/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.task.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.service.IAgentContactApiService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.agent.api.vo.AgentContactApiVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.core.competitor.dao.CompetitorMapper;
import com.jxdinfo.crm.core.competitor.model.Competitor;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.contact.dao.ContactMapper;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.fileinfo.dto.FileInfoDto;
import com.jxdinfo.crm.core.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.marketingactivity.dao.MarketingActivityMapper;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.product.dao.ProductMapper;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.task.dao.TaskMapper;
import com.jxdinfo.crm.core.task.dto.TaskDto;
import com.jxdinfo.crm.core.task.model.TaskEntity;
import com.jxdinfo.crm.core.task.model.TaskPersonEntity;
import com.jxdinfo.crm.core.task.service.TaskPersonService;
import com.jxdinfo.crm.core.task.service.TaskService;
import com.jxdinfo.crm.core.task.vo.TaskEntityVo;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.marketing.api.wallchart.service.IWallchartAPIService;
import com.jxdinfo.crm.marketing.api.wallchart.vo.WallchartAPIVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TaskServiceImpl
extends ServiceImpl<TaskMapper, TaskEntity>
implements TaskService {
    @Resource
    private FileInfoService fileInfoService;
    @Resource
    private TaskPersonService taskPersonService;
    @Resource
    private TaskMapper taskMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private ContactMapper contactMapper;
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private MarketingActivityMapper marketingActivityMapper;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private CompetitorMapper competitorMapper;
    @Resource
    private ProductMapper productMapper;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private IWallchartAPIService wallchartAPIService;
    @Resource
    private IAgentApiService agentApiService;
    @Resource
    private IAgentContactApiService agentContactApiService;

    @Override
    public Page<TaskEntity> getTaskPage(TaskDto taskDto) {
        taskDto.setDelFlag("0");
        Page page = taskDto.getPage();
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        taskDto.setCurrentTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        SecurityUser user = BaseSecurityUtil.getUser();
        taskDto.setPersonId(user.getUserId());
        List<TaskEntity> list = this.taskMapper.queryTaskList((Page<TaskEntity>)page, taskDto, permissionDto);
        if (CollectionUtil.isNotEmpty(list)) {
            for (TaskEntity taskEntity : list) {
                WallchartAPIVo wallchartAPIVo;
                if (HussarUtils.isEmpty((Object)taskEntity.getBusinessId())) continue;
                if (CrmBusinessTypeEnum.CUSTOMER.getId().equals(taskEntity.getBusinessType())) {
                    CustomerEntity customer = (CustomerEntity)this.customerMapper.selectById(taskEntity.getBusinessId());
                    if (!ToolUtil.isNotEmpty((Object)customer)) continue;
                    taskEntity.setBusinessName(customer.getCustomerName());
                    continue;
                }
                if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(taskEntity.getBusinessType())) {
                    OpportunityEntity opportunity = (OpportunityEntity)this.opportunityMapper.selectById(taskEntity.getBusinessId());
                    if (!ToolUtil.isNotEmpty((Object)opportunity)) continue;
                    taskEntity.setBusinessName(opportunity.getOpportunityName());
                    continue;
                }
                if (CrmBusinessTypeEnum.CONTACT.getId().equals(taskEntity.getBusinessType())) {
                    ContactEntity contact = (ContactEntity)this.contactMapper.selectById(taskEntity.getBusinessId());
                    if (!ToolUtil.isNotEmpty((Object)contact)) continue;
                    taskEntity.setBusinessName(contact.getContactName());
                    continue;
                }
                if (CrmBusinessTypeEnum.LEADS.getId().equals(taskEntity.getBusinessType())) {
                    Leads leads = (Leads)this.leadsMapper.selectById(taskEntity.getBusinessId());
                    if (!ToolUtil.isNotEmpty((Object)leads)) continue;
                    taskEntity.setBusinessName(leads.getLeadsName());
                    continue;
                }
                if (CrmBusinessTypeEnum.CAMPAIGN.getId().equals(taskEntity.getBusinessType())) {
                    MarketingActivityEntity marketingActivity = (MarketingActivityEntity)this.marketingActivityMapper.selectById(taskEntity.getBusinessId());
                    if (!ToolUtil.isNotEmpty((Object)marketingActivity)) continue;
                    taskEntity.setBusinessName(marketingActivity.getCampaignName());
                    continue;
                }
                if (CrmBusinessTypeEnum.COMPETITOR.getId().equals(taskEntity.getBusinessType())) {
                    Competitor competitor = (Competitor)this.competitorMapper.selectById(taskEntity.getBusinessId());
                    if (!ToolUtil.isNotEmpty((Object)competitor)) continue;
                    taskEntity.setBusinessName(competitor.getCompetitorName());
                    continue;
                }
                if (CrmBusinessTypeEnum.PRODUCT.getId().equals(taskEntity.getBusinessType())) {
                    Product product = (Product)this.productMapper.selectById(taskEntity.getBusinessId());
                    if (!ToolUtil.isNotEmpty((Object)product)) continue;
                    taskEntity.setBusinessName(product.getProductName());
                    continue;
                }
                if (CrmBusinessTypeEnum.AGENT.getId().equals(taskEntity.getBusinessType())) {
                    AgentApiVo agent = this.agentApiService.getById((Serializable)taskEntity.getBusinessId());
                    if (!ToolUtil.isNotEmpty((Object)agent)) continue;
                    taskEntity.setBusinessName(agent.getAgentName());
                    continue;
                }
                if (CrmBusinessTypeEnum.AGENT_CONTACT.getId().equals(taskEntity.getBusinessType())) {
                    AgentContactApiVo agentContact = this.agentContactApiService.getById((Serializable)taskEntity.getBusinessId());
                    if (ToolUtil.isNotEmpty((Object)agentContact)) {
                        taskEntity.setBusinessName(agentContact.getAgentContactName());
                    }
                    taskEntity.setBusinessName(((Product)this.productMapper.selectById(taskEntity.getBusinessId())).getProductName());
                    continue;
                }
                if (!CrmBusinessTypeEnum.WALLCHART.getId().equals(taskEntity.getBusinessType()) || !HussarUtils.isNotEmpty((Object)(wallchartAPIVo = this.wallchartAPIService.selectWallchartById(taskEntity.getBusinessId())))) continue;
                taskEntity.setBusinessName(wallchartAPIVo.getWallchartName());
            }
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public TaskEntityVo taskListSum(TaskDto taskDto) {
        TaskEntityVo taskEntityVo = new TaskEntityVo();
        taskDto.setDelFlag("0");
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        taskDto.setCurrentTime(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        SecurityUser user = BaseSecurityUtil.getUser();
        taskDto.setPersonId(user.getUserId());
        taskEntityVo.setTaskCount(this.taskMapper.taskListSum(taskDto, permissionDto));
        taskDto.setState("2");
        taskEntityVo.setTaskFinish(this.taskMapper.taskListSum(taskDto, permissionDto));
        return taskEntityVo;
    }

    @Override
    public TaskEntity getTaskById(String taskId) {
        String currentTime = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        TaskEntity taskEntity = this.taskMapper.getTaskById(Long.valueOf(taskId), currentTime);
        if (taskEntity != null) {
            AgentContactApiVo agentContact;
            if (CrmBusinessTypeEnum.CUSTOMER.getId().equals(taskEntity.getBusinessType())) {
                CustomerEntity customer = (CustomerEntity)this.customerMapper.selectById(taskEntity.getBusinessId());
                if (ToolUtil.isNotEmpty((Object)customer)) {
                    taskEntity.setBusinessName(customer.getCustomerName());
                }
            } else if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(taskEntity.getBusinessType())) {
                OpportunityEntity opportunity = (OpportunityEntity)this.opportunityMapper.selectById(taskEntity.getBusinessId());
                if (ToolUtil.isNotEmpty((Object)opportunity)) {
                    taskEntity.setBusinessName(opportunity.getOpportunityName());
                }
            } else if (CrmBusinessTypeEnum.CONTACT.getId().equals(taskEntity.getBusinessType())) {
                ContactEntity contact = (ContactEntity)this.contactMapper.selectById(taskEntity.getBusinessId());
                if (ToolUtil.isNotEmpty((Object)contact)) {
                    taskEntity.setBusinessName(contact.getContactName());
                }
            } else if (CrmBusinessTypeEnum.LEADS.getId().equals(taskEntity.getBusinessType())) {
                Leads leads = (Leads)this.leadsMapper.selectById(taskEntity.getBusinessId());
                if (ToolUtil.isNotEmpty((Object)leads)) {
                    taskEntity.setBusinessName(leads.getLeadsName());
                }
            } else if (CrmBusinessTypeEnum.CAMPAIGN.getId().equals(taskEntity.getBusinessType())) {
                MarketingActivityEntity marketingActivity = (MarketingActivityEntity)this.marketingActivityMapper.selectById(taskEntity.getBusinessId());
                if (ToolUtil.isNotEmpty((Object)marketingActivity)) {
                    taskEntity.setBusinessName(marketingActivity.getCampaignName());
                }
            } else if (CrmBusinessTypeEnum.COMPETITOR.getId().equals(taskEntity.getBusinessType())) {
                Competitor competitor = (Competitor)this.competitorMapper.selectById(taskEntity.getBusinessId());
                if (ToolUtil.isNotEmpty((Object)competitor)) {
                    taskEntity.setBusinessName(competitor.getCompetitorName());
                }
            } else if (CrmBusinessTypeEnum.PRODUCT.getId().equals(taskEntity.getBusinessType())) {
                Product product = (Product)this.productMapper.selectById(taskEntity.getBusinessId());
                if (ToolUtil.isNotEmpty((Object)product)) {
                    taskEntity.setBusinessName(product.getProductName());
                }
                taskEntity.setBusinessName(((Product)this.productMapper.selectById(taskEntity.getBusinessId())).getProductName());
            } else if (CrmBusinessTypeEnum.WALLCHART.getId().equals(taskEntity.getBusinessType())) {
                WallchartAPIVo wallchartAPIVo = this.wallchartAPIService.selectWallchartById(taskEntity.getBusinessId());
                if (HussarUtils.isNotEmpty((Object)wallchartAPIVo)) {
                    taskEntity.setBusinessName(wallchartAPIVo.getWallchartName());
                }
            } else if (CrmBusinessTypeEnum.AGENT.getId().equals(taskEntity.getBusinessType())) {
                AgentApiVo agent = this.agentApiService.getById((Serializable)taskEntity.getBusinessId());
                if (ToolUtil.isNotEmpty((Object)agent)) {
                    taskEntity.setBusinessName(agent.getAgentName());
                }
            } else if (CrmBusinessTypeEnum.AGENT_CONTACT.getId().equals(taskEntity.getBusinessType()) && ToolUtil.isNotEmpty((Object)(agentContact = this.agentContactApiService.getById((Serializable)taskEntity.getBusinessId())))) {
                taskEntity.setBusinessName(agentContact.getAgentContactName());
            }
        }
        return taskEntity;
    }

    @Override
    @Transactional
    public Boolean addTask(TaskEntity entity) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long taskId = Long.valueOf(CommonUtills.generateAssignId());
        entity.setTaskId(taskId);
        if (HussarUtils.isEmpty((Object)entity.getBusinessId())) {
            entity.setBusinessType(null);
        }
        entity.setState("1");
        if (CollectionUtil.isNotEmpty(entity.getFileIds())) {
            FileInfoDto fileInfoDto = new FileInfoDto();
            fileInfoDto.setBusinessId(String.valueOf(taskId));
            fileInfoDto.setIds(entity.getFileIds());
            this.fileInfoService.insertFileInfo(fileInfoDto);
        }
        entity.setCreatePerson(user.getUserId());
        entity.setCreatePersonName(user.getUserName());
        entity.setCreateTime(date);
        entity.setChangePerson(user.getUserId());
        entity.setChangePersonName(user.getUserName());
        entity.setChangeTime(date);
        if (entity.getChargePerson() != null) {
            entity.setChargePerson(CommonUtills.translateUserId(entity.getChargePerson()));
        }
        entity.setOwnDepartment(user.getDeptId());
        entity.setOwnDepartmentName(user.getDeptName());
        entity.setDelFlag("0");
        if (CollectionUtil.isNotEmpty(entity.getPersonList())) {
            for (TaskPersonEntity personEntity : entity.getPersonList()) {
                personEntity.setDataStatus("0");
                personEntity.setPersonId(CommonUtills.translateUserId(personEntity.getPersonId()));
                personEntity.setTaskId(taskId);
            }
            this.taskPersonService.saveBatch(entity.getPersonList());
        }
        if ("2".equals(entity.getBusinessType())) {
            this.opportunityService.updateChangeTime(HussarUtils.toStr((Object)entity.getBusinessId()));
        }
        this.save(entity);
        if (ToolUtil.isNotEmpty((Object)entity.getBusinessId())) {
            this.saveTrackRecord(entity, date, "1", null);
        }
        try {
            this.sendMessage(entity, "1", null, user, date);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    @Transactional
    public Boolean updateTask(TaskEntity entity) {
        if ("2".equals(entity.getBusinessType())) {
            this.opportunityService.updateChangeTime(HussarUtils.toStr((Object)entity.getBusinessId()));
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        entity.setChangePerson(user.getUserId());
        entity.setChangePersonName(user.getUserName());
        entity.setChangeTime(date);
        ArrayList<String> receiverList = new ArrayList<String>();
        TaskEntity oldTaskEntity = this.getTaskById(String.valueOf(entity.getTaskId()));
        if (!oldTaskEntity.getLastTime().equals(entity.getLastTime()) || !oldTaskEntity.getContent().equals(entity.getContent())) {
            this.trackRecordAPIService.updateTrackRecord(entity.getLastTime(), entity.getContent(), entity.getTaskId(), "0", "1");
        }
        if ("2".equals(entity.getState())) {
            receiverList.add(oldTaskEntity.getCreatePerson().toString());
            oldTaskEntity.setFinishDetail(entity.getFinishDetail());
            if (ToolUtil.isNotEmpty((Object)entity.getBusinessId())) {
                this.saveTrackRecord(oldTaskEntity, date, "3", null);
            }
        } else {
            if ("3".equals(entity.getState())) {
                entity.setState("3");
                this.updateById(entity);
                return true;
            }
            if (entity.getChargePerson() != null) {
                entity.setChargePerson(CommonUtills.translateUserId(entity.getChargePerson()));
            }
            if (entity.getFileIds() != null) {
                FileInfoDto fileInfoDto = new FileInfoDto();
                fileInfoDto.setBusinessId(String.valueOf(entity.getTaskId()));
                fileInfoDto.setIds(entity.getFileIds());
                this.fileInfoService.insertFileInfo(fileInfoDto);
            }
            List oldPersonList = this.taskPersonService.list((Wrapper)new LambdaQueryWrapper().eq(TaskPersonEntity::getTaskId, (Object)entity.getTaskId()));
            this.taskPersonService.remove((Wrapper)new LambdaQueryWrapper().eq(TaskPersonEntity::getTaskId, (Object)entity.getTaskId()));
            if (CollectionUtil.isNotEmpty(entity.getPersonList())) {
                for (TaskPersonEntity personEntity : entity.getPersonList()) {
                    personEntity.setDataStatus("0");
                    personEntity.setPersonId(CommonUtills.translateUserId(personEntity.getPersonId()));
                    personEntity.setTaskId(entity.getTaskId());
                }
                this.taskPersonService.saveBatch(entity.getPersonList());
            }
            if (ToolUtil.isNotEmpty((Object)entity.getBusinessId())) {
                this.saveTrackRecord(entity, date, "2", oldTaskEntity);
            }
            if (StringUtil.isNotBlank((CharSequence)entity.getChargePerson()) && !entity.getChargePerson().equals(oldTaskEntity.getChargePerson())) {
                receiverList.add(entity.getChargePerson());
            }
            if (CollectionUtil.isNotEmpty(entity.getPersonList())) {
                ArrayList<String> oldPersonIdList = new ArrayList<String>();
                if (CollectionUtil.isNotEmpty((Collection)oldPersonList)) {
                    for (TaskPersonEntity personEntity : oldPersonList) {
                        oldPersonIdList.add(personEntity.getPersonId());
                    }
                }
                for (TaskPersonEntity personEntity : entity.getPersonList()) {
                    if (CollectionUtil.isNotEmpty(oldPersonIdList) && !oldPersonIdList.contains(personEntity.getPersonId()) && !receiverList.contains(personEntity.getPersonId())) {
                        receiverList.add(personEntity.getPersonId());
                        continue;
                    }
                    if (!CollectionUtil.isEmpty(oldPersonIdList) || receiverList.contains(personEntity.getPersonId())) continue;
                    receiverList.add(personEntity.getPersonId());
                }
            }
        }
        try {
            if ("2".equals(entity.getState())) {
                this.sendMessage(oldTaskEntity, "3", Collections.singletonList(oldTaskEntity.getCreatePerson().toString()), user, date);
            } else if (!"3".equals(entity.getState()) && CollectionUtil.isNotEmpty(receiverList)) {
                this.sendMessage(entity, "2", receiverList, user, date);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateById(entity);
        return true;
    }

    @Override
    @Transactional
    public Boolean deleteTask(Long taskId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        TaskEntity entity = (TaskEntity)this.getById(taskId);
        if ("2".equals(entity.getBusinessType())) {
            this.opportunityService.updateChangeTime(HussarUtils.toStr((Object)entity.getBusinessId()));
        }
        entity.setDelFlag("1");
        entity.setChangePerson(user.getUserId());
        entity.setChangePersonName(user.getUserName());
        entity.setChangeTime(date);
        this.updateById(entity);
        return true;
    }

    private void sendMessage(TaskEntity entity, String type, List<String> receiverList, SecurityUser user, LocalDateTime date) {
        String title = "";
        String content = "";
        String contentUnify = "";
        String userName = user.getUserName();
        String entryContent = entity.getContent();
        String lastTime = DateTimeUtil.DATETIME_FORMAT.format(entity.getLastTime());
        List<String> receiverIds = new ArrayList<String>();
        if ("1".equals(type)) {
            title = user.getUserName() + "\u5206\u914d\u4e86\u4e00\u6761\u4efb\u52a1\u7ed9\u60a8\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
            content = "\u4efb\u52a1\u63cf\u8ff0\uff1a" + entryContent + "\n\u622a\u6b62\u65f6\u95f4\uff1a" + lastTime;
            contentUnify = "\u3010\u4efb\u52a1\u63d0\u9192\u3011" + userName + "\u5206\u914d\u4e86\u4e00\u6761\u4efb\u52a1\u7ed9\u4f60\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u4efb\u52a1\u63cf\u8ff0\uff1a" + entryContent + "\u3002\u622a\u6b62\u65f6\u95f4\uff1a" + lastTime + "\u3002";
            receiverIds.add(entity.getChargePerson());
            if (CollectionUtil.isNotEmpty(entity.getPersonList())) {
                for (TaskPersonEntity personEntity : entity.getPersonList()) {
                    receiverIds.add(personEntity.getPersonId());
                }
            }
        } else if ("2".equals(type)) {
            title = user.getUserName() + "\u5206\u914d\u4e86\u4e00\u6761\u4efb\u52a1\u7ed9\u60a8\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002";
            content = "\u4efb\u52a1\u63cf\u8ff0\uff1a" + entryContent + "\n\u622a\u6b62\u65f6\u95f4\uff1a" + lastTime;
            contentUnify = "\u3010\u4efb\u52a1\u63d0\u9192\u3011" + userName + "\u5206\u914d\u4e86\u4e00\u6761\u4efb\u52a1\u7ed9\u4f60\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002\u4efb\u52a1\u63cf\u8ff0\uff1a" + entryContent + "\u3002\u622a\u6b62\u65f6\u95f4\uff1a" + lastTime + "\u3002";
            receiverIds = receiverList;
        } else if ("3".equals(type)) {
            title = "\u60a8\u5206\u914d\u7684\u4efb\u52a1\u5df2\u5b8c\u6210\uff0c\u8bf7\u60a8\u53ca\u65f6\u4e86\u89e3\u5b8c\u6210\u60c5\u51b5\u3002";
            content = "\u4efb\u52a1\u63cf\u8ff0\uff1a" + entryContent + "\n\u5b8c\u6210\u4eba\uff1a" + user.getUserName();
            contentUnify = "\u3010\u4efb\u52a1\u63d0\u9192\u3011\u60a8\u5206\u914d\u7684\u4efb\u52a1\uff0c" + userName + "\u5df2\u5b8c\u6210\uff0c\u8bf7\u77e5\u6089\u3002\u4efb\u52a1\u63cf\u8ff0\uff1a" + entryContent + "\u3002";
            receiverIds = receiverList;
        }
        String url = "/crm/rw/rwxq";
        if (CollectionUtil.isNotEmpty(receiverIds)) {
            EimPushUtil.pushJqxArticleMessage(title, content, url, entity.getTaskId().toString(), receiverIds);
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String userIdToString = StringUtil.join(receiverIds, (String)",");
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/rw/todoTask";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
        }
    }

    private void saveTrackRecord(TaskEntity entity, LocalDateTime dateTime, String type, TaskEntity oldEntity) {
        CustomerEntity customer;
        ArrayList<Long> typeIds = new ArrayList<Long>();
        typeIds.add(entity.getTaskId());
        typeIds.add(entity.getBusinessId());
        if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(entity.getBusinessType())) {
            OpportunityEntity opportunityEntity = (OpportunityEntity)this.opportunityMapper.selectById(entity.getBusinessId());
            typeIds.add(opportunityEntity.getCustomerId());
            customer = new CustomerEntity();
            customer.setCustomerId(opportunityEntity.getCustomerId());
            customer.setTrackTime(dateTime);
            this.customerMapper.updateById(customer);
        } else if (CrmBusinessTypeEnum.CONTACT.getId().equals(entity.getBusinessType())) {
            ContactEntity contactEntity = (ContactEntity)this.contactMapper.selectById(entity.getBusinessId());
            typeIds.add(contactEntity.getCustomerId());
            customer = new CustomerEntity();
            customer.setCustomerId(contactEntity.getCustomerId());
            customer.setTrackTime(dateTime);
            this.customerMapper.updateById(customer);
        }
        TrackRecordAPIVo trackRecord = new TrackRecordAPIVo();
        trackRecord.setState(type);
        if ("1".equals(type)) {
            trackRecord.setTaskContent(entity.getContent());
            trackRecord.setTaskChargePerson(Long.valueOf(entity.getChargePerson()));
            trackRecord.setTaskChargePersonName(entity.getChargePersonName());
            trackRecord.setTaskLastTime(entity.getLastTime());
        } else if ("2".equals(type)) {
            boolean updateFlag = false;
            if (entity.getChargePerson() != null && !entity.getChargePerson().equals(oldEntity.getChargePerson())) {
                trackRecord.setTaskChargePerson(Long.valueOf(entity.getChargePerson()));
                trackRecord.setTaskChargePersonName(entity.getChargePersonName());
                updateFlag = true;
            }
            if (entity.getLastTime() != null && !DateTimeUtil.DATETIME_FORMAT.format(entity.getLastTime()).equals(DateTimeUtil.DATETIME_FORMAT.format(oldEntity.getLastTime()))) {
                trackRecord.setTaskLastTime(entity.getLastTime());
                updateFlag = true;
            }
            if (!updateFlag) {
                return;
            }
            trackRecord.setTaskContent(oldEntity.getContent());
        } else if ("3".equals(type)) {
            trackRecord.setTaskContent(entity.getContent());
            trackRecord.setTaskFinishDetail(entity.getFinishDetail());
        }
        this.trackRecordAPIService.saveTrackRecord(trackRecord, CrmBusinessTypeEnum.TASK, entity.getTaskId(), null, dateTime, false, typeIds);
        if (CrmBusinessTypeEnum.CUSTOMER.getId().equals(entity.getBusinessType())) {
            CustomerEntity customer2 = new CustomerEntity();
            customer2.setCustomerId(entity.getBusinessId());
            customer2.setTrackTime(dateTime);
            this.customerMapper.updateById(customer2);
        } else if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(entity.getBusinessType())) {
            OpportunityEntity opportunity = new OpportunityEntity();
            opportunity.setOpportunityId(entity.getBusinessId());
            opportunity.setTrackTime(dateTime);
            this.opportunityMapper.updateById(opportunity);
        } else if (CrmBusinessTypeEnum.CONTACT.getId().equals(entity.getBusinessType())) {
            ContactEntity contact = new ContactEntity();
            contact.setContactId(entity.getBusinessId());
            contact.setTrackTime(dateTime);
            this.contactMapper.updateById(contact);
        } else if (CrmBusinessTypeEnum.LEADS.getId().equals(entity.getBusinessType())) {
            Leads leads = new Leads();
            leads.setLeadsId(entity.getBusinessId());
            leads.setTrackTime(dateTime);
            this.leadsMapper.updateById(leads);
        } else if (CrmBusinessTypeEnum.CAMPAIGN.getId().equals(entity.getBusinessType())) {
            MarketingActivityEntity marketingActivity = new MarketingActivityEntity();
            marketingActivity.setCampaignId(entity.getBusinessId());
            marketingActivity.setTrackTime(dateTime);
            this.marketingActivityMapper.updateById(marketingActivity);
        } else if (CrmBusinessTypeEnum.COMPETITOR.getId().equals(entity.getBusinessType())) {
            Competitor competitor = new Competitor();
            competitor.setCompetitorId(entity.getBusinessId());
            competitor.setTrackTime(dateTime);
            this.competitorMapper.updateById(competitor);
        }
    }
}

