/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.dto.CrmSceneDto;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.scene.model.CrmSceneUser;
import com.jxdinfo.crm.core.scene.service.CrmSceneService;
import com.jxdinfo.crm.core.scene.service.CrmSceneUserService;
import com.jxdinfo.crm.core.scene.vo.CrmSceneVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrmSceneServiceImpl
extends ServiceImpl<CrmSceneMapper, CrmScene>
implements CrmSceneService {
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private CrmSceneUserService crmSceneUserService;
    @Resource
    private CommonService commonService;
    @Resource
    private CrmCommonProperties crmProperties;

    @Override
    @Transactional
    public Long saveScene(CrmSceneDto dto) {
        if (dto == null) {
            return -1L;
        }
        String module = dto.getModule();
        if (StringUtil.isEmpty((Object)module)) {
            return -1L;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        int maxOrder = 0;
        List<Integer> maxOrderList = this.crmSceneMapper.selectMaxShowOrder(userId, module);
        if (CollectionUtil.isNotEmpty(maxOrderList)) {
            maxOrder = maxOrderList.get(0) + 1;
        }
        if ("1".equals(dto.getIsDefault())) {
            this.crmSceneMapper.updateDefault(userId, module);
        }
        CrmScene crmScene = new CrmScene();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)crmScene));
        int isSuccess = this.crmSceneMapper.insert((Object)crmScene);
        crmScene.setSceneId(crmScene.getScId());
        this.crmSceneMapper.updateById((Object)crmScene);
        if (isSuccess > 0) {
            CrmSceneUser crmSceneUser = new CrmSceneUser();
            crmSceneUser.setSceneId(crmScene.getSceneId());
            crmSceneUser.setModule(module);
            crmSceneUser.setIsDefault(dto.getIsDefault());
            crmSceneUser.setSceneOwner(userId);
            crmSceneUser.setShowOrder(maxOrder);
            this.crmSceneUserService.save((Object)crmSceneUser);
            return crmScene.getSceneId();
        }
        return -1L;
    }

    @Override
    public Boolean updateScene(CrmSceneDto dto) {
        if (dto == null || StringUtil.isEmpty((Object)dto.getScId())) {
            return false;
        }
        long sceneId = Long.parseLong(dto.getScId());
        if (sceneId <= 0L) {
            return false;
        }
        CrmScene oldCrmScene = (CrmScene)((Object)this.crmSceneMapper.selectById(Long.valueOf(sceneId)));
        if (oldCrmScene != null) {
            if ("1".equals(oldCrmScene.getIsSystem())) {
                throw new HussarException("\u7cfb\u7edf\u5185\u7f6e\u573a\u666f\u4e0d\u53ef\u4fee\u6539");
            }
            SecurityUser user = BaseSecurityUtil.getUser();
            if (!user.getUserId().equals(oldCrmScene.getCreator())) {
                throw new HussarException("\u53ea\u53ef\u4ee5\u4fee\u6539\u81ea\u5df1\u521b\u5efa\u7684\u573a\u666f");
            }
        }
        CrmScene crmScene = new CrmScene();
        BeanUtils.copyProperties((Object)dto, (Object)((Object)crmScene));
        crmScene.setSceneId(Long.parseLong(dto.getSceneId()));
        crmScene.setScId(Long.parseLong(dto.getScId()));
        int isSuccess = this.crmSceneMapper.updateById((Object)crmScene);
        return isSuccess > 0;
    }

    @Override
    public CrmSceneVo selectById(Long sceneId) throws HussarException {
        if (sceneId == null || sceneId <= 0L) {
            throw new HussarException("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        CrmScene crmScene = (CrmScene)((Object)this.crmSceneMapper.selectById(sceneId));
        if (crmScene != null) {
            CrmSceneVo crmSceneVo = new CrmSceneVo();
            BeanUtils.copyProperties((Object)((Object)crmScene), (Object)crmSceneVo);
            crmSceneVo.setScId(crmScene.getScId().toString());
            crmSceneVo.setSceneId(crmScene.getSceneId().toString());
            return crmSceneVo;
        }
        return null;
    }

    @Override
    public Boolean removeSceneById(CrmSceneDto dto) {
        int isSuccess;
        if (dto == null || StringUtil.isEmpty((Object)dto.getScId()) || StringUtil.isEmpty((Object)dto.getSceneId())) {
            throw new HussarException("\u8bf7\u6c42\u53c2\u6570\u9519\u8bef");
        }
        long scId = Long.parseLong(dto.getScId());
        long sceneId = Long.parseLong(dto.getSceneId());
        CrmScene oldCrmScene = (CrmScene)((Object)this.crmSceneMapper.selectById(Long.valueOf(scId)));
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        if (oldCrmScene != null) {
            if ("1".equals(oldCrmScene.getIsSystem())) {
                throw new HussarException("\u7cfb\u7edf\u5185\u7f6e\u573a\u666f\u4e0d\u53ef\u5220\u9664");
            }
            if (!userId.equals(oldCrmScene.getCreator())) {
                throw new HussarException("\u53ea\u53ef\u4ee5\u5220\u9664\u81ea\u5df1\u521b\u5efa\u7684\u573a\u666f");
            }
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(CrmSceneUser::getSceneId, (Object)sceneId);
        lambdaQueryWrapper.eq(CrmSceneUser::getSceneOwner, (Object)userId);
        CrmSceneUser crmSceneUser = (CrmSceneUser)((Object)this.crmSceneUserService.getOne((Wrapper)lambdaQueryWrapper));
        if (crmSceneUser != null) {
            if ("1".equals(crmSceneUser.getIsDefault())) {
                throw new HussarException("\u9ed8\u8ba4\u573a\u666f\u4e0d\u53ef\u4ee5\u5220\u9664");
            }
            this.crmSceneUserService.removeById(crmSceneUser.getSceneUserId());
        }
        return (isSuccess = this.crmSceneMapper.deleteById(Long.valueOf(scId))) > 0;
    }

    @Override
    public List<CrmSceneVo> getSceneList(String module) {
        Long userId;
        List<CrmSceneVo> crmSceneVoList;
        SecurityUser user = BaseSecurityUtil.getUser();
        Integer sales = this.commonService.isSales();
        int contansAll = 0;
        if ("contact".equals(module)) {
            if (user.getRolesList().contains(Long.parseLong(this.crmProperties.getRoles().getAllContact()))) {
                contansAll = 1;
            }
        } else if (user.getRolesList().contains(Long.parseLong(this.crmProperties.getRoles().getMarketingManager())) || sales != null && sales >= 2) {
            contansAll = 1;
        }
        if (CollectionUtil.isNotEmpty(crmSceneVoList = this.crmSceneMapper.selectByUser(userId = user.getUserId(), module, contansAll))) {
            List<CrmSceneUser> sceneIdList = this.crmSceneMapper.selectInsertSceneByUser(userId, module, contansAll);
            if (CollectionUtil.isNotEmpty(sceneIdList)) {
                ArrayList<CrmSceneUser> crmSceneUserList = new ArrayList<CrmSceneUser>();
                for (CrmSceneUser crmSceneUser : sceneIdList) {
                    crmSceneUser.setSceneOwner(userId);
                    crmSceneUser.setIsDefault("0");
                    crmSceneUserList.add(crmSceneUser);
                }
                this.crmSceneUserService.saveBatch(crmSceneUserList);
                return this.crmSceneMapper.selectByUser(userId, module, contansAll);
            }
            return crmSceneVoList;
        }
        List<CrmSceneVo> sysCrmSceneVoList = this.crmSceneMapper.selectByUser(1L, module, contansAll);
        if (CollectionUtil.isEmpty(sysCrmSceneVoList)) {
            return null;
        }
        ArrayList<CrmSceneDto> crmSceneDtoList = new ArrayList<CrmSceneDto>();
        for (CrmSceneVo crmSceneVo : sysCrmSceneVoList) {
            CrmSceneDto crmSceneDto = new CrmSceneDto();
            BeanUtils.copyProperties((Object)crmSceneVo, (Object)crmSceneDto);
            crmSceneDtoList.add(crmSceneDto);
        }
        this.updateSceneUser(crmSceneDtoList, userId);
        return sysCrmSceneVoList;
    }

    @Override
    public Boolean updateDefault(CrmSceneDto crmSceneDto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String module = crmSceneDto.getModule();
        Long sceneId = Long.parseLong(crmSceneDto.getSceneId());
        this.crmSceneMapper.updateDefault(userId, module);
        int isSuccess = this.crmSceneMapper.setDefault(userId, sceneId, module);
        return isSuccess > 0;
    }

    @Override
    public Boolean updateOrder(List<CrmSceneDto> dtoList) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        if (CollectionUtil.isEmpty(dtoList)) {
            return false;
        }
        int isSuccess = this.crmSceneMapper.updateShowOrderBatche(dtoList, userId);
        if (isSuccess < 1) {
            return this.updateSceneUser(dtoList, userId);
        }
        return false;
    }

    private Boolean updateSceneUser(List<CrmSceneDto> dtoList, Long userId) {
        ArrayList<CrmSceneUser> crmSceneUserList = new ArrayList<CrmSceneUser>();
        for (CrmSceneDto crmSceneDto : dtoList) {
            String module = crmSceneDto.getModule();
            if (StringUtil.isEmpty((Object)module)) {
                return false;
            }
            CrmSceneUser crmSceneUser = new CrmSceneUser();
            crmSceneUser.setSceneId(Long.parseLong(crmSceneDto.getSceneId()));
            crmSceneUser.setSceneOwner(userId);
            crmSceneUser.setIsDefault(crmSceneDto.getIsDefault());
            crmSceneUser.setShowOrder(crmSceneDto.getShowOrder());
            crmSceneUser.setModule(module);
            crmSceneUserList.add(crmSceneUser);
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(CrmSceneUser::getModule, (Object)dtoList.get(0).getModule());
        lambdaQueryWrapper.eq(CrmSceneUser::getSceneOwner, (Object)userId);
        this.crmSceneUserService.remove((Wrapper)lambdaQueryWrapper);
        return this.crmSceneUserService.saveBatch(crmSceneUserList);
    }
}

