/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.core.api.opportunity.dto.StageRecordDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunitySuccessRateAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityConversionVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStageSuccessRate;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunitySuccessRateStageVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunitySuccessRateVo;
import com.jxdinfo.crm.core.api.opportunity.vo.SuccessRateVo;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.OpportunitySuccessRate;
import com.jxdinfo.crm.core.opportunity.service.IOpportunitySuccessRateService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.impl.StageProcessServiceImpl;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunitySuccessRateAPIServiceImpl
implements IOpportunitySuccessRateAPIService {
    @Resource
    private IOpportunitySuccessRateService opportunitySuccessRateService;
    @Resource
    private StageProcessServiceImpl stageProcessService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;

    public List<SuccessRateVo> getSuccessRate(List<Long> productIdList, List<Long> stageIds) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (CollectionUtil.isNotEmpty(stageIds)) {
            lambdaQueryWrapper.in(OpportunitySuccessRate::getStageId, stageIds);
        }
        if (CollectionUtil.isNotEmpty(productIdList)) {
            lambdaQueryWrapper.in(OpportunitySuccessRate::getProductId, productIdList);
        } else {
            lambdaQueryWrapper.isNull(OpportunitySuccessRate::getProductId);
        }
        List opportunitySuccessRateList = this.opportunitySuccessRateService.list((Wrapper)lambdaQueryWrapper);
        return BeanUtil.copyProperties((Collection)opportunitySuccessRateList, SuccessRateVo.class);
    }

    public List<SuccessRateVo> getAllSuccessRate() {
        List opportunitySuccessRateList = this.opportunitySuccessRateService.list();
        return BeanUtil.copyProperties((Collection)opportunitySuccessRateList, SuccessRateVo.class);
    }

    public List<SuccessRateVo> getSuccessRateByProduct(List<Long> productIdList, List<Long> stageIds) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (CollectionUtil.isNotEmpty(stageIds)) {
            lambdaQueryWrapper.in(OpportunitySuccessRate::getStageId, stageIds);
        }
        if (CollectionUtil.isNotEmpty(productIdList)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.in(OpportunitySuccessRate::getProductId, productIdList)).or()).isNull(OpportunitySuccessRate::getProductId);
        } else {
            lambdaQueryWrapper.isNull(OpportunitySuccessRate::getProductId);
        }
        List opportunitySuccessRateList = this.opportunitySuccessRateService.list((Wrapper)lambdaQueryWrapper);
        return BeanUtil.copyProperties((Collection)opportunitySuccessRateList, SuccessRateVo.class);
    }

    public List<OpportunitySuccessRateVo> getOpportunitySuccess(List<Long> productIdList) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (CollectionUtil.isNotEmpty(productIdList)) {
            lambdaQueryWrapper.in(OpportunitySuccessRate::getProductId, productIdList);
        } else {
            lambdaQueryWrapper.isNull(OpportunitySuccessRate::getProductId);
        }
        List opportunitySuccessRateList = this.opportunitySuccessRateService.list((Wrapper)lambdaQueryWrapper);
        ArrayList<OpportunitySuccessRateVo> opportunitySuccessRateVoList = new ArrayList<OpportunitySuccessRateVo>();
        if (CollectionUtil.isNotEmpty((Collection)opportunitySuccessRateList)) {
            if (CollectionUtil.isNotEmpty(productIdList)) {
                Map<Long, List<OpportunitySuccessRate>> productSuccessRateVoListMap = opportunitySuccessRateList.stream().collect(Collectors.groupingBy(OpportunitySuccessRate::getProductId));
                for (Long productId : productIdList) {
                    List<OpportunitySuccessRate> productSuccessRateList = productSuccessRateVoListMap.get(productId);
                    if (!CollectionUtil.isNotEmpty(productSuccessRateList)) continue;
                    opportunitySuccessRateVoList.add(this.convertToVo(productSuccessRateList));
                }
            } else {
                OpportunitySuccessRateVo opportunitySuccessRateVo = this.convertToVo(opportunitySuccessRateList);
                opportunitySuccessRateVo.setProductName(null);
                opportunitySuccessRateVo.setProductId(null);
                opportunitySuccessRateVoList.add(opportunitySuccessRateVo);
            }
        }
        return opportunitySuccessRateVoList;
    }

    public List<OpportunitySuccessRateStageVo> getOpportunitySuccessStage(List<Long> productIdList, List<Long> customerStageIds, List<Long> stageProcessIds) {
        ArrayList resultList = new ArrayList();
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        if (CollectionUtil.isNotEmpty(customerStageIds)) {
            lambdaQueryWrapper.in(OpportunitySuccessRate::getStageId, customerStageIds);
        }
        if (CollectionUtil.isNotEmpty(productIdList)) {
            lambdaQueryWrapper.in(OpportunitySuccessRate::getProductId, productIdList);
        } else {
            lambdaQueryWrapper.isNull(OpportunitySuccessRate::getProductId);
        }
        List opportunitySuccessRateList = this.opportunitySuccessRateService.list((Wrapper)lambdaQueryWrapper);
        LambdaQueryWrapper lambdaQueryWrapper2 = new LambdaQueryWrapper();
        if (CollectionUtil.isNotEmpty(customerStageIds)) {
            lambdaQueryWrapper2.in(OpportunitySuccessRate::getStageId, customerStageIds);
        }
        lambdaQueryWrapper2.isNull(OpportunitySuccessRate::getProductId);
        List opportunitySuccessRateList2 = this.opportunitySuccessRateService.list((Wrapper)lambdaQueryWrapper2);
        Map<Long, List<OpportunitySuccessRate>> stageIdGrouped = opportunitySuccessRateList.stream().collect(Collectors.groupingBy(OpportunitySuccessRate::getStageProcessId));
        Map<Long, List<OpportunitySuccessRate>> stageIdGrouped2 = opportunitySuccessRateList2.stream().collect(Collectors.groupingBy(OpportunitySuccessRate::getStageProcessId));
        List stageProcessEntityList = this.stageProcessService.listByIds(stageProcessIds);
        Map<Long, String> stageProcessMap = stageProcessEntityList.stream().collect(Collectors.toMap(StageProcessEntity::getStageProcessId, StageProcessEntity::getProcessName));
        ArrayList<OpportunitySuccessRateStageVo> opportunitySuccessRateStageVos = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)opportunitySuccessRateList) || CollectionUtil.isNotEmpty((Collection)opportunitySuccessRateList2)) {
            if (CollectionUtil.isEmpty(productIdList)) {
                for (Long stageProcessId : stageProcessIds) {
                    ArrayList<OpportunitySuccessRateVo> opportunitySuccessRateVoList = new ArrayList<OpportunitySuccessRateVo>();
                    List<OpportunitySuccessRate> opportunitySuccessRates = stageIdGrouped.get(stageProcessId);
                    if (opportunitySuccessRates == null) {
                        opportunitySuccessRates = stageIdGrouped2.get(stageProcessId);
                    }
                    if (!CollectionUtil.isNotEmpty(opportunitySuccessRates)) continue;
                    OpportunitySuccessRateStageVo opportunitySuccessRateStageVo = new OpportunitySuccessRateStageVo();
                    OpportunitySuccessRateVo opportunitySuccessRateVo = this.convertToVo(opportunitySuccessRates);
                    opportunitySuccessRateVo.setProductName(null);
                    opportunitySuccessRateVo.setProductId(null);
                    opportunitySuccessRateVoList.add(opportunitySuccessRateVo);
                    opportunitySuccessRateStageVo.setOpportunitySuccessRateVo(opportunitySuccessRateVoList);
                    opportunitySuccessRateStageVo.setStageProcessId(stageProcessId);
                    String processName = stageProcessMap.get(stageProcessId);
                    opportunitySuccessRateStageVo.setProcessName(processName);
                    opportunitySuccessRateStageVos.add(opportunitySuccessRateStageVo);
                }
            } else {
                for (Long stageId : stageProcessIds) {
                    OpportunitySuccessRateStageVo successRateStageVo = new OpportunitySuccessRateStageVo();
                    ArrayList<OpportunitySuccessRateVo> opportunitySuccessRateVoList = new ArrayList<OpportunitySuccessRateVo>();
                    List<OpportunitySuccessRate> opportunitySuccessRates = stageIdGrouped.get(stageId);
                    if (opportunitySuccessRates == null) {
                        opportunitySuccessRates = stageIdGrouped2.get(stageId);
                        opportunitySuccessRateVoList.add(this.convertToVo(opportunitySuccessRates));
                    } else {
                        Map<Long, List<OpportunitySuccessRate>> productIdGrouped = opportunitySuccessRates.stream().collect(Collectors.groupingBy(OpportunitySuccessRate::getProductId));
                        for (Long productId : productIdList) {
                            List<OpportunitySuccessRate> productSuccessRateList = productIdGrouped.get(productId);
                            if (!CollectionUtil.isNotEmpty(productSuccessRateList)) continue;
                            opportunitySuccessRateVoList.add(this.convertToVo(productSuccessRateList));
                        }
                    }
                    successRateStageVo.setStageProcessId(stageId);
                    String processName = stageProcessMap.get(stageId);
                    successRateStageVo.setProcessName(processName);
                    successRateStageVo.setOpportunitySuccessRateVo(opportunitySuccessRateVoList);
                    opportunitySuccessRateStageVos.add(successRateStageVo);
                }
            }
        } else {
            List<String> stageTypesNotInclude = Arrays.asList("21", "22", "23");
            List opportunityStages = this.stageProcessService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(StageProcessEntity::getStageProcessId, stageProcessIds)).eq(StageProcessEntity::getDelFlag, (Object)"0"));
            for (StageProcessEntity stageProcess : opportunityStages) {
                OpportunitySuccessRateStageVo successRateStageVo = new OpportunitySuccessRateStageVo();
                successRateStageVo.setProcessName(stageProcess.getProcessName());
                successRateStageVo.setStageProcessId(stageProcess.getStageProcessId());
                List customerStageNames = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageName}).eq(OpportunityStage::getStageProcessId, (Object)stageProcess.getStageProcessId())).eq(OpportunityStage::getDelFlag, (Object)"0")).notIn(OpportunityStage::getStageType, stageTypesNotInclude), Object::toString);
                if (CollectionUtil.isNotEmpty((Collection)customerStageNames)) {
                    String customerStageName = StringUtil.join((Collection)customerStageNames, (String)",");
                    successRateStageVo.setCustomerStageName(customerStageName);
                }
                opportunitySuccessRateStageVos.add(successRateStageVo);
            }
        }
        opportunitySuccessRateStageVos = opportunitySuccessRateStageVos.stream().sorted(Comparator.comparing(OpportunitySuccessRateStageVo::getStageProcessId)).collect(Collectors.toList());
        return opportunitySuccessRateStageVos;
    }

    public OpportunityConversionVo getConversionInfo(StageRecordDto stageRecordDto) {
        return this.opportunitySuccessRateService.getConversionInfo(stageRecordDto);
    }

    private OpportunitySuccessRateVo convertToVo(List<OpportunitySuccessRate> opportunitySuccessRateList) {
        if (CollectionUtil.isEmpty(opportunitySuccessRateList)) {
            return null;
        }
        Long productId = opportunitySuccessRateList.get(0).getProductId();
        String productName = opportunitySuccessRateList.get(0).getProductName();
        String shortName = opportunitySuccessRateList.get(0).getShortName();
        OpportunitySuccessRateVo opportunitySuccessRateVo = new OpportunitySuccessRateVo();
        opportunitySuccessRateVo.setProductId(productId);
        opportunitySuccessRateVo.setProductName(productName);
        opportunitySuccessRateVo.setShortName(shortName);
        ArrayList<OpportunityStageSuccessRate> opportunityStageSuccessRateList = new ArrayList<OpportunityStageSuccessRate>();
        for (OpportunitySuccessRate opportunitySuccessRate : opportunitySuccessRateList) {
            OpportunityStageSuccessRate opportunityStageSuccessRate = new OpportunityStageSuccessRate();
            opportunityStageSuccessRate.setStageId(opportunitySuccessRate.getStageId());
            opportunityStageSuccessRate.setStageName(opportunitySuccessRate.getStageName());
            opportunityStageSuccessRate.setSuccessRate(opportunitySuccessRate.getSuccessRate());
            opportunityStageSuccessRate.setOrderNumber(opportunitySuccessRate.getOrderNumber());
            opportunityStageSuccessRateList.add(opportunityStageSuccessRate);
        }
        opportunityStageSuccessRateList.sort(Comparator.comparing(OpportunityStageSuccessRate::getOrderNumber));
        opportunitySuccessRateVo.setStageSuccessRate(opportunityStageSuccessRateList);
        return opportunitySuccessRateVo;
    }
}

