/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.opportunity.external.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityStatisticsDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityStatisticsService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityStatisticsVo;
import com.jxdinfo.crm.core.api.opportunity.vo.StatisticsVo;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.opportunity.external.dao.OpportunityStatisticsMapper;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityStatisticsServiceImpl
implements IOpportunityStatisticsService {
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private OpportunityStatisticsMapper opportunityStatisticsMapper;

    public OpportunityStatisticsVo statisticsByProduct(OpportunityStatisticsDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.getUserRolePermissionsByUserId(permissionDto, this.crmProperties, dto.getUserId());
        StatisticsVo thisYearStatistics = this.opportunityStatisticsMapper.getThisYear(dto, permissionDto);
        StatisticsVo lastYearsStatistics = this.opportunityStatisticsMapper.getLastYears(dto, permissionDto);
        StatisticsVo winingOpportunity = this.opportunityStatisticsMapper.getWiningOpportunity(dto, permissionDto);
        OpportunityStatisticsVo opportunityStatisticsVo = new OpportunityStatisticsVo();
        opportunityStatisticsVo.setThisYear(thisYearStatistics);
        opportunityStatisticsVo.setLastYears(lastYearsStatistics);
        opportunityStatisticsVo.setWiningOpportunity(winingOpportunity);
        return opportunityStatisticsVo;
    }
}

