/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderBuilder;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordRelationAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordRelationAPIVo;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.api.task.service.ITaskAPIService;
import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeKeyword;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeQueryService;
import com.jxdinfo.crm.core.businessprocess.dto.BusinessProcessDto;
import com.jxdinfo.crm.core.businessprocess.service.IBusinessProcessService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.dto.DeptChangeBatchDto;
import com.jxdinfo.crm.core.common.dto.TianYanChaDto;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.common.vo.CompanyBaseInfo;
import com.jxdinfo.crm.core.common.vo.PersonWithDepInfo;
import com.jxdinfo.crm.core.common.vo.TransferBatchResultVo;
import com.jxdinfo.crm.core.common.vo.UserInfoVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.contact.dao.ContactMapper;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmopportunityproduct1.service.impl.CrmOpportunityProduct1ServiceImpl;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypool.constant.OpportunityPoolConstant;
import com.jxdinfo.crm.core.crm.opportunitypool.opportunitypooloppo.dao.OpportunityPoolOppoMapper;
import com.jxdinfo.crm.core.crm.sj.crmopportunitytask.dto.CrmOpportunityTaskTaskFlowIncrementDTO;
import com.jxdinfo.crm.core.crm.sj.crmopportunitytask.dto.CrmOpportunityTaskTaskIncrementTable;
import com.jxdinfo.crm.core.crm.sj.crmopportunitytask.model.CrmOpportunityProduct;
import com.jxdinfo.crm.core.crm.sj.crmopportunitytask.service.CrmOpportunityTaskTaskService;
import com.jxdinfo.crm.core.customer.dao.CustomerMapper;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.core.fileinfo.model.FileImport;
import com.jxdinfo.crm.core.fileinfo.service.FileImportService;
import com.jxdinfo.crm.core.focus.dao.FocusMapper;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.jxdIM.dto.CrmTeamAdminInfoDto;
import com.jxdinfo.crm.core.jxdIM.service.ImGroupMemberService;
import com.jxdinfo.crm.core.leads.dao.LeadsMapper;
import com.jxdinfo.crm.core.leads.dao.LeadsOriginMapper;
import com.jxdinfo.crm.core.leads.dto.LeadConvertDto;
import com.jxdinfo.crm.core.leads.dto.LeadsAssociativeQueryDto;
import com.jxdinfo.crm.core.leads.dto.LeadsDto;
import com.jxdinfo.crm.core.leads.dto.LeadsOriginDto;
import com.jxdinfo.crm.core.leads.dto.LeadsOriginExportTempDto;
import com.jxdinfo.crm.core.leads.model.CrmDeptRegionRelation;
import com.jxdinfo.crm.core.leads.model.CrmProductAssignRule;
import com.jxdinfo.crm.core.leads.model.CrmProductAssignRuleMember;
import com.jxdinfo.crm.core.leads.model.CrmProductAssignedRecord;
import com.jxdinfo.crm.core.leads.model.Leads;
import com.jxdinfo.crm.core.leads.model.LeadsOrigin;
import com.jxdinfo.crm.core.leads.model.LeadsOriginClaim;
import com.jxdinfo.crm.core.leads.service.CrmDeptRegionRelationService;
import com.jxdinfo.crm.core.leads.service.CrmProductAssignRuleMemberService;
import com.jxdinfo.crm.core.leads.service.CrmProductAssignRuleService;
import com.jxdinfo.crm.core.leads.service.CrmProductAssignedRecordService;
import com.jxdinfo.crm.core.leads.service.LeadsAssociativeQueryService;
import com.jxdinfo.crm.core.leads.service.LeadsOriginClaimService;
import com.jxdinfo.crm.core.leads.service.LeadsOriginService;
import com.jxdinfo.crm.core.leads.service.LeadsService;
import com.jxdinfo.crm.core.leads.vo.CrmProductAssignRuleVo;
import com.jxdinfo.crm.core.leads.vo.LeadsAnalysisSumVo;
import com.jxdinfo.crm.core.leads.vo.LeadsRepeatDetailVo;
import com.jxdinfo.crm.core.leads.vo.LeadsRepeatVo;
import com.jxdinfo.crm.core.leadshighseas.dao.LeadsHighSeasRelationMapper;
import com.jxdinfo.crm.core.leadshighseas.model.LeadsHighSeasModel;
import com.jxdinfo.crm.core.leadshighseas.model.LeadsHighSeasRelation;
import com.jxdinfo.crm.core.leadshighseas.service.LeadsHighSeasRelationService;
import com.jxdinfo.crm.core.leadshighseas.service.LeadsHighSeasService;
import com.jxdinfo.crm.core.leadshighseas.vo.LeadsHighSeasRelationVo;
import com.jxdinfo.crm.core.marketingactivity.model.MarketingActivityEntity;
import com.jxdinfo.crm.core.marketingactivity.model.SourceMarketingActivityEntity;
import com.jxdinfo.crm.core.marketingactivity.service.MarketingActivityService;
import com.jxdinfo.crm.core.marketingactivity.service.SourceMarketingActivityService;
import com.jxdinfo.crm.core.opportunity.constant.OpportunityEditConstant;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dto.ImproveOpportunityDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityEntityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.StageRecord;
import com.jxdinfo.crm.core.opportunity.service.IStageRecordService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.opportunity.util.OpportunityUtil;
import com.jxdinfo.crm.core.opportunityproduct.dao.OpportunityProductMapper;
import com.jxdinfo.crm.core.opportunityproduct.dto.OpportunityProductDto;
import com.jxdinfo.crm.core.opportunityproduct.model.OpportunityProduct;
import com.jxdinfo.crm.core.opportunityproduct.service.OpportunityProductService;
import com.jxdinfo.crm.core.opportunityproduct.vo.OpportunityProductVo;
import com.jxdinfo.crm.core.opportunitystage.model.StageProcessEntity;
import com.jxdinfo.crm.core.opportunitystage.service.IStageProcessService;
import com.jxdinfo.crm.core.product.dao.ProductMapper;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.teammeber.dao.TeamMeberMapper;
import com.jxdinfo.crm.core.teammeber.dto.TeamMeberDto;
import com.jxdinfo.crm.core.teammeber.model.TeamMeberEntity;
import com.jxdinfo.crm.core.teammeber.service.TeamMeberService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.CrmLabelUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.common.dto.Increment;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.region.model.SysRegion;
import com.jxdinfo.hussar.region.service.IHussarBaseRegionService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import com.jxdinfo.hussar.workflow.task.datasync.config.SnowflakeIDGenerator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class LeadsServiceImpl
extends ServiceImpl<LeadsMapper, Leads>
implements LeadsService {
    private static final Logger logger = LoggerFactory.getLogger(LeadsServiceImpl.class);
    @Resource
    private LeadsMapper leadsMapper;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;
    @Resource
    private CustomerMapper customerMapper;
    @Resource
    private ContactMapper contactMapper;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CustomerService customerService;
    @Resource
    private ContactService contactService;
    @Resource
    private TeamMeberMapper teamMeberMapper;
    @Resource
    private TeamMeberService teamMeberService;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private LeadsHighSeasService leadsHighSeasService;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private CrmOpportunityProduct1ServiceImpl opportunityProduct1;
    @Resource
    private LeadsHighSeasRelationService leadsHighSeasRelationService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CommonService commonService;
    @Resource
    private ISysStruService struService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private MarketingActivityService marketingActivityService;
    @Resource
    private SourceMarketingActivityService sourceMarketingActivityService;
    @Resource
    private ProductService productService;
    @Resource
    private ITrackRecordRelationAPIService trackRecordRelationAPIService;
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private OpportunityProductService opportunityProductService;
    @Resource
    private FocusMapper focusMapper;
    @Resource
    private ITaskAPIService taskAPIService;
    @Resource
    private OpportunityProductService opportunityProductService2;
    @Resource
    private ProductMapper productMapper;
    @Resource
    private LeadsHighSeasRelationMapper leadsHighSeasRelationMapper;
    @Resource
    private IHussarBaseRegionService iHussarBaseRegionService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private FileImportService fileImportService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private CrmProductAssignRuleService productAssignRuleService;
    @Resource
    private CrmProductAssignRuleMemberService productAssignRuleMemberService;
    @Resource
    private CrmDeptRegionRelationService deptRegionRelationService;
    @Resource
    private CrmProductAssignedRecordService productAssignedRecordService;
    @Autowired
    private SnowflakeIDGenerator idGenerator;
    @Resource
    private ImGroupMemberService imGroupMemberService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private LeadsOriginMapper leadsOriginMapper;
    @Resource
    private LeadsOriginClaimService leadsOriginClaimService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private LeadsOriginService leadsOriginService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private LeadsAssociativeQueryService leadsAssociativeQueryService;
    @Resource
    private AssociativeQueryService associativeQueryService;
    @Resource
    private ILabelService labelService;
    @Resource
    private CrmOpportunityTaskTaskService crmOpportunityTaskTaskService;
    @Resource
    private IBusinessProcessService businessProcessService;
    @Resource
    private OpportunityProductMapper opportunityProductMapper;
    @Resource
    private IStageRecordService stageRecordService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IStageProcessService stageProcessService;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private ISysCodeRuleRefService sysCodeRuleRefService;
    @Resource
    private OpportunityPoolOppoMapper opportunityPoolOppoMapper;
    @Resource
    private ICrmBaseConfigBoService iCrmBaseConfigBoService;

    @Override
    public Page<Leads> selectCrmLeadsList(LeadsDto dto) {
        Page page;
        List<Leads> list;
        List<LeadsDto> queryDtoList = this.getLeadsDtoList(dto);
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if ("1".equals(dto.getLeadsView())) {
            IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        }
        if (CollectionUtil.isNotEmpty(list = this.leadsMapper.selectCrmLeadList(page = dto.getPage(), dto.getCurrentUserId(), queryDtoList, permissionDto, dto.getTimeOrder()))) {
            List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.LEAD.getModuleId());
            list.forEach(leads -> {
                List recordList = this.trackRecordAPIService.listOrderByDesc(leads.getLeadsId());
                if (recordList != null && recordList.size() > 0) {
                    leads.setRecordType(((TrackRecordAPIVo)recordList.get(0)).getRecordType());
                    leads.setRecordContent(((TrackRecordAPIVo)recordList.get(0)).getRecordContent());
                }
                leads.setLabelName(CrmLabelUtil.getLabelName(labelList, leads.getLabelId()));
            });
        }
        page.setRecords(list);
        return page;
    }

    private List<LeadsDto> getLeadsDtoList(LeadsDto leadsDto) {
        ArrayList<LeadsDto> queryDtoList = new ArrayList<LeadsDto>();
        String view = leadsDto.getLeadsView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long opportunityView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)opportunityView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"leads");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)((Object)crmSceneList.get(0))).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        LeadsDto queryDto = (LeadsDto)JSONObject.parseObject((String)queryValue, LeadsDto.class);
                        queryDto.setLeadsView(String.valueOf(opportunityView));
                        queryDtoList.add(this.leadsPrivateQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.leadsPrivateQueryCondition(leadsDto));
        return queryDtoList;
    }

    private LeadsDto leadsPrivateQueryCondition(LeadsDto dto) {
        List<Long> otherProvinceIds;
        DateConvertVo dateConvertVo;
        String leadsView;
        LocalDateTime date = LocalDateTime.now();
        if (StringUtil.isEmpty((Object)dto.getLeadsView())) {
            dto.setLeadsView("1");
        }
        if (ToolUtil.isNotEmpty((Object)dto.getLeadsScreening())) {
            dto.setLeadsScreening(dto.getLeadsScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (String userId : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId(userId));
            }
            dto.setTransUserIds(userIds);
        }
        List<String> departments = dto.getOwnDepartments();
        ArrayList<String> odpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList<String> Ids;
                String odpIsTemp = CommonUtills.translateDepId(odpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(odpIsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        List<String> createDepartments = dto.getCreateDepartments();
        ArrayList<String> cdpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(createDepartments) && createDepartments.size() > 0) {
            for (String cdpId : createDepartments) {
                ArrayList<String> Ids;
                String cdpIdsTemp = CommonUtills.translateDepId(cdpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(cdpIdsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    cdpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransCreateDepartmentIds(cdpIds);
        }
        if ("2".equals(leadsView = dto.getLeadsView())) {
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if ("3".equals(leadsView)) {
            dto.setState("5");
        }
        if ("4".equals(leadsView)) {
            dto.setState("4");
        }
        if ("5".equals(leadsView)) {
            dto.setState("6");
        }
        if ("6".equals(leadsView)) {
            dto.setState("1");
        }
        if ("8".equals(leadsView)) {
            dto.setState("7");
        }
        dto.setDelFlag("0");
        SecurityUser user = BaseSecurityUtil.getUser();
        Object list = null;
        dto.setCurrentUserId(user.getUserId());
        if (!"".equals(dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && ToolUtil.isNotEmpty((Object)(dateConvertVo = IndexUtil.getCurrentTime(dto.getCreateTimeFlag())))) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (CollectionUtil.isNotEmpty(dto.getProvinces()) && dto.getProvinces().contains(99L) && CollectionUtil.isNotEmpty(otherProvinceIds = this.commonMapper.selectOtherProvince())) {
            otherProvinceIds.addAll(dto.getProvinces());
            dto.setProvinces(otherProvinceIds);
        }
        CommonUtills.inviteLeadsOverdueFollowTime(dto, date);
        return dto;
    }

    @Override
    public List<AssociativeQueryVo> associativeQuery(LeadsAssociativeQueryDto dto) {
        String keyWord = dto.getKeyword();
        String queryScreening = null;
        if (dto.getDto() != null) {
            queryScreening = dto.getDto().getLeadsScreening();
        }
        LeadsAssociativeQueryService adapterService = this.leadsAssociativeQueryService;
        AssociativeKeyword associativeKeyword = new AssociativeKeyword();
        associativeKeyword.setLabelName("\u5173\u952e\u5b57");
        associativeKeyword.setDataName("input_7Data");
        associativeKeyword.setDictTypeName("");
        associativeKeyword.setMultiOption(false);
        return this.associativeQueryService.associativeQuery(dto, keyWord, queryScreening, adapterService, associativeKeyword);
    }

    @Override
    public Page<OpportunityEntity> selectLeadsAnalysisList(OpportunityDto dto) {
        List<Long> otherProvinceIds;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        permissionDto.setTimeRange(dto.getTimeRange());
        permissionDto.setEndTime(dto.getDefinedEndTime());
        permissionDto.setStartTime(dto.getDefinedStartTime());
        IndexUtil.getCurrentTimeRange(permissionDto);
        if (StringUtil.isNotBlank((CharSequence)dto.getOrganId()) && !"1".equals(dto.getOrganId())) {
            SysStru sysStru = (SysStru)this.struService.getById((Serializable)((Object)dto.getOrganId()));
            if (ToolUtil.isEmpty((Object)sysStru)) {
                SysUsers sysUsers = (SysUsers)this.sysUsersService.getById((Serializable)((Object)dto.getOrganId()));
                if (ToolUtil.isNotEmpty((Object)sysUsers)) {
                    dto.setChargePersonId(String.valueOf(sysUsers.getId()));
                }
            } else if ("2".equals(sysStru.getStruType())) {
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(dto.getOrganId());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                dto.setDeptIds(deptIds);
            }
        }
        List<String> createDepartments = dto.getCreateDepartments();
        ArrayList<String> cdpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(createDepartments) && createDepartments.size() > 0) {
            for (String cdpId : createDepartments) {
                ArrayList<String> Ids;
                String cdpIdsTemp = CommonUtills.translateDepId(cdpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(cdpIdsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    cdpIds.add(idsTemp.get(i));
                }
            }
        }
        Page page = dto.getPage();
        dto.setDelFlag("0");
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getMarketingManager()))) {
            permissionDto.setPermissionUserDeptId(user.getDeptId());
        }
        if (CollectionUtil.isNotEmpty(dto.getProvinces()) && dto.getProvinces().contains(99L) && CollectionUtil.isNotEmpty(otherProvinceIds = this.commonMapper.selectOtherProvince())) {
            otherProvinceIds.addAll(dto.getProvinces());
            dto.setProvinces(otherProvinceIds);
        }
        List<OpportunityEntity> list = this.opportunityMapper.selectCrmFunnelLeadsList(dto, page, permissionDto, cdpIds);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<LeadsAnalysisSumVo> selectLeadsAnalysisSum(OpportunityDto dto) {
        List<Long> otherProvinceIds;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        permissionDto.setTimeRange(dto.getTimeRange());
        permissionDto.setEndTime(dto.getDefinedEndTime());
        permissionDto.setStartTime(dto.getDefinedStartTime());
        IndexUtil.getCurrentTimeRange(permissionDto);
        if (StringUtil.isNotBlank((CharSequence)dto.getOrganId()) && !"1".equals(dto.getOrganId())) {
            SysStru sysStru = (SysStru)this.struService.getById((Serializable)((Object)dto.getOrganId()));
            if (ToolUtil.isEmpty((Object)sysStru)) {
                SysUsers sysUsers = (SysUsers)this.sysUsersService.getById((Serializable)((Object)dto.getOrganId()));
                if (ToolUtil.isNotEmpty((Object)sysUsers)) {
                    dto.setChargePersonId(String.valueOf(sysUsers.getId()));
                }
            } else if ("2".equals(sysStru.getStruType())) {
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(dto.getOrganId());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                dto.setDeptIds(deptIds);
            }
        }
        List<String> createDepartments = dto.getCreateDepartments();
        ArrayList<String> cdpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(createDepartments) && createDepartments.size() > 0) {
            for (String cdpId : createDepartments) {
                ArrayList<String> Ids;
                String cdpIdsTemp = CommonUtills.translateDepId(cdpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(cdpIdsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    cdpIds.add(idsTemp.get(i));
                }
            }
        }
        permissionDto.setWinStateId("9223372036854775801");
        permissionDto.setLoseStateId("9223372036854775803");
        dto.setDelFlag("0");
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getMarketingManager()))) {
            permissionDto.setPermissionUserDeptId(user.getDeptId());
        }
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
            permissionDto.setPermissionDeptIds(null);
            permissionDto.setPermissionUserId(null);
        }
        if (CollectionUtil.isNotEmpty(dto.getProvinces()) && dto.getProvinces().contains(99L) && CollectionUtil.isNotEmpty(otherProvinceIds = this.commonMapper.selectOtherProvince())) {
            otherProvinceIds.addAll(dto.getProvinces());
            dto.setProvinces(otherProvinceIds);
        }
        Map<String, Object> maps = this.opportunityMapper.selectLeadsAnalysisSum(permissionDto, dto, cdpIds);
        ArrayList<LeadsAnalysisSumVo> list = new ArrayList<LeadsAnalysisSumVo>();
        int opportunityNum = 0;
        if (ToolUtil.isNotEmpty((Object)maps.get("opportunityNum"))) {
            opportunityNum = Integer.parseInt(maps.get("opportunityNum").toString());
        }
        list.add(new LeadsAnalysisSumVo("\u5546\u673a\u603b\u6570", null, opportunityNum, ""));
        int followingNum = 0;
        if (ToolUtil.isNotEmpty((Object)maps.get("followingNum"))) {
            followingNum = Integer.parseInt(maps.get("followingNum").toString());
        }
        list.add(new LeadsAnalysisSumVo("\u8ddf\u8fdb\u6570\u91cf", null, followingNum, ""));
        int customerNum = 0;
        if (ToolUtil.isNotEmpty((Object)maps.get("customerNum"))) {
            customerNum = Integer.parseInt(maps.get("customerNum").toString());
        }
        list.add(new LeadsAnalysisSumVo("\u8f6c\u5ba2\u6237", null, customerNum, ""));
        int approachNum = 0;
        if (ToolUtil.isNotEmpty((Object)maps.get("approachNum"))) {
            approachNum = Integer.parseInt(maps.get("approachNum").toString());
        }
        list.add(new LeadsAnalysisSumVo("\u521d\u6b65\u63a5\u6d3d", null, approachNum, ""));
        int confirmationNum = 0;
        if (ToolUtil.isNotEmpty((Object)maps.get("confirmationNum"))) {
            confirmationNum = Integer.parseInt(maps.get("confirmationNum").toString());
        }
        list.add(new LeadsAnalysisSumVo("\u6280\u672f\u4ea4\u6d41", null, confirmationNum, ""));
        int businessNum = 0;
        if (ToolUtil.isNotEmpty((Object)maps.get("businessNum"))) {
            businessNum = Integer.parseInt(maps.get("businessNum").toString());
        }
        list.add(new LeadsAnalysisSumVo("\u5546\u52a1\u8c08\u5224", null, businessNum, ""));
        int communicationNum = 0;
        if (ToolUtil.isNotEmpty((Object)maps.get("communicationNum"))) {
            communicationNum = Integer.parseInt(maps.get("communicationNum").toString());
        }
        list.add(new LeadsAnalysisSumVo("\u6295\u6807\u9636\u6bb5", null, communicationNum, ""));
        int advanceNum = 0;
        if (ToolUtil.isNotEmpty((Object)maps.get("advanceNum"))) {
            advanceNum = Integer.parseInt(maps.get("advanceNum").toString());
        }
        list.add(new LeadsAnalysisSumVo("\u63d0\u524d\u5f00\u5de5", null, advanceNum, ""));
        int winNum = 0;
        if (ToolUtil.isNotEmpty((Object)maps.get("winNum"))) {
            winNum = Integer.parseInt(maps.get("winNum").toString());
        }
        list.add(new LeadsAnalysisSumVo("\u8d62\u5355", null, winNum, ""));
        return list;
    }

    public List<String> selectLeadsTissueTreeUserId(String orgId, List<String> ids) {
        List<Map<String, Object>> organIds = this.opportunityMapper.opportunityTissueTreeFunnel(orgId);
        if (ToolUtil.isNotEmpty(organIds) && organIds.size() > 0) {
            for (Map<String, Object> organId : organIds) {
                String id = organId.get("id").toString();
                ids.add(id);
            }
        }
        return ids;
    }

    @Override
    public Leads selectCrmLeadsListDetails(LeadsDto dto) {
        List<LeadsHighSeasRelationVo> relationVoList;
        SecurityUser user = BaseSecurityUtil.getUser();
        Page page = dto.getPage();
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        Leads leads = this.leadsMapper.selectCrmLeadsDetailsTemp(dto);
        if (leads != null && StringUtil.isNotBlank((CharSequence)leads.getProductId())) {
            String[] products = leads.getProductId().split(",");
            List productList = this.productService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Product::getProductId, Product::getProductName}).in(Product::getProductId, Arrays.stream(products).toArray())).orderByAsc(Product::getCreateTime));
            String productName = "";
            for (Product product : productList) {
                productName = productName + "," + product.getProductName();
            }
            if (productName.length() > 0) {
                productName = productName.substring(1);
            }
            leads.setProductName(productName);
            leads.setProductList(productList);
        }
        if (CollectionUtil.isNotEmpty(relationVoList = this.leadsHighSeasRelationMapper.getLeadHighSeasByLeadId(dto.getLeadsId()))) {
            StringBuilder highSeasIds = new StringBuilder();
            StringBuilder highSeasNames = new StringBuilder();
            for (LeadsHighSeasRelationVo relation : relationVoList) {
                highSeasIds.append(",").append(relation.getHighSeasIds());
                highSeasNames.append(",").append(relation.getHighSeasNames());
            }
            assert (leads != null);
            leads.setHighSeasId(highSeasIds.substring(1));
            leads.setHighSeasName(highSeasNames.substring(1));
        }
        return leads;
    }

    @Override
    public Leads selectCrmLeadsDetails(LeadsDto dto) {
        List<LeadsHighSeasRelationVo> relationVoList;
        MarketingActivityEntity marketingActivityEntity;
        String fileInfoAmount = "0";
        SecurityUser user = BaseSecurityUtil.getUser();
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        Leads leads = this.leadsMapper.selectCrmLeadsDetails(dto);
        if (leads == null) {
            return null;
        }
        if (StringUtil.isNotBlank((CharSequence)leads.getProductId())) {
            String[] products = leads.getProductId().split(",");
            List productList = this.productService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Product::getProductId, Product::getProductName}).in(Product::getProductId, Arrays.stream(products).toArray())).orderByAsc(Product::getCreateTime));
            String productName = "";
            for (Product product : productList) {
                productName = productName + "," + product.getProductName();
            }
            if (productName.length() > 0) {
                productName = productName.substring(1);
            }
            leads.setProductName(productName);
            leads.setProductList(productList);
        }
        if (leads.getCampaignId() != null && (marketingActivityEntity = (MarketingActivityEntity)this.marketingActivityService.getById(leads.getCampaignId())) != null) {
            leads.setCampaignName(marketingActivityEntity.getCampaignName());
        }
        if (CollectionUtil.isNotEmpty(relationVoList = this.leadsHighSeasRelationMapper.getLeadHighSeasByLeadId(dto.getLeadsId()))) {
            StringBuilder highSeasIds = new StringBuilder();
            StringBuilder highSeasNames = new StringBuilder();
            for (LeadsHighSeasRelationVo relation : relationVoList) {
                highSeasIds.append(",").append(relation.getHighSeasIds());
                highSeasNames.append(",").append(relation.getHighSeasNames());
            }
            assert (leads != null);
            leads.setHighSeasId(highSeasIds.substring(1));
            leads.setHighSeasName(highSeasNames.substring(1));
        }
        if (ToolUtil.isNotEmpty((Object)leads)) {
            long businessId = dto.getLeadsId();
            List trackRecordList = this.trackRecordAPIService.queryTrackRecordList(Long.valueOf(businessId));
            ArrayList<Long> lids = new ArrayList<Long>();
            lids.add(businessId);
            for (TrackRecordAPIVo trackRecord : trackRecordList) {
                if (!ToolUtil.isNotEmpty((Object)trackRecord)) continue;
                lids.add(trackRecord.getRecordId());
            }
            if (null != lids && lids.size() != 0) {
                fileInfoAmount = this.customerMapper.selectFileInfoAmountByCustomerId(lids, "0");
            }
        }
        List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.LEAD.getModuleId());
        leads.setLabelName(CrmLabelUtil.getLabelName(labelList, leads.getLabelId()));
        leads.setFileInfoAmount(fileInfoAmount);
        leads.setTeamMemberAmount(this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)dto.getLeadsId())).eq(TeamMeberEntity::getBusinessType, (Object)"4")).ne(TeamMeberEntity::getDelFlag, (Object)"1")));
        leads.setTaskAmount(this.taskAPIService.selectTaskCount("4", dto.getLeadsId()));
        return leads;
    }

    @Override
    @Transactional
    public boolean updateDelFlagByLeadsIds(List<String> ids) {
        List leadsList = this.listByIds(ids);
        List leadsStates = leadsList.stream().map(Leads::getState).collect(Collectors.toList());
        if (leadsStates.contains("4")) {
            throw new BaseException("\u7ebf\u7d22\u5df2\u88ab\u8f6c\u5316\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        if (leadsStates.contains("7")) {
            throw new BaseException("\u7ebf\u7d22\u5df2\u88ab\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.leadsMapper.updateDelFlagByLeadsIds(ids, "1");
        this.teamMeberMapper.updateDelFlagByIds(null, "1", ids);
        List trackRecordList = this.trackRecordAPIService.list(ids, null, Collections.singletonList(RecordProductTypeEnum.PRODUCE_SYSTEM.getId()), "0");
        List<Object> recordIds = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)trackRecordList)) {
            recordIds = trackRecordList.stream().map(TrackRecordAPIVo::getRecordId).collect(Collectors.toList());
        }
        this.trackRecordAPIService.deleteBatchByIds(ids, CrmBusinessTypeEnum.LEADS.getId(), "1");
        List<Long> lids = ids.stream().map(Long::parseLong).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(recordIds)) {
            lids.addAll(recordIds);
        }
        this.fileInfoMapper.deleteFileInfoByIds(null, lids, "1");
        return true;
    }

    @Override
    public boolean updateLeadsState(long leadsId, String state, LocalDateTime date) {
        LeadsDto dto = new LeadsDto();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        dto.setLeadsId(leadsId);
        dto.setState(state);
        dto.setChangeTime(date);
        dto.setChangePerson(userId);
        dto.setChangePersonName(userName);
        this.leadsMapper.updateLeadsState(dto);
        return true;
    }

    @Override
    @Transactional
    public TransferBatchResultVo leadsTransfer(List<LeadsDto> dtos) {
        Object teamMeberEntity;
        ArrayList<TeamMeberEntity> teamMeberEntityList;
        ArrayList<String> msgList;
        TransferBatchResultVo resultVo = new TransferBatchResultVo();
        int dtoSize = dtos.size();
        int noPermissionNum = 0;
        int alreadyChargePersonNum = 0;
        ArrayList<CrmTeamAdminInfoDto> crmTeamAdminInfoDtoList = new ArrayList<CrmTeamAdminInfoDto>();
        String keepFlag = dtos.get(0).getKeepFlag();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        String userName = user.getUserName();
        String newChargePersonId = CommonUtills.translateUserId(dtos.get(0).getNewChargePersonId());
        PersonWithDepInfo mapDepartment = CommonUtills.selectDepIdName(newChargePersonId);
        String newOwnDepartment = mapDepartment.getDepartmentId().toString();
        String newOwnDepartmentName = mapDepartment.getDepartmentName();
        String newChargePersonName = dtos.get(0).getNewChargePersonName();
        List<Long> leadsIdList = dtos.stream().map(LeadsDto::getLeadsId).collect(Collectors.toList());
        List leadsList = this.listByIds(leadsIdList);
        for (LeadsDto dto : dtos) {
            for (Leads lead2 : leadsList) {
                if (!lead2.getLeadsId().equals(dto.getLeadsId())) continue;
                dto.setCustomerName(lead2.getCustomerName());
            }
        }
        ArrayList<Long> excludeLeadIdList = new ArrayList<Long>();
        List<Integer> operateFlagList = this.isOperateBatch(leadsIdList);
        for (int i = 0; i < operateFlagList.size(); ++i) {
            if (operateFlagList.get(i) >= 0) continue;
            excludeLeadIdList.add(leadsIdList.get(i));
            ++noPermissionNum;
        }
        for (Long excludeLeadId : excludeLeadIdList) {
            dtos = dtos.stream().filter(lead -> !lead.getLeadsId().equals(excludeLeadId)).collect(Collectors.toList());
        }
        leadsIdList = dtos.stream().map(LeadsDto::getLeadsId).collect(Collectors.toList());
        leadsList = ToolUtil.isNotEmpty(leadsIdList) ? this.listByIds(leadsIdList) : new ArrayList();
        ArrayList<LeadsDto> dtoList = new ArrayList<LeadsDto>();
        ArrayList<TeamMeberDto> teamMeberDtoList = new ArrayList<TeamMeberDto>();
        for (LeadsDto dto : dtos) {
            Leads lead3 = leadsList.stream().filter(object -> Objects.equals(object.getLeadsId(), dto.getLeadsId())).findFirst().get();
            String oldChargePersonName = dto.getOldChargePersonName();
            String string = dto.getOldChargePersonId();
            if (newChargePersonId.equals(string) && newChargePersonName.equals(oldChargePersonName)) {
                ++alreadyChargePersonNum;
                continue;
            }
            String string2 = lead3.getLeadsName();
            Long leadId = dto.getLeadsId();
            dto.setChangeTime(date);
            dto.setChangePerson(userId);
            dto.setChangePersonName(userName);
            dto.setNewChargePersonId(newChargePersonId);
            dto.setNewChargePersonName(newChargePersonName);
            dto.setOwnDepartment(Long.valueOf(newOwnDepartment));
            dto.setOwnDepartmentName(newOwnDepartmentName);
            dto.setLeadsId(leadId);
            dto.setLeadsName(string2);
            dtoList.add(dto);
            TeamMeberDto teamMeberDto = new TeamMeberDto();
            teamMeberDto.setBusinessId(leadId);
            teamMeberDto.setPersonId(Long.parseLong(newChargePersonId));
            teamMeberDto.setDelFlag("0");
            teamMeberDtoList.add(teamMeberDto);
        }
        if (dtoList.size() + alreadyChargePersonNum == dtoSize) {
            resultVo.setTransferResult(true);
            msgList = new ArrayList<String>();
            msgList.add("\u8f6c\u79fb\u6210\u529f");
            resultVo.setMsgList(msgList);
        } else {
            resultVo.setTransferResult(false);
            msgList = new ArrayList();
            if (dtoSize == 1) {
                if (noPermissionNum != 0) {
                    msgList.add("\u8f6c\u79fb\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u65e0\u6743\u9650");
                }
                resultVo.setMsgList(msgList);
            } else {
                Object msg = String.format("\u8f6c\u79fb\u6210\u529f%d\u6761\uff0c\u5931\u8d25%d\u6761\u3002\u5931\u8d25\u539f\u56e0\uff1a", dtoList.size() + alreadyChargePersonNum, dtoSize - dtoList.size() - alreadyChargePersonNum);
                if (noPermissionNum != 0) {
                    msg = msg + "\u65e0\u6743\u9650";
                }
                msgList.add((String)msg);
                resultVo.setMsgList(msgList);
            }
        }
        if (dtoList.isEmpty()) {
            return resultVo;
        }
        this.leadsMapper.updateChargePersonBatch(dtoList);
        if ("0".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (LeadsDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                ((TeamMeberEntity)((Object)teamMeberEntity)).setBusinessId(dto.getLeadsId());
                ((TeamMeberEntity)((Object)teamMeberEntity)).setDelFlag("1");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                teamMeberEntityList.add((TeamMeberEntity)((Object)teamMeberEntity));
            }
            this.teamMeberMapper.deleteChargePersonBatch(teamMeberEntityList);
        } else if ("1".equals(keepFlag)) {
            teamMeberEntityList = new ArrayList();
            for (LeadsDto dto : dtoList) {
                teamMeberEntity = new TeamMeberEntity();
                ((TeamMeberEntity)((Object)teamMeberEntity)).setBusinessId(dto.getLeadsId());
                ((TeamMeberEntity)((Object)teamMeberEntity)).setPersonId(Long.valueOf(dto.getOldChargePersonId()));
                ((TeamMeberEntity)((Object)teamMeberEntity)).setIsCharge("0");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setMemberRole("6");
                ((TeamMeberEntity)((Object)teamMeberEntity)).setModifyPower(null);
                teamMeberEntityList.add((TeamMeberEntity)((Object)teamMeberEntity));
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList);
        }
        List<Map<String, Object>> existTeamMemberList = this.teamMeberMapper.selectTeamMeberListBatch(teamMeberDtoList);
        ArrayList<LeadsDto> insertMemberDtoList = new ArrayList<LeadsDto>();
        ArrayList<LeadsDto> updateChargeDtoList = new ArrayList<LeadsDto>();
        for (LeadsDto leadsDto : dtoList) {
            boolean bl = true;
            for (Map map : existTeamMemberList) {
                if (!map.get("BUSINESS_ID").equals(leadsDto.getLeadsId())) continue;
                updateChargeDtoList.add(leadsDto);
                bl = false;
                break;
            }
            if (!bl) continue;
            insertMemberDtoList.add(leadsDto);
        }
        if (ToolUtil.isNotEmpty(updateChargeDtoList)) {
            ArrayList<TeamMeberEntity> teamMeberEntityList2 = new ArrayList<TeamMeberEntity>();
            for (LeadsDto leadsDto : updateChargeDtoList) {
                TeamMeberEntity teamMeberEntity2 = new TeamMeberEntity();
                teamMeberEntity2.setBusinessId(leadsDto.getLeadsId());
                teamMeberEntity2.setPersonId(Long.valueOf(newChargePersonId));
                teamMeberEntity2.setIsCharge("1");
                teamMeberEntity2.setMemberRole(null);
                teamMeberEntity2.setModifyPower("1");
                teamMeberEntityList2.add(teamMeberEntity2);
            }
            this.teamMeberMapper.updateIsChargeBatch(teamMeberEntityList2);
        }
        if (ToolUtil.isNotEmpty(insertMemberDtoList)) {
            this.teamMeberService.insertTeamMemberBatch(newChargePersonName, Long.parseLong(newChargePersonId), insertMemberDtoList.stream().map(LeadsDto::getLeadsId).collect(Collectors.toList()), "1", "1", ((LeadsDto)insertMemberDtoList.get(0)).getChangeTime(), "4");
        }
        ArrayList<Long> longOldChargePersonIdList = new ArrayList<Long>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (LeadsDto dto : dtoList) {
            longOldChargePersonIdList.add(Long.parseLong(dto.getOldChargePersonId()));
            arrayList.add(dto.getOldChargePersonName());
        }
        this.addTrackRecordBatch(dtoList, longOldChargePersonIdList, arrayList, newChargePersonId, newChargePersonName);
        for (LeadsDto dto : dtoList) {
            String string = dto.getLeadsName();
            Long leadsId = dto.getLeadsId();
            String oldChargePersonId = dto.getOldChargePersonId();
            String title = user.getUserName() + "\u5c06\u7ebf\u7d22\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8";
            String content = "\u7ebf\u7d22\u540d\u79f0\u3010" + string + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            EimPushUtil.pushJqxArticleMessage(title, content, "/crm/schd/xsxq", dto.getLeadsId().toString(), Arrays.asList(dto.getNewChargePersonId()));
            AddSysMessageType addSysMessageType = new AddSysMessageType();
            String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/clueDetails?row=" + "\"" + dto.getLeadsId() + "\"";
            String contentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + " \u5c06\u7ebf\u7d22\u8d1f\u8d23\u4eba\u8f6c\u79fb\u7ed9\u60a8\uff0c\u7ebf\u7d22\u540d\u79f0\u3010" + string + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
            UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, dto.getNewChargePersonId(), user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(addSysMessageType);
            String oldTitle = user.getUserName() + "\u8f6c\u79fb\u4e86\u60a8\u8d1f\u8d23\u7684\u7ebf\u7d22";
            String oldContent = "\u7ebf\u7d22\u540d\u79f0\u3010" + string + "\u3011\uff0c\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            EimPushUtil.pushJqxArticleMessage(oldTitle, oldContent, "/crm/schd/xsxq", leadsId.toString(), Arrays.asList(oldChargePersonId));
            AddSysMessageType oldAddSysMessageType = new AddSysMessageType();
            String oldContentUnify = "\u3010\u8f6c\u79fb\u63d0\u9192\u3011" + userName + "\u5c06\u60a8\u8d1f\u8d23\u7684\u7ebf\u7d22\u3010" + string + "\u3011\u8f6c\u79fb\u7ed9" + newOwnDepartmentName + "-" + newChargePersonName + "\uff0c\u8bf7\u77e5\u6089\u3002";
            UnifyUtil.defaultMessage(oldAddSysMessageType, oldContentUnify, date, user, oldChargePersonId, user.getUserName(), unifyWebUrl, "");
            UnifyUtil.sendMessage(oldAddSysMessageType);
            CrmTeamAdminInfoDto crmTeamAdminInfoDto = new CrmTeamAdminInfoDto();
            crmTeamAdminInfoDto.setBusinessType("4");
            crmTeamAdminInfoDto.setBusinessId(leadsId);
            crmTeamAdminInfoDto.setNewChargePersonId(newChargePersonId);
            crmTeamAdminInfoDto.setOldChargePersonId(oldChargePersonId);
            crmTeamAdminInfoDto.setKeepFlag(dto.getKeepFlag());
            crmTeamAdminInfoDtoList.add(crmTeamAdminInfoDto);
        }
        this.imGroupMemberService.transferAdmin(crmTeamAdminInfoDtoList);
        return resultVo;
    }

    @Override
    public void addTrackRecordBatch(List<LeadsDto> dtoList, List<Long> oldContactPersonIdList, List<String> oldContactPersonNameList, String newChargePersonId, String newChargePersonName) {
        ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (int i = 0; i < dtoList.size(); ++i) {
            LeadsDto dto = dtoList.get(i);
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(Long.valueOf(newChargePersonId));
            operateRecordDO.setContactName(newChargePersonName);
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFER.getId());
            if (HussarUtils.isNotEmpty((Object)oldContactPersonIdList.get(i))) {
                operateRecordDO.setOldContactId(oldContactPersonIdList.get(i));
            }
            operateRecordDO.setOldContactName(oldContactPersonNameList.get(i));
            operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType(CrmBusinessTypeEnum.LEADS.getId());
            operateRecordDO.setTypeId(dto.getLeadsId());
            operateRecordDO.setBusinessName(dto.getLeadsName());
            operateRecordDO.setCreatePerson(user.getUserId());
            operateRecordDO.setCreatePersonName(user.getUserName());
            operateRecordDO.setCreateTime(date);
            operateRecordDO.setChangePerson(user.getUserId());
            operateRecordDO.setChangeTime(date);
            operateRecordDO.setChangePersonName(user.getUserName());
            operateRecordDO.setDelflag("0");
            if (operateRecordDO.getProduceType() == null) {
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            }
            trackRecordList.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
    }

    @Override
    public List<Integer> isOperateBatch(List<Long> leadsIdList) {
        int i;
        List<Map<String, Long>> struList;
        int i2;
        ArrayList<Integer> permissionFlagList = new ArrayList<Integer>();
        List leadsList = this.listByIds(leadsIdList);
        for (Long leadId : leadsIdList) {
            boolean flag = false;
            for (Leads lead : leadsList) {
                if (!leadId.equals(lead.getLeadsId())) continue;
                flag = true;
                break;
            }
            if (flag) {
                permissionFlagList.add(CommonConstant.unconfirmedPermission);
                continue;
            }
            permissionFlagList.add(CommonConstant.noPermission);
        }
        block2: for (Leads lead : leadsList) {
            if (!"1".equals(lead.getDelFlag())) continue;
            for (i2 = 0; i2 < leadsIdList.size(); ++i2) {
                if (!lead.getLeadsId().equals(leadsIdList.get(i2)) || !((Integer)permissionFlagList.get(i2)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i2, CommonConstant.noPermission);
                continue block2;
            }
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            for (i2 = 0; i2 < permissionFlagList.size(); ++i2) {
                if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i2))) continue;
                permissionFlagList.set(i2, CommonConstant.companyLeader);
            }
        }
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        block5: for (Leads lead : leadsList) {
            if (!DataPermission.isLeadship(userRoles, leadershipRoles)) continue;
            struList = DataPermission.getStruCache();
            List<String> struIds = DataPermission.getLeadershipBGList(user.getUserId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String struId : struIds) {
                    List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                    deptIdList.addAll(deptIds);
                }
            }
            if (!CollectionUtil.isNotEmpty(deptIdList) || !deptIdList.contains(lead.getOwnDepartment() == null ? "" : lead.getOwnDepartment().toString())) continue;
            for (int i3 = 0; i3 < leadsIdList.size(); ++i3) {
                if (!lead.getLeadsId().equals(leadsIdList.get(i3)) || !((Integer)permissionFlagList.get(i3)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i3, CommonConstant.leadership);
                continue block5;
            }
        }
        block8: for (Leads lead : leadsList) {
            Long parentId;
            List<String> deptIds;
            if (!userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) || !CollectionUtil.isNotEmpty(deptIds = DataPermission.getAllDeptIdByParentId(struList = DataPermission.getStruCache(), parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId()))) || !deptIds.contains(lead.getOwnDepartment() == null ? "" : lead.getOwnDepartment().toString())) continue;
            for (int i4 = 0; i4 < leadsIdList.size(); ++i4) {
                if (!lead.getLeadsId().equals(leadsIdList.get(i4)) || !((Integer)permissionFlagList.get(i4)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i4, CommonConstant.bgLeader);
                continue block8;
            }
        }
        block10: for (Leads lead : leadsList) {
            if (!userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) || !user.getDeptId().toString().equals(lead.getOwnDepartment() == null ? "" : lead.getOwnDepartment().toString())) continue;
            for (int i5 = 0; i5 < leadsIdList.size(); ++i5) {
                if (!lead.getLeadsId().equals(leadsIdList.get(i5)) || !((Integer)permissionFlagList.get(i5)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i5, CommonConstant.salesGM);
                continue block10;
            }
        }
        block12: for (Leads lead : leadsList) {
            if (!userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) || !user.getDeptId().toString().equals(lead.getOwnDepartment() == null ? "" : lead.getOwnDepartment().toString())) continue;
            for (int i6 = 0; i6 < leadsIdList.size(); ++i6) {
                if (!lead.getLeadsId().equals(leadsIdList.get(i6)) || !((Integer)permissionFlagList.get(i6)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i6, CommonConstant.salesDirector);
                continue block12;
            }
        }
        block14: for (Leads lead : leadsList) {
            if (!user.getUserId().toString().equals(lead.getChargePersonId() == null ? "" : lead.getChargePersonId().toString())) continue;
            for (int i7 = 0; i7 < leadsIdList.size(); ++i7) {
                if (!lead.getLeadsId().equals(leadsIdList.get(i7)) || !((Integer)permissionFlagList.get(i7)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i7, CommonConstant.salesman);
                continue block14;
            }
        }
        block16: for (Leads lead : leadsList) {
            List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)lead.getLeadsId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"3"));
            if (!CollectionUtil.isNotEmpty((Collection)teamList)) continue;
            boolean flag = false;
            block17: for (TeamMeberEntity teamMeberEntity : teamList) {
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                for (int i8 = 0; i8 < leadsIdList.size(); ++i8) {
                    if (!lead.getLeadsId().equals(leadsIdList.get(i8)) || !((Integer)permissionFlagList.get(i8)).equals(CommonConstant.unconfirmedPermission)) continue;
                    permissionFlagList.set(i8, CommonConstant.otherRole);
                    flag = true;
                    continue block17;
                }
            }
            if (flag) continue;
            for (int i9 = 0; i9 < leadsIdList.size(); ++i9) {
                if (!lead.getLeadsId().equals(leadsIdList.get(i9)) || !((Integer)permissionFlagList.get(i9)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i9, CommonConstant.readOnly);
                continue block16;
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getMarketingPoolManager()))) {
            for (int i10 = 0; i10 < permissionFlagList.size(); ++i10) {
                if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i10))) continue;
                permissionFlagList.set(i10, CommonConstant.readOnly);
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getMarketingManager()))) {
            for (int i11 = 0; i11 < permissionFlagList.size(); ++i11) {
                if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i11))) continue;
                permissionFlagList.set(i11, CommonConstant.readOnly);
            }
        }
        for (i = 0; i < leadsList.size(); ++i) {
            Leads lead;
            lead = (Leads)leadsList.get(i);
            if (!StringUtil.isNotBlank((CharSequence)lead.getProductId())) continue;
            List<String> productIds = Arrays.asList(lead.getProductId().split(","));
            List<Long> businessIds = productIds.stream().map(Long::valueOf).collect(Collectors.toList());
            List<Map<String, Object>> productManagers = this.teamMeberMapper.selectProductTeamMemberByBusinessId(businessIds, "0");
            for (Map<String, Object> productManager : productManagers) {
                if (!user.getUserId().equals(productManager.get("personId")) || !((Integer)permissionFlagList.get(i)).equals(CommonConstant.unconfirmedPermission)) continue;
                permissionFlagList.set(i, CommonConstant.readOnly);
            }
        }
        for (i = 0; i < permissionFlagList.size(); ++i) {
            if (!CommonConstant.unconfirmedPermission.equals(permissionFlagList.get(i))) continue;
            permissionFlagList.set(i, CommonConstant.noPermission);
        }
        return permissionFlagList;
    }

    @Override
    @Transactional
    public boolean leadsChange(OpportunityEntityDto opportunityEntityDto) {
        OpportunityEntity opportunityEntity = (OpportunityEntity)BeanUtil.copy((Object)opportunityEntityDto, OpportunityEntity.class);
        assert (opportunityEntity != null);
        LeadsDto dto = new LeadsDto();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        String userDeptName = user.getDeptName();
        String leadsId = opportunityEntity.getLeadsId();
        boolean isOpportunity = opportunityEntity.isOpportunity();
        Long chargePersonId = user.getUserId();
        String chargePersonName = user.getUserName();
        String mobilePhone = opportunityEntity.getMobilePhone().replace(" ", "");
        dto.setLeadsId(Long.valueOf(leadsId));
        dto.setDelFlag("0");
        Leads leads = (Leads)this.getById(Long.valueOf(leadsId));
        if (leads == null || "4".equals(leads.getState()) || "7".equals(leads.getState())) {
            return false;
        }
        if (isOpportunity) {
            dto.setState("4");
        } else {
            dto.setState("7");
        }
        dto.setChangeTime(date);
        dto.setChangePerson(userId.toString());
        dto.setChangePersonName(userName);
        this.leadsMapper.updateLeadsState(dto);
        boolean isNewTeamMember = false;
        ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList();
        if (opportunityEntity.isTeamMeber()) {
            teamMeberEntityList = this.teamMeberMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)leadsId)).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
            isNewTeamMember = this.updateTeamMeberInfo(leads.getChargePersonId(), teamMeberEntityList, isNewTeamMember);
        }
        CustomerEntity customer = new CustomerEntity();
        ContactEntity contact = new ContactEntity();
        String name = opportunityEntity.getContactName();
        String companyName = opportunityEntity.getCustomerName();
        String sex = leads.getSex();
        String position = leads.getPosition();
        String phone = leads.getTelephone();
        String email = leads.getEmail();
        String trade = leads.getTrade();
        Long campaignId = leads.getCampaignId();
        String campaignName = leads.getCampaignName();
        String origin = leads.getLeadsOrigin();
        String province = leads.getProvince();
        String city = leads.getCity();
        String county = leads.getCounty();
        String address = leads.getAddressDetail();
        String remark = leads.getRemark();
        Long deptId = leads.getOwnDepartment();
        String deptName = leads.getOwnDepartmentName();
        String contactDepartment = leads.getContactDepartment();
        customer.setCustomerId(Long.valueOf(CommonUtills.generateAssignId()));
        customer.setCustomerName(companyName);
        customer.setTelephone(phone);
        customer.setTrade(trade);
        customer.setCampaignId(campaignId);
        customer.setCampaignName(campaignName);
        customer.setCustomerOrigin(origin);
        customer.setChargePersonId(chargePersonId);
        customer.setChargePersonName(chargePersonName);
        customer.setProvince(province);
        customer.setCity(city);
        customer.setCounty(county);
        customer.setAddressDetail(address);
        customer.setCustomerType(opportunityEntity.getCustomerType());
        customer.setCustLevel(opportunityEntity.getCustLevel());
        customer.setRemark(remark);
        customer.setCreatePerson(userId);
        customer.setCreatePersonName(userName);
        customer.setCreateTime(date);
        customer.setChangePerson(userId);
        customer.setChangePersonName(userName);
        customer.setChangeTime(date);
        customer.setOwnDepartment(deptId);
        customer.setOwnDepartmentName(deptName);
        customer.setCustomerReferredName(opportunityEntity.getCustomerReferredName());
        customer.setCustomerOrigin(opportunityEntity.getCustomerOrigin());
        customer.setDelFlag("0");
        this.customerService.saveOrUpdate(customer);
        if (opportunityEntity.isTeamMeber()) {
            for (TeamMeberEntity list : teamMeberEntityList) {
                this.addTeamMember(list, customer.getCustomerId(), "1", date);
            }
            this.teamMeberService.saveBatch(teamMeberEntityList);
            if (isNewTeamMember) {
                this.teamMeberService.insertTeamMember(customer.getChargePersonName(), customer.getChargePersonId(), customer.getCustomerId(), "1", "1", date, "1");
            }
        } else {
            this.teamMeberService.insertTeamMember(customer.getChargePersonName(), customer.getChargePersonId(), customer.getCustomerId(), "1", "1", date, "1");
        }
        contact.setContactId(Long.valueOf(CommonUtills.generateAssignId()));
        contact.setContactName(name);
        contact.setCustomerId(customer.getCustomerId());
        contact.setCustomerName(companyName);
        contact.setSex(sex);
        contact.setPosition(position);
        contact.setMobilePhone(mobilePhone);
        contact.setEmail(email);
        contact.setChargePersonId(chargePersonId);
        contact.setChargePersonName(chargePersonName);
        contact.setProvince(province);
        contact.setCity(city);
        contact.setCounty(county);
        contact.setAddressDetail(address);
        contact.setRemark(remark);
        contact.setCreatePerson(userId);
        contact.setCreatePersonName(userName);
        contact.setCreateTime(date);
        contact.setChangePerson(userId);
        contact.setChangePersonName(userName);
        contact.setChangeTime(date);
        contact.setOwnDepartment(deptId);
        contact.setOwnDepartmentName(deptName);
        contact.setDelFlag("0");
        contact.setTelephone(phone);
        contact.setDepartment(contactDepartment);
        this.contactService.saveOrUpdate(contact);
        if (opportunityEntity.isTeamMeber()) {
            for (TeamMeberEntity list : teamMeberEntityList) {
                this.addTeamMember(list, contact.getContactId(), "3", date);
            }
            this.teamMeberService.saveBatch(teamMeberEntityList);
            if (isNewTeamMember) {
                this.teamMeberService.insertTeamMember(contact.getChargePersonName(), contact.getChargePersonId(), contact.getContactId(), "1", "1", date, "3");
            }
        } else {
            this.teamMeberService.insertTeamMember(contact.getChargePersonName(), contact.getChargePersonId(), contact.getContactId(), "1", "1", date, "3");
        }
        ArrayList<Long> recordTypeId = new ArrayList<Long>();
        recordTypeId.add(Long.valueOf(leadsId));
        recordTypeId.add(customer.getCustomerId());
        recordTypeId.add(contact.getContactId());
        Long opportunityId = null;
        String opportunityName = null;
        if (isOpportunity) {
            opportunityEntity.setOpportunityId(Long.parseLong(CommonUtills.generateAssignId()));
            opportunityEntity.setCustomerId(customer.getCustomerId());
            opportunityEntity.setCreateTime(date);
            opportunityEntity.setCreatePerson(user.getId());
            opportunityEntity.setCreatePersonName(userName);
            opportunityEntity.setChangeTime(date);
            opportunityEntity.setChargePersonId(user.getId());
            opportunityEntity.setChargePersonName(userName);
            opportunityEntity.setChangePerson(user.getId());
            opportunityEntity.setChangePersonName(userName);
            opportunityEntity.setOwnDepartment(deptId);
            opportunityEntity.setOwnDepartmentName(deptName);
            opportunityEntity.setOpopportunityFrom(origin);
            opportunityEntity.setCustomerGroupId(CommonConstant.standard_group);
            opportunityEntity.setOriginLeads(Long.valueOf(leadsId));
            opportunityEntity.setCustomerBudget("0");
            if (ToolUtil.isEmpty((Object)opportunityEntity.getOpportunityAmount())) {
                opportunityEntity.setOpportunityAmount("0");
            }
            boolean k = this.opportunityService.saveOrUpdate(opportunityEntity);
            if (CollectionUtil.isNotEmpty(opportunityEntityDto.getProductList())) {
                this.saveOpprtunityProduct(opportunityEntityDto, date, user, opportunityEntity);
            }
            if (!k) {
                return false;
            }
            if (opportunityEntity.isTeamMeber()) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    this.addTeamMember(list, opportunityEntity.getOpportunityId(), "2", date);
                }
                this.teamMeberService.saveBatch(teamMeberEntityList);
                if (isNewTeamMember) {
                    this.teamMeberService.insertTeamMember(opportunityEntity.getChargePersonName(), opportunityEntity.getChargePersonId(), opportunityEntity.getOpportunityId(), "1", "1", date, "2");
                }
            } else {
                this.teamMeberService.insertTeamMember(opportunityEntity.getChargePersonName(), opportunityEntity.getChargePersonId(), opportunityEntity.getOpportunityId(), "1", "1", date, "2");
            }
            recordTypeId.add(opportunityEntity.getOpportunityId());
            opportunityId = opportunityEntity.getOpportunityId();
            opportunityName = opportunityEntity.getOpportunityName();
        }
        this.leadsMapper.updateLeadsCustomerId(opportunityId, opportunityName, customer.getCustomerId(), customer.getCustomerName(), leadsId, name, mobilePhone);
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setConvertCustomerId(customer.getCustomerId());
        operateRecordDO.setConvertCustomerName(customer.getCustomerName());
        operateRecordDO.setConvertContactId(contact.getContactId());
        operateRecordDO.setConvertContactName(contact.getContactName());
        operateRecordDO.setConvertOpporId(opportunityId);
        operateRecordDO.setConvertOpporName(opportunityName);
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFORMATION.getId());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS, Long.valueOf(opportunityId), leads.getLeadsName(), date, false, recordTypeId);
        ArrayList<String> produceTypes = new ArrayList<String>();
        produceTypes.add(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        produceTypes.add(RecordProductTypeEnum.PRODUCE_SYSTEM.getId());
        List recordList = this.trackRecordAPIService.list(Collections.singletonList(leadsId), null, produceTypes, "0");
        ArrayList<TrackRecordRelationAPIVo> relationList = new ArrayList<TrackRecordRelationAPIVo>();
        for (TrackRecordAPIVo list2 : recordList) {
            TrackRecordRelationAPIVo trackRecordRelation = new TrackRecordRelationAPIVo();
            trackRecordRelation.setRecordId(list2.getRecordId());
            trackRecordRelation.setTypeId(customer.getCustomerId());
            relationList.add(trackRecordRelation);
            if (!isOpportunity) continue;
            TrackRecordRelationAPIVo trackRecordRelation2 = new TrackRecordRelationAPIVo();
            if (RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId().equals(list2.getProduceType())) {
                trackRecordRelation2.setRecordId(list2.getRecordId());
                trackRecordRelation2.setTypeId(opportunityId);
                relationList.add(trackRecordRelation2);
                continue;
            }
            if (opportunityEntityDto.getRecordToOpportunity() == null || !opportunityEntityDto.getRecordToOpportunity().booleanValue()) continue;
            trackRecordRelation2.setRecordId(list2.getRecordId());
            trackRecordRelation2.setTypeId(opportunityId);
            relationList.add(trackRecordRelation2);
        }
        this.trackRecordRelationAPIService.saveBatch(relationList);
        List<String> focusId = this.focusMapper.selectCreateId("4", leads.getLeadsId());
        List<String> createRole = this.commonService.getRoleNameByUser_Id(leads.getCreatePerson());
        if (!(createRole.contains(this.crmProperties.getRoles().getBgLeader()) || createRole.contains(this.crmProperties.getRoles().getSalesGM()) || createRole.contains(this.crmProperties.getRoles().getSalesDirector()) || createRole.contains(this.crmProperties.getRoles().getSalesman()))) {
            String createPersonId = String.valueOf(leads.getCreatePerson());
            focusId.removeIf(item -> item.contains(createPersonId));
            String title1 = userName + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5ba2\u6237";
            String content1 = "\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + userDeptName + "\u7684" + userName + "\u8f6c\u6362\u6210\u5ba2\u6237\u3010" + customer.getCustomerName() + "\u3011";
            EimPushUtil.pushJqxArticleMessage(title1, content1, "/crm/kh/khxq", customer.getCustomerId().toString(), Arrays.asList(String.valueOf(leads.getCreatePerson())));
            String title2 = userName + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u8054\u7cfb\u4eba";
            String content2 = "\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + userDeptName + "\u7684" + userName + "\u8f6c\u6362\u6210\u8054\u7cfb\u4eba\u3010" + contact.getContactName() + "\u3011";
            EimPushUtil.pushJqxArticleMessage(title2, content2, "/crm/lxr/lxrxq", contact.getContactId().toString(), Arrays.asList(String.valueOf(leads.getCreatePerson())));
            if (isOpportunity) {
                String title3 = userName + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5546\u673a";
                String content3 = "\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + userDeptName + "\u7684" + userName + "\u8f6c\u6362\u6210\u5546\u673a\u3010" + opportunityName + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title3, content3, "/crm/sj/sjxq/xxzl", opportunityId.toString(), Arrays.asList(String.valueOf(leads.getCreatePerson())));
            }
        }
        if (ToolUtil.isNotEmpty(focusId)) {
            String title4 = userName + "\u5c06\u7ebf\u7d22\u8f6c\u6362\u6210\u5ba2\u6237";
            String content4 = "\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u8f6c\u6362\u4e3a\u5ba2\u6237\u3010" + customer.getCustomerName() + "\u3011";
            EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/kh/khxq", String.valueOf(customer.getCustomerId()), focusId);
            if (isOpportunity) {
                String title5 = userName + "\u5c06\u7ebf\u7d22\u8f6c\u6362\u6210\u5546\u673a";
                String content5 = "\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u8f6c\u6362\u4e3a\u5546\u673a\u3010" + opportunityName + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title5, content5, "/crm/sj/sjxq/xxzl", String.valueOf(opportunityId), focusId);
            }
        }
        return true;
    }

    @Override
    @Transactional
    public boolean leadsMerge(OpportunityEntityDto opportunityEntityDto) {
        OpportunityEntity opportunityEntity = (OpportunityEntity)BeanUtil.copy((Object)opportunityEntityDto, OpportunityEntity.class);
        assert (opportunityEntity != null);
        LeadsDto dto = new LeadsDto();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        String userDeptName = user.getDeptName();
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        Long parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId());
        List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId);
        String leadsId = opportunityEntity.getLeadsId();
        boolean isOpportunity = opportunityEntity.isOpportunity();
        Long chargePersonId = user.getUserId();
        String chargePersonName = user.getUserName();
        String mobilePhone = opportunityEntity.getMobilePhone().replace(" ", "");
        dto.setLeadsId(Long.valueOf(leadsId));
        dto.setDelFlag("0");
        Leads leads = (Leads)this.getById(Long.valueOf(leadsId));
        if (leads == null || "4".equals(leads.getState()) || "7".equals(leads.getState())) {
            return false;
        }
        if (isOpportunity) {
            dto.setState("4");
        } else {
            dto.setState("7");
        }
        dto.setChangeTime(date);
        dto.setChangePerson(userId.toString());
        dto.setChangePersonName(userName);
        this.leadsMapper.updateLeadsState(dto);
        boolean isNewTeamMember = false;
        ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList();
        if (opportunityEntity.isTeamMeber()) {
            teamMeberEntityList = this.teamMeberMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)leads.getLeadsId())).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
            isNewTeamMember = this.updateTeamMeberInfo(leads.getChargePersonId(), teamMeberEntityList, isNewTeamMember);
        }
        CustomerDto customerDto = new CustomerDto();
        String name = opportunityEntity.getContactName();
        String companyName = opportunityEntity.getCustomerName();
        String sex = leads.getSex();
        String position = leads.getPosition();
        String email = leads.getEmail();
        String origin = leads.getLeadsOrigin();
        String province = leads.getProvince();
        String city = leads.getCity();
        String county = leads.getCounty();
        String address = leads.getAddressDetail();
        String remark = leads.getRemark();
        Long deptId = leads.getOwnDepartment();
        String deptName = leads.getOwnDepartmentName();
        String phone = leads.getTelephone();
        String contactDepartment = leads.getContactDepartment();
        customerDto.setCustomerName(opportunityEntity.getCustomerName());
        List customerList = ToolUtil.isNotEmpty(deptIds) ? this.customerMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerName, (Object)opportunityEntity.getCustomerName())).in(CustomerEntity::getOwnDepartment, deptIds)).orderByDesc(CustomerEntity::getTrackTime)) : this.customerMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getCustomerName, (Object)opportunityEntity.getCustomerName())).orderByDesc(CustomerEntity::getTrackTime));
        CustomerEntity customer = (CustomerEntity)customerList.get(0);
        customer.setCustomerName(opportunityEntity.getCustomerName());
        customer.setCustomerType(opportunityEntity.getCustomerType());
        customer.setCustLevel(opportunityEntity.getCustLevel());
        customer.setChangePerson(userId);
        customer.setChangePersonName(userName);
        customer.setChangeTime(date);
        customer.setCustomerOrigin(opportunityEntity.getCustomerOrigin());
        customer.setCustomerReferredName(opportunityEntity.getCustomerReferredName());
        this.customerService.saveOrUpdate(customer);
        long teamCount = this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)customer.getCustomerId())).eq(TeamMeberEntity::getPersonId, (Object)userId)).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
        if (teamCount == 0L) {
            this.teamMeberService.insertTeamMember(userName, userId, customer.getCustomerId(), "1", "0", date, "1");
        }
        if (opportunityEntity.isTeamMeber()) {
            List<Long> customerPersonId = this.teamMeberMapper.selectPersonIdByBusinessId(customer.getCustomerId(), "0", null);
            ArrayList<TeamMeberEntity> teamMeberEntityList1 = new ArrayList<TeamMeberEntity>();
            for (TeamMeberEntity list : teamMeberEntityList) {
                if (customerPersonId.contains(list.getPersonId())) continue;
                teamMeberEntityList1.add(list);
            }
            if (CollectionUtil.isNotEmpty(teamMeberEntityList1)) {
                for (TeamMeberEntity list : teamMeberEntityList1) {
                    this.addTeamMember(list, customer.getCustomerId(), "1", date);
                }
                this.teamMeberService.saveBatch(teamMeberEntityList1);
            }
        }
        List contactList = this.contactMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getCustomerId, (Object)customer.getCustomerId())).eq(ContactEntity::getMobilePhone, (Object)mobilePhone.replace(" ", ""))).eq(ContactEntity::getDelFlag, (Object)"0")).orderByDesc(ContactEntity::getCreateTime));
        ContactEntity contact = new ContactEntity();
        if (CollectionUtil.isEmpty((Collection)contactList)) {
            contact.setContactId(Long.valueOf(CommonUtills.generateAssignId()));
            contact.setContactName(name);
            contact.setCustomerId(customer.getCustomerId());
            contact.setCustomerName(companyName);
            contact.setSex(sex);
            contact.setPosition(position);
            contact.setMobilePhone(mobilePhone);
            contact.setEmail(email);
            contact.setChargePersonId(chargePersonId);
            contact.setChargePersonName(chargePersonName);
            contact.setProvince(province);
            contact.setCity(city);
            contact.setCounty(county);
            contact.setAddressDetail(address);
            contact.setRemark(remark);
            contact.setCreatePerson(userId);
            contact.setCreatePersonName(userName);
            contact.setCreateTime(date);
            contact.setChangePerson(userId);
            contact.setChangePersonName(userName);
            contact.setChangeTime(date);
            contact.setOwnDepartment(deptId);
            contact.setOwnDepartmentName(deptName);
            contact.setDelFlag("0");
            contact.setTelephone(phone);
            contact.setDepartment(contactDepartment);
            this.contactMapper.insertCrmContact(contact);
            if (opportunityEntity.isTeamMeber()) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    this.addTeamMember(list, contact.getContactId(), "3", date);
                }
                this.teamMeberService.saveBatch(teamMeberEntityList);
                if (isNewTeamMember) {
                    this.teamMeberService.insertTeamMember(contact.getChargePersonName(), contact.getChargePersonId(), contact.getContactId(), "1", "1", date, "3");
                }
            } else {
                this.teamMeberService.insertTeamMember(contact.getChargePersonName(), contact.getChargePersonId(), contact.getContactId(), "1", "1", date, "3");
            }
        } else {
            contact = (ContactEntity)contactList.get(0);
            contact.setContactName(name);
            contact.setChangePerson(userId);
            contact.setChangePersonName(userName);
            contact.setChangeTime(date);
            this.contactMapper.updateById(contact);
            long teamCount2 = this.teamMeberService.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)contact.getContactId())).eq(TeamMeberEntity::getPersonId, (Object)userId)).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
            if (teamCount2 == 0L) {
                this.teamMeberService.insertTeamMember(userName, userId, contact.getContactId(), "1", "0", date, "3");
            }
            if (opportunityEntity.isTeamMeber()) {
                List<Long> contactPersonId = this.teamMeberMapper.selectPersonIdByBusinessId(contact.getContactId(), "0", null);
                ArrayList<TeamMeberEntity> teamMeberEntityList2 = new ArrayList<TeamMeberEntity>();
                for (TeamMeberEntity list : teamMeberEntityList) {
                    if (contactPersonId.contains(list.getPersonId())) continue;
                    teamMeberEntityList2.add(list);
                }
                if (CollectionUtil.isNotEmpty(teamMeberEntityList2)) {
                    for (TeamMeberEntity list : teamMeberEntityList2) {
                        this.addTeamMember(list, contact.getContactId(), "3", date);
                    }
                    this.teamMeberService.saveBatch(teamMeberEntityList2);
                }
            }
        }
        ArrayList<Long> recordTypeId = new ArrayList<Long>();
        recordTypeId.add(Long.valueOf(leadsId));
        recordTypeId.add(customer.getCustomerId());
        recordTypeId.add(contact.getContactId());
        Long opportunityId = null;
        String opportunityName = null;
        if (isOpportunity) {
            opportunityEntity.setOpportunityId(Long.parseLong(CommonUtills.generateAssignId()));
            opportunityEntity.setCustomerId(customer.getCustomerId());
            opportunityEntity.setCreateTime(date);
            opportunityEntity.setCreatePerson(user.getId());
            opportunityEntity.setCreatePersonName(userName);
            opportunityEntity.setChangeTime(date);
            opportunityEntity.setChargePersonId(user.getId());
            opportunityEntity.setChargePersonName(userName);
            opportunityEntity.setChangePerson(user.getId());
            opportunityEntity.setChangePersonName(userName);
            opportunityEntity.setOwnDepartment(deptId);
            opportunityEntity.setOwnDepartmentName(deptName);
            opportunityEntity.setOpopportunityFrom(origin);
            opportunityEntity.setCustomerBudget("0");
            opportunityEntity.setCustomerGroupId(CommonConstant.standard_group);
            opportunityEntity.setOriginLeads(Long.valueOf(leadsId));
            if (ToolUtil.isEmpty((Object)opportunityEntity.getOpportunityAmount())) {
                opportunityEntity.setOpportunityAmount("0");
            }
            boolean k = this.opportunityService.saveOrUpdate(opportunityEntity);
            if (CollectionUtil.isNotEmpty(opportunityEntityDto.getProductList())) {
                this.saveOpprtunityProduct(opportunityEntityDto, date, user, opportunityEntity);
            }
            if (!k) {
                return false;
            }
            if (opportunityEntity.isTeamMeber()) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    this.addTeamMember(list, opportunityEntity.getOpportunityId(), "2", date);
                }
                this.teamMeberService.saveBatch(teamMeberEntityList);
                if (isNewTeamMember) {
                    this.teamMeberService.insertTeamMember(opportunityEntity.getChargePersonName(), opportunityEntity.getChargePersonId(), opportunityEntity.getOpportunityId(), "1", "1", date, "2");
                }
            } else {
                this.teamMeberService.insertTeamMember(opportunityEntity.getChargePersonName(), opportunityEntity.getChargePersonId(), opportunityEntity.getOpportunityId(), "1", "1", date, "2");
            }
            recordTypeId.add(opportunityEntity.getOpportunityId());
            opportunityId = opportunityEntity.getOpportunityId();
            opportunityName = opportunityEntity.getOpportunityName();
        }
        this.leadsMapper.updateLeadsCustomerId(opportunityId, opportunityName, customer.getCustomerId(), customer.getCustomerName(), leadsId, name, mobilePhone);
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setConvertCustomerId(customer.getCustomerId());
        operateRecordDO.setConvertCustomerName(customer.getCustomerName());
        operateRecordDO.setConvertContactId(contact.getContactId());
        operateRecordDO.setConvertContactName(contact.getContactName());
        operateRecordDO.setConvertOpporId(opportunityId);
        operateRecordDO.setConvertOpporName(opportunityName);
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFORMATION.getId());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS, Long.valueOf(leadsId), leads.getLeadsName(), date, false, recordTypeId);
        if (isOpportunity && opportunityEntityDto.getRecordToOpportunity() != null && opportunityEntityDto.getRecordToOpportunity().booleanValue()) {
            ArrayList<String> produceTypes = new ArrayList<String>();
            produceTypes.add(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
            produceTypes.add(RecordProductTypeEnum.PRODUCE_SYSTEM.getId());
            List recordList = this.trackRecordAPIService.list(Collections.singletonList(leadsId), null, produceTypes, "0");
            ArrayList<TrackRecordRelationAPIVo> relationList = new ArrayList<TrackRecordRelationAPIVo>();
            for (TrackRecordAPIVo list2 : recordList) {
                TrackRecordRelationAPIVo trackRecordRelation2 = new TrackRecordRelationAPIVo();
                trackRecordRelation2.setRecordId(list2.getRecordId());
                trackRecordRelation2.setTypeId(opportunityId);
                relationList.add(trackRecordRelation2);
            }
            this.trackRecordRelationAPIService.saveBatch(relationList);
        }
        List<String> focusId = this.focusMapper.selectCreateId("4", leads.getLeadsId());
        List<String> createRole = this.commonService.getRoleNameByUser_Id(leads.getCreatePerson());
        if (!(createRole.contains(this.crmProperties.getRoles().getBgLeader()) || createRole.contains(this.crmProperties.getRoles().getSalesGM()) || createRole.contains(this.crmProperties.getRoles().getSalesDirector()) || createRole.contains(this.crmProperties.getRoles().getSalesman()))) {
            String createPersonId = String.valueOf(leads.getCreatePerson());
            focusId.removeIf(item -> item.contains(createPersonId));
            String title1 = userName + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5ba2\u6237";
            String content1 = userName + "\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + userDeptName + "\u7684" + userName + "\u8f6c\u6362\u6210\u5ba2\u6237\u3010" + customer.getCustomerName() + "\u3011";
            EimPushUtil.pushJqxArticleMessage(title1, content1, "/crm/kh/khxq", customer.getCustomerId().toString(), Arrays.asList(String.valueOf(leads.getCreatePerson())));
            String title2 = userName + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u8054\u7cfb\u4eba";
            String content2 = "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + userDeptName + "\u7684" + userName + "\u8f6c\u6362\u6210\u8054\u7cfb\u4eba\u3010" + contact.getContactName() + "\u3011";
            EimPushUtil.pushJqxArticleMessage(title2, content2, "/crm/lxr/lxrxq", contact.getContactId().toString(), Arrays.asList(String.valueOf(leads.getCreatePerson())));
            if (isOpportunity) {
                String title3 = userName + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5546\u673a";
                String content3 = "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + userDeptName + "\u7684" + userName + "\u8f6c\u6362\u6210\u5546\u673a\u3010" + opportunityName + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title3, content3, "/crm/sj/sjxq/xxzl", opportunityId.toString(), Arrays.asList(String.valueOf(leads.getCreatePerson())));
            }
        }
        String title4 = userName + "\u5c06\u7ebf\u7d22\u8f6c\u6362\u6210\u5ba2\u6237";
        String content4 = "\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u8f6c\u6362\u4e3a\u5ba2\u6237\u3010" + customer.getCustomerName() + "\u3011";
        EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/kh/khxq", String.valueOf(customer.getCustomerId()), focusId);
        if (isOpportunity) {
            String title5 = userName + "\u5c06\u7ebf\u7d22\u8f6c\u6362\u6210\u5546\u673a";
            String content5 = "\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u8f6c\u6362\u4e3a\u5546\u673a\u3010" + opportunityName + "\u3011";
            EimPushUtil.pushJqxArticleMessage(title5, content5, "/crm/sj/sjxq/xxzl", String.valueOf(opportunityId), focusId);
        }
        return true;
    }

    @Override
    public Integer selectRepeatNumber(LeadsDto dto) {
        int i = this.leadsMapper.selectRepeatNumber(dto);
        return i;
    }

    @Override
    public String leadsExport(HttpServletResponse response, LeadsDto dto) {
        String distinguish;
        String leadsView = dto.getLeadsView();
        String string = distinguish = dto.getDistinguish() == null ? "" : dto.getDistinguish();
        if (!distinguish.equals("1")) {
            DateConvertVo dateConvertVo = null;
            if ("1".equals(leadsView)) {
                dateConvertVo = CommonUtills.getWeekDate();
                dto.setState("4");
            }
            if ("2".equals(leadsView)) {
                dateConvertVo = CommonUtills.getMonthDay();
                dto.setState("4");
            }
            if ("4".equals(leadsView)) {
                dateConvertVo = CommonUtills.getYearDay();
                dto.setState("4");
            }
            if (dateConvertVo != null) {
                dto.setStartDate(dateConvertVo.getStartDate());
                dto.setEndDate(dateConvertVo.getEndDate());
            }
            if ("2".equals(leadsView)) {
                dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
                dto.setState("4");
            }
            if ("1".equals(leadsView)) {
                dto.setState("4");
            }
            if ("4".equals(leadsView)) {
                dto.setState("4");
            }
            if (null == leadsView || "".equals(leadsView)) {
                dto.setState("4");
            }
        }
        dto.setDelFlag("0");
        List<Leads> list = this.leadsMapper.selectCrmLeadsListExport(dto, null);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u7ebf\u7d22", Leads.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    @Override
    public String leadsStatisticsExport(HttpServletResponse response, LeadsDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        if (StringUtil.isNotBlank((CharSequence)dto.getOrganId()) && !"1".equals(dto.getOrganId())) {
            SysStru sysStru = (SysStru)this.struService.getById((Serializable)((Object)dto.getOrganId()));
            if ("2".equals(sysStru.getStruType())) {
                List<String> deptIds = new ArrayList<String>();
                deptIds.add(dto.getOrganId());
                deptIds = IndexUtil.getSubDeptId(deptIds);
                dto.setDeptIds(deptIds);
            } else {
                dto.setChargePersonId(dto.getOrganId());
            }
        }
        dto.setDelFlag("0");
        List<Leads> list = this.leadsMapper.selectCrmFunnelLeadsList(dto, null, permissionDto, null);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u7ebf\u7d22\u5217\u8868", Leads.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    @Override
    public String leadsExportTemplate(HttpServletResponse response) {
        ArrayList list = new ArrayList();
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, list, "\u7ebf\u7d22\u6a21\u677f", Leads.class);
        return "\u5bfc\u51fa\u6a21\u677f\u6210\u529f";
    }

    @Override
    public boolean updateLeadsByHighSeasId(LeadsDto dto) {
        long count;
        if (CollectionUtil.isEmpty(dto.getLeadsIds())) {
            throw new BaseException("\u7ebf\u7d22\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtil.isEmpty((Object)dto.getHighSeasId())) {
            throw new BaseException("\u516c\u6d77\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (dto.getLeadsIds().size() == 1 && (count = this.leadsHighSeasRelationService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LeadsHighSeasRelation::getHighSeasId, (Object)dto.getHighSeasId())).eq(LeadsHighSeasRelation::getLeadId, (Object)dto.getLeadsIds().get(0)))) > 0L) {
            throw new BaseException("\u7ebf\u7d22\u5df2\u5b58\u5728");
        }
        ArrayList<LeadsHighSeasRelation> relationList = new ArrayList<LeadsHighSeasRelation>();
        for (String leadId : dto.getLeadsIds()) {
            long count2 = this.leadsHighSeasRelationService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(LeadsHighSeasRelation::getHighSeasId, (Object)dto.getHighSeasId())).eq(LeadsHighSeasRelation::getLeadId, (Object)dto.getLeadsIds().get(0)));
            if (count2 != 0L) continue;
            LeadsHighSeasRelation relation = new LeadsHighSeasRelation();
            relation.setLeadId(Long.valueOf(leadId));
            relation.setHighSeasId(Long.valueOf(dto.getHighSeasId()));
            relationList.add(relation);
        }
        if (relationList.size() == 0) {
            throw new BaseException("\u7ebf\u7d22\u5747\u5df2\u5b58\u5728");
        }
        this.leadsHighSeasRelationService.saveBatch(relationList);
        return true;
    }

    @Override
    @Transactional
    public boolean abandonedLeads(OpportunityDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById(dto.getOpportunityId());
        if (opportunity == null) {
            throw new BaseException("\u5546\u673a\u4e0d\u5b58\u5728");
        }
        if ("6".equals(opportunity.getState())) {
            throw new BaseException("\u5546\u673a\u5f53\u524d\u5df2\u5e9f\u5f03\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c");
        }
        Long stageId = Long.parseLong(opportunity.getCustomerStageId());
        opportunity.setStageFinishTime(date);
        opportunity.setState("6");
        List invalidStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageProcessId, (Object)dto.getStageProcessId())).eq(OpportunityStage::getStageType, (Object)"22")).eq(OpportunityStage::getDelFlag, (Object)"0"));
        opportunity.setChangePerson(user.getUserId());
        opportunity.setChangePersonName(user.getUserName());
        opportunity.setChangeTime(date);
        opportunity.setAbandonedReason(dto.getAbandonedReason());
        opportunity.setAbandonedDescribe(dto.getAbandonedDescribe());
        this.opportunityService.updateById(opportunity);
        List<String> focusId = this.focusMapper.selectCreateId("2", opportunity.getOpportunityId());
        String createPersonId = String.valueOf(opportunity.getCreatePerson());
        String title = user.getUserName() + "\u5c06\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u5e9f\u5f03";
        String content = "\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5df2\u7531" + user.getDeptName() + "\u7684" + user.getUserName() + "\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
        EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", opportunity.getOpportunityId().toString(), Arrays.asList(String.valueOf(opportunity.getCreatePerson())));
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
        String contentUnify = "\u3010\u5546\u673a\u9636\u6bb5\u53d8\u66f4\u3011" + user.getUserName() + "\u5c06\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
        UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, String.valueOf(opportunity.getCreatePerson()), user.getUserName(), unifyWebUrl, "");
        UnifyUtil.sendMessage(addSysMessageType);
        focusId.removeIf(item -> item.contains(createPersonId));
        if (CollectionUtil.isNotEmpty(focusId)) {
            String title4 = user.getUserName() + "\u5c06\u5546\u673a\u5e9f\u5f03";
            String content4 = "\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5df2\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
            EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/sj/sjxq/xxzl", String.valueOf(opportunity.getOpportunityId()), focusId);
            AddSysMessageType addSysMessageType4 = new AddSysMessageType();
            String userIdToString = StringUtil.join(focusId, (String)",");
            String unifyWebUrl4 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
            String contentUnify1 = "\u3010\u5546\u673a\u9636\u6bb5\u53d8\u66f4\u3011" + user.getUserName() + "\u5c06\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + opportunity.getAbandonedDescribe();
            UnifyUtil.defaultMessage(addSysMessageType4, contentUnify1, date, user, userIdToString, user.getUserName(), unifyWebUrl4, "");
            UnifyUtil.sendMessage(addSysMessageType4);
        }
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setContactId(Long.valueOf(dto.getAbandonedReason()));
        if (ToolUtil.isNotEmpty((Object)dto.getAbandonedReason())) {
            operateRecordDO.setContactName(this.leadsMapper.selectAbandonedReason(dto.getAbandonedReason()));
        }
        operateRecordDO.setRecordContent(dto.getAbandonedDescribe());
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_LEADS_ABANDONED.getId());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, dto.getOpportunityId(), dto.getOpportunityName(), date, false, Arrays.asList(dto.getOpportunityId()));
        List opportunityStageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageProcessId, (Object)dto.getStageProcessId())).eq(OpportunityStage::getDelFlag, (Object)"0"));
        Map<Long, String> opportunityStageMap = opportunityStageList.stream().collect(Collectors.toMap(OpportunityStage::getCustomerStageId, OpportunityStage::getCustomerStageName));
        StageRecord stageRecord = new StageRecord();
        stageRecord.setOpportunityId(opportunity.getOpportunityId());
        stageRecord.setBeforeStageId(stageId);
        stageRecord.setBeforeStageName(opportunityStageMap.get(stageId));
        stageRecord.setAfterStageId(Long.valueOf(dto.getCustomerStageId()));
        stageRecord.setAfterStageName(opportunityStageMap.get(Long.valueOf(dto.getCustomerStageId())));
        stageRecord.setEntryTime(LocalDateTime.now());
        this.stageRecordService.insertRecordAndUpdateLeaveTime(stageRecord);
        return true;
    }

    @Override
    public Integer isOperate(Long leadsId) {
        Object parentId;
        List<String> deptIds;
        List<Map<String, Long>> struList;
        if (leadsId == null) {
            return CommonConstant.noPermission;
        }
        Leads leads = (Leads)this.getById(leadsId);
        if (leads == null || "1".equals(leads.getDelFlag())) {
            return CommonConstant.noPermission;
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            return CommonConstant.companyLeader;
        }
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        if (DataPermission.isLeadship(userRoles, leadershipRoles)) {
            struList = DataPermission.getStruCache();
            List<String> struIds = DataPermission.getLeadershipBGList(user.getUserId());
            ArrayList<String> deptIdList = new ArrayList<String>();
            if (CollectionUtil.isNotEmpty(struIds)) {
                for (String struId : struIds) {
                    List<String> deptIds2 = DataPermission.getAllDeptIdByParentId(struList, Long.valueOf(struId));
                    deptIdList.addAll(deptIds2);
                }
            }
            if (CollectionUtil.isNotEmpty(deptIdList) && deptIdList.contains(leads.getOwnDepartment() == null ? "" : leads.getOwnDepartment().toString())) {
                return CommonConstant.leadership;
            }
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader())) && CollectionUtil.isNotEmpty(deptIds = DataPermission.getAllDeptIdByParentId(struList = DataPermission.getStruCache(), (Long)(parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId())))) && deptIds.contains(leads.getOwnDepartment() == null ? "" : leads.getOwnDepartment().toString())) {
            return CommonConstant.bgLeader;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) && user.getDeptId().toString().equals(leads.getOwnDepartment() == null ? "" : leads.getOwnDepartment().toString())) {
            return CommonConstant.salesGM;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) && user.getDeptId().toString().equals(leads.getOwnDepartment() == null ? "" : leads.getOwnDepartment().toString())) {
            return CommonConstant.salesDirector;
        }
        if (user.getUserId().toString().equals(leads.getChargePersonId() == null ? "" : leads.getChargePersonId().toString())) {
            return CommonConstant.salesman;
        }
        List teamList = this.teamMeberService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)leads.getLeadsId())).eq(TeamMeberEntity::getDelFlag, (Object)"0")).eq(TeamMeberEntity::getPersonId, (Object)user.getUserId())).eq(TeamMeberEntity::getBusinessType, (Object)"4"));
        if (CollectionUtil.isNotEmpty((Collection)teamList)) {
            for (TeamMeberEntity teamMeberEntity : teamList) {
                if (!"1".equals(teamMeberEntity.getModifyPower())) continue;
                return CommonConstant.otherRole;
            }
            return CommonConstant.readOnly;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getMarketingPoolManager()))) {
            return CommonConstant.readOnly;
        }
        if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getMarketingManager()))) {
            return CommonConstant.readOnly;
        }
        if (user.getUserId().toString().equals(leads.getCreatePerson().toString())) {
            return CommonConstant.readOnly;
        }
        if (StringUtil.isNotBlank((CharSequence)leads.getProductId())) {
            List<String> productIds = Arrays.asList(leads.getProductId().split(","));
            List<Long> businessIds = productIds.stream().map(Long::valueOf).collect(Collectors.toList());
            List<Map<String, Object>> productManagers = this.teamMeberMapper.selectProductTeamMemberByBusinessId(businessIds, "0");
            for (Map<String, Object> productManager : productManagers) {
                if (!user.getUserId().equals(productManager.get("personId"))) continue;
                return CommonConstant.readOnly;
            }
        }
        return CommonConstant.noPermission;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Transactional
    public Boolean addLeads(Leads leads) {
        UserInfoVo userInfoVo;
        Long productId;
        Long userId;
        String companyName = leads.getCompanyName();
        companyName = companyName.trim();
        leads.setCompanyName(companyName);
        OpportunityEntity opportunityEntity = (OpportunityEntity)BeanUtil.copy((Object)leads, OpportunityEntity.class);
        assert (opportunityEntity != null);
        opportunityEntity.setOpportunityName(leads.getLeadsName());
        if (StringUtil.isEmpty((Object)opportunityEntity.getOpportunityName())) {
            throw new BaseException("\u5546\u673a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long opportunityId = Long.valueOf(CommonUtills.generateAssignId());
        List productList = this.productService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(Product::getProductName, (Object)opportunityEntity.getOpportunityName())).or()).eq(Product::getProductId, (Object)opportunityEntity.getProductId());
        })).eq(Product::getDelFlag, (Object)"0"));
        Map creator = (Map)JSON.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("official_web_creator").getConfigValue(), Map.class);
        Map dept = (Map)JSON.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("official_web_department").getConfigValue(), Map.class);
        Long createUserId = null;
        if (HussarUtils.isNotEmpty(creator.get("id"))) {
            createUserId = Long.valueOf((String)creator.get("id"));
        }
        if (CollectionUtil.isNotEmpty((Collection)productList) && ToolUtil.isNotEmpty((Object)(userId = this.leadsMapper.selectLeadsUser(productId = ((Product)productList.get(0)).getProductId())))) {
            createUserId = userId;
        }
        if (ToolUtil.isEmpty((Object)(userInfoVo = this.commonMapper.getUserInfo(createUserId)))) {
            userInfoVo = new UserInfoVo();
        }
        CompanyBaseInfo companyBaseInfo = null;
        String opportunityName = null;
        if (StringUtil.isNotEmpty((Object)companyName)) {
            TianYanChaDto tianYanChaDto = new TianYanChaDto();
            tianYanChaDto.setSearchKey(companyName);
            try {
                companyBaseInfo = this.commonService.getBaseInfoByTianyancha(tianYanChaDto);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (companyBaseInfo != null && StringUtil.isNotEmpty((Object)companyBaseInfo.getAlias())) {
            opportunityName = companyBaseInfo.getAlias();
        }
        if (StringUtil.isEmpty(opportunityName)) {
            opportunityName = this.commonService.companySimplify(companyName);
        }
        opportunityName = "[\u5b98\u7f51]" + opportunityName + "-";
        opportunityName = productList != null && productList.size() > 0 ? opportunityName + ((Product)productList.get(0)).getShortName() : opportunityName + leads.getLeadsName();
        opportunityEntity.setOpportunityName(opportunityName);
        if (StringUtil.isNotBlank((CharSequence)opportunityEntity.getMobilePhone())) {
            opportunityEntity.setMobilePhone(opportunityEntity.getMobilePhone().replace(" ", ""));
        }
        LocalDateTime date = LocalDateTime.now();
        StageProcessEntity defaultProcess = (StageProcessEntity)this.stageProcessService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StageProcessEntity::getDelFlag, (Object)"0")).eq(StageProcessEntity::getIsDefault, (Object)"1")).get(0);
        opportunityEntity.setStageProcessId(defaultProcess.getStageProcessId());
        opportunityEntity.setCustomerDemand(opportunityEntity.getRemark());
        opportunityEntity.setCustomerName(opportunityEntity.getCompanyName());
        opportunityEntity.setOpportunityId(opportunityId);
        opportunityEntity.setCreatePerson(userInfoVo.getUserId());
        opportunityEntity.setCreatePersonName((String)creator.get("name"));
        opportunityEntity.setOwnDepartment(userInfoVo.getStruId());
        opportunityEntity.setOwnDepartmentName(userInfoVo.getStruName());
        opportunityEntity.setChargePersonId(null);
        opportunityEntity.setChargePersonName(null);
        opportunityEntity.setCreateDepartment(userInfoVo.getStruId());
        opportunityEntity.setCreateDepartmentName(userInfoVo.getStruName());
        opportunityEntity.setCreateTime(date);
        opportunityEntity.setChangeTime(date);
        opportunityEntity.setChangePersonName((String)creator.get("name"));
        opportunityEntity.setChangePerson(userInfoVo.getUserId());
        opportunityEntity.setDelFlag("0");
        opportunityEntity.setFindTime(date);
        opportunityEntity.setState("5");
        opportunityEntity.setCustomerGroupId(11111L);
        opportunityEntity.setCustomerStageId("0");
        opportunityEntity.setImportance("1");
        opportunityEntity.setOpopportunityType("1");
        opportunityEntity.setOpopportunityFrom("5");
        opportunityEntity.setOpportunityAmount("0.00");
        ArrayList<OpportunityProduct> opportunityProductList = new ArrayList<OpportunityProduct>();
        this.setCampaignAndProduct(opportunityEntity, opportunityProductList);
        ArrayList<OperateRecordAPIVo> operateRecordDOS = new ArrayList<OperateRecordAPIVo>();
        OperateRecordAPIVo trackRecord = this.getOperateLog(userInfoVo, date, opportunityId, opportunityName, RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId(), null, null);
        operateRecordDOS.add(trackRecord);
        OpportunityUtil.singleOpportunityNo(opportunityEntity);
        if (HussarUtils.isNotEmpty((Object)companyBaseInfo)) {
            opportunityEntity.setAddressDetail(companyBaseInfo.getRegLocation());
            opportunityEntity.setProvince(companyBaseInfo.getProvinceId() == null ? null : String.valueOf(companyBaseInfo.getProvinceId()));
            opportunityEntity.setCity(companyBaseInfo.getCityId() == null ? null : String.valueOf(companyBaseInfo.getCityId()));
            opportunityEntity.setCounty(companyBaseInfo.getDistrictId() == null ? null : String.valueOf(companyBaseInfo.getDistrictId()));
            StringBuilder sb = new StringBuilder();
            if (HussarUtils.isNotEmpty((Object)companyBaseInfo.getProvince())) {
                sb.append(companyBaseInfo.getProvince());
            }
            if (HussarUtils.isNotEmpty((Object)companyBaseInfo.getCity())) {
                sb.append("/").append(companyBaseInfo.getCity());
            }
            if (HussarUtils.isNotEmpty((Object)companyBaseInfo.getDistrict())) {
                sb.append("/").append(companyBaseInfo.getDistrict());
            }
            if (HussarUtils.isNotEmpty((Object)sb)) {
                opportunityEntity.setRegionLabel(sb.toString());
            }
        } else {
            companyBaseInfo = new CompanyBaseInfo();
            companyBaseInfo.setName(companyName);
        }
        List<CrmProductAssignRuleVo> productAssignRuleVoList = new ArrayList<CrmProductAssignRuleVo>();
        String getRuleResult = "";
        StringBuilder customerNameKeyWord = new StringBuilder();
        String opptyPoolName = "";
        if (opportunityProductList.size() > 0) {
            Map<String, Object> resultMap = this.autoAssignLead(((OpportunityProduct)opportunityProductList.get(0)).getProductId(), companyBaseInfo, customerNameKeyWord, opportunityEntity);
            getRuleResult = (String)resultMap.get("resultMsg");
            productAssignRuleVoList = (List)resultMap.get("ruleVoList");
            opptyPoolName = (String)resultMap.get("opptyPoolName");
        } else if (ToolUtil.isEmpty(opportunityProductList)) {
            getRuleResult = "1";
        }
        ArrayList<Object> teamMeberEntities = new ArrayList<Object>();
        Long regioniId = null;
        if (getRuleResult.equals("0") && HussarUtils.isNotEmpty(productAssignRuleVoList)) {
            CrmProductAssignRuleVo productAssignRuleVo = this.getMatchedRuleVo(productAssignRuleVoList, companyBaseInfo.getProvinceId());
            UserInfoVo chargePersonVo = null;
            List deptRegionRelations = this.deptRegionRelationService.list((Wrapper)new LambdaQueryWrapper().eq(CrmDeptRegionRelation::getRegioniId, (Object)companyBaseInfo.getProvinceId()));
            Object var26_29 = null;
            if (CollectionUtil.isNotEmpty((Collection)deptRegionRelations)) {
                void var26_35;
                if (deptRegionRelations.size() > 1) {
                    ArrayList<Long> deptIds = new ArrayList<Long>();
                    for (Object relation : deptRegionRelations) {
                        deptIds.add(((CrmDeptRegionRelation)relation).getDeptId());
                    }
                    List recordList = this.productAssignedRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CrmProductAssignedRecord::getAssignDeptId, deptIds)).orderByDesc(HussarBaseEntity::getCreateTime)).last(" limit 1 "));
                    if (CollectionUtil.isNotEmpty((Collection)recordList)) {
                        for (CrmDeptRegionRelation relation : deptRegionRelations) {
                            if (String.valueOf(relation.getDeptId()).equals(String.valueOf(((CrmProductAssignedRecord)((Object)recordList.get(0))).getAssignDeptId()))) continue;
                            CrmDeptRegionRelation crmDeptRegionRelation = relation;
                        }
                    } else {
                        CrmDeptRegionRelation crmDeptRegionRelation = (CrmDeptRegionRelation)deptRegionRelations.get(0);
                    }
                } else {
                    CrmDeptRegionRelation crmDeptRegionRelation = (CrmDeptRegionRelation)deptRegionRelations.get(0);
                }
                SysStru sysStru = (SysStru)this.struService.getById((Serializable)var26_35.getDeptId());
                if (HussarUtils.isNotEmpty((Object)sysStru) && "0".equals(productAssignRuleVo.getDefaultFlag())) {
                    chargePersonVo = this.commonMapper.getUserInfo(var26_35.getChargePersonId());
                    opportunityEntity.setOwnDepartment(chargePersonVo.getStruId());
                    opportunityEntity.setOwnDepartmentName(chargePersonVo.getStruName());
                    opportunityEntity.setChargePersonId(var26_35.getChargePersonId());
                    opportunityEntity.setChargePersonName(var26_35.getChargePersonName());
                    opportunityEntity.setState("1");
                } else if ("1".equals(productAssignRuleVo.getDefaultFlag())) {
                    CrmProductAssignRuleMember assignRuleMember = new CrmProductAssignRuleMember();
                    assignRuleMember.setMemberId(var26_35.getChargePersonId());
                    assignRuleMember.setMemberRole("5");
                    productAssignRuleVo.getMemberList().add(assignRuleMember);
                }
                regioniId = var26_35.getRegioniId();
            }
            if ("1".equals(productAssignRuleVo.getDefaultFlag()) || "2".equals(productAssignRuleVo.getDefaultFlag())) {
                chargePersonVo = this.commonMapper.getUserInfo(productAssignRuleVo.getChargePersonId());
                opportunityEntity.setOwnDepartment(chargePersonVo.getStruId());
                opportunityEntity.setOwnDepartmentName(chargePersonVo.getStruName());
                opportunityEntity.setChargePersonId(productAssignRuleVo.getChargePersonId());
                opportunityEntity.setChargePersonName(productAssignRuleVo.getChargePersonName());
                opportunityEntity.setState("1");
            } else if ("3".equals(productAssignRuleVo.getDefaultFlag())) {
                CrmProductAssignRuleMember assignRuleMember = new CrmProductAssignRuleMember();
                assignRuleMember.setMemberId(productAssignRuleVo.getChargePersonId());
                assignRuleMember.setMemberRole("8");
                productAssignRuleVo.getMemberList().add(assignRuleMember);
            }
            if (chargePersonVo != null) {
                TeamMeberEntity chargeTeamMeberEntity = this.getTeamMeberEntity(chargePersonVo, date, opportunityId, "1", "1", "6");
                teamMeberEntities.add((Object)chargeTeamMeberEntity);
                OperateRecordAPIVo operateLog = this.getOperateLog(userInfoVo, date, opportunityId, opportunityName, RecordProductTypeEnum.PRODUCE_DISTRIBUTE.getId(), chargePersonVo.getUserId(), chargePersonVo.getUserName());
                operateRecordDOS.add(operateLog);
                this.addLeadSendMessage(opportunityName, leads.getCompanyName(), opportunityId, date, String.valueOf(chargePersonVo.getUserId()), "7", getRuleResult, null, null);
            }
            if (HussarUtils.isNotEmpty(productAssignRuleVo.getMemberList())) {
                for (CrmProductAssignRuleMember ruleMember : productAssignRuleVo.getMemberList()) {
                    UserInfoVo teamMemberPersonVo = this.commonMapper.getUserInfo(ruleMember.getMemberId());
                    TeamMeberEntity teamMeberEntity2 = this.getTeamMeberEntity(teamMemberPersonVo, date, opportunityId, "0", "1", ruleMember.getMemberRole());
                    teamMeberEntities.add((Object)teamMeberEntity2);
                    OperateRecordAPIVo operateLog = this.getOperateLog(userInfoVo, date, opportunityId, opportunityName, RecordProductTypeEnum.PRODUCE_TEAM_MEMBER.getId(), teamMemberPersonVo.getUserId(), teamMemberPersonVo.getUserName());
                    operateRecordDOS.add(operateLog);
                    this.addLeadSendMessage(opportunityName, leads.getCompanyName(), opportunityId, date, String.valueOf(teamMemberPersonVo.getUserId()), "6", getRuleResult, null, null);
                }
            }
        } else {
            String[] abnormalHandlerId = this.crmBaseConfigBoService.getCrmBaseConfigByKey("abnormal_data_handler").getConfigValue().split(",");
            HashMap<Long, UserInfoVo> userInfoVoMap = new HashMap<Long, UserInfoVo>();
            for (String id : abnormalHandlerId) {
                userInfoVoMap.put(Long.parseLong(id), this.commonMapper.getUserInfo(Long.parseLong(id)));
            }
            for (Map.Entry entry : userInfoVoMap.entrySet()) {
                TeamMeberEntity teamMeberEntity = this.getTeamMeberEntity((UserInfoVo)entry.getValue(), date, opportunityId, "0", "1", "8");
                teamMeberEntities.add((Object)teamMeberEntity);
                OperateRecordAPIVo operateLog = this.getOperateLog((UserInfoVo)entry.getValue(), date, opportunityId, opportunityName, RecordProductTypeEnum.PRODUCE_TEAM_MEMBER.getId(), ((UserInfoVo)entry.getValue()).getUserId(), ((UserInfoVo)entry.getValue()).getUserName());
                operateRecordDOS.add(operateLog);
                this.addLeadSendMessage(opportunityName, leads.getCompanyName(), opportunityId, date, String.valueOf(((UserInfoVo)entry.getValue()).getUserId()), "6", getRuleResult, customerNameKeyWord.toString(), opptyPoolName);
            }
        }
        this.opportunityService.save(opportunityEntity);
        if (opportunityProductList.size() > 0) {
            this.opportunityProductService.saveBatch(opportunityProductList);
        }
        this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOS);
        this.teamMeberService.saveBatch(teamMeberEntities);
        CrmProductAssignedRecord assignedRecord = new CrmProductAssignedRecord();
        if ("1".equals(opportunityEntity.getState())) {
            assignedRecord.setAssignUserId(opportunityEntity.getChargePersonId());
            assignedRecord.setAssignUserName(opportunityEntity.getChargePersonName());
            assignedRecord.setAssignRegionId(regioniId);
        } else {
            assignedRecord.setAssignUserId(userInfoVo.getUserId());
            assignedRecord.setAssignUserName(userInfoVo.getUserName());
        }
        if (opportunityProductList.size() > 0) {
            assignedRecord.setProductId(((OpportunityProduct)opportunityProductList.get(0)).getProductId());
        }
        assignedRecord.setAssignDeptId(opportunityEntity.getOwnDepartment());
        this.productAssignedRecordService.save((Object)assignedRecord);
        return true;
    }

    private CrmProductAssignRuleVo getMatchedRuleVo(List<CrmProductAssignRuleVo> productAssignRuleVoList, Long provinceId) {
        String province = String.valueOf(provinceId);
        boolean matchedFlag = false;
        CrmProductAssignRuleVo defaultAssignRuleVo = null;
        CrmProductAssignRuleVo matchedAssignRuleVo = null;
        for (CrmProductAssignRuleVo productAssignRuleVo : productAssignRuleVoList) {
            String[] provinces;
            String ruleProvince = productAssignRuleVo.getProvinceId();
            if (ToolUtil.isEmpty((Object)ruleProvince)) {
                defaultAssignRuleVo = productAssignRuleVo;
                continue;
            }
            for (String s : provinces = ruleProvince.split(",")) {
                if (!s.equals(province)) continue;
                matchedAssignRuleVo = productAssignRuleVo;
                matchedFlag = true;
                break;
            }
            if (!matchedFlag) continue;
            break;
        }
        if (matchedFlag) {
            return matchedAssignRuleVo;
        }
        return defaultAssignRuleVo;
    }

    private void setCampaignAndProduct(OpportunityEntity opportunityEntity, List<OpportunityProduct> opportunityProductList) {
        List sourceCampaignList;
        String campaignName = "\u81ea\u7136\u641c\u7d22";
        if (StringUtil.isNotBlank((CharSequence)opportunityEntity.getCampaignName())) {
            campaignName = opportunityEntity.getCampaignName();
        }
        if ((sourceCampaignList = this.sourceMarketingActivityService.list((Wrapper)new LambdaQueryWrapper().eq(SourceMarketingActivityEntity::getSourceName, (Object)campaignName))) != null && sourceCampaignList.size() > 0) {
            opportunityEntity.setCampaignId(((SourceMarketingActivityEntity)((Object)sourceCampaignList.get(0))).getCampaignId());
            opportunityEntity.setCampaignName(((SourceMarketingActivityEntity)((Object)sourceCampaignList.get(0))).getCampaignName());
        }
        String productNameStr = opportunityEntity.getProductName();
        String productIdStr = opportunityEntity.getProductId();
        if (StringUtil.isNotBlank((CharSequence)productNameStr) || StringUtil.isNotBlank((CharSequence)productIdStr)) {
            LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Product::getDelFlag, (Object)"0");
            if (ToolUtil.isNotEmpty((Object)productIdStr)) {
                String[] productIds = productIdStr.split(",");
                lambdaQueryWrapper.in(Product::getProductId, Arrays.stream(productIds).toArray());
            } else if (ToolUtil.isNotEmpty((Object)productNameStr)) {
                String[] productNames = productNameStr.split(",");
                lambdaQueryWrapper.and(queryWrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.in(Product::getProductName, Arrays.stream(productNames).toArray())).or()).in(Product::getProductId, Arrays.stream(productNames).toArray());
                });
            }
            lambdaQueryWrapper.orderByAsc(Product::getCreateTime);
            List productList = this.productService.list((Wrapper)lambdaQueryWrapper);
            if (productList != null && productList.size() > 0) {
                String productId = "";
                String productName = "";
                for (Product product : productList) {
                    productId = productId + "," + product.getProductId();
                    productName = productName + "," + product.getProductName();
                    OpportunityProduct opportunityProduct = new OpportunityProduct();
                    opportunityProduct.setProductId(product.getProductId());
                    opportunityProduct.setProductName(product.getProductName());
                    opportunityProduct.setOpportunityId(opportunityEntity.getOpportunityId());
                    opportunityProduct.setOpportunityName(opportunityEntity.getOpportunityName());
                    opportunityProduct.setStandardPrice(product.getProductPrice());
                    opportunityProduct.setSellPrice("0.00");
                    opportunityProduct.setProductNumber("1");
                    opportunityProduct.setProductSubtotal("0.00");
                    opportunityProduct.setTotalPrice("0.00");
                    opportunityProduct.setProductType(product.getProductType());
                    opportunityProduct.setCreatePerson(opportunityEntity.getCreatePerson());
                    opportunityProduct.setCreatePersonName(opportunityEntity.getCreatePersonName());
                    opportunityProduct.setCreateTime(opportunityEntity.getCreateTime());
                    opportunityProduct.setChangePerson(opportunityEntity.getCreatePerson());
                    opportunityProduct.setChangePersonName(opportunityEntity.getCreatePersonName());
                    opportunityProduct.setChangeTime(opportunityEntity.getCreateTime());
                    opportunityProduct.setDelFlag("0");
                    opportunityProductList.add(opportunityProduct);
                }
                if (productId.length() > 0) {
                    productId = productId.substring(1);
                    opportunityEntity.setProductId(productId);
                }
                if (productName.length() > 0) {
                    productName = productName.substring(1);
                    opportunityEntity.setProductName(productName);
                }
            }
        }
    }

    private TeamMeberEntity getTeamMeberEntity(UserInfoVo user, LocalDateTime date, Long businessId, String isCharge, String isPower, String memberRole) {
        TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
        teamMeberEntity.setTeamMeberName(user.getUserName());
        teamMeberEntity.setPersonId(user.getUserId());
        teamMeberEntity.setBusinessId(businessId);
        teamMeberEntity.setBusinessType("2");
        teamMeberEntity.setModifyPower(isPower);
        teamMeberEntity.setIsCharge(isCharge);
        teamMeberEntity.setCreatePerson(user.getUserId());
        teamMeberEntity.setCreatePersonName(user.getUserName());
        teamMeberEntity.setCreateTime(date);
        teamMeberEntity.setMemberRole(memberRole);
        teamMeberEntity.setOwnDepartment(user.getStruId());
        teamMeberEntity.setOwnDepartmentName(user.getStruName());
        teamMeberEntity.setUpdatePerson(user.getUserId());
        teamMeberEntity.setUpdateTime(date);
        teamMeberEntity.setUpdatePersonName(user.getUserName());
        teamMeberEntity.setDelFlag("0");
        return teamMeberEntity;
    }

    private OperateRecordAPIVo getOperateLog(UserInfoVo user, LocalDateTime date, Long businessId, String businessName, String produceType, Long userId, String userName) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setRecordId(Long.valueOf(this.idGenerator.getNextId()));
        operateRecordDO.setBusinessType(CrmBusinessTypeEnum.OPPORTUNITY.getId());
        operateRecordDO.setTypeId(businessId);
        operateRecordDO.setBusinessName(businessName);
        operateRecordDO.setCreatePerson(user.getUserId());
        operateRecordDO.setCreatePersonName("\u7cfb\u7edf");
        operateRecordDO.setCreateTime(date);
        operateRecordDO.setChangePerson(user.getUserId());
        operateRecordDO.setChangeTime(date);
        operateRecordDO.setChangePersonName("\u7cfb\u7edf");
        CodePlusDto codePlusDto = new CodePlusDto();
        codePlusDto.setRuleCode("OPERATE_RECORD_ORDER_NUMBER");
        Integer currentCode = Integer.valueOf(this.sysCodeRuleRefService.getCurrentCodeByCache(codePlusDto));
        operateRecordDO.setOrderNumber(currentCode);
        operateRecordDO.setDelflag("0");
        operateRecordDO.setProduceType(produceType);
        if (RecordProductTypeEnum.PRODUCE_TEAM_MEMBER.getId().equals(produceType)) {
            operateRecordDO.setTeamMemberId(String.valueOf(userId));
            operateRecordDO.setTeamMemberName(userName);
        } else if (RecordProductTypeEnum.PRODUCE_DISTRIBUTE.getId().equals(produceType)) {
            operateRecordDO.setContactId(userId);
            operateRecordDO.setContactName(userName);
        }
        return operateRecordDO;
    }

    @Override
    public void addTeamMember(TeamMeberEntity teamMeber, Long businessId, String businessType, LocalDateTime date) {
        SecurityUser user = BaseSecurityUtil.getUser();
        teamMeber.setTeamMeberId(null);
        teamMeber.setBusinessId(businessId);
        teamMeber.setBusinessType(businessType);
        teamMeber.setCreatePerson(user.getId());
        teamMeber.setCreatePersonName(user.getName());
        teamMeber.setCreateTime(date);
        teamMeber.setUpdatePerson(user.getUserId());
        teamMeber.setUpdatePersonName(user.getUserName());
        teamMeber.setTrackTime(date);
        teamMeber.setUpdateTime(date);
    }

    public boolean updateTeamMeberInfo(Long chargePersonId, List<TeamMeberEntity> teamMeberEntityList, boolean isNewTeamMember) {
        block5: {
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user.getUserId();
            if (chargePersonId.equals(userId)) break block5;
            List personIds = teamMeberEntityList.stream().map(TeamMeberEntity::getPersonId).collect(Collectors.toList());
            if (personIds.contains(userId)) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    if (list.getIsCharge().equals("1")) {
                        list.setMemberRole("6");
                        list.setIsCharge("0");
                    }
                    if (!list.getPersonId().equals(userId)) continue;
                    list.setIsCharge("1");
                    list.setMemberRole(null);
                }
            } else {
                isNewTeamMember = true;
                for (TeamMeberEntity list : teamMeberEntityList) {
                    if (!list.getIsCharge().equals("1")) continue;
                    list.setMemberRole("6");
                    list.setIsCharge("0");
                }
            }
        }
        return isNewTeamMember;
    }

    public void saveOpprtunityProduct(OpportunityEntityDto opportunityEntityDto, LocalDateTime date, SecurityUser user, OpportunityEntity opportunityEntity) {
        int i;
        List<OpportunityProduct> opportunityProductList = opportunityEntityDto.getProductList();
        for (int i2 = 0; i2 < opportunityProductList.size(); ++i2) {
            if (opportunityProductList.get(i2).getId() != null) continue;
            opportunityProductList.get(i2).setDelFlag("0");
            opportunityProductList.get(i2).setCreateTime(date);
            opportunityProductList.get(i2).setCreatePerson(user.getUserId());
            opportunityProductList.get(i2).setCreatePersonName(user.getUserName());
            opportunityProductList.get(i2).setChangeTime(date);
            opportunityProductList.get(i2).setChangePerson(user.getUserId());
            opportunityProductList.get(i2).setChangePersonName(user.getUserName());
            opportunityProductList.get(i2).setOrderNumber(null);
            opportunityProductList.get(i2).setOpportunityId(opportunityEntity.getOpportunityId());
            opportunityProductList.get(i2).setOpportunityName(opportunityEntity.getOpportunityName());
        }
        this.opportunityProductService.saveBatch(opportunityProductList);
        List<Long> saveProductIds = opportunityProductList.stream().map(OpportunityProduct::getProductId).collect(Collectors.toList());
        List<Map<String, Object>> productManagers = this.opportunityMapper.opportunityProductAndManagerList(opportunityEntityDto.getOpportunityId(), "0", saveProductIds);
        ArrayList<String> list = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(productManagers)) {
            try {
                for (i = 0; i < productManagers.size(); ++i) {
                    if (list.contains(String.valueOf(productManagers.get(i).get("managerId")))) continue;
                    list.add(String.valueOf(productManagers.get(i).get("managerId")));
                    String title = "\u3010" + productManagers.get(i).get("productName") + "\u3011\u5546\u673a\u63d0\u9192";
                    String content = user.getDeptName() + "-" + user.getUserName() + "\u5c06\u4ea7\u54c1\u3010" + productManagers.get(i).get("productName") + "\u3011\u5173\u8054\u5230\u5546\u673a\u3010" + opportunityEntityDto.getOpportunityName() + "\u3011";
                    EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", String.valueOf(opportunityProductList.get(0).getOpportunityId()), Arrays.asList(String.valueOf(productManagers.get(i).get("managerId"))));
                    AddSysMessageType addSysMessageType = new AddSysMessageType();
                    String contentUnify = "\u3010\u4ea7\u54c1\u52a8\u6001\u3011" + user.getDeptName() + "-" + user.getUserName() + " \u5728\u5546\u673a\u3010" + opportunityEntityDto.getOpportunityName() + "\u3011\u4e2d\uff0c\u5173\u8054\u4e86\u60a8\u7ba1\u7406\u7684\u4ea7\u54c1\u3010" + productManagers.get(i).get("shortName") + "\u3011";
                    UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, String.valueOf(productManagers.get(i).get("managerId")), "", "", "");
                    UnifyUtil.sendMessage(addSysMessageType);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (i = 0; i < opportunityProductList.size(); ++i) {
            OperateRecordAPIVo trackRecord = new OperateRecordAPIVo();
            trackRecord.setContactId(opportunityProductList.get(i).getProductId());
            trackRecord.setContactName(opportunityProductList.get(i).getProductName());
            trackRecord.setDelflag("0");
            trackRecord.setProduceType(RecordProductTypeEnum.PRODUCE_PRODUCT_ADD.getId());
            this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.OPPORTUNITY, opportunityEntity.getOpportunityId(), opportunityEntity.getOpportunityName(), date, false, Arrays.asList(opportunityEntity.getOpportunityId(), opportunityEntity.getCustomerId()));
        }
    }

    @Override
    public List<OpportunityEntity> selectLeadsRepeatList(OpportunityDto dto) {
        if (ToolUtil.isEmpty(dto.getProductIds())) {
            return null;
        }
        if (ToolUtil.isEmpty((Object)dto.getMobilePhone()) && ToolUtil.isEmpty((Object)dto.getCompanyName())) {
            return null;
        }
        dto.setDelFlag("0");
        String mobilePhone = dto.getMobilePhone();
        String companyName = dto.getCompanyName();
        ArrayList<OpportunityEntity> repeatList = new ArrayList<OpportunityEntity>();
        if (ToolUtil.isNotEmpty((Object)dto.getMobilePhone()) && ToolUtil.isNotEmpty(dto.getProductIds())) {
            dto.setCompanyName(null);
            List<OpportunityEntity> list1 = this.opportunityMapper.selectOpportunityCheckRepeat(dto);
            if (CollectionUtil.isNotEmpty(list1)) {
                repeatList.addAll(list1);
            }
        }
        dto.setCompanyName(companyName);
        if (ToolUtil.isNotEmpty((Object)dto.getCompanyName()) && ToolUtil.isNotEmpty(dto.getProductIds())) {
            dto.setMobilePhone(null);
            List<OpportunityEntity> list2 = this.opportunityMapper.selectOpportunityCheckRepeat(dto);
            if (CollectionUtil.isNotEmpty(list2)) {
                if (CollectionUtil.isEmpty(repeatList)) {
                    repeatList.addAll(list2);
                } else {
                    List productIds = repeatList.stream().map(OpportunityEntity::getProductId).collect(Collectors.toList());
                    List companyNames = repeatList.stream().map(OpportunityEntity::getCompanyName).collect(Collectors.toList());
                    for (OpportunityEntity opportunity : list2) {
                        if (productIds.contains(opportunity.getProductId()) && companyNames.contains(opportunity.getCompanyName())) continue;
                        repeatList.add(opportunity);
                    }
                }
            }
        }
        return repeatList;
    }

    @Override
    public String leadsCheckRepeat(OpportunityDto dto) {
        if (ToolUtil.isEmpty(dto.getProductIds())) {
            return "0";
        }
        if (ToolUtil.isEmpty((Object)dto.getMobilePhone()) && ToolUtil.isEmpty((Object)dto.getCompanyName())) {
            return "0";
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        Long parentId = DataPermission.getParentIdByDeptId(struList, user.getDeptId());
        List<String> deptIds = DataPermission.getAllDeptIdByParentId(struList, parentId);
        dto.setDeptIds(deptIds);
        dto.setDelFlag("0");
        ArrayList<OpportunityEntity> departmentList = new ArrayList<OpportunityEntity>();
        String mobilePhone = dto.getMobilePhone();
        String companyName = dto.getCompanyName();
        if (ToolUtil.isNotEmpty(dto.getProductIds()) && ToolUtil.isNotEmpty((Object)dto.getMobilePhone())) {
            dto.setCompanyName(null);
            List<OpportunityEntity> list1 = this.opportunityMapper.selectOpportunityCheckRepeat(dto);
            if (CollectionUtil.isNotEmpty(list1)) {
                departmentList.addAll(list1);
            }
        }
        dto.setCompanyName(companyName);
        if (ToolUtil.isNotEmpty(dto.getProductIds()) && ToolUtil.isNotEmpty((Object)dto.getCompanyName())) {
            dto.setMobilePhone(null);
            List<OpportunityEntity> list2 = this.opportunityMapper.selectOpportunityCheckRepeat(dto);
            if (CollectionUtil.isNotEmpty(list2)) {
                departmentList.addAll(list2);
            }
        }
        dto.setMobilePhone(mobilePhone);
        if (CollectionUtil.isNotEmpty(departmentList)) {
            return "2";
        }
        dto.setDeptIds(null);
        ArrayList<OpportunityEntity> companyList = new ArrayList<OpportunityEntity>();
        if (ToolUtil.isNotEmpty(dto.getProductIds()) && ToolUtil.isNotEmpty((Object)dto.getCompanyName())) {
            dto.setMobilePhone(null);
            List<OpportunityEntity> list3 = this.opportunityMapper.selectOpportunityCheckRepeat(dto);
            if (CollectionUtil.isNotEmpty(list3)) {
                companyList.addAll(list3);
            }
        }
        dto.setMobilePhone(mobilePhone);
        if (ToolUtil.isNotEmpty(dto.getProductIds()) && ToolUtil.isNotEmpty((Object)dto.getMobilePhone())) {
            dto.setCompanyName(null);
            List<OpportunityEntity> list4 = this.opportunityMapper.selectOpportunityCheckRepeat(dto);
            if (CollectionUtil.isNotEmpty(list4)) {
                companyList.addAll(list4);
            }
        }
        dto.setCompanyName(companyName);
        if (CollectionUtil.isNotEmpty(companyList)) {
            return "1";
        }
        return "0";
    }

    @Override
    public List<OpportunityProductVo> selectLeadsProducts(Long opportunityId) {
        OpportunityProductDto dto = new OpportunityProductDto();
        dto.setOpportunityId(opportunityId);
        dto.setDelFlag("0");
        List<OpportunityProduct> list = this.opportunityProductMapper.selectCrmOpportunityProductList(null, dto);
        return BeanUtil.copy(list, OpportunityProductVo.class);
    }

    @Override
    @Transactional
    public LeadConvertDto leadConvert(LeadConvertDto convertDto) {
        JSONObject sourceDescriptionJSON;
        Object operateRecordAPIVo;
        CustomerEntity customerEntity;
        OpportunityEntity opportunityEntity = (OpportunityEntity)this.opportunityService.getById(convertDto.getOpportunityId());
        if (opportunityEntity == null || "1".equals(opportunityEntity.getDelFlag())) {
            throw new BaseException("\u5f53\u524d\u5546\u673a\u4e0d\u5b58\u5728");
        }
        if ("6".equals(opportunityEntity.getState())) {
            throw new BaseException("\u5f53\u524d\u5546\u673a\u5df2\u5e9f\u5f03");
        }
        if (opportunityEntity.getCustomerId() != null) {
            throw new BaseException("\u5f53\u524d\u5546\u673a\u4fe1\u606f\u5df2\u786e\u8ba4");
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        this.defaultValue(convertDto);
        Long customerId = null;
        String customerName = null;
        Long contactId = null;
        Long opportunityId = convertDto.getOpportunityId();
        String oldOpptyStageName = "";
        String newOpptyStageName = "";
        if (convertDto.getAddCustomer().booleanValue()) {
            customerId = Long.valueOf(CommonUtills.generateAssignId());
            customerEntity = convertDto.getCustomerEntity();
            customerName = customerEntity.getCustomerName();
            customerEntity.setCustomerId(customerId);
            this.defaultCustomer(customerEntity, date, user, opportunityEntity.getChargePersonId(), opportunityEntity.getChargePersonName());
            this.customerService.save(customerEntity);
            operateRecordAPIVo = new OperateRecordAPIVo();
            operateRecordAPIVo.setSourceType("5");
            sourceDescriptionJSON = new JSONObject();
            sourceDescriptionJSON.put("sourceBusinessId", (Object)opportunityId);
            sourceDescriptionJSON.put("sourceBusinessName", (Object)opportunityEntity.getOpportunityName());
            sourceDescriptionJSON.put("sourceBusinessType", (Object)CrmBusinessTypeEnum.OPPORTUNITY.getId());
            operateRecordAPIVo.setSourceDescription(JSONObject.toJSONString((Object)sourceDescriptionJSON));
            this.operateRecordAPIService.saveOperateLog((OperateRecordAPIVo)operateRecordAPIVo, CrmBusinessTypeEnum.CUSTOMER, customerId, customerEntity.getCustomerName(), date, false, null);
            convertDto.setCustomerEntity(customerEntity);
        } else {
            customerId = convertDto.getCustomerEntity().getCustomerId();
            customerEntity = (CustomerEntity)this.customerService.getById(customerId);
            convertDto.setCustomerEntity(customerEntity);
            customerName = customerEntity.getCustomerName();
        }
        if (convertDto.getAddContact().booleanValue()) {
            contactId = Long.valueOf(CommonUtills.generateAssignId());
            ContactEntity contactEntity = convertDto.getContactEntity();
            contactEntity.setContactId(contactId);
            contactEntity.setCustomerId(customerId);
            contactEntity.setCustomerName(customerName);
            this.defaultContact(contactEntity, date, user, opportunityEntity.getChargePersonId(), opportunityEntity.getChargePersonName());
            this.contactService.save(contactEntity);
            operateRecordAPIVo = new OperateRecordAPIVo();
            operateRecordAPIVo.setSourceType("5");
            sourceDescriptionJSON = new JSONObject();
            sourceDescriptionJSON.put("sourceBusinessId", (Object)opportunityId);
            sourceDescriptionJSON.put("sourceBusinessName", (Object)opportunityEntity.getOpportunityName());
            sourceDescriptionJSON.put("sourceBusinessType", (Object)CrmBusinessTypeEnum.OPPORTUNITY.getId());
            operateRecordAPIVo.setSourceDescription(JSONObject.toJSONString((Object)sourceDescriptionJSON));
            this.operateRecordAPIService.saveOperateLog((OperateRecordAPIVo)operateRecordAPIVo, CrmBusinessTypeEnum.CONTACT, contactId, contactEntity.getContactName(), date, false, null);
        } else {
            contactId = convertDto.getContactEntity().getContactId();
            convertDto.setContactEntity((ContactEntity)this.contactService.getById(contactId));
        }
        OpportunityEntity opportunityEntityNew = new OpportunityEntity();
        if (convertDto.getOpportunity().booleanValue()) {
            opportunityEntityNew = (OpportunityEntity)BeanUtil.copy((Object)convertDto.getOpportunityEntityDto(), OpportunityEntity.class);
            assert (opportunityEntityNew != null);
            if (CollectionUtil.isNotEmpty(convertDto.getOpportunityEntityDto().getProductList())) {
                for (OpportunityProduct product : convertDto.getOpportunityEntityDto().getProductList()) {
                    product.setOpportunityId(opportunityEntity.getOpportunityId());
                    product.setOpportunityName(opportunityEntity.getOpportunityName());
                    if (!ToolUtil.isEmpty((Object)product.getStandardPrice()) || !ToolUtil.isNotEmpty((Object)product.getProductPrice())) continue;
                    product.setStandardPrice(product.getProductPrice());
                }
                this.opportunityProductService2.saveOpportunityProduct(convertDto.getOpportunityEntityDto().getProductList(), false, false);
            }
            convertDto.setOpportunityEntityDto((OpportunityEntityDto)BeanUtil.copy((Object)opportunityEntityNew, OpportunityEntityDto.class));
        } else {
            List stageList = this.opportunityStageService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityStage::getStageProcessId, (Object)opportunityEntity.getStageProcessId())).eq(OpportunityStage::getDelFlag, (Object)"0"));
            OpportunityStage convertStage = stageList.stream().filter(os -> "23".equals(os.getStageType())).findFirst().orElse(null);
            Map<Long, String> stageNameMap = stageList.stream().collect(Collectors.toMap(OpportunityStage::getCustomerStageId, OpportunityStage::getCustomerStageName));
            for (OpportunityStage os2 : stageList) {
                if (!"23".equals(os2.getStageType())) continue;
                opportunityEntityNew.setCustomerStageId(String.valueOf(os2.getCustomerStageId()));
                break;
            }
            opportunityEntityNew.setState("7");
            Long stageId = Long.parseLong(opportunityEntity.getCustomerStageId());
            oldOpptyStageName = stageNameMap.get(stageId);
            StageRecord stageRecord = new StageRecord();
            stageRecord.setOpportunityId(opportunityEntity.getOpportunityId());
            stageRecord.setBeforeStageId(stageId);
            stageRecord.setBeforeStageName(oldOpptyStageName);
            Long closeStage = convertStage.getCustomerStageId();
            newOpptyStageName = stageNameMap.get(closeStage);
            stageRecord.setAfterStageId(closeStage);
            stageRecord.setAfterStageName(newOpptyStageName);
            stageRecord.setEntryTime(LocalDateTime.now());
            this.stageRecordService.insertRecordAndUpdateLeaveTime(stageRecord);
        }
        opportunityEntityNew.setOpportunityId(opportunityId);
        opportunityEntityNew.setCustomerId(customerId);
        this.defaultOpportunity(opportunityEntityNew, date, user);
        opportunityEntityNew.setStageFinishTime(date);
        this.opportunityService.updateById(opportunityEntityNew);
        this.convertLeadRecord(opportunityEntity.getOpportunityId(), opportunityEntity.getOpportunityName(), customerId, contactId, date);
        if (!(convertDto.getOpportunity().booleanValue() || "".equals(oldOpptyStageName) || "".equals(newOpptyStageName))) {
            operateRecordAPIVo = new OperateRecordAPIVo();
            operateRecordAPIVo.setProduceType(RecordProductTypeEnum.PRODUCE_OPPORTUNITY_STAGE.getId());
            operateRecordAPIVo.setContactName(oldOpptyStageName);
            operateRecordAPIVo.setRecordContent(newOpptyStageName);
            this.operateRecordAPIService.saveOperateLog((OperateRecordAPIVo)operateRecordAPIVo, CrmBusinessTypeEnum.OPPORTUNITY, opportunityId, opportunityEntity.getOpportunityName(), LocalDateTime.now(), false, null);
        }
        List<TrackRecordRelationAPIVo> recordRelationList = this.getLeadRelationRecord(opportunityId, customerId);
        this.trackRecordRelationAPIService.saveBatch(recordRelationList);
        this.convertLeadAddTeamMember(convertDto, opportunityEntity, customerId, contactId, date, user);
        this.convertLeadToJqxMessage(convertDto, opportunityEntity, user, date);
        return convertDto;
    }

    private void defaultValue(LeadConvertDto convertDto) {
        if (convertDto.getAddCustomer() == null) {
            convertDto.setAddCustomer(false);
        }
        if (convertDto.getAddContact() == null) {
            convertDto.setAddContact(false);
        }
        if (convertDto.getTeamMeber() == null) {
            convertDto.setTeamMeber(false);
        }
        if (convertDto.getRecordToOpportunity() == null) {
            convertDto.setRecordToOpportunity(true);
        }
    }

    @Override
    public void defaultCustomer(CustomerEntity customerEntity, LocalDateTime date, SecurityUser user, Long chargePersonId, String chargePersonName) {
        customerEntity.setTelephone(customerEntity.getTelephone().replaceAll(" ", ""));
        customerEntity.setCreatePerson(user.getUserId());
        customerEntity.setCreatePersonName(user.getUserName());
        customerEntity.setCreateTime(date);
        customerEntity.setDelFlag("0");
        customerEntity.setDisableRepeat("0");
        customerEntity.setChargePersonId(chargePersonId);
        customerEntity.setChargePersonName(chargePersonName);
        customerEntity.setCreateDepartment(user.getDeptId());
        customerEntity.setCreateDepartmentName(user.getDeptName());
        customerEntity.setOwnDepartment(user.getDeptId());
        customerEntity.setOwnDepartmentName(user.getDeptName());
        customerEntity.setChangePerson(user.getUserId());
        customerEntity.setChangePersonName(user.getUserName());
        customerEntity.setChangeTime(date);
        if (ToolUtil.isEmpty((Object)customerEntity.getProvince())) {
            customerEntity.setProvince(null);
        }
        if (ToolUtil.isEmpty((Object)customerEntity.getCity())) {
            customerEntity.setCity(null);
        }
        if (ToolUtil.isEmpty((Object)customerEntity.getCounty())) {
            customerEntity.setCounty(null);
        }
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)customerEntity.getProvince())) {
            customerEntity.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerEntity.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)customerEntity.getCity())) {
            customerEntity.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerEntity.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)customerEntity.getCounty())) {
            customerEntity.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerEntity.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        customerEntity.setRegionLabel(sb.toString());
    }

    @Override
    public void defaultContact(ContactEntity contactEntity, LocalDateTime date, SecurityUser user, Long chargePersonId, String chargePersonName) {
        contactEntity.setDelFlag("0");
        if (StringUtil.isNotBlank((CharSequence)contactEntity.getMobilePhone())) {
            contactEntity.setMobilePhone(contactEntity.getMobilePhone().replace(" ", ""));
        }
        if (StringUtil.isNotBlank((CharSequence)contactEntity.getTelephone())) {
            contactEntity.setTelephone(contactEntity.getTelephone().replace(" ", ""));
        }
        contactEntity.setCreatePerson(user.getUserId());
        contactEntity.setCreatePersonName(user.getUserName());
        contactEntity.setCreateTime(date);
        contactEntity.setChargePersonId(chargePersonId);
        contactEntity.setChargePersonName(chargePersonName);
        contactEntity.setOwnDepartment(user.getDeptId());
        contactEntity.setOwnDepartmentName(user.getDeptName());
        contactEntity.setCreateDepartment(user.getDeptId());
        contactEntity.setCreateDepartmentName(user.getDeptName());
        contactEntity.setChangePerson(user.getUserId());
        contactEntity.setChangePersonName(user.getUserName());
        contactEntity.setChangeTime(date);
        contactEntity.setDelFlag("0");
        contactEntity.setCounty(null);
        contactEntity.setProvince(null);
        contactEntity.setCity(null);
    }

    @Override
    public void defaultOpportunity(OpportunityEntity opportunityEntity, LocalDateTime date, SecurityUser user) {
        opportunityEntity.setChangeTime(date);
        opportunityEntity.setChangePerson(user.getUserId());
        opportunityEntity.setChangePersonName(user.getUserName());
        opportunityEntity.setTrackTime(null);
    }

    private void updateConvertLead(LeadConvertDto convertDto, Leads leads, Long customerId, Long contactId, Long opportunityId, LocalDateTime date, SecurityUser user) {
        if (convertDto.getOpportunity().booleanValue()) {
            leads.setState("4");
            leads.setTransformationOpportunityId(opportunityId);
        } else {
            leads.setState("7");
        }
        if (convertDto.getAddCustomer().booleanValue()) {
            leads.setCompanyName(convertDto.getCustomerEntity().getCustomerName());
        }
        if (convertDto.getAddContact().booleanValue()) {
            if (StringUtil.isNotBlank((CharSequence)convertDto.getContactEntity().getContactName())) {
                leads.setName(convertDto.getContactEntity().getContactName());
            }
            if (StringUtil.isNotBlank((CharSequence)convertDto.getContactEntity().getMobilePhone())) {
                leads.setMobilePhone(convertDto.getContactEntity().getMobilePhone().replace(" ", ""));
            }
        }
        leads.setTransformationCustomerId(customerId);
        leads.setChangeTime(date);
        leads.setChangePerson(user.getUserId());
        leads.setChangePersonName(user.getUserName());
        this.updateById(leads);
    }

    @Override
    public void convertLeadRecord(Long opportunityId, String opportunityName, Long customerId, Long contactId, LocalDateTime date) {
        ArrayList<Long> typeIds = new ArrayList<Long>();
        typeIds.add(opportunityId);
        typeIds.add(customerId);
        if (HussarUtils.isNotEmpty((Object)contactId)) {
            typeIds.add(contactId);
        }
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setConvertCustomerId(customerId);
        if (HussarUtils.isNotEmpty((Object)contactId)) {
            operateRecordDO.setConvertContactId(contactId);
        }
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFORMATION.getId());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.OPPORTUNITY, opportunityId, opportunityName, date, false, typeIds);
    }

    @Override
    public List<TrackRecordRelationAPIVo> getLeadRelationRecord(Long opportunityId, Long customerId) {
        ArrayList<TrackRecordRelationAPIVo> relationList = new ArrayList<TrackRecordRelationAPIVo>();
        ArrayList<String> produceTypes = new ArrayList<String>();
        produceTypes.add(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        produceTypes.add(RecordProductTypeEnum.PRODUCE_SYSTEM.getId());
        List recordList = this.trackRecordAPIService.list(Collections.singletonList(String.valueOf(opportunityId)), null, produceTypes, "0");
        for (TrackRecordAPIVo list : recordList) {
            TrackRecordRelationAPIVo trackRecordRelation = new TrackRecordRelationAPIVo();
            trackRecordRelation.setRecordId(list.getRecordId());
            trackRecordRelation.setTypeId(customerId);
            relationList.add(trackRecordRelation);
        }
        return relationList;
    }

    private void convertLeadAddTeamMember(LeadConvertDto convertDto, OpportunityEntity opportunityEntity, Long customerId, Long contactId, LocalDateTime date, SecurityUser user) {
        List personIds;
        boolean isNewTeamMember = false;
        List teamMeberEntityList = new ArrayList();
        if (convertDto.getTeamMeber().booleanValue() && !(personIds = (teamMeberEntityList = this.teamMeberMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)opportunityEntity.getOpportunityId())).eq(TeamMeberEntity::getDelFlag, (Object)"0"))).stream().map(TeamMeberEntity::getPersonId).collect(Collectors.toList())).contains(user.getUserId())) {
            isNewTeamMember = true;
        }
        if (convertDto.getAddCustomer().booleanValue()) {
            if (teamMeberEntityList.size() > 0) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    this.addTeamMember(list, customerId, "1", date);
                }
                this.teamMeberService.saveBatch(teamMeberEntityList);
            }
            if (isNewTeamMember || !convertDto.getTeamMeber().booleanValue()) {
                this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), customerId, "1", "0", date, "1");
            }
        }
        if (convertDto.getAddContact().booleanValue()) {
            if (teamMeberEntityList.size() > 0) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    this.addTeamMember(list, contactId, "3", date);
                }
                this.teamMeberService.saveBatch(teamMeberEntityList);
            }
            if (isNewTeamMember || !convertDto.getTeamMeber().booleanValue()) {
                this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), contactId, "1", "0", date, "3");
            }
        }
    }

    private void convertLeadToJqxMessage(LeadConvertDto convertDto, OpportunityEntity opportunityEntity, SecurityUser user, LocalDateTime date) {
        try {
            List<String> focusId = this.focusMapper.selectCreateId("2", opportunityEntity.getOpportunityId());
            List<String> createRole = this.commonService.getRoleNameByUser_Id(opportunityEntity.getCreatePerson());
            if (!(createRole.contains(this.crmProperties.getRoles().getBgLeader()) || createRole.contains(this.crmProperties.getRoles().getSalesGM()) || createRole.contains(this.crmProperties.getRoles().getSalesDirector()) || createRole.contains(this.crmProperties.getRoles().getSalesman()))) {
                String createPersonId = String.valueOf(opportunityEntity.getCreatePerson());
                focusId.removeIf(item -> item.contains(createPersonId));
                String title1 = user.getUserName() + "\u5c06\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u8f6c\u6362\u6210\u5ba2\u6237";
                String content1 = "\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u3010" + opportunityEntity.getOpportunityName() + "\u3011\u5df2\u7531" + user.getDeptName() + "\u7684" + user.getUserName() + "\u8f6c\u6362\u6210\u5ba2\u6237\u3010" + convertDto.getCustomerEntity().getCustomerName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title1, content1, "/crm/kh/khxq", convertDto.getCustomerEntity().getCustomerId().toString(), Collections.singletonList(String.valueOf(opportunityEntity.getCreatePerson())));
                AddSysMessageType addSysMessageType1 = new AddSysMessageType();
                String unifyWebUrl1 = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + convertDto.getCustomerEntity().getCustomerId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType1, content1, date, user, String.valueOf(opportunityEntity.getCreatePerson()), user.getUserName(), unifyWebUrl1, "");
                UnifyUtil.sendMessage(addSysMessageType1);
                String title2 = user.getUserName() + "\u5c06\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u8f6c\u6362\u6210\u8054\u7cfb\u4eba";
                String content2 = "\u60a8\u63d0\u4ea4\u7684\u5546\u673a\u3010" + opportunityEntity.getOpportunityName() + "\u3011\u5df2\u7531" + user.getDeptName() + "\u7684" + user.getUserName() + "\u8f6c\u6362\u6210\u8054\u7cfb\u4eba\u3010" + convertDto.getContactEntity().getContactName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title2, content2, "/crm/lxr/lxrxq", convertDto.getContactEntity().getContactId().toString(), Collections.singletonList(String.valueOf(opportunityEntity.getCreatePerson())));
                AddSysMessageType addSysMessageType2 = new AddSysMessageType();
                String unifyWebUrl2 = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + convertDto.getContactEntity().getContactId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType2, content2, date, user, String.valueOf(opportunityEntity.getCreatePerson()), user.getUserName(), unifyWebUrl2, "");
                UnifyUtil.sendMessage(addSysMessageType2);
            }
            focusId.removeIf(item -> item.contains(user.getUserId().toString()));
            if (ToolUtil.isNotEmpty(focusId)) {
                String title4 = user.getUserName() + "\u5c06\u60a8\u5173\u6ce8\u7684\u5546\u673a\u8f6c\u6362\u6210\u5ba2\u6237";
                String content4 = "\u5546\u673a\u3010" + opportunityEntity.getOpportunityName() + "\u3011\u8f6c\u6362\u4e3a\u5ba2\u6237\u3010" + convertDto.getCustomerEntity().getCustomerName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/kh/khxq", String.valueOf(convertDto.getCustomerEntity().getCustomerId()), focusId);
                AddSysMessageType addSysMessageType4 = new AddSysMessageType();
                String userIdToString4 = StringUtil.join(focusId, (String)",");
                String unifyWebUrl4 = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + convertDto.getCustomerEntity().getCustomerId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType4, content4, date, user, userIdToString4, user.getUserName(), unifyWebUrl4, "");
                UnifyUtil.sendMessage(addSysMessageType4);
                String title6 = user.getUserName() + "\u5c06\u60a8\u5173\u6ce8\u7684\u5546\u673a\u8f6c\u6362\u6210\u8054\u7cfb\u4eba";
                String content6 = "\u5546\u673a\u3010" + opportunityEntity.getOpportunityName() + "\u3011\u8f6c\u6362\u4e3a\u8054\u7cfb\u4eba\u3010" + convertDto.getContactEntity().getContactName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title6, content6, "/crm/lxr/lxrxq", convertDto.getContactEntity().getContactId().toString(), focusId);
                AddSysMessageType addSysMessageType6 = new AddSysMessageType();
                String userIdToString6 = StringUtil.join(focusId, (String)",");
                String unifyWebUrl6 = this.unifyProperties.getCrmUrl() + "/crm/contactDetails?row=" + "\"" + convertDto.getContactEntity().getContactId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType6, content6, date, user, userIdToString6, user.getUserName(), unifyWebUrl6, "");
                UnifyUtil.sendMessage(addSysMessageType6);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> leadsAbandonedTag(String abandonedReason) {
        if (ToolUtil.isEmpty((Object)abandonedReason)) {
            throw new BaseException("\u8bf7\u9009\u62e9\u5e9f\u5f03\u539f\u56e0");
        }
        List<String> abandonedTags = this.leadsMapper.selectAbandonedTag(abandonedReason);
        return abandonedTags;
    }

    private Map<String, Object> autoAssignLead(Long productId, CompanyBaseInfo companyBaseInfo, StringBuilder customerNameKeyWord, OpportunityEntity opportunityEntity) {
        HashMap<String, Object> autoAssignResult = new HashMap<String, Object>();
        ArrayList<CrmProductAssignRuleVo> crmProductAssignRuleVoList = new ArrayList<CrmProductAssignRuleVo>();
        if (productId == null) {
            autoAssignResult.put("resultMsg", "1");
            autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
            return autoAssignResult;
        }
        Map<String, Object> repeatResult = this.repeatOportunity(productId, companyBaseInfo, customerNameKeyWord, opportunityEntity);
        String resultMsg = (String)repeatResult.get("resultMsg");
        if (!"0".equals(resultMsg)) {
            return repeatResult;
        }
        List productAssignRuleList = this.productAssignRuleService.list((Wrapper)new LambdaQueryWrapper().eq(CrmProductAssignRule::getProductId, (Object)productId));
        if (productAssignRuleList.isEmpty()) {
            autoAssignResult.put("resultMsg", "2");
            autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
            return autoAssignResult;
        }
        for (CrmProductAssignRule productAssignRule : productAssignRuleList) {
            CrmProductAssignRuleVo ruleVo = (CrmProductAssignRuleVo)BeanUtil.copy((Object)productAssignRule, CrmProductAssignRuleVo.class);
            List members = this.productAssignRuleMemberService.list((Wrapper)new LambdaQueryWrapper().eq(CrmProductAssignRuleMember::getRuleId, (Object)productAssignRule.getRuleId()));
            assert (ruleVo != null);
            ruleVo.setMemberList(members);
            crmProductAssignRuleVoList.add(ruleVo);
        }
        autoAssignResult.put("resultMsg", "0");
        autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
        return autoAssignResult;
    }

    private Map<String, Object> repeatOportunity(Long productId, CompanyBaseInfo companyBaseInfo, StringBuilder customerNameKeyWord, OpportunityEntity opportunityEntity) {
        List<String> opptyPoolNameList;
        Integer count;
        HashMap<String, Object> autoAssignResult = new HashMap<String, Object>();
        ArrayList crmProductAssignRuleVoList = new ArrayList();
        String opportunityName = opportunityEntity.getOpportunityName();
        String openPool = this.iCrmBaseConfigBoService.getCrmBaseConfigByKey(OpportunityPoolConstant.CONFIG_KEY_OPEN_POOL).getConfigValue();
        if (ToolUtil.isNotEmpty((Object)opportunityEntity.getMobilePhone())) {
            List<String> opptyPoolName;
            autoAssignResult.put("resultMsg", "4");
            autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
            long repeatCountOpportunity = this.opportunityService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OpportunityEntity::getMobilePhone, (Object)opportunityEntity.getMobilePhone())).eq(OpportunityEntity::getDelFlag, (Object)"0"));
            if (repeatCountOpportunity > 0L) {
                return autoAssignResult;
            }
            long repeatCountCustomer = this.customerService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerEntity::getTelephone, (Object)opportunityEntity.getMobilePhone())).eq(CustomerEntity::getDelFlag, (Object)"0"));
            if (repeatCountCustomer > 0L) {
                return autoAssignResult;
            }
            long repeatCountContact = this.contactService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getTelephone, (Object)opportunityEntity.getMobilePhone())).eq(ContactEntity::getDelFlag, (Object)"0"));
            if (repeatCountContact > 0L) {
                return autoAssignResult;
            }
            if ("1".equals(openPool) && HussarUtils.isNotEmpty(opptyPoolName = this.opportunityPoolOppoMapper.repeatOpportunityPoolByMobile(opportunityEntity.getMobilePhone()))) {
                StringBuffer poolName = new StringBuffer();
                for (String s : opptyPoolName) {
                    if (HussarUtils.isNotEmpty((Object)poolName)) {
                        poolName = poolName.append("\u3001").append(s);
                        continue;
                    }
                    poolName = poolName.append(s);
                }
                autoAssignResult.put("resultMsg", "7");
                autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
                autoAssignResult.put("opptyPoolName", poolName.toString());
                return autoAssignResult;
            }
        }
        if (HussarUtils.isNotEmpty((Object)companyBaseInfo) && StringUtil.isNotEmpty((Object)companyBaseInfo.getName())) {
            autoAssignResult.put("resultMsg", "3");
            autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
            long count2 = this.customerService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().and(wrapper -> {
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(CustomerEntity::getCustomerName, (Object)companyBaseInfo.getName())).or()).like(CustomerEntity::getCustomerReferredName, (Object)companyBaseInfo.getName())).or()).like(CustomerEntity::getCustomerAlias, (Object)companyBaseInfo.getName());
                if (HussarUtils.isNotEmpty((Object)companyBaseInfo.getAlias())) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.or()).like(CustomerEntity::getCustomerName, (Object)companyBaseInfo.getAlias())).or()).like(CustomerEntity::getCustomerReferredName, (Object)companyBaseInfo.getAlias())).or()).like(CustomerEntity::getCustomerAlias, (Object)companyBaseInfo.getAlias());
                }
            })).eq(CustomerEntity::getDelFlag, (Object)"0"));
            if (count2 > 0L) {
                return autoAssignResult;
            }
            long countOpportunity = this.opportunityService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().and(wrapper -> {
                wrapper.like(OpportunityEntity::getCustomerName, (Object)companyBaseInfo.getName());
                if (HussarUtils.isNotEmpty((Object)companyBaseInfo.getAlias())) {
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.or()).like(OpportunityEntity::getOpportunityName, (Object)companyBaseInfo.getAlias())).or()).like(OpportunityEntity::getOpportunityName, (Object)companyBaseInfo.getAlias());
                }
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.or()).like(OpportunityEntity::getOpportunityName, (Object)opportunityName.substring(4))).or()).like(OpportunityEntity::getOpportunityName, (Object)companyBaseInfo.getName());
            })).eq(OpportunityEntity::getDelFlag, (Object)"0"));
            if (countOpportunity > 0L) {
                return autoAssignResult;
            }
        }
        if (HussarUtils.isNotEmpty((Object)companyBaseInfo) && StringUtil.isNotEmpty((Object)companyBaseInfo.getName()) && (count = this.opportunityMapper.selectOpportunityCountByCustomerAndProduct(companyBaseInfo.getName(), productId)) > 0) {
            autoAssignResult.put("resultMsg", "3");
            autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
            return autoAssignResult;
        }
        if (HussarUtils.isNotEmpty((Object)companyBaseInfo) && StringUtil.isNotEmpty((Object)companyBaseInfo.getName())) {
            CrmBaseConfigVo configVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("special_customer_name");
            Object[] specialNames = configVo.getConfigValue().split(",");
            if (CollectionUtil.isNotEmpty((Object[])specialNames)) {
                for (Object specialName : specialNames) {
                    if (!companyBaseInfo.getName().contains((CharSequence)specialName)) continue;
                    if (customerNameKeyWord.length() == 0) {
                        customerNameKeyWord.append((String)specialName);
                        continue;
                    }
                    customerNameKeyWord.append("\u3001").append((String)specialName);
                }
            }
            if (customerNameKeyWord != null && HussarUtils.isNotEmpty((Object)customerNameKeyWord.toString())) {
                autoAssignResult.put("resultMsg", "5");
                autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
                return autoAssignResult;
            }
        }
        if ("1".equals(openPool) && (StringUtil.isNotEmpty((Object)companyBaseInfo.getName()) || StringUtil.isNotEmpty((Object)companyBaseInfo.getAlias()) || StringUtil.isNotEmpty((Object)opportunityName)) && HussarUtils.isNotEmpty(opptyPoolNameList = this.opportunityPoolOppoMapper.repeatOpportunityPool(companyBaseInfo.getAlias(), companyBaseInfo.getName(), opportunityName.substring(4)))) {
            StringBuffer poolName = new StringBuffer();
            for (String s : opptyPoolNameList) {
                if (HussarUtils.isNotEmpty((Object)poolName)) {
                    poolName = poolName.append("\u3001").append(s);
                    continue;
                }
                poolName = poolName.append(s);
            }
            autoAssignResult.put("resultMsg", "6");
            autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
            autoAssignResult.put("opptyPoolName", poolName.toString());
            return autoAssignResult;
        }
        autoAssignResult.put("resultMsg", "0");
        autoAssignResult.put("ruleVoList", crmProductAssignRuleVoList);
        return autoAssignResult;
    }

    private void addLeadSendMessage(String opportunityName, String customerName, Long opportunityId, LocalDateTime date, String receiverId, String type, String disputeFlag, String keyWord, String opptyPoolName) {
        String title = "\u7cfb\u7edf\u5c06\u5546\u673a\u5206\u914d\u7ed9\u4f60";
        String content = opportunityName + "\u3010" + customerName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb";
        String contentUnify = "\u3010\u5206\u914d\u63d0\u9192\u3011\u7cfb\u7edf\u5c06\u5546\u673a\u5206\u914d\u7ed9\u4f60\uff0c\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u8bf7\u53ca\u65f6\u8ddf\u8fdb\u3002";
        if ("6".equals(type)) {
            title = "\u7cfb\u7edf\u5c06\u60a8\u52a0\u5165\u5230\u5546\u673a\u56e2\u961f\u6210\u5458\u4e2d";
            content = "\u3010" + opportunityName + "\u3011\uff0c\u53ef\u70b9\u51fb\u67e5\u770b\u8be6\u60c5";
            contentUnify = "\u3010\u56e2\u961f\u52a8\u6001\u3011\u7cfb\u7edf\u5c06\u4f60\u52a0\u5165\u5546\u673a\u56e2\u961f\u6210\u5458\u4e2d\uff0c\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
            if (disputeFlag.equals("1")) {
                title = "\u5206\u914d\u5f02\u5e38\u63d0\u9192";
                content = "\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u672a\u5173\u8054\u4ea7\u54c1\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
                contentUnify = "\u3010\u5206\u914d\u5f02\u5e38\u63d0\u9192\u3011\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u672a\u5173\u8054\u4ea7\u54c1\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
            } else if (disputeFlag.equals("4")) {
                title = "\u5206\u914d\u5f02\u5e38\u63d0\u9192";
                content = "\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u624b\u673a\u53f7\u91cd\u590d\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
                contentUnify = "\u3010\u5206\u914d\u5f02\u5e38\u63d0\u9192\u3011\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u624b\u673a\u53f7\u91cd\u590d\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
            } else if (disputeFlag.equals("3")) {
                title = "\u5206\u914d\u5f02\u5e38\u63d0\u9192";
                content = "\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u5ba2\u6237/\u5546\u673a\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
                contentUnify = "\u3010\u5206\u914d\u5f02\u5e38\u63d0\u9192\u3011\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u5ba2\u6237\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
            } else if (disputeFlag.equals("5")) {
                title = "\u5206\u914d\u5f02\u5e38\u63d0\u9192";
                content = "\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u5305\u542b\u5173\u952e\u8bcd\uff1a" + keyWord;
                contentUnify = "\u3010\u5206\u914d\u5f02\u5e38\u63d0\u9192\u3011\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u5305\u542b\u5173\u952e\u8bcd\uff1a" + keyWord;
            } else if (disputeFlag.equals("7")) {
                title = "\u5206\u914d\u5f02\u5e38\u63d0\u9192";
                content = "\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u624b\u673a\u53f7\u5728\u3010" + opptyPoolName + "\u3011\u516c\u6d77\u6c60\u4e2d\u91cd\u590d\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
                contentUnify = "\u3010\u5206\u914d\u5f02\u5e38\u63d0\u9192\u3011\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u624b\u673a\u53f7\u5728\u3010" + opptyPoolName + "\u3011\u516c\u6d77\u6c60\u4e2d\u91cd\u590d\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
            } else if (disputeFlag.equals("6")) {
                title = "\u5206\u914d\u5f02\u5e38\u63d0\u9192";
                content = "\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u5ba2\u6237/\u5546\u673a\u540d\u79f0\u5728\u3010" + opptyPoolName + "\u3011\u516c\u6d77\u6c60\u4e2d\u91cd\u590d\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
                contentUnify = "\u3010\u5206\u914d\u5f02\u5e38\u63d0\u9192\u3011\u5546\u673a\u540d\u79f0\u3010" + opportunityName + "\u3011\uff0c\u81ea\u52a8\u5206\u914d\u5f02\u5e38\uff0c\u5f02\u5e38\u539f\u56e0\uff1a\u5ba2\u6237/\u5546\u673a\u540d\u79f0\u5728\u3010" + opptyPoolName + "\u3011\u516c\u6d77\u6c60\u4e2d\u91cd\u590d\uff0c\u8bf7\u4eba\u5de5\u5904\u7406\u3002";
            }
        }
        EimPushUtil.pushJqxArticleMessage(title, content, "/crm/sj/sjxq/xxzl", opportunityId.toString(), Arrays.asList(receiverId));
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunityId + "\"";
        SysUsers sysUsers = (SysUsers)this.sysUsersService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)"superadmin"));
        SecurityUser user = new SecurityUser();
        user.setUserId(sysUsers.getId());
        user.setDeptId(sysUsers.getDepartmentId());
        UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, receiverId, "\u7cfb\u7edf", unifyWebUrl, "");
        UnifyUtil.sendMessage(addSysMessageType);
    }

    @Override
    public Leads formQuery(String leadsId) {
        try {
            Leads leads = (Leads)this.getById((Serializable)((Object)leadsId));
            if (leads != null && StringUtil.isNotBlank((CharSequence)leads.getProductId())) {
                String[] products = leads.getProductId().split(",");
                List productList = this.productService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Product::getProductId, Product::getProductName}).in(Product::getProductId, Arrays.stream(products).toArray())).orderByAsc(Product::getCreateTime));
                String productName = "";
                for (Product product : productList) {
                    productName = productName + "," + product.getProductName();
                }
                if (productName.length() > 0) {
                    productName = productName.substring(1);
                }
                leads.setProductName(productName);
                leads.setProductList(productList);
            }
            return leads;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u8868\u5355\u67e5\u8be2\u5931\u8d25");
        }
    }

    @Override
    @HussarTransactional
    public ApiResponse<String> insertOrUpdate(Leads leads) {
        try {
            SecurityUser user = BaseSecurityUtil.getUser();
            Leads oldLeads = (Leads)this.getById(leads.getLeadsId());
            if (ToolUtil.isNotEmpty((Object)leads.getProductId())) {
                List<Long> businessIds;
                List<Map<String, Object>> productManagers;
                List<String> newProdcutIds = Arrays.asList(leads.getProductId().split(","));
                List<Object> oldProductIds = new ArrayList();
                if (ToolUtil.isNotEmpty((Object)oldLeads.getProductId())) {
                    oldProductIds = Arrays.asList(oldLeads.getProductId().split(","));
                }
                List<Object> productIds = new ArrayList();
                if (CollectionUtil.isNotEmpty(oldProductIds)) {
                    for (int i = 0; i < newProdcutIds.size(); ++i) {
                        if (oldProductIds.contains(newProdcutIds.get(i))) continue;
                        productIds.add(newProdcutIds.get(i));
                    }
                } else {
                    productIds = newProdcutIds;
                }
                if (ToolUtil.isNotEmpty(productIds) && CollectionUtil.isNotEmpty(productManagers = this.teamMeberMapper.selectProductTeamMemberByBusinessId(businessIds = productIds.stream().map(Long::valueOf).collect(Collectors.toList()), "0"))) {
                    ArrayList<String> list = new ArrayList<String>();
                    for (int i = 0; i < productManagers.size(); ++i) {
                        if (list.contains(String.valueOf(productManagers.get(i).get("personId")))) continue;
                        list.add(String.valueOf(productManagers.get(i).get("personId")));
                        String title = "\u3010" + productManagers.get(i).get("productName") + "\u3011\u7ebf\u7d22\u63d0\u9192";
                        String content = user.getDeptName() + "-" + user.getUserName() + "\u5c06\u4ea7\u54c1\u3010" + productManagers.get(i).get("productName") + "\u3011\u5173\u8054\u5230\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011";
                        EimPushUtil.pushJqxArticleMessage(title, content, "/crm/schd/xsxq", String.valueOf(leads.getLeadsId()), Arrays.asList(String.valueOf(productManagers.get(i).get("personId"))));
                    }
                }
            }
            leads.setMobilePhone(leads.getMobilePhone().replace(" ", ""));
            leads.setTelephone(leads.getTelephone().replace(" ", ""));
            leads.setTrackTime(null);
            StringBuilder sb = new StringBuilder();
            if (ToolUtil.isEmpty((Object)leads.getProvince())) {
                leads.setProvince(null);
            } else {
                SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(leads.getProvince()));
                if (ToolUtil.isNotEmpty((Object)province)) {
                    sb.append(province.getName());
                }
            }
            if (ToolUtil.isEmpty((Object)leads.getCity())) {
                leads.setCity(null);
            } else {
                SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(leads.getCity()));
                if (ToolUtil.isNotEmpty((Object)city)) {
                    sb.append("/").append(city.getName());
                }
            }
            if (ToolUtil.isEmpty((Object)leads.getCounty())) {
                leads.setCounty(null);
            } else {
                SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(leads.getCounty()));
                if (ToolUtil.isNotEmpty((Object)county)) {
                    sb.append("/").append(county.getName());
                }
            }
            leads.setRegionLabel(sb.toString());
            this.saveOrUpdate(leads);
            return ApiResponse.success((Object)String.valueOf(leads.getLeadsId()), (String)"");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new HussarException("\u65b0\u589e\u6216\u4fee\u6539\u5931\u8d25");
        }
    }

    private TeamMeberEntity leadsSeaSaveTeamMember(SecurityUser user, LocalDateTime date, long businessId, Integer sales) {
        TeamMeberEntity teamMeberEntity = new TeamMeberEntity();
        teamMeberEntity.setTeamMeberName(user.getUserName());
        teamMeberEntity.setPersonId(user.getUserId());
        teamMeberEntity.setBusinessId(businessId);
        teamMeberEntity.setBusinessType("4");
        teamMeberEntity.setModifyPower("1");
        if (sales == 0) {
            teamMeberEntity.setIsCharge("0");
        } else {
            teamMeberEntity.setIsCharge("1");
        }
        teamMeberEntity.setCreatePerson(user.getUserId());
        teamMeberEntity.setCreatePersonName(user.getUserName());
        teamMeberEntity.setCreateTime(date);
        if ("0".equals(teamMeberEntity.getIsCharge())) {
            if ("4".equals(teamMeberEntity.getBusinessType())) {
                teamMeberEntity.setMemberRole("7");
            } else {
                teamMeberEntity.setMemberRole("6");
            }
        }
        teamMeberEntity.setOwnDepartment(user.getDeptId());
        teamMeberEntity.setOwnDepartmentName(user.getDeptName());
        teamMeberEntity.setUpdatePerson(user.getUserId());
        teamMeberEntity.setUpdateTime(date);
        teamMeberEntity.setUpdatePersonName(user.getUserName());
        teamMeberEntity.setDelFlag("0");
        return teamMeberEntity;
    }

    private OperateRecordAPIVo leadsSeaSaveTrackRecord(SecurityUser user, LocalDateTime date, long businessId, String businessName) {
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setBusinessType(CrmBusinessTypeEnum.LEADS_ORIGIN.getId());
        operateRecordDO.setTypeId(Long.valueOf(businessId));
        operateRecordDO.setBusinessName(businessName);
        operateRecordDO.setCreatePerson(user.getUserId());
        operateRecordDO.setCreatePersonName(user.getUserName());
        operateRecordDO.setCreateTime(date);
        operateRecordDO.setChangePerson(user.getUserId());
        operateRecordDO.setChangeTime(date);
        operateRecordDO.setChangePersonName(user.getUserName());
        operateRecordDO.setDelflag("0");
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        return operateRecordDO;
    }

    private SalesStatisticsDto leadsOperate(LeadsDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if ("1".equals(dto.getLeadsView())) {
            IndexUtil.currentUserRolePermissions(permissionDto, this.crmProperties);
        }
        return permissionDto;
    }

    private LeadsDto leadsQueryCondition(LeadsDto dto) {
        List<Long> otherProvinceIds;
        String leadsView = dto.getLeadsView();
        if ("2".equals(leadsView)) {
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if ("3".equals(leadsView)) {
            dto.setState("5");
        }
        if ("4".equals(leadsView)) {
            dto.setState("4");
        }
        if ("5".equals(leadsView)) {
            dto.setState("6");
        }
        if ("6".equals(leadsView)) {
            dto.setState("1");
        }
        if ("8".equals(leadsView)) {
            dto.setState("7");
        }
        dto.setDelFlag("0");
        SecurityUser user = BaseSecurityUtil.getUser();
        dto.setCurrentUserId(user.getUserId());
        if ("1".equals(dto.getCreateTimeFlag()) || "2".equals(dto.getCreateTimeFlag())) {
            DateConvertVo dateConvertVo = IndexUtil.getCurrentTime(dto.getCreateTimeFlag());
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (CollectionUtil.isNotEmpty(dto.getProvinces()) && dto.getProvinces().contains(99L) && CollectionUtil.isNotEmpty(otherProvinceIds = this.commonMapper.selectOtherProvince())) {
            otherProvinceIds.addAll(dto.getProvinces());
            dto.setProvinces(otherProvinceIds);
        }
        return dto;
    }

    private List<LeadsOrigin> dictionaryTranslate(List<LeadsOrigin> list) {
        List dicLeadsLevel = this.sysDicRefService.getDicListByType("leads_level");
        List dicLeadsState = this.sysDicRefService.getDicListByType("leads_state");
        List dicLeadsSource = this.sysDicRefService.getDicListByType("leads_source");
        List<Map<String, Object>> getAllSecordStru = this.commonService.getAllSecondStru();
        List<Map<String, Long>> struList = DataPermission.getStruCache();
        List labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.LEAD.getModuleId());
        for (LeadsOrigin leads : list) {
            if (ToolUtil.isNotEmpty((Object)leads.getLevelNew())) {
                for (DicVo dicVo : dicLeadsLevel) {
                    if (!leads.getLevelNew().equals(dicVo.getValue())) continue;
                    leads.setLevelNew(dicVo.getLabel());
                    break;
                }
            }
            if (ToolUtil.isNotEmpty((Object)leads.getState())) {
                for (DicVo dicVo : dicLeadsState) {
                    if (!leads.getState().equals(dicVo.getValue())) continue;
                    leads.setState(dicVo.getLabel());
                    break;
                }
            }
            if (ToolUtil.isNotEmpty((Object)leads.getLeadsOrigin())) {
                for (DicVo dicVo : dicLeadsSource) {
                    if (!leads.getLeadsOrigin().equals(dicVo.getValue())) continue;
                    leads.setLeadsOrigin(dicVo.getLabel());
                    break;
                }
            }
            if (ToolUtil.isNotEmpty((Object)leads.getFindTime())) {
                leads.setFindDate(leads.getFindTime().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")));
            }
            leads.setLabelName(CrmLabelUtil.getLabelName(labelList, leads.getLabelId()));
        }
        return list;
    }

    @Override
    @Transactional
    public LeadConvertDto convertCustomer(LeadConvertDto convertDto) {
        OpportunityEntity opportunityEntity;
        String customerName;
        CustomerEntity customerEntity;
        Long customerId;
        Leads leads = (Leads)this.getById(convertDto.getLeadId());
        if (leads == null) {
            throw new BaseException("\u8f6c\u6362\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        if ("4".equals(leads.getState()) || "7".equals(leads.getState())) {
            throw new BaseException("\u8be5\u7ebf\u7d22\u5df2\u8f6c\u6362");
        }
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        this.defaultValueLeads(convertDto);
        Long contactId = null;
        Long opportunityId = null;
        if (convertDto.getAddCustomer().booleanValue()) {
            customerId = Long.valueOf(CommonUtills.generateAssignId());
            customerEntity = convertDto.getCustomerEntity();
            customerEntity.setCustomerId(customerId);
            this.defaultCustomer(customerEntity, date, user, null);
            this.customerService.save(customerEntity);
            convertDto.setCustomerEntity(customerEntity);
            customerName = customerEntity.getCustomerName();
            OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
            operateRecordAPIVo.setSourceType("3");
            JSONObject sourceDescriptionJSON = new JSONObject();
            sourceDescriptionJSON.put("sourceBusinessId", (Object)leads.getLeadsId());
            sourceDescriptionJSON.put("sourceBusinessName", (Object)leads.getLeadsName());
            sourceDescriptionJSON.put("sourceBusinessType", (Object)CrmBusinessTypeEnum.LEADS.getId());
            operateRecordAPIVo.setSourceDescription(JSONObject.toJSONString((Object)sourceDescriptionJSON));
            this.operateRecordAPIService.saveOperateLog(operateRecordAPIVo, CrmBusinessTypeEnum.CUSTOMER, customerId, customerName, date, false, null);
        } else {
            customerEntity = (CustomerEntity)this.customerService.getById(convertDto.getCustomerEntity().getCustomerId());
            if (ToolUtil.isEmpty((Object)customerEntity)) {
                throw new BaseException("\u6240\u9009\u5ba2\u6237\u4e0d\u5b58\u5728");
            }
            convertDto.setCustomerEntity(customerEntity);
            customerId = customerEntity.getCustomerId();
            customerName = customerEntity.getCustomerName();
        }
        if (convertDto.getAddContact().booleanValue()) {
            contactId = Long.valueOf(CommonUtills.generateAssignId());
            ContactEntity contactEntity = convertDto.getContactEntity();
            contactEntity.setContactId(contactId);
            contactEntity.setCustomerId(customerId);
            contactEntity.setCustomerName(customerName);
            this.defaultContact(contactEntity, date, user, null);
            this.contactService.save(contactEntity);
            OperateRecordAPIVo operateRecordAPIVo2 = new OperateRecordAPIVo();
            operateRecordAPIVo2.setSourceType("3");
            JSONObject sourceDescriptionJSON2 = new JSONObject();
            sourceDescriptionJSON2.put("sourceBusinessId", (Object)leads.getLeadsId());
            sourceDescriptionJSON2.put("sourceBusinessName", (Object)leads.getLeadsName());
            sourceDescriptionJSON2.put("sourceBusinessType", (Object)CrmBusinessTypeEnum.LEADS.getId());
            operateRecordAPIVo2.setSourceDescription(JSONObject.toJSONString((Object)sourceDescriptionJSON2));
            this.operateRecordAPIService.saveOperateLog(operateRecordAPIVo2, CrmBusinessTypeEnum.CONTACT, contactId, contactEntity.getContactName(), date, false, null);
        }
        if (convertDto.getOpportunity().booleanValue() && convertDto.getAddOpportunity().booleanValue()) {
            opportunityId = Long.parseLong(CommonUtills.generateAssignId());
            opportunityEntity = (OpportunityEntity)BeanUtil.copy((Object)convertDto.getOpportunityEntityDto(), OpportunityEntity.class);
            assert (opportunityEntity != null);
            customerId = convertDto.getOpportunityEntityDto().getCustomerId();
            opportunityEntity.setOpportunityId(opportunityId);
            opportunityEntity.setCustomerId(customerId);
            opportunityEntity.setOriginLeads(leads.getLeadsId());
            this.defaultOpportunityEntity(opportunityEntity, date, user, null);
            this.opportunityService.save(opportunityEntity);
            if (CollectionUtil.isNotEmpty(convertDto.getOpportunityEntityDto().getProductList())) {
                for (OpportunityProduct product : convertDto.getOpportunityEntityDto().getProductList()) {
                    product.setOpportunityId(opportunityEntity.getOpportunityId());
                    product.setOpportunityName(opportunityEntity.getOpportunityName());
                    product.setStandardPrice(product.getProductPrice());
                    if (StringUtil.isEmpty((Object)product.getSellPrice())) {
                        product.setSellPrice("0.00");
                    }
                    if (StringUtil.isEmpty((Object)product.getDiscount())) {
                        product.setDiscount("100");
                    }
                    if (StringUtil.isEmpty((Object)product.getProductNumber())) {
                        product.setProductNumber("1");
                    }
                    if (StringUtil.isEmpty((Object)product.getProductSubtotal())) {
                        product.setProductSubtotal("0.00");
                    }
                    if (!StringUtil.isEmpty((Object)product.getTotalPrice())) continue;
                    product.setTotalPrice("0.00");
                }
                this.opportunityProductService2.saveOpportunityProduct(convertDto.getOpportunityEntityDto().getProductList(), false, false);
            }
            convertDto.setOpportunityEntityDto((OpportunityEntityDto)BeanUtil.copy((Object)opportunityEntity, OpportunityEntityDto.class));
        } else if (convertDto.getOpportunity().booleanValue()) {
            opportunityId = convertDto.getOpportunityEntityDto().getOpportunityId();
            opportunityEntity = (OpportunityEntity)this.opportunityService.getById(opportunityId);
            convertDto.setOpportunityEntityDto((OpportunityEntityDto)BeanUtil.copy((Object)opportunityEntity, OpportunityEntityDto.class));
        }
        this.updateConvertLead(convertDto, leads, customerId, contactId, opportunityId, date, user);
        this.convertLeadRecord(leads.getLeadsId(), leads.getLeadsName(), customerId, contactId, convertDto.getOpportunity() != false ? opportunityId : null, date);
        List<TrackRecordRelationAPIVo> recordRelationList = this.getLeadRelationRecord(leads.getLeadsId(), customerId, convertDto.getRecordToCustomer(), opportunityId, convertDto.getRecordToOpportunity() != false && convertDto.getOpportunity() != false);
        this.trackRecordRelationAPIService.saveBatch(recordRelationList);
        this.convertLeadAddTeamMember(convertDto, leads, customerId, contactId, opportunityId, date, user);
        Thread thread = new Thread(() -> this.convertLeadToJqxMessage(convertDto, leads, user, date));
        thread.start();
        return convertDto;
    }

    private void defaultValueLeads(LeadConvertDto convertDto) {
        if (convertDto.getAddCustomer() == null) {
            convertDto.setAddCustomer(false);
        }
        if (convertDto.getAddContact() == null) {
            convertDto.setAddContact(false);
        }
        if (convertDto.getOpportunity() == null) {
            convertDto.setOpportunity(false);
        }
        if (convertDto.getAddOpportunity() == null) {
            convertDto.setAddOpportunity(false);
        }
        if (convertDto.getTeamMeber() == null) {
            convertDto.setTeamMeber(false);
        }
        if (convertDto.getRecordToOpportunity() == null) {
            convertDto.setRecordToOpportunity(true);
        }
    }

    private void defaultCustomer(CustomerEntity customerEntity, LocalDateTime date, SecurityUser user, SysStru unit) {
        customerEntity.setTelephone(customerEntity.getTelephone().replaceAll(" ", ""));
        customerEntity.setCreatePerson(user.getUserId());
        customerEntity.setCreatePersonName(user.getUserName());
        customerEntity.setCreateTime(date);
        customerEntity.setDelFlag("0");
        customerEntity.setChargePersonId(user.getUserId());
        customerEntity.setChargePersonName(user.getUserName());
        customerEntity.setCreateDepartment(user.getDeptId());
        customerEntity.setCreateDepartmentName(user.getDeptName());
        customerEntity.setOwnDepartment(user.getDeptId());
        customerEntity.setOwnDepartmentName(user.getDeptName());
        customerEntity.setChangePerson(user.getUserId());
        customerEntity.setChangePersonName(user.getUserName());
        customerEntity.setChangeTime(date);
        StringBuilder sb = new StringBuilder();
        if (ToolUtil.isEmpty((Object)customerEntity.getProvince())) {
            customerEntity.setProvince(null);
        } else {
            SysRegion province = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerEntity.getProvince()));
            if (ToolUtil.isNotEmpty((Object)province)) {
                sb.append(province.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)customerEntity.getCity())) {
            customerEntity.setCity(null);
        } else {
            SysRegion city = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerEntity.getCity()));
            if (ToolUtil.isNotEmpty((Object)city)) {
                sb.append("/").append(city.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)customerEntity.getCounty())) {
            customerEntity.setCounty(null);
        } else {
            SysRegion county = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)Long.valueOf(customerEntity.getCounty()));
            if (ToolUtil.isNotEmpty((Object)county)) {
                sb.append("/").append(county.getName());
            }
        }
        if (ToolUtil.isEmpty((Object)customerEntity.getRegionLabel())) {
            customerEntity.setRegionLabel(null);
        } else {
            customerEntity.setRegionLabel(sb.toString());
        }
    }

    private void defaultContact(ContactEntity contactEntity, LocalDateTime date, SecurityUser user, SysStru unit) {
        contactEntity.setDelFlag("0");
        if (StringUtil.isNotBlank((CharSequence)contactEntity.getMobilePhone())) {
            contactEntity.setMobilePhone(contactEntity.getMobilePhone().replace(" ", ""));
        }
        if (StringUtil.isNotBlank((CharSequence)contactEntity.getTelephone())) {
            contactEntity.setTelephone(contactEntity.getTelephone().replace(" ", ""));
        }
        contactEntity.setCreatePerson(user.getUserId());
        contactEntity.setCreatePersonName(user.getUserName());
        contactEntity.setCreateTime(date);
        contactEntity.setChargePersonId(user.getUserId());
        contactEntity.setChargePersonName(user.getUserName());
        contactEntity.setCreateDepartment(user.getDeptId());
        contactEntity.setCreateDepartmentName(user.getDeptName());
        contactEntity.setOwnDepartment(user.getDeptId());
        contactEntity.setOwnDepartmentName(user.getDeptName());
        contactEntity.setChangePerson(user.getUserId());
        contactEntity.setChangePersonName(user.getUserName());
        contactEntity.setChangeTime(date);
    }

    private void defaultOpportunityEntity(OpportunityEntity opportunityEntity, LocalDateTime date, SecurityUser user, SysStru unit) {
        opportunityEntity.setDelFlag("0");
        opportunityEntity.setState("1");
        opportunityEntity.setCreateTime(date);
        opportunityEntity.setCreateDepartment(user.getDeptId());
        opportunityEntity.setCreateDepartmentName(user.getDeptName());
        opportunityEntity.setCreatePerson(user.getUserId());
        opportunityEntity.setCreatePersonName(user.getUserName());
        opportunityEntity.setChargePersonId(user.getUserId());
        opportunityEntity.setChargePersonName(user.getUserName());
        opportunityEntity.setOwnDepartment(user.getDeptId());
        opportunityEntity.setOwnDepartmentName(user.getDeptName());
        opportunityEntity.setDelFlag("0");
        opportunityEntity.setChangeTime(date);
        opportunityEntity.setChangePerson(user.getUserId());
        opportunityEntity.setChangePersonName(user.getUserName());
        OpportunityUtil.singleOpportunityNo(opportunityEntity);
    }

    private void convertLeadRecord(Long leadId, String leadName, Long customerId, Long contactId, Long opportunityId, LocalDateTime date) {
        ArrayList<Long> typeIds = new ArrayList<Long>();
        typeIds.add(leadId);
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        if (customerId != null) {
            typeIds.add(customerId);
            operateRecordDO.setConvertCustomerId(customerId);
        }
        if (contactId != null) {
            typeIds.add(contactId);
            operateRecordDO.setConvertContactId(contactId);
        }
        if (opportunityId != null) {
            operateRecordDO.setConvertOpporId(opportunityId);
            typeIds.add(opportunityId);
        }
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_TRANSFORMATION.getId());
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS, leadId, leadName, date, false, typeIds);
    }

    private List<TrackRecordRelationAPIVo> getLeadRelationRecord(Long leadId, Long customerId, boolean customerFlag, Long opportunityId, boolean opportunityFlag) {
        ArrayList<TrackRecordRelationAPIVo> relationList = new ArrayList<TrackRecordRelationAPIVo>();
        ArrayList<String> produceTypes = new ArrayList<String>();
        produceTypes.add(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        produceTypes.add(RecordProductTypeEnum.PRODUCE_SYSTEM.getId());
        List recordList = this.trackRecordAPIService.list(Collections.singletonList(String.valueOf(leadId)), null, produceTypes, "0");
        for (TrackRecordAPIVo list : recordList) {
            if (customerFlag) {
                TrackRecordRelationAPIVo trackRecordRelation = new TrackRecordRelationAPIVo();
                trackRecordRelation.setRecordId(list.getRecordId());
                trackRecordRelation.setTypeId(customerId);
                relationList.add(trackRecordRelation);
            }
            if (!opportunityFlag) continue;
            TrackRecordRelationAPIVo trackRecordRelation2 = new TrackRecordRelationAPIVo();
            trackRecordRelation2.setRecordId(list.getRecordId());
            trackRecordRelation2.setTypeId(opportunityId);
            relationList.add(trackRecordRelation2);
        }
        return relationList;
    }

    private void convertLeadAddTeamMember(LeadConvertDto convertDto, Leads leads, Long customerId, Long contactId, Long opportunityId, LocalDateTime date, SecurityUser user) {
        boolean isNewTeamMember = false;
        List<TeamMeberEntity> teamMeberEntityList = new ArrayList();
        if (convertDto.getTeamMeber().booleanValue()) {
            teamMeberEntityList = this.teamMeberMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)leads.getLeadsId())).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
            isNewTeamMember = this.updateTeamMeberInfo(leads, teamMeberEntityList, isNewTeamMember);
        }
        if (convertDto.getAddCustomer().booleanValue()) {
            if (teamMeberEntityList.size() > 0) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    this.addTeamMember(list, customerId, "1", date);
                }
                this.teamMeberService.saveBatch(teamMeberEntityList);
            }
            if (isNewTeamMember || !convertDto.getTeamMeber().booleanValue()) {
                this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), customerId, "1", "1", date, "1");
            }
        }
        if (convertDto.getAddContact().booleanValue()) {
            if (teamMeberEntityList.size() > 0) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    this.addTeamMember(list, contactId, "3", date);
                }
                this.teamMeberService.saveBatch(teamMeberEntityList);
            }
            if (isNewTeamMember || !convertDto.getTeamMeber().booleanValue()) {
                this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), contactId, "1", "1", date, "3");
            }
        }
        if (convertDto.getOpportunity().booleanValue() && convertDto.getAddOpportunity().booleanValue()) {
            if (teamMeberEntityList.size() > 0) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    this.addTeamMember(list, opportunityId, "2", date);
                }
                this.teamMeberService.saveBatch(teamMeberEntityList);
            }
            if (isNewTeamMember || !convertDto.getTeamMeber().booleanValue()) {
                this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), opportunityId, "1", "1", date, "2");
            }
        }
    }

    private void convertLeadToJqxMessage(LeadConvertDto convertDto, Leads leads, SecurityUser user, LocalDateTime date) {
        try {
            List<String> focusId = this.focusMapper.selectCreateId("4", leads.getLeadsId());
            List<String> createRole = this.commonService.getRoleNameByUser_Id(leads.getCreatePerson());
            if (!(createRole.contains(this.crmProperties.getRoles().getBgLeader()) || createRole.contains(this.crmProperties.getRoles().getSalesGM()) || createRole.contains(this.crmProperties.getRoles().getSalesDirector()) || createRole.contains(this.crmProperties.getRoles().getSalesman()))) {
                String createPersonId = String.valueOf(leads.getCreatePerson());
                focusId.removeIf(item -> item.contains(createPersonId));
                String title1 = user.getUserName() + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5ba2\u6237";
                String content1 = "\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + user.getDeptName() + "\u7684" + user.getUserName() + "\u8f6c\u6362\u6210\u5ba2\u6237\u3010" + convertDto.getCustomerEntity().getCustomerName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title1, content1, "/crm/kh/khxq", convertDto.getCustomerEntity().getCustomerId().toString(), Collections.singletonList(String.valueOf(leads.getCreatePerson())));
                AddSysMessageType addSysMessageType1 = new AddSysMessageType();
                String unifyWebUrl1 = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + convertDto.getCustomerEntity().getCustomerId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType1, content1, date, user, String.valueOf(leads.getCreatePerson()), user.getUserName(), unifyWebUrl1, "");
                UnifyUtil.sendMessage(addSysMessageType1);
                String title2 = user.getUserName() + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u8054\u7cfb\u4eba";
                String content2 = "\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + user.getDeptName() + "\u7684" + user.getUserName() + "\u8f6c\u6362\u6210\u8054\u7cfb\u4eba\u3010" + convertDto.getContactEntity().getContactName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title2, content2, "/crm/lxr/lxrxq", convertDto.getContactEntity().getContactId().toString(), Collections.singletonList(String.valueOf(leads.getCreatePerson())));
                AddSysMessageType addSysMessageType2 = new AddSysMessageType();
                String unifyWebUrl2 = this.unifyProperties.getCrmUrl() + "/crm/contactDetails?row=" + "\"" + convertDto.getContactEntity().getContactId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType2, content2, date, user, String.valueOf(leads.getCreatePerson()), user.getUserName(), unifyWebUrl2, "");
                UnifyUtil.sendMessage(addSysMessageType2);
                if (convertDto.getOpportunity().booleanValue()) {
                    String title3 = user.getUserName() + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5546\u673a";
                    String content3 = "\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + user.getDeptName() + "\u7684" + user.getUserName() + "\u8f6c\u6362\u6210\u5546\u673a\u3010" + convertDto.getOpportunityEntityDto().getOpportunityName() + "\u3011";
                    EimPushUtil.pushJqxArticleMessage(title3, content3, "/crm/sj/sjxq/xxzl", convertDto.getOpportunityEntityDto().getOpportunityId().toString(), Collections.singletonList(String.valueOf(leads.getCreatePerson())));
                    AddSysMessageType addSysMessageType3 = new AddSysMessageType();
                    String unifyWebUrl3 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + convertDto.getOpportunityEntityDto().getOpportunityId() + "\"";
                    UnifyUtil.defaultMessage(addSysMessageType3, content3, date, user, String.valueOf(leads.getCreatePerson()), user.getUserName(), unifyWebUrl3, "");
                    UnifyUtil.sendMessage(addSysMessageType3);
                }
            }
            focusId.removeIf(item -> item.contains(user.getUserId().toString()));
            if (ToolUtil.isNotEmpty(focusId)) {
                String title4 = user.getUserName() + "\u5c06\u60a8\u5173\u6ce8\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5ba2\u6237";
                String content4 = "\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u8f6c\u6362\u4e3a\u5ba2\u6237\u3010" + convertDto.getCustomerEntity().getCustomerName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/kh/khxq", String.valueOf(convertDto.getCustomerEntity().getCustomerId()), focusId);
                AddSysMessageType addSysMessageType4 = new AddSysMessageType();
                String unifyWebUrl4 = this.unifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + convertDto.getCustomerEntity().getCustomerId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType4, content4, date, user, String.valueOf(leads.getCreatePerson()), user.getUserName(), unifyWebUrl4, "");
                UnifyUtil.sendMessage(addSysMessageType4);
                String title6 = user.getUserName() + "\u5c06\u60a8\u5173\u6ce8\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u8054\u7cfb\u4eba";
                String content6 = "\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u8f6c\u6362\u4e3a\u8054\u7cfb\u4eba\u3010" + convertDto.getContactEntity().getContactName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title6, content6, "/crm/lxr/lxrxq", convertDto.getContactEntity().getContactId().toString(), focusId);
                AddSysMessageType addSysMessageType6 = new AddSysMessageType();
                String unifyWebUrl6 = this.unifyProperties.getCrmUrl() + "/crm/contactDetails?row=" + "\"" + convertDto.getContactEntity().getContactId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType6, content6, date, user, String.valueOf(leads.getCreatePerson()), user.getUserName(), unifyWebUrl6, "");
                UnifyUtil.sendMessage(addSysMessageType6);
                if (convertDto.getOpportunity().booleanValue()) {
                    String title5 = user.getUserName() + "\u5c06\u60a8\u5173\u6ce8\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5546\u673a";
                    String content5 = "\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u8f6c\u6362\u4e3a\u5546\u673a\u3010" + convertDto.getOpportunityEntityDto().getOpportunityName() + "\u3011";
                    EimPushUtil.pushJqxArticleMessage(title5, content5, "/crm/sj/sjxq/xxzl", String.valueOf(convertDto.getOpportunityEntityDto().getOpportunityId()), focusId);
                    AddSysMessageType addSysMessageType5 = new AddSysMessageType();
                    String unifyWebUrl5 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + convertDto.getOpportunityEntityDto().getOpportunityId() + "\"";
                    UnifyUtil.defaultMessage(addSysMessageType5, content5, date, user, String.valueOf(leads.getCreatePerson()), user.getUserName(), unifyWebUrl5, "");
                    UnifyUtil.sendMessage(addSysMessageType5);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean updateTeamMeberInfo(Leads leads, List<TeamMeberEntity> teamMeberEntityList, boolean isNewTeamMember) {
        block5: {
            SecurityUser user = BaseSecurityUtil.getUser();
            Long userId = user.getUserId();
            if (leads.getChargePersonId().equals(userId)) break block5;
            List personIds = teamMeberEntityList.stream().map(TeamMeberEntity::getPersonId).collect(Collectors.toList());
            if (personIds.contains(userId)) {
                for (TeamMeberEntity list : teamMeberEntityList) {
                    if (list.getIsCharge().equals("1")) {
                        list.setMemberRole("6");
                        list.setIsCharge("0");
                    }
                    if (!list.getPersonId().equals(userId)) continue;
                    list.setIsCharge("1");
                    list.setMemberRole(null);
                }
            } else {
                isNewTeamMember = true;
                for (TeamMeberEntity list : teamMeberEntityList) {
                    if (!list.getIsCharge().equals("1")) continue;
                    list.setMemberRole("6");
                    list.setIsCharge("0");
                }
            }
        }
        return isNewTeamMember;
    }

    @Override
    @Transactional
    public boolean abandonedLeads(List<LeadsDto> leadsDtoList) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (CollectionUtil.isEmpty(leadsDtoList)) {
            throw new BaseException("\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u7ebf\u7d22");
        }
        List leadsIdList = leadsDtoList.stream().map(LeadsDto::getLeadsId).filter(ToolUtil::isNotEmpty).collect(Collectors.toList());
        List leadsStateList = leadsDtoList.stream().map(LeadsDto::getState).filter(ToolUtil::isNotEmpty).collect(Collectors.toList());
        for (String leadsState : leadsStateList) {
            if ("6".equals(leadsState)) {
                throw new BaseException("\u9009\u4e2d\u9879\u4e0d\u80fd\u5305\u542b\u201c\u5df2\u5e9f\u5f03\u201d\u7684\u7ebf\u7d22");
            }
            if ("4".equals(leadsState)) {
                throw new BaseException("\u9009\u4e2d\u9879\u4e0d\u80fd\u5305\u542b\u201c\u5df2\u8f6c\u6362\u201d\u7684\u7ebf\u7d22");
            }
            if (!"8".equals(leadsState)) continue;
            throw new BaseException("\u9009\u4e2d\u9879\u4e0d\u80fd\u5305\u542b\u201c\u53ea\u8f6c\u5ba2\u6237\u201d\u7684\u7ebf\u7d22");
        }
        LeadsDto dto = leadsDtoList.get(0);
        List leadsList = this.leadsMapper.selectBatchIds(leadsIdList);
        for (Leads leads : leadsList) {
            leads.setState("6");
            leads.setChangePerson(user.getUserId());
            leads.setChangePersonName(user.getUserName());
            leads.setChangeTime(date);
            leads.setAbandonedPeason(dto.getAbandonedReason());
            leads.setAbandonedDescribe(dto.getAbandonedDescribe());
        }
        this.updateBatchById(leadsList);
        for (Leads leads : leadsList) {
            List<String> senderId = Collections.singletonList(String.valueOf(leads.getChargePersonId()));
            String title4 = user.getUserName() + "\u5c06\u7ebf\u7d22\u5e9f\u5f03";
            String content4 = "\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u5e9f\u5f03\uff0c\u5e9f\u5f03\u539f\u56e0\uff1a" + leads.getAbandonedDescribe();
            EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/schd/xsxq", String.valueOf(leads.getLeadsId()), senderId);
            AddSysMessageType addSysMessageType4 = new AddSysMessageType();
            String userIdToString = StringUtil.join(senderId, (String)",");
            String unifyWebUrl4 = this.unifyProperties.getCrmUrl() + "/crm/clueDetails?row=" + "\"" + leads.getLeadsId() + "\"";
            UnifyUtil.defaultMessage(addSysMessageType4, content4, date, user, userIdToString, user.getUserName(), unifyWebUrl4, "");
            UnifyUtil.sendMessage(addSysMessageType4);
            OperateRecordAPIVo trackRecord = new OperateRecordAPIVo();
            trackRecord.setContactId(Long.valueOf(dto.getAbandonedReason()));
            if (ToolUtil.isNotEmpty((Object)dto.getAbandonedReason())) {
                trackRecord.setContactName(this.leadsMapper.selectAbandonedReason(dto.getAbandonedReason()));
            }
            trackRecord.setRecordContent(dto.getAbandonedDescribe());
            trackRecord.setProduceType(RecordProductTypeEnum.PRODUCE_LEADS_ABANDONED.getId());
            this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.LEADS, leads.getLeadsId(), leads.getLeadsName(), date, true, Collections.singletonList(leads.getLeadsId()));
        }
        return true;
    }

    @Override
    @Transactional
    public Page<LeadsRepeatVo> repeatLeads(LeadsDto dto) {
        List<Object> list = new ArrayList();
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        if (ToolUtil.isEmpty((Object)dto.getRepeatFlag())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931\uff0c\u65e0\u6cd5\u786e\u8ba4\u7ebf\u7d22\u7c7b\u578b(\u516c\u6d77/\u79c1\u6d77)");
        }
        dto.setDelFlag("0");
        List<LeadsRepeatDetailVo> startDetailVos = this.leadsMapper.selectLeadsExceptProductId(dto);
        if (CollectionUtil.isEmpty(startDetailVos)) {
            page.setRecords(list);
            return page;
        }
        List<Long> startIds = startDetailVos.stream().map(LeadsRepeatDetailVo::getLeadsId).collect(Collectors.toList());
        ArrayList<Long> finalIds = new ArrayList<Long>();
        if ("1".equals(dto.getSameProductFlag())) {
            List<LeadsRepeatDetailVo> finalDetailVos = new ArrayList<LeadsRepeatDetailVo>(startDetailVos);
            finalDetailVos = startDetailVos.stream().filter(leadsRepeatDetailVo -> ToolUtil.isNotEmpty((Object)leadsRepeatDetailVo.getProductId())).collect(Collectors.toList());
            for (int i = 0; i < finalDetailVos.size(); ++i) {
                for (LeadsRepeatDetailVo finalDetailVo : finalDetailVos) {
                    List<String> productIds;
                    if (Objects.equals(finalDetailVos.get(i).getLeadsId(), finalDetailVo.getLeadsId()) || !CollectionUtil.isNotEmpty(productIds = Arrays.asList(finalDetailVos.get(i).getProductId().split(",")))) continue;
                    for (String productId : productIds) {
                        if (!finalDetailVo.getProductId().contains(productId) || !Objects.equals(finalDetailVos.get(i).getCustomerId(), finalDetailVo.getCustomerId())) continue;
                        finalIds.add(finalDetailVos.get(i).getLeadsId());
                    }
                }
            }
            if (CollectionUtil.isEmpty(finalIds)) {
                page.setRecords(list);
                return page;
            }
            list = this.leadsMapper.selectRepeatLeadsFinal(finalIds, dto, (Page<LeadsRepeatVo>)page);
            page.setRecords(list);
            return page;
        }
        list = this.leadsMapper.selectRepeatLeadsFinal(startIds, dto, (Page<LeadsRepeatVo>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    @Transactional
    public Page<LeadsRepeatDetailVo> repeatLeadsList(LeadsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        dto.setDelFlag("0");
        if (ToolUtil.isNotEmpty((Object)dto.getLeadsExceptIds())) {
            List<String> ids = Arrays.stream(dto.getLeadsExceptIds().split(",")).collect(Collectors.toList());
            dto.setLeadsIds(ids);
        }
        List<LeadsRepeatDetailVo> list = this.leadsMapper.selectRepeatLeadsListByName(dto, (Page<LeadsRepeatDetailVo>)page);
        for (LeadsRepeatDetailVo detailVo : list) {
            List<String> productIds;
            List<String> productNameList;
            if (!ToolUtil.isNotEmpty((Object)detailVo.getProductId()) || !CollectionUtil.isNotEmpty(productNameList = this.leadsMapper.selectLeadsProductNameByLeadsId(productIds = Arrays.stream(detailVo.getProductId().split(",")).collect(Collectors.toList())))) continue;
            String productName = String.join((CharSequence)",", productNameList);
            detailVo.setLeadsProductName(productName);
        }
        page.setRecords(list);
        return page;
    }

    @Override
    @Transactional
    public String leadsHighSeasImport(MultipartFile file, String highSeasid) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Long userId = user.getUserId();
        String userName = user.getUserName();
        AttachmentManagerModelVo attachment = null;
        Object suspectedAttachment = null;
        Long fileImportId = Long.valueOf(CommonUtills.generateAssignId());
        int importCount = 0;
        Integer sales = this.commonService.isSales();
        int flag = 0;
        if (file == null) {
            flag = -1;
        }
        if (!file.getOriginalFilename().endsWith("xlsx")) {
            flag = -2;
        }
        try {
            Long leadId;
            InputStream inputStream = file.getInputStream();
            List leadsOriginDtoList = null;
            try {
                leadsOriginDtoList = ((ExcelReaderSheetBuilder)((ExcelReaderBuilder)EasyExcel.read((InputStream)inputStream).head(LeadsOriginExportTempDto.class)).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(1))).doReadSync();
            }
            catch (Exception e) {
                return "\u5bfc\u5165\u6587\u4ef6\u4e0e\u6a21\u7248\u4e0d\u7b26\uff01";
            }
            List leadsList = BeanUtil.copy((Collection)leadsOriginDtoList, LeadsOrigin.class);
            if (CollectionUtil.isEmpty((Collection)leadsList)) {
                return "\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0a\u4f20\u5931\u8d25";
            }
            for (LeadsOrigin lead : leadsList) {
                Matcher matcher_mail;
                Matcher matcher;
                if (ToolUtil.isEmpty((Object)lead.getLeadsName()) || ToolUtil.isEmpty((Object)lead.getCompanyName())) {
                    return "\u5b58\u5728\u5fc5\u586b\u9879\u6ca1\u586b\uff0c\u5bfc\u5165\u5931\u8d25";
                }
                String regex = "^((13[0-9])|(14(0|[5-7]|9))|(15([0-3]|[5-9]))|(16(2|[5-7]))|(17[0-8])|(18[0-9])|(19([0-3]|[5-9])))\\d{8}$";
                Pattern pattern = Pattern.compile(regex, 2);
                if (ToolUtil.isNotEmpty((Object)lead.getMobilePhone()) && !(matcher = pattern.matcher(lead.getMobilePhone())).matches()) {
                    return "\u7ebf\u7d22\u3010" + lead.getLeadsName() + "\u3011 \u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                String regex_mail = "^(\\w+([-.][A-Za-z0-9]+)*){3,18}@\\w+([-.][A-Za-z0-9]+)*\\.\\w+([-.][A-Za-z0-9]+)*$";
                String[] pattern_mail = Pattern.compile(regex_mail);
                if (ToolUtil.isNotEmpty((Object)lead.getEmail()) && !(matcher_mail = pattern_mail.matcher(lead.getEmail())).matches()) {
                    return "\u7ebf\u7d22\u3010" + lead.getLeadsName() + "\u3011 \u90ae\u7bb1\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                List dicLeadsSource = this.sysDicRefService.getDicListByType("leads_source");
                int sourceFlag = 0;
                for (DicVo dic : dicLeadsSource) {
                    if (!Objects.equals(lead.getLeadsOrigin(), dic.getLabel())) continue;
                    lead.setLeadsOrigin(dic.getValue());
                    sourceFlag = 1;
                }
                if (ToolUtil.isNotEmpty((Object)lead.getLeadsOrigin()) && sourceFlag == 0) {
                    return "\u7ebf\u7d22\u6765\u6e90\u683c\u5f0f\u4e0d\u6b63\u786e";
                }
                lead.setCompanyName(lead.getCompanyName().replace(" ", ""));
            }
            for (LeadsOrigin lead : leadsList) {
                SysRegion sysRegion;
                if (ToolUtil.isNotEmpty((Object)lead.getTrade())) {
                    String trade = this.leadsMapper.selectValueByLabel("industry", lead.getTrade());
                    lead.setTrade(trade);
                }
                StringBuilder sb = new StringBuilder();
                if (ToolUtil.isNotEmpty((Object)lead.getProvince())) {
                    String province = this.leadsMapper.selectBaseAreaIdByName(lead.getProvince(), "0");
                    sysRegion = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)((Object)province));
                    if (ToolUtil.isNotEmpty((Object)sysRegion)) {
                        sb.append(sysRegion.getName());
                        lead.setRegionLabel(sysRegion.getName());
                    }
                    lead.setProvince(province);
                }
                if (ToolUtil.isNotEmpty((Object)lead.getCity()) && ToolUtil.isNotEmpty((Object)lead.getProvince())) {
                    String city = this.leadsMapper.selectBaseAreaIdByName(lead.getCity(), lead.getProvince());
                    sysRegion = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)((Object)city));
                    if (!ToolUtil.isNotEmpty((Object)sysRegion)) {
                        return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5730\u5e02";
                    }
                    sb.append("/").append(sysRegion.getName());
                    lead.setRegionLabel(sb.toString());
                    lead.setCity(city);
                }
                if (ToolUtil.isNotEmpty((Object)lead.getCounty()) && ToolUtil.isNotEmpty((Object)lead.getCity()) && ToolUtil.isNotEmpty((Object)lead.getProvince())) {
                    String county = this.leadsMapper.selectBaseAreaIdByName(lead.getCounty(), lead.getCity());
                    sysRegion = (SysRegion)this.iHussarBaseRegionService.getById((Serializable)((Object)county));
                    if (ToolUtil.isNotEmpty((Object)sysRegion)) {
                        sb.append("/").append(sysRegion.getName());
                        lead.setRegionLabel(sb.toString());
                    }
                    lead.setCounty(county);
                } else {
                    lead.setCounty(null);
                }
                if (ToolUtil.isNotEmpty((Object)lead.getCampaignName())) {
                    MarketingActivityEntity marketingActivity = (MarketingActivityEntity)this.marketingActivityService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(MarketingActivityEntity::getCampaignName, (Object)lead.getCampaignName())).eq(MarketingActivityEntity::getDelFlag, (Object)"0"));
                    if (ToolUtil.isNotEmpty((Object)marketingActivity)) {
                        lead.setCampaignId(marketingActivity.getCampaignId());
                    } else {
                        lead.setCampaignName(null);
                    }
                }
                if (ToolUtil.isNotEmpty((Object)lead.getSex())) {
                    if ("\u7537".equals(lead.getSex())) {
                        lead.setSex("1");
                    } else if ("\u5973".equals(lead.getSex())) {
                        lead.setSex("2");
                    } else {
                        lead.setSex(null);
                    }
                }
                StringBuffer sBuffer = new StringBuffer();
                if (ToolUtil.isNotEmpty((Object)lead.getProductName())) {
                    String[] productSplit;
                    for (String product : productSplit = lead.getProductName().split(",")) {
                        Product oneProduct = null;
                        List productList = this.productMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PRODUCT_NAME", (Object)product)).eq((Object)"DEL_FLAG", (Object)"0"));
                        if (ToolUtil.isNotEmpty((Object)productList)) {
                            oneProduct = (Product)productList.get(0);
                        }
                        sBuffer.append(oneProduct.getProductId());
                        if (product.equals(productSplit[productSplit.length - 1])) continue;
                        sBuffer.append(",");
                    }
                }
                lead.setProductId(sBuffer.toString());
                leadId = lead.getLeadsId();
                if (lead.getLeadsId() == null) {
                    leadId = Long.valueOf(CommonUtills.generateAssignId());
                    lead.setLeadsId(leadId);
                    if (ToolUtil.isNotEmpty((Object)lead.getMobilePhone())) {
                        lead.setMobilePhone(lead.getMobilePhone().replace(" ", ""));
                    }
                    if (ToolUtil.isNotEmpty((Object)lead.getTelephone())) {
                        lead.setTelephone(lead.getTelephone().replace(" ", ""));
                    }
                    lead.setDelFlag("0");
                    lead.setCreatePerson(user.getUserId());
                    lead.setCreatePersonName(user.getUserName());
                    lead.setCreateTime(date);
                    lead.setCreateDepartment(user.getDeptId());
                    lead.setCreateDepartmentName(user.getDeptName());
                    lead.setState("11");
                    lead.setChargePersonId(null);
                    lead.setChargePersonName(null);
                }
                if (ToolUtil.isEmpty((Object)lead.getClaimNum())) {
                    lead.setClaimNum(1);
                }
                lead.setClaimRange("1");
                lead.setClaimNum(CommonConstant.CLAIM_NUM);
                lead.setHighSeasId(highSeasid);
                lead.setRegionLabel(sb.toString());
                lead.setChangePerson(user.getUserId());
                lead.setChangePersonName(user.getUserName());
                lead.setChangeTime(date);
                ++importCount;
            }
            this.leadsOriginService.saveBatch(leadsList);
            ArrayList<OperateRecordAPIVo> trackRecordList = new ArrayList<OperateRecordAPIVo>();
            ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList<TeamMeberEntity>();
            for (LeadsOrigin lead : leadsList) {
                leadId = lead.getLeadsId();
                TeamMeberEntity teamMeber = this.leadsSeaSaveTeamMember(user, date, lead.getLeadsId(), sales);
                teamMeberEntityList.add(teamMeber);
                OperateRecordAPIVo trackRecord = this.leadsSeaSaveTrackRecord(user, date, lead.getLeadsId(), lead.getLeadsName());
                trackRecordList.add(trackRecord);
                if (!ToolUtil.isNotEmpty((Object)lead.getProductId())) continue;
                List<String> productIds = Arrays.asList(lead.getProductId().split(","));
                List<Long> businessIds = productIds.stream().map(Long::valueOf).collect(Collectors.toList());
                List<Map<String, Object>> productManagers = this.teamMeberMapper.selectProductTeamMemberByBusinessId(businessIds, "0");
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < productManagers.size(); ++i) {
                    if (list.contains(String.valueOf(productManagers.get(i).get("personId")))) continue;
                    list.add(String.valueOf(productManagers.get(i).get("personId")));
                    String title = "\u3010" + productManagers.get(i).get("productName") + "\u3011\u7ebf\u7d22\u63d0\u9192";
                    String content = user.getDeptName() + "-" + user.getUserName() + "\u5c06\u4ea7\u54c1\u3010" + productManagers.get(i).get("productName") + "\u3011\u5173\u8054\u5230\u7ebf\u7d22\u3010" + lead.getLeadsName() + "\u3011";
                    EimPushUtil.pushJqxArticleMessage(title, content, "/crm/schd/xsxq", String.valueOf(lead.getLeadsId()), Arrays.asList(String.valueOf(productManagers.get(i).get("personId"))));
                }
            }
            this.teamMeberService.saveBatch(teamMeberEntityList);
            this.operateRecordAPIService.saveOperateLogBatch(trackRecordList);
        }
        catch (Exception e) {
            System.out.println("\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            throw new RuntimeException(e);
        }
        FileInputStream inputStream = null;
        try {
            ApiResponse response = this.attachmentManagerService.uploadFileWithDrag(file, fileImportId);
            attachment = (AttachmentManagerModelVo)response.getData();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        FileImport fileImport = new FileImport();
        String sourceFileName = attachment.getFileName();
        String finishMessage = "";
        if (flag >= 0) {
            fileImport.setSuccessFail("1");
            finishMessage = "\u5bfc\u5165\u6210\u529f" + importCount + "\u6761";
        } else {
            fileImport.setSuccessFail("0");
            if (flag == -1) {
                finishMessage = "\u5bfc\u5165\u7684\u6587\u4ef6\u4e0d\u5b58\u5728";
            } else if (flag == -2) {
                finishMessage = "\u8bf7\u4e0a\u4f20\u6307\u5b9a\u683c\u5f0f\u6587\u4ef6";
            } else if (flag == -3) {
                finishMessage = "\u4e0a\u4f20\u5931\u8d25";
            }
        }
        fileImport.setFileImportId(fileImportId);
        Long sourceFileId = attachment.getId();
        fileImport.setSourceFileId(sourceFileId);
        fileImport.setSourceFileName(sourceFileName);
        fileImport.setImportResult(finishMessage);
        fileImport.setModuleId(LabelModuleEnum.LEAD.getModuleId());
        fileImport.setCreateTime(date);
        fileImport.setCreator(userId);
        fileImport.setCreatorName(userName);
        fileImport.setLastTime(date);
        fileImport.setLastEditor(userId);
        fileImport.setLastEditorName(userName);
        fileImport.setDelFlag("0");
        this.fileImportService.save((Object)fileImport);
        return "\u5bfc\u5165\u6210\u529f";
    }

    @Override
    @Transactional
    public String leadsHighSeasExport(HttpServletResponse response, LeadsOriginDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto salesStatisticsDto = new SalesStatisticsDto();
        dto = this.leadsOriginQueryCondition(dto);
        salesStatisticsDto.setCurrentUserId(user.getUserId());
        List<LeadsOrigin> list = this.leadsOriginMapper.selectCrmLeadsOriginList(null, dto, salesStatisticsDto);
        if (ToolUtil.isNotEmpty(list)) {
            for (LeadsOrigin leadsOrigin : list) {
                if ("1".equals(leadsOrigin.getClaimRange())) {
                    leadsOrigin.setClaimRange("\u5168\u90e8");
                    continue;
                }
                leadsOrigin.setClaimRange(this.getClaimRangeByLeadsId(leadsOrigin.getLeadsId()));
            }
        }
        List<LeadsOrigin> leadsList = this.dictionaryTranslate(list);
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, leadsList, "\u516c\u6d77\u7ebf\u7d22\u5217\u8868", LeadsOrigin.class);
        return "\u5bfc\u51fa\u6210\u529f";
    }

    private LeadsOriginDto leadsOriginQueryCondition(LeadsOriginDto dto) {
        if (ToolUtil.isNotEmpty((Object)dto.getLeadsScreening())) {
            dto.setLeadsScreening(dto.getLeadsScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(dto.getCreatePersonIds()) && dto.getCreatePersonIds().size() > 0) {
            for (String userId : dto.getCreatePersonIds()) {
                userIds.add(CommonUtills.translateUserId(userId));
            }
            dto.setCreatePersonIds(userIds);
        }
        List<String> createDepartmentIds = dto.getCreateDepartmentIds();
        ArrayList<String> cdpIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(createDepartmentIds) && createDepartmentIds.size() > 0) {
            for (String cdpId : createDepartmentIds) {
                ArrayList<String> Ids;
                String cdpIdsTemp = CommonUtills.translateDepId(cdpId);
                List<String> idsTemp = CommonUtills.selectOpportunityTissueTreeUserId(cdpIdsTemp, Ids = new ArrayList<String>());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    cdpIds.add(idsTemp.get(i));
                }
            }
            dto.setCreateDepartmentIds(cdpIds);
        }
        if ("1".equals(dto.getCreateTimeFlag()) || "2".equals(dto.getCreateTimeFlag()) || "13".equals(dto.getCreateTimeFlag())) {
            DateConvertVo dateConvertVo = IndexUtil.getCurrentTime(dto.getCreateTimeFlag());
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        return dto;
    }

    private String getClaimRangeByLeadsId(Long leadsId) {
        List unitIdsList = this.leadsOriginClaimService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{LeadsOriginClaim::getUnitId}).in(LeadsOriginClaim::getLeadsId, new Object[]{leadsId}), s -> Long.parseLong(s.toString()));
        List unitNameList = this.sysStruService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysStru::getOrganAlias}).in(SysStru::getId, (Collection)unitIdsList), s -> s.toString());
        String claimRange = "";
        if (ToolUtil.isNotEmpty((Object)unitNameList)) {
            claimRange = unitNameList.stream().collect(Collectors.joining("\uff0c"));
        }
        return claimRange;
    }

    @Override
    public void leadsHighSeasImportTemplate(HttpServletResponse response) {
        String filename = null;
        try {
            filename = URLEncoder.encode("\u516c\u6d77\u7ebf\u7d22\u4fe1\u606f\u8868", "utf-8");
            response.setHeader("Content-disposition", "attachment;filename=" + filename + ".xlsx");
            EasyExcel.write((OutputStream)response.getOutputStream(), LeadsOriginExportTempDto.class).sheet("\u516c\u6d77\u7ebf\u7d22\u4fe1\u606f").doWrite((Collection)null);
        }
        catch (Exception e) {
            System.out.println("\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<Product> selectLeadsProductsByLeadsId(Long leadsId) {
        Leads leads = (Leads)this.getById(leadsId);
        if (ToolUtil.isEmpty((Object)leads.getProductId())) {
            return null;
        }
        List<String> productIds = Arrays.asList(leads.getProductId().split(","));
        List productList = this.productService.listByIds(productIds);
        return productList;
    }

    @Override
    @Transactional
    public boolean activatedLeadsByBatch(LeadsDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Leads leads = (Leads)this.getById(dto.getLeadsId());
        if (leads == null) {
            throw new BaseException("\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        if (!"6".equals(leads.getState())) {
            throw new BaseException("\u53ea\u80fd\u6fc0\u6d3b\u5df2\u5e9f\u5f03\u7684\u7ebf\u7d22");
        }
        leads.setState("1");
        leads.setChangePerson(user.getUserId());
        leads.setChangePersonName(user.getUserName());
        leads.setChangeTime(date);
        this.updateById(leads);
        List<String> senderId = Collections.singletonList(String.valueOf(leads.getChargePersonId()));
        String title4 = user.getUserName() + "\u5c06\u7ebf\u7d22\u6fc0\u6d3b";
        String content4 = user.getUserName() + "\u5c06\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u6fc0\u6d3b";
        EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/schd/xsxq", String.valueOf(leads.getLeadsId()), senderId);
        AddSysMessageType addSysMessageType4 = new AddSysMessageType();
        String userIdToString = StringUtil.join(senderId, (String)",");
        String unifyWebUrl4 = this.unifyProperties.getCrmUrl() + "/crm/clueDetails?row=" + "\"" + leads.getLeadsId() + "\"";
        UnifyUtil.defaultMessage(addSysMessageType4, content4, date, user, userIdToString, user.getUserName(), unifyWebUrl4, "");
        UnifyUtil.sendMessage(addSysMessageType4);
        OperateRecordAPIVo trackRecord = new OperateRecordAPIVo();
        trackRecord.setProduceType(RecordProductTypeEnum.PRODUCE_LEADS_ACTIVATE.getId());
        this.operateRecordAPIService.saveOperateLog(trackRecord, CrmBusinessTypeEnum.LEADS, leads.getLeadsId(), leads.getLeadsName(), date, true, Collections.singletonList(leads.getLeadsId()));
        return true;
    }

    @Override
    @Transactional
    public boolean releaseLeads(LeadsDto dto) {
        String recordContent;
        String content4;
        String leadsOriginName;
        Long leadsOriginId;
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        Leads leads = (Leads)this.getById(dto.getLeadsId());
        if (leads == null) {
            throw new BaseException("\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        if (ToolUtil.isEmpty((Object)dto.getHighSeasId())) {
            throw new BaseException("\u6ca1\u6709\u9009\u62e9\u7ebf\u7d22\u8981\u91ca\u653e\u7684\u516c\u6d77");
        }
        if ("4".equals(leads.getState())) {
            throw new BaseException("\u5df2\u8f6c\u6362\u7684\u7ebf\u7d22\u4e0d\u80fd\u91ca\u653e");
        }
        if ("8".equals(leads.getState())) {
            throw new BaseException("\u53ea\u8f6c\u5ba2\u6237\u7684\u7ebf\u7d22\u4e0d\u80fd\u91ca\u653e");
        }
        String highSeaNameOld = null;
        if (ToolUtil.isNotEmpty((Object)leads.getOriginLeads())) {
            LeadsOrigin leadsOriginTemp = (LeadsOrigin)this.leadsOriginService.getById(leads.getOriginLeads());
            highSeaNameOld = ((LeadsHighSeasModel)this.leadsHighSeasService.getById((Serializable)((Object)leadsOriginTemp.getHighSeasId()))).getHighSeasName();
            if (Objects.equals(leadsOriginTemp.getHighSeasId(), dto.getHighSeasId())) {
                this.leadsOriginService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(LeadsOrigin::getState, (Object)"11")).set(LeadsOrigin::getLabelId, null)).eq(LeadsOrigin::getLeadsId, (Object)leads.getOriginLeads())).eq(LeadsOrigin::getDelFlag, (Object)"0"));
            } else {
                this.leadsOriginService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(LeadsOrigin::getHighSeasId, (Object)dto.getHighSeasId())).set(LeadsOrigin::getState, (Object)"11")).set(LeadsOrigin::getClaimNum, (Object)CommonConstant.CLAIM_NUM)).set(LeadsOrigin::getClaimRange, (Object)"1")).set(LeadsOrigin::getTrackTime, null)).set(LeadsOrigin::getLabelId, null)).set(LeadsOrigin::getChangePerson, (Object)user.getUserId())).set(LeadsOrigin::getChangePersonName, (Object)user.getUserName())).set(LeadsOrigin::getChangeTime, (Object)date)).eq(LeadsOrigin::getLeadsId, (Object)leads.getOriginLeads())).eq(LeadsOrigin::getDelFlag, (Object)"0"));
            }
            leadsOriginId = leads.getOriginLeads();
        } else {
            LeadsOrigin leadsOrigin = new LeadsOrigin();
            BeanUtils.copyProperties((Object)leads, (Object)leadsOrigin);
            leadsOrigin.setLeadsId(null);
            leadsOrigin.setHighSeasId(dto.getHighSeasId());
            leadsOrigin.setState("11");
            leadsOrigin.setClaimNum(CommonConstant.CLAIM_NUM);
            leadsOrigin.setClaimRange("1");
            leadsOrigin.setTrackTime(null);
            leadsOrigin.setLabelId(null);
            leadsOrigin.setChangePerson(user.getUserId());
            leadsOrigin.setChangePersonName(user.getUserName());
            leadsOrigin.setChangeTime(date);
            this.leadsOriginService.save(leadsOrigin);
            leadsOriginId = leadsOrigin.getLeadsId();
        }
        String highSeaNameNew = ((LeadsHighSeasModel)this.leadsHighSeasService.getById((Serializable)((Object)dto.getHighSeasId()))).getHighSeasName();
        leads.setState("3");
        leads.setChangePerson(user.getUserId());
        leads.setChangePersonName(user.getUserName());
        leads.setChangeTime(date);
        leads.setDelFlag("1");
        this.updateById(leads);
        ArrayList<String> senderId = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)leads.getChargePersonId())) {
            senderId = Collections.singletonList(String.valueOf(leads.getChargePersonId()));
        }
        String title4 = user.getUserName() + "\u5c06\u7ebf\u7d22\u91ca\u653e\u56de\u516c\u6d77";
        if (ToolUtil.isNotEmpty((Object)leads.getOriginLeads())) {
            leadsOriginName = ((LeadsOrigin)this.leadsOriginService.getById(leads.getOriginLeads())).getLeadsName();
            if (ToolUtil.isNotEmpty((Object)highSeaNameOld) && ToolUtil.isNotEmpty((Object)highSeaNameNew) && highSeaNameOld.equals(highSeaNameNew)) {
                content4 = user.getUserName() + "\u5c06\u60a8\u8d1f\u8d23\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u91ca\u653e\u56de\u539f\u516c\u6d77\u3010" + highSeaNameNew + "\u3011\u4e2d";
                recordContent = "\u91ca\u653e\u56de\u539f\u516c\u6d77\u3010" + highSeaNameNew + "\u3011\u4e2d";
            } else {
                content4 = user.getUserName() + "\u5c06\u60a8\u8d1f\u8d23\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u91ca\u653e\u56de\u516c\u6d77\uff0c\u4e14\u7531\u516c\u6d77\u3010" + highSeaNameOld + "\u3011\u8c03\u6574\u4e3a\u516c\u6d77\u3010" + highSeaNameNew + "\u3011\u4e2d";
                recordContent = "\u7531\u516c\u6d77\u3010" + highSeaNameOld + "\u3011\u8c03\u6574\u4e3a\u516c\u6d77\u3010" + highSeaNameNew + "\u3011\u4e2d";
            }
        } else {
            leadsOriginName = leads.getLeadsName();
            content4 = user.getUserName() + "\u5c06\u60a8\u8d1f\u8d23\u7684\u4e2a\u4eba\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u91ca\u653e\u5230\u516c\u6d77\u3010" + highSeaNameNew + "\u3011\u4e2d";
            recordContent = "\u5c06\u4e2a\u4eba\u7ebf\u7d22\u91ca\u653e\u5230\u516c\u6d77\u3010" + highSeaNameNew + "\u3011\u4e2d";
        }
        if (!Objects.equals(leads.getChargePersonId(), user.getUserId())) {
            EimPushUtil.pushJqxArticleMessage(title4, content4, "/crm/schd/xsxq", String.valueOf(leadsOriginId), senderId);
            AddSysMessageType addSysMessageType4 = new AddSysMessageType();
            String userIdToString = StringUtil.join(senderId, (String)",");
            String unifyWebUrl4 = this.unifyProperties.getCrmUrl() + "/crm/clueDetails?row=" + "\"" + leadsOriginId + "\"";
            UnifyUtil.defaultMessage(addSysMessageType4, content4, date, user, userIdToString, user.getUserName(), unifyWebUrl4, "");
            UnifyUtil.sendMessage(addSysMessageType4);
        }
        OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
        operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_LEADS_RELEASE.getId());
        operateRecordDO.setRecordContent(recordContent);
        this.operateRecordAPIService.saveOperateLog(operateRecordDO, CrmBusinessTypeEnum.LEADS_ORIGIN, leadsOriginId, leadsOriginName, date, false, Collections.singletonList(leadsOriginId));
        return true;
    }

    @Override
    @Transactional
    public Long getOldHighSeasId(Long leadsId) {
        Leads leads = (Leads)this.getById(leadsId);
        if (ToolUtil.isNotEmpty((Object)leads.getOriginLeads())) {
            LeadsOrigin leadsOriginTemp = (LeadsOrigin)this.leadsOriginService.getById(leads.getOriginLeads());
            return ((LeadsHighSeasModel)this.leadsHighSeasService.getById((Serializable)((Object)leadsOriginTemp.getHighSeasId()))).getHighSeasId();
        }
        return null;
    }

    @Override
    @Transactional
    public Long convertOpportunity(ImproveOpportunityDto dto) {
        String processReportState;
        Long leadsId = dto.getLeadsId();
        Leads leads = (Leads)this.getById(leadsId);
        if (leads == null) {
            throw new BaseException("\u8f6c\u6362\u7ebf\u7d22\u4e0d\u5b58\u5728");
        }
        if ("4".equals(leads.getState()) || "7".equals(leads.getState())) {
            throw new BaseException("\u8be5\u7ebf\u7d22\u5df2\u8f6c\u6362");
        }
        String leadsName = leads.getLeadsName();
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        OpportunityEntityDto opportunityEntityDto = dto.getOpportunityEntityDto();
        CustomerEntity customer = dto.getCustomer();
        Long customerId = customer.getCustomerId();
        String customerName = customer.getCustomerName();
        BusinessProcessDto businessProcessDto = new BusinessProcessDto();
        businessProcessDto.setProcessKey("opportunity_reporting");
        String string = processReportState = ToolUtil.isNotEmpty((Object)this.businessProcessService.selectBusinessProcess(businessProcessDto)) ? this.businessProcessService.selectBusinessProcess(businessProcessDto).getState() : null;
        if (ToolUtil.isEmpty(processReportState) || "0".equals(processReportState)) {
            OpportunityEntity opportunityEntity = (OpportunityEntity)BeanUtil.copy((Object)opportunityEntityDto, OpportunityEntity.class);
            assert (opportunityEntity != null);
            Long opportunityId = Long.parseLong(CommonUtills.generateAssignId());
            opportunityEntity.setOpportunityId(opportunityId);
            opportunityEntity.setOriginLeads(leadsId);
            opportunityEntity.setCustomerId(customerId);
            opportunityEntity.setCustomerName(customerName);
            this.defaultOpportunityEntity(opportunityEntity, date, user, null);
            this.opportunityService.save(opportunityEntity);
            this.opportunityProductService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(OpportunityProduct::getOpportunityId, (Object)opportunityId)).set(OpportunityProduct::getDelFlag, (Object)"1"));
            if (CollectionUtil.isNotEmpty(opportunityEntityDto.getProductList())) {
                for (OpportunityProduct product : opportunityEntityDto.getProductList()) {
                    product.setId(null);
                    product.setOpportunityId(opportunityEntity.getOpportunityId());
                    product.setOpportunityName(opportunityEntity.getOpportunityName());
                    if (!ToolUtil.isEmpty((Object)product.getStandardPrice()) || !ToolUtil.isNotEmpty((Object)product.getProductPrice())) continue;
                    product.setStandardPrice(product.getProductPrice());
                }
                this.opportunityProductService2.saveOpportunityProduct(opportunityEntityDto.getProductList(), false, false);
            }
            if (ToolUtil.isNotEmpty((Object)opportunityEntity.getName()) && ToolUtil.isNotEmpty((Object)opportunityEntity.getMobilePhone()) && ToolUtil.isNotEmpty((Object)opportunityEntity.getCustomerId())) {
                opportunityEntity.setMobilePhone(opportunityEntity.getMobilePhone().replace(" ", ""));
                List contactList = this.contactService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getDelFlag, (Object)"0")).eq(ContactEntity::getCustomerId, (Object)opportunityEntity.getCustomerId())).eq(ContactEntity::getMobilePhone, (Object)opportunityEntity.getMobilePhone()));
                if (CollectionUtil.isEmpty((Collection)contactList)) {
                    ContactEntity contact = this.getDefaultContactEntity(opportunityEntity);
                    this.contactService.saveCrmContact(contact);
                }
            }
            this.updateLeadsInfo(leads, customer, opportunityEntity, date, user);
            leads.setTransformationCustomerId(customerId);
            leads.setTransformationCustomerName(customerName);
            leads.setTransformationOpportunityId(opportunityId);
            leads.settOName(opportunityEntity.getOpportunityName());
            this.updateById(leads);
            OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
            operateRecordAPIVo.setSourceType("2");
            JSONObject sourceDescriptionJSON = new JSONObject();
            sourceDescriptionJSON.put("sourceBusinessId", (Object)leadsId);
            sourceDescriptionJSON.put("sourceBusinessName", (Object)((Leads)this.getById(leadsId)).getLeadsName());
            sourceDescriptionJSON.put("sourceBusinessType", (Object)CrmBusinessTypeEnum.LEADS.getId());
            operateRecordAPIVo.setSourceDescription(JSONObject.toJSONString((Object)sourceDescriptionJSON));
            this.operateRecordAPIService.saveOperateLog(operateRecordAPIVo, CrmBusinessTypeEnum.OPPORTUNITY, opportunityId, opportunityEntity.getOpportunityName(), date, false, null);
            this.convertLeadRecord(leadsId, leadsName, customerId, null, opportunityId, date);
            this.convertLeadTeamMember(user, date, leads, opportunityEntity, dto.getTeamMeber());
            List<TrackRecordRelationAPIVo> recordRelationList = this.getLeadRelationRecord(leadsId, customerId, true, opportunityId, dto.getGetRecordToOpportunity());
            this.trackRecordRelationAPIService.saveBatch(recordRelationList);
            Thread thread = new Thread(() -> this.convertLeadMessage(opportunityEntity, leads, user, date));
            thread.start();
            return opportunityId;
        }
        CrmOpportunityTaskTaskIncrementTable form = (CrmOpportunityTaskTaskIncrementTable)BeanUtil.copy((Object)opportunityEntityDto, CrmOpportunityTaskTaskIncrementTable.class);
        OpportunityEntity opportunityEntity = (OpportunityEntity)BeanUtil.copy((Object)opportunityEntityDto, OpportunityEntity.class);
        Long opportunityId = Long.parseLong(CommonUtills.generateAssignId());
        opportunityEntity.setOpportunityId(opportunityId);
        opportunityEntity.setOriginLeads(leadsId);
        opportunityEntity.setCustomerId(customerId);
        opportunityEntity.setCustomerName(customerName);
        this.defaultOpportunityEntity(opportunityEntity, date, user, null);
        form = (CrmOpportunityTaskTaskIncrementTable)BeanUtil.copy((Object)opportunityEntity, CrmOpportunityTaskTaskIncrementTable.class);
        opportunityId = Long.parseLong(CommonUtills.generateAssignId());
        form.setOpportunityId(opportunityId);
        form.setDelFlag("0");
        form.setCreateTime(date);
        form.setCreatePerson(user.getUserId());
        form.setCreatePersonName(user.getUserName());
        form.setCreateDepartment(user.getDeptId());
        form.setCreateDepartmentName(user.getDeptName());
        form.setState("5");
        form.setChargePersonId(null);
        form.setChargePersonName(null);
        form.setOwnDepartment(null);
        form.setOwnDepartmentName(null);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (ToolUtil.isNotEmpty((Object)opportunityEntity.getEndTime())) {
            form.setOppEndTime(LocalDateTime.parse(opportunityEntity.getEndTime(), formatter));
        }
        Increment opportunityProductIncrement = new Increment();
        form.setCrmOpportunityProduct((Increment<CrmOpportunityProduct>)opportunityProductIncrement);
        Increment crmOpportunityProductIncrement = new Increment();
        List<OpportunityProduct> opportunityProductList = opportunityEntityDto.getProductList();
        ArrayList<CrmOpportunityProduct> crmOpportunityProductList = new ArrayList<CrmOpportunityProduct>();
        for (OpportunityProduct opportunityProduct : opportunityProductList) {
            CrmOpportunityProduct crmOpportunityProduct = (CrmOpportunityProduct)BeanUtil.copy((Object)opportunityProduct, CrmOpportunityProduct.class);
            if (ToolUtil.isEmpty((Object)crmOpportunityProduct.getStandardPrice()) && ToolUtil.isNotEmpty((Object)opportunityProduct.getProductPrice())) {
                crmOpportunityProduct.setStandardPrice(Double.valueOf(opportunityProduct.getProductPrice()));
            }
            crmOpportunityProductList.add(crmOpportunityProduct);
        }
        crmOpportunityProductIncrement.setAdd(crmOpportunityProductList);
        form.setCrmOpportunityProduct((Increment<CrmOpportunityProduct>)crmOpportunityProductIncrement);
        CrmOpportunityTaskTaskFlowIncrementDTO dto1 = new CrmOpportunityTaskTaskFlowIncrementDTO();
        dto1.setTaskId("");
        dto1.setProcessDefinitionKey("opportunity_reporting");
        dto1.setFormdata(form);
        this.crmOpportunityTaskTaskService.flowFormSubmitPlus(dto1);
        if (ToolUtil.isNotEmpty((Object)opportunityEntity.getName()) && ToolUtil.isNotEmpty((Object)opportunityEntity.getMobilePhone()) && ToolUtil.isNotEmpty((Object)opportunityEntity.getCustomerId())) {
            opportunityEntity.setMobilePhone(opportunityEntity.getMobilePhone().replace(" ", ""));
            List contactList = this.contactService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactEntity::getDelFlag, (Object)"0")).eq(ContactEntity::getCustomerId, (Object)opportunityEntity.getCustomerId())).eq(ContactEntity::getMobilePhone, (Object)opportunityEntity.getMobilePhone()));
            if (CollectionUtil.isEmpty((Collection)contactList)) {
                ContactEntity contact = this.getDefaultContactEntity(opportunityEntity);
                this.contactService.saveCrmContact(contact);
            }
        }
        this.updateLeadsInfo(leads, customer, opportunityEntity, date, user);
        leads.setTransformationCustomerId(customerId);
        leads.setTransformationCustomerName(customerName);
        leads.setTransformationOpportunityId(opportunityId);
        leads.settOName(opportunityEntity.getOpportunityName());
        this.updateById(leads);
        ArrayList<Long> typeIdList = new ArrayList<Long>(Collections.singletonList(opportunityId));
        typeIdList.add(customerId);
        OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
        operateRecordAPIVo.setSourceType("2");
        JSONObject sourceDescriptionJSON = new JSONObject();
        sourceDescriptionJSON.put("sourceBusinessId", (Object)leadsId);
        sourceDescriptionJSON.put("sourceBusinessName", (Object)((Leads)this.getById(leadsId)).getLeadsName());
        sourceDescriptionJSON.put("sourceBusinessType", (Object)CrmBusinessTypeEnum.LEADS.getId());
        operateRecordAPIVo.setSourceDescription(JSONObject.toJSONString((Object)sourceDescriptionJSON));
        this.operateRecordAPIService.saveOperateLog(operateRecordAPIVo, CrmBusinessTypeEnum.OPPORTUNITY, opportunityId, opportunityEntity.getOpportunityName(), date, false, typeIdList, user);
        this.convertLeadRecord(leadsId, leadsName, customerId, null, opportunityId, date);
        this.convertLeadTeamMember(user, date, leads, opportunityEntity, dto.getTeamMeber());
        List<TrackRecordRelationAPIVo> recordRelationList = this.getLeadRelationRecord(leadsId, customerId, true, opportunityId, dto.getGetRecordToOpportunity());
        this.trackRecordRelationAPIService.saveBatch(recordRelationList);
        Thread thread = new Thread(() -> this.convertLeadMessage(opportunityEntity, leads, user, date));
        thread.start();
        return opportunityId;
    }

    private ContactEntity getDefaultContactEntity(OpportunityEntity opportunityEntity) {
        ContactEntity contact = new ContactEntity();
        contact.setContactName(opportunityEntity.getName());
        contact.setDepartment(opportunityEntity.getContactDepartment());
        contact.setPosition(opportunityEntity.getPosition());
        contact.setMobilePhone(opportunityEntity.getMobilePhone());
        contact.setSex(opportunityEntity.getSex());
        contact.setTelephone(opportunityEntity.getTelephone());
        contact.setEmail(opportunityEntity.getEmail());
        contact.setCustomerId(opportunityEntity.getCustomerId());
        contact.setCustomerName(opportunityEntity.getCustomerName());
        return contact;
    }

    private void updateLeadsInfo(Leads leads, CustomerEntity customer, OpportunityEntity opportunity, LocalDateTime date, SecurityUser user) {
        leads.setCompanyName(customer.getCustomerName());
        leads.setCustomerId(customer.getCustomerId());
        leads.setTransformationCustomerId(customer.getCustomerId());
        leads.setTransformationCustomerName(customer.getCustomerName());
        leads.setTransformationOpportunityId(opportunity.getOpportunityId());
        leads.setChangePerson(user.getId());
        leads.setChangePersonName(user.getUserName());
        leads.setChangeTime(date);
        leads.setState("4");
    }

    private void convertLeadMessage(OpportunityEntity opportunity, Leads leads, SecurityUser user, LocalDateTime date) {
        try {
            List<String> focusId = this.focusMapper.selectCreateId("4", leads.getLeadsId());
            List<String> createRole = this.commonService.getRoleNameByUser_Id(leads.getCreatePerson());
            if (!(createRole.contains(this.crmProperties.getRoles().getBgLeader()) || createRole.contains(this.crmProperties.getRoles().getSalesGM()) || createRole.contains(this.crmProperties.getRoles().getSalesDirector()) || createRole.contains(this.crmProperties.getRoles().getSalesman()))) {
                String createPersonId = String.valueOf(leads.getCreatePerson());
                focusId.removeIf(item -> item.contains(createPersonId));
                String title3 = user.getUserName() + "\u5c06\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5546\u673a";
                String content3 = "\u60a8\u63d0\u4ea4\u7684\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u5df2\u7531" + user.getDeptName() + "\u7684" + user.getUserName() + "\u8f6c\u6362\u6210\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title3, content3, "/crm/sj/sjxq/xxzl", opportunity.getOpportunityId().toString(), Collections.singletonList(String.valueOf(leads.getCreatePerson())));
                AddSysMessageType addSysMessageType3 = new AddSysMessageType();
                String unifyWebUrl3 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType3, content3, date, user, String.valueOf(leads.getCreatePerson()), user.getUserName(), unifyWebUrl3, "");
                UnifyUtil.sendMessage(addSysMessageType3);
            }
            focusId.removeIf(item -> item.contains(user.getUserId().toString()));
            if (ToolUtil.isNotEmpty(focusId)) {
                String title5 = user.getUserName() + "\u5c06\u60a8\u5173\u6ce8\u7684\u7ebf\u7d22\u8f6c\u6362\u6210\u5546\u673a";
                String content5 = "\u7ebf\u7d22\u3010" + leads.getLeadsName() + "\u3011\u8f6c\u6362\u4e3a\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011";
                EimPushUtil.pushJqxArticleMessage(title5, content5, "/crm/sj/sjxq/xxzl", String.valueOf(opportunity.getOpportunityId()), focusId);
                AddSysMessageType addSysMessageType5 = new AddSysMessageType();
                String pushPersonIds = StringUtil.join(focusId, (String)",");
                String unifyWebUrl5 = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
                UnifyUtil.defaultMessage(addSysMessageType5, content5, date, user, pushPersonIds, user.getUserName(), unifyWebUrl5, "");
                UnifyUtil.sendMessage(addSysMessageType5);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void convertLeadTeamMember(SecurityUser user, LocalDateTime date, Leads leads, OpportunityEntity opportunity, boolean teamMber) {
        boolean isNewTeamMember = false;
        ArrayList<TeamMeberEntity> teamMeberEntityList = new ArrayList();
        if (teamMber) {
            teamMeberEntityList = this.teamMeberMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TeamMeberEntity::getBusinessId, (Object)leads.getLeadsId())).eq(TeamMeberEntity::getDelFlag, (Object)"0"));
            isNewTeamMember = this.updateTeamMeberInfo(leads, teamMeberEntityList, isNewTeamMember);
        }
        if (teamMeberEntityList.size() > 0) {
            for (TeamMeberEntity list : teamMeberEntityList) {
                this.addTeamMember(list, opportunity.getOpportunityId(), "2", date);
            }
            this.teamMeberService.saveBatch(teamMeberEntityList);
        }
        if (isNewTeamMember || !teamMber) {
            this.teamMeberService.insertTeamMember(user.getUserName(), user.getUserId(), opportunity.getOpportunityId(), "1", "1", date, "2");
        }
    }

    @Override
    public ApiResponse<String> leadsChangeDeptBatch(DeptChangeBatchDto dto) {
        if (HussarUtils.isNotEmpty((Object)dto.getOwnDepartment()) && CollectionUtil.isNotEmpty(dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List leadsList = this.list((Wrapper)new LambdaQueryWrapper().in(Leads::getLeadsId, dto.getObjectIdList()));
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            String newOwnDeptName = dto.getOwnDepartmentName();
            Long newOwnDeptId = dto.getOwnDepartment();
            boolean changeFlag = false;
            for (Leads leads : leadsList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                ArrayList changeField = new ArrayList();
                if (dto.getOwnDepartmentName().equals(leads.getOwnDepartmentName())) continue;
                String oldOwnDeptName = leads.getOwnDepartmentName();
                Long oldOwnDeptId = leads.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = leads.getLeadsName();
                typeEnum = CrmBusinessTypeEnum.LEADS;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                operateRecordDO.setChangeBefore(oldJson);
                operateRecordDO.setChangeAfter(newJson);
                operateRecordDO.setChangeField(changeFieldStr);
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(leads.getLeadsId());
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                operateRecordDOList.add(operateRecordDO);
            }
            this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(Leads::getLeadsId, dto.getObjectIdList())).set(Leads::getOwnDepartment, (Object)dto.getOwnDepartment())).set(Leads::getOwnDepartmentName, (Object)dto.getOwnDepartmentName())).set(Leads::getChangeTime, (Object)date)).set(Leads::getChangePerson, (Object)user.getUserId())).set(Leads::getChangePersonName, (Object)user.getUserName()));
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }

    @Override
    public ApiResponse<String> leadsChangeDeptByChargePersonBatch(DeptChangeBatchDto dto) {
        if (CollectionUtil.isNotEmpty(dto.getObjectIdList())) {
            LocalDateTime date = LocalDateTime.now();
            SecurityUser user = BaseSecurityUtil.getUser();
            List leadsList = this.list((Wrapper)new LambdaQueryWrapper().in(Leads::getLeadsId, dto.getObjectIdList()));
            for (Leads leads : leadsList) {
                if (!ToolUtil.isEmpty((Object)leads.getChargePersonId())) continue;
                throw new HussarException("\u7ebf\u7d22\u8d1f\u8d23\u4eba\u4e0d\u5b58\u5728\uff01");
            }
            ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
            List<Map<String, Object>> userInfoList = this.commonMapper.getDeptInfosByUserIdList(leadsList.stream().map(Leads::getChargePersonId).collect(Collectors.toList()));
            boolean changeFlag = false;
            for (Leads leads : leadsList) {
                HashMap<String, Object> before = new HashMap<String, Object>();
                HashMap<String, Object> after = new HashMap<String, Object>();
                ArrayList changeField = new ArrayList();
                Map userMap = (Map)userInfoList.stream().filter(map -> map.get("USER_ID").equals(leads.getChargePersonId())).collect(Collectors.toList()).get(0);
                Long newOwnDeptId = (Long)userMap.get("DEPARTMENT_ID");
                String newOwnDeptName = (String)userMap.get("ORGAN_ALIAS");
                if (newOwnDeptName.equals(leads.getOwnDepartmentName())) continue;
                String oldOwnDeptName = leads.getOwnDepartmentName();
                Long oldOwnDeptId = leads.getOwnDepartment();
                if ((ToolUtil.isEmpty((Object)oldOwnDeptName) && ToolUtil.isEmpty((Object)newOwnDeptName) || !ToolUtil.isEmpty((Object)oldOwnDeptName) && oldOwnDeptName.equals(newOwnDeptName)) && (ToolUtil.isEmpty((Object)oldOwnDeptId) && ToolUtil.isEmpty((Object)newOwnDeptId) || !ToolUtil.isEmpty((Object)oldOwnDeptId) && oldOwnDeptId.equals(newOwnDeptId))) continue;
                HashMap<String, String> field = new HashMap<String, String>();
                field.put("field", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField());
                field.put("fieldName", OpportunityEditConstant.OWN_DEPARTMENT_NAME.getName());
                changeField.add(field);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), oldOwnDeptName);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_NAME.getField(), newOwnDeptName);
                before.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), oldOwnDeptId);
                after.put(OpportunityEditConstant.OWN_DEPARTMENT_ID.getField(), newOwnDeptId);
                String changeFieldStr = JSON.toJSONString(changeField);
                changeFlag = true;
                String oldJson = JSON.toJSONString(before);
                String newJson = JSON.toJSONString(after);
                String businessName = "";
                CrmBusinessTypeEnum typeEnum = null;
                businessName = leads.getCustomerName();
                typeEnum = CrmBusinessTypeEnum.LEADS;
                OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
                operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_OWN_DEPARTMENT.getId());
                operateRecordDO.setChangeBefore(oldJson);
                operateRecordDO.setChangeAfter(newJson);
                operateRecordDO.setChangeField(changeFieldStr);
                operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
                operateRecordDO.setBusinessType(typeEnum.getId());
                operateRecordDO.setTypeId(leads.getCustomerId());
                operateRecordDO.setBusinessName(businessName);
                operateRecordDO.setCreatePerson(user.getUserId());
                operateRecordDO.setCreatePersonName(user.getUserName());
                operateRecordDO.setCreateTime(date);
                operateRecordDO.setChangePerson(user.getUserId());
                operateRecordDO.setChangeTime(date);
                operateRecordDO.setChangePersonName(user.getUserName());
                operateRecordDO.setDelflag("0");
                operateRecordDO.setChangeBatch(1);
                operateRecordDOList.add(operateRecordDO);
                leads.setOwnDepartment(newOwnDeptId);
                leads.setOwnDepartmentName(newOwnDeptName);
                leads.setChangeTime(date);
                leads.setChangePerson(user.getUserId());
                leads.setChangePersonName(user.getUserName());
            }
            this.updateBatchById(leadsList);
            if (changeFlag) {
                this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
            }
            return ApiResponse.success();
        }
        return ApiResponse.fail((String)"\u53c2\u6570\u9519\u8bef");
    }
}

