/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.leads.service.impl;

import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.core.associativeQuery.queryEnum.AssociativeModuleEnum;
import com.jxdinfo.crm.core.associativeQuery.queryEnum.AssociativeQueryEnum;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeFiledQueryService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.leads.dto.LeadsAssociativeQueryDto;
import com.jxdinfo.crm.core.leads.dto.LeadsDto;
import com.jxdinfo.crm.core.leads.service.LeadsAssociativeQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class LeadsAssociativeQueryServiceImpl
implements LeadsAssociativeQueryService {
    @Resource
    private AssociativeFiledQueryService associativeFiledQueryService;

    @Override
    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        LeadsAssociativeQueryDto leadsAssociativeQueryDto = null;
        if (associativeQueryDto instanceof LeadsAssociativeQueryDto) {
            leadsAssociativeQueryDto = (LeadsAssociativeQueryDto)associativeQueryDto;
        }
        assert (leadsAssociativeQueryDto != null);
        LeadsDto leadsDto = leadsAssociativeQueryDto.getDto();
        List<String> labelIdList = null;
        List<String> ownDepartmentList = null;
        List<String> chargePersonIdList = null;
        String createTimeTage = null;
        List<Long> provinceList = null;
        String overdueFollow = null;
        List<String> fromList = null;
        List<String> productIds = null;
        List<Long> campaignIds = null;
        List<String> createDepartments = null;
        if (leadsDto != null) {
            ownDepartmentList = leadsDto.getOwnDepartments();
            chargePersonIdList = leadsDto.getChargePersonIds();
            createTimeTage = leadsDto.getCreateTimeFlag();
            provinceList = leadsDto.getProvinces();
            overdueFollow = leadsDto.getOverdueFollow();
            fromList = leadsDto.getLeadsOrigins();
            productIds = leadsDto.getProductIds();
            campaignIds = leadsDto.getCampaignIds();
            createDepartments = leadsDto.getCreateDepartments();
        }
        String moduleId = AssociativeModuleEnum.LEAD.getModuleId();
        List<String> selectedLabels = excludeInfoMap.get("selectedLabels");
        selectedLabels = this.associativeFiledQueryService.getLabelAssociativeQuery(associativeQueryVoList, keyword, selectedLabels, labelIdList, moduleId);
        excludeInfoMap.put("selectedLabels", selectedLabels);
        List<String> selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryService.getOwnDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, AssociativeQueryEnum.LEADS_OWN_DEPARTMENTS);
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List<String> selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryService.getChargePersonAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, AssociativeQueryEnum.LEADS_CHARGE_PERSON);
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List<String> selectedCreateTimes = excludeInfoMap.get("selectedCreateTimes");
        selectedCreateTimes = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimes, createTimeTage, AssociativeQueryEnum.LEADS_CREATE_TIME);
        excludeInfoMap.put("selectedCreateTimes", selectedCreateTimes);
        List<String> selectedStates = excludeInfoMap.get("selectedStates");
        selectedStates = this.associativeFiledQueryService.getLeadsStateAssociativeQuery(associativeQueryVoList, keyword, selectedStates, leadsDto);
        excludeInfoMap.put("selectedStates", selectedStates);
        List<String> selectedFroms = excludeInfoMap.get("selectedFroms");
        selectedFroms = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedFroms, fromList, AssociativeQueryEnum.LEADS_FROM);
        excludeInfoMap.put("selectedFroms", selectedFroms);
        List<String> selectedCampaignIds = excludeInfoMap.get("selectedCampaignIds");
        selectedCampaignIds = this.associativeFiledQueryService.getCampaignIdAssociativeQuery(associativeQueryVoList, keyword, selectedCampaignIds, campaignIds, AssociativeQueryEnum.LEADS_CAMPAIGN);
        excludeInfoMap.put("selectedCampaignIds", selectedCampaignIds);
        List<String> selectedProducts = excludeInfoMap.get("selectedProducts");
        selectedProducts = this.associativeFiledQueryService.getProductAssociativeQuery(associativeQueryVoList, keyword, selectedProducts, productIds, AssociativeQueryEnum.LEADS_PRODUCT_TYPES);
        excludeInfoMap.put("selectedProducts", selectedProducts);
        List<String> selectedProvinces = excludeInfoMap.get("selectedProvinces");
        selectedProvinces = this.associativeFiledQueryService.getProvinceAssociativeQuery(associativeQueryVoList, keyword, selectedProvinces, provinceList);
        excludeInfoMap.put("selectedProvinces", selectedProvinces);
        List<String> selectedCreateDepartments = excludeInfoMap.get("selectedCreateDepartments");
        selectedCreateDepartments = this.associativeFiledQueryService.getCreateDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedCreateDepartments, createDepartments, AssociativeQueryEnum.OPPORTUNITY_CREATE_DEPT);
        excludeInfoMap.put("selectedCreateDepartments", selectedCreateDepartments);
        List<String> selectedOverdues = excludeInfoMap.get("selectedOverdues");
        selectedOverdues = this.associativeFiledQueryService.getOverdueAssociativeQuery(associativeQueryVoList, keyword, selectedOverdues, overdueFollow);
        excludeInfoMap.put("selectedOverdues", selectedOverdues);
        return associativeQueryVoList;
    }
}

