/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.job.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.common.vo.UserInfoVo;
import com.jxdinfo.crm.core.common.vo.UserRoleVo;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.job.service.NotTransferredOpportunityService;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.unify.dto.AddSysMessageType;
import com.jxdinfo.crm.core.unify.util.UnifyUtil;
import com.jxdinfo.crm.core.utills.EimPushUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class NotTransferredOpportunityServiceImpl
implements NotTransferredOpportunityService {
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private CommonService commonService;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private UnifyProperties unifyProperties;

    @Override
    public ProcessResult NoChargePerson() {
        LocalDateTime date = LocalDateTime.now();
        List list = this.opportunityService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().lt(OpportunityEntity::getCreateTime, (Object)LocalDateTime.now().minusDays(1L))).eq(OpportunityEntity::getDelFlag, (Object)"0")).eq(OpportunityEntity::getIsUnassigned, (Object)"1"));
        if (list.isEmpty()) {
            return new ProcessResult(true);
        }
        List<Long> CreatePersonList = list.stream().map(OpportunityEntity::getCreatePerson).collect(Collectors.toList());
        List<UserRoleVo> voList = this.commonMapper.getUsersRolesByUserIds(CreatePersonList);
        ArrayList<UserRoleVo> userRolesList = new ArrayList<UserRoleVo>();
        Long userIdTemp = voList.get(0).getUserId();
        UserRoleVo tempVo = new UserRoleVo();
        tempVo.setUserRoles("");
        tempVo.setUserId(userIdTemp);
        StringBuffer strb = new StringBuffer();
        for (int i = 0; i < voList.size(); ++i) {
            UserRoleVo userRoleVo;
            if (voList.get(i).getUserId().equals(userIdTemp)) {
                strb.append(voList.get(i).getGrantedRole() + ",");
            } else {
                strb.deleteCharAt(strb.length() - 1);
                tempVo.setUserRoles(strb.toString());
                userRoleVo = new UserRoleVo();
                userRoleVo = (UserRoleVo)BeanUtil.copy((Object)tempVo, UserRoleVo.class);
                userRolesList.add(userRoleVo);
                userIdTemp = voList.get(i).getUserId();
                tempVo.setUserId(userIdTemp);
                strb = new StringBuffer(voList.get(i).getGrantedRole() + ",");
            }
            if (i != voList.size() - 1) continue;
            strb.deleteCharAt(strb.length() - 1);
            tempVo.setUserRoles(strb.toString());
            userRoleVo = new UserRoleVo();
            userRoleVo = (UserRoleVo)BeanUtil.copy((Object)tempVo, UserRoleVo.class);
            userRolesList.add(userRoleVo);
        }
        List<UserRoleVo> isSalesList = this.isSales(userRolesList);
        for (UserRoleVo userRole : isSalesList) {
            UserInfoVo userInfoVo = this.commonService.getUserInfo(userRole.getUserId());
            if (userRole.getIsSales() >= CommonConstant.salesman || userRole.getUserRoles().contains(this.crmProperties.getRoles().getMarketingManager())) continue;
            ArrayList<OpportunityEntity> msgOpportunityList = new ArrayList<OpportunityEntity>();
            for (OpportunityEntity opportunityEntity : list) {
                if (!Objects.equals(opportunityEntity.getCreatePerson(), userRole.getUserId())) continue;
                msgOpportunityList.add(opportunityEntity);
            }
            if (!CollectionUtil.isNotEmpty(msgOpportunityList)) continue;
            for (OpportunityEntity opportunity : msgOpportunityList) {
                String contentUnify = "\u3010\u5546\u673a\u63d0\u9192\u3011\u60a8\u521b\u5efa\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5df2\u8d85\u8fc71\u5929\uff0c\u4f46\u672a\u8f6c\u79fb\u51fa\u53bb\uff0c\u8bf7\u53ca\u65f6\u8f6c\u79fb\u8ddf\u8fdb\u3002";
                String mobileContent = "\u60a8\u521b\u5efa\u5546\u673a\u3010" + opportunity.getOpportunityName() + "\u3011\u5df2\u8d85\u8fc71\u5929\uff0c\u4f46\u672a\u8f6c\u79fb\u51fa\u53bb\uff0c\u8bf7\u53ca\u65f6\u8f6c\u79fb\u8ddf\u8fdb";
                this.sendMsg(opportunity, Collections.singletonList(HussarUtils.toStr((Object)userInfoVo.getUserId())), date, contentUnify, mobileContent);
            }
        }
        return new ProcessResult(true);
    }

    private void sendMsg(OpportunityEntity opportunity, List<String> sendMsgUserId, LocalDateTime date, String content, String mobileContent) {
        String mobileTitle = "\u3010CRM\u3011\u5546\u673a\u63d0\u9192";
        EimPushUtil.pushJqxArticleMessage(mobileTitle, mobileContent, "/crm/sj/sjxq/xxzl", String.valueOf(opportunity.getOpportunityId()), sendMsgUserId);
        AddSysMessageType addSysMessageType = new AddSysMessageType();
        String unifyWebUrl = this.unifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + opportunity.getOpportunityId() + "\"";
        String userIdToString = StringUtil.join(sendMsgUserId, (String)",");
        addSysMessageType.setMessageContent(content);
        addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
        addSysMessageType.setBusinessAddress(unifyWebUrl);
        addSysMessageType.setUserId(userIdToString);
        addSysMessageType.setOpenWay("1");
        UnifyUtil.sendMessage(addSysMessageType);
    }

    private List<UserRoleVo> isSales(List<UserRoleVo> roleVos) {
        List<Long> leadershipRoles = DataPermission.getLeadershipRoles();
        for (UserRoleVo userRole : roleVos) {
            if (userRole.getUserRoles().contains(this.crmProperties.getRoles().getCompanyLeader())) {
                userRole.setIsSales(CommonConstant.companyLeader);
            } else if (DataPermission.isLeadship(Arrays.stream(userRole.getUserRoles().split(",")).mapToLong(Long::parseLong).boxed().collect(Collectors.toList()), leadershipRoles)) {
                userRole.setIsSales(CommonConstant.leadership);
            } else if (userRole.getUserRoles().contains(this.crmProperties.getRoles().getBgLeader())) {
                userRole.setIsSales(CommonConstant.bgLeader);
            } else if (userRole.getUserRoles().contains(this.crmProperties.getRoles().getSalesGM())) {
                userRole.setIsSales(CommonConstant.salesGM);
            } else if (userRole.getUserRoles().contains(this.crmProperties.getRoles().getSalesDirector())) {
                userRole.setIsSales(CommonConstant.salesDirector);
            } else if (userRole.getUserRoles().contains(this.crmProperties.getRoles().getSalesman())) {
                userRole.setIsSales(CommonConstant.salesman);
            }
            userRole.setIsSales(CommonConstant.otherRole);
        }
        return roleVos;
    }
}

