/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.service.impl;

import com.jxdinfo.crm.core.associativeQuery.dto.AssociativeQueryDto;
import com.jxdinfo.crm.core.associativeQuery.queryEnum.AssociativeModuleEnum;
import com.jxdinfo.crm.core.associativeQuery.queryEnum.AssociativeQueryEnum;
import com.jxdinfo.crm.core.associativeQuery.service.AssociativeFiledQueryService;
import com.jxdinfo.crm.core.common.vo.AssociativeQueryVo;
import com.jxdinfo.crm.core.customer.dto.CustomerAssociativeQueryDto;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.service.ICustomerAssociativeQueryService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerAssociativeQueryServiceImpl
implements ICustomerAssociativeQueryService {
    @Resource
    private AssociativeFiledQueryService associativeFiledQueryService;

    @Override
    public List<AssociativeQueryVo> getAssociativeQueryVo(String keyword, AssociativeQueryDto associativeQueryDto, Map<String, List<String>> excludeInfoMap) {
        ArrayList<AssociativeQueryVo> associativeQueryVoList = new ArrayList<AssociativeQueryVo>();
        CustomerAssociativeQueryDto customerAssociativeQueryDto = null;
        if (associativeQueryDto instanceof CustomerAssociativeQueryDto) {
            customerAssociativeQueryDto = (CustomerAssociativeQueryDto)associativeQueryDto;
        }
        assert (customerAssociativeQueryDto != null);
        CustomerDto customerDto = customerAssociativeQueryDto.getDto();
        List<String> labelList = null;
        String overdue = null;
        List<String> customerTypeList = null;
        List<String> custLevelList = null;
        List<String> customerOriginList = null;
        List<String> customerAttributeList = null;
        List<String> tradeList = null;
        List<Long> provinceList = null;
        List<String> dealStates = null;
        String createTimeTage = null;
        String trackTimeFlag = null;
        List<String> ownDepartmentList = null;
        List<String> chargePersonIdList = null;
        List<String> teamMemberIdList = null;
        List<String> customerStageList = null;
        List<String> corporateScaleList = null;
        List<String> corporateImpactList = null;
        List<String> listingStatusList = null;
        List<String> customerRelationList = null;
        List<String> customerRiskList = null;
        List<String> customerRiskPointList = null;
        List<String> stageProcessIds = null;
        if (customerDto != null) {
            labelList = customerDto.getLabelIds();
            overdue = customerDto.getOverdueFollow();
            customerTypeList = customerDto.getCustomerIds();
            custLevelList = customerDto.getCustLevels();
            customerOriginList = customerDto.getCustomerOrigins();
            customerAttributeList = customerDto.getCustomerAttributes();
            tradeList = customerDto.getTrades();
            provinceList = customerDto.getProvinces();
            dealStates = customerDto.getDealStates();
            createTimeTage = customerDto.getCreateTimeFlag();
            trackTimeFlag = customerDto.getTrackTimeFlag();
            ownDepartmentList = customerDto.getOwnDepartments();
            chargePersonIdList = customerDto.getChargePersonIds();
            teamMemberIdList = customerDto.getTeamMemberIds();
            customerStageList = customerDto.getCustStageList();
            corporateScaleList = customerDto.getCorpScaleList();
            corporateImpactList = customerDto.getCorpImpactList();
            listingStatusList = customerDto.getListingStatusList();
            customerRelationList = customerDto.getCustRelationList();
            customerRiskList = customerDto.getCustRiskList();
            customerRiskPointList = customerDto.getRiskPointList();
            stageProcessIds = customerDto.getStageProcessIds();
        }
        String moduleId = AssociativeModuleEnum.CUSTOMER.getModuleId();
        List<String> selectedLabels = excludeInfoMap.get("selectedLabels");
        selectedLabels = this.associativeFiledQueryService.getLabelAssociativeQuery(associativeQueryVoList, keyword, selectedLabels, labelList, moduleId);
        excludeInfoMap.put("selectedLabels", selectedLabels);
        List<String> selectedOverdues = excludeInfoMap.get("selectedOverdues");
        selectedOverdues = this.associativeFiledQueryService.getOverdueAssociativeQuery(associativeQueryVoList, keyword, selectedOverdues, overdue);
        excludeInfoMap.put("selectedOverdues", selectedOverdues);
        List<String> selectedCustomerTypes = excludeInfoMap.get("selectedCustomerTypes");
        selectedCustomerTypes = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerTypes, customerTypeList, AssociativeQueryEnum.CUSTOMER_TYPE);
        excludeInfoMap.put("selectedCustomerTypes", selectedCustomerTypes);
        List<String> selectedCustLevel = excludeInfoMap.get("selectedCustLevel");
        selectedCustLevel = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustLevel, custLevelList, AssociativeQueryEnum.CUSTOMER_LEVEL);
        excludeInfoMap.put("selectedCustLevel", selectedCustLevel);
        List<String> selectedCustomerOrigins = excludeInfoMap.get("selectedCustomerOrigins");
        selectedCustomerOrigins = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerOrigins, customerOriginList, AssociativeQueryEnum.CUSTOMER_SOURCE);
        excludeInfoMap.put("selectedCustomerOrigins", selectedCustomerOrigins);
        List<String> selectedCustomerAttributes = excludeInfoMap.get("selectedCustomerAttributes");
        selectedCustomerAttributes = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerAttributes, customerAttributeList, AssociativeQueryEnum.CUSTOMER_ATTRIBUTE);
        excludeInfoMap.put("selectedCustomerAttributes", selectedCustomerAttributes);
        List<String> selectedTrades = excludeInfoMap.get("selectedTrades");
        selectedTrades = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedTrades, tradeList, AssociativeQueryEnum.CUSTOMER_INDUSTRY);
        excludeInfoMap.put("selectedTrades", selectedTrades);
        List<String> selectedProvinces = excludeInfoMap.get("selectedProvinces");
        selectedProvinces = this.associativeFiledQueryService.getProvinceAssociativeQuery(associativeQueryVoList, keyword, selectedProvinces, provinceList);
        excludeInfoMap.put("selectedProvinces", selectedProvinces);
        List<String> selectDealStates = excludeInfoMap.get("selectDealStates");
        selectDealStates = this.associativeFiledQueryService.getDealStateAssociativeQuery(associativeQueryVoList, keyword, selectDealStates, dealStates);
        excludeInfoMap.put("selectDealStates", selectDealStates);
        List<String> selectedCreateTimes = excludeInfoMap.get("selectedCreateTimes");
        selectedCreateTimes = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedCreateTimes, createTimeTage, AssociativeQueryEnum.CUSTOMER_CREATE_TIME);
        excludeInfoMap.put("selectedCreateTimes", selectedCreateTimes);
        List<String> selectedTrackTimes = excludeInfoMap.get("selectedTrackTimes");
        selectedTrackTimes = this.associativeFiledQueryService.getTimeTageAssociativeQuery(associativeQueryVoList, keyword, selectedTrackTimes, trackTimeFlag, AssociativeQueryEnum.CUSTOMER_TRACK_TIME);
        excludeInfoMap.put("selectedTrackTimes", selectedTrackTimes);
        List<String> selectedOwnDepartments = excludeInfoMap.get("selectedOwnDepartments");
        selectedOwnDepartments = this.associativeFiledQueryService.getOwnDepartmentAssociativeQuery(associativeQueryVoList, keyword, selectedOwnDepartments, ownDepartmentList, AssociativeQueryEnum.CUSTOMER_OWN_DEPARTMENTS);
        excludeInfoMap.put("selectedOwnDepartments", selectedOwnDepartments);
        List<String> selectedChargePersonIds = excludeInfoMap.get("selectedChargePersonIds");
        selectedChargePersonIds = this.associativeFiledQueryService.getChargePersonAssociativeQuery(associativeQueryVoList, keyword, selectedChargePersonIds, chargePersonIdList, AssociativeQueryEnum.CUSTOMER_CHARGE_PERSON);
        excludeInfoMap.put("selectedChargePersonIds", selectedChargePersonIds);
        List<String> selectedTeamMemberIds = excludeInfoMap.get("selectedTeamMemberIds");
        selectedTeamMemberIds = this.associativeFiledQueryService.getTeamMemberIdAssociativeQuery(associativeQueryVoList, keyword, selectedTeamMemberIds, teamMemberIdList);
        excludeInfoMap.put("selectedTeamMemberIds", selectedTeamMemberIds);
        List<String> selectedOpptyStageProcesses = excludeInfoMap.get("selectedOpptyStageProcesses");
        selectedOpptyStageProcesses = this.associativeFiledQueryService.getOpptyStageProcessAssociativeQuery(associativeQueryVoList, keyword, selectedOpptyStageProcesses, stageProcessIds, AssociativeQueryEnum.OPPORTUNITY_STAGE_PROCESS);
        excludeInfoMap.put("selectedOpptyStageProcesses", selectedOpptyStageProcesses);
        List<String> selectedStageId = excludeInfoMap.get("selectedStageId");
        selectedStageId = this.associativeFiledQueryService.getCustomerStageIdAssociativeQuery(associativeQueryVoList, keyword, selectedStageId, customerDto);
        excludeInfoMap.put("selectedStageId", selectedStageId);
        List<String> selectedRelationProduct = excludeInfoMap.get("selectedRelationProduct");
        selectedRelationProduct = this.associativeFiledQueryService.getRelationProductAssociativeQuery(associativeQueryVoList, keyword, selectedRelationProduct, customerDto, AssociativeQueryEnum.CUSTOMER_PRODUCT_TYPES);
        excludeInfoMap.put("selectedRelationProduct", selectedRelationProduct);
        List<String> selectedCustomerStages = excludeInfoMap.get("selectedCustomerStages");
        selectedCustomerStages = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerStages, customerStageList, AssociativeQueryEnum.CUSTOMER_STAGE);
        excludeInfoMap.put("selectedCustomerStages", selectedCustomerStages);
        List<String> selectedCorporateScales = excludeInfoMap.get("selectedCorporateScales");
        selectedCorporateScales = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCorporateScales, corporateScaleList, AssociativeQueryEnum.CORPORATE_SCALE);
        excludeInfoMap.put("selectedCorporateScales", selectedCorporateScales);
        List<String> selectedCorporateImpacts = excludeInfoMap.get("selectedCorporateImpacts");
        selectedCorporateImpacts = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCorporateImpacts, corporateImpactList, AssociativeQueryEnum.CORPORATE_IMPACT);
        excludeInfoMap.put("selectedCorporateImpacts", selectedCorporateImpacts);
        List<String> selectedListingStatusList = excludeInfoMap.get("selectedListingStatusList");
        selectedListingStatusList = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedListingStatusList, listingStatusList, AssociativeQueryEnum.LISTING_STATUS);
        excludeInfoMap.put("selectedListingStatusList", selectedListingStatusList);
        List<String> selectedCustomerRelations = excludeInfoMap.get("selectedCustomerRelations");
        selectedCustomerRelations = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerRelations, customerRelationList, AssociativeQueryEnum.CUSTOMER_RELATION);
        excludeInfoMap.put("selectedCustomerRelations", selectedCustomerRelations);
        List<String> selectedCustomerRiskLisk = excludeInfoMap.get("selectedCustomerRiskLisk");
        selectedCustomerRiskLisk = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerRiskLisk, customerRiskList, AssociativeQueryEnum.CUSTOMER_RISK);
        excludeInfoMap.put("selectedCustomerRiskLisk", selectedCustomerRiskLisk);
        List<String> selectedCustomerRiskPointLisk = excludeInfoMap.get("selectedCustomerRiskPointLisk");
        selectedCustomerRiskPointLisk = this.associativeFiledQueryService.getDictAssociativeQuery(associativeQueryVoList, keyword, selectedCustomerRiskPointLisk, customerRiskPointList, AssociativeQueryEnum.CUSTOMER_RISK_POINT);
        excludeInfoMap.put("selectedCustomerRiskPointLisk", selectedCustomerRiskPointLisk);
        return associativeQueryVoList;
    }
}

