/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.customer.controller;

import com.jxdinfo.crm.core.customer.dto.CustomerMergeDto;
import com.jxdinfo.crm.core.customer.service.ICustomerMergeService;
import com.jxdinfo.crm.core.customer.vo.CustomerMergeVo;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5408\u5e76\u5ba2\u6237\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/customerMerge"})
public class CustomerMergeController {
    @Resource
    private ICustomerMergeService customerMergeService;

    @GetMapping(value={"/getList"})
    @ApiOperation(value="\u83b7\u53d6\u9700\u8981\u5408\u5e76\u5ba2\u6237\u5217\u8868", notes="\u83b7\u53d6\u9700\u8981\u5408\u5e76\u5ba2\u6237\u5217\u8868")
    @AuditLog(moduleName="\u5408\u5e76\u5ba2\u6237\u7ba1\u7406", eventDesc="\u83b7\u53d6\u9700\u8981\u5408\u5e76\u5ba2\u6237\u5217\u8868", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CustomerMergeVo>> getList(@RequestParam(value="customerName", required=false) String customerName, @RequestParam(value="customerIds", required=false) String customerIds) throws Exception {
        List<CustomerMergeVo> customerMergeVoList = this.customerMergeService.getList(customerName, customerIds);
        return ApiResponse.success(customerMergeVoList);
    }

    @PostMapping(value={"/merge"})
    @ApiOperation(value="\u5408\u5e76\u5ba2\u6237", notes="\u5408\u5e76\u5ba2\u6237")
    @AuditLog(moduleName="\u5408\u5e76\u5ba2\u6237\u7ba1\u7406", eventDesc="\u5408\u5e76\u5ba2\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CustomerMergeVo>> merge(@RequestBody CustomerMergeDto dto) {
        int isSuccess = this.customerMergeService.merge(dto);
        if (isSuccess > 0) {
            return ApiResponse.success((String)"\u5408\u5e76\u6210\u529f");
        }
        return ApiResponse.fail((String)"\u5408\u5e76\u5931\u8d25");
    }
}

