/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.core.contactcharacter.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.contact.model.ContactEntity;
import com.jxdinfo.crm.core.contact.service.ContactService;
import com.jxdinfo.crm.core.contactcharacter.dao.ContactCharacterMapper;
import com.jxdinfo.crm.core.contactcharacter.dto.ContactCharacterBatchDto;
import com.jxdinfo.crm.core.contactcharacter.dto.ContactCharacterDto;
import com.jxdinfo.crm.core.contactcharacter.model.ContactCharacterEntity;
import com.jxdinfo.crm.core.contactcharacter.service.ContactCharacterService;
import com.jxdinfo.crm.core.contactcharacter.vo.ContactCharacterTreeVo;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmcontactcharacter1.dao.CrmContactCharacter1Mapper;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ContactCharacterServiceImpl
extends ServiceImpl<ContactCharacterMapper, ContactCharacterEntity>
implements ContactCharacterService {
    @Resource
    private ContactCharacterMapper contactCharacterMapper;
    @Resource
    private CommonService commonService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private ContactService contactService;
    @Resource
    private CustomerService customerService;
    @Resource
    private CrmContactCharacter1Mapper crmContactCharacter1Mapper;

    @Override
    public Page<ContactCharacterEntity> selectContactCharacterOpportunity(ContactCharacterDto dto) {
        Page page = dto.getPage();
        dto.setDelFlag("0");
        List<ContactCharacterEntity> list = this.contactCharacterMapper.selectContactCharacterOpportunity(dto, page);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<ContactCharacterEntity> selectCrmContactCharacterOppoNoPage(ContactCharacterDto dto) {
        dto.setDelFlag("0");
        List<ContactCharacterEntity> list = this.contactCharacterMapper.selectContactCharacterOpportunity(dto, null);
        return list;
    }

    @Override
    public List<String> selectContactCharacterId(ContactCharacterDto dto) {
        return this.contactCharacterMapper.selectContactIdByOpportunityId(dto.getOpportunityId(), "0");
    }

    @Override
    @Transactional
    public boolean addContactCharacter(ContactCharacterEntity contactCharacterEntity) {
        List<String> contactIdList = this.contactCharacterMapper.selectContactIdByOpportunityId(contactCharacterEntity.getOpportunityId(), "0");
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (contactCharacterEntity.getId() == null) {
            if (contactIdList.contains(contactCharacterEntity.getContactId())) {
                throw new BaseException("\u6240\u9009\u5e72\u7cfb\u4eba\u5df2\u5b58\u5728");
            }
            Long contactCharacterId = Long.valueOf(CommonUtills.generateAssignId());
            contactCharacterEntity.setId(contactCharacterId);
            contactCharacterEntity.setDelFlag("0");
            contactCharacterEntity.setCreateTime(date);
            contactCharacterEntity.setCreatePerson(user.getUserId());
            contactCharacterEntity.setCreatePersonName(user.getUserName());
            contactCharacterEntity.setOwnDepartment(user.getDeptId());
            contactCharacterEntity.setOwnDepartmentName(user.getDeptName());
        }
        if (StringUtil.isEmpty((Object)contactCharacterEntity.getOrderNumber())) {
            contactCharacterEntity.setOrderNumber(null);
        }
        contactCharacterEntity.setChangeTime(date);
        contactCharacterEntity.setChangePerson(user.getUserId());
        contactCharacterEntity.setChangePersonName(user.getUserName());
        this.opportunityService.updateChangeTime(contactCharacterEntity.getOpportunityId());
        return this.saveOrUpdate(contactCharacterEntity);
    }

    @Override
    @DSTransactional
    public ApiResponse<String> insertOrUpdateBatch(ContactCharacterBatchDto dto) {
        long contactCount;
        List<ContactCharacterEntity> crmContactCharacterList = dto.getContactCharacterList();
        SecurityUser user = BaseSecurityUtil.getUser();
        List updateIdList = crmContactCharacterList.stream().map(ContactCharacterEntity::getId).filter(Objects::nonNull).collect(Collectors.toList());
        LambdaUpdateWrapper deleteWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ContactCharacterEntity::getDelFlag, (Object)"0")).eq(ContactCharacterEntity::getOpportunityId, (Object)dto.getOpportunityId());
        if (ToolUtil.isNotEmpty(updateIdList)) {
            deleteWrapper.notIn(ContactCharacterEntity::getId, updateIdList);
        }
        deleteWrapper.set(ContactCharacterEntity::getDelFlag, (Object)"1");
        this.update((Wrapper)deleteWrapper);
        List newIdList = crmContactCharacterList.stream().filter(ca -> ToolUtil.isEmpty((Object)ca.getId())).map(ContactCharacterEntity::getContactId).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(newIdList) && (contactCount = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactCharacterEntity::getDelFlag, (Object)"0")).eq(ContactCharacterEntity::getOpportunityId, (Object)dto.getOpportunityId())).in(ContactCharacterEntity::getContactId, newIdList))) > 0L) {
            throw new BaseException("\u6240\u9009\u5e72\u7cfb\u4eba\u5df2\u5b58\u5728");
        }
        for (int i = 0; i < crmContactCharacterList.size(); ++i) {
            ContactCharacterEntity character1 = crmContactCharacterList.get(i);
            Long id = character1.getId();
            if (ToolUtil.isEmpty((Object)id)) {
                character1.setCreateTime(LocalDateTime.now());
                character1.setCreatePerson(user.getUserId());
                character1.setCreatePersonName(user.getUserName());
                character1.setOwnDepartment(user.getDeptId());
                character1.setOwnDepartmentName(user.getDeptName());
                character1.setDelFlag("0");
            }
            character1.setChangeTime(LocalDateTime.now());
            character1.setChangePerson(user.getUserId());
            character1.setChangePersonName(user.getUserName());
        }
        this.opportunityService.updateChangeTime(HussarUtils.toStr((Object)dto.getOpportunityId()));
        this.saveOrUpdateBatch(crmContactCharacterList);
        return ApiResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    public boolean deleteContactCharacter(ContactCharacterDto dto) {
        this.contactCharacterMapper.deleteContactCharacter(dto.getIds(), "1");
        return true;
    }

    @Override
    public List<ContactCharacterEntity> getContactCharacterList(Long opportunityId) {
        if (opportunityId == null) {
            throw new BaseException("\u5546\u673aid\u4e3a\u7a7a");
        }
        ContactCharacterDto dto = new ContactCharacterDto();
        dto.setOpportunityId(opportunityId.toString());
        dto.setDelFlag("0");
        return this.contactCharacterMapper.selectContactCharacterOpportunity(dto, null);
    }

    @Override
    public ContactCharacterEntity getContactCharacterDetails(Long contactCharacterId) {
        if (contactCharacterId == null) {
            throw new BaseException("\u5546\u673a\u5e72\u7cfb\u4eba\u4e3b\u952e\u4e3a\u7a7a");
        }
        ContactCharacterDto dto = new ContactCharacterDto();
        dto.setId(contactCharacterId);
        dto.setDelFlag("0");
        return this.contactCharacterMapper.selectContactCharacterOpportunity(dto);
    }

    @Override
    public ContactCharacterTreeVo selectContactCharacterTreeByOpportunity(ContactCharacterDto dto) {
        List contactCharacterEntityList = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ContactCharacterEntity::getOpportunityId, (Object)dto.getOpportunityId())).eq(ContactCharacterEntity::getDelFlag, (Object)"0"));
        ArrayList<ContactCharacterTreeVo> list = new ArrayList<ContactCharacterTreeVo>();
        ArrayList<ContactCharacterTreeVo> result = new ArrayList<ContactCharacterTreeVo>();
        for (ContactCharacterEntity contactCharacterEntity : contactCharacterEntityList) {
            List treeNodeList;
            String superiorDepartment;
            List treeNodeList2;
            ContactEntity contact = (ContactEntity)this.contactService.getOne((Wrapper)new LambdaQueryWrapper().eq(ContactEntity::getContactId, (Object)contactCharacterEntity.getContactId()));
            ContactCharacterTreeVo contactCharacterTreeNode = this.initContactCharacterTreeVo(contactCharacterEntity.getId().toString(), "", true, false, contactCharacterEntity, contact);
            list.add(contactCharacterTreeNode);
            String department = contact.getDepartment();
            if (ToolUtil.isNotEmpty((Object)department) && ToolUtil.isEmpty(treeNodeList2 = list.stream().filter(treeNode -> treeNode.getOrganName().equals(department)).collect(Collectors.toList()))) {
                ContactCharacterTreeVo organTreeNode = this.initContactCharacterTreeVo("", department, false, false, null, null);
                list.add(organTreeNode);
            }
            if (!ToolUtil.isNotEmpty((Object)(superiorDepartment = contact.getSuperiorDepartment())) || !ToolUtil.isEmpty(treeNodeList = list.stream().filter(treeNode -> treeNode.getOrganName().equals(superiorDepartment)).collect(Collectors.toList()))) continue;
            ContactCharacterTreeVo organTreeNode = this.initContactCharacterTreeVo("", superiorDepartment, false, false, null, null);
            list.add(organTreeNode);
        }
        for (ContactCharacterTreeVo treeNode2 : list) {
            ArrayList<ContactCharacterTreeVo> treeNodeList;
            ContactCharacterTreeVo node;
            if (!ToolUtil.isNotEmpty((Object)treeNode2.getUserFlag()) || !treeNode2.getUserFlag().booleanValue()) continue;
            if (ToolUtil.isNotEmpty((Object)treeNode2.getContact()) && ToolUtil.isNotEmpty((Object)treeNode2.getContact().getDirectSuperior()) && !list.stream().filter(node1 -> (node1.getContact() == null ? "" : node1.getContact().getContactId().toString()).equals(treeNode2.getContact().getDirectSuperior())).collect(Collectors.toList()).isEmpty()) {
                node = (ContactCharacterTreeVo)((Object)list.stream().filter(node1 -> (node1.getContact() == null ? "" : node1.getContact().getContactId().toString()).equals(treeNode2.getContact().getDirectSuperior())).collect(Collectors.toList()).get(0));
                node.setHasChildren(true);
                if (ToolUtil.isEmpty((Object)node.getChildren())) {
                    treeNodeList = new ArrayList();
                    treeNodeList.add(treeNode2);
                    node.setChildren(treeNodeList);
                } else {
                    node.getChildren().add(treeNode2);
                }
                treeNode2.setParentId(node.getId());
            } else if (ToolUtil.isNotEmpty((Object)treeNode2.getContact()) && ToolUtil.isNotEmpty((Object)treeNode2.getContact().getDepartment())) {
                node = (ContactCharacterTreeVo)((Object)list.stream().filter(node1 -> node1.getOrganName().equals(treeNode2.getContact().getDepartment())).collect(Collectors.toList()).get(0));
                node.setHasChildren(true);
                if (ToolUtil.isEmpty((Object)node.getChildren())) {
                    treeNodeList = new ArrayList<ContactCharacterTreeVo>();
                    treeNodeList.add(treeNode2);
                    node.setChildren(treeNodeList);
                } else {
                    node.getChildren().add(treeNode2);
                }
                treeNode2.setParentId((Serializable)((Object)node.getOrganName()));
            }
            if (!ToolUtil.isNotEmpty((Object)treeNode2.getContact()) || !ToolUtil.isNotEmpty((Object)treeNode2.getContact().getDepartment()) || !ToolUtil.isNotEmpty((Object)treeNode2.getContact().getSuperiorDepartment())) continue;
            node = (ContactCharacterTreeVo)((Object)list.stream().filter(node1 -> node1.getOrganName().equals(treeNode2.getContact().getDepartment())).collect(Collectors.toList()).get(0));
            ContactCharacterTreeVo nodeSuper = (ContactCharacterTreeVo)((Object)list.stream().filter(node1 -> node1.getOrganName().equals(treeNode2.getContact().getSuperiorDepartment())).collect(Collectors.toList()).get(0));
            if (!ToolUtil.isEmpty((Object)node.getParentId())) continue;
            nodeSuper.setHasChildren(true);
            if (ToolUtil.isEmpty((Object)nodeSuper.getChildren())) {
                ArrayList<ContactCharacterTreeVo> treeNodeList3 = new ArrayList<ContactCharacterTreeVo>();
                treeNodeList3.add(node);
                nodeSuper.setChildren(treeNodeList3);
            } else {
                nodeSuper.getChildren().add(node);
            }
            node.setParentId((Serializable)((Object)nodeSuper.getOrganName()));
        }
        for (ContactCharacterTreeVo treeNode2 : list) {
            if (!ToolUtil.isEmpty((Object)treeNode2.getParentId())) continue;
            result.add(treeNode2);
        }
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById((Serializable)((Object)dto.getOpportunityId()));
        String customerName = ((CustomerEntity)this.customerService.getById(opportunity.getCustomerId())).getCustomerName();
        ContactCharacterTreeVo root = this.initContactCharacterTreeVo("", customerName, false, true, null, null);
        for (ContactCharacterTreeVo contactCharacterTreeVo : result) {
            contactCharacterTreeVo.setParentId((Serializable)((Object)root.getOrganName()));
        }
        root.setChildren(result);
        root.setHasChildren(true);
        root.setId((Serializable)((Object)((CustomerEntity)this.customerService.getById(opportunity.getCustomerId())).getCustomerId().toString()));
        return root;
    }

    public ContactCharacterTreeVo initContactCharacterTreeVo(String id, String organName, Boolean userFlag, Boolean hasChildren, ContactCharacterEntity contactCharacter, ContactEntity contact) {
        ContactCharacterTreeVo contactCharacterTreeNode = new ContactCharacterTreeVo();
        if (userFlag.booleanValue()) {
            contactCharacterTreeNode.setUserFlag(true);
            contactCharacterTreeNode.setOrganName("");
            contactCharacterTreeNode.setHasChildren(false);
            contactCharacterTreeNode.setContactCharacter(contactCharacter);
            contactCharacterTreeNode.setContact(contact);
            contactCharacterTreeNode.setId((Serializable)((Object)id));
        } else {
            contactCharacterTreeNode.setUserFlag(false);
            contactCharacterTreeNode.setHasChildren(false);
            contactCharacterTreeNode.setOrganName(organName);
            contactCharacterTreeNode.setId((Serializable)((Object)""));
        }
        return contactCharacterTreeNode;
    }

    @Override
    public List<ContactEntity> getOPPContactCharacter(ContactCharacterDto dto) {
        List<Long> contactIdList = this.crmContactCharacter1Mapper.selectContactIdByOpportunityId(Long.valueOf(dto.getOpportunityId()), "0");
        ArrayList<String> contactIdListTemp = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(contactIdList)) {
            if (ToolUtil.isNotEmpty(dto.getContactIds())) {
                for (String contactId : dto.getContactIds()) {
                    if (contactIdList.contains(Long.valueOf(contactId))) continue;
                    contactIdListTemp.add(contactId);
                }
            }
        } else {
            contactIdListTemp.addAll(dto.getContactIds());
        }
        List<ContactEntity> contactEntityList = new ArrayList<ContactEntity>();
        if (ToolUtil.isNotEmpty(contactIdListTemp) && CollectionUtil.isNotEmpty(contactEntityList = this.contactService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(ContactEntity::getContactId, contactIdListTemp)).eq(ContactEntity::getDelFlag, (Object)"0")))) {
            for (ContactEntity contactEntity : contactEntityList) {
                String telephone = contactEntity.getMobilePhone();
                if (!StringUtil.isNotEmpty((Object)telephone)) continue;
                contactEntity.setMobilePhone(StringUtils.overlay((String)telephone, (String)"****", (int)3, (int)7));
            }
        }
        return contactEntityList;
    }
}

