/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.fileinfo.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.crm.common.api.fileInfo.dto.FileInfoAPIDto;
import com.jxdinfo.crm.common.api.fileInfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.common.api.fileInfo.vo.FileInfoAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.common.fileinfo.dto.FileInfoDto;
import com.jxdinfo.crm.common.fileinfo.model.FileInfo;
import com.jxdinfo.crm.common.fileinfo.service.FileInfoService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class FileInfoAPIServiceImpl
implements IFileInfoAPIService {
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private FileInfoService fileInfoService;

    public int insertFileInfo(FileInfoAPIDto fileInfoDto) {
        if (fileInfoDto == null || CollectionUtils.isEmpty((Collection)fileInfoDto.getIds())) {
            return -1;
        }
        FileInfoDto dto = (FileInfoDto)((Object)HussarUtils.copyProperties((Object)fileInfoDto, FileInfoDto.class));
        return this.fileInfoService.insertFileInfo(dto);
    }

    public void deleteHighSecurityLevelFileInfo(Long businessId, Integer securityLevel) {
        if (securityLevel == null) {
            return;
        }
        LambdaQueryWrapper fileInfoQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, new Object[]{businessId})).ne(FileInfo::getDelFlag, (Object)"1");
        fileInfoQueryWrapper.gt(FileInfo::getSecurityLevel, (Object)securityLevel);
        List fileInfoList = this.fileInfoMapper.selectList((Wrapper)fileInfoQueryWrapper);
        if (HussarUtils.isNotEmpty((Object)fileInfoList)) {
            List<Long> lids = fileInfoList.stream().map(FileInfo::getId).collect(Collectors.toList());
            this.fileInfoMapper.deleteFileInfoByIds(lids, null, "1");
        }
    }

    public void updateTrackFileInfoSecurityLevel(Long businessId, Integer securityLevel) {
        List trackRecordIds = this.trackRecordAPIService.selectTrackRecordIdByBusinessId(businessId);
        if (CollectionUtils.isNotEmpty((Collection)trackRecordIds)) {
            this.fileInfoService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(FileInfo::getBusinessId, (Collection)trackRecordIds)).eq(FileInfo::getDelFlag, (Object)"0")).set(FileInfo::getSecurityLevel, (Object)securityLevel));
        }
    }

    public Long countFile(FileInfoAPIDto fileInfoDto) {
        String businessId;
        ArrayList businessIds = fileInfoDto.getBusinessIds();
        if (businessIds == null) {
            businessIds = new ArrayList();
        }
        if (StringUtils.isNotEmpty((CharSequence)(businessId = fileInfoDto.getBusinessId()))) {
            List thisBusinessIds = Arrays.stream(businessId.split(",")).map(Long::parseLong).collect(Collectors.toList());
            businessIds.addAll(thisBusinessIds);
        }
        LambdaQueryWrapper fileInfoQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, businessIds)).ne(FileInfo::getDelFlag, (Object)"1");
        if (HussarUtils.isNotEmpty((Object)fileInfoDto.getSecurityLevel())) {
            fileInfoQueryWrapper.le(FileInfo::getSecurityLevel, (Object)fileInfoDto.getSecurityLevel());
        }
        return this.fileInfoService.count((Wrapper)fileInfoQueryWrapper);
    }

    public int deleteFileInfoByIds(List<Long> ids, List<Long> businessIds) {
        return this.fileInfoMapper.deleteFileInfoByIds(ids, businessIds, "1");
    }

    public List<FileInfoAPIVo> selectFileInfoList(FileInfoAPIDto fileInfoDto) {
        List fileInfoList;
        LambdaQueryWrapper fileInfoQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getBusinessId, new Object[]{fileInfoDto.getBusinessId()})).ne(FileInfo::getDelFlag, (Object)"1");
        if (HussarUtils.isNotEmpty((Object)fileInfoDto.getSecurityLevel())) {
            fileInfoQueryWrapper.le(FileInfo::getSecurityLevel, (Object)fileInfoDto.getSecurityLevel());
        }
        if (CollectionUtils.isNotEmpty((Collection)(fileInfoList = this.fileInfoService.list((Wrapper)fileInfoQueryWrapper)))) {
            return HussarUtils.copyProperties((Collection)fileInfoList, FileInfoAPIVo.class);
        }
        return null;
    }

    public boolean mergeFileInfo(List<Long> deleteLeadsIdList, Long primaryLeadsId) {
        return this.fileInfoService.mergeFileInfo(deleteLeadsIdList, primaryLeadsId);
    }

    public boolean insertFileInfoBatch(List<FileInfoAPIDto> fileInfoAPIDtoList) {
        if (CollectionUtils.isNotEmpty(fileInfoAPIDtoList)) {
            ArrayList<FileInfoDto> fileInfoDtoList = new ArrayList();
            fileInfoDtoList = HussarUtils.copyProperties(fileInfoAPIDtoList, FileInfoDto.class);
            this.fileInfoService.insertFileInfoBatch(fileInfoDtoList);
        }
        return false;
    }

    public List<FileInfoAPIVo> listNotDelByIds(Collection<? extends Serializable> ids) {
        List list = this.fileInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(FileInfo::getId, ids)).eq(FileInfo::getDelFlag, (Object)"0"));
        return BeanUtil.copyToList((Collection)list, FileInfoAPIVo.class);
    }

    public List<FileInfoAPIVo> listByIds(Collection<? extends Serializable> ids) {
        List list = this.fileInfoService.listByIds(ids);
        return BeanUtil.copyToList((Collection)list, FileInfoAPIVo.class);
    }

    public boolean updateBatchExtendBusinessId(FileInfoAPIDto fileInfoDto) {
        return this.fileInfoService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(FileInfo::getId, (Collection)fileInfoDto.getFileInfoIds())).set(FileInfo::getExtendBusinessId, (Object)fileInfoDto.getExtendBusinessId()));
    }

    public boolean updateBatchFileId(FileInfoAPIDto fileInfoDto) {
        return this.fileInfoService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(FileInfo::getId, (Collection)fileInfoDto.getFileInfoIds())).set(FileInfo::getBusinessId, (Object)fileInfoDto.getBusinessId()));
    }

    public Long countFileAndExtendBusinessId(FileInfoAPIDto fileInfoDto) {
        LambdaQueryWrapper fileInfoQueryWrapper = new LambdaQueryWrapper();
        if (HussarUtils.isEmpty((Object)fileInfoDto.getExtendBusinessId())) {
            ((LambdaQueryWrapper)fileInfoQueryWrapper.in(FileInfo::getBusinessId, new Object[]{fileInfoDto.getBusinessId()})).ne(FileInfo::getDelFlag, (Object)"1");
        } else {
            ((LambdaQueryWrapper)fileInfoQueryWrapper.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.in(FileInfo::getBusinessId, (Collection)fileInfoDto.getBusinessIds())).or()).eq(FileInfo::getExtendBusinessId, (Object)fileInfoDto.getExtendBusinessId());
            })).ne(FileInfo::getDelFlag, (Object)"1");
        }
        if (HussarUtils.isNotEmpty((Object)fileInfoDto.getSecurityLevel())) {
            fileInfoQueryWrapper.le(FileInfo::getSecurityLevel, (Object)fileInfoDto.getSecurityLevel());
        }
        return this.fileInfoService.count((Wrapper)fileInfoQueryWrapper);
    }
}

