/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.fileinfo.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.config.CommonUnifyProperties;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.docbase.service.DocbaseService;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.fileinfo.dao.FileInfoMapper;
import com.jxdinfo.crm.common.fileinfo.dto.FileInfoDto;
import com.jxdinfo.crm.common.fileinfo.model.FileDownload;
import com.jxdinfo.crm.common.fileinfo.model.FileInfo;
import com.jxdinfo.crm.common.fileinfo.service.FileDownloadService;
import com.jxdinfo.crm.common.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.common.fileinfo.sync.SyncFileInfoCallable;
import com.jxdinfo.crm.common.message.dto.AddSysMessageType;
import com.jxdinfo.crm.common.message.util.EimPushUtil;
import com.jxdinfo.crm.common.message.util.UnifyUtil;
import com.jxdinfo.crm.core.api.product.service.IProductAPIService;
import com.jxdinfo.crm.core.api.product.vo.ProductAPIVo;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.entity.ContentType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class FileInfoServiceImpl
extends ServiceImpl<FileInfoMapper, FileInfo>
implements FileInfoService {
    @Resource
    private FileInfoMapper fileInfoMapper;
    @Resource
    private ITrackRecordAPIService trackRecordAPIService;
    @Resource
    private AttachmentManagerService attachmentManagerService;
    @Resource
    private FileDownloadService fileDownloadService;
    @Resource
    private DocbaseService docbaseService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private IProductAPIService productAPIService;
    @Resource
    private CommonUnifyProperties commonUnifyProperties;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private IHussarBaseUserBoService iHussarBaseUserBoService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;

    @Override
    public Page<FileInfo> selectFileInfoByBusinessId(FileInfoDto dto) {
        Page page = new Page(1L, -1L);
        long businessId = Long.valueOf(dto.getBusinessId());
        SecurityUser user = BaseSecurityUtil.getUser();
        Integer userSecurityLevel = user.getSecurityLevel();
        List trackRecordList = this.trackRecordAPIService.queryTrackRecordList(Long.valueOf(businessId));
        ArrayList<Long> lids = new ArrayList<Long>();
        List<Object> list = new ArrayList();
        lids.add(businessId);
        for (TrackRecordAPIVo trackRecord : trackRecordList) {
            if (!ToolUtil.isNotEmpty((Object)trackRecord)) continue;
            lids.add(trackRecord.getRecordId());
        }
        if (null != lids && lids.size() != 0) {
            list = this.fileInfoMapper.selectFileInfoByBusinessId(lids, page, "0", userSecurityLevel);
        }
        page.setRecords(list);
        return page;
    }

    @Override
    public List<FileInfo> selectFileInfoFromTrackRecord(FileInfoDto dto) {
        long businessId = Long.valueOf(dto.getBusinessId());
        String enclosureType = dto.getEnclosureType();
        return this.fileInfoMapper.selectFileInfoFromTrackRecord(businessId, enclosureType, "0");
    }

    @Override
    @Transactional
    public Map<String, Object> upload(MultipartHttpServletRequest multipartRequest, String enclosureType, String attachmentType, String docbase, String businessType, String businessId, String securityLevel) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String uploadPerson = user.getUserName();
        LocalDateTime date = LocalDateTime.now();
        FileInfo fileInfo = new FileInfo();
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (multipartRequest.getFileMap().isEmpty()) {
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6587\u4ef6");
        }
        long id = Long.parseLong(CommonUtills.generateAssignId());
        AttachmentManagerModelVo attachment = null;
        try {
            ApiResponse response = this.attachmentManagerService.uploadFileWithDrag(multipartRequest, Long.valueOf(id));
            attachment = (AttachmentManagerModelVo)response.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
        try {
            if (this.crmProperties.getDocbase().isDocbaseEnable() && "1".equals(docbase)) {
                String docbaseFileId = "";
                ProductAPIVo product = this.productAPIService.getProductById(Long.valueOf(Long.parseLong(businessId)));
                MultipartFile file = multipartRequest.getFile("files");
                JSONObject tokenObject = this.docbaseService.getToken(String.valueOf(user.getUserId()), user.getUserName());
                String accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
                JSONObject resultObject = this.docbaseService.uploadFile(String.valueOf(user.getUserId()), user.getUserName(), accessToken, attachment.getId().toString(), file, product.getFolderId());
                docbaseFileId = JSONObject.parseObject((String)resultObject.get((Object)"result").toString()).get((Object)"fileId").toString();
                if (ToolUtil.isEmpty((Object)docbaseFileId)) {
                    throw new BaseException("\u4e0a\u4f20\u6587\u5e93\u5931\u8d25");
                }
                fileInfo.setDocbaseFileId(docbaseFileId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String fileName = attachment.getAttachmentName();
        String fileType = attachment.getAttachmentType();
        double fileSize = Double.parseDouble(attachment.getBytes());
        fileInfo.setId(attachment.getId());
        fileInfo.setFileName(fileName);
        fileInfo.setFileType(fileType);
        fileInfo.setFilePath(attachment.getPath());
        fileInfo.setFileSize(fileSize / 1024.0);
        fileInfo.setEnclosureType(enclosureType);
        fileInfo.setUploadTime(LocalDateTime.now());
        fileInfo.setUploadPerson(uploadPerson);
        fileInfo.setDelFlag("0");
        fileInfo.setFileFrom("1");
        if (attachmentType != null) {
            fileInfo.setAttachmentType(attachmentType);
        }
        if (HussarUtils.isNotEmpty((Object)securityLevel)) {
            fileInfo.setSecurityLevel(Integer.valueOf(securityLevel));
        }
        this.fileInfoMapper.insertFileInfo(fileInfo);
        map.put("id", attachment.getId());
        return map;
    }

    @Override
    @Transactional
    public String multiUpload(MultipartHttpServletRequest multipartRequest, FileInfoDto dto) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String uploadPerson = user.getUserName();
        List<String> ids = dto.getIds();
        List<String> imageFormats = Arrays.asList("jpg", "jpeg", "png", "gif", "bmp", "webp");
        List attachments = new ArrayList();
        dto.setBusinessType("2");
        if (CollectionUtil.isNotEmpty(ids)) {
            this.deleteFileInfoByIds(dto);
        }
        try {
            long id = Long.parseLong(CommonUtills.generateAssignId());
            attachments = this.attachmentManagerService.uploadMultipleFile(multipartRequest, Long.valueOf(id));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u4e0a\u4f20\u5931\u8d25");
        }
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (int i = 0; i < attachments.size(); ++i) {
            AttachmentManagerModelVo attachment = (AttachmentManagerModelVo)attachments.get(i);
            FileInfo fileInfo = new FileInfo();
            fileInfo.setId(attachment.getId());
            fileInfo.setFileName(attachment.getAttachmentName());
            fileInfo.setFileType(attachment.getAttachmentType());
            fileInfo.setFilePath(attachment.getPath());
            fileInfo.setFileSize(Double.parseDouble(attachment.getBytes()) / 1024.0);
            if (imageFormats.contains(attachment.getAttachmentType().toLowerCase())) {
                fileInfo.setEnclosureType("2");
            } else {
                fileInfo.setEnclosureType("1");
            }
            fileInfo.setUploadTime(LocalDateTime.now());
            fileInfo.setUploadPerson(uploadPerson);
            fileInfo.setDelFlag("0");
            fileInfo.setFileFrom("2");
            if (dto.getAttachmentType() != null) {
                fileInfo.setAttachmentType(dto.getAttachmentType());
            }
            if (HussarUtils.isNotEmpty(dto.getSecurityLevelList()) && HussarUtils.isNotEmpty((Object)dto.getSecurityLevelList().get(i))) {
                fileInfo.setSecurityLevel(dto.getSecurityLevelList().get(i));
            }
            fileInfo.setBusinessId(Long.parseLong(dto.getBusinessId()));
            fileInfo.setBusinessType(dto.getBusinessType());
            fileInfoList.add(fileInfo);
        }
        this.saveOrUpdateBatch(fileInfoList);
        this.fileSaveOperateLog(null, fileInfoList, dto.getBusinessType(), RecordProductTypeEnum.UPLOAD_FILE);
        return "\u4fdd\u5b58\u6210\u529f";
    }

    @Override
    public int insertFileInfo(FileInfoDto fileInfoDto) {
        List<String> ids = fileInfoDto.getIds();
        if (CollectionUtil.isEmpty(ids)) {
            return 0;
        }
        String businessId = fileInfoDto.getBusinessId();
        if (CollectionUtil.isEmpty(ids)) {
            return -1;
        }
        ArrayList<String> idTemp = new ArrayList<String>();
        for (String id : ids) {
            if (!ToolUtil.isNotEmpty((Object)id)) continue;
            idTemp.add(id);
        }
        if (CollectionUtil.isEmpty(idTemp)) {
            return -1;
        }
        List<Long> lids = idTemp.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        return this.fileInfoMapper.updateBusinessIdByIds(lids, Long.parseLong(businessId));
    }

    @Override
    public void insertFileInfoBatch(List<FileInfoDto> fileInfoDtoList) {
        if (CollectionUtil.isEmpty(fileInfoDtoList)) {
            return;
        }
        ArrayList<String> fileIdList = new ArrayList<String>();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (FileInfoDto fileInfoDto : fileInfoDtoList) {
            fileIdList.addAll(fileInfoDto.getIds());
            for (String id : fileInfoDto.getIds()) {
                tempMap.put(id, fileInfoDto.getBusinessId());
            }
        }
        List fileInfoList = this.fileInfoMapper.selectBatchIds(fileIdList);
        for (FileInfo fileInfo : fileInfoList) {
            fileInfo.setBusinessId(Long.parseLong((String)tempMap.get(String.valueOf(fileInfo.getId()))));
        }
        this.updateBatchById(fileInfoList);
    }

    @Override
    @Transactional
    public String deleteFileInfoByIds(FileInfoDto fileInfoDto) {
        FileInfo fileInfo;
        Long businessId;
        ProductAPIVo product;
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        List<String> ids = fileInfoDto.getIds();
        List<Long> lids = ids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        ArrayList<String> fileNames = new ArrayList<String>();
        Iterator iterator = lids.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            FileInfo fileInfo2 = this.fileInfoMapper.selectFileInfoById(id, "0");
            if (null == fileInfo2) {
                return "\u672a\u627e\u5230\u6587\u4ef6";
            }
            fileNames.add(fileInfo2.getFileName());
            this.attachmentManagerService.deleteFile(Long.valueOf(id));
        }
        if (CollectionUtil.isNotEmpty(fileNames) && ToolUtil.isNotEmpty((Object)(product = this.productAPIService.getProductById(businessId = Long.valueOf((fileInfo = (FileInfo)this.fileInfoMapper.selectById((Serializable)((Object)ids.get(0)))).getBusinessId())))) && CollectionUtil.isNotEmpty(fileNames)) {
            String fileName = String.join((CharSequence)"\u3001", fileNames);
            ArrayList<Long> pushRoleIds = new ArrayList<Long>();
            pushRoleIds.add(Long.valueOf(this.crmCommonProperties.getRoles().getSalesman()));
            pushRoleIds.add(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM()));
            List pushPerson = this.iHussarBaseUserBoService.getUserInfoByRoleId(pushRoleIds);
            ArrayList<String> pushPersonIds = new ArrayList();
            if (CollectionUtil.isNotEmpty((Collection)pushPerson)) {
                pushPersonIds = pushPerson.stream().map(UserVo::getId).map(String::valueOf).distinct().collect(Collectors.toList());
            }
            if (CollectionUtil.isNotEmpty(pushPersonIds)) {
                String title = "\u3010" + product.getShortName() + "\u3011\u4ea7\u54c1\u8d44\u6599\u66f4\u65b0";
                String content = "\u5220\u9664\u3010" + fileName + "\u3011\uff0c\u8bf7\u77e5\u6089\u3002";
                EimPushUtil.pushJqxArticleMessage(title, content, "/chanpinguanli/01pageFolder/chanpin/cpxq", String.valueOf(businessId), pushPersonIds);
                AddSysMessageType addSysMessageType = new AddSysMessageType();
                String userIdToString = StringUtil.join(pushPersonIds, (String)",");
                String unifyWebUrl = this.commonUnifyProperties.getCrmUrl() + "/crm/productDetails?row=" + "\"" + businessId + "\"";
                String contentUnify = "\u3010\u4ea7\u54c1\u8d44\u6599\u66f4\u65b0\u3011\u3010" + product.getShortName() + "\u3011\u4ea7\u54c1\u8d44\u6599\u66f4\u65b0\uff1a\u5220\u9664\u3010" + fileName + "\u3011\uff0c\u8bf7\u77e5\u6089";
                UnifyUtil.defaultMessage(addSysMessageType, contentUnify, date, user, userIdToString, user.getUserName(), unifyWebUrl, "");
                UnifyUtil.sendMessage(addSysMessageType);
            }
        }
        int i = this.fileInfoMapper.deleteFileInfoByIds(lids, null, "1");
        if (this.crmProperties.getDocbase().isDocbaseEnable() && fileInfoDto.getDocbase() != null && fileInfoDto.getDocbase().equals("1")) {
            String fids = ids.stream().collect(Collectors.joining(","));
            this.docbaseService.deleteFile(user.getUserName(), user.getUserName(), "", fids);
        }
        if (i > 0) {
            this.fileSaveOperateLog(ids.stream().map(Long::parseLong).collect(Collectors.toList()), null, fileInfoDto.getBusinessType(), RecordProductTypeEnum.DELETE_FILE);
            return "\u5220\u9664\u6210\u529f";
        }
        return "\u6570\u636e\u5220\u9664\u5931\u8d25";
    }

    @Override
    @Transactional
    public void fileDownload(HttpServletResponse response, String fileId, Long userId, String type, String businessType, boolean countFlag) throws ServletException, IOException {
        String[] fileIdArr = fileId.split(",");
        LocalDateTime date = LocalDateTime.now();
        if (countFlag) {
            SecurityUser user = this.fileDownloadService.getUserInfoByUserId(userId);
            if (user == null) {
                throw new BaseException("\u7528\u6237\u4e0d\u5b58\u5728");
            }
            for (String fileIdStr : fileIdArr) {
                FileDownload download = new FileDownload();
                download.setDownloadId(Long.parseLong(CommonUtills.generateAssignId()));
                download.setCreateTime(date);
                download.setFileId(Long.valueOf(fileIdStr));
                download.setCreateDepartment(user.getDeptId());
                download.setCreateDepartmentName(user.getDeptName());
                download.setCreatePersion(user.getUserId());
                download.setCreatePersionName(user.getUserName());
                this.fileDownloadService.save(download);
            }
        }
        if (fileIdArr.length == 1) {
            if (StringUtil.isNotBlank((CharSequence)type) && "web".equals(type)) {
                this.attachmentManagerService.batchDownload(fileId, response);
            } else {
                this.attachmentManagerService.fileDownload(response, Long.valueOf(fileIdArr[0]));
            }
        }
        if (fileIdArr.length > 1) {
            this.attachmentManagerService.batchDownload(fileId, response);
        }
        this.fileSaveOperateLog(Arrays.stream(fileIdArr).map(Long::parseLong).collect(Collectors.toList()), null, businessType, RecordProductTypeEnum.DOWNLOAD_FILE);
    }

    private void fileSaveOperateLog(List<Long> fileIds, List<FileInfo> fileInfoList, String businessType, RecordProductTypeEnum produceType) {
        if (HussarUtils.isEmpty(fileIds) && HussarUtils.isEmpty(fileInfoList)) {
            return;
        }
        if (HussarUtils.isEmpty(fileInfoList)) {
            fileInfoList = this.list((Wrapper)new QueryWrapper().lambda().in(FileInfo::getId, fileIds));
        }
        fileInfoList.removeIf(fileInfo -> !"2".equals(fileInfo.getFileFrom()));
        if (HussarUtils.isEmpty(fileInfoList)) {
            return;
        }
        List fileNames = fileInfoList.stream().map(FileInfo::getFileName).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty((Object)businessType)) {
            CrmBusinessTypeEnum crmBusinessTypeEnum = CrmBusinessTypeEnum.getEnumByModuleId((String)businessType);
            OperateRecordAPIVo trackRecord = new OperateRecordAPIVo();
            trackRecord.setProduceType(produceType.getId());
            trackRecord.setBusinessType(businessType);
            trackRecord.setRecordContent(String.join((CharSequence)"\u3001", fileNames));
            this.operateRecordAPIService.saveOperateLog(trackRecord, crmBusinessTypeEnum, Long.valueOf(((FileInfo)fileInfoList.get(0)).getBusinessId()), "", LocalDateTime.now(), false, new ArrayList());
        }
    }

    @Override
    @Transactional
    public String previewFile(String id) {
        FileInfo fileInfo = (FileInfo)this.getById((Serializable)((Object)id));
        if (ToolUtil.isEmpty((Object)fileInfo.getDocbaseFileId())) {
            throw new BaseException("\u9644\u4ef6\u672a\u4e0a\u4f20\u6587\u5e93\u65e0\u6cd5\u9884\u89c8");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String accessToken = "";
        JSONObject tokenObject = this.docbaseService.getToken(user.getUserName(), user.getUserName());
        if (tokenObject.get((Object)"code").equals("1")) {
            accessToken = JSONObject.parseObject((String)tokenObject.get((Object)"result").toString()).get((Object)"accessToken").toString();
        }
        JSONObject resultObject = this.docbaseService.previewFile(user.getUserName(), user.getUserName(), accessToken, fileInfo.getDocbaseFileId());
        String url = "";
        if (resultObject.get((Object)"code").equals("1")) {
            url = JSONObject.parseObject((String)resultObject.get((Object)"result").toString()).getString("filepath");
        }
        return url;
    }

    @Override
    @Transactional
    public boolean syncFile() {
        List products = this.productAPIService.getProductListHasFolderId();
        if (CollectionUtil.isNotEmpty((Collection)products)) {
            try {
                for (ProductAPIVo product : products) {
                    if (!ToolUtil.isNotEmpty((Object)product.getFolderId())) continue;
                    List fileInfoList = this.fileInfoMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FileInfo::getDelFlag, (Object)"0")).eq(FileInfo::getBusinessId, (Object)product.getProductId())).isNull(FileInfo::getDocbaseFileId));
                    for (FileInfo fileInfo : fileInfoList) {
                        if (!StringUtil.isEmpty((Object)fileInfo.getDocbaseFileId())) continue;
                        File file = new File(fileInfo.getFilePath());
                        if (!file.exists()) {
                            System.out.println("\u540c\u6b65\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a" + fileInfo.getFilePath());
                            continue;
                        }
                        MultipartFile file1 = this.getMultipartFile(file, fileInfo.getFileName());
                        SyncFileInfoCallable fileInfoCallable = new SyncFileInfoCallable();
                        fileInfoCallable.setUserName(product.getProductManagerName());
                        fileInfoCallable.setAccessToken("");
                        fileInfoCallable.setFile(file1);
                        fileInfoCallable.setId(String.valueOf(fileInfo.getId()));
                        fileInfoCallable.setFileName(fileInfo.getFileName());
                        fileInfoCallable.setFolderId(product.getFolderId());
                        fileInfoCallable.call();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean mergeFileInfo(List<Long> oldBusinessIdList, Long newBusinessId) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(FileInfo::getBusinessId, oldBusinessIdList)).set(FileInfo::getBusinessId, (Object)newBusinessId));
        return true;
    }

    @Override
    public boolean isHigherSecurityLevel(String businessId, String securityLevel) {
        return this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(FileInfo::getBusinessId, (Object)Long.parseLong(businessId))).ne(FileInfo::getDelFlag, (Object)"1")).gt(FileInfo::getSecurityLevel, (Object)Integer.parseInt(securityLevel))) > 0L;
    }

    @Override
    public Long downloadCount(String id) {
        return this.fileDownloadService.count((Wrapper)new LambdaQueryWrapper().eq(FileDownload::getFileId, (Object)id));
    }

    private MultipartFile getMultipartFile(File file, String fileName) {
        FileInputStream fileInputStream = null;
        MockMultipartFile multipartFile = null;
        try {
            fileInputStream = new FileInputStream(file);
            multipartFile = new MockMultipartFile(fileName, fileName, ContentType.APPLICATION_OCTET_STREAM.toString(), (InputStream)fileInputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return multipartFile;
    }
}

