/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.phrases.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.phrases.dao.PhrasesMapper;
import com.jxdinfo.crm.common.phrases.dao.PhrasesUserMapper;
import com.jxdinfo.crm.common.phrases.dto.PhrasesDto;
import com.jxdinfo.crm.common.phrases.model.CommonUsePhrases;
import com.jxdinfo.crm.common.phrases.model.CommonUsePhrasesUser;
import com.jxdinfo.crm.common.phrases.service.PhrasesService;
import com.jxdinfo.crm.common.phrases.service.PhrasesUserService;
import com.jxdinfo.crm.common.phrases.vo.PhrasesVo;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PhrasesServiceImpl
extends HussarServiceImpl<PhrasesMapper, CommonUsePhrases>
implements PhrasesService {
    @Resource
    private PhrasesMapper phrasesMapper;
    @Resource
    private PhrasesUserMapper phrasesUserMapper;
    @Resource
    private PhrasesUserService phrasesUserService;

    @Override
    @Transactional
    public List<PhrasesVo> getPhrasesList(String type) {
        SecurityUser user = BaseSecurityUtil.getUser();
        List<PhrasesVo> phrases = this.phrasesMapper.selectUserPhrases(user.getUserId(), type);
        if (CollectionUtil.isEmpty(phrases)) {
            List list = this.phrasesMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonUsePhrases::getPhrasesScope, (Object)1)).eq(CommonUsePhrases::getType, (Object)type));
            for (CommonUsePhrases commonUsePhrases : list) {
                PhrasesVo phrasesVo = new PhrasesVo();
                phrasesVo.setPhrasesScope(commonUsePhrases.getPhrasesScope());
                phrasesVo.setPhrasesContent(commonUsePhrases.getPhrasesContent());
                phrasesVo.setPhrasesId(commonUsePhrases.getPhrasesId());
                phrasesVo.setType(commonUsePhrases.getType());
                phrases.add(phrasesVo);
            }
        }
        return phrases;
    }

    @Override
    @Transactional
    public Boolean savePhrases(List<PhrasesDto> list) {
        if (list.isEmpty()) {
            throw new RuntimeException("\u6700\u5c11\u914d\u7f6e1\u6761\u5e38\u7528\u8bed");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        String type = list.get(0).getType();
        this.phrasesUserMapper.deleteByUserIdAndType(user.getUserId(), type);
        this.phrasesMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(HussarBaseEntity::getCreator, (Object)user.getUserId())).eq(CommonUsePhrases::getType, (Object)type));
        List phrasesIdList = list.stream().map(PhrasesDto::getPhrasesId).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
        List spList = new ArrayList();
        if (phrasesIdList.size() > 0) {
            spList = this.phrasesMapper.selectList((Wrapper)new LambdaQueryWrapper().in(CommonUsePhrases::getPhrasesId, phrasesIdList));
        }
        block0: for (CommonUsePhrases sp : spList) {
            for (PhrasesDto dto : list) {
                if (!"1".equals(dto.getPhrasesScope()) || !Objects.equals(sp.getPhrasesId(), dto.getPhrasesId()) || sp.getPhrasesContent().equals(dto.getPhrasesContent())) continue;
                dto.setPhrasesScope("2");
                continue block0;
            }
        }
        ArrayList<CommonUsePhrases> savePhrasesList = new ArrayList<CommonUsePhrases>();
        ArrayList<CommonUsePhrasesUser> savePhrasesUserList = new ArrayList<CommonUsePhrasesUser>();
        for (int i = 0; i < list.size(); ++i) {
            CommonUsePhrases p = new CommonUsePhrases();
            PhrasesDto dto = list.get(i);
            if (!"2".equals(dto.getPhrasesScope())) continue;
            p.setPhrasesContent(dto.getPhrasesContent());
            p.setPhrasesScope("2");
            p.setType(type);
            savePhrasesList.add(p);
        }
        this.saveBatch(savePhrasesList);
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            CommonUsePhrasesUser pu = new CommonUsePhrasesUser();
            if (!"1".equals(list.get(i).getPhrasesScope())) {
                list.get(i).setPhrasesId(((CommonUsePhrases)((Object)savePhrasesList.get(n))).getPhrasesId());
                ++n;
            }
            pu.setPhrasesId(list.get(i).getPhrasesId());
            pu.setOrderNumber(Long.valueOf(i));
            pu.setUserId(user.getUserId());
            savePhrasesUserList.add(pu);
        }
        this.phrasesUserService.saveBatch(savePhrasesUserList);
        return true;
    }
}

