/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.message.util;

import com.jxdinfo.crm.common.api.util.constant.common.CommonConstant;
import com.jxdinfo.crm.common.message.dto.AddSysMessageType;
import com.jxdinfo.crm.common.message.service.CommonSysMessageService;
import com.jxdinfo.crm.common.message.util.NoticeUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.notice.dto.AddSysMessageDto;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.CompletableFuture;

public class UnifyUtil {
    public static Long specialRoleId = 862695903377760256L;

    public static void sendMessage(AddSysMessageType addSysMessageType) {
        CompletableFuture.runAsync(() -> {
            try {
                CommonSysMessageService sysMessageService = (CommonSysMessageService)SpringUtils.getBean(CommonSysMessageService.class);
                sysMessageService.addSysMessage(addSysMessageType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                UnifyUtil.sendCrmMessage(addSysMessageType);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public static void sendCrmMessage(AddSysMessageType addSysMessageType) {
        AddSysMessageDto addSysMessageDto = new AddSysMessageDto();
        addSysMessageDto.setMessageTypeId(addSysMessageType.getMessageTypeId());
        addSysMessageDto.setMessageTitle(addSysMessageType.getMessageContent());
        addSysMessageDto.setReleaseDate(LocalDateTime.parse(addSysMessageType.getReleaseDate(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        addSysMessageDto.setMessageContent(addSysMessageType.getMessageContent());
        addSysMessageDto.setDepartmentId(addSysMessageType.getDepartmentId());
        addSysMessageDto.setRoleId(addSysMessageType.getRoleId());
        addSysMessageDto.setUserId(addSysMessageType.getUserId());
        if (HussarUtils.isNotEmpty((Object)addSysMessageType.getCreatoeDepartmentId())) {
            addSysMessageDto.setCreatoeDepartmentId(Long.valueOf(Long.parseLong(addSysMessageType.getCreatoeDepartmentId())));
        }
        addSysMessageDto.setMessageIssue(addSysMessageType.getMessageIssue());
        addSysMessageDto.setCreator(addSysMessageType.getCreator());
        addSysMessageDto.setLastEditor(addSysMessageType.getLastEditor());
        addSysMessageDto.setReadFlag(addSysMessageDto.getReadFlag());
        addSysMessageDto.setDelFlag(addSysMessageDto.getDelFlag());
        addSysMessageDto.setBusinessAddress(addSysMessageType.getBusinessAddress());
        addSysMessageDto.setOpenWay("0");
        NoticeUtil.sendMessage(addSysMessageDto);
    }

    public static void defaultMessage(AddSysMessageType addSysMessageType, String messageContent, LocalDateTime date, SecurityUser user, String userId, String messageIssue, String businessAddress, String mobileBusinessAddress) {
        addSysMessageType.setMessageContent(messageContent);
        addSysMessageType.setReleaseDate(date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        addSysMessageType.setMessageTypeId(CommonConstant.MESSAGE_TYPE_OTHER);
        addSysMessageType.setUserId(userId);
        if (user.getDeptId() != null) {
            addSysMessageType.setCreatoeDepartmentId(String.valueOf(user.getDeptId()));
        }
        addSysMessageType.setMessageIssue(messageIssue);
        addSysMessageType.setCreator(user.getUserId());
        addSysMessageType.setLastEditor(user.getUserId());
        addSysMessageType.setBusinessAddress(businessAddress);
        addSysMessageType.setMobileBusinessAddress(mobileBusinessAddress);
        addSysMessageType.setOpenWay("1");
    }
}

