/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.fileinfo.controller;

import com.jxdinfo.crm.common.fileinfo.service.IPreviewFileInfoService;
import com.jxdinfo.crm.common.fileinfo.util.ByteArrayMultipartFile;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jmimemagic.Magic;
import net.sf.jmimemagic.MagicMatch;
import org.apache.ibatis.annotations.Param;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/common/file"})
@Api(tags={"\u9644\u4ef6\u9884\u89c8"})
public class PreviewFileInfoController
extends BaseController {
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    @Autowired
    private IPreviewFileInfoService previewFileInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/preview"})
    public void pdfStreamHandler(HttpServletRequest request, HttpServletResponse response, @Param(value="fileId") Long fileId) throws IOException {
        File file = this.previewFileInfoService.getAttachmentModelPath(fileId);
        if (file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                byte[] data = new byte[input.available()];
                input.read(data);
                MagicMatch match = Magic.getMagicMatch((byte[])data);
                String mimeType = match.getMimeType();
                response.setContentType(mimeType);
                response.addHeader("cache-control", "no-cache");
                response.getOutputStream().write(data);
            }
            catch (Exception e) {
                System.out.println("pdf\u6587\u4ef6\u5904\u7406\u5f02\u5e38\uff1a" + e);
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @PostMapping(value={"/uploadfile"})
    public ApiResponse<AttachmentManagerModelVo> uploadfilewithdrag(MultipartHttpServletRequest multipartRequest, @ApiParam(value="\u4e1a\u52a1ID") Long businessId) throws Exception {
        MultipartFile originalFile = multipartRequest.getFile("file");
        String originalFilename = originalFile.getOriginalFilename();
        String fileExtension = "";
        if (originalFilename != null && originalFilename.contains(".")) {
            fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1).toLowerCase();
        }
        if ("xlsx".equals(fileExtension) || "xls".equals(fileExtension) || "pdf".equals(fileExtension)) {
            ApiResponse attachmentManagerModelVoApiResponse = this.attachmentManagerService.uploadFileWithDrag(originalFile, null);
            return attachmentManagerModelVoApiResponse;
        }
        ByteArrayMultipartFile tempFile = new ByteArrayMultipartFile(originalFile);
        MultipartFile pdfFile = this.previewFileInfoService.convertToPdf(tempFile);
        ApiResponse attachmentManagerModelVoApiResponse1 = this.attachmentManagerService.uploadFileWithDrag(originalFile, null);
        ApiResponse attachmentManagerModelVoApiResponse2 = this.attachmentManagerService.uploadFileWithDrag(pdfFile, null);
        Long id = ((AttachmentManagerModelVo)attachmentManagerModelVoApiResponse2.getData()).getId();
        ((AttachmentManagerModelVo)attachmentManagerModelVoApiResponse1.getData()).setBusinessId(id);
        return attachmentManagerModelVoApiResponse1;
    }
}

