/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.organUser.external.servie.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.organUser.vo.DeptVo;
import com.jxdinfo.crm.common.organUser.dao.OrganUserMapper;
import com.jxdinfo.crm.common.organUser.service.IOrganUserService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrganUserBoServiceImpl
implements IOrganUserBoService {
    @Resource
    private IOrganUserService organUserService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private OrganUserMapper organUserMapper;
    @Resource
    private CrmCommonProperties crmCommonProperties;

    public List<Long> getOrganByParentId(List<Long> departIdList) {
        return this.organUserService.getOrganByParentId(departIdList);
    }

    public List<Long> getOrganByParentIdContainsParent(List<Long> departIdList) {
        return this.organUserService.getOrganByParentIdContainsParent(departIdList);
    }

    public List<UserVo> getUserListByDepartmentId(List<Long> departmentIdList) {
        List<Long> allDepartmentIdList = this.organUserService.getOrganByParentIdContainsParent(departmentIdList);
        return this.hussarBaseUserBoService.getUsersByOrganUser(allDepartmentIdList, null);
    }

    public List<Long> getParentOrganIncludeOneself(List<Long> departIdList) {
        return this.organUserService.getParentOrganIncludeOneself(departIdList);
    }

    public List<UserVo> getAllSalesman() {
        Long salesManRole = Long.parseLong(this.crmCommonProperties.getRoles().getSalesman());
        List userVoList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
        return userVoList;
    }

    public List<String> getProvinceCodeByStruId(Long struId) {
        return this.organUserMapper.selectProvinceCodeByStruId(struId);
    }

    public List<Long> getStruIdByProvinceCode(Long provinceId) {
        return this.organUserMapper.selectStruIdByProvinceCode(provinceId);
    }

    public List<UserVo> getUserByRoleAndDept(String role, List<Long> struIdList) {
        return this.organUserMapper.selectUserByRoleAndDept(role, struIdList);
    }

    public List<String> selectUserAllStruId(Long userId) {
        return this.organUserMapper.selectUserAllStruId(userId);
    }

    public List<Long> selectProviceDeptIds() {
        return this.organUserMapper.selectProviceDeptIds();
    }

    public List<UserVo> selectDeptChargePersonByDeptId(Long deptId) {
        return this.organUserMapper.selectDeptChargePersonByDeptId(deptId);
    }

    public List<UserVo> selectDeptChargePersonByDeptId(List<Long> deptIdList) {
        return this.organUserMapper.selectDeptChargePersonByDeptIds(deptIdList);
    }

    public List<UserVo> getUserByRoles(List<String> roles) {
        return this.organUserMapper.getUserByRoles(roles);
    }

    public DeptVo selectUserDept(Long userId) {
        return this.organUserMapper.selectUserDept(userId);
    }
}

