/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.label.external.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.dto.SaveLabelDto;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.common.label.dto.SearchLabelDto;
import com.jxdinfo.crm.common.label.model.CrmLabel;
import com.jxdinfo.crm.common.label.service.ICrmLabelService;
import com.jxdinfo.hussar.common.base.HussarDelflagEntity;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.crm.common.label.external.service.impl.labelServiceImpl")
public class LabelServiceImpl
implements ILabelService {
    @Resource
    ICrmLabelService crmLabelService;

    public List<LabelVo> getLabelListForUserByModule(String moduleId) {
        return this.crmLabelService.getLabelListForUserByModule(moduleId);
    }

    public List<LabelVo> listByBusinessId(String moduleId, Long businessId) {
        return this.crmLabelService.listByBusinessId(moduleId, businessId).stream().map(o -> (LabelVo)BeanUtil.copy((Object)o, LabelVo.class)).collect(Collectors.toList());
    }

    public List<LabelVo> listByGroupId(String moduleId, Long groupId) {
        SearchLabelDto searchLabelDto = new SearchLabelDto();
        searchLabelDto.setModuleName(Collections.singletonList(moduleId));
        searchLabelDto.setLabelGroupId(groupId);
        if (groupId == null) {
            searchLabelDto.setLabelCategory("3");
        }
        return this.crmLabelService.selectUserLabelListByGroupId(searchLabelDto);
    }

    public Boolean userSaveLabel(SaveLabelDto saveLabelDto) {
        return this.crmLabelService.userSaveLabel(saveLabelDto);
    }

    public List<LabelVo> listByModuleIdForSelect(String moduleId, String keyword, List<String> exclueLabels) {
        if (ToolUtil.isEmpty((Object)moduleId)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        LabelModuleEnum moduleEnum = LabelModuleEnum.getEnumByModuleId((String)moduleId);
        if (moduleEnum == null) {
            throw new BaseException("\u5f53\u524d\u5bf9\u8c61\u4e0d\u652f\u6301\u6807\u7b7e\u529f\u80fd");
        }
        List<LabelVo> labelList = this.crmLabelService.getLabelListForUserByModule(moduleId, keyword, exclueLabels);
        return labelList.stream().sorted(Comparator.comparing(LabelVo::getGroupShowOrder).thenComparing(LabelVo::getShowOrder)).collect(Collectors.toList());
    }

    public List<LabelVo> listByIds(List<Long> labelIdList) {
        List crmLabelList = this.crmLabelService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(CrmLabel::getLabelId, labelIdList)).ne(HussarDelflagEntity::getDelFlag, (Object)"1"));
        if (CollectionUtil.isEmpty((Collection)crmLabelList)) {
            return null;
        }
        return crmLabelList.stream().map(crmLabel -> {
            LabelVo labelVo = new LabelVo();
            BeanUtil.copyProperties((Object)crmLabel, (Object)labelVo);
            return labelVo;
        }).collect(Collectors.toList());
    }
}

