/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.associativeQuery.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeLabelVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.AssociativeQueryVo;
import com.jxdinfo.crm.common.api.associativeQuery.vo.ProvinceVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.common.associativeQuery.service.AssociativeFiledQueryService;
import com.jxdinfo.crm.common.dict.IDictService;
import com.jxdinfo.crm.common.organUser.service.IStruUserService;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class AssociativeFiledQueryServiceImpl
implements AssociativeFiledQueryService {
    @Resource
    private IStruUserService struUserService;
    @Resource
    private IDictService dictService;
    @Resource
    private ISysStruService struService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private ILabelService labelService;

    @Override
    public List<String> getLabelAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedLabels, List<String> labelList, String moduleId) {
        List labelVoList;
        if (CollectionUtil.isEmpty(selectedLabels)) {
            selectedLabels = new ArrayList<String>();
        }
        ArrayList<String> labelIds = new ArrayList<String>(selectedLabels);
        if (CollectionUtil.isNotEmpty(labelList)) {
            labelIds.addAll(labelList);
        }
        if (ToolUtil.isNotEmpty((Object)(labelVoList = this.labelService.listByModuleIdForSelect(moduleId, keyword, labelIds)))) {
            for (LabelVo labelVo : labelVoList) {
                AssociativeQueryVo LabelAssociative = new AssociativeQueryVo();
                LabelAssociative.setLabelName("\u6807\u7b7e\uff1a");
                LabelAssociative.setDataName("labelSelect");
                LabelAssociative.setMultiOption(Boolean.valueOf(true));
                LabelAssociative.setTips("\u6807\u7b7e\uff1a " + labelVo.getLabelName());
                LabelAssociative.setOptionName(labelVo.getLabelName());
                LabelAssociative.setOptionValue(String.valueOf(labelVo.getLabelId()));
                associativeQueryVoList.add(LabelAssociative);
                selectedLabels.add(String.valueOf(labelVo.getLabelId()));
            }
        }
        return selectedLabels;
    }

    @Override
    public List<String> getDepartmentAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedDepartments, List<String> departmentList, AssociativeLabelVo associativeLabelVo) {
        List detpId = this.struService.listObjs((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{SysStru::getId}).eq(SysStru::getOrganAlias, (Object)"\u79bb\u804c\u4eba\u5458"), s -> Long.parseLong(s.toString()));
        ArrayList<String> ownDepartments = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty((Collection)detpId)) {
            ownDepartments.add(((Long)detpId.get(0)).toString());
        }
        if (CollectionUtil.isNotEmpty(departmentList)) {
            ownDepartments.addAll(departmentList);
        }
        if (CollectionUtil.isEmpty(selectedDepartments)) {
            selectedDepartments = new ArrayList<String>();
        }
        ownDepartments.addAll(selectedDepartments);
        List<SysStru> ownDepartmentsList = this.struUserService.getDeptList(keyword, ownDepartments);
        if (ToolUtil.isNotEmpty(ownDepartmentsList)) {
            for (SysStru sysStru : ownDepartmentsList) {
                AssociativeQueryVo ownDepartmentsAssociative = this.getAssociativeQueryVo(associativeLabelVo, sysStru.getOrganAlias(), String.valueOf(sysStru.getId()));
                associativeQueryVoList.add(ownDepartmentsAssociative);
                selectedDepartments.add(String.valueOf(sysStru.getId()));
            }
        }
        return selectedDepartments;
    }

    @Override
    public List<String> getUsersAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedUserIds, List<String> userIdList, AssociativeLabelVo associativeLabelVo) {
        ArrayList<String> chargePersonIds = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(userIdList)) {
            chargePersonIds.addAll(userIdList);
        }
        if (CollectionUtil.isEmpty(selectedUserIds)) {
            selectedUserIds = new ArrayList<String>();
        }
        chargePersonIds.addAll(selectedUserIds);
        List<SysUsers> chargePersonList = this.struUserService.getUserList(keyword, chargePersonIds);
        if (ToolUtil.isNotEmpty(chargePersonList)) {
            for (SysUsers sysUsers : chargePersonList) {
                AssociativeQueryVo chargePersonIdAssociative = this.getAssociativeQueryVo(associativeLabelVo, sysUsers.getUserName(), String.valueOf(sysUsers.getId()));
                associativeQueryVoList.add(chargePersonIdAssociative);
                selectedUserIds.add(String.valueOf(sysUsers.getId()));
            }
        }
        return selectedUserIds;
    }

    @Override
    public List<String> getTimeTageAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedCreateTimes, String timeTage, AssociativeLabelVo associativeLabelVo) {
        List<DicVo> dicVoList;
        ArrayList<String> createTimes = new ArrayList<String>();
        createTimes.add("6");
        if (CollectionUtil.isEmpty(selectedCreateTimes)) {
            selectedCreateTimes = new ArrayList<String>();
        }
        createTimes.addAll(selectedCreateTimes);
        if (StringUtil.isEmpty((Object)timeTage) && ToolUtil.isNotEmpty(dicVoList = this.dictService.getDicValue(associativeLabelVo.getDictTypeName(), keyword, createTimes))) {
            for (DicVo dicVo : dicVoList) {
                AssociativeQueryVo createTimeAssociative = this.getAssociativeQueryVo(associativeLabelVo, dicVo.getLabel(), dicVo.getValue());
                String labelName = associativeLabelVo.getLabelName() + "\uff1a";
                createTimeAssociative.setLabelName(labelName);
                createTimeAssociative.setDataName(associativeLabelVo.getDataName());
                createTimeAssociative.setMultiOption(associativeLabelVo.getMultiOption());
                createTimeAssociative.setTips(labelName + dicVo.getLabel());
                createTimeAssociative.setOptionName(dicVo.getLabel());
                createTimeAssociative.setOptionValue(dicVo.getValue());
                associativeQueryVoList.add(createTimeAssociative);
                selectedCreateTimes.add(dicVo.getValue());
            }
        }
        return selectedCreateTimes;
    }

    @Override
    public List<String> getDictAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedValueList, List<String> dtoValueList, AssociativeLabelVo associativeLabelVo) {
        List<DicVo> dicVoList;
        if (CollectionUtil.isEmpty(selectedValueList)) {
            selectedValueList = new ArrayList<String>();
        }
        ArrayList<String> excludeValueList = new ArrayList<String>(selectedValueList);
        if (CollectionUtil.isNotEmpty(dtoValueList)) {
            excludeValueList.addAll(dtoValueList);
        }
        if (ToolUtil.isNotEmpty(dicVoList = this.dictService.getDicValue(associativeLabelVo.getDictTypeName(), keyword, excludeValueList))) {
            for (DicVo dicVo : dicVoList) {
                AssociativeQueryVo opportunityTypeAssociative = this.getAssociativeQueryVo(associativeLabelVo, dicVo.getLabel(), dicVo.getValue());
                associativeQueryVoList.add(opportunityTypeAssociative);
                selectedValueList.add(dicVo.getValue());
            }
        }
        return selectedValueList;
    }

    @Override
    public List<String> getProvinceAssociativeQuery(List<AssociativeQueryVo> associativeQueryVoList, String keyword, List<String> selectedProvinces, List<Long> provinceIdList, AssociativeLabelVo associativeLabelVo) {
        ArrayList<Long> provinces = new ArrayList<Long>();
        if (CollectionUtil.isNotEmpty(provinceIdList)) {
            provinces.addAll(provinceIdList);
        }
        if (CollectionUtil.isNotEmpty(selectedProvinces)) {
            List selectedProvinceList = selectedProvinces.stream().map(Long::parseLong).collect(Collectors.toList());
            provinces.addAll(selectedProvinceList);
        } else {
            selectedProvinces = new ArrayList<String>();
        }
        List<ProvinceVo> provinceList = this.struUserService.getProvinceList(keyword, provinces);
        if (ToolUtil.isNotEmpty(provinceList)) {
            for (ProvinceVo provinceVo : provinceList) {
                AssociativeQueryVo provinceAssociative = this.getAssociativeQueryVo(associativeLabelVo, provinceVo.getProvinceName(), String.valueOf(provinceVo.getProvinceId()));
                associativeQueryVoList.add(provinceAssociative);
                selectedProvinces.add(String.valueOf(provinceVo.getProvinceId()));
            }
        }
        return selectedProvinces;
    }

    @Override
    public AssociativeQueryVo getAssociativeQueryVo(AssociativeLabelVo associativeLabelVo, String name, String value) {
        AssociativeQueryVo associativeQueryVo = new AssociativeQueryVo();
        String labelName = associativeLabelVo.getLabelName() + "\uff1a";
        associativeQueryVo.setLabelName(labelName);
        associativeQueryVo.setDataName(associativeLabelVo.getDataName());
        associativeQueryVo.setMultiOption(associativeLabelVo.getMultiOption());
        associativeQueryVo.setTips(labelName + name);
        associativeQueryVo.setOptionName(name);
        associativeQueryVo.setOptionValue(value);
        return associativeQueryVo;
    }
}

