/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.fileinfo.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.jodconverter.OfficeDocumentConverter;
import org.jodconverter.office.DefaultOfficeManagerBuilder;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="filePreviewLibreOfficePDFConvert")
public class LibreOfficePDFConvert {
    private static final Logger logger = LoggerFactory.getLogger(LibreOfficePDFConvert.class);
    private static String officeHomeDir = null;
    private static OfficeManager officeManager = null;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void start() {
        officeHomeDir = this.environment.getProperty("hussar.docbase.officeHomeDir");
        if (ToolUtil.isNotEmpty((Object)officeHomeDir)) {
            String libreOfficePath = LibreOfficePDFConvert.getOfficeHome();
            if (ToolUtil.isEmpty((Object)libreOfficePath)) {
                logger.error("\u8bf7\u8bbe\u7f6elibreOffice\u5b89\u88c5\u76ee\u5f55!");
                return;
            }
            DefaultOfficeManagerBuilder builder = new DefaultOfficeManagerBuilder();
            builder.setOfficeHome(new File(libreOfficePath));
            builder.setPortNumbers(new int[]{8100});
            builder.setTaskExecutionTimeout(3000000L);
            builder.setTaskQueueTimeout(864000000L);
            try {
                officeManager = builder.build();
                if (!officeManager.isRunning()) {
                    LibreOfficePDFConvert.startService(officeManager);
                }
            }
            catch (Exception e) {
                logger.error("\u542f\u52a8office\u8f6c\u6362\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    @PreDestroy
    public void stop() {
        try {
            if (officeManager.isRunning()) {
                LibreOfficePDFConvert.stopService(officeManager);
            }
        }
        catch (OfficeException e) {
            logger.error("\u5173\u95edoffice\u8f6c\u6362\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static synchronized String doDocToFdpLibre(File sourceFile, File tarPdfFile) throws OfficeException {
        File inputFile = sourceFile;
        File outputFile = null;
        OfficeDocumentConverter converter = new OfficeDocumentConverter(officeManager);
        outputFile = tarPdfFile;
        converter.convert(inputFile, outputFile);
        String pdfPath = outputFile.getPath();
        return pdfPath;
    }

    private static String getOfficeHome() {
        if (null != officeHomeDir) {
            return officeHomeDir;
        }
        String osName = System.getProperty("os.name");
        if (Pattern.matches("Windows.*", osName)) {
            officeHomeDir = "C:\\Program Files\\LibreOffice";
            return officeHomeDir;
        }
        if (Pattern.matches("Linux.*", osName)) {
            officeHomeDir = "/opt/libreoffice6.0";
            return officeHomeDir;
        }
        if (Pattern.matches("Mac.*", osName)) {
            officeHomeDir = "/Application/openOfficeSoft";
            return officeHomeDir;
        }
        return null;
    }

    private static void stopService(OfficeManager officeManager) throws OfficeException {
        if (null != officeManager) {
            officeManager.stop();
        }
        logger.info("\u5173\u95edoffice\u8f6c\u6362\u6210\u529f!");
    }

    private static void startService(OfficeManager officeManager) {
        try {
            officeManager.start();
            logger.info("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u6210\u529f");
        }
        catch (Exception ce) {
            logger.error("office\u8f6c\u6362\u670d\u52a1\u542f\u52a8\u5931\u8d25!\u8be6\u7ec6\u4fe1\u606f:{}", (Throwable)ce);
        }
    }

    public static void setOfficeHome(String officeHome) {
        officeHomeDir = officeHome;
    }
}

