/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.fileinfo.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.springframework.web.multipart.MultipartFile;

public class CustomMultipartFile
implements MultipartFile {
    private final File file;
    private final String name;

    public CustomMultipartFile(File file, String name) {
        this.file = file;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.name;
    }

    public String getContentType() {
        return "application/pdf";
    }

    public boolean isEmpty() {
        return this.file.length() == 0L;
    }

    public long getSize() {
        return this.file.length();
    }

    public byte[] getBytes() throws IOException {
        FileInputStream fis = new FileInputStream(this.file);
        byte[] bytes = new byte[(int)this.file.length()];
        fis.read(bytes);
        fis.close();
        return bytes;
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        FileUtils.copyFile((File)this.file, (File)dest);
    }
}

