/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.fileinfo.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.fileinfo.dao.PreviewFileInfoMapper;
import com.jxdinfo.crm.common.fileinfo.model.PreviewFileInfo;
import com.jxdinfo.crm.common.fileinfo.service.FileInfoService;
import com.jxdinfo.crm.common.fileinfo.service.IPreviewFileInfoService;
import com.jxdinfo.crm.common.fileinfo.util.ChangeToPdfUtil;
import com.jxdinfo.crm.common.fileinfo.util.CustomMultipartFile;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.oss.api.service.OssService;
import com.jxdinfo.hussar.support.oss.core.support.service.AttachmentManagerService;
import com.jxdinfo.hussar.support.oss.core.support.vo.AttachmentManagerModelVo;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PreviewFileInfoServiceImpl
extends ServiceImpl<PreviewFileInfoMapper, PreviewFileInfo>
implements IPreviewFileInfoService {
    @Autowired
    private FileInfoService fileInfoService;
    @Autowired
    private AttachmentManagerService attachmentManagerService;
    @Autowired
    private OssService ossService;
    @Autowired
    private IPreviewFileInfoService previewFileInfoService;

    @Override
    public File getAttachmentModelPath(Long fileId) {
        LambdaQueryWrapper previewFileInfoQueryWrapper = new LambdaQueryWrapper();
        previewFileInfoQueryWrapper.eq(PreviewFileInfo::getFileId, (Object)fileId);
        List previewFileInfoList = this.previewFileInfoService.list((Wrapper)previewFileInfoQueryWrapper);
        if (CollectionUtils.isEmpty((Collection)previewFileInfoList)) {
            AttachmentManagerModelVo attachmentManagerModelVo = this.ossService.getByFileId(fileId);
            String attachmentType = attachmentManagerModelVo.getAttachmentType();
            if ("xlsx".equals(attachmentType) || "xls".equals(attachmentType) || "pdf".equals(attachmentType)) {
                return new File(attachmentManagerModelVo.getPath());
            }
            File file = ChangeToPdfUtil.changeToPdf(attachmentManagerModelVo.getPath());
            if (file == null) {
                throw new HussarException("\u6b64\u6587\u6863\u4e0d\u652f\u6301\u9884\u89c8");
            }
            MultipartFile multipartFile = null;
            try {
                multipartFile = this.convertFileToMultipartFile(file, this.getFileNameWithoutExtension(attachmentManagerModelVo.getFileName()) + ".pdf");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ApiResponse attachmentManagerModelVoApiResponse = null;
            try {
                attachmentManagerModelVoApiResponse = this.attachmentManagerService.uploadFileWithDrag(multipartFile, null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Long previewFileId = ((AttachmentManagerModelVo)attachmentManagerModelVoApiResponse.getData()).getId();
            PreviewFileInfo previewFileInfo = new PreviewFileInfo();
            previewFileInfo.setId(Long.parseLong(CommonUtills.generateAssignId()));
            previewFileInfo.setFileId(fileId);
            previewFileInfo.setPreviewFileId(previewFileId);
            this.previewFileInfoService.save(previewFileInfo);
            return file;
        }
        PreviewFileInfo previewFileInfo = (PreviewFileInfo)previewFileInfoList.get(0);
        AttachmentManagerModelVo attachmentManagerModelVo = this.ossService.getByFileId(previewFileInfo.getPreviewFileId());
        return new File(attachmentManagerModelVo.getPath());
    }

    @Override
    public MultipartFile convertFileToMultipartFile(File file, String fileName) throws IOException {
        return new CustomMultipartFile(file, fileName);
    }

    @Override
    public MultipartFile convertToPdf(MultipartFile originalFile) {
        try {
            String originalFilename = originalFile.getOriginalFilename();
            String fileExtension = "";
            if (originalFilename != null && originalFilename.contains(".")) {
                fileExtension = originalFilename.substring(originalFilename.lastIndexOf(".") + 1).toLowerCase();
            }
            File tempFile = null;
            switch (fileExtension) {
                case "xls": 
                case "xlsx": 
                case "pdf": {
                    return originalFile;
                }
                case "doc": 
                case "docx": 
                case "ppt": 
                case "pptx": 
                case "txt": {
                    tempFile = File.createTempFile("upload_", "." + fileExtension);
                    originalFile.transferTo(tempFile);
                    File pdfFile = ChangeToPdfUtil.changeToPdf(tempFile.getAbsolutePath());
                    return this.convertFileToMultipartFile(pdfFile, this.getFileNameWithoutExtension(originalFilename) + ".pdf");
                }
                case "jpg": 
                case "jpeg": 
                case "png": 
                case "bmp": 
                case "gif": {
                    tempFile = File.createTempFile("upload_", "." + fileExtension);
                    originalFile.transferTo(tempFile);
                    File imagePdfFile = ChangeToPdfUtil.changeToPdf(tempFile.getAbsolutePath());
                    return this.convertFileToMultipartFile(imagePdfFile, this.getFileNameWithoutExtension(originalFilename) + ".pdf");
                }
            }
            return originalFile;
        }
        catch (Exception e) {
            throw new HussarException();
        }
    }

    @Override
    public String getFileNameWithoutExtension(String fileName) {
        if (fileName != null && fileName.contains(".")) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }
}

