/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.dataRightManage.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.dataRightManage.vo.UserDepartmentVo;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.organUser.vo.DeptVo;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.common.dataRightManage.dao.CrmRolesMapper;
import com.jxdinfo.crm.common.dataRightManage.dto.DivisionsLeaderDto;
import com.jxdinfo.crm.common.dataRightManage.service.ICommonDataRightService;
import com.jxdinfo.crm.common.dataRightManage.service.IDivisionsLeaderService;
import com.jxdinfo.crm.common.organUser.dao.UserInfoMapper;
import com.jxdinfo.crm.common.organUser.service.IOrganUserService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityDataRightModuleService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CommonDataRightServiceImpl
implements ICommonDataRightService {
    @Resource
    CrmRolesMapper crmRolesMapper;
    @Resource
    UserInfoMapper userInfoMapper;
    @Resource
    CrmCommonProperties crmProperties;
    @Resource
    private IOrganUserService organUserService;
    @Resource
    private IDivisionsLeaderService divisionsLeaderService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private IDataRightBoService dataRightBoService;
    @Resource
    private IOpportunityDataRightModuleService opportunityDataRightModuleService;
    @Resource
    private IUserBoService userBoService;

    @Override
    public List<Long> getChargeDepartmentList() {
        return this.getChargeDepartmentList(null);
    }

    @Override
    public List<Long> getChargeDepartmentList(Long userId) {
        SecurityUser user = userId == null ? BaseSecurityUtil.getUser() : this.userInfoMapper.selectSecurityByUserId(userId);
        return this.getDirectDepartmentIds(user);
    }

    @Override
    public List<Long> getChargeDepartmentHasDivisions() {
        return this.getChargeDepartmentHasDivisions(null);
    }

    @Override
    public List<Long> getChargeDepartmentHasDivisions(Long userId) {
        SecurityUser user = userId == null ? BaseSecurityUtil.getUser() : this.userInfoMapper.selectSecurityByUserId(userId);
        List<Long> departmentIdList = this.getDirectDepartmentIds(user);
        return departmentIdList;
    }

    private List<Long> getDirectDepartmentIds(SecurityUser user) {
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader()))) {
            return null;
        }
        ArrayList<Long> deptIdList = new ArrayList<Long>();
        DivisionsLeaderDto divisionsLeaderDto = new DivisionsLeaderDto();
        divisionsLeaderDto.setUserId(user.getUserId());
        List<DeptVo> deptVoList = this.divisionsLeaderService.deptListByUser(divisionsLeaderDto);
        if (CollectionUtil.isNotEmpty(deptVoList)) {
            List<Long> divisionIdList = deptVoList.stream().map(DeptVo::getDeptId).collect(Collectors.toList());
            divisionIdList = this.organUserService.getOrganByParentIdContainsParent(divisionIdList);
            deptIdList.addAll(divisionIdList);
        }
        if (deptIdList.isEmpty()) {
            deptIdList.add(-1L);
        }
        return deptIdList;
    }

    @Override
    public Map<Long, List<SecurityUser>> getChargePersonList(List<Long> departIdList) {
        List chargePersonIds = this.dataRightBoService.getUserIdByDeptChargerDeptIds(departIdList);
        List securityUserList = this.userBoService.selectSecurityByUserIdList(chargePersonIds);
        if (CollectionUtil.isNotEmpty((Collection)securityUserList)) {
            return securityUserList.stream().collect(Collectors.groupingBy(SecurityUser::getDeptId));
        }
        return null;
    }

    @Override
    public List<Long> getSalesUserList(@Nullable Long userId, List<UserDepartmentVo> userDepartmentVoList) {
        Long salesManRole = Long.parseLong(this.crmProperties.getRoles().getSalesman());
        List userVoList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
        if (CollectionUtil.isEmpty((Collection)userVoList)) {
            return Collections.singletonList(-1L);
        }
        List<Long> userIdList = userVoList.stream().map(UserVo::getId).collect(Collectors.toList());
        List<Long> departmentIdList = this.getChargeDepartmentHasDivisions();
        if (CollectionUtil.isEmpty(departmentIdList)) {
            List<UserDepartmentVo> thisUserDepartmentVoList = this.crmRolesMapper.selectUserByDepartmentId(userIdList, null);
            userDepartmentVoList.addAll(thisUserDepartmentVoList);
            return userIdList;
        }
        if (departmentIdList.size() == 1 && departmentIdList.get(0) == -1L) {
            if (userId != null) {
                userId = BaseSecurityUtil.getUser().getUserId();
            }
            if (userIdList.contains(userId)) {
                return Collections.singletonList(userId);
            }
            return Collections.singletonList(-1L);
        }
        List<UserDepartmentVo> thisUserDepartmentVoList = this.crmRolesMapper.selectUserByDepartmentId(userIdList, departmentIdList);
        userDepartmentVoList.addAll(thisUserDepartmentVoList);
        if (CollectionUtil.isEmpty(userDepartmentVoList)) {
            return Collections.singletonList(-1L);
        }
        return userDepartmentVoList.stream().map(UserDepartmentVo::getUserId).collect(Collectors.toList());
    }

    @Override
    public List<Long> getAllSalesUserList(@Nullable Long userId, List<UserDepartmentVo> userDepartmentVoList) {
        Long salesManRole = Long.parseLong(this.crmProperties.getRoles().getSalesman());
        List userVoList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
        if (CollectionUtil.isEmpty((Collection)userVoList)) {
            return Collections.singletonList(-1L);
        }
        List<Long> userIdList = userVoList.stream().map(UserVo::getId).collect(Collectors.toList());
        List<UserDepartmentVo> thisUserDepartmentVoList = this.crmRolesMapper.selectUserByDepartmentId(userIdList, null);
        userDepartmentVoList.addAll(thisUserDepartmentVoList);
        return userIdList;
    }

    @Override
    public PermissionDto getUserRolePermission(String module, SecurityUser user) {
        return this.dataRightBoService.getPermissionInfo(module, user);
    }

    @Override
    public PermissionDto getCurrentUserRolePermissions(String module) {
        SecurityUser user = BaseSecurityUtil.getUser();
        return this.getUserRolePermission(module, user);
    }

    @Override
    public PermissionDto getUserRolePermissionsByUserId(String module, Long userId) {
        IUserBoService userBoService = (IUserBoService)SpringUtils.getBean(IUserBoService.class);
        SecurityUser user = userBoService.selectSecurityByUserId(userId);
        return this.getUserRolePermission(module, user);
    }

    public static Long getParentIdByDeptId(List<Map<String, Long>> struList, Long deptId) {
        if (CollectionUtil.isEmpty(struList)) {
            return deptId;
        }
        for (Map<String, Long> map : struList) {
            if (!map.get("struId").equals(deptId)) continue;
            return map.get("parentId");
        }
        return deptId;
    }

    public static boolean isLeadship(List<Long> userRoles, List<Long> leadershipRoles) {
        if (CollectionUtil.isEmpty(leadershipRoles)) {
            return false;
        }
        for (Long role : leadershipRoles) {
            if (!userRoles.contains(role)) continue;
            return true;
        }
        return false;
    }
}

