/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.message.external.service.impl;

import com.jxdinfo.crm.common.api.message.dto.MessageTemplateDto;
import com.jxdinfo.crm.common.api.message.service.IMessageTemplateService;
import com.jxdinfo.crm.common.api.message.vo.MessagePushVo;
import com.jxdinfo.crm.common.message.dao.MessageTemplateMapper;
import com.jxdinfo.crm.common.message.model.MessageTemplateEntity;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MessageTemplateServiceImpl
implements IMessageTemplateService {
    @Resource
    private MessageTemplateMapper messageTemplateMapper;

    public List<MessagePushVo> getMessagePushList(String messageEnum) {
        return this.messageTemplateMapper.selectMessagePushList(messageEnum, null);
    }

    public List<MessagePushVo> getMessagePushList(String templateKey, Long typeId) {
        return this.messageTemplateMapper.selectMessagePushList(templateKey, typeId);
    }

    public Integer addMessageTemplateBatch(List<MessageTemplateDto> dtoList) {
        ArrayList<MessageTemplateEntity> messageTemplateEntities = new ArrayList<MessageTemplateEntity>();
        SecurityUser user = BaseSecurityUtil.getUser();
        for (MessageTemplateDto messageTemplateDto : dtoList) {
            MessageTemplateEntity messageTemplateEntity = (MessageTemplateEntity)BeanUtil.copy((Object)messageTemplateDto, MessageTemplateEntity.class);
            messageTemplateEntity.setCreator(user.getUserId().toString());
            messageTemplateEntity.setCreateTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
            messageTemplateEntity.setLastEditor(user.getUserId().toString());
            messageTemplateEntity.setLastTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
            messageTemplateEntities.add(messageTemplateEntity);
        }
        return this.messageTemplateMapper.addMessageTemplateBatch(messageTemplateEntities);
    }

    public Integer deleteMessageTemplate(String templateKey) {
        return this.messageTemplateMapper.deleteMessageTemplateByTemplateKey(templateKey);
    }
}

