/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.label.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.label.vo.LabelGroupVo;
import com.jxdinfo.crm.common.api.label.vo.LabelPermissionVo;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.common.label.dao.CrmLabelGroupMapper;
import com.jxdinfo.crm.common.label.dto.CrmLabelGroupDto;
import com.jxdinfo.crm.common.label.dto.LabelGroupDto;
import com.jxdinfo.crm.common.label.dto.SortLabelGroupDto;
import com.jxdinfo.crm.common.label.model.CrmLabel;
import com.jxdinfo.crm.common.label.model.CrmLabelGroup;
import com.jxdinfo.crm.common.label.model.CrmLabelGroupPartner;
import com.jxdinfo.crm.common.label.service.ICrmLabelGroupPartnerService;
import com.jxdinfo.crm.common.label.service.ICrmLabelGroupService;
import com.jxdinfo.crm.common.label.service.ICrmLabelPermissionService;
import com.jxdinfo.crm.common.label.service.ICrmLabelService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.HussarBaseServiceImpl;
import com.jxdinfo.hussar.common.base.HussarDelflagEntity;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.mobile.pack.utils.CommonUtills;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CrmLabelGroupServiceImpl
extends HussarBaseServiceImpl<CrmLabelGroupMapper, CrmLabelGroup>
implements ICrmLabelGroupService {
    @Resource
    private ICrmLabelPermissionService labelPermissionService;
    @Resource
    private ICrmLabelService labelService;
    @Resource
    private ICrmLabelGroupPartnerService labelGroupPartnerService;
    @Resource
    private CrmCommonProperties crmCommonProperties;

    @Override
    public List<LabelGroupVo> listLabelGroup(CrmLabelGroupDto crmLabelGroupDto) {
        Boolean isAdmin;
        if (ToolUtil.isEmpty((Object)crmLabelGroupDto.getLabelCategory())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getLabelManager()))) {
            isAdmin = true;
        } else {
            if ("1".equals(crmLabelGroupDto.getLabelCategory())) {
                return new ArrayList<LabelGroupVo>();
            }
            isAdmin = false;
        }
        return ((CrmLabelGroupMapper)this.baseMapper).selectListLabelGroup(crmLabelGroupDto, user.getUserId(), isAdmin);
    }

    @Override
    public LabelGroupVo detail(Long groupId) {
        if (ToolUtil.isEmpty((Object)groupId)) {
            throw new BaseException("\u5206\u7ec4id\u4e0d\u5b58\u5728");
        }
        CrmLabelGroup labelGroup = (CrmLabelGroup)((Object)this.getById(groupId));
        if (labelGroup == null) {
            return null;
        }
        LabelGroupVo labelGroupVo = (LabelGroupVo)BeanUtil.copy((Object)((Object)labelGroup), LabelGroupVo.class);
        return labelGroupVo;
    }

    @Override
    @HussarTransactional
    public Boolean addLabelGroup(LabelGroupDto dto) {
        CrmLabelGroup labelGroup = (CrmLabelGroup)((Object)BeanUtil.copy((Object)dto, CrmLabelGroup.class));
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (!userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getLabelManager())) && "1".equals(dto.getLabelCategory())) {
            throw new BaseException("\u60a8\u5f53\u524d\u6682\u65e0\u6743\u9650\u6dfb\u52a0\u7cfb\u7edf\u6807\u7b7e\u5206\u7ec4");
        }
        if (!userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getLabelManager())) && !userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getDeptLabelManager()))) {
            if ("1".equals(dto.getLabelCategory())) {
                throw new BaseException("\u60a8\u5f53\u524d\u6682\u65e0\u6743\u9650\u6dfb\u52a0\u7cfb\u7edf\u6807\u7b7e\u5206\u7ec4");
            }
            if ("2".equals(dto.getLabelCategory())) {
                throw new BaseException("\u60a8\u5f53\u524d\u6682\u65e0\u6743\u9650\u6dfb\u52a0\u90e8\u95e8\u6807\u7b7e\u5206\u7ec4");
            }
        }
        Long userId = user.getUserId();
        String userName = user.getUserName();
        LocalDateTime date = LocalDateTime.now();
        assert (labelGroup != null);
        if (labelGroup.getGroupId() == null) {
            Long groupId = CommonUtills.generateAssignId();
            labelGroup.setGroupId(groupId);
            labelGroup.setCreator(userId);
            labelGroup.setCreatorName(userName);
            labelGroup.setCreateTime(date);
            labelGroup.setLastEditor(userId);
            labelGroup.setLastEditorName(userName);
            labelGroup.setLastTime(date);
            labelGroup.setDelFlag("0");
            labelGroup.setDisableFlag("0");
            Integer maxOrder = this.getMaxOrder();
            labelGroup.setShowOrder(maxOrder + 1);
        }
        this.saveOrUpdate((BaseEntity)labelGroup);
        if ("2".equals(dto.getLabelCategory()) && ToolUtil.isNotEmpty(dto.getPartnerList())) {
            List<CrmLabelGroupPartner> labelGroupPartnerList = dto.getPartnerList();
            labelGroupPartnerList.forEach(p -> {
                p.setCreatorName(userName);
                p.setGroupId(labelGroup.getGroupId());
            });
            this.labelGroupPartnerService.saveBatch(labelGroupPartnerList);
        }
        return true;
    }

    @Override
    @HussarTransactional
    public Boolean updateLabelGroup(LabelGroupDto dto) {
        CrmLabelGroup labelGroup = (CrmLabelGroup)((Object)BeanUtil.copy((Object)dto, CrmLabelGroup.class));
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        labelGroup.setLastEditor(user.getUserId());
        labelGroup.setLastEditorName(user.getUserName());
        labelGroup.setLastTime(date);
        this.saveOrUpdate((BaseEntity)labelGroup);
        if ("2".equals(dto.getLabelCategory()) && ToolUtil.isNotEmpty(dto.getPartnerList())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.labelGroupPartnerService.lambdaUpdate().set(HussarDelflagEntity::getDelFlag, (Object)"1")).eq(CrmLabelGroupPartner::getGroupId, (Object)dto.getGroupId())).update();
            List<CrmLabelGroupPartner> labelGroupPartnerList = dto.getPartnerList();
            labelGroupPartnerList.forEach(p -> {
                p.setCreatorName(user.getUserName());
                p.setGroupId(dto.getGroupId());
            });
            this.labelGroupPartnerService.saveBatch(labelGroupPartnerList);
        } else if ("2".equals(dto.getLabelCategory()) && ToolUtil.isEmpty(dto.getPartnerList())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.labelGroupPartnerService.lambdaUpdate().set(HussarDelflagEntity::getDelFlag, (Object)"1")).eq(CrmLabelGroupPartner::getGroupId, (Object)dto.getGroupId())).update();
        }
        return true;
    }

    @Override
    @HussarTransactional
    public Boolean delLabelGroup(Long groupId) {
        if (ToolUtil.isEmpty((Object)groupId)) {
            throw new BaseException("\u5206\u7ec4id\u4e0d\u5b58\u5728");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List roles = user.getRolesList();
        CrmLabelGroup crmLabelGroup = (CrmLabelGroup)((Object)this.getById(groupId));
        if (!roles.contains(Long.parseLong(this.crmCommonProperties.getRoles().getLabelManager())) && !user.getId().equals(crmLabelGroup.getCreator())) {
            throw new BaseException("\u60a8\u65e0\u6743\u5220\u9664\u8be5\u5206\u7ec4");
        }
        List labelEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.labelService.lambdaQuery().eq(CrmLabel::getLabelGroupId, (Object)groupId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0")).list();
        if (CollectionUtil.isNotEmpty((Collection)labelEntityList)) {
            throw new BaseException("\u5206\u7ec4\u4e0b\u5b58\u5728\u6807\u7b7e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        LocalDateTime date = LocalDateTime.now();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().set(HussarDelflagEntity::getDelFlag, (Object)"1")).set(HussarBaseEntity::getLastEditor, (Object)user.getUserId())).set(CrmLabelGroup::getLastEditorName, (Object)user.getUserName())).set(HussarBaseEntity::getLastTime, (Object)date)).eq(CrmLabelGroup::getGroupId, (Object)groupId)).update();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.labelGroupPartnerService.lambdaUpdate().set(HussarDelflagEntity::getDelFlag, (Object)"1")).eq(CrmLabelGroupPartner::getGroupId, (Object)groupId)).update();
        return true;
    }

    @Override
    public Boolean sortLabelGroup(SortLabelGroupDto dto) {
        List<Long> idList = dto.getIdList();
        if (ToolUtil.isEmpty(idList)) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        List userRoles = BaseSecurityUtil.getUser().getRolesList();
        if (!userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getLabelManager()))) {
            throw new BaseException("\u60a8\u5f53\u524d\u6682\u65e0\u6743\u9650\u8fdb\u884c\u6807\u7b7e\u5206\u7ec4\u6392\u5e8f");
        }
        String userName = BaseSecurityUtil.getUser().getUserName();
        ArrayList<CrmLabelGroup> crmLabelGroupList = new ArrayList<CrmLabelGroup>();
        Integer index = 1;
        for (Long id : idList) {
            CrmLabelGroup crmLabelGroup = new CrmLabelGroup();
            crmLabelGroup.setGroupId(id);
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            crmLabelGroup.setShowOrder(n);
            crmLabelGroup.setLastEditorName(userName);
            crmLabelGroupList.add(crmLabelGroup);
        }
        return this.updateBatchById(crmLabelGroupList);
    }

    private Integer getMaxOrder() {
        Integer maxOrder = ((CrmLabelGroupMapper)this.baseMapper).getMaxOrder();
        return maxOrder == null ? 0 : maxOrder;
    }

    @Override
    public List<LabelGroupVo> getUserLabel(CrmLabelGroupDto dto) {
        List<Object> res;
        if (ToolUtil.isEmpty((Object)dto.getLabelCategory())) {
            throw new BaseException("\u53c2\u6570\u7f3a\u5931");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        List userRoles = user.getRolesList();
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getLabelManager()))) {
            res = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmLabelGroup::getLabelCategory, (Object)dto.getLabelCategory())).orderByAsc(CrmLabelGroup::getShowOrder)).list().stream().map(o -> (LabelGroupVo)BeanUtil.copy((Object)o, LabelGroupVo.class)).collect(Collectors.toList());
        } else {
            List groupIds = ((LambdaQueryChainWrapper)this.labelGroupPartnerService.lambdaQuery().eq(CrmLabelGroupPartner::getUserId, (Object)user.getId())).list().stream().map(CrmLabelGroupPartner::getGroupId).collect(Collectors.toList());
            res = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmLabelGroup::getLabelCategory, (Object)dto.getLabelCategory())).and(f -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)f.eq(HussarBaseEntity::getCreator, (Object)user.getId())).or(ToolUtil.isNotEmpty((Object)groupIds))).in(ToolUtil.isNotEmpty((Object)groupIds), CrmLabelGroup::getGroupId, (Collection)groupIds);
            })).list().stream().map(o -> (LabelGroupVo)BeanUtil.copy((Object)o, LabelGroupVo.class)).collect(Collectors.toList());
        }
        List resGroupIds = res.stream().map(LabelGroupVo::getGroupId).collect(Collectors.toList());
        if (resGroupIds.isEmpty()) {
            return res;
        }
        List labelVoList = ((LambdaQueryChainWrapper)this.labelService.lambdaQuery().in(CrmLabel::getLabelGroupId, resGroupIds)).list().stream().map(o -> (LabelVo)BeanUtil.copy((Object)o, LabelVo.class)).collect(Collectors.toList());
        List<Long> labelIdList = labelVoList.stream().map(LabelVo::getLabelId).collect(Collectors.toList());
        List<LabelPermissionVo> labelPermissionVoList = this.labelPermissionService.selectLabelPermissionVoByLabelIdList(labelIdList);
        labelVoList.stream().map(labelVo -> {
            labelVo.setLabelPermissionVoList(labelPermissionVoList.stream().filter(o -> labelVo.getLabelId().equals(o.getBusinessId())).collect(Collectors.toList()));
            return labelVo;
        }).collect(Collectors.toList());
        res.stream().map(labelGroupVo -> {
            labelGroupVo.setLabelList(labelVoList.stream().filter(o -> labelGroupVo.getGroupId().equals(o.getLabelGroupId())).collect(Collectors.toList()));
            return labelGroupVo;
        }).collect(Collectors.toList());
        return res;
    }

    @Override
    public Boolean hasSortAuth() {
        List roles = BaseSecurityUtil.getUser().getRolesList();
        return roles.contains(Long.parseLong(this.crmCommonProperties.getRoles().getLabelManager()));
    }

    @Override
    public Boolean hasSaveLabelAuth() {
        List roles = BaseSecurityUtil.getUser().getRolesList();
        return roles.contains(Long.parseLong(this.crmCommonProperties.getRoles().getLabelManager())) || roles.contains(Long.parseLong(this.crmCommonProperties.getRoles().getDeptLabelManager()));
    }
}

