/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.trackrecord.service.serviceImpl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.service.IAgentContactApiService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.agent.api.vo.AgentContactApiVo;
import com.jxdinfo.crm.common.api.config.CommonUnifyProperties;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.message.util.EimPushUtil;
import com.jxdinfo.crm.common.trackrecord.dao.TrackRecordMapper;
import com.jxdinfo.crm.common.trackrecord.dto.TrackRecordDto;
import com.jxdinfo.crm.common.trackrecord.model.SearchView;
import com.jxdinfo.crm.common.trackrecord.model.TrackRecord;
import com.jxdinfo.crm.common.trackrecord.model.TrackRecordRelation;
import com.jxdinfo.crm.common.trackrecord.model.TrackRecordVisitors;
import com.jxdinfo.crm.common.trackrecord.service.TrackRecordRelationService;
import com.jxdinfo.crm.common.trackrecord.service.TrackRecordService;
import com.jxdinfo.crm.common.trackrecord.service.TrackRecordVisitorsService;
import com.jxdinfo.crm.common.trackrecord.vo.TrackRecordVo;
import com.jxdinfo.crm.core.api.competitor.service.ICompetitorAPIService;
import com.jxdinfo.crm.core.api.competitor.vo.CompetitorAPIVo;
import com.jxdinfo.crm.core.api.contact.service.IContactAPIService;
import com.jxdinfo.crm.core.api.contact.vo.ContactAPIVo;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.fileinfo.dto.FileInfoAPIDto;
import com.jxdinfo.crm.core.api.fileinfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.core.api.focus.service.IFocusAPIService;
import com.jxdinfo.crm.core.api.leads.service.ILeadsAPIService;
import com.jxdinfo.crm.core.api.leads.vo.LeadsAPIVo;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityAPIService;
import com.jxdinfo.crm.core.api.marketingactivity.vo.MarketingActivityAPIVo;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.unify.service.IUnifyAPIService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TrackRecordServiceImpl
extends ServiceImpl<TrackRecordMapper, TrackRecord>
implements TrackRecordService {
    @Resource
    private TrackRecordMapper trackRecordMapper;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;
    @Resource
    private ILeadsAPIService leadsAPIService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private IContactAPIService contactAPIService;
    @Resource
    private TrackRecordRelationService recordRelationService;
    @Resource
    private IMarketingActivityAPIService marketingActivityAPIService;
    @Resource
    private TrackRecordVisitorsService trackRecordVisitorsService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IFocusAPIService focusAPIService;
    @Resource
    private ICompetitorAPIService competitorAPIService;
    @Resource
    private CommonUnifyProperties commonUnifyProperties;
    @Resource
    private IAgentApiService agentAPIService;
    @Resource
    private IAgentContactApiService agentContactAPIService;
    @Resource
    private IUnifyAPIService unifyAPIService;

    @Override
    public Page<TrackRecordVo> followUpList(TrackRecordDto recordDto) {
        Page page = recordDto.getPage();
        if ("9".equals(recordDto.getRecordBusinessType())) {
            recordDto.setRecordBusinessType(null);
            recordDto.setProduceType("1");
        }
        List<TrackRecordVo> list = this.trackRecordMapper.followUpList((Page<TrackRecordVo>)page, recordDto);
        List positionDic = new ArrayList();
        if (!list.isEmpty()) {
            positionDic = this.sysDicRefService.getDicListByType("cust_position");
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (TrackRecordVo listTemp : list) {
            List ledas;
            List contactAPIVoList;
            List contactIds;
            HashMap<String, String> map;
            ArrayList<Map<String, String>> mapList;
            List opportunityAPIVoList;
            List opportunityIds;
            if (listTemp.getBusinessType().equals("1")) {
                CustomerAPIVo customer;
                if (HussarUtils.isNotEmpty((Object)listTemp.getOpportunityId())) {
                    opportunityIds = Arrays.stream(listTemp.getOpportunityId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                    opportunityAPIVoList = this.opportunityAPIService.selectList(opportunityIds);
                    mapList = new ArrayList<Map<String, String>>();
                    if (ToolUtil.isNotEmpty((Object)opportunityAPIVoList)) {
                        for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
                            map = new HashMap<String, String>();
                            map.put("opportunityId", String.valueOf(opportunityAPIVo.getOpportunityId()));
                            map.put("opportunityName", opportunityAPIVo.getOpportunityName());
                            mapList.add(map);
                        }
                    }
                    listTemp.setAssociateOpportunity(mapList);
                }
                if (HussarUtils.isNotEmpty((Object)listTemp.getContactId())) {
                    contactIds = Arrays.stream(listTemp.getContactId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                    contactAPIVoList = this.contactAPIService.selectList(contactIds);
                    mapList = new ArrayList();
                    if (ToolUtil.isNotEmpty((Object)contactAPIVoList)) {
                        for (ContactAPIVo contactAPIVo : contactAPIVoList) {
                            map = new HashMap();
                            map.put("contactId", String.valueOf(contactAPIVo.getContactId()));
                            map.put("contactName", contactAPIVo.getContactName());
                            mapList.add(map);
                        }
                    }
                    listTemp.setAssociateContact(mapList);
                }
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType() + listTemp.getTypeId())) && HussarUtils.isNotEmpty((Object)(customer = this.customerAPIService.selectOne(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType() + listTemp.getTypeId(), customer.getCustomerName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("1" + listTemp.getTypeId())) ? (String)nameMap.get("1" + listTemp.getTypeId()) : listTemp.getBusinessName());
            }
            if (listTemp.getBusinessType().equals("2")) {
                OpportunityAPIVo opportunity;
                if (HussarUtils.isNotEmpty((Object)listTemp.getContactId())) {
                    contactIds = Arrays.stream(listTemp.getContactId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                    contactAPIVoList = this.contactAPIService.selectList(contactIds);
                    mapList = new ArrayList();
                    if (ToolUtil.isNotEmpty((Object)contactAPIVoList)) {
                        for (ContactAPIVo contactAPIVo : contactAPIVoList) {
                            map = new HashMap();
                            map.put("contactId", String.valueOf(contactAPIVo.getContactId()));
                            map.put("contactName", contactAPIVo.getContactName());
                            mapList.add(map);
                        }
                    }
                    listTemp.setAssociateContact(mapList);
                }
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType() + listTemp.getTypeId())) && HussarUtils.isNotEmpty((Object)(opportunity = this.opportunityAPIService.selectOneOverride(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType() + listTemp.getTypeId(), opportunity.getOpportunityName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("2" + listTemp.getTypeId())) ? (String)nameMap.get("2" + listTemp.getTypeId()) : listTemp.getBusinessName());
            }
            if (listTemp.getBusinessType().equals("3")) {
                ContactAPIVo contact;
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType() + listTemp.getTypeId())) && HussarUtils.isNotEmpty((Object)(contact = this.contactAPIService.selectOne(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType() + listTemp.getTypeId(), contact.getContactName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("3" + listTemp.getTypeId())) ? (String)nameMap.get("3" + listTemp.getTypeId()) : listTemp.getBusinessName());
            }
            if (listTemp.getBusinessType().equals("4") && (ledas = this.leadsAPIService.selectList(listTemp.getTypeId())).size() > 0) {
                listTemp.setBusinessName(((LeadsAPIVo)ledas.get(0)).getLeadsName());
            }
            if (listTemp.getBusinessType().equals(CrmBusinessTypeEnum.CAMPAIGN.getId())) {
                MarketingActivityAPIVo marketingActivityEntity;
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType() + listTemp.getTypeId())) && HussarUtils.isNotEmpty((Object)(marketingActivityEntity = this.marketingActivityAPIService.selectOne(listTemp.getTypeId(), listTemp.getDelflag())))) {
                    nameMap.put(listTemp.getBusinessType() + listTemp.getTypeId(), marketingActivityEntity.getCampaignName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get(CrmBusinessTypeEnum.CAMPAIGN.getId() + listTemp.getTypeId())) ? (String)nameMap.get(CrmBusinessTypeEnum.CAMPAIGN.getId() + listTemp.getTypeId()) : listTemp.getBusinessName());
            }
            if (listTemp.getBusinessType().equals(CrmBusinessTypeEnum.AGENT.getId())) {
                if (HussarUtils.isNotEmpty((Object)listTemp.getOpportunityId())) {
                    opportunityIds = Arrays.stream(listTemp.getOpportunityId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                    opportunityAPIVoList = this.opportunityAPIService.selectList(opportunityIds);
                    mapList = new ArrayList();
                    if (ToolUtil.isNotEmpty((Object)opportunityAPIVoList)) {
                        for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
                            map = new HashMap();
                            map.put("opportunityId", String.valueOf(opportunityAPIVo.getOpportunityId()));
                            map.put("opportunityName", opportunityAPIVo.getOpportunityName());
                            mapList.add(map);
                        }
                    }
                    listTemp.setAssociateOpportunity(mapList);
                }
                if (HussarUtils.isNotEmpty((Object)listTemp.getContactId())) {
                    contactIds = Arrays.stream(listTemp.getContactId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                    contactAPIVoList = this.agentContactAPIService.selectList(contactIds);
                    mapList = new ArrayList();
                    if (ToolUtil.isNotEmpty((Object)contactAPIVoList)) {
                        for (AgentContactApiVo agentContactApiVo : contactAPIVoList) {
                            map = new HashMap();
                            map.put("contactId", String.valueOf(agentContactApiVo.getAgentContactId()));
                            map.put("contactName", agentContactApiVo.getAgentContactName());
                            mapList.add(map);
                        }
                    }
                    listTemp.setAssociateContact(mapList);
                }
            }
            if (!"5".equals(listTemp.getRecordType())) continue;
            List visitors = this.trackRecordVisitorsService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrackRecordVisitors::getRecordId, (Object)listTemp.getRecordId())).orderByAsc(TrackRecordVisitors::getShowOrder));
            StringBuilder visitorNames = new StringBuilder();
            if (!HussarUtils.isNotEmpty((Object)visitors)) continue;
            listTemp.setVisitors(visitors);
            for (TrackRecordVisitors visitor : visitors) {
                String positionName = "";
                if (positionDic != null) {
                    for (DicVo dicVo : positionDic) {
                        if (!dicVo.getValue().equals(visitor.getPositionId())) continue;
                        positionName = dicVo.getLabel();
                        visitor.setPositonName(positionName);
                        break;
                    }
                }
                if (StringUtil.isNotBlank((CharSequence)positionName)) {
                    visitorNames.append("\uff0c").append(visitor.getName()).append("\uff08").append(positionName).append("\uff09");
                    continue;
                }
                visitorNames.append("\uff0c").append(visitor.getName());
            }
            if (visitorNames.length() > 0) {
                visitorNames = new StringBuilder(visitorNames.substring(1));
            }
            listTemp.setVisitorNames(visitorNames.toString());
        }
        page.setRecords(list);
        return page;
    }

    @Override
    @Transactional
    public Boolean add(TrackRecordVo trackRecord) {
        List opportunityAPIVoList;
        LeadsAPIVo leads;
        if ("2".equals(trackRecord.getBusinessType()) && (HussarUtils.isNotEmpty((Object)trackRecord.getEndTime()) || HussarUtils.isNotEmpty((Object)trackRecord.getOpportunityAmount()) || HussarUtils.isNotEmpty((Object)trackRecord.getOpportunityWinRate()))) {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("opportunityAmount", trackRecord.getOpportunityAmount());
            paramMap.put("endTime", trackRecord.getEndTime());
            paramMap.put("opportunityWinRate", trackRecord.getOpportunityWinRate());
            this.opportunityAPIService.editOpportunity(paramMap, trackRecord.getTypeId());
        }
        trackRecord.setDelflag("0");
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        if (trackRecord.getRecordId() == null) {
            trackRecord.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            trackRecord.setCreatePerson(user.getUserId());
            trackRecord.setCreatePersonName(user.getUserName());
            trackRecord.setCreateTime(date);
            trackRecord.setDepartmentId(user.getDeptId());
            trackRecord.setDepartmentName(user.getDeptName());
        }
        if (trackRecord.getFileId() != null) {
            FileInfoAPIDto fileInfoDto = new FileInfoAPIDto();
            fileInfoDto.setBusinessId(String.valueOf(trackRecord.getRecordId()));
            fileInfoDto.setIds(trackRecord.getFileId());
            this.fileInfoAPIService.insertFileInfo(fileInfoDto);
        }
        if (ToolUtil.isEmpty((Object)trackRecord.getCreateTime())) {
            trackRecord.setCreateTime(date);
        }
        if (trackRecord.getBusinessType().equals(CrmBusinessTypeEnum.OPPORTUNITY.getId())) {
            OpportunityAPIVo opportunityEntity = this.opportunityAPIService.getById(trackRecord.getTypeId());
            if (opportunityEntity.getState().equals("1") && !opportunityEntity.getState().equals("14")) {
                opportunityEntity.setState("2");
                this.opportunityAPIService.updateById(opportunityEntity);
            }
        } else if (trackRecord.getBusinessType().equals(CrmBusinessTypeEnum.LEADS.getId()) && (leads = this.leadsAPIService.selectById(trackRecord.getTypeId())).getState().equals("1")) {
            leads.setState("2");
            this.leadsAPIService.updateById(leads);
        }
        trackRecord.setState(null);
        TrackRecord recordEntity = (TrackRecord)BeanUtil.copy((Object)trackRecord, TrackRecord.class);
        ArrayList<Long> businessIds = new ArrayList<Long>();
        Long customerId = null;
        businessIds.add(recordEntity.getTypeId());
        ArrayList<String> opportunityNameList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(trackRecord.getOpportunityIdList()) && ToolUtil.isNotEmpty((Object)(opportunityAPIVoList = this.opportunityAPIService.selectList(trackRecord.getOpportunityIdList())))) {
            for (Object opportunityAPIVo : opportunityAPIVoList) {
                opportunityNameList.add(opportunityAPIVo.getOpportunityName());
            }
            recordEntity.setOpportunityId(StringUtil.join(trackRecord.getOpportunityIdList(), (String)","));
            recordEntity.setOpportunityName(StringUtil.join(opportunityNameList, (String)"\u3001"));
        }
        ArrayList<String> contactNameList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(trackRecord.getContactIdList())) {
            if (trackRecord.getBusinessType().equals(CrmBusinessTypeEnum.AGENT.getId())) {
                List agentContactApiVoList = this.agentContactAPIService.selectList(trackRecord.getContactIdList());
                if (ToolUtil.isNotEmpty((Object)agentContactApiVoList)) {
                    for (AgentContactApiVo agentContactApiVo : agentContactApiVoList) {
                        contactNameList.add(agentContactApiVo.getAgentContactName());
                    }
                    recordEntity.setContactId(StringUtil.join(trackRecord.getContactIdList(), (String)","));
                    recordEntity.setContactName(StringUtil.join(contactNameList, (String)"\u3001"));
                }
            } else {
                List contactAPIVoList = this.contactAPIService.selectList(trackRecord.getContactIdList());
                if (ToolUtil.isNotEmpty((Object)contactAPIVoList)) {
                    for (ContactAPIVo contactAPIVo : contactAPIVoList) {
                        contactNameList.add(contactAPIVo.getContactName());
                    }
                    recordEntity.setContactId(StringUtil.join(trackRecord.getContactIdList(), (String)","));
                    recordEntity.setContactName(StringUtil.join(contactNameList, (String)"\u3001"));
                }
            }
        }
        this.saveOrUpdate(recordEntity);
        if ("9".equals(recordEntity.getRecordType())) {
            String customerName = "";
            if ("1".equals(recordEntity.getBusinessType())) {
                customerName = recordEntity.getBusinessName();
            } else if ("2".equals(recordEntity.getBusinessType())) {
                Object opportunityAPIVo;
                opportunityAPIVo = this.opportunityAPIService.getById(recordEntity.getTypeId());
                customerName = opportunityAPIVo.getCustomerName();
            }
            this.saveOrUpdateVisitBenchmarkCustomerRecord(recordEntity, user, customerName, date);
        }
        String title = "\u65b0\u589e\u4e86\u4e00\u6761\u8ddf\u8fdb\u8bb0\u5f55";
        String url = "/crm/sy/yddsy";
        String unifyWebUrl = this.commonUnifyProperties.getCrmUrl() + "/index";
        String content = trackRecord.getRecordContent();
        String businessName = "";
        Long chargerPersonId = null;
        List<String> productManagerIds = new ArrayList<String>();
        if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(recordEntity.getBusinessType())) {
            OpportunityAPIVo opportunity = this.opportunityAPIService.getById(recordEntity.getTypeId());
            businessName = opportunity.getOpportunityName();
            customerId = opportunity.getCustomerId();
            if (ToolUtil.isNotEmpty((Object)customerId)) {
                businessIds.add(customerId);
            }
            chargerPersonId = opportunity.getChargePersonId();
            title = user.getUserName() + "\u65b0\u589e\u4e86\u4e00\u6761\u5546\u673a\u8ddf\u8fdb\u8bb0\u5f55";
            url = "/crm/sj/sjxq/xxzl";
            unifyWebUrl = this.commonUnifyProperties.getCrmUrl() + "/crm/businessDetails?row=" + "\"" + recordEntity.getTypeId() + "\"";
            this.saveContactTrackRecord(trackRecord, businessIds, date, user);
        } else if (CrmBusinessTypeEnum.CONTACT.getId().equals(recordEntity.getBusinessType())) {
            customerId = this.contactAPIService.getById(recordEntity.getTypeId()).getCustomerId();
            businessIds.add(customerId);
        } else if (CrmBusinessTypeEnum.CUSTOMER.getId().equals(recordEntity.getBusinessType())) {
            customerId = recordEntity.getTypeId();
            CustomerAPIVo customer = this.customerAPIService.selectById(customerId);
            businessName = customer.getCustomerName();
            title = user.getUserName() + "\u65b0\u589e\u4e86\u4e00\u6761\u5ba2\u6237\u8ddf\u8fdb\u8bb0\u5f55";
            url = "/crm/kh/khxq";
            unifyWebUrl = this.commonUnifyProperties.getCrmUrl() + "/crm/clientDetails?row=" + "\"" + recordEntity.getTypeId() + "\"";
            chargerPersonId = customer.getChargePersonId();
            this.saveContactTrackRecord(trackRecord, businessIds, date, user);
            this.saveOpportunityTrackRecord(trackRecord, productManagerIds, businessIds, date, user);
        } else if (CrmBusinessTypeEnum.LEADS.getId().equals(recordEntity.getBusinessType())) {
            LeadsAPIVo leads2 = this.leadsAPIService.selectById(recordEntity.getTypeId());
            businessName = leads2.getLeadsName();
            title = user.getUserName() + "\u65b0\u589e\u4e86\u4e00\u6761\u7ebf\u7d22\u8ddf\u8fdb\u8bb0\u5f55";
            url = "/crm/schd/xsxq";
        } else if (CrmBusinessTypeEnum.AGENT.getId().equals(recordEntity.getBusinessType())) {
            AgentApiVo agent = this.agentAPIService.getById((Serializable)recordEntity.getTypeId());
            businessName = agent.getAgentName();
            title = user.getUserName() + "\u65b0\u589e\u4e86\u4e00\u6761\u4ee3\u7406\u5546\u8ddf\u8fdb\u8bb0\u5f55";
            url = "/crm/sy/yddsy";
            unifyWebUrl = this.commonUnifyProperties.getCrmUrl() + "/crm/agentDetails?row=" + "\"" + recordEntity.getTypeId() + "\"";
            chargerPersonId = agent.getChargePerson();
            if (ToolUtil.isNotEmpty(trackRecord.getContactIdList())) {
                for (Long contactId : trackRecord.getContactIdList()) {
                    businessIds.add(contactId);
                    AgentContactApiVo agentContact = new AgentContactApiVo();
                    agentContact.setAgentContactId(contactId);
                    if (trackRecord.getNextTime() != null) {
                        agentContact.setNextTime(trackRecord.getNextTime());
                    }
                    agentContact.setTrackTime(date);
                    agentContact.setChangeTime(date);
                    agentContact.setChangePerson(user.getUserId());
                    agentContact.setChangePersonName(user.getUserName());
                    this.agentContactAPIService.updateById(agentContact);
                }
            }
            if (ToolUtil.isNotEmpty(trackRecord.getOpportunityIdList())) {
                for (Long opportunityId : trackRecord.getOpportunityIdList()) {
                    productManagerIds = this.opportunityAPIService.opportunityProductManagerList(opportunityId, "0", null);
                    businessIds.add(opportunityId);
                    OpportunityAPIVo opportunityEntity = new OpportunityAPIVo();
                    opportunityEntity.setOpportunityId(opportunityId);
                    if (trackRecord.getNextTime() != null) {
                        opportunityEntity.setNextTime(trackRecord.getNextTime());
                    }
                    opportunityEntity.setTrackTime(date);
                    opportunityEntity.setTrackPerson(user.getUserId());
                    opportunityEntity.setTrackPersonName(user.getUserName());
                    opportunityEntity.setChangeTime(date);
                    opportunityEntity.setChangePerson(user.getUserId());
                    opportunityEntity.setChangePersonName(user.getUserName());
                    this.opportunityAPIService.updateById(opportunityEntity);
                }
            }
            if (recordEntity.getAssociatedCustomerId() != null) {
                customerId = recordEntity.getAssociatedCustomerId();
                businessIds.add(customerId);
            }
        }
        if (CollectionUtil.isNotEmpty(trackRecord.getVisitors())) {
            this.getTrackRecordVisitors(trackRecord.getRecordId(), trackRecord.getVisitors());
            if (trackRecord.getVisitors().size() > 0) {
                this.trackRecordVisitorsService.saveBatch(trackRecord.getVisitors());
            }
        }
        this.recordRelationService.saveBatch(this.saveTrackRecordRelation(trackRecord.getRecordId(), businessIds));
        this.updateNextTime(trackRecord.getBusinessType(), trackRecord.getTypeId(), trackRecord.getNextTime(), date, null);
        List<Object> userIds = new ArrayList<String>();
        List focusId = this.focusAPIService.selectCreateId(trackRecord.getBusinessType(), trackRecord.getTypeId());
        if (CollectionUtil.isNotEmpty((Collection)focusId)) {
            userIds.addAll(focusId);
        }
        if (CollectionUtil.isNotEmpty(productManagerIds)) {
            userIds.addAll(productManagerIds);
        }
        if (CollectionUtil.isNotEmpty((Object)chargerPersonId)) {
            userIds.add(String.valueOf(chargerPersonId));
        }
        String contentIM = "";
        if (CollectionUtil.isNotEmpty(userIds)) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            userIds.removeIf(id -> HussarUtils.toStr((Object)user.getUserId()).equals(id));
            if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(recordEntity.getBusinessType()) || CrmBusinessTypeEnum.CUSTOMER.getId().equals(recordEntity.getBusinessType()) || CrmBusinessTypeEnum.LEADS.getId().equals(recordEntity.getBusinessType()) || CrmBusinessTypeEnum.AGENT.getId().equals(recordEntity.getBusinessType())) {
                contentIM = "\u3010" + businessName + "\u3011" + content;
            }
            EimPushUtil.pushJqxArticleMessage(title, contentIM, url, String.valueOf(recordEntity.getTypeId()), userIds);
            String contentUnify = "\u3010\u8ddf\u8fdb\u8bb0\u5f55\u63d0\u9192\u3011" + user.getUserName() + " \u65b0\u589e\u4e86\u4e00\u6761\u3010" + businessName + "\u3011\u7684\u8ddf\u8fdb\u8bb0\u5f55\uff0c\u8ddf\u8fdb\u5185\u5bb9\uff1a" + content + "\u3002";
            String userIdToString = StringUtil.join(userIds, (String)",");
            this.unifyAPIService.unifySendMessage(contentUnify, date, user, userIdToString, user.getUserName(), unifyWebUrl, "");
        }
        return true;
    }

    private void saveContactTrackRecord(TrackRecordVo trackRecord, List<Long> businessIds, LocalDateTime date, SecurityUser user) {
        if (ToolUtil.isNotEmpty(trackRecord.getContactIdList())) {
            for (Long contactId : trackRecord.getContactIdList()) {
                businessIds.add(contactId);
                ContactAPIVo contactEntity = new ContactAPIVo();
                contactEntity.setContactId(contactId);
                if (trackRecord.getNextTime() != null) {
                    contactEntity.setNextTime(trackRecord.getNextTime());
                }
                contactEntity.setTrackTime(date);
                contactEntity.setChangeTime(date);
                contactEntity.setChangePerson(user.getUserId());
                contactEntity.setChangePersonName(user.getUserName());
                this.contactAPIService.updateById(contactEntity);
            }
        }
    }

    private void saveOpportunityTrackRecord(TrackRecordVo trackRecord, List<String> productManagerIds, List<Long> businessIds, LocalDateTime date, SecurityUser user) {
        if (ToolUtil.isNotEmpty(trackRecord.getOpportunityIdList())) {
            for (Long opportunityId : trackRecord.getOpportunityIdList()) {
                productManagerIds = this.opportunityAPIService.opportunityProductManagerList(opportunityId, "0", null);
                businessIds.add(opportunityId);
                OpportunityAPIVo opportunityEntity = new OpportunityAPIVo();
                opportunityEntity.setOpportunityId(opportunityId);
                if (trackRecord.getNextTime() != null) {
                    opportunityEntity.setNextTime(trackRecord.getNextTime());
                }
                opportunityEntity.setTrackTime(date);
                opportunityEntity.setTrackPerson(user.getUserId());
                opportunityEntity.setTrackPersonName(user.getUserName());
                opportunityEntity.setChangeTime(date);
                opportunityEntity.setChangePerson(user.getUserId());
                opportunityEntity.setChangePersonName(user.getUserName());
                this.opportunityAPIService.updateById(opportunityEntity);
            }
        }
    }

    private List<TrackRecordRelation> saveTrackRecordRelation(Long recordId, List<Long> businessIds) {
        ArrayList<TrackRecordRelation> relationList = new ArrayList<TrackRecordRelation>();
        if (CollectionUtil.isNotEmpty(businessIds)) {
            for (Long businessId : businessIds) {
                if (businessId == null) continue;
                TrackRecordRelation recordRelation = new TrackRecordRelation();
                recordRelation.setRecordId(recordId);
                recordRelation.setTypeId(businessId);
                relationList.add(recordRelation);
            }
        }
        return relationList;
    }

    private void getTrackRecordVisitors(Long recordId, List<TrackRecordVisitors> visitors) {
        if (CollectionUtil.isNotEmpty(visitors)) {
            for (int i = 0; i < visitors.size(); ++i) {
                if (StringUtil.isEmpty((Object)visitors.get(i).getName())) {
                    visitors.remove(visitors.get(i));
                    continue;
                }
                visitors.get(i).setRecordId(recordId);
                visitors.get(i).setShowOrder(i + 1);
            }
        }
    }

    @Override
    @Transactional
    public Boolean update(TrackRecordVo trackRecord) {
        ArrayList<Long> businessIds;
        List opportunityAPIVoList;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (trackRecord.getFileId() != null) {
            FileInfoAPIDto fileInfoDto = new FileInfoAPIDto();
            fileInfoDto.setBusinessId(String.valueOf(trackRecord.getRecordId()));
            fileInfoDto.setIds(trackRecord.getFileId());
            this.fileInfoAPIService.insertFileInfo(fileInfoDto);
        }
        LocalDateTime date = LocalDateTime.now();
        TrackRecord recordEntity = (TrackRecord)BeanUtil.copy((Object)trackRecord, TrackRecord.class);
        ArrayList<String> opportunityNameList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(trackRecord.getOpportunityIdList()) && ToolUtil.isNotEmpty((Object)(opportunityAPIVoList = this.opportunityAPIService.selectList(trackRecord.getOpportunityIdList())))) {
            for (Object opportunityAPIVo : opportunityAPIVoList) {
                opportunityNameList.add(opportunityAPIVo.getOpportunityName());
            }
            assert (recordEntity != null);
            recordEntity.setOpportunityId(StringUtil.join(trackRecord.getOpportunityIdList(), (String)","));
            recordEntity.setOpportunityName(StringUtil.join(opportunityNameList, (String)"\u3001"));
        }
        ArrayList<String> contactNameList = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(trackRecord.getContactIdList())) {
            if (trackRecord.getBusinessType().equals(CrmBusinessTypeEnum.AGENT.getId())) {
                List agentContactApiVoList = this.agentContactAPIService.selectList(trackRecord.getContactIdList());
                if (ToolUtil.isNotEmpty((Object)agentContactApiVoList)) {
                    for (AgentContactApiVo agentContactApiVo : agentContactApiVoList) {
                        contactNameList.add(agentContactApiVo.getAgentContactName());
                    }
                    assert (recordEntity != null);
                    recordEntity.setContactId(StringUtil.join(trackRecord.getContactIdList(), (String)","));
                    recordEntity.setContactName(StringUtil.join(contactNameList, (String)"\u3001"));
                }
            } else {
                List contactAPIVoList = this.contactAPIService.selectList(trackRecord.getContactIdList());
                if (ToolUtil.isNotEmpty((Object)contactAPIVoList)) {
                    for (ContactAPIVo contactAPIVo : contactAPIVoList) {
                        contactNameList.add(contactAPIVo.getContactName());
                    }
                    assert (recordEntity != null);
                    recordEntity.setContactId(StringUtil.join(trackRecord.getContactIdList(), (String)","));
                    recordEntity.setContactName(StringUtil.join(contactNameList, (String)"\u3001"));
                }
            }
        }
        this.saveOrUpdate(recordEntity);
        Long recordId = trackRecord.getRecordId();
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TrackRecord::getOriginalRecordId, (Object)recordId)).set(TrackRecord::getDelflag, (Object)"1"));
        if ("9".equals(recordEntity.getRecordType())) {
            String customerName = "";
            if ("1".equals(recordEntity.getBusinessType())) {
                customerName = recordEntity.getBusinessName();
            } else if ("2".equals(recordEntity.getBusinessType())) {
                OpportunityAPIVo opportunityAPIVo = this.opportunityAPIService.getById(recordEntity.getTypeId());
                customerName = opportunityAPIVo.getCustomerName();
            }
            this.saveOrUpdateVisitBenchmarkCustomerRecord(recordEntity, user, customerName, date);
        }
        if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(trackRecord.getBusinessType())) {
            OpportunityAPIVo opportunity = this.opportunityAPIService.getById(trackRecord.getTypeId());
            opportunity.setChangeTime(date);
            opportunity.setChangePerson(user.getUserId());
            opportunity.setChangePersonName(user.getUserName());
            String endTime = trackRecord.getEndTime();
            String opportunityAmount = trackRecord.getOpportunityAmount();
            String opportunityWinRate = trackRecord.getOpportunityWinRate();
            if (HussarUtils.isNotEmpty((Object)endTime)) {
                opportunity.setEndTime(endTime);
            }
            if (HussarUtils.isNotEmpty((Object)opportunityAmount)) {
                opportunity.setOpportunityAmount(opportunityAmount);
            }
            if (HussarUtils.isNotEmpty((Object)opportunityWinRate)) {
                opportunity.setOpportunityWinRate(opportunityWinRate);
            }
            this.opportunityAPIService.updateById(opportunity);
        }
        assert (recordEntity != null);
        if (CrmBusinessTypeEnum.CUSTOMER.getId().equals(recordEntity.getBusinessType())) {
            this.recordRelationService.remove((Wrapper)new LambdaQueryWrapper().eq(TrackRecordRelation::getRecordId, (Object)recordEntity.getRecordId()));
            businessIds = new ArrayList<Long>();
            businessIds.add(trackRecord.getTypeId());
            if (CollectionUtil.isNotEmpty(trackRecord.getContactIdList())) {
                businessIds.addAll(trackRecord.getContactIdList());
            }
            if (CollectionUtil.isNotEmpty(trackRecord.getOpportunityIdList())) {
                businessIds.addAll(trackRecord.getOpportunityIdList());
            }
            this.recordRelationService.saveBatch(this.saveTrackRecordRelation(trackRecord.getRecordId(), businessIds));
        }
        if (CrmBusinessTypeEnum.AGENT.getId().equals(trackRecord.getBusinessType())) {
            this.recordRelationService.remove((Wrapper)new LambdaQueryWrapper().eq(TrackRecordRelation::getRecordId, (Object)recordEntity.getRecordId()));
            businessIds = new ArrayList();
            businessIds.add(trackRecord.getTypeId());
            if (CollectionUtil.isNotEmpty(trackRecord.getContactIdList())) {
                businessIds.addAll(trackRecord.getContactIdList());
            }
            if (CollectionUtil.isNotEmpty(trackRecord.getOpportunityIdList())) {
                businessIds.addAll(trackRecord.getOpportunityIdList());
            }
            this.recordRelationService.saveBatch(this.saveTrackRecordRelation(trackRecord.getRecordId(), businessIds));
        }
        if ("5".equals(recordEntity.getRecordType())) {
            this.trackRecordVisitorsService.remove((Wrapper)new LambdaQueryWrapper().eq(TrackRecordVisitors::getRecordId, (Object)recordEntity.getRecordId()));
            if (CollectionUtil.isNotEmpty(trackRecord.getVisitors())) {
                this.getTrackRecordVisitors(trackRecord.getRecordId(), trackRecord.getVisitors());
                if (trackRecord.getVisitors().size() > 0) {
                    this.trackRecordVisitorsService.saveBatch(trackRecord.getVisitors());
                }
            }
        }
        String isUpdate = "1";
        this.updateNextTime(trackRecord.getBusinessType(), trackRecord.getTypeId(), trackRecord.getNextTime(), date, isUpdate);
        return true;
    }

    @Override
    @Transactional
    public int delete(Long recordId) {
        LocalDateTime date = LocalDateTime.now();
        SecurityUser user = BaseSecurityUtil.getUser();
        TrackRecord trackRecord = (TrackRecord)this.getById(recordId);
        Long opid = trackRecord.getTypeId();
        OpportunityAPIVo opportunity = this.opportunityAPIService.getById(opid);
        if (HussarUtils.isNotEmpty((Object)opportunity)) {
            opportunity.setChangeTime(date);
            opportunity.setChangePerson(user.getUserId());
            opportunity.setChangePersonName(user.getUserName());
            this.opportunityAPIService.updateById(opportunity);
        }
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(TrackRecord::getOriginalRecordId, (Object)recordId)).set(TrackRecord::getDelflag, (Object)"1"));
        int i = this.trackRecordMapper.delete(recordId);
        return i;
    }

    @Override
    public int deleteBySchd(Long typeId) {
        int i = this.trackRecordMapper.deleteBySchd(typeId);
        return i;
    }

    @Override
    public List<SearchView> querycustomize(Long businessFunctionId) {
        List<SearchView> list = this.trackRecordMapper.querycustomize(businessFunctionId);
        return list;
    }

    @Transactional
    public void updateNextTime(String businessType, Long typeId, LocalDateTime nextTime, LocalDateTime date, String isUpdate) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (CrmBusinessTypeEnum.CUSTOMER.getId().equals(businessType)) {
            CustomerAPIVo customerEntity = new CustomerAPIVo();
            customerEntity.setCustomerId(typeId);
            if (nextTime != null) {
                customerEntity.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                customerEntity.setTrackTime(date);
                customerEntity.setChangeTime(date);
                customerEntity.setChangePerson(user.getUserId());
                customerEntity.setChangePersonName(user.getUserName());
                this.customerAPIService.updateById(customerEntity);
            }
        } else if (CrmBusinessTypeEnum.AGENT.getId().equals(businessType)) {
            AgentApiVo agentEntity = new AgentApiVo();
            agentEntity.setAgentId(typeId);
            if (nextTime != null) {
                agentEntity.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                agentEntity.setTrackTime(date);
                agentEntity.setChangeTime(date);
                agentEntity.setChangePerson(user.getUserId());
                agentEntity.setChangePersonName(user.getUserName());
                this.agentAPIService.updateById(agentEntity);
            }
        } else if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(businessType)) {
            CustomerAPIVo customerEntity = new CustomerAPIVo();
            OpportunityAPIVo opportunityEntity = new OpportunityAPIVo();
            opportunityEntity.setOpportunityId(typeId);
            if (nextTime != null) {
                opportunityEntity.setNextTime(nextTime);
                customerEntity.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                opportunityEntity.setTrackTime(date);
                opportunityEntity.setTrackPerson(user.getUserId());
                opportunityEntity.setTrackPersonName(user.getUserName());
                opportunityEntity.setChangeTime(date);
                opportunityEntity.setChangePerson(user.getUserId());
                opportunityEntity.setChangePersonName(user.getUserName());
                this.opportunityAPIService.updateById(opportunityEntity);
                opportunityEntity = this.opportunityAPIService.getById(typeId);
                customerEntity.setCustomerId(opportunityEntity.getCustomerId());
                customerEntity.setTrackTime(date);
                customerEntity.setChangeTime(date);
                customerEntity.setChangePerson(user.getUserId());
                customerEntity.setChangePersonName(user.getUserName());
                this.customerAPIService.updateById(customerEntity);
            }
        } else if (CrmBusinessTypeEnum.CONTACT.getId().equals(businessType)) {
            CustomerAPIVo customerEntity = new CustomerAPIVo();
            ContactAPIVo contactEntity = new ContactAPIVo();
            contactEntity.setContactId(typeId);
            if (nextTime != null) {
                contactEntity.setNextTime(nextTime);
                customerEntity.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                contactEntity.setTrackTime(date);
                contactEntity.setChangeTime(date);
                contactEntity.setChangePerson(user.getUserId());
                contactEntity.setChangePersonName(user.getUserName());
                this.contactAPIService.updateById(contactEntity);
                contactEntity = this.contactAPIService.getById(typeId);
                customerEntity.setCustomerId(contactEntity.getCustomerId());
                customerEntity.setTrackTime(date);
                customerEntity.setChangeTime(date);
                customerEntity.setChangePerson(user.getUserId());
                customerEntity.setChangePersonName(user.getUserName());
                this.customerAPIService.updateById(customerEntity);
            }
        } else if (CrmBusinessTypeEnum.LEADS.getId().equals(businessType)) {
            LeadsAPIVo lead = new LeadsAPIVo();
            lead.setLeadsId(typeId);
            if (nextTime != null) {
                lead.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                lead.setTrackTime(date);
                this.leadsAPIService.updateById(lead);
            }
        } else if (CrmBusinessTypeEnum.CAMPAIGN.getId().equals(businessType)) {
            MarketingActivityAPIVo marketingActivity = new MarketingActivityAPIVo();
            marketingActivity.setCampaignId(typeId);
            if (marketingActivity == null) {
                marketingActivity.setTrackTime(date);
                this.marketingActivityAPIService.updateById(marketingActivity);
            }
        } else if (CrmBusinessTypeEnum.COMPETITOR.getId().equals(businessType)) {
            CompetitorAPIVo competitor = new CompetitorAPIVo();
            competitor.setCompetitorId(typeId);
            if (competitor == null) {
                competitor.setTrackTime(date);
                this.competitorAPIService.updateById(competitor);
            }
        }
    }

    @Override
    public TrackRecordVo trackRecordDetails(TrackRecordDto dto) {
        List visitors;
        TrackRecordVo recordVo = this.trackRecordMapper.trackRecordDetails(dto.getRecordId());
        if (recordVo != null && recordVo.getBusinessType().equals("1") && "5".equals(recordVo.getRecordType()) && CollectionUtil.isNotEmpty((Collection)(visitors = this.trackRecordVisitorsService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrackRecordVisitors::getRecordId, (Object)recordVo.getRecordId())).orderByAsc(TrackRecordVisitors::getShowOrder))))) {
            recordVo.setVisitors(visitors);
        }
        if (recordVo != null) {
            HashMap<String, String> map;
            ArrayList<Map<String, String>> mapList;
            if ((recordVo.getBusinessType().equals(CrmBusinessTypeEnum.CUSTOMER.getId()) || recordVo.getBusinessType().equals(CrmBusinessTypeEnum.OPPORTUNITY.getId()) || recordVo.getBusinessType().equals(CrmBusinessTypeEnum.AGENT.getId())) && HussarUtils.isNotEmpty((Object)recordVo.getContactId())) {
                List contactAPIVoList;
                List contactIds;
                if (recordVo.getBusinessType().equals(CrmBusinessTypeEnum.AGENT.getId())) {
                    contactIds = Arrays.stream(recordVo.getContactId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                    contactAPIVoList = this.agentContactAPIService.selectList(contactIds);
                    mapList = new ArrayList<Map<String, String>>();
                    if (ToolUtil.isNotEmpty((Object)contactAPIVoList)) {
                        for (AgentContactApiVo agentContactApiVo : contactAPIVoList) {
                            map = new HashMap<String, String>();
                            map.put("contactId", String.valueOf(agentContactApiVo.getAgentContactId()));
                            map.put("contactName", agentContactApiVo.getAgentContactName());
                            mapList.add(map);
                        }
                    }
                    recordVo.setAssociateContact(mapList);
                } else {
                    contactIds = Arrays.stream(recordVo.getContactId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                    contactAPIVoList = this.contactAPIService.selectList(contactIds);
                    mapList = new ArrayList();
                    if (ToolUtil.isNotEmpty((Object)contactAPIVoList)) {
                        for (ContactAPIVo contactAPIVo : contactAPIVoList) {
                            map = new HashMap();
                            map.put("contactId", String.valueOf(contactAPIVo.getContactId()));
                            map.put("contactName", contactAPIVo.getContactName());
                            mapList.add(map);
                        }
                    }
                    recordVo.setAssociateContact(mapList);
                }
            }
            if ((recordVo.getBusinessType().equals(CrmBusinessTypeEnum.CUSTOMER.getId()) || recordVo.getBusinessType().equals(CrmBusinessTypeEnum.AGENT.getId())) && HussarUtils.isNotEmpty((Object)recordVo.getOpportunityId())) {
                List opportunityIds = Arrays.stream(recordVo.getOpportunityId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                List opportunityAPIVoList = this.opportunityAPIService.selectList(opportunityIds);
                mapList = new ArrayList();
                if (ToolUtil.isNotEmpty((Object)opportunityAPIVoList)) {
                    for (OpportunityAPIVo opportunityAPIVo : opportunityAPIVoList) {
                        map = new HashMap();
                        map.put("opportunityId", String.valueOf(opportunityAPIVo.getOpportunityId()));
                        map.put("opportunityName", opportunityAPIVo.getOpportunityName());
                        mapList.add(map);
                    }
                }
                recordVo.setAssociateOpportunity(mapList);
            }
        }
        return recordVo;
    }

    @Override
    public long countTrackRecordByTypeIds(List<Long> typeIds) {
        long countTrackRecord = this.count((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrackRecord::getTypeId, typeIds)).eq(TrackRecord::getProduceType, (Object)RecordProductTypeEnum.PRODUCE_SYSTEM.getId())).eq(TrackRecord::getDelflag, (Object)"0"));
        return countTrackRecord;
    }

    @Override
    public boolean mergeTrackRecord(List<Long> oldBusinessIdList, Long newBusinessId) {
        this.recordRelationService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(TrackRecordRelation::getTypeId, oldBusinessIdList)).set(TrackRecordRelation::getTypeId, (Object)newBusinessId));
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(TrackRecord::getTypeId, oldBusinessIdList)).set(TrackRecord::getTypeId, (Object)newBusinessId));
        return true;
    }

    private boolean saveOrUpdateVisitBenchmarkCustomerRecord(TrackRecord originalRecord, SecurityUser user, String customerName, LocalDateTime dateNow) {
        TrackRecord trackRecord = new TrackRecord();
        trackRecord.setCreateTime(dateNow);
        trackRecord.setCreatePerson(originalRecord.getCreatePerson());
        trackRecord.setCreatePersonName(originalRecord.getCreatePersonName());
        trackRecord.setRecordType(originalRecord.getRecordType());
        trackRecord.setBenchmarkCustomerId(originalRecord.getBenchmarkCustomerId());
        trackRecord.setBenchmarkCustomerName(originalRecord.getBenchmarkCustomerName());
        trackRecord.setTrackTime(originalRecord.getTrackTime());
        trackRecord.setActualTrackTime(originalRecord.getActualTrackTime());
        trackRecord.setBusinessType(trackRecord.getBuildType());
        trackRecord.setBusinessType("1");
        trackRecord.setProduceType("1");
        trackRecord.setTypeId(originalRecord.getBenchmarkCustomerId());
        trackRecord.setBusinessName(originalRecord.getBenchmarkCustomerName());
        trackRecord.setOriginalRecordId(originalRecord.getRecordId());
        trackRecord.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        StringBuilder sb = new StringBuilder();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
        sb.append(user.getDeptName()).append("-").append(user.getUserName()).append("\uff0c\u4e8e").append(trackRecord.getActualTrackTime().format(formatter)).append("\u5e26\u3010").append(customerName).append("\u3011\u5ba2\u6237\u8fdb\u884c\u4e86\u53c2\u89c2\u62dc\u8bbf\u3002");
        trackRecord.setRecordContent(sb.toString());
        trackRecord.setDelflag("0");
        TrackRecordRelation relation = new TrackRecordRelation();
        relation.setRecordId(trackRecord.getRecordId());
        relation.setTypeId(trackRecord.getTypeId());
        relation.setDelFlag("0");
        this.save(trackRecord);
        this.recordRelationService.save(relation);
        return true;
    }
}

