/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.organUserComponent.external.servie.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.organUserComponent.dao.OrganUserMapper;
import com.jxdinfo.crm.common.organUserComponent.service.IOrganUserService;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrganUserBoServiceImpl
implements IOrganUserBoService {
    @Resource
    private IOrganUserService organUserService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private OrganUserMapper organUserMapper;
    @Resource
    private CrmCommonProperties crmCommonProperties;

    public List<Long> getOrganByParentId(List<Long> departIdList) {
        return this.organUserService.getOrganByParentId(departIdList);
    }

    public List<Long> getOrganByParentIdContainsParent(List<Long> departIdList) {
        return this.organUserService.getOrganByParentIdContainsParent(departIdList);
    }

    public List<UserVo> getUserListByDepartmentId(List<Long> departmentIdList) {
        List<Long> allDepartmentIdList = this.organUserService.getOrganByParentIdContainsParent(departmentIdList);
        return this.hussarBaseUserBoService.getUsersByOrganUser(allDepartmentIdList, null);
    }

    public List<Long> getParentOrganIncludeOneself(List<Long> departIdList) {
        return this.organUserService.getParentOrganIncludeOneself(departIdList);
    }

    public List<UserVo> getAllSalesman() {
        Long salesManRole = Long.parseLong(this.crmCommonProperties.getRoles().getSalesmanAnalysis());
        List userVoList = this.hussarBaseUserBoService.getUserInfoByRoleId(Collections.singletonList(salesManRole));
        return userVoList;
    }

    public List<String> getProvinceCodeByStruId(Long struId) {
        return this.organUserMapper.selectProvinceCodeByStruId(struId);
    }

    public List<Long> getStruIdByProvinceCode(Long provinceId) {
        return this.organUserMapper.selectStruIdByProvinceCode(provinceId);
    }

    public List<UserVo> getUserByRoleAndDept(String role, List<Long> struIdList) {
        return this.organUserMapper.selectUserByRoleAndDept(role, struIdList);
    }

    public List<String> selectUserAllStruId(Long userId) {
        return this.organUserMapper.selectUserAllStruId(userId);
    }
}

