/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.sysCalendar.service.impl;

import com.jxdinfo.crm.common.api.sysCalendar.dto.DayTypeDto;
import com.jxdinfo.crm.common.api.sysCalendar.dto.RecycleReasonDate;
import com.jxdinfo.crm.common.api.sysCalendar.service.ISysCalendarBoService;
import com.jxdinfo.hussar.general.calendar.dao.SysCalendarMapper;
import com.jxdinfo.hussar.general.calendar.model.SysCalendar;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysCalendarBoServiceImpl
implements ISysCalendarBoService {
    @Resource
    private SysCalendarMapper calendarMapper;

    public List<SysCalendar> getEventsList() {
        return this.calendarMapper.getEventsList();
    }

    public List<LocalDate> getStartDate(List<DayTypeDto> list, LocalDate today) {
        ArrayList<LocalDate> dateList = new ArrayList<LocalDate>();
        for (DayTypeDto dateAndType : list) {
            String dateType = dateAndType.getDateType();
            Integer day = dateAndType.getDay();
            if (day == null) {
                dateList.add(null);
                continue;
            }
            LocalDate baseDate = today.minusDays(1L).minusDays(day.intValue());
            if (!"1".equals(dateAndType.getSwitchFlag())) {
                dateList.add(null);
                continue;
            }
            if ("1".equals(dateType)) {
                dateList.add(baseDate);
                continue;
            }
            List<Object> calendarList = this.getEventsList();
            calendarList.removeIf(sysCalendar -> sysCalendar.getStartTime().isAfter(LocalDate.now().atStartOfDay()));
            if ("2".equals(dateType)) {
                ArrayList exhDateList = new ArrayList();
                calendarList = calendarList.stream().filter(sysCalendar -> "\u4f11".equals(sysCalendar.getTitle())).collect(Collectors.toList());
                calendarList.sort(Comparator.comparing(SysCalendar::getStartTime).reversed());
                for (SysCalendar sysCalendar2 : calendarList) {
                    if (!sysCalendar2.getStartTime().isAfter(baseDate.atStartOfDay())) continue;
                    baseDate = baseDate.minusDays(1L);
                }
                dateList.add(baseDate);
                continue;
            }
            if (!"3".equals(dateType)) continue;
            ArrayList exhwDateList = new ArrayList();
            List workDayList = calendarList.stream().filter(sysCalendar -> "\u73ed".equals(sysCalendar.getTitle())).map(sysCalendar -> sysCalendar.getStartTime().toLocalDate()).collect(Collectors.toList());
            List list2 = calendarList.stream().filter(sysCalendar -> "\u4f11".equals(sysCalendar.getTitle())).map(sysCalendar -> sysCalendar.getStartTime().toLocalDate()).collect(Collectors.toList());
            LocalDate dayExcludingHW = LocalDate.from(today).minusDays(1L);
            int weekDay = today.minusDays(1L).getDayOfWeek().getValue();
            for (int i = 0; i < day; ++i) {
                int n = weekDay = weekDay < 1 ? 7 : weekDay;
                if (!workDayList.contains(dayExcludingHW) && (weekDay == 6 || weekDay == 7 || list2.contains(dayExcludingHW))) {
                    --i;
                }
                dayExcludingHW = dayExcludingHW.minusDays(1L);
                --weekDay;
            }
            dateList.add(dayExcludingHW);
        }
        return dateList;
    }

    public Map<Long, RecycleReasonDate> getRecycleTime(Map<Long, List<DayTypeDto>> dtoListMap, Map<Long, LocalDate> dateMap) {
        HashMap<Long, RecycleReasonDate> recycleTimeMap = new HashMap<Long, RecycleReasonDate>();
        List<SysCalendar> calendarList = this.getEventsList();
        calendarList.sort(Comparator.comparing(SysCalendar::getStartTime));
        for (Map.Entry<Long, List<DayTypeDto>> listEntry : dtoListMap.entrySet()) {
            Map<String, Integer> typeDayMap = listEntry.getValue().stream().collect(Collectors.toMap(DayTypeDto::getDateType, DayTypeDto::getDay));
            RecycleReasonDate recycleReasonDate = new RecycleReasonDate();
            int reasonDay = 0;
            LocalDate recycleTime = null;
            LocalDate today = LocalDate.from(dateMap.get(listEntry.getKey()));
            if (typeDayMap.get("1") != null) {
                recycleTime = today.plusDays(typeDayMap.get("1") + 1);
                reasonDay = typeDayMap.get("1");
            }
            if (typeDayMap.get("2") != null) {
                List holidayCalendarList = calendarList.stream().filter(sysCalendar -> "\u4f11".equals(sysCalendar.getTitle())).collect(Collectors.toList());
                LocalDate timeTemp2 = LocalDate.from(today).plusDays(typeDayMap.get("2") + 1);
                for (SysCalendar calendar : holidayCalendarList) {
                    if (!calendar.getStartTime().isBefore(timeTemp2.atTime(23, 59, 59))) continue;
                    timeTemp2 = timeTemp2.plusDays(1L);
                }
                if (recycleTime != null) {
                    if (timeTemp2.isBefore(recycleTime)) {
                        recycleTime = timeTemp2;
                        reasonDay = typeDayMap.get("2");
                    }
                } else {
                    recycleTime = timeTemp2;
                    reasonDay = typeDayMap.get("2");
                }
            }
            if (typeDayMap.get("3") != null) {
                Integer day = typeDayMap.get("3") + 1;
                List workDayList = calendarList.stream().filter(sysCalendar -> "\u73ed".equals(sysCalendar.getTitle())).map(sysCalendar -> sysCalendar.getStartTime().toLocalDate()).collect(Collectors.toList());
                List holidayList = calendarList.stream().filter(sysCalendar -> "\u4f11".equals(sysCalendar.getTitle())).map(sysCalendar -> sysCalendar.getStartTime().toLocalDate()).collect(Collectors.toList());
                int weekDay = today.getDayOfWeek().getValue();
                LocalDate timeTemp3 = LocalDate.from(today);
                for (int i = 0; i < day; ++i) {
                    int n = weekDay = weekDay > 7 ? 1 : weekDay;
                    if (!workDayList.contains(timeTemp3) && (weekDay == 6 || weekDay == 7 || holidayList.contains(timeTemp3))) {
                        --i;
                    }
                    timeTemp3 = timeTemp3.plusDays(1L);
                    ++weekDay;
                }
                if ((recycleTime = recycleTime != null ? (timeTemp3.isBefore(recycleTime) ? timeTemp3 : recycleTime) : timeTemp3) != null) {
                    if (timeTemp3.isBefore(recycleTime)) {
                        recycleTime = timeTemp3;
                        reasonDay = typeDayMap.get("3");
                    }
                } else {
                    recycleTime = timeTemp3;
                    reasonDay = typeDayMap.get("3");
                }
            }
            recycleReasonDate.setDate(recycleTime);
            recycleReasonDate.setDay(reasonDay);
            recycleTimeMap.put(listEntry.getKey(), recycleReasonDate);
        }
        return recycleTimeMap;
    }
}

