/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.trackrecord.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.agent.api.vo.AgentApiVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.dto.SalesReportDto;
import com.jxdinfo.crm.common.api.trackrecord.dto.TrackRecordAPIDto;
import com.jxdinfo.crm.common.api.trackrecord.dto.TrackRecordQueryDateDto;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.service.ITrackRecordAPIService;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordCusVo;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordLeadVo;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordOppVo;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordViewAPIVo;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.trackrecord.dao.TrackRecordMapper;
import com.jxdinfo.crm.common.trackrecord.dto.TrackRecordDto;
import com.jxdinfo.crm.common.trackrecord.model.SearchCondition;
import com.jxdinfo.crm.common.trackrecord.model.SearchView;
import com.jxdinfo.crm.common.trackrecord.model.TrackRecord;
import com.jxdinfo.crm.common.trackrecord.model.TrackRecordRelation;
import com.jxdinfo.crm.common.trackrecord.model.TrackRecordVisitors;
import com.jxdinfo.crm.common.trackrecord.service.TrackRecordRelationService;
import com.jxdinfo.crm.common.trackrecord.service.TrackRecordService;
import com.jxdinfo.crm.common.trackrecord.service.TrackRecordVisitorsService;
import com.jxdinfo.crm.common.trackrecord.vo.TrackRecordVo;
import com.jxdinfo.crm.core.api.competitor.service.ICompetitorAPIService;
import com.jxdinfo.crm.core.api.competitor.vo.CompetitorAPIVo;
import com.jxdinfo.crm.core.api.contact.service.IContactAPIService;
import com.jxdinfo.crm.core.api.contact.vo.ContactAPIVo;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.customer.vo.CustomerAPIVo;
import com.jxdinfo.crm.core.api.fileinfo.dto.FileInfoAPIDto;
import com.jxdinfo.crm.core.api.fileinfo.service.IFileInfoAPIService;
import com.jxdinfo.crm.core.api.leads.service.ILeadsAPIService;
import com.jxdinfo.crm.core.api.leads.vo.LeadsAPIVo;
import com.jxdinfo.crm.core.api.marketingactivity.service.IMarketingActivityAPIService;
import com.jxdinfo.crm.core.api.marketingactivity.vo.MarketingActivityAPIVo;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.NewAdditionCountVo;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.general.dict.vo.DicVo;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TrackRecordAPIServiceImpl
implements ITrackRecordAPIService {
    @Resource
    private TrackRecordMapper trackRecordMapper;
    @Resource
    private TrackRecordService trackRecordService;
    @Resource
    private IFileInfoAPIService fileInfoAPIService;
    @Resource
    private ILeadsAPIService leadsAPIService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private IContactAPIService contactAPIService;
    @Resource
    private TrackRecordRelationService recordRelationService;
    @Resource
    private IMarketingActivityAPIService marketingActivityAPIService;
    @Resource
    private TrackRecordVisitorsService trackRecordVisitorsService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ICompetitorAPIService competitorAPIService;
    @Resource
    private IAgentApiService agentAPIService;
    @Resource
    private ISysUsersService userService;

    public List<TrackRecordAPIVo> selectFirstRecordByCustomer(List<Long> customerIdList, LocalDateTime createTimeStart, LocalDateTime createTimeEnd) {
        if (CollectionUtil.isEmpty(customerIdList)) {
            return null;
        }
        List<TrackRecord> list = this.trackRecordMapper.selectTrackRecordByCustomer(customerIdList, createTimeStart, createTimeEnd);
        HashMap<Long, TrackRecord> map = new HashMap<Long, TrackRecord>();
        for (TrackRecord entity : list) {
            map.putIfAbsent(entity.getTypeId(), entity);
        }
        return BeanUtil.copy((Collection)CollectionUtil.toList(map.values()), TrackRecordAPIVo.class);
    }

    public Page selectTrackRecordList(TrackRecordAPIDto dto) {
        String popUpSign;
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeList())) {
            for (TrackRecordQueryDateDto dateDto : dto.getCreateTimeList()) {
                dateDto.setTimeRange("6");
            }
        }
        if (HussarUtils.isNotEmpty((Object)(popUpSign = dto.getPopUpSign()))) {
            switch (popUpSign) {
                case "1": {
                    Page pageCus = this.pageHandlingBehavior(dto);
                    pageCus.setRecords(this.trackRecordMapper.getFollowUpCusPopUp(dto, (Page<TrackRecordCusVo>)pageCus));
                    return pageCus;
                }
                case "2": {
                    Page pageOpp = this.pageHandlingBehavior(dto);
                    pageOpp.setRecords(this.trackRecordMapper.getFollowUpOppPopUp(dto, (Page<TrackRecordOppVo>)pageOpp));
                    return pageOpp;
                }
                case "4": {
                    Page pageLead = this.pageHandlingBehavior(dto);
                    pageLead.setRecords(this.trackRecordMapper.getFollowUpLeadPopUp(dto, (Page<TrackRecordLeadVo>)pageLead));
                    return pageLead;
                }
            }
            return new Page();
        }
        return new Page();
    }

    private Page pageHandlingBehavior(TrackRecordAPIDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        return page;
    }

    public List<Long> selectRelationRecordIds(Long typeId) {
        return this.trackRecordMapper.selectRelationRecordIds(typeId);
    }

    public void deleteBatchByIds(List<String> contactIds, String id, String delFlag) {
        this.trackRecordMapper.deleteBatchByIds(contactIds, id, delFlag);
    }

    public List<TrackRecordViewAPIVo> getTrackRecordDetailsBatch(List<Long> idList, String id) {
        return BeanUtil.copy(this.trackRecordMapper.getTrackRecordDetailsBatch(idList, id), TrackRecordViewAPIVo.class);
    }

    public TrackRecordAPIVo selectTrackRecordContentByTypeId(Long id) {
        TrackRecord trackRecord = null;
        List<TrackRecord> trackRecordList = this.trackRecordMapper.selectTrackRecordContentByTypeId(id);
        if (HussarUtils.isNotEmpty(trackRecordList) && trackRecordList.size() > 0) {
            trackRecord = trackRecordList.get(0);
        }
        return (TrackRecordAPIVo)BeanUtil.copy(trackRecord, TrackRecordAPIVo.class);
    }

    public List<TrackRecordAPIVo> queryTrackRecordList(Long typeId) {
        return BeanUtil.copy(this.trackRecordMapper.queryList(typeId), TrackRecordAPIVo.class);
    }

    public List<TrackRecordViewAPIVo> getLatestTrackRecordDetailsByTypeIdBatch(List<Long> typeIdList) {
        ArrayList resultList = new ArrayList();
        List<TrackRecordVo> trackRecordVoList = this.trackRecordMapper.getLastTrackRecordDetails(typeIdList);
        return BeanUtil.copy(trackRecordVoList, TrackRecordViewAPIVo.class);
    }

    public Page<TrackRecordViewAPIVo> followUpList(TrackRecordAPIDto recordAPIDto) {
        TrackRecordDto recordDto = (TrackRecordDto)((Object)BeanUtil.copy((Object)recordAPIDto, TrackRecordDto.class));
        assert (recordDto != null);
        Page page = recordDto.getPage();
        if ("9".equals(recordDto.getRecordBusinessType())) {
            recordDto.setRecordBusinessType(null);
            recordDto.setProduceType("1");
        }
        List<TrackRecordVo> list = this.trackRecordMapper.followUpList((Page<TrackRecordVo>)page, recordDto);
        List positionDic = new ArrayList();
        if (!list.isEmpty()) {
            positionDic = this.sysDicRefService.getDicListByType("cust_position");
        }
        HashMap<String, String> nameMap = new HashMap<String, String>();
        for (TrackRecordVo listTemp : list) {
            MarketingActivityAPIVo marketingActivityEntity;
            List ledas;
            if (listTemp.getBusinessType().equals("1")) {
                CustomerAPIVo customer;
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType() + listTemp.getTypeId())) && HussarUtils.isNotEmpty((Object)(customer = this.customerAPIService.selectOne(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType() + listTemp.getTypeId(), customer.getCustomerName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("1" + listTemp.getTypeId())) ? (String)nameMap.get("1" + listTemp.getTypeId()) : listTemp.getBusinessName());
                if ("5".equals(listTemp.getRecordType())) {
                    List visitors = this.trackRecordVisitorsService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrackRecordVisitors::getRecordId, (Object)listTemp.getRecordId())).orderByAsc(TrackRecordVisitors::getShowOrder));
                    StringBuilder visitorNames = new StringBuilder();
                    if (HussarUtils.isNotEmpty((Object)visitors)) {
                        listTemp.setVisitors(visitors);
                        for (TrackRecordVisitors visitor : visitors) {
                            String positionName = "";
                            if (positionDic != null) {
                                for (DicVo dicVo : positionDic) {
                                    if (!dicVo.getValue().equals(visitor.getPositionId())) continue;
                                    positionName = dicVo.getLabel();
                                    visitor.setPositonName(positionName);
                                    break;
                                }
                            }
                            if (StringUtil.isNotBlank((CharSequence)positionName)) {
                                visitorNames.append("\uff0c").append(visitor.getName()).append("\uff08").append(positionName).append("\uff09");
                                continue;
                            }
                            visitorNames.append("\uff0c").append(visitor.getName());
                        }
                        if (visitorNames.length() > 0) {
                            visitorNames = new StringBuilder(visitorNames.substring(1));
                        }
                        listTemp.setVisitorNames(visitorNames.toString());
                    }
                }
            }
            if (listTemp.getBusinessType().equals("2")) {
                OpportunityAPIVo opportunity;
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType() + listTemp.getTypeId())) && HussarUtils.isNotEmpty((Object)(opportunity = this.opportunityAPIService.selectOneOverride(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType() + listTemp.getTypeId(), opportunity.getOpportunityName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("2" + listTemp.getTypeId())) ? (String)nameMap.get("2" + listTemp.getTypeId()) : listTemp.getBusinessName());
            }
            if (listTemp.getBusinessType().equals("3")) {
                ContactAPIVo contact;
                if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType() + listTemp.getTypeId())) && HussarUtils.isNotEmpty((Object)(contact = this.contactAPIService.selectOne(listTemp.getTypeId())))) {
                    nameMap.put(listTemp.getBusinessType() + listTemp.getTypeId(), contact.getContactName());
                }
                listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get("3" + listTemp.getTypeId())) ? (String)nameMap.get("3" + listTemp.getTypeId()) : listTemp.getBusinessName());
            }
            if (listTemp.getBusinessType().equals("4") && (ledas = this.leadsAPIService.selectList(listTemp.getTypeId())).size() > 0) {
                listTemp.setBusinessName(((LeadsAPIVo)ledas.get(0)).getLeadsName());
            }
            if (!listTemp.getBusinessType().equals(CrmBusinessTypeEnum.CAMPAIGN.getId())) continue;
            if (HussarUtils.isEmpty(nameMap.get(listTemp.getBusinessType() + listTemp.getTypeId())) && HussarUtils.isNotEmpty((Object)(marketingActivityEntity = this.marketingActivityAPIService.selectOne(listTemp.getTypeId(), listTemp.getDelflag())))) {
                nameMap.put(listTemp.getBusinessType() + listTemp.getTypeId(), marketingActivityEntity.getCampaignName());
            }
            listTemp.setBusinessName(HussarUtils.isNotEmpty(nameMap.get(CrmBusinessTypeEnum.CAMPAIGN.getId() + listTemp.getTypeId())) ? (String)nameMap.get(CrmBusinessTypeEnum.CAMPAIGN.getId() + listTemp.getTypeId()) : listTemp.getBusinessName());
        }
        page.setRecords(list);
        Page page1 = new Page();
        page1.setRecords(BeanUtil.copy((Collection)page.getRecords(), TrackRecordViewAPIVo.class));
        page1.setSize(page.getSize());
        page1.setCurrent(page.getCurrent());
        page1.setTotal(page.getTotal());
        page1.setOrders(page.orders());
        return page1;
    }

    @Transactional
    public Boolean saveTrackRecord(TrackRecordAPIVo trackRecord, CrmBusinessTypeEnum businessTypeEnum, Long typeId, String businessName, LocalDateTime date, boolean trackTime, List<Long> businessIds) {
        if (trackRecord == null) {
            trackRecord = new TrackRecordAPIVo();
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        trackRecord.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        trackRecord.setBusinessType(businessTypeEnum.getId());
        trackRecord.setTypeId(typeId);
        trackRecord.setBusinessName(businessName);
        trackRecord.setCreatePerson(user.getUserId());
        trackRecord.setCreatePersonName(user.getUserName());
        trackRecord.setCreateTime(date);
        trackRecord.setDepartmentId(user.getDeptId());
        trackRecord.setDepartmentName(user.getDeptName());
        trackRecord.setDelflag("0");
        if (trackRecord.getProduceType() == null) {
            trackRecord.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        }
        this.trackRecordService.saveOrUpdate(BeanUtil.copy((Object)trackRecord, TrackRecord.class));
        this.recordRelationService.saveBatch(this.saveTrackRecordRelation(trackRecord.getRecordId(), businessIds));
        return true;
    }

    @Transactional
    public Boolean update(TrackRecordViewAPIVo trackRecord) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (trackRecord.getFileId() != null) {
            FileInfoAPIDto fileInfoDto = new FileInfoAPIDto();
            fileInfoDto.setBusinessId(String.valueOf(trackRecord.getRecordId()));
            fileInfoDto.setIds(trackRecord.getFileId());
            this.fileInfoAPIService.insertFileInfo(fileInfoDto);
        }
        LocalDateTime date = LocalDateTime.now();
        TrackRecord recordEntity = (TrackRecord)BeanUtil.copy((Object)trackRecord, TrackRecord.class);
        this.trackRecordService.saveOrUpdate(recordEntity);
        if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(trackRecord.getBusinessType())) {
            OpportunityAPIVo opportunity = this.opportunityAPIService.getById(trackRecord.getTypeId());
            opportunity.setChangeTime(date);
            opportunity.setChangePerson(user.getUserId());
            opportunity.setChangePersonName(user.getUserName());
            String endTime = trackRecord.getEndTime();
            String opportunityAmount = trackRecord.getOpportunityAmount();
            if (HussarUtils.isNotEmpty((Object)endTime)) {
                opportunity.setEndTime(endTime);
            }
            if (HussarUtils.isNotEmpty((Object)opportunityAmount)) {
                opportunity.setOpportunityAmount(opportunityAmount);
            }
            this.opportunityAPIService.updateById(opportunity);
        }
        assert (recordEntity != null);
        if (CrmBusinessTypeEnum.CUSTOMER.getId().equals(recordEntity.getBusinessType())) {
            this.recordRelationService.remove((Wrapper)new LambdaQueryWrapper().eq(TrackRecordRelation::getRecordId, (Object)recordEntity.getRecordId()));
            ArrayList<Long> businessIds = new ArrayList<Long>();
            businessIds.add(trackRecord.getTypeId());
            if (CollectionUtil.isNotEmpty((Object)trackRecord.getContactId())) {
                List customerIds = Arrays.stream(trackRecord.getContactId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                businessIds.addAll(customerIds);
            }
            if (CollectionUtil.isNotEmpty((Object)trackRecord.getOpportunityId())) {
                List opportunityIds = Arrays.stream(trackRecord.getOpportunityId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                businessIds.addAll(opportunityIds);
            }
            this.recordRelationService.saveBatch(this.saveTrackRecordRelation(trackRecord.getRecordId(), businessIds));
            if ("5".equals(recordEntity.getRecordType())) {
                this.trackRecordVisitorsService.remove((Wrapper)new LambdaQueryWrapper().eq(TrackRecordVisitors::getRecordId, (Object)recordEntity.getRecordId()));
                if (CollectionUtil.isNotEmpty((Collection)trackRecord.getVisitors())) {
                    List visitors = BeanUtil.copy((Collection)trackRecord.getVisitors(), TrackRecordVisitors.class);
                    this.getTrackRecordVisitors(trackRecord.getRecordId(), visitors);
                    if (trackRecord.getVisitors().size() > 0) {
                        this.trackRecordVisitorsService.saveBatch(visitors);
                    }
                }
            }
        }
        String isUpdate = "1";
        this.updateNextTime(trackRecord.getBusinessType(), trackRecord.getTypeId(), trackRecord.getNextTime(), date, isUpdate);
        return true;
    }

    public int queryAnaly(Map<String, Object> map) {
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)map.get("searchView")));
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)map.get("searchConditionList")));
        SearchView searchView = (SearchView)JSON.toJavaObject((JSON)jsonObject, SearchView.class);
        List searchConditionList = jsonArray.toJavaList(SearchCondition.class);
        String searchId = CommonUtills.generateAssignId();
        searchView.setSearchId(Long.valueOf(searchId));
        int i = this.trackRecordMapper.addSearchView(searchView);
        for (SearchCondition searchCondition : searchConditionList) {
            String conditionId = CommonUtills.generateAssignId();
            searchCondition.setConditionId(Long.valueOf(conditionId));
            searchCondition.setSearchId(Long.valueOf(searchId));
            int n = this.trackRecordMapper.addSearchCondition(searchCondition);
        }
        if (i > 0) {
            return 1;
        }
        return 0;
    }

    public String queryAnalize(Long searchId) {
        SecurityUser user = BaseSecurityUtil.getUser();
        String userId = user.getId().toString();
        SearchView searchView = new SearchView();
        searchView = this.trackRecordMapper.queryView(searchId);
        List<SearchCondition> searchConditionList = this.trackRecordMapper.queryConditionList(searchId);
        String sql = "";
        if (searchView == null) {
            return sql;
        }
        if ("0".equals(searchView.getSearchType())) {
            return sql;
        }
        for (int i = searchConditionList.size(); i > 0; --i) {
            String temp = searchConditionList.get(i - 1).getConditionField() + searchConditionList.get(i - 1).getConditionQuery() + "'";
            temp = "userId".equals(searchConditionList.get(i - 1).getConditionContent()) ? temp + userId + "'" : temp + searchConditionList.get(i - 1).getConditionContent() + "'";
            sql = i > 1 ? sql + temp + " AND " : sql + temp;
        }
        return sql;
    }

    public List<TrackRecordAPIVo> list(List<String> typeIds, List<String> businessTypes, List<String> produceTypes, String delFlagNo) {
        List trackRecordList = this.trackRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrackRecord::getTypeId, typeIds)).in(ToolUtil.isNotEmpty(businessTypes), TrackRecord::getBusinessType, businessTypes)).in(ToolUtil.isNotEmpty(produceTypes), TrackRecord::getProduceType, produceTypes)).eq(TrackRecord::getDelflag, (Object)"0"));
        return BeanUtil.copy((Collection)trackRecordList, TrackRecordAPIVo.class);
    }

    public List<TrackRecordAPIVo> listOrderByDesc(Long typeId) {
        List trackRecordList = this.trackRecordService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TrackRecord::getDelflag, (Object)"0")).eq(TrackRecord::getProduceType, (Object)"1")).eq(TrackRecord::getTypeId, (Object)typeId)).orderByDesc(TrackRecord::getCreateTime)).last("limit 1"));
        return BeanUtil.copy((Collection)trackRecordList, TrackRecordAPIVo.class);
    }

    public Long countContact(List<String> contactIds, String delFlagNo) {
        return this.trackRecordService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrackRecord::getContactId, contactIds)).eq(TrackRecord::getDelflag, (Object)delFlagNo));
    }

    public Long countConvertCustomer(List<String> convertCustomerIds, String delFlagNo) {
        return this.trackRecordService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrackRecord::getConvertCustomerId, convertCustomerIds)).eq(TrackRecord::getDelflag, (Object)delFlagNo));
    }

    public Long countConvertContact(List<String> convertContactIds, String delFlagNo) {
        return this.trackRecordService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(TrackRecord::getConvertContactId, convertContactIds)).eq(TrackRecord::getDelflag, (Object)delFlagNo));
    }

    public void updateTrackRecord(LocalDateTime lastTime, String content, Long taskId, String delFlagNo, String taskStateDoing) {
        this.trackRecordService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(TrackRecord::getTaskLastTime, (Object)lastTime)).set(TrackRecord::getTaskContent, (Object)content)).eq(TrackRecord::getTypeId, (Object)taskId)).eq(TrackRecord::getDelflag, (Object)delFlagNo)).eq(TrackRecord::getState, (Object)taskStateDoing));
    }

    public TrackRecordAPIVo getById(Long businessId) {
        return (TrackRecordAPIVo)BeanUtil.copy((Object)this.trackRecordService.getById(businessId), TrackRecordAPIVo.class);
    }

    private List<TrackRecordRelation> saveTrackRecordRelation(Long recordId, List<Long> businessIds) {
        ArrayList<TrackRecordRelation> relationList = new ArrayList<TrackRecordRelation>();
        if (CollectionUtil.isNotEmpty(businessIds)) {
            for (Long businessId : businessIds) {
                if (businessId == null) continue;
                TrackRecordRelation recordRelation = new TrackRecordRelation();
                recordRelation.setRecordId(recordId);
                recordRelation.setTypeId(businessId);
                relationList.add(recordRelation);
            }
        }
        return relationList;
    }

    private void getTrackRecordVisitors(Long recordId, List<TrackRecordVisitors> visitors) {
        if (CollectionUtil.isNotEmpty(visitors)) {
            for (int i = 0; i < visitors.size(); ++i) {
                if (StringUtil.isEmpty((Object)visitors.get(i).getName())) {
                    visitors.remove(visitors.get(i));
                    continue;
                }
                visitors.get(i).setRecordId(recordId);
                visitors.get(i).setShowOrder(i + 1);
            }
        }
    }

    @Transactional
    public void updateNextTime(String businessType, Long typeId, LocalDateTime nextTime, LocalDateTime date, String isUpdate) {
        SecurityUser user = BaseSecurityUtil.getUser();
        if (CrmBusinessTypeEnum.CUSTOMER.getId().equals(businessType)) {
            CustomerAPIVo customerEntity = new CustomerAPIVo();
            customerEntity.setCustomerId(typeId);
            if (nextTime != null) {
                customerEntity.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                customerEntity.setTrackTime(date);
                customerEntity.setChangeTime(date);
                customerEntity.setChangePerson(user.getUserId());
                customerEntity.setChangePersonName(user.getUserName());
                this.customerAPIService.updateById(customerEntity);
            }
        } else if (CrmBusinessTypeEnum.AGENT.getId().equals(businessType)) {
            AgentApiVo agentEntity = new AgentApiVo();
            agentEntity.setAgentId(typeId);
            if (nextTime != null) {
                agentEntity.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                agentEntity.setTrackTime(date);
                agentEntity.setChangeTime(date);
                agentEntity.setChangePerson(user.getUserId());
                agentEntity.setChangePersonName(user.getUserName());
                this.agentAPIService.updateById(agentEntity);
            }
        } else if (CrmBusinessTypeEnum.OPPORTUNITY.getId().equals(businessType)) {
            CustomerAPIVo customerEntity = new CustomerAPIVo();
            OpportunityAPIVo opportunityEntity = new OpportunityAPIVo();
            opportunityEntity.setOpportunityId(typeId);
            if (nextTime != null) {
                opportunityEntity.setNextTime(nextTime);
                customerEntity.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                opportunityEntity.setTrackTime(date);
                opportunityEntity.setTrackPerson(user.getUserId());
                opportunityEntity.setTrackPersonName(user.getUserName());
                opportunityEntity.setChangeTime(date);
                opportunityEntity.setChangePerson(user.getUserId());
                opportunityEntity.setChangePersonName(user.getUserName());
                this.opportunityAPIService.updateById(opportunityEntity);
                opportunityEntity = this.opportunityAPIService.getById(typeId);
                customerEntity.setCustomerId(opportunityEntity.getCustomerId());
                customerEntity.setTrackTime(date);
                customerEntity.setChangeTime(date);
                customerEntity.setChangePerson(user.getUserId());
                customerEntity.setChangePersonName(user.getUserName());
                this.customerAPIService.updateById(customerEntity);
            }
        } else if (CrmBusinessTypeEnum.CONTACT.getId().equals(businessType)) {
            CustomerAPIVo customerEntity = new CustomerAPIVo();
            ContactAPIVo contactEntity = new ContactAPIVo();
            contactEntity.setContactId(typeId);
            if (nextTime != null) {
                contactEntity.setNextTime(nextTime);
                customerEntity.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                contactEntity.setTrackTime(date);
                contactEntity.setChangeTime(date);
                contactEntity.setChangePerson(user.getUserId());
                contactEntity.setChangePersonName(user.getUserName());
                this.contactAPIService.updateById(contactEntity);
                contactEntity = this.contactAPIService.getById(typeId);
                customerEntity.setCustomerId(contactEntity.getCustomerId());
                customerEntity.setTrackTime(date);
                customerEntity.setChangeTime(date);
                customerEntity.setChangePerson(user.getUserId());
                customerEntity.setChangePersonName(user.getUserName());
                this.customerAPIService.updateById(customerEntity);
            }
        } else if (CrmBusinessTypeEnum.LEADS.getId().equals(businessType)) {
            LeadsAPIVo lead = new LeadsAPIVo();
            lead.setLeadsId(typeId);
            if (nextTime != null) {
                lead.setNextTime(nextTime);
            }
            if (isUpdate == null) {
                lead.setTrackTime(date);
                this.leadsAPIService.updateById(lead);
            }
        } else if (CrmBusinessTypeEnum.CAMPAIGN.getId().equals(businessType)) {
            MarketingActivityAPIVo marketingActivity = new MarketingActivityAPIVo();
            marketingActivity.setCampaignId(typeId);
            if (marketingActivity == null) {
                marketingActivity.setTrackTime(date);
                this.marketingActivityAPIService.updateById(marketingActivity);
            }
        } else if (CrmBusinessTypeEnum.COMPETITOR.getId().equals(businessType)) {
            CompetitorAPIVo competitor = new CompetitorAPIVo();
            competitor.setCompetitorId(typeId);
            if (competitor == null) {
                competitor.setTrackTime(date);
                this.competitorAPIService.updateById(competitor);
            }
        }
    }

    public String selectTodayTrackRecordByUserId(SalesReportDto dto) {
        StringBuffer content = new StringBuffer("");
        Long userId = dto.getUserId();
        DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)"0");
        if (ToolUtil.isNotEmpty((Object)dateConvertVo)) {
            dto.setStartTime(dateConvertVo.getStartDate());
            dto.setEndTime(dateConvertVo.getEndDate());
        }
        NewAdditionCountVo newAdditionCountVo = this.opportunityAPIService.getSaleCountToday(dto.getUserId(), dto.getStartTime(), dto.getEndTime());
        List<TrackRecordAPIVo> opportunityTrack = this.trackRecordMapper.opportunityTrack(dto);
        List<TrackRecordAPIVo> customerTrack = this.trackRecordMapper.customerTrack(dto);
        content.append("1\uff09\u5546\u673a\u7b80\u62a5\n").append("   \u4eca\u65e5\u65b0\u589e").append(newAdditionCountVo.getAddOpportunity()).append("\u4e2a\u5546\u673a\uff0c\u8d62\u5355").append(newAdditionCountVo.getWinOpportunity()).append("\u4e2a\uff0c\u8ddf\u8fdb").append(opportunityTrack.size()).append("\u6b21\u3002\n");
        content.append("2\uff09\u5ba2\u6237\u53ca\u8054\u7cfb\u4eba\u7b80\u62a5\n").append("   \u4eca\u65e5\u65b0\u589e").append(newAdditionCountVo.getAddCustomer()).append("\u4e2a\u5ba2\u6237\uff0c").append(newAdditionCountVo.getAddContact()).append("\u4e2a\u8054\u7cfb\u4eba\uff0c\u8ddf\u8fdb\u6b21\u6570\u4e3a").append(customerTrack.size()).append("\u6b21\u3002\n");
        content.append("3\uff09\u4eca\u65e5\u8ddf\u8fdb\u60c5\u51b5\n");
        if (opportunityTrack.size() == 0 && customerTrack.size() == 0) {
            content.append("  \u6682\u65e0\u8ddf\u8fdb\n");
        } else {
            int j;
            int i = 0;
            if (opportunityTrack.size() > 0) {
                Map<Long, List<TrackRecordAPIVo>> opportunityMap = opportunityTrack.stream().collect(Collectors.groupingBy(TrackRecordAPIVo::getTypeId));
                for (Map.Entry<Long, List<TrackRecordAPIVo>> key : opportunityMap.entrySet()) {
                    content.append("  \uff08").append(++i).append("\uff09").append(key.getValue().get(0).getBusinessName()).append("\u3010").append(key.getValue().get(0).getStageName()).append("\u3011\uff0c").append("\u91d1\u989d").append(key.getValue().get(0).getOpportunityAmount()).append("\u4e07").append("\uff0c\u8ddf\u8fdb").append(key.getValue().size()).append("\u6b21\uff1a\n");
                    for (j = 0; j < key.getValue().size(); ++j) {
                        content.append("     ").append(key.getValue().get(j).getRecordType()).append("\uff1a").append(key.getValue().get(j).getRecordContent()).append("\n");
                        if (!StringUtil.isNotEmpty((Object)key.getValue().get(j).getNextTime())) continue;
                        content.append("     \u4e0b\u6b21\u8054\u7cfb\u65f6\u95f4\uff1a").append(key.getValue().get(j).getNextTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).append("\u3002\n");
                    }
                }
            }
            if (customerTrack.size() > 0) {
                Map<Long, List<TrackRecordAPIVo>> customerMap = customerTrack.stream().collect(Collectors.groupingBy(TrackRecordAPIVo::getTypeId));
                for (Map.Entry<Long, List<TrackRecordAPIVo>> key : customerMap.entrySet()) {
                    content.append("  \uff08").append(++i).append("\uff09").append(key.getValue().get(0).getBusinessName()).append("\uff0c\u8ddf\u8fdb").append(key.getValue().size()).append("\u6b21\uff1a\n");
                    for (j = 0; j < key.getValue().size(); ++j) {
                        content.append("     ").append(key.getValue().get(j).getRecordType()).append("\uff1a").append(key.getValue().get(j).getRecordContent()).append("\n");
                        if (!StringUtil.isNotEmpty((Object)key.getValue().get(j).getNextTime())) continue;
                        content.append("     \u4e0b\u6b21\u8054\u7cfb\u65f6\u95f4\uff1a").append(key.getValue().get(j).getNextTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"))).append("\u3002\n");
                    }
                }
            }
        }
        System.out.println(content);
        return content.toString();
    }

    public long countTrackRecordByTypeIds(List<Long> typeIds) {
        return this.trackRecordService.countTrackRecordByTypeIds(typeIds);
    }

    public boolean mergeTrackRecord(List<Long> oldBusinessIdList, Long newBusinessId) {
        return this.trackRecordService.mergeTrackRecord(oldBusinessIdList, newBusinessId);
    }
}

