/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.operaterecord.external.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.operaterecord.dao.OperateRecordMapper;
import com.jxdinfo.crm.common.operaterecord.model.OperateRecordDO;
import com.jxdinfo.crm.common.operaterecord.service.OperateRecordService;
import com.jxdinfo.crm.common.operaterecord.vo.OperateRecordVo;
import com.jxdinfo.crm.common.trackrecord.service.TrackRecordRelationService;
import com.jxdinfo.hussar.code.plus.dto.CodePlusDto;
import com.jxdinfo.hussar.code.plus.service.ISysCodeRuleRefService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OperateRecordAPIServiceImpl
implements IOperateRecordAPIService {
    @Resource
    private OperateRecordMapper operateRecordMapper;
    @Resource
    private OperateRecordService operateRecordService;
    @Resource
    private TrackRecordRelationService recordRelationService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ISysCodeRuleRefService sysCodeRuleRefService;

    @Transactional
    public Boolean saveOperateLogBatch(List<OperateRecordAPIVo> operateRecordAPIVoList) {
        this.operateRecordService.saveBatch(BeanUtil.copy(operateRecordAPIVoList, OperateRecordDO.class));
        return true;
    }

    @Transactional
    public Boolean saveOperateLog(OperateRecordAPIVo operateRecordAPIVo, CrmBusinessTypeEnum businessTypeEnum, Long typeId, String businessName, LocalDateTime date, boolean trackTime, List<Long> businessIds) {
        if (operateRecordAPIVo == null) {
            operateRecordAPIVo = new OperateRecordAPIVo();
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (operateRecordAPIVo.getOrderNumber() == null) {
            CodePlusDto codePlusDto = new CodePlusDto();
            codePlusDto.setRuleCode("OPERATE_RECORD_ORDER_NUMBER");
            Integer currentCode = Integer.valueOf(this.sysCodeRuleRefService.getCurrentCodeByCache(codePlusDto));
            operateRecordAPIVo.setOrderNumber(currentCode);
        }
        operateRecordAPIVo.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        operateRecordAPIVo.setBusinessType(businessTypeEnum.getId());
        operateRecordAPIVo.setTypeId(typeId);
        operateRecordAPIVo.setBusinessName(businessName);
        operateRecordAPIVo.setCreatePerson(user.getUserId());
        operateRecordAPIVo.setCreatePersonName(user.getUserName());
        operateRecordAPIVo.setCreateTime(date);
        operateRecordAPIVo.setChangePerson(user.getUserId());
        operateRecordAPIVo.setChangeTime(date);
        operateRecordAPIVo.setChangePersonName(user.getUserName());
        operateRecordAPIVo.setDelflag("0");
        if (operateRecordAPIVo.getProduceType() == null) {
            operateRecordAPIVo.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        }
        this.operateRecordService.saveOrUpdate(BeanUtil.copy((Object)operateRecordAPIVo, OperateRecordDO.class));
        return true;
    }

    public Boolean saveOperateLog(OperateRecordAPIVo operateRecordAPIVo, CrmBusinessTypeEnum businessTypeEnum, Long typeId, String businessName, LocalDateTime date, boolean trackTime, List<Long> businessIds, SecurityUser user) {
        if (operateRecordAPIVo == null) {
            operateRecordAPIVo = new OperateRecordAPIVo();
        }
        operateRecordAPIVo.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        operateRecordAPIVo.setBusinessType(businessTypeEnum.getId());
        operateRecordAPIVo.setTypeId(typeId);
        operateRecordAPIVo.setBusinessName(businessName);
        operateRecordAPIVo.setCreatePerson(user.getUserId());
        operateRecordAPIVo.setCreatePersonName(user.getUserName());
        operateRecordAPIVo.setCreateTime(date);
        operateRecordAPIVo.setChangePerson(user.getUserId());
        operateRecordAPIVo.setChangeTime(date);
        operateRecordAPIVo.setChangePersonName(user.getUserName());
        operateRecordAPIVo.setDelflag("0");
        if (operateRecordAPIVo.getProduceType() == null) {
            operateRecordAPIVo.setProduceType(RecordProductTypeEnum.PRODUCE_AUTOMATIC.getId());
        }
        this.operateRecordService.saveOrUpdate(BeanUtil.copy((Object)operateRecordAPIVo, OperateRecordDO.class));
        return true;
    }

    public Boolean saveOperateLog(OperateRecordAPIVo operateRecordAPIVo, CrmBusinessTypeEnum businessTypeEnum, Long typeId, String businessName, String produceType, LocalDateTime date, Boolean systemUser, SecurityUser user) {
        operateRecordAPIVo.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
        operateRecordAPIVo.setTypeId(typeId);
        operateRecordAPIVo.setBusinessName(businessName);
        operateRecordAPIVo.setBusinessType(businessTypeEnum.getId());
        operateRecordAPIVo.setProduceType(produceType);
        if (systemUser.booleanValue()) {
            operateRecordAPIVo.setCreatePersonName("\u7cfb\u7edf");
            operateRecordAPIVo.setChangePersonName("\u7cfb\u7edf");
        } else {
            operateRecordAPIVo.setCreatePersonName(user.getUserName());
            operateRecordAPIVo.setChangePersonName(user.getUserName());
        }
        operateRecordAPIVo.setCreatePerson(user.getUserId());
        operateRecordAPIVo.setChangePerson(user.getUserId());
        operateRecordAPIVo.setCreateTime(date);
        operateRecordAPIVo.setChangeTime(date);
        operateRecordAPIVo.setDelflag("0");
        if (operateRecordAPIVo.getOrderNumber() == null) {
            CodePlusDto codePlusDto = new CodePlusDto();
            codePlusDto.setRuleCode("OPERATE_RECORD_ORDER_NUMBER");
            Integer currentCode = Integer.valueOf(this.sysCodeRuleRefService.getCurrentCodeByCache(codePlusDto));
            operateRecordAPIVo.setOrderNumber(currentCode);
        }
        this.operateRecordService.saveOrUpdate(BeanUtil.copy((Object)operateRecordAPIVo, OperateRecordDO.class));
        return true;
    }

    public void addInsertOperateLogList(List<OperateRecordAPIVo> insertOperateRecordAPIVoList, CrmBusinessTypeEnum businessTypeEnum, String productType, Long newPersonId, String newChargePersonName, Long oldPersonId, String oldChargePersonName, Long recordId, Long typeId, String businessName, LocalDateTime date) {
        OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
        operateRecordAPIVo.setContactId(newPersonId);
        operateRecordAPIVo.setContactName(newChargePersonName);
        operateRecordAPIVo.setOldContactName(oldChargePersonName);
        operateRecordAPIVo.setOldContactId(oldPersonId);
        operateRecordAPIVo.setDelflag("0");
        operateRecordAPIVo.setProduceType(productType);
        SecurityUser user = BaseSecurityUtil.getUser();
        operateRecordAPIVo.setRecordId(recordId);
        operateRecordAPIVo.setBusinessType(businessTypeEnum.getId());
        operateRecordAPIVo.setTypeId(typeId);
        operateRecordAPIVo.setBusinessName(businessName);
        operateRecordAPIVo.setCreatePerson(user.getUserId());
        operateRecordAPIVo.setCreatePersonName(user.getUserName());
        operateRecordAPIVo.setCreateTime(date);
        operateRecordAPIVo.setChangePerson(user.getUserId());
        operateRecordAPIVo.setChangeTime(date);
        operateRecordAPIVo.setChangePersonName(user.getUserName());
        insertOperateRecordAPIVoList.add(operateRecordAPIVo);
    }

    public List<OperateRecordAPIVo> list(List<String> productTypeList) {
        List<OperateRecordVo> operateRecordVoList = this.operateRecordService.list(productTypeList);
        if (CollectionUtil.isNotEmpty(operateRecordVoList)) {
            ArrayList<OperateRecordAPIVo> operateRecordAPIVoList = new ArrayList<OperateRecordAPIVo>();
            for (OperateRecordVo operateRecordVo : operateRecordVoList) {
                OperateRecordAPIVo operateRecordAPIVo = new OperateRecordAPIVo();
                BeanUtil.copyProperties((Object)operateRecordVo, (Object)operateRecordAPIVo);
                operateRecordAPIVoList.add(operateRecordAPIVo);
            }
            return operateRecordAPIVoList;
        }
        return null;
    }

    public List<OperateRecordAPIVo> getLastStageRecord(Long typeId) {
        return BeanUtil.copy(this.operateRecordService.getLastStageRecord(typeId), OperateRecordAPIVo.class);
    }
}

