/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.organUserComponent.service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.baseconfig.model.CrmBaseConfig;
import com.jxdinfo.crm.common.baseconfig.service.ICrmBaseConfigService;
import com.jxdinfo.crm.common.constant.OrganUserConstant;
import com.jxdinfo.crm.common.dataRightManage.Service.impl.UserRolePermissionIServiceImpl;
import com.jxdinfo.crm.common.organUserComponent.dao.OrganUserMapper;
import com.jxdinfo.crm.common.organUserComponent.service.IOrganUserService;
import com.jxdinfo.crm.common.organUserComponent.vo.SearchOrganUserVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.authorization.permit.vo.OrganUserTreeVo;
import com.jxdinfo.hussar.common.constant.Constants;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OrganUserServiceImpl
implements IOrganUserService {
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private OrganUserMapper organUserMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ICrmBaseConfigService configService;
    @Resource
    private UserRolePermissionIServiceImpl userRolePermissionsOrgan;
    @Resource
    private CrmCommonProperties crmCommonProperties;

    @Override
    public List<OrganUserTreeVo> lazyOrganUserTree(Long departmentId, Integer resultType) {
        List organUserTreeVoList = this.hussarBaseUserBoService.lazyOrganUserTree(Collections.singletonList(departmentId), Boolean.valueOf(false), OrganUserConstant.RESULT_TYPE_ORGAN);
        CrmBaseConfig config = this.configService.getCrmBaseConfigByKey("dimission_department_id");
        if (config != null && StringUtil.isNotEmpty((Object)config.getConfigValue())) {
            String dimission = config.getConfigValue();
            organUserTreeVoList = organUserTreeVoList.stream().filter(organUserTreeVo -> !dimission.equals(((Long)organUserTreeVo.getId()).toString()) && !dimission.equals(((Long)organUserTreeVo.getParentId()).toString())).collect(Collectors.toList());
        }
        if (OrganUserConstant.RESULT_TYPE_ORGAN_USER.equals(resultType)) {
            for (OrganUserTreeVo organUserTreeVo2 : organUserTreeVoList) {
                if (organUserTreeVo2.getUserCount() <= 0) continue;
                organUserTreeVo2.setHasChildren(Boolean.valueOf(true));
            }
            List<Object> userList = this.organUserMapper.getUserByStruIds(departmentId, null);
            if (CollectionUtil.isNotEmpty(userList)) {
                userList = userList.stream().distinct().collect(Collectors.toList());
                organUserTreeVoList.addAll(userList);
            }
        }
        return organUserTreeVoList;
    }

    @Override
    public List<OrganUserTreeVo> lazyOrganUserTreePermission(Long departmentId, Integer resultType) {
        ArrayList<Long> deptIdList;
        SecurityUser user = BaseSecurityUtil.getUser();
        int isCommonUser = this.userRolePermissionsOrgan.getCurrentRoleOrganIds(this.crmCommonProperties, user, deptIdList = new ArrayList<Long>());
        if (isCommonUser == 0 && CollectionUtil.isEmpty(deptIdList)) {
            return this.lazyOrganUserTree(departmentId, resultType);
        }
        List struList = (List)DefaultCacheUtil.get((Object)OrganUserConstant.STRU_KEY);
        HashSet<Long> departIdSet = new HashSet<Long>(deptIdList);
        Set<Long> returnDepartIdSet = this.getOrganByParentId(struList, departIdSet);
        returnDepartIdSet.addAll(departIdSet);
        List<OrganUserTreeVo> organUserTreeVoList = new ArrayList();
        if ("100001".equals(departmentId.toString())) {
            organUserTreeVoList = this.hussarBaseUserBoService.lazyOrganUserTree(deptIdList, Boolean.valueOf(true), OrganUserConstant.RESULT_TYPE_ORGAN);
        } else if (returnDepartIdSet.contains(departmentId) && isCommonUser == 0) {
            organUserTreeVoList = this.hussarBaseUserBoService.lazyOrganUserTree(Collections.singletonList(departmentId), Boolean.valueOf(false), OrganUserConstant.RESULT_TYPE_ORGAN);
        }
        if (OrganUserConstant.RESULT_TYPE_ORGAN_USER.equals(resultType)) {
            List<Object> userList;
            for (OrganUserTreeVo organUserTreeVo : organUserTreeVoList) {
                if (organUserTreeVo.getUserCount() <= 0) continue;
                organUserTreeVo.setHasChildren(Boolean.valueOf(true));
            }
            Long userId = null;
            if (isCommonUser == 1) {
                userId = user.getUserId();
            }
            if (CollectionUtil.isNotEmpty(userList = this.organUserMapper.getUserByStruIds(departmentId, userId))) {
                userList = userList.stream().distinct().collect(Collectors.toList());
                organUserTreeVoList.addAll(userList);
            }
        }
        return organUserTreeVoList;
    }

    @Override
    public List<SearchOrganUserVo> searchOrganAndUser(String keyword, String struFid, String types) {
        CrmBaseConfig config = this.configService.getCrmBaseConfigByKey("dimission_department_id");
        String dimissionStr = null;
        if (config != null) {
            dimissionStr = config.getConfigValue();
        }
        Long dimission = 0L;
        try {
            dimission = Long.parseLong(dimissionStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<SearchOrganUserVo> organUserVoList = new ArrayList<SearchOrganUserVo>();
        keyword = keyword.replaceAll("%", "/%").replaceAll("-", "/-");
        if (StringUtil.isEmpty((Object)types) || OrganUserConstant.TYPES_ORGAN.equals(types)) {
            List<SearchOrganUserVo> organList = this.organUserMapper.queryOrgan(keyword, struFid, dimission, null);
            organUserVoList.addAll(organList);
        }
        if (StringUtil.isEmpty((Object)types) || OrganUserConstant.TYPES_USER.equals(types)) {
            List<SearchOrganUserVo> userList = this.organUserMapper.queryUser(keyword, struFid, dimission, null, null);
            organUserVoList.addAll(userList);
        }
        return organUserVoList;
    }

    @Override
    public List<SearchOrganUserVo> searchOrganAndUserPermission(String keyword, String struFid, String types) {
        CrmBaseConfig config = this.configService.getCrmBaseConfigByKey("dimission_department_id");
        String dimissionStr = null;
        if (config != null) {
            dimissionStr = config.getConfigValue();
        }
        Long dimission = 0L;
        try {
            dimission = Long.parseLong(dimissionStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        ArrayList<Long> departIdList = new ArrayList<Long>();
        int isCommonUser = this.userRolePermissionsOrgan.getCurrentRoleOrganIds(this.crmCommonProperties, user, departIdList);
        ArrayList<SearchOrganUserVo> organUserVoList = new ArrayList<SearchOrganUserVo>();
        keyword = keyword.replaceAll("%", "/%").replaceAll("-", "/-");
        if (StringUtil.isEmpty((Object)types) || OrganUserConstant.TYPES_ORGAN.equals(types)) {
            List<SearchOrganUserVo> organList = this.organUserMapper.queryOrgan(keyword, struFid, dimission, departIdList);
            organUserVoList.addAll(organList);
        }
        if (StringUtil.isEmpty((Object)types) || OrganUserConstant.TYPES_USER.equals(types)) {
            List<Object> userList = new ArrayList();
            Long userId = null;
            if (isCommonUser == 1) {
                userId = user.getUserId();
            }
            userList = this.organUserMapper.queryUser(keyword, struFid, dimission, departIdList, userId);
            organUserVoList.addAll(userList);
        }
        return organUserVoList;
    }

    @Override
    public List<OrganUserTreeVo> getTreeById(Long id, String type) {
        List<OrganUserTreeVo> res;
        SysStru sysStru;
        Long pId;
        ArrayList<Long> pIdList = new ArrayList<Long>();
        if (OrganUserConstant.TYPES_USER.equals(type)) {
            SysUsers sysUsers = this.sysUsersService.getUser(id);
            pId = sysUsers.getDepartmentId();
        } else {
            sysStru = (SysStru)this.sysStruService.getById((Serializable)id);
            pId = sysStru.getParentId();
        }
        pIdList.add(pId);
        while (!ToolUtil.isEmpty((Object)(sysStru = (SysStru)this.sysStruService.getById((Serializable)pId))) && !Constants.ROOT_NODE_ID.equals(pId = sysStru.getParentId())) {
            pIdList.add(pId);
        }
        List<OrganUserTreeVo> currentTree = res = this.lazyOrganUserTree(Constants.ROOT_NODE_ID, OrganUserConstant.RESULT_TYPE_ORGAN_USER);
        block1: for (int i = pIdList.size() - 1; i >= 0; --i) {
            for (OrganUserTreeVo organUserTreeVo : currentTree) {
                if (!((Long)organUserTreeVo.getId()).equals(pIdList.get(i))) continue;
                List<OrganUserTreeVo> list = this.lazyOrganUserTree((Long)pIdList.get(i), OrganUserConstant.RESULT_TYPE_ORGAN_USER);
                organUserTreeVo.setChildren(list);
                currentTree = list;
                continue block1;
            }
        }
        return res;
    }

    @Override
    public Set<Long> getOrganByParentId(List<Map<String, Long>> struList, Set<Long> departIdSet) {
        HashSet<Long> returnDepartIdSet = new HashSet<Long>();
        if (CollectionUtil.isNotEmpty(struList)) {
            HashSet<Long> nextDepartIdSet = new HashSet<Long>();
            for (Map<String, Long> struMap : struList) {
                Long struId;
                if (!departIdSet.contains(struMap.get("parentId")) || departIdSet.contains(struId = struMap.get("struId")) || !returnDepartIdSet.add(struId)) continue;
                nextDepartIdSet.add(struId);
            }
            if (CollectionUtil.isNotEmpty(nextDepartIdSet)) {
                returnDepartIdSet.addAll(this.getOrganByParentId(struList, nextDepartIdSet));
            }
        }
        return returnDepartIdSet;
    }

    @Override
    public List<Long> getOrganByParentId(List<Long> departIdList) {
        List struList = (List)DefaultCacheUtil.get((Object)OrganUserConstant.STRU_KEY_COPY);
        HashSet<Long> departIdSet = new HashSet<Long>(departIdList);
        Set<Long> returnDepartIdSet = this.getOrganByParentId(struList, departIdSet);
        return new ArrayList<Long>(returnDepartIdSet);
    }

    @Override
    public List<Long> getOrganByParentIdContainsParent(List<Long> departIdList) {
        List struList = (List)DefaultCacheUtil.get((Object)OrganUserConstant.STRU_KEY_COPY);
        HashSet<Long> departIdSet = new HashSet<Long>(departIdList);
        Set<Long> returnDepartIdSet = this.getOrganByParentId(struList, departIdSet);
        ArrayList<Long> returnDepartIdList = new ArrayList<Long>();
        returnDepartIdList.addAll(departIdSet);
        returnDepartIdList.addAll(returnDepartIdSet);
        return returnDepartIdList;
    }

    @Override
    public Map<String, List<SearchOrganUserVo>> searchUserGroupByPY(String keyword, String struFid) {
        CrmBaseConfig config = this.configService.getCrmBaseConfigByKey(OrganUserConstant.DIMISSION_DEPARTMENT_ID);
        String dimissionStr = null;
        if (config != null) {
            dimissionStr = config.getConfigValue();
        }
        Long dimission = 0L;
        try {
            dimission = Long.parseLong(dimissionStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        keyword = keyword.replaceAll("%", "/%").replaceAll("-", "/-");
        List<SearchOrganUserVo> userList = this.organUserMapper.queryUser(keyword, struFid, dimission, null, null);
        List otherUserList = userList.stream().filter(searchOrganUserRoleVo -> searchOrganUserRoleVo.getPinyinInitial() == null).collect(Collectors.toList());
        Map<String, List<SearchOrganUserVo>> organUserVoListMap = userList.stream().filter(searchOrganUserRoleVo -> searchOrganUserRoleVo.getPinyinInitial() != null).collect(Collectors.groupingBy(user -> user.getPinyinInitial().substring(0, 1).toUpperCase()));
        LinkedHashMap<String, List<SearchOrganUserVo>> result = new LinkedHashMap<String, List<SearchOrganUserVo>>();
        organUserVoListMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(map -> {
            List cfr_ignored_0 = (List)result.put((String)map.getKey(), (List<SearchOrganUserVo>)map.getValue());
        });
        result.put("#", otherUserList);
        return result;
    }

    @Override
    public List<SearchOrganUserVo> searchOrganAndUserAndRole(String keyword, String struFid, List<String> types) {
        List<SearchOrganUserVo> userList;
        if (CollectionUtil.isEmpty(types)) {
            return null;
        }
        CrmBaseConfig config = this.configService.getCrmBaseConfigByKey(OrganUserConstant.DIMISSION_DEPARTMENT_ID);
        String dimissionStr = null;
        if (config != null) {
            dimissionStr = config.getConfigValue();
        }
        Long dimission = 0L;
        try {
            dimission = Long.parseLong(dimissionStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<SearchOrganUserVo> organUserVoList = new ArrayList<SearchOrganUserVo>();
        keyword = keyword.replaceAll("%", "/%").replaceAll("-", "/-");
        if (types.contains(OrganUserConstant.TYPE_ORGAN)) {
            List<SearchOrganUserVo> organList = this.organUserMapper.queryOrgan(keyword, struFid, dimission, null);
            organUserVoList.addAll(organList);
        }
        if (types.contains(OrganUserConstant.TYPE_USER)) {
            userList = this.organUserMapper.queryUser(keyword, struFid, dimission, null, null);
            organUserVoList.addAll(userList);
        }
        if (types.contains(OrganUserConstant.TYPE_ROLE)) {
            userList = this.organUserMapper.queryRole(keyword);
            organUserVoList.addAll(userList);
        }
        return organUserVoList;
    }
}

