/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.organUserComponent.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.common.baseconfig.model.CrmBaseConfig;
import com.jxdinfo.crm.common.baseconfig.service.ICrmBaseConfigService;
import com.jxdinfo.crm.common.constant.OrganUserConstant;
import com.jxdinfo.crm.common.organUserComponent.dao.CommonUseMapper;
import com.jxdinfo.crm.common.organUserComponent.dto.CommonUseDto;
import com.jxdinfo.crm.common.organUserComponent.model.CommonUse;
import com.jxdinfo.crm.common.organUserComponent.service.ICommonUseService;
import com.jxdinfo.crm.common.organUserComponent.vo.CommonUseVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.exception.HussarCoreException;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CommonUseServiceImpl
extends HussarServiceImpl<CommonUseMapper, CommonUse>
implements ICommonUseService {
    @Resource
    private CommonUseMapper commonUseMapper;
    @Resource
    private ICrmBaseConfigService crmBaseConfigService;

    @Override
    public int addCommonUse(List<CommonUseDto> commonUseDtoList) {
        if (CollectionUtil.isEmpty(commonUseDtoList)) {
            throw new HussarCoreException("\u7f3a\u5c11\u5fc5\u586b\u53c2\u6570");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonUse::getCommonUseOwner, (Object)userId);
        List commonUseList = this.list((Wrapper)queryWrapper);
        List<Object> insertCommonUseDtoList = new ArrayList();
        List<CommonUse> updateCommonUseList = new ArrayList<CommonUse>();
        if (CollectionUtil.isEmpty((Collection)commonUseList)) {
            insertCommonUseDtoList = commonUseDtoList;
        } else {
            Map<Long, CommonUse> commonUseMap = commonUseList.stream().collect(Collectors.toMap(CommonUse::getBusinessId, commonUse -> commonUse));
            List addBusinessId = commonUseDtoList.stream().map(CommonUseDto::getBusinessId).collect(Collectors.toList());
            List exitBusinessId = commonUseList.stream().map(CommonUse::getBusinessId).collect(Collectors.toList());
            exitBusinessId.retainAll(addBusinessId);
            if (CollectionUtil.isNotEmpty(exitBusinessId)) {
                updateCommonUseList = commonUseList.stream().filter(commonUse -> exitBusinessId.contains(commonUse.getBusinessId())).collect(Collectors.toList());
            }
            addBusinessId.removeAll(exitBusinessId);
            if (CollectionUtil.isNotEmpty(addBusinessId)) {
                insertCommonUseDtoList = commonUseDtoList.stream().filter(commonUseDto -> addBusinessId.contains(commonUseDto.getBusinessId())).collect(Collectors.toList());
            }
        }
        if (CollectionUtil.isNotEmpty(updateCommonUseList)) {
            this.commonUseMapper.updateCountBatch(updateCommonUseList);
        }
        if (CollectionUtil.isNotEmpty(insertCommonUseDtoList)) {
            ArrayList<CommonUse> insertCommonUseList = new ArrayList<CommonUse>();
            for (CommonUseDto commonUseDto2 : insertCommonUseDtoList) {
                CommonUse commonUse2 = new CommonUse();
                BeanUtil.copyProperties((Object)commonUseDto2, (Object)((Object)commonUse2));
                commonUse2.setCommonUseOwner(userId);
                commonUse2.setCount(1);
                insertCommonUseList.add(commonUse2);
            }
            this.saveBatch(insertCommonUseList);
        }
        return 1;
    }

    @Override
    public List<CommonUseVo> listCommonUse(String types) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        CrmBaseConfig config = this.crmBaseConfigService.getCrmBaseConfigByKey("common_use_size");
        long pageSize = 20L;
        if (config != null) {
            try {
                pageSize = Long.parseLong(config.getConfigValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Page pager = new Page(1L, pageSize);
        return this.commonUseMapper.listCommonUse((Page<CommonUseVo>)pager, userId, types).getRecords();
    }

    @Override
    public List<CommonUseVo> listCommonUseAndOrganAndRole(List<String> types) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        CrmBaseConfig config = this.crmBaseConfigService.getCrmBaseConfigByKey("common_use_size");
        long pageSize = 20L;
        if (config != null) {
            try {
                pageSize = Long.parseLong(config.getConfigValue());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Page pager = new Page(1L, pageSize);
        ArrayList<String> typeList = new ArrayList<String>();
        if (types.contains(OrganUserConstant.TYPE_ROLE)) {
            typeList.add(OrganUserConstant.TYPES_ROLE);
        }
        if (types.contains(OrganUserConstant.TYPE_USER)) {
            typeList.add(OrganUserConstant.TYPES_USER);
        }
        if (types.contains(OrganUserConstant.TYPE_ORGAN)) {
            typeList.add(OrganUserConstant.TYPES_ORGAN);
        }
        return this.commonUseMapper.listCommonUseAndOrganAndRole((Page<CommonUseVo>)pager, userId, typeList).getRecords();
    }
}

