/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.dataRightManage.Service.impl;

import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.constant.OrganUserConstant;
import com.jxdinfo.crm.common.dataRightManage.Service.ICommonDataRightService;
import com.jxdinfo.crm.common.dataRightManage.dao.RolesMapper;
import com.jxdinfo.crm.common.organUserComponent.service.IOrganUserService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.support.cache.util.DefaultCacheUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CommonDataRightServiceImpl
implements ICommonDataRightService {
    @Resource
    RolesMapper rolesMapper;
    @Resource
    CrmCommonProperties crmCommonProperties;
    @Resource
    private IOrganUserService organUserService;

    @Override
    public List<Long> getChargeDepartmentList(Long userId) {
        List struList = (List)DefaultCacheUtil.get((Object)OrganUserConstant.STRU_KEY);
        SecurityUser user = null;
        user = userId == null ? BaseSecurityUtil.getUser() : this.rolesMapper.selectSecurityByUserId(userId);
        List userRoles = user.getRolesList();
        Long deptId = user.getDeptId();
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getBgLeader()))) {
            Long parentId = CommonDataRightServiceImpl.getParentIdByDeptId(struList, deptId);
            HashSet<Long> departIdSet = new HashSet<Long>(Collections.singleton(parentId));
            Set<Long> returnDepartIdSet = this.organUserService.getOrganByParentId(struList, departIdSet);
            return new ArrayList<Long>(returnDepartIdSet);
        }
        if (userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(this.crmCommonProperties.getRoles().getSalesDirector()))) {
            return Collections.singletonList(deptId);
        }
        return null;
    }

    @Override
    public Map<Long, List<SecurityUser>> getChargePersonList(List<Long> departIdList) {
        ArrayList<String> roleIdList = new ArrayList<String>();
        roleIdList.add(this.crmCommonProperties.getRoles().getSalesDirector());
        roleIdList.add(this.crmCommonProperties.getRoles().getSalesGM());
        List<SecurityUser> securityUserList = this.rolesMapper.selectSecurityByRoles(roleIdList, departIdList);
        if (CollectionUtil.isNotEmpty(securityUserList)) {
            return securityUserList.stream().collect(Collectors.groupingBy(SecurityUser::getDeptId));
        }
        return null;
    }

    public static Long getParentIdByDeptId(List<Map<String, Long>> struList, Long deptId) {
        if (CollectionUtil.isEmpty(struList)) {
            return deptId;
        }
        for (Map<String, Long> map : struList) {
            if (!map.get("struId").equals(deptId)) continue;
            return map.get("parentId");
        }
        return deptId;
    }
}

