/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.api.util;

public class DataMaskingUtil {
    public static String maskData(String data, DataType dataType) {
        if (data == null || data.trim().isEmpty()) {
            return data;
        }
        switch (dataType) {
            case PHONE: {
                return DataMaskingUtil.maskPhone(data);
            }
            case EMAIL: {
                return DataMaskingUtil.maskEmail(data);
            }
            case TELEPHONE: {
                return DataMaskingUtil.maskTelephone(data);
            }
        }
        return data;
    }

    public static String maskPhone(String phone) {
        if (phone == null || phone.length() < 7) {
            return phone;
        }
        return phone.replaceAll("(\\d{3})\\d*(\\d{4})", "$1****$2");
    }

    public static String maskEmail(String email) {
        if (email == null || !email.contains("@")) {
            return email;
        }
        String[] parts = email.split("@");
        if (parts[0].length() <= 1) {
            return email;
        }
        String username = parts[0];
        StringBuilder maskedUsername = new StringBuilder();
        maskedUsername.append(username.charAt(0));
        for (int i = 1; i < username.length() - 1; ++i) {
            maskedUsername.append('*');
        }
        if (username.length() > 1) {
            maskedUsername.append(username.charAt(username.length() - 1));
        }
        return maskedUsername.toString() + "@" + parts[1];
    }

    public static String maskTelephone(String telephone) {
        String number;
        String[] parts;
        if (telephone == null) {
            return null;
        }
        String cleanTel = telephone.replaceAll("\\s+", "");
        if (cleanTel.contains("-") && (parts = cleanTel.split("-")).length == 2 && (number = parts[1]).length() >= 4) {
            return parts[0] + "-****" + number.substring(number.length() - 4);
        }
        if (cleanTel.length() >= 8) {
            return "****" + cleanTel.substring(cleanTel.length() - 4);
        }
        return telephone;
    }

    public static enum DataType {
        PHONE,
        EMAIL,
        TELEPHONE;

    }
}

