/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.api.util;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.incrementer.DefaultIdentifierGenerator;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.text.DecimalFormat;

public class CommonUtills {
    private static IdentifierGenerator identifierGenerator = new DefaultIdentifierGenerator();
    public static final char ESCAPE_CHAR = '/';

    public static String generateAssignId() {
        String id = identifierGenerator.nextId(new Object()).toString();
        return id;
    }

    public static String transferAmount(String amount, String amountDisplay) {
        if (StringUtil.isNotEmpty((Object)amount)) {
            Double amountDouble = Double.parseDouble(amount);
            return CommonUtills.transferAmount(amountDouble, amountDisplay);
        }
        return "0.00";
    }

    public static String transferAmount(String amount) {
        if (StringUtil.isNotEmpty((Object)amount)) {
            Double amountDouble = Double.parseDouble(amount);
            return CommonUtills.transferAmount(amountDouble);
        }
        return "0.00";
    }

    public static String transferAmount(Double amount, String amountDisplay) {
        JSONObject jsonObject;
        if (StringUtil.isEmpty((Object)amountDisplay)) {
            amountDisplay = "{\"unit\":\"1\", \"decimalNum\": 2}";
        }
        if ("2".equals((jsonObject = JSONObject.parseObject((String)amountDisplay)).get((Object)"unit"))) {
            amount = amount / 10000.0;
        }
        int decimalNum = 2;
        try {
            decimalNum = Integer.parseInt(jsonObject.get((Object)"decimalNum").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String formatStr = "%." + decimalNum + "f";
        return String.format(formatStr, amount);
    }

    public static String transferAmount(Double amount) {
        ICrmBaseConfigBoService crmBaseConfigBoService = (ICrmBaseConfigBoService)SpringUtils.getBean(ICrmBaseConfigBoService.class);
        CrmBaseConfigVo crmBaseConfigVo = crmBaseConfigBoService.getCrmBaseConfigByKey("amount_display");
        String amountDisplay = crmBaseConfigVo.getConfigValue();
        return CommonUtills.transferAmount(amount, amountDisplay);
    }

    public static String transferAmountSeparator(Double amount) {
        if (amount == null || amount == 0.0) {
            return "0.00";
        }
        DecimalFormat decimalFormat = new DecimalFormat("#,###.00");
        return decimalFormat.format(amount);
    }

    public static String calculatePercent(double number1, double number2) {
        if (number1 == 0.0) {
            return "0.00%";
        }
        if (number2 == 0.0) {
            return "--";
        }
        return String.format("%.2f", number1 / number2 * 100.0) + "%";
    }

    public static String calculatePercent(int number1, int number2) {
        if (number1 == 0) {
            return "0.00%";
        }
        if (number2 == 0) {
            return "--";
        }
        return String.format("%.2f", (double)number1 / (double)number2 * 100.0) + "%";
    }

    public static String escapeLike(String input) {
        if (HussarUtils.isEmpty((Object)input)) {
            return input;
        }
        String escapeStr = String.valueOf('/');
        String escaped = input.replaceAll(escapeStr, escapeStr + escapeStr);
        escaped = escaped.replaceAll("%", escapeStr + "%");
        escaped = escaped.replaceAll("_", escapeStr + "_");
        return escaped;
    }
}

