/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.common.api.util;

import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.common.api.util.entity.DateStartEndVo;
import com.jxdinfo.hussar.platform.core.utils.DateUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Month;
import java.time.temporal.TemporalAdjusters;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CrmDateUtils {
    public static final String TIME_DAY = "day";
    public static final String TIME_HOUR = "hour";
    public static final String TIME_MINUTE = "minute";
    public static String TIME_DAY_SHOW = "\u5929";
    public static String TIME_HOUR_SHOW = "\u5c0f\u65f6";
    public static String TIME_MINUTE_SHOW = "\u5206\u949f";
    public static String STOP_DAY_TYPE = "stop_day_type";

    public static DateConvertVo getCurrentTime(String timeRange) {
        DateConvertVo dateConvertVo = null;
        if ("1".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getWeekDate();
        } else if ("11".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getLastWeekDate();
        } else if ("8".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getNextWeekDate();
        } else if ("12".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getLastMonthDay();
        } else if ("2".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getMonthDay();
        } else if ("9".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getNextMonthDay();
        } else if ("4".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getYearDay();
        } else if ("7".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getLastYearDay();
        } else if ("5".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getNextYearDay();
        } else if ("13".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getYesterday();
        } else if ("0".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getToday();
        } else if ("3".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getQuarter();
        } else if ("14".equals(timeRange)) {
            dateConvertVo = CrmDateUtils.getLastQuarter();
        }
        return dateConvertVo;
    }

    public static DateConvertVo initLastBeginEndDateByTimeRange(String timeRange, String hasDay) {
        DateConvertVo dateConvertVo = null;
        switch (timeRange) {
            case "1": {
                if ("1".equals(hasDay)) {
                    dateConvertVo = CrmDateUtils.getLastWeekTodayDate();
                    break;
                }
                dateConvertVo = CrmDateUtils.getLastWeekDate();
                break;
            }
            case "11": {
                dateConvertVo = CrmDateUtils.getLastWeekDate();
                dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
                dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
                break;
            }
            case "2": {
                if ("1".equals(hasDay)) {
                    dateConvertVo = CrmDateUtils.getLastMonthTodayDay();
                    break;
                }
                dateConvertVo = CrmDateUtils.getLastMonthDay();
                break;
            }
            case "12": {
                dateConvertVo = CrmDateUtils.getLastMonthDay();
                dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
                dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
                break;
            }
            case "4": {
                if ("1".equals(hasDay)) {
                    dateConvertVo = CrmDateUtils.getLastYearTodayDay();
                    break;
                }
                dateConvertVo = CrmDateUtils.getLastYearDay();
                break;
            }
            case "7": {
                dateConvertVo = CrmDateUtils.getLastYearDay();
                dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.plusYears((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)-1), (String)"yyyy-MM-dd"));
                dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.plusYears((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)-1), (String)"yyyy-MM-dd"));
                break;
            }
            case "14": {
                dateConvertVo = CrmDateUtils.getLastQuarter();
                dateConvertVo.setStartDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getStartDate(), (String)"yyyy-MM-dd"), (int)-3), (String)"yyyy-MM-dd"));
                dateConvertVo.setEndDate(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)dateConvertVo.getEndDate(), (String)"yyyy-MM-dd"), (int)-3), (String)"yyyy-MM-dd"));
            }
        }
        return dateConvertVo;
    }

    private static DateConvertVo getQuarter() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        int quarterFirstMonth = cal.get(2) / 3 * 3;
        cal.set(2, quarterFirstMonth);
        cal.set(5, 1);
        Date sundayDate = cal.getTime();
        String quarterStart = sdf.format(sundayDate);
        cal.add(2, 2);
        cal.set(5, cal.getActualMaximum(5));
        String quarterEnd = sdf.format(cal.getTime());
        return CrmDateUtils.dateResultMap(quarterStart, quarterEnd);
    }

    private static DateConvertVo getLastQuarter() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        int quarterLastMonth = cal.get(2) / 3 * 3;
        cal.set(2, quarterLastMonth);
        cal.set(5, 0);
        String quarterEnd = sdf.format(cal.getTime());
        int quarterFirstMonth = quarterLastMonth - 3;
        cal.set(2, quarterFirstMonth);
        cal.set(5, 1);
        String quarterStart = sdf.format(cal.getTime());
        return CrmDateUtils.dateResultMap(quarterStart, quarterEnd);
    }

    public static DateConvertVo getWeekDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        cal.add(5, 4 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        return CrmDateUtils.dateResultMap(weekBegin, weekEnd);
    }

    public static DateConvertVo getLastWeekDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        cal.add(5, 4 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        return CrmDateUtils.dateResultMap(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekBegin, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getLastWeekTodayDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        return CrmDateUtils.dateResultMap(DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekBegin, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusWeeks((Date)DateUtil.parse((String)weekEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getNextWeekDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        int dayWeek = cal.get(7);
        if (dayWeek == 1) {
            dayWeek = 8;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        cal.add(5, 4 + cal.getFirstDayOfWeek());
        Date sundayDate = cal.getTime();
        String weekEnd = sdf.format(sundayDate);
        return CrmDateUtils.dateResultMap(DateUtil.format((Date)DateUtil.plusWeeks((Date)DateUtil.parse((String)weekBegin, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.plusWeeks((Date)DateUtil.parse((String)weekEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getMonthDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String monthEnd = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(monthStart, monthEnd);
    }

    public static DateConvertVo getLastMonthDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String monthEnd = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthStart, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getLastMonthTodayDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        String monthEnd = format.format(cale.getTime());
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthStart, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.minusMonths((Date)DateUtil.parse((String)monthEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getNextMonthDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(2, 0);
        cale.set(5, 1);
        String monthStart = format.format(cale.getTime());
        cale.add(2, 1);
        cale.set(5, 0);
        String monthEnd = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(DateUtil.format((Date)DateUtil.plusMonths((Date)DateUtil.parse((String)monthStart, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"), DateUtil.format((Date)DateUtil.plusMonths((Date)DateUtil.parse((String)monthEnd, (String)"yyyy-MM-dd"), (int)1), (String)"yyyy-MM-dd"));
    }

    public static DateConvertVo getYearDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, 0);
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        cale.add(1, 1);
        cale.set(6, 0);
        String yearEnd = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getNextYearDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, 1);
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        cale.add(1, 1);
        cale.set(6, 0);
        String yearEnd = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getLastYearDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, -1);
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        cale.add(1, 1);
        cale.set(6, 0);
        String yearEnd = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getLastYearTodayDay() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(1, -1);
        String yearEnd = format.format(cale.getTime());
        cale.set(6, 1);
        String yearStart = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(yearStart, yearEnd);
    }

    public static DateConvertVo getYesterday() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, -1);
        String yesterday = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(yesterday, yesterday);
    }

    public static DateConvertVo getToday() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, 0);
        String today = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(today, today);
    }

    public static DateConvertVo getBeginANdEndTimeOfToday() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cale = Calendar.getInstance();
        cale.add(5, 0);
        String today = format.format(cale.getTime());
        cale.add(5, 1);
        String tomorrow = format.format(cale.getTime());
        return CrmDateUtils.dateResultMap(today, tomorrow);
    }

    private static DateConvertVo dateResultMap(String startDate, String endDate) {
        DateConvertVo date = new DateConvertVo();
        date.setStartDate(startDate);
        date.setEndDate(endDate);
        return date;
    }

    public static DateStartEndVo inviteSevenFifteenThirtyTime(String timeFlag) {
        LocalDate date = LocalDate.now();
        DateStartEndVo dateStartEndVo = new DateStartEndVo();
        if (HussarUtils.isNotEmpty((Object)timeFlag)) {
            switch (timeFlag) {
                case "1": {
                    dateStartEndVo.setStartDate(date.plusDays(0L));
                    dateStartEndVo.setEndDate(date.plusDays(7L));
                    break;
                }
                case "2": {
                    dateStartEndVo.setStartDate(date.plusDays(7L));
                    dateStartEndVo.setEndDate(date.plusDays(30L));
                    break;
                }
                case "3": {
                    dateStartEndVo.setStartDate(date.plusDays(30L));
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return dateStartEndVo;
    }

    public static String secondToDay(Long second, String type) {
        if (second < 0L) {
            return "--";
        }
        if (StringUtil.isEmpty((Object)type)) {
            ICrmBaseConfigBoService crmBaseConfigBoService = (ICrmBaseConfigBoService)SpringUtils.getBean(ICrmBaseConfigBoService.class);
            CrmBaseConfigVo crmBaseConfigVo = crmBaseConfigBoService.getCrmBaseConfigByKey(STOP_DAY_TYPE);
            type = TIME_DAY;
            if (crmBaseConfigVo != null && StringUtil.isNotEmpty((Object)crmBaseConfigVo.getConfigValue())) {
                type = crmBaseConfigVo.getConfigValue();
            }
        }
        long days = second / 86400L;
        long hours = second % 86400L / 3600L;
        long minutes = second % 3600L / 60L;
        String returnStr = "";
        switch (type) {
            case "minute": {
                returnStr = minutes + TIME_MINUTE_SHOW + returnStr;
            }
            case "hour": {
                returnStr = hours + TIME_HOUR_SHOW + returnStr;
            }
            case "day": {
                returnStr = days + TIME_DAY_SHOW + returnStr;
            }
        }
        if (StringUtil.isEmpty((Object)returnStr)) {
            return "--";
        }
        return returnStr;
    }

    public static String secondToDay(Long second) {
        ICrmBaseConfigBoService crmBaseConfigBoService = (ICrmBaseConfigBoService)SpringUtils.getBean(ICrmBaseConfigBoService.class);
        CrmBaseConfigVo crmBaseConfigVo = crmBaseConfigBoService.getCrmBaseConfigByKey(STOP_DAY_TYPE);
        String type = TIME_DAY;
        if (crmBaseConfigVo != null && StringUtil.isNotEmpty((Object)crmBaseConfigVo.getConfigValue())) {
            type = crmBaseConfigVo.getConfigValue();
        }
        return CrmDateUtils.secondToDay(second, type);
    }

    public static List<LocalDate> getNearlyTenDays(int timeRange) {
        LocalDate today = LocalDate.now();
        return IntStream.range(0, timeRange).mapToObj(today::minusDays).collect(Collectors.toList());
    }

    public static void getNearlyWeeks(List<Map<String, LocalDate>> mapList, LocalDate date, int n) {
        if (n > 0) {
            HashMap<String, LocalDate> map1 = new HashMap<String, LocalDate>();
            map1.put("startDate", date.minusWeeks(1L));
            map1.put("endDate", date.minusDays(1L));
            mapList.add(map1);
            CrmDateUtils.getNearlyWeeks(mapList, date.minusWeeks(1L), --n);
        }
    }

    public static void getNearlyMonths(List<Map<String, LocalDate>> mapList, LocalDate date, LocalDate dateNow, int n) {
        if (n > 1) {
            HashMap<String, LocalDate> map1 = new HashMap<String, LocalDate>();
            map1.put("startDate", date.minusMonths(1L).with(TemporalAdjusters.firstDayOfMonth()));
            map1.put("endDate", date.minusMonths(1L).with(TemporalAdjusters.lastDayOfMonth()));
            mapList.add(map1);
            CrmDateUtils.getNearlyMonths(mapList, date.minusMonths(1L), dateNow, --n);
        } else {
            HashMap<String, LocalDate> map1 = new HashMap<String, LocalDate>();
            map1.put("startDate", dateNow.with(TemporalAdjusters.firstDayOfMonth()));
            map1.put("endDate", dateNow);
            mapList.add(map1);
        }
    }

    public static void getNearlyQuarters(List<Map<String, LocalDate>> mapList, LocalDate date, LocalDate dateNow, int n) {
        if (n > 1) {
            HashMap<String, LocalDate> map1 = new HashMap<String, LocalDate>();
            LocalDate firstDayOfQuarter = CrmDateUtils.getFirstDayOfQuarter(date.minusMonths(3L));
            map1.put("startDate", firstDayOfQuarter);
            map1.put("endDate", firstDayOfQuarter.plusMonths(3L).minusDays(1L).with(TemporalAdjusters.lastDayOfMonth()));
            mapList.add(map1);
            CrmDateUtils.getNearlyQuarters(mapList, firstDayOfQuarter, dateNow, --n);
        } else {
            HashMap<String, LocalDate> map1 = new HashMap<String, LocalDate>();
            LocalDate firstDayOfQuarter = CrmDateUtils.getFirstDayOfQuarter(dateNow);
            map1.put("startDate", firstDayOfQuarter);
            map1.put("endDate", dateNow);
            mapList.add(map1);
        }
    }

    private static LocalDate getFirstDayOfQuarter(LocalDate dateNow) {
        int month = dateNow.getMonthValue();
        LocalDate firstDayOfQuarter = month <= 3 ? LocalDate.of(dateNow.getYear(), Month.JANUARY, 1) : (month <= 6 ? LocalDate.of(dateNow.getYear(), Month.APRIL, 1) : (month <= 9 ? LocalDate.of(dateNow.getYear(), Month.JULY, 1) : LocalDate.of(dateNow.getYear(), Month.OCTOBER, 1)));
        return firstDayOfQuarter;
    }

    public static void getNearlyYears(List<Map<String, LocalDate>> mapList, LocalDate date, LocalDate dateNow, int n) {
        if (n > 1) {
            HashMap<String, LocalDate> map1 = new HashMap<String, LocalDate>();
            map1.put("startDate", date.minusYears(1L).with(TemporalAdjusters.firstDayOfYear()));
            map1.put("endDate", date.minusYears(1L).with(TemporalAdjusters.lastDayOfYear()));
            mapList.add(map1);
            CrmDateUtils.getNearlyYears(mapList, date.minusYears(1L), dateNow, --n);
        } else {
            HashMap<String, LocalDate> map1 = new HashMap<String, LocalDate>();
            map1.put("startDate", dateNow.with(TemporalAdjusters.firstDayOfYear()));
            map1.put("endDate", dateNow);
            mapList.add(map1);
        }
    }
}

