/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.common.CommonUtil;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.SalespersonOpportunityAnalysisMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.SalespersonOpportunityAnalysisDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.SalespersonOpportunityAnalysisService;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SaleOpptyCellVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonOpportunityAnalysisVo;
import com.jxdinfo.crm.common.api.dataRightManage.IDataRightBoService;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CommonUtills;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityDataRightModuleService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SalespersonOpportunityAnalysisServiceImpl
implements SalespersonOpportunityAnalysisService {
    @Resource
    private SalespersonOpportunityAnalysisMapper analysisMapper;
    @Resource
    private CommonUtil commonUtil;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IOpportunityDataRightModuleService opportunityDataRightModuleService;
    @Resource
    private IDataRightBoService dataRightBoService;

    @Override
    public List<SalespersonOpportunityAnalysisVo> salespersonOppoAnalysis(SalespersonOpportunityAnalysisDto dto) {
        List<SaleOpptyCellVo> stageCellVoList;
        List<SalespersonOpportunityAnalysisVo> oppoSourceLists;
        List<SalespersonOpportunityAnalysisVo> oppoFollowUp;
        List oppoStageList;
        SecurityUser user = BaseSecurityUtil.getUser();
        dto.setCurrentUserId(user.getId());
        List permissionDeptIds = this.dataRightBoService.getChargeDepartmentHasDivisions();
        List provinceStruIds = this.commonMapper.selectAllProvinceStruId();
        if (ToolUtil.isEmpty((Object)provinceStruIds)) {
            return new ArrayList<SalespersonOpportunityAnalysisVo>();
        }
        if (HussarUtils.isNotEmpty((Object)permissionDeptIds)) {
            List<Long> provinceIds = permissionDeptIds.stream().filter(provinceStruIds::contains).collect(Collectors.toList());
            if (CollectionUtil.isEmpty(provinceIds)) {
                return new ArrayList<SalespersonOpportunityAnalysisVo>();
            }
            dto.setPermissionDeptIds(provinceIds);
            dto.setProvinceStruIds(provinceIds);
        } else {
            dto.setPermissionDeptIds(provinceStruIds);
            dto.setProvinceStruIds(provinceStruIds);
        }
        if (HussarUtils.isEmpty((Object)dto.getTimeRange())) {
            dto.setStartTime(null);
            dto.setEndTime(null);
        }
        if (HussarUtils.isNotEmpty((Object)dto.getTimeRange()) && !"6".equals(dto.getTimeRange())) {
            DateConvertVo currentTime = CrmDateUtils.getCurrentTime((String)dto.getTimeRange());
            dto.setStartTime(currentTime.getStartDate());
            dto.setEndTime(currentTime.getEndDate());
        }
        Long provinceDeptId = dto.getProvinceDeptId();
        this.calculationTime(dto);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OpportunityStage::getDelFlag, (Object)"0");
        if (ToolUtil.isNotEmpty((Object)dto.getStageProcessId())) {
            ((LambdaQueryWrapper)queryWrapper.eq(OpportunityStage::getStageProcessId, (Object)dto.getStageProcessId())).orderByAsc(OpportunityStage::getOrderNumber);
        }
        if (CollectionUtil.isEmpty((Collection)(oppoStageList = this.opportunityStageService.list((Wrapper)queryWrapper)))) {
            return new ArrayList<SalespersonOpportunityAnalysisVo>();
        }
        Map<Long, String> currentCustomerStages = oppoStageList.stream().collect(Collectors.toMap(OpportunityStage::getCustomerStageId, OpportunityStage::getCustomerStageName));
        List<Long> currentCustomerStageIds = oppoStageList.stream().sorted(Comparator.comparing(OpportunityStage::getOrderNumber)).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        dto.setCurrentCustomerStageIds(currentCustomerStageIds);
        String network = "4";
        String selfExtension = "5";
        String oldCustomer = "6";
        String businessType = CrmBusinessTypeEnum.OPPORTUNITY.getId();
        List<Long> customerNotInStageIds = oppoStageList.stream().filter(s -> new ArrayList<String>(Arrays.asList("20", "21", "22", "23")).contains(s.getStageType())).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        dto.setCustomerStageIds(customerNotInStageIds);
        LocalDate now = LocalDate.now();
        LocalDate sevenDaysLater = now.minus(Period.ofDays(7));
        LocalDate fifteenDaysLater = now.minus(Period.ofDays(15));
        LocalDate thirtyDaysLater = now.minus(Period.ofDays(30));
        dto.setSevenDaysLater(sevenDaysLater);
        dto.setFifteenDaysLater(fifteenDaysLater);
        dto.setThirtyDaysLater(thirtyDaysLater);
        if (ToolUtil.isNotEmpty((Object)provinceDeptId)) {
            List<Long> provinceUserIds = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getDepartmentId, (Object)provinceDeptId)).stream().map(SysUsers::getId).collect(Collectors.toList());
            if (ToolUtil.isEmpty(provinceUserIds)) {
                return new ArrayList<SalespersonOpportunityAnalysisVo>();
            }
            dto.setProvinceUserIds(provinceUserIds);
            dto.setPermissionDeptIds(null);
            oppoFollowUp = this.analysisMapper.getOppoFolllowUpPerson(dto, businessType);
            oppoSourceLists = this.analysisMapper.getOppoSourcePerson(dto, network, selfExtension, oldCustomer);
            stageCellVoList = this.analysisMapper.getOppoStatePerson(dto);
        } else {
            oppoFollowUp = this.analysisMapper.getOppoFolllowUp(dto, businessType);
            oppoSourceLists = this.analysisMapper.getOppoSource(dto, network, selfExtension, oldCustomer);
            stageCellVoList = this.analysisMapper.getOppoState(dto);
        }
        Map<String, List<SaleOpptyCellVo>> saleOpptybyStageCellVosSum = stageCellVoList.stream().collect(Collectors.groupingBy(SaleOpptyCellVo::getCustomerStageId));
        List dicSingles = this.sysDicRefService.getDictByType("salesProcess_StageList");
        Map<String, Integer> sortMap = dicSingles.stream().collect(Collectors.toMap(DicSingle::getLabel, DicSingle::getSort));
        for (SalespersonOpportunityAnalysisVo salespersonOpportunityAnalysisVo : oppoFollowUp) {
            Map<String, List<SaleOpptyCellVo>> saleOpptybyStageCellVos;
            Object oppoSourceDeptUserLists;
            List<Object> saleOpptyCellVoListFinal = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)provinceDeptId)) {
                Long userId = salespersonOpportunityAnalysisVo.getUserId();
                oppoSourceDeptUserLists = oppoSourceLists.stream().filter(f -> Objects.equals(f.getUserId(), userId)).collect(Collectors.toList());
                saleOpptybyStageCellVos = stageCellVoList.stream().filter(f -> Objects.equals(f.getUserId(), userId)).collect(Collectors.groupingBy(SaleOpptyCellVo::getCustomerStageId));
            } else {
                Long dept = salespersonOpportunityAnalysisVo.getDeptId();
                oppoSourceDeptUserLists = oppoSourceLists.stream().filter(f -> Objects.equals(f.getDeptId(), dept)).collect(Collectors.toList());
                saleOpptybyStageCellVos = stageCellVoList.stream().filter(f -> Objects.equals(f.getDeptId(), dept)).collect(Collectors.groupingBy(SaleOpptyCellVo::getCustomerStageId));
            }
            for (Long currentStageId : currentCustomerStageIds) {
                SaleOpptyCellVo saleOpptyFinal = new SaleOpptyCellVo();
                if (ToolUtil.isNotEmpty(saleOpptybyStageCellVos.get(String.valueOf(currentStageId)))) {
                    List<SaleOpptyCellVo> voListTemp = saleOpptybyStageCellVos.get(String.valueOf(currentStageId));
                    saleOpptyFinal.setCustomerStageId(voListTemp.get(0).getCustomerStageId());
                    saleOpptyFinal.setCustomerStageName(voListTemp.get(0).getCustomerStageName());
                    saleOpptyFinal.setCountNum(voListTemp.get(0).getCountNum());
                    saleOpptyCellVoListFinal.add(saleOpptyFinal);
                    continue;
                }
                saleOpptyFinal.setCustomerStageId(String.valueOf(currentStageId));
                saleOpptyFinal.setCustomerStageName(currentCustomerStages.get(currentStageId));
                saleOpptyFinal.setCountNum(0L);
                saleOpptyCellVoListFinal.add(saleOpptyFinal);
            }
            if (ToolUtil.isEmpty((Object)dto.getStageProcessId())) {
                saleOpptyCellVoListFinal = saleOpptyCellVoListFinal.stream().collect(Collectors.groupingBy(SaleOpptyCellVo::getCustomerStageName)).entrySet().stream().map(entry -> {
                    String stageName = (String)entry.getKey();
                    List groupedList = (List)entry.getValue();
                    String stageId = groupedList.stream().map(SaleOpptyCellVo::getCustomerStageId).collect(Collectors.joining(","));
                    long countNum = groupedList.stream().mapToLong(SaleOpptyCellVo::getCountNum).sum();
                    SaleOpptyCellVo saleOpptyCellVo = new SaleOpptyCellVo();
                    saleOpptyCellVo.setCustomerStageId(stageId);
                    saleOpptyCellVo.setCustomerStageName(stageName);
                    saleOpptyCellVo.setCountNum(countNum);
                    return saleOpptyCellVo;
                }).collect(Collectors.toList());
                saleOpptyCellVoListFinal = saleOpptyCellVoListFinal.stream().sorted(Comparator.comparingInt(vo -> sortMap.getOrDefault(vo.getCustomerStageName(), Integer.MAX_VALUE))).collect(Collectors.toList());
            }
            Integer weekChangeNum = salespersonOpportunityAnalysisVo.getWeekChangeNum() == null ? 0 : salespersonOpportunityAnalysisVo.getWeekChangeNum();
            Integer lastTotal = salespersonOpportunityAnalysisVo.getLastTotal() == null ? 0 : salespersonOpportunityAnalysisVo.getLastTotal();
            salespersonOpportunityAnalysisVo.setWeekChangeNum(weekChangeNum - lastTotal);
            if (ToolUtil.isNotEmpty(oppoSourceDeptUserLists)) {
                SalespersonOpportunityAnalysisVo oppoSourceDept = (SalespersonOpportunityAnalysisVo)oppoSourceDeptUserLists.get(0);
                salespersonOpportunityAnalysisVo.setNetworkNum(oppoSourceDept.getNetworkNum());
                salespersonOpportunityAnalysisVo.setSelfExtensionNum(oppoSourceDept.getSelfExtensionNum());
                salespersonOpportunityAnalysisVo.setOldCustomerNum(oppoSourceDept.getOldCustomerNum());
                salespersonOpportunityAnalysisVo.setOtherSourceNum(oppoSourceDept.getOtherSourceNum());
            }
            if (!ToolUtil.isNotEmpty(saleOpptyCellVoListFinal)) continue;
            salespersonOpportunityAnalysisVo.setStageCellVos(saleOpptyCellVoListFinal);
        }
        SalespersonOpportunityAnalysisVo salespersonOpportunityAnalysisVo = new SalespersonOpportunityAnalysisVo();
        if (ToolUtil.isNotEmpty((Object)provinceDeptId)) {
            salespersonOpportunityAnalysisVo.setUserName("\u5408\u8ba1");
        } else {
            salespersonOpportunityAnalysisVo.setDeptName("\u5408\u8ba1");
        }
        salespersonOpportunityAnalysisVo.setOppoTotalNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getOppoTotalNum).sum());
        salespersonOpportunityAnalysisVo.setFollowedUpNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getFollowedUpNum).sum());
        salespersonOpportunityAnalysisVo.setNotFollowedUpMonthNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getNotFollowedUpMonthNum).sum());
        salespersonOpportunityAnalysisVo.setFollowedUpWeekNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getFollowedUpWeekNum).sum());
        salespersonOpportunityAnalysisVo.setDailyFollowUpNum(oppoFollowUp.stream().mapToDouble(SalespersonOpportunityAnalysisVo::getFollowedUpWeekNum).sum() / (double)dto.getWeekDayCount());
        salespersonOpportunityAnalysisVo.setAverageFollowUpNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getAverageFollowUpNum).sum());
        salespersonOpportunityAnalysisVo.setWeekChangeNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getWeekChangeNum).sum());
        salespersonOpportunityAnalysisVo.setNetworkNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getNetworkNum).sum());
        salespersonOpportunityAnalysisVo.setSelfExtensionNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getSelfExtensionNum).sum());
        salespersonOpportunityAnalysisVo.setOldCustomerNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getOldCustomerNum).sum());
        salespersonOpportunityAnalysisVo.setOtherSourceNum(oppoFollowUp.stream().mapToInt(SalespersonOpportunityAnalysisVo::getOtherSourceNum).sum());
        List<SaleOpptyCellVo> saleOpptyFinalListSum = new ArrayList<SaleOpptyCellVo>();
        for (Long currentStageId : currentCustomerStageIds) {
            SaleOpptyCellVo saleOpptyFinal = new SaleOpptyCellVo();
            if (ToolUtil.isNotEmpty(saleOpptybyStageCellVosSum.get(String.valueOf(currentStageId)))) {
                List<SaleOpptyCellVo> voListTemp = saleOpptybyStageCellVosSum.get(String.valueOf(currentStageId));
                saleOpptyFinal.setCustomerStageId(voListTemp.get(0).getCustomerStageId());
                saleOpptyFinal.setCustomerStageName(voListTemp.get(0).getCustomerStageName());
                saleOpptyFinal.setCountNum(voListTemp.stream().mapToLong(SaleOpptyCellVo::getCountNum).sum());
                saleOpptyFinalListSum.add(saleOpptyFinal);
                continue;
            }
            saleOpptyFinal.setCustomerStageId(String.valueOf(currentStageId));
            saleOpptyFinal.setCustomerStageName(currentCustomerStages.get(currentStageId));
            saleOpptyFinal.setCountNum(0L);
            saleOpptyFinalListSum.add(saleOpptyFinal);
        }
        if (ToolUtil.isEmpty((Object)dto.getStageProcessId())) {
            saleOpptyFinalListSum = saleOpptyFinalListSum.stream().collect(Collectors.groupingBy(SaleOpptyCellVo::getCustomerStageName)).entrySet().stream().map(entry -> {
                String stageName = (String)entry.getKey();
                List groupedList = (List)entry.getValue();
                String stageId = groupedList.stream().map(SaleOpptyCellVo::getCustomerStageId).collect(Collectors.joining(","));
                long countNum = groupedList.stream().mapToLong(SaleOpptyCellVo::getCountNum).sum();
                SaleOpptyCellVo saleOpptyCellVo = new SaleOpptyCellVo();
                saleOpptyCellVo.setCustomerStageId(stageId);
                saleOpptyCellVo.setCustomerStageName(stageName);
                saleOpptyCellVo.setCountNum(countNum);
                return saleOpptyCellVo;
            }).collect(Collectors.toList());
            saleOpptyFinalListSum = saleOpptyFinalListSum.stream().sorted(Comparator.comparingInt(vo -> sortMap.getOrDefault(vo.getCustomerStageName(), Integer.MAX_VALUE))).collect(Collectors.toList());
        }
        salespersonOpportunityAnalysisVo.setStageCellVos(saleOpptyFinalListSum);
        List<SalespersonOpportunityAnalysisVo> collect = oppoFollowUp;
        String sortString = dto.getSortString();
        if (HussarUtils.isNotEmpty((Object)sortString)) {
            String[] split = sortString.split(",");
            String row = split[0];
            String sort = split[1];
            Comparator<SalespersonOpportunityAnalysisVo> comparator = null;
            switch (row) {
                case "oppoTotalNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getOppoTotalNum);
                    break;
                }
                case "followedUpNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getFollowedUpNum);
                    break;
                }
                case "notFollowedUpMonthNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getNotFollowedUpMonthNum);
                    break;
                }
                case "followedUpWeekNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getFollowedUpWeekNum);
                    break;
                }
                case "dailyFollowUpNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getDailyFollowUpNum);
                    break;
                }
                case "averageFollowUpNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getAverageFollowUpNum);
                    break;
                }
                case "weekChangeNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getWeekChangeNum);
                    break;
                }
                case "networkNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getNetworkNum);
                    break;
                }
                case "selfExtensionNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getSelfExtensionNum);
                    break;
                }
                case "oldCustomerNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getOldCustomerNum);
                    break;
                }
                case "otherSourceNum": {
                    comparator = this.getComparatorRank(sort, SalespersonOpportunityAnalysisVo::getOtherSourceNum);
                    break;
                }
            }
            if (comparator != null) {
                collect = oppoFollowUp.stream().sorted(comparator).collect(Collectors.toList());
            } else {
                this.salesPersonOpportunityAnalysisSort(sortString, collect);
            }
        }
        collect.add(salespersonOpportunityAnalysisVo);
        collect.forEach(f -> f.setDailyFollowUpNum(Math.round(f.getDailyFollowUpNum())));
        return collect;
    }

    private void salesPersonOpportunityAnalysisSort(String orderString, List<SalespersonOpportunityAnalysisVo> salesPersonOpptyAnalysisVos) {
        String[] orders = orderString.split(",");
        if (orders.length != 2) {
            return;
        }
        String stageId = orders[0];
        String orderType = orders[1];
        for (int i = 0; i < salesPersonOpptyAnalysisVos.size(); ++i) {
            for (int j = 0; j < salesPersonOpptyAnalysisVos.size() - 1 - i; ++j) {
                SalespersonOpportunityAnalysisVo salesPersonOpptyAnalysisVo = salesPersonOpptyAnalysisVos.get(j);
                long numbers1 = 0L;
                SalespersonOpportunityAnalysisVo voTemp = salesPersonOpptyAnalysisVos.get(j + 1);
                long numbers2 = 0L;
                for (SaleOpptyCellVo saleOpptyCellVo : salesPersonOpptyAnalysisVo.getStageCellVos()) {
                    if (!saleOpptyCellVo.getCustomerStageId().equals(stageId)) continue;
                    numbers1 = saleOpptyCellVo.getCountNum();
                    break;
                }
                for (SaleOpptyCellVo saleOpptyCellVo : voTemp.getStageCellVos()) {
                    if (!saleOpptyCellVo.getCustomerStageId().equals(stageId)) continue;
                    numbers2 = saleOpptyCellVo.getCountNum();
                    break;
                }
                if ("0".equals(orderType)) {
                    if (numbers1 <= numbers2) continue;
                    Collections.swap(salesPersonOpptyAnalysisVos, j, j + 1);
                    continue;
                }
                if (numbers1 > numbers2) continue;
                Collections.swap(salesPersonOpptyAnalysisVos, j, j + 1);
            }
        }
    }

    @Override
    public Page<OpportunityEntity> oppoAnalysisPopUp(SalespersonOpportunityAnalysisDto dto) {
        this.calculationTime(dto);
        SecurityUser user = BaseSecurityUtil.getUser();
        dto.setCurrentUserId(user.getId());
        Page page = dto.getPage();
        String businessType = CrmBusinessTypeEnum.OPPORTUNITY.getId();
        dto.setSearchKey(CommonUtills.escapeLike((String)dto.getSearchKey()));
        List<OpportunityEntity> oppoAnalysisPopUp = this.analysisMapper.oppoAnalysisPopUp((Page<OpportunityEntity>)page, dto, businessType);
        page.setRecords(oppoAnalysisPopUp);
        return page;
    }

    private SalespersonOpportunityAnalysisDto calculationTime(SalespersonOpportunityAnalysisDto dto) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        int dayOfWeek = calendar.get(7);
        if (dayOfWeek == 1) {
            calendar.add(5, -6);
        } else {
            calendar.add(5, -dayOfWeek + 2);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        dto.setWeekFirstDay(LocalDate.parse(sdf.format(calendar.getTime())));
        dto.setWeekLastDay(dto.getWeekFirstDay().plusDays(6L));
        if (dayOfWeek == 1) {
            dayOfWeek = 8;
        }
        dto.setWeekDayCount(dayOfWeek - 1);
        return dto;
    }

    private Comparator<SalespersonOpportunityAnalysisVo> getComparatorRank(String sort, Function<SalespersonOpportunityAnalysisVo, Comparable> keyExtractor) {
        switch (sort) {
            case "0": {
                return Comparator.comparing(keyExtractor);
            }
            case "1": {
                return Comparator.comparing(keyExtractor).reversed();
            }
        }
        throw new IllegalArgumentException("Invalid statisticalIndicators value: " + sort);
    }
}

