/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.OpportunityLoseWinAnalysisMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.IOpportunityLoseWinAnalysisService;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.LoseReasonCountVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.WinningElementsCountVo;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.util.entity.PermissionDto;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityDataRightModuleService;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.product.model.ProductCategory;
import com.jxdinfo.crm.product.service.ProductCategoryService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityLoseWinAnalysisServiceImpl
implements IOpportunityLoseWinAnalysisService {
    @Resource
    private ProductCategoryService productCategoryService;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private OpportunityLoseWinAnalysisMapper opportunityLoseWinAnalysisMapper;
    @Resource
    private IOpportunityDataRightModuleService opportunityDataRightModuleService;

    @Override
    public Page<OpportunityEntity> lostList(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        this.productCategoryIdTrans(dto);
        dto.setDelFlag("0");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageLose(true);
        List stageLose = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageLose();
        dto.setLoseStateIds(stageLose);
        if (HussarUtils.isNotEmpty((Object)dto.getTimeRange())) {
            IndexUtil.getCurrentTimeRange((SalesStatisticsDto)dto);
        }
        PermissionDto opportunityPermissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        PermissionDto campaignPermissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        if (CollectionUtil.isNotEmpty((Collection)dto.getDeptIds())) {
            dto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(dto.getDeptIds()));
        }
        List<OpportunityEntity> list = this.opportunityLoseWinAnalysisMapper.loseListPage(dto, (Page<OpportunityEntity>)page, opportunityPermissionDto, campaignPermissionDto);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<WinningElementsCountVo> winningElements(SalesStatisticsDto dto) {
        this.productCategoryIdTrans(dto);
        dto.setDelFlag("0");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        dto.setWinStateIds(stageWin);
        if (HussarUtils.isNotEmpty((Object)dto.getTimeRange())) {
            IndexUtil.getCurrentTimeRange((SalesStatisticsDto)dto);
        }
        PermissionDto opportunityPermissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        PermissionDto campaignPermissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        if (CollectionUtil.isNotEmpty((Collection)dto.getDeptIds())) {
            dto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(dto.getDeptIds()));
        }
        return this.opportunityLoseWinAnalysisMapper.winningElementsCount(dto, opportunityPermissionDto, campaignPermissionDto);
    }

    @Override
    public Page<OpportunityEntity> winList(SalesStatisticsDto dto) {
        Page page = new Page();
        if (dto.getCurrent() != null) {
            page.setCurrent((long)dto.getCurrent().intValue());
        } else {
            page.setCurrent(1L);
        }
        if (dto.getSize() != null) {
            page.setSize((long)dto.getSize().intValue());
        } else {
            page.setSize(10L);
        }
        this.productCategoryIdTrans(dto);
        dto.setDelFlag("0");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        dto.setWinStateIds(stageWin);
        if (HussarUtils.isNotEmpty((Object)dto.getTimeRange())) {
            IndexUtil.getCurrentTimeRange((SalesStatisticsDto)dto);
        }
        PermissionDto opportunityPermissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        PermissionDto campaignPermissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        if (CollectionUtil.isNotEmpty((Collection)dto.getDeptIds())) {
            dto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(dto.getDeptIds()));
        }
        List<OpportunityEntity> list = this.opportunityLoseWinAnalysisMapper.winListPage(dto, (Page<OpportunityEntity>)page, opportunityPermissionDto, campaignPermissionDto);
        page.setRecords(list);
        return page;
    }

    @Override
    public List<LoseReasonCountVo> loseReason(SalesStatisticsDto dto) {
        this.productCategoryIdTrans(dto);
        dto.setDelFlag("0");
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageLose(true);
        List stageLose = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageLose();
        dto.setLoseStateIds(stageLose);
        dto.setLoseType("lost_type");
        if (HussarUtils.isNotEmpty((Object)dto.getTimeRange())) {
            IndexUtil.getCurrentTimeRange((SalesStatisticsDto)dto);
        }
        PermissionDto opportunityPermissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        PermissionDto campaignPermissionDto = this.opportunityDataRightModuleService.getCurrentUserRolePermissions();
        if (CollectionUtil.isNotEmpty((Collection)dto.getDeptIds())) {
            dto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(dto.getDeptIds()));
        }
        return this.opportunityLoseWinAnalysisMapper.loseReason(dto, opportunityPermissionDto, campaignPermissionDto);
    }

    private void productCategoryIdTrans(SalesStatisticsDto dto) {
        List categoryIds = dto.getProductCategoryIds();
        if (CollectionUtil.isNotEmpty((Collection)categoryIds)) {
            List categoryList = this.productCategoryService.list((Wrapper)new LambdaQueryWrapper().eq(ProductCategory::getDelFlag, (Object)"0"));
            HashSet<Long> searchCategoryIdSet = new HashSet<Long>();
            for (Long categoryId : categoryIds) {
                ArrayList<Long> childCategoryIds = new ArrayList<Long>();
                childCategoryIds.add(categoryId);
                this.getCategoryAllChildId(childCategoryIds, categoryList, categoryId);
                searchCategoryIdSet.addAll(childCategoryIds);
            }
            dto.setProductCategoryIds(new ArrayList(searchCategoryIdSet));
        }
    }

    private void getCategoryAllChildId(List<Long> childCategoryIds, List<ProductCategory> categoryList, Long categoryId) {
        for (ProductCategory pc : categoryList) {
            if (!Objects.equals(pc.getParentId(), categoryId)) continue;
            childCategoryIds.add(pc.getCategoryId());
            this.getCategoryAllChildId(childCategoryIds, categoryList, pc.getCategoryId());
        }
    }
}

