/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.datamonitor.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.analysis.datamonitor.dao.DataMonitorFieldMapper;
import com.jxdinfo.crm.analysis.datamonitor.dao.TabulationFieldMapper;
import com.jxdinfo.crm.analysis.datamonitor.model.DataMonitorRuleEntity;
import com.jxdinfo.crm.analysis.datamonitor.model.TabulationFieldEntity;
import com.jxdinfo.crm.analysis.datamonitor.service.IDataMonitorRuleService;
import com.jxdinfo.crm.analysis.datamonitor.service.ITabulationFieldService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class TabulationFieldServiceImpl
extends ServiceImpl<TabulationFieldMapper, TabulationFieldEntity>
implements ITabulationFieldService {
    @Resource
    private DataMonitorFieldMapper dataMonitorFieldMapper;
    @Resource
    private IDataMonitorRuleService dataMonitorRuleService;
    @Resource
    private TabulationFieldMapper tabulationFieldMapper;

    @Override
    public Map<String, Object> getTabulationFields(Long ruleId) {
        List<Object> fieldVoList = new ArrayList();
        DataMonitorRuleEntity dataMonitorRuleEntity = (DataMonitorRuleEntity)this.dataMonitorRuleService.getById(ruleId);
        if (ToolUtil.isNotEmpty((Object)dataMonitorRuleEntity)) {
            fieldVoList = this.tabulationFieldMapper.selectTabulationFieldListByRuleId(ruleId, dataMonitorRuleEntity.getTargetType());
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("fieldList", fieldVoList);
        resultMap.put("ignoreFlag", dataMonitorRuleEntity.getIgnoreFlag());
        resultMap.put("pushFlag", dataMonitorRuleEntity.getPushFlag());
        resultMap.put("editDepartmentOperation", dataMonitorRuleEntity.getEditDepartmentOperation());
        resultMap.put("editDepartmentByChargePersonOperation", dataMonitorRuleEntity.getEditDepartmentByChargePersonOperation());
        resultMap.put("addProductOperation", dataMonitorRuleEntity.getAddProductOperation());
        resultMap.put("transferOperation", dataMonitorRuleEntity.getTransferOperation());
        return resultMap;
    }
}

