/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.opportunityportrait.job.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.crm.analysis.opportunityportrait.dao.RecordAIMapper;
import com.jxdinfo.crm.analysis.opportunityportrait.dto.OpportunityPortraitDto;
import com.jxdinfo.crm.analysis.opportunityportrait.job.service.IOpptyPortraitRecordAIService;
import com.jxdinfo.crm.analysis.opportunityportrait.model.RecordAI;
import com.jxdinfo.crm.analysis.opportunityportrait.service.IRecordAIService;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.DimensionVo;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.RecordAIVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.jxdIM.util.HttpClientUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OpptyPortraitRecordAIServiceImpl
implements IOpptyPortraitRecordAIService {
    private static final Logger logger = LoggerFactory.getLogger(OpptyPortraitRecordAIServiceImpl.class);
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private CrmCommonProperties crmCommonProperties;
    @Resource
    private IRecordAIService recordAIService;
    @Resource
    private RecordAIMapper recordAIMapper;

    @Override
    public String calculateRecordAIList(OpportunityPortraitDto dto, List<Long> ids) {
        boolean portraitFlag = "1".equals(this.crmBaseConfigBoService.getCrmBaseConfigByKey("opportunity_portrait_switch").getConfigValue());
        boolean aiFlag = "1".equals(this.crmBaseConfigBoService.getCrmBaseConfigByKey("opportunity_portrait_ai").getConfigValue());
        if (!portraitFlag || !aiFlag) {
            return "2";
        }
        if (!this.crmCommonProperties.getAi().isAiEnable()) {
            return "2";
        }
        List<Object> opportunityIds = new ArrayList<Long>();
        String content = "";
        if (HussarUtils.isNotEmpty((Object)dto)) {
            opportunityIds.add(Long.parseLong(dto.getOpportunityId()));
            content = dto.getContent();
        } else if (HussarUtils.isNotEmpty(ids)) {
            opportunityIds.addAll(ids);
        } else {
            String[] stringStageIds = this.crmBaseConfigBoService.getCrmBaseConfigByKey("oppty_update_stage").getConfigValue().split(",");
            List<String> stageList = Arrays.asList(stringStageIds);
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            map.put("customerStageIds", stageList);
            List opportunityList = this.opportunityAPIService.selectOpptyPortraitUsedList(map);
            opportunityIds = opportunityList.stream().map(OpportunityAPIVo::getOpportunityId).collect(Collectors.toList());
        }
        String url = this.crmCommonProperties.getAi().getRequestAiOpptyAnalysisUrl();
        LocalDateTime date = LocalDateTime.now();
        String unclearBudgetKeys = "";
        DimensionVo budgetConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_budget").getConfigValue(), DimensionVo.class);
        if (HussarUtils.isNotEmpty((Object)budgetConfig) && HussarUtils.isNotEmpty((Object)budgetConfig.getTwo().getTrackrecordContain())) {
            unclearBudgetKeys = budgetConfig.getTwo().getTrackrecordContain();
        }
        String existingPlanKeys = "";
        String clearRequirementsKeys = "";
        String clearBiddingInfoKeys = "";
        DimensionVo needConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_need").getConfigValue(), DimensionVo.class);
        if (HussarUtils.isNotEmpty((Object)needConfig)) {
            if (HussarUtils.isNotEmpty((Object)needConfig.getFive().getTrackrecordContain())) {
                existingPlanKeys = needConfig.getFive().getTrackrecordContain();
            }
            if (HussarUtils.isNotEmpty((Object)needConfig.getFour().getTrackrecordContain())) {
                clearRequirementsKeys = needConfig.getFour().getTrackrecordContain();
            }
            if (HussarUtils.isNotEmpty((Object)needConfig.getTwo().getTrackrecordContain())) {
                clearBiddingInfoKeys = needConfig.getTwo().getTrackrecordContain();
            }
        }
        List recordAIListExist = this.recordAIService.list((Wrapper)new LambdaQueryWrapper().in(RecordAI::getTypeId, opportunityIds));
        ArrayList<RecordAI> recordAIList = new ArrayList<RecordAI>();
        logger.info("AI\u8bc6\u522b\u5546\u673a\u8ddf\u8fdb\u5185\u5bb9\u5f00\u59cb");
        int count = 0;
        LocalDateTime start = LocalDateTime.now();
        for (Long l : opportunityIds) {
            RecordAI recordAI = this.getRecordAIByAIRequest(url, l, recordAIListExist, unclearBudgetKeys, existingPlanKeys, clearRequirementsKeys, clearBiddingInfoKeys, content, date);
            if (!HussarUtils.isNotEmpty((Object)recordAI)) continue;
            ++count;
            recordAIList.add(recordAI);
        }
        LocalDateTime end = LocalDateTime.now();
        logger.info("AI\u8bc6\u522b{}\u6761\u5546\u673a\u8ddf\u8fdb\u5185\u5bb9\u7ed3\u675f\uff0c\u603b\u5171\u8017\u65f6{}s", (Object)count, (Object)(Duration.between(start, end).toMillis() / 1000L));
        if (HussarUtils.isNotEmpty(recordAIList)) {
            logger.info("\u5f00\u59cb\u5411\u6570\u636e\u5e93\u63d2\u5165\u6570\u636e");
            this.recordAIService.saveOrUpdateBatch(recordAIList);
            logger.info("\u6570\u636e\u5e93\u63d2\u5165\u6570\u636e\u5b8c\u6210");
            return "0";
        }
        logger.info("AI\u8bc6\u522b\u5546\u673a\u8ddf\u8fdb\u5185\u5bb9\u5931\u8d25");
        return "1";
    }

    private RecordAI getRecordAIByAIRequest(String url, Long id, List<RecordAI> recordAIListExist, String unclearBudgetKeys, String existingPlanKeys, String clearRequirementsKeys, String clearBiddingInfoKeys, String content, LocalDateTime date) {
        RecordAI recordAI = recordAIListExist.stream().filter(r -> HussarUtils.equals((Object)r.getTypeId(), (Object)id)).findFirst().orElse(null);
        if (HussarUtils.isEmpty((Object)recordAI)) {
            recordAI = new RecordAI();
            recordAI.setTypeId(id);
            recordAI.setCreateTime(date);
            recordAI.setModifyTime(date);
            recordAI.setUnclearBudget("0");
            recordAI.setExistingPlan("0");
            recordAI.setClearRequirements("0");
            recordAI.setClearBiddingInformation("0");
        } else {
            recordAI.setModifyTime(date);
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("unclearBudgetKeyword", unclearBudgetKeys);
        queryMap.put("existingPlanKeyword", existingPlanKeys);
        queryMap.put("clearRequirementsKeyword", clearRequirementsKeys);
        queryMap.put("clearBiddingInformationKeyword", clearBiddingInfoKeys);
        List<String> recordContents = this.recordAIMapper.opportunityRecordContents(id);
        if (HussarUtils.isNotEmpty(recordContents)) {
            if (HussarUtils.isNotEmpty((Object)content)) {
                recordContents.add(0, content);
            }
            queryMap.put("recordContent", recordContents);
        } else {
            recordContents = new ArrayList<String>();
            if (HussarUtils.isNotEmpty((Object)content)) {
                recordContents.add(0, content);
            }
            queryMap.put("recordContent", recordContents);
        }
        if (HussarUtils.isNotEmpty(recordContents)) {
            String jsonBody = JSONObject.toJSONString(queryMap);
            Map resultMap = HttpClientUtil.post((String)url, (String)jsonBody, null);
            if (HussarUtils.isNotEmpty((Object)resultMap)) {
                RecordAIVo recordAIVo = (RecordAIVo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resultMap), RecordAIVo.class);
                return OpptyPortraitRecordAIServiceImpl.getRecordAI(recordAIVo, recordAI);
            }
            return recordAI;
        }
        return recordAI;
    }

    private static RecordAI getRecordAI(RecordAIVo recordAIVo, RecordAI recordAI) {
        if (HussarUtils.isNotEmpty((Object)recordAIVo.getBudget())) {
            recordAI.setBudget(recordAIVo.getBudget());
        }
        if (recordAIVo.getUnclearBudget().booleanValue()) {
            recordAI.setUnclearBudget("1");
        }
        if (recordAIVo.getExistingPlan().booleanValue()) {
            recordAI.setExistingPlan("1");
        }
        if (recordAIVo.getClearRequirements().booleanValue()) {
            recordAI.setClearRequirements("1");
        }
        if (recordAIVo.getClearBiddingInformation().booleanValue()) {
            recordAI.setClearBiddingInformation("1");
        }
        return recordAI;
    }
}

