/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.datamonitor.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.analysis.datamonitor.dao.DataMonitorIgnoreMapper;
import com.jxdinfo.crm.analysis.datamonitor.dto.DataMonitorIgnoreDto;
import com.jxdinfo.crm.analysis.datamonitor.model.DataMonitorIgnoreEntity;
import com.jxdinfo.crm.analysis.datamonitor.model.DataMonitorRuleEntity;
import com.jxdinfo.crm.analysis.datamonitor.service.IDataMonitorIgnoreService;
import com.jxdinfo.crm.analysis.datamonitor.service.IDataMonitorRuleService;
import com.jxdinfo.crm.analysis.datamonitor.vo.DataMonitorIgnoreVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.operaterecord.service.IOperateRecordAPIService;
import com.jxdinfo.crm.common.api.operaterecord.vo.OperateRecordAPIVo;
import com.jxdinfo.crm.core.api.contact.service.IContactAPIService;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.leads.service.ILeadsAPIService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataMonitorIgnoreServiceImpl
extends ServiceImpl<DataMonitorIgnoreMapper, DataMonitorIgnoreEntity>
implements IDataMonitorIgnoreService {
    @Resource
    private IDataMonitorRuleService dataMonitorRuleService;
    @Resource
    private DataMonitorIgnoreMapper dataMonitorIgnoreMapper;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private IContactAPIService contactAPIService;
    @Resource
    private ILeadsAPIService leadsAPIService;
    @Resource
    private IAgentApiService agentApiService;
    @Resource
    private IOperateRecordAPIService operateRecordAPIService;

    @Override
    @Transactional
    public Boolean addIgnoreData(List<DataMonitorIgnoreEntity> dataMonitorIgnoreEntityList) {
        Long ruleId = dataMonitorIgnoreEntityList.get(0).getRuleId();
        DataMonitorRuleEntity dataMonitorRuleEntity = (DataMonitorRuleEntity)this.dataMonitorRuleService.getById(ruleId);
        int ignoreCycle = ToolUtil.isNotEmpty((Object)dataMonitorRuleEntity.getIgnoreCycle()) ? Integer.parseInt(dataMonitorRuleEntity.getIgnoreCycle()) : 0;
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime date = LocalDateTime.now();
        ArrayList<OperateRecordAPIVo> operateRecordDOList = new ArrayList<OperateRecordAPIVo>();
        for (DataMonitorIgnoreEntity dataMonitorIgnoreEntity : dataMonitorIgnoreEntityList) {
            OperateRecordAPIVo operateRecordDO = new OperateRecordAPIVo();
            operateRecordDO.setContactId(dataMonitorRuleEntity.getRuleId());
            operateRecordDO.setTeamMemberName(dataMonitorRuleEntity.getRuleName());
            operateRecordDO.setRecordContent(dataMonitorIgnoreEntity.getIgnoreReson());
            operateRecordDO.setDelflag("0");
            operateRecordDO.setProduceType(RecordProductTypeEnum.PRODUCE_ADD_IGNORE_DATA.getId());
            operateRecordDO.setRecordId(Long.valueOf(CommonUtills.generateAssignId()));
            operateRecordDO.setBusinessType(dataMonitorRuleEntity.getTargetType());
            operateRecordDO.setTypeId(dataMonitorIgnoreEntity.getBusinessId());
            operateRecordDO.setBusinessName(dataMonitorIgnoreEntity.getBusinessName());
            operateRecordDO.setCreatePerson(user.getUserId());
            operateRecordDO.setCreatePersonName(user.getUserName());
            operateRecordDO.setCreateTime(date);
            operateRecordDO.setChangePerson(user.getUserId());
            operateRecordDO.setChangeTime(date);
            operateRecordDO.setChangePersonName(user.getUserName());
            operateRecordDO.setDelflag("0");
            operateRecordDO.setChangeBatch(1);
            operateRecordDOList.add(operateRecordDO);
        }
        this.operateRecordAPIService.saveOperateLogBatch(operateRecordDOList);
        for (DataMonitorIgnoreEntity dataMonitorIgnoreEntity : dataMonitorIgnoreEntityList) {
            dataMonitorIgnoreEntity.setCreateDepartment(user.getDeptId());
            dataMonitorIgnoreEntity.setCreateDepartmentName(user.getDeptName());
            dataMonitorIgnoreEntity.setDelFlag("0");
            dataMonitorIgnoreEntity.setCreateTime(LocalDateTime.now());
            dataMonitorIgnoreEntity.setLastTime(LocalDateTime.now());
            dataMonitorIgnoreEntity.setCreator(user.getUserId());
            dataMonitorIgnoreEntity.setCreatorName(user.getUserName());
            LocalDateTime todayTime = LocalDateTime.now();
            LocalDate today = todayTime.toLocalDate();
            LocalDate expireDate = today.plusDays(ignoreCycle);
            LocalTime localTime = todayTime.toLocalTime();
            LocalDateTime expireTime = LocalDateTime.of(expireDate, localTime);
            dataMonitorIgnoreEntity.setExpireTime(expireTime);
        }
        this.saveOrUpdateBatch(dataMonitorIgnoreEntityList);
        return true;
    }

    @Override
    public Page<DataMonitorIgnoreVo> getIgnoreDataList(DataMonitorIgnoreDto dto) {
        Page page = dto.getPage();
        SecurityUser user = BaseSecurityUtil.getUser();
        String businessIds = "";
        switch (dto.getTargetType()) {
            case "2": {
                List opptyList = this.opportunityAPIService.getOpportunityIdList();
                if (!ToolUtil.isNotEmpty((Object)opptyList)) break;
                businessIds = opptyList.stream().map(Object::toString).collect(Collectors.joining(","));
                break;
            }
            case "1": {
                List customerList = this.customerAPIService.getCustomerIdList();
                if (!ToolUtil.isNotEmpty((Object)customerList)) break;
                businessIds = customerList.stream().map(Object::toString).collect(Collectors.joining(","));
                break;
            }
            case "3": {
                List contactList = this.contactAPIService.getContactIdList();
                if (!ToolUtil.isNotEmpty((Object)contactList)) break;
                businessIds = contactList.stream().map(Object::toString).collect(Collectors.joining(","));
                break;
            }
            case "4": {
                List leadsList = this.leadsAPIService.getLeadsIdList();
                if (!ToolUtil.isNotEmpty((Object)leadsList)) break;
                businessIds = leadsList.stream().map(Object::toString).collect(Collectors.joining(","));
                break;
            }
            case "17": {
                List agentList = this.agentApiService.getAgentIdList();
                if (!ToolUtil.isNotEmpty((Object)agentList)) break;
                businessIds = agentList.stream().map(Object::toString).collect(Collectors.joining(","));
                break;
            }
        }
        List<DataMonitorIgnoreVo> list = this.dataMonitorIgnoreMapper.getIgnoreDataList(dto, businessIds, (Page<DataMonitorIgnoreVo>)page);
        List<Long> businessIdList = list.stream().map(DataMonitorIgnoreEntity::getBusinessId).collect(Collectors.toList());
        if (ToolUtil.isNotEmpty(businessIdList)) {
            List<Map<String, Object>> mapList = this.dataMonitorIgnoreMapper.getChargePersonAndDeptByBusinessIdList(businessIdList);
            for (Map<String, Object> map : mapList) {
                if (!ToolUtil.isNotEmpty((Object)map.get("CHARGE_PERSON_ID"))) continue;
                Long id = (Long)map.get("BUSINESS_ID");
                List voList = list.stream().filter(ignoreVo -> ignoreVo.getBusinessId().equals(id)).collect(Collectors.toList());
                for (DataMonitorIgnoreVo vo : voList) {
                    vo.setChargePerson((Long)map.get("CHARGE_PERSON_ID"));
                    vo.setChargePersonName((String)map.get("CHARGE_PERSON_NAME"));
                    vo.setOwnDepartment((Long)map.get("OWN_DEPARTMENT"));
                    vo.setOwnDepartmentName((String)map.get("OWN_DEPARTMENT_NAME"));
                }
            }
        }
        page.setRecords(list);
        return page;
    }

    @Override
    @Transactional
    public Boolean deleteIgnoreData(List<String> dataIdList) {
        ArrayList<DataMonitorIgnoreEntity> dataMonitorIgnoreEntityList = new ArrayList<DataMonitorIgnoreEntity>();
        for (String dataId : dataIdList) {
            DataMonitorIgnoreEntity dataMonitorIgnoreEntity = new DataMonitorIgnoreEntity();
            dataMonitorIgnoreEntity.setDataId(Long.parseLong(dataId));
            dataMonitorIgnoreEntity.setDelFlag("1");
            dataMonitorIgnoreEntityList.add(dataMonitorIgnoreEntity);
        }
        this.saveOrUpdateBatch(dataMonitorIgnoreEntityList);
        return true;
    }

    @Override
    public Boolean deleteIgnoreDataByExpireTime() {
        List list = this.list();
        ArrayList<String> deleteIdList = new ArrayList<String>();
        for (DataMonitorIgnoreEntity dataMonitorIgnoreEntity : list) {
            LocalDate expireDate;
            LocalDateTime currentTime = LocalDateTime.now();
            LocalDateTime expireTime = dataMonitorIgnoreEntity.getExpireTime();
            LocalDate currentDate = currentTime.toLocalDate();
            if (!currentDate.isEqual(expireDate = expireTime.toLocalDate()) && !currentDate.isAfter(expireDate)) continue;
            deleteIdList.add(dataMonitorIgnoreEntity.getDataId().toString());
        }
        return this.deleteIgnoreData(deleteIdList);
    }
}

