/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.customerprofile.job.service.impl;

import com.jxdinfo.crm.analysis.customerprofile.dao.CustomerProfileMapper;
import com.jxdinfo.crm.analysis.customerprofile.job.service.CustomerAutoLabelService;
import com.jxdinfo.crm.analysis.customerprofile.service.ICustomerProfileService;
import com.jxdinfo.crm.analysis.customerprofile.service.ISingleCustomerMetricsService;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerActivityLevelVo;
import com.jxdinfo.crm.analysis.customerprofile.vo.CustomerFollowUpMonthsVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.opportunity.dto.OpportunityQueryDto;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerAutoLabelServiceImpl
implements CustomerAutoLabelService {
    @Resource
    private ICustomerAPIService customerApiService;
    @Resource
    private ILabelService labelService;
    @Resource
    private ICustomerProfileService customerProfileService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private CustomerProfileMapper customerProfileMapper;
    @Resource
    private ISingleCustomerMetricsService singleCustomerMetricsService;

    @Override
    @Transactional
    public ProcessResult customerAutoLabel() {
        HashMap<String, List<Long>> customerIdsMap = new HashMap<String, List<Long>>();
        List<Long> gwlzCustomerList = this.getGwlzCustomerList();
        List<Long> gwbdCustomerList = this.getCustomerByConsultationMethods(Collections.singletonList("1"));
        gwlzCustomerList.addAll(gwbdCustomerList);
        HashSet<Long> longHashSet = new HashSet<Long>(gwlzCustomerList);
        gwbdCustomerList = new ArrayList<Long>(longHashSet);
        customerIdsMap.put("848161189874900992", gwbdCustomerList);
        List<Long> qywxCustomerList = this.getCustomerByConsultationMethods(Collections.singletonList("4"));
        customerIdsMap.put("848161189954592768", qywxCustomerList);
        List<Long> customer400List = this.getCustomerByConsultationMethods(Collections.singletonList("5"));
        customerIdsMap.put("848161189975564288", customer400List);
        List<Long> qtbdCustomerList = this.getCustomerByConsultationMethods(Collections.singletonList("3"));
        customerIdsMap.put("848161189929426944", qtbdCustomerList);
        List<Long> dhCustomerList = this.getCustomerByConsultationMethods(Collections.singletonList("8"));
        customerIdsMap.put("848161190051061760", dhCustomerList);
        List<Long> zxzxCustomerList = this.getCustomerByConsultationMethods(Collections.singletonList("7"));
        customerIdsMap.put("848161190025895936", zxzxCustomerList);
        List<Long> affCustomerList = this.getCustomerByConsultationMethods(Collections.singletonList("6"));
        customerIdsMap.put("848161190000730112", affCustomerList);
        List<Long> jmyCustomerList = this.getCustomerByConsultationMethods(Collections.singletonList("2"));
        customerIdsMap.put("848161189904261120", jmyCustomerList);
        LocalDate dateNow = LocalDate.now();
        ArrayList<Long> highFrequencyCustomerList = new ArrayList<Long>();
        ArrayList<Long> relativelyCustomerList = new ArrayList<Long>();
        ArrayList<Long> normalCustomerList = new ArrayList<Long>();
        ArrayList<Long> notActiveCustomerList = new ArrayList<Long>();
        Map<Long, CustomerActivityLevelVo> activityLevelVos = this.customerProfileService.getCustomerActivityLevel();
        List<CustomerFollowUpMonthsVo> customerFollowUpMonths = this.customerProfileMapper.selectCustomerFollowUpMonths();
        Map<Long, List> cusMonthMap = customerFollowUpMonths.stream().collect(Collectors.groupingBy(CustomerFollowUpMonthsVo::getCustomerId, Collectors.collectingAndThen(Collectors.toList(), list -> list.stream().sorted(Comparator.comparing(CustomerFollowUpMonthsVo::getRecordCreateMonth)).collect(Collectors.toList()))));
        HashMap<Long, Integer> cusMonthCountMap = new HashMap<Long, Integer>();
        for (Map.Entry<Long, List> entry : cusMonthMap.entrySet()) {
            Long customerId = entry.getKey();
            LocalDateTime successTime = activityLevelVos.get(customerId).getLastSuccessDate();
            int countMonth = 1;
            YearMonth dateTemp = YearMonth.from(((CustomerFollowUpMonthsVo)entry.getValue().get(0)).getRecordCreateMonth());
            for (CustomerFollowUpMonthsVo monthsVo : entry.getValue()) {
                if (successTime != null && !successTime.isAfter(monthsVo.getRecordCreateMonth()) || !dateTemp.isBefore(YearMonth.from(monthsVo.getRecordCreateMonth()))) continue;
                ++countMonth;
                dateTemp = YearMonth.from(monthsVo.getRecordCreateMonth());
            }
            cusMonthCountMap.put(customerId, countMonth);
        }
        double tempComAvg = 0.0;
        int i = 0;
        for (Map.Entry<Long, CustomerActivityLevelVo> entry : activityLevelVos.entrySet()) {
            CustomerActivityLevelVo vo = entry.getValue();
            if (vo.getFirstRecordTime() == null || vo.getLastSuccessDate() == null) continue;
            double d = ((Integer)cusMonthCountMap.get(entry.getKey())).intValue();
            tempComAvg += (double)vo.getCountRecord().intValue() / d;
            ++i;
        }
        double companyAvgTrack = 0.0;
        if (i > 0) {
            companyAvgTrack = tempComAvg / (double)i;
        }
        this.crmBaseConfigBoService.updateConfigValue(String.format("%.0f", companyAvgTrack), "common_customer_monthly_track");
        for (Map.Entry entry : activityLevelVos.entrySet()) {
            long avgRecord;
            Long customerId = (Long)entry.getKey();
            CustomerActivityLevelVo vo = (CustomerActivityLevelVo)entry.getValue();
            if (cusMonthCountMap.get(entry.getKey()) == null || vo.getCountRecord() == null) {
                avgRecord = 0L;
            } else {
                double monthBetween = ((Integer)cusMonthCountMap.get(entry.getKey())).intValue();
                avgRecord = (long)Math.ceil((double)vo.getCountRecord().intValue() / monthBetween);
            }
            if (vo.getLastRecordTime() == null) {
                notActiveCustomerList.add(customerId);
                continue;
            }
            if (vo.getCountContact() > 5 && vo.getLastRecordTime().toLocalDate().plusWeeks(1L).isAfter(dateNow) && (double)avgRecord > companyAvgTrack) {
                highFrequencyCustomerList.add(customerId);
                continue;
            }
            if (vo.getCountContact() > 3 && vo.getLastRecordTime().toLocalDate().plusWeeks(2L).isAfter(dateNow) && (double)avgRecord > companyAvgTrack) {
                relativelyCustomerList.add(customerId);
                continue;
            }
            if (vo.getCountContact() > 0 && vo.getLastRecordTime().toLocalDate().plusMonths(1L).isAfter(dateNow)) {
                normalCustomerList.add(customerId);
                continue;
            }
            notActiveCustomerList.add(customerId);
        }
        customerIdsMap.put("848161404925255680", highFrequencyCustomerList);
        customerIdsMap.put("848161404954615808", relativelyCustomerList);
        customerIdsMap.put("848161404979781632", normalCustomerList);
        customerIdsMap.put("848161405004947456", notActiveCustomerList);
        List<Long> campaignIdList1 = this.customerProfileMapper.selectCustomerOpptyJoinCampaign();
        List<Long> list2 = this.customerProfileMapper.selectCustomerJoinCampaign();
        campaignIdList1.addAll(list2);
        HashSet<Long> set = new HashSet<Long>(campaignIdList1);
        campaignIdList1 = new ArrayList<Long>(set);
        customerIdsMap.put("848204476384026624", campaignIdList1);
        HashMap<Long, List<String>> aiTagsMap = new HashMap<Long, List<String>>();
        this.getCustomerLabelMap(customerIdsMap, aiTagsMap);
        ArrayList aiTagMapList = new ArrayList();
        for (Map.Entry entry : aiTagsMap.entrySet()) {
            HashMap map = new HashMap();
            map.put("id", entry.getKey());
            map.put("aiTag", StringUtils.join((Collection)((Collection)entry.getValue()), (String)","));
            aiTagMapList.add(map);
        }
        this.customerApiService.updateAiTags(aiTagMapList);
        return new ProcessResult(true);
    }

    private List<Long> getGwlzCustomerList() {
        OpportunityQueryDto dto = new OpportunityQueryDto();
        dto.setOpportunityName("\u5b98\u7f51");
        dto.setCreatePerson("\u7cfb\u7edf");
        return this.customerApiService.selectCustomerByOpportunity(dto);
    }

    private List<Long> getCustomerByConsultationMethods(List<String> consultationMethods) {
        OpportunityQueryDto dto = new OpportunityQueryDto();
        dto.setConsultationMethodsList(consultationMethods);
        return this.customerApiService.selectCustomerByOpportunity(dto);
    }

    private void getCustomerLabelMap(Map<String, List<Long>> customerIds, Map<Long, List<String>> aiTagsMap) {
        for (Map.Entry<String, List<Long>> entry : customerIds.entrySet()) {
            for (Long customerId : entry.getValue()) {
                if (aiTagsMap.containsKey(customerId)) {
                    aiTagsMap.get(customerId).add(entry.getKey());
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                list.add(entry.getKey());
                aiTagsMap.put(customerId, list);
            }
        }
    }
}

