/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.unify.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.unify.dto.IncreaseStatisticsDto;
import com.jxdinfo.crm.analysis.unify.dto.ProductPenetrateDto;
import com.jxdinfo.crm.analysis.unify.dto.UnifyPortalAnalysisDto;
import com.jxdinfo.crm.analysis.unify.service.OpportunityAndAnalysisService;
import com.jxdinfo.crm.analysis.unify.service.PortalStatisticsService;
import com.jxdinfo.crm.analysis.unify.service.UnifyPortalService;
import com.jxdinfo.crm.analysis.unify.vo.PortalFunnelVo;
import com.jxdinfo.crm.analysis.unify.vo.PortalIncreaseVo;
import com.jxdinfo.crm.analysis.unify.vo.PortalProductSaleVo;
import com.jxdinfo.crm.analysis.unify.vo.PortalProvinceSaleVo;
import com.jxdinfo.crm.analysis.unify.vo.PortalProvinceSaleVo2;
import com.jxdinfo.crm.analysis.unify.vo.ProductContractAmountVo;
import com.jxdinfo.crm.core.common.service.CommonService;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmopportunitystage1.model.CrmOpportunityStage1;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.vo.OpportunityEntityVo;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.scene.dto.CrmSceneDto;
import com.jxdinfo.crm.core.scene.vo.CrmSceneVo;
import com.jxdinfo.crm.core.unify.vo.ExcelStageVo;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.model.DicType;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.audit.core.annotations.AuditLog;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventGrade;
import com.jxdinfo.hussar.support.audit.core.enums.AuditEventType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/unify/portal"})
@Api(tags={"\u7edf\u4e00\u95e8\u6237"})
public class UnifyPortalController {
    @Resource
    private UnifyPortalService unifyPortalService;
    @Resource
    private CommonService commonService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private PortalStatisticsService portalStatisticsService;
    @Resource
    private ProductService productService;
    @Resource
    private OpportunityAndAnalysisService opportunityAndAnalysisService;

    @PostMapping(value={"/province"})
    @ApiOperation(value="\u67e5\u8be2\u7701\u533a\u9500\u552e\u5206\u6790\u62a5\u8868", notes="\u67e5\u8be2\u7701\u533a\u9500\u552e\u5206\u6790\u62a5\u8868")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u7edf\u4e00\u95e8\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<PortalProvinceSaleVo> provinceCount(@RequestBody @ApiParam(value="\u9500\u552e\u7b80\u62a5dto") SalesStatisticsDto dto) {
        return ApiResponse.success((Object)this.unifyPortalService.provinceCount(dto));
    }

    @PostMapping(value={"/getAllCustomerStage"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5728\u4f7f\u7528\u7684\u5546\u673a\u9636\u6bb5", notes="\u83b7\u53d6\u6240\u6709\u5728\u4f7f\u7528\u7684\u5546\u673a\u9636\u6bb5")
    @AuditLog(moduleName="\u667a\u80fd\u5206\u6790-\u5546\u673a\u5206\u5e03\u7edf\u8ba1", eventDesc="\u90e8\u95e8\u7edf\u8ba1\u8868\u683c", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<CrmOpportunityStage1>> getAllCustomerStage() {
        return ApiResponse.success(this.unifyPortalService.getAllCustomerStage());
    }

    @PostMapping(value={"/province2"})
    @ApiOperation(value="\u67e5\u8be2\u7701\u533a\u9500\u552e\u5206\u6790\u62a5\u8868", notes="\u67e5\u8be2\u7701\u533a\u9500\u552e\u5206\u6790\u62a5\u8868")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u7edf\u4e00\u95e8\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<PortalProvinceSaleVo2>> provinceCount2(@RequestBody @ApiParam(value="\u9500\u552e\u7b80\u62a5dto") SalesStatisticsDto dto) {
        return ApiResponse.success(this.unifyPortalService.provinceCount2(dto));
    }

    @PostMapping(value={"/product"})
    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u9500\u552e\u5206\u6790\u62a5\u8868", notes="\u67e5\u8be2\u4ea7\u54c1\u9500\u552e\u5206\u6790\u62a5\u8868")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u7edf\u4e00\u95e8\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<PortalProductSaleVo> productCount(@RequestBody @ApiParam(value="\u9500\u552e\u7b80\u62a5dto") SalesStatisticsDto dto) {
        return ApiResponse.success((Object)this.unifyPortalService.productCount(dto));
    }

    @PostMapping(value={"/funnel"})
    @ApiOperation(value="\u9500\u552e\u6f0f\u6597\u5206\u6790", notes="\u9500\u552e\u6f0f\u6597\u5206\u6790")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u7edf\u4e00\u95e8\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<PortalFunnelVo> funnel(@RequestBody @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SalesStatisticsDto dto) {
        return ApiResponse.success((Object)this.unifyPortalService.funnel(dto));
    }

    @PostMapping(value={"/funnelForecastAmount"})
    @ApiOperation(value="\u9500\u552e\u6f0f\u6597\u5206\u6790-\u9884\u6d4b\u5546\u673a\u91d1\u989d", notes="\u9500\u552e\u6f0f\u6597\u5206\u6790-\u9884\u6d4b\u5546\u673a\u91d1\u989d")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u9500\u552e\u6f0f\u6597\u5206\u6790-\u9884\u6d4b\u5546\u673a\u91d1\u989d", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<String> funnelForecastAmount(@RequestBody @ApiParam(value="\u67e5\u8be2\u6761\u4ef6") SalesStatisticsDto dto) {
        String forecastAmount = this.unifyPortalService.funnelForecastAmount(dto);
        ApiResponse response = ApiResponse.success();
        if (StringUtil.isEmpty((Object)forecastAmount)) {
            forecastAmount = "0.00";
        }
        response.setData((Object)forecastAmount);
        return response;
    }

    @PostMapping(value={"/increase"})
    @ApiOperation(value="\u83b7\u53d6\u9500\u552e\u7b80\u62a5", notes="\u83b7\u53d6\u9500\u552e\u7b80\u62a5")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u83b7\u53d6\u9500\u552e\u7b80\u62a5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<PortalIncreaseVo> increase(@RequestBody @ApiParam(value="\u9500\u552e\u7b80\u62a5dto") SalesStatisticsDto dto) {
        return ApiResponse.success((Object)this.unifyPortalService.increase(dto));
    }

    @PostMapping(value={"/increase/byTimeRanges"})
    @ApiOperation(value="\u83b7\u53d6\u9500\u552e\u7b80\u62a5(\u65f6\u95f4\u8303\u56f4\u591a\u9009)", notes="\u83b7\u53d6\u9500\u552e\u7b80\u62a5")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u83b7\u53d6\u9500\u552e\u7b80\u62a5", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<PortalIncreaseVo>> increaseByTimeRanges(@RequestBody @ApiParam(value="\u9500\u552e\u7b80\u62a5dto") IncreaseStatisticsDto dto) {
        return ApiResponse.success(this.unifyPortalService.increaseByTimeRanges(dto));
    }

    @PostMapping(value={"/selectListByTypeName"})
    @ApiOperation(value="\u6839\u636eTypeName\u67e5\u8be2\u96c6\u5408", notes="\u6839\u636eTypeName\u67e5\u8be2\u96c6\u5408")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u6839\u636eTypeName\u67e5\u8be2\u96c6\u5408", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<DicSingle>> selectListByTypeName(@RequestBody @ApiParam(value="\u6570\u636e\u5b57\u5178\u7c7b\u578b\u5b9e\u4f53") DicType dicType) {
        return ApiResponse.success((Object)this.sysDicRefService.getDictByType(dicType.getTypeName()));
    }

    @PostMapping(value={"/getProductList"})
    @ApiOperation(value="\u83b7\u53d6\u4ea7\u54c1\u5217\u8868", notes="\u83b7\u53d6\u4ea7\u54c1\u5217\u8868")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u83b7\u53d6\u4ea7\u54c1\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Map<String, Object>> getProductList() {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        List list = this.productService.selectProductForPortal();
        result.put("count", list.size());
        result.put("data", list);
        result.put("code", "0");
        return ApiResponse.success(result);
    }

    @PostMapping(value={"/funnelExcel"})
    @ApiOperation(value="\u4ea7\u54c1\u5546\u673a\u5206\u5e03", notes="\u4ea7\u54c1\u5546\u673a\u5206\u5e03")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u4ea7\u54c1\u5546\u673a\u5206\u5e03", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ExcelStageVo>> funnelExcel(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.unifyPortalService.funnelExcel(dto));
    }

    @PostMapping(value={"/getSalesHelper"})
    @ApiOperation(value="\u83b7\u53d6\u9500\u552e\u52a9\u624b", notes="\u83b7\u53d6\u9500\u552e\u52a9\u624b")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u83b7\u53d6\u9500\u552e\u52a9\u624b", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Map<String, Object>> getSalesHelper() {
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        Map<String, String> data = this.unifyPortalService.salesHelper(new SalesStatisticsDto());
        result.put("code", "0");
        result.put("data", data);
        return ApiResponse.success(result);
    }

    @PostMapping(value={"saleOpportunityList"})
    @ApiOperation(value="\u9500\u552e\u7b80\u62a5\u5546\u673a\u5217\u8868", notes="\u9500\u552e\u7b80\u62a5\u5546\u673a\u5217\u8868")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u9500\u552e\u7b80\u62a5\u5546\u673a\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityEntity>> saleOpportunityList(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.unifyPortalService.saleOpportunityList(dto));
    }

    @PostMapping(value={"saleProductList"})
    @ApiOperation(value="\u9500\u552e\u7b80\u62a5\u4ea7\u54c1\u5217\u8868", notes="\u9500\u552e\u7b80\u62a5\u4ea7\u54c1\u5217\u8868")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u9500\u552e\u7b80\u62a5\u4ea7\u54c1\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityEntityVo>> saleProductList(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.unifyPortalService.saleProductList(dto));
    }

    @GetMapping(value={"/getOpportunitiesRange"})
    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u5546\u673a\u8303\u56f4", notes="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u5546\u673a\u8303\u56f4")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u83b7\u53d6\u7528\u6237\u7ba1\u7406\u5546\u673a\u8303\u56f4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Map<String, Object>> getString() {
        return ApiResponse.success(this.portalStatisticsService.getOpportunitiesRange());
    }

    @GetMapping(value={"/getPopUpTerm"})
    @ApiOperation(value="\u83b7\u53d6\u95e8\u6237\u53cb\u60c5\u63d0\u793a\u5f39\u7a97\u4e0d\u518d\u63d0\u793a\u65f6\u95f4", notes="\u83b7\u53d6\u95e8\u6237\u53cb\u60c5\u63d0\u793a\u5f39\u7a97\u4e0d\u518d\u63d0\u793a\u65f6\u95f4")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u83b7\u53d6\u95e8\u6237\u53cb\u60c5\u63d0\u793a\u5f39\u7a97\u4e0d\u518d\u63d0\u793a\u65f6\u95f4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<LocalDateTime> getPopUpTerm() {
        return ApiResponse.success((Object)this.portalStatisticsService.getPopUpTerm());
    }

    @GetMapping(value={"/updatePopUpTerm"})
    @ApiOperation(value="\u4fee\u6539\u95e8\u6237\u53cb\u60c5\u63d0\u793a\u5f39\u7a97\u4e0d\u518d\u63d0\u793a\u65f6\u95f4", notes="\u4fee\u6539\u95e8\u6237\u53cb\u60c5\u63d0\u793a\u5f39\u7a97\u4e0d\u518d\u63d0\u793a\u65f6\u95f4")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u4fee\u6539\u95e8\u6237\u53cb\u60c5\u63d0\u793a\u5f39\u7a97\u4e0d\u518d\u63d0\u793a\u65f6\u95f4", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.UPDATE)
    public ApiResponse<Boolean> updatePopUpTerm() {
        return ApiResponse.success((Object)this.portalStatisticsService.updatePopUpTerm());
    }

    @PostMapping(value={"funnelExcelProductList"})
    @ApiOperation(value="\u4ea7\u54c1\u5546\u673a\u5206\u5e03-\u4ea7\u54c1\u5217\u8868", notes="\u4ea7\u54c1\u5546\u673a\u5206\u5e03-\u4ea7\u54c1\u5217\u8868")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u4ea7\u54c1\u5546\u673a\u5206\u5e03-\u4ea7\u54c1\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityEntityVo>> funnelExcelProductList(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.unifyPortalService.funnelExcelProductList(dto));
    }

    @PostMapping(value={"/productList/{permissions}"})
    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u9500\u552e\u5206\u6790\u62a5\u8868\u5217\u8868", notes="\u67e5\u8be2\u4ea7\u54c1\u9500\u552e\u5206\u6790\u62a5\u8868\u5217\u8868")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u7edf\u4e00\u95e8\u6237", eventGrade=AuditEventGrade.SERVICE_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityEntityVo>> productList(@PathVariable(value="permissions") String permissions, @RequestBody @ApiParam(value="\u9500\u552e\u7b80\u62a5dto") SalesStatisticsDto dto) {
        return ApiResponse.success(this.unifyPortalService.productList(permissions, dto));
    }

    @PostMapping(value={"provincialSalesAnalysisList"})
    @ApiOperation(value="\u7701\u533a\u9500\u552e\u5206\u6790\u5217\u8868", notes="\u7701\u533a\u9500\u552e\u5206\u6790\u5217\u8868")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u7701\u533a\u9500\u552e\u5206\u6790\u5217\u8868", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityEntity>> provincialSalesAnalysisList(@RequestBody SalesStatisticsDto dto) {
        return ApiResponse.success(this.unifyPortalService.provincialSalesAnalysisList(dto));
    }

    @PostMapping(value={"/addOrUpdateScene"})
    @ApiOperation(value="\u9996\u9875\u95e8\u6237\u4fdd\u5b58\u9ed8\u8ba4\u67e5\u8be2\u6761\u4ef6", notes="\u9996\u9875\u95e8\u6237\u4fdd\u5b58\u9ed8\u8ba4\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u9996\u9875\u95e8\u6237\u4fdd\u5b58\u9ed8\u8ba4\u67e5\u8be2\u6761\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.INSERT)
    public ApiResponse<Boolean> addOrUpdateScene(@RequestBody CrmSceneDto dto) {
        return ApiResponse.success((Object)this.unifyPortalService.addOrUpdateScene(dto));
    }

    @GetMapping(value={"/deleteScene"})
    @ApiOperation(value="\u9996\u9875\u95e8\u6237\u5220\u9664\u9ed8\u8ba4\u67e5\u8be2\u6761\u4ef6", notes="\u9996\u9875\u95e8\u6237\u5220\u9664\u9ed8\u8ba4\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u9996\u9875\u95e8\u6237\u5220\u9664\u9ed8\u8ba4\u67e5\u8be2\u6761\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.DELETE)
    public ApiResponse<Boolean> deleteScene(@RequestParam(value="module") String module) {
        return ApiResponse.success((Object)this.unifyPortalService.deleteScene(module));
    }

    @GetMapping(value={"/getScene"})
    @ApiOperation(value="\u67e5\u8be2\u9996\u9875\u95e8\u6237\u9ed8\u8ba4\u67e5\u8be2\u6761\u4ef6", notes="\u67e5\u8be2\u9996\u9875\u95e8\u6237\u9ed8\u8ba4\u67e5\u8be2\u6761\u4ef6")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u67e5\u8be2\u9996\u9875\u95e8\u6237\u9ed8\u8ba4\u67e5\u8be2\u6761\u4ef6", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<CrmSceneVo> getScene(@RequestParam(value="module") String module) {
        return ApiResponse.success((Object)this.unifyPortalService.getScene(module));
    }

    @PostMapping(value={"/productContractAmount"})
    @ApiOperation(value="\u4ea7\u54c1\u9500\u552e\u6982\u89c8", notes="\u4ea7\u54c1\u9500\u552e\u6982\u89c8")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u4ea7\u54c1\u9500\u552e\u6982\u89c8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<List<ProductContractAmountVo>> portalProductContractAmount(@RequestBody UnifyPortalAnalysisDto dto) {
        return ApiResponse.success(this.unifyPortalService.portalProductContractAmount(dto));
    }

    @PostMapping(value={"/productContractPenetrate"})
    @ApiOperation(value="\u7a7f\u900f\u5f39\u7a97", notes="\u7a7f\u900f\u5f39\u7a97")
    @AuditLog(moduleName="\u7edf\u4e00\u95e8\u6237", eventDesc="\u4ea7\u54c1\u9500\u552e\u6982\u89c8", eventGrade=AuditEventGrade.SYSTEM_LOG_TYPE, evnetType=AuditEventType.QUERY)
    public ApiResponse<Page<OpportunityEntityVo>> productContractPenetrate(@RequestBody ProductPenetrateDto dto) {
        return ApiResponse.success(this.unifyPortalService.productContractPenetrate(dto));
    }
}

