/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.opportunityportrait.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.analysis.opportunityportrait.dao.OpportunityPortraitScoreMapper;
import com.jxdinfo.crm.analysis.opportunityportrait.dto.OpportunityPortraitDto;
import com.jxdinfo.crm.analysis.opportunityportrait.job.service.IOpptyPortraitCalculateService;
import com.jxdinfo.crm.analysis.opportunityportrait.job.service.IOpptyPortraitRecordAIService;
import com.jxdinfo.crm.analysis.opportunityportrait.model.OpptyPortraitScore;
import com.jxdinfo.crm.analysis.opportunityportrait.service.IOpportunityPortraitService;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.DimensionVo;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.OpptyPortraitScoreVo;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.OpptyScoreLevelVo;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.ScoreLevelRangeVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.service.OpportunityService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class OpportunityPortraitServiceImpl
extends ServiceImpl<OpportunityPortraitScoreMapper, OpptyPortraitScore>
implements IOpportunityPortraitService {
    @Resource
    private IOpptyPortraitCalculateService opptyPortraitCalculateService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private OpportunityService opportunityService;
    @Resource
    private IOpptyPortraitRecordAIService opptyPortraitRecordAIService;

    @Override
    public List<OpptyPortraitScoreVo> selectPortraitInfo(String opportunityId) {
        boolean portraitFlag = "1".equals(this.crmBaseConfigBoService.getCrmBaseConfigByKey("opportunity_portrait_switch").getConfigValue());
        if (!portraitFlag) {
            return new ArrayList<OpptyPortraitScoreVo>();
        }
        List list = this.list((Wrapper)new LambdaQueryWrapper().eq(OpptyPortraitScore::getOpportunityId, (Object)opportunityId));
        List copy = BeanUtil.copy((Collection)list, OpptyPortraitScoreVo.class);
        DimensionVo budgetConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_budget").getConfigValue(), DimensionVo.class);
        DimensionVo authorityConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_authority").getConfigValue(), DimensionVo.class);
        DimensionVo needConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_need").getConfigValue(), DimensionVo.class);
        DimensionVo timeConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_time").getConfigValue(), DimensionVo.class);
        DimensionVo competitorConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_competitor").getConfigValue(), DimensionVo.class);
        for (OpptyPortraitScoreVo next : copy) {
            if (HussarUtils.equals((Object)"dimension_budget", (Object)next.getScopeDimension())) {
                next.setScoreStandard(budgetConfig.getScoreStandard());
                next.setDimensionName(budgetConfig.getName());
                if (HussarUtils.isNotEmpty((Object)next.getArtificialScore())) {
                    next.setFinalScore(next.getArtificialScore());
                    continue;
                }
                next.setFinalScore(next.getSystemScore());
                continue;
            }
            if (HussarUtils.equals((Object)"dimension_authority", (Object)next.getScopeDimension())) {
                next.setScoreStandard(authorityConfig.getScoreStandard());
                next.setDimensionName(authorityConfig.getName());
                if (HussarUtils.isNotEmpty((Object)next.getArtificialScore())) {
                    next.setFinalScore(next.getArtificialScore());
                    continue;
                }
                next.setFinalScore(next.getSystemScore());
                continue;
            }
            if (HussarUtils.equals((Object)"dimension_need", (Object)next.getScopeDimension())) {
                next.setScoreStandard(needConfig.getScoreStandard());
                next.setDimensionName(needConfig.getName());
                if (HussarUtils.isNotEmpty((Object)next.getArtificialScore())) {
                    next.setFinalScore(next.getArtificialScore());
                    continue;
                }
                next.setFinalScore(next.getSystemScore());
                continue;
            }
            if (HussarUtils.equals((Object)"dimension_time", (Object)next.getScopeDimension())) {
                next.setScoreStandard(timeConfig.getScoreStandard());
                next.setDimensionName(timeConfig.getName());
                if (HussarUtils.isNotEmpty((Object)next.getArtificialScore())) {
                    next.setFinalScore(next.getArtificialScore());
                    continue;
                }
                next.setFinalScore(next.getSystemScore());
                continue;
            }
            if (!HussarUtils.equals((Object)"dimension_competitor", (Object)next.getScopeDimension())) continue;
            next.setScoreStandard(competitorConfig.getScoreStandard());
            next.setDimensionName(competitorConfig.getName());
            if (HussarUtils.isNotEmpty((Object)next.getArtificialScore())) {
                next.setFinalScore(next.getArtificialScore());
                continue;
            }
            next.setFinalScore(next.getSystemScore());
        }
        this.sortScoreListByOrderNumber(copy);
        copy.sort(Comparator.comparing(OpptyPortraitScoreVo::getOrder));
        return copy;
    }

    @Override
    @HussarTransactional
    public Boolean refreshPortrait(OpportunityPortraitDto dto) {
        List<Long> ids = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(dto.getOpportunityIds())) {
            ids = dto.getOpportunityIds().stream().map(Long::valueOf).collect(Collectors.toList());
        }
        if (HussarUtils.isNotEmpty(ids)) {
            this.opptyPortraitRecordAIService.calculateRecordAIList(null, ids);
            ProcessResult processResult = this.opptyPortraitCalculateService.calculateOpptyPortraitScore(ids);
            return processResult.isSuccess();
        }
        return false;
    }

    @Override
    @HussarTransactional
    public Boolean correctPortrait(OpportunityPortraitDto dto) {
        List<OpptyPortraitScore> list = dto.getOpptyPortraitScoreList();
        Iterator<OpptyPortraitScore> iterator = list.iterator();
        SecurityUser user = BaseSecurityUtil.getUser();
        LocalDateTime now = LocalDateTime.now();
        String opportunityId = dto.getOpportunityId();
        OpportunityEntity opportunity = (OpportunityEntity)this.opportunityService.getById((Serializable)((Object)opportunityId));
        CrmBaseConfigVo crmBaseConfigByKey = this.crmBaseConfigBoService.getCrmBaseConfigByKey("oppty_score_level");
        List<ScoreLevelRangeVo> scoreLevelRnageVoList = ((OpptyScoreLevelVo)JSONObject.parseObject((String)crmBaseConfigByKey.getConfigValue(), OpptyScoreLevelVo.class)).getScoreLevelRangeVoList();
        while (iterator.hasNext()) {
            OpptyPortraitScore next = iterator.next();
            OpptyPortraitScore scoreTemp = (OpptyPortraitScore)this.getById(next.getPortraitId());
            if (HussarUtils.isNotEmpty((Object)next.getArtificialScore())) {
                if (!next.getArtificialScore().equals(scoreTemp.getArtificialScore())) {
                    this.correctionBasisToConclusion(next);
                    next.setChangeTime(now);
                    next.setCorrector(user.getUserId());
                    next.setCorrectorName(user.getUserName());
                }
                this.saveOrUpdateBatch(list);
                continue;
            }
            if (!HussarUtils.isNotEmpty((Object)scoreTemp.getArtificialScore())) continue;
            next.setArtificialScore(null);
            next.setCorrector(null);
            next.setCorrectorName("");
            this.saveOrUpdateBatch(list);
            this.opptyPortraitCalculateService.calculateOpptyPortraitScore(Collections.singletonList(next.getOpportunityId()));
        }
        List portraitScoreList = this.list((Wrapper)new LambdaQueryWrapper().eq(OpptyPortraitScore::getOpportunityId, (Object)opportunityId));
        double targetValue = portraitScoreList.stream().mapToDouble(score -> score.getArtificialScore() != null ? score.getArtificialScore() : score.getSystemScore()).sum();
        for (ScoreLevelRangeVo range : scoreLevelRnageVoList) {
            int[] value = range.getValue();
            if (!((double)value[0] <= targetValue) || !(targetValue <= (double)value[1])) continue;
            opportunity.setWinPossibility(range.getName());
        }
        this.opportunityService.saveOrUpdate((Object)opportunity);
        return true;
    }

    private void correctionBasisToConclusion(OpptyPortraitScore next) {
        String demision = next.getScopeDimension();
        String correctionBasis = "";
        if (HussarUtils.equals((Object)"dimension_budget", (Object)demision)) {
            DimensionVo budgetConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_budget").getConfigValue(), DimensionVo.class);
            correctionBasis = budgetConfig.getName() + "\uff1a";
        } else if (HussarUtils.equals((Object)"dimension_authority", (Object)demision)) {
            DimensionVo authorityConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_authority").getConfigValue(), DimensionVo.class);
            correctionBasis = authorityConfig.getName() + "\uff1a";
        } else if (HussarUtils.equals((Object)"dimension_need", (Object)demision)) {
            DimensionVo needConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_need").getConfigValue(), DimensionVo.class);
            correctionBasis = needConfig.getName() + "\uff1a";
        } else if (HussarUtils.equals((Object)"dimension_time", (Object)demision)) {
            DimensionVo timeConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_time").getConfigValue(), DimensionVo.class);
            correctionBasis = timeConfig.getName() + "\uff1a";
        } else if (HussarUtils.equals((Object)"dimension_competitor", (Object)demision)) {
            DimensionVo competitorConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_competitor").getConfigValue(), DimensionVo.class);
            correctionBasis = competitorConfig.getName() + "\uff1a";
        }
        correctionBasis = correctionBasis + next.getCorrectionBasis();
        if (next.getArtificialScore() >= 3.0) {
            next.setPositiveConclusion(correctionBasis);
            next.setNegativeConclsion("");
        } else {
            next.setNegativeConclsion(correctionBasis);
            next.setPositiveConclusion("");
        }
    }

    private void sortScoreListByOrderNumber(List<OpptyPortraitScoreVo> list) {
        for (OpptyPortraitScoreVo opptyScore : list) {
            if ("dimension_budget".equals(opptyScore.getScopeDimension())) {
                opptyScore.setOrder(1);
                continue;
            }
            if ("dimension_authority".equals(opptyScore.getScopeDimension())) {
                opptyScore.setOrder(2);
                continue;
            }
            if ("dimension_need".equals(opptyScore.getScopeDimension())) {
                opptyScore.setOrder(3);
                continue;
            }
            if ("dimension_time".equals(opptyScore.getScopeDimension())) {
                opptyScore.setOrder(4);
                continue;
            }
            if ("dimension_competitor".equals(opptyScore.getScopeDimension())) {
                opptyScore.setOrder(5);
                continue;
            }
            opptyScore.setOrder(9999);
        }
    }
}

