/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.opportunityportrait.job.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.jxdinfo.crm.analysis.opportunityportrait.dao.OpportunityPortraitMapper;
import com.jxdinfo.crm.analysis.opportunityportrait.job.service.IOpptyPortraitCalculateService;
import com.jxdinfo.crm.analysis.opportunityportrait.model.OpptyPortraitPrompt;
import com.jxdinfo.crm.analysis.opportunityportrait.model.OpptyPortraitScore;
import com.jxdinfo.crm.analysis.opportunityportrait.model.RecordAI;
import com.jxdinfo.crm.analysis.opportunityportrait.service.IOpportunityPortraitService;
import com.jxdinfo.crm.analysis.opportunityportrait.service.IRecordAIService;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.DimensionVo;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.OpptyProductPriceVo;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.OpptyQuoteVo;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.OpptyScoreLevelVo;
import com.jxdinfo.crm.analysis.opportunityportrait.vo.ScoreLevelRangeVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.trackrecord.vo.TrackRecordAPIVo;
import com.jxdinfo.crm.core.api.competitoranalysis.service.ICompetitorAnalysisAPIService;
import com.jxdinfo.crm.core.api.competitoranalysis.vo.CompetitorAnalysisAPIVo;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.api.opportunity.vo.OpportunityAPIVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmcontactcharacter1.model.CrmContactCharacter1;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OpptyPortraitCalculateServiceImpl
implements IOpptyPortraitCalculateService {
    private static final Logger logger = LoggerFactory.getLogger(OpptyPortraitCalculateServiceImpl.class);
    @Resource
    private IOpportunityPortraitService opportunityPortraitService;
    @Resource
    private OpportunityPortraitMapper opportunityPortraitMapper;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ICompetitorAnalysisAPIService competitorAnalysisService;
    @Resource
    private IRecordAIService recordAIService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    @Override
    public ProcessResult calculateOpptyPortraitScore(List<Long> opportunityIds) {
        List opportunityList;
        boolean portraitFlag = "1".equals(this.crmBaseConfigBoService.getCrmBaseConfigByKey("opportunity_portrait_switch").getConfigValue());
        if (!portraitFlag) {
            return new ProcessResult(false, "\u5546\u673a\u753b\u50cf\u672a\u5f00\u542f");
        }
        List<OpptyPortraitPrompt> promptList = this.opportunityPortraitMapper.selectAllPrompt();
        CrmBaseConfigVo crmBaseConfigByKey = this.crmBaseConfigBoService.getCrmBaseConfigByKey("oppty_score_level");
        List<ScoreLevelRangeVo> scoreLevelRnageVoList = ((OpptyScoreLevelVo)JSONObject.parseObject((String)crmBaseConfigByKey.getConfigValue(), OpptyScoreLevelVo.class)).getScoreLevelRangeVoList();
        LocalDateTime date = LocalDateTime.now();
        boolean autoRefreshFlag = false;
        if (HussarUtils.isNotEmpty(opportunityIds)) {
            opportunityList = this.opportunityAPIService.selectList(opportunityIds);
        } else {
            String[] stringStageIds = this.crmBaseConfigBoService.getCrmBaseConfigByKey("oppty_update_stage").getConfigValue().split(",");
            List<String> stageValueList = Arrays.asList(stringStageIds);
            List stageList = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).in(OpportunityStage::getStageNameValue, stageValueList)).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> s.toString());
            LocalDateTime changeTime = this.opportunityPortraitMapper.selectMaxChangeTime();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("customerStageIds", stageList);
            if (HussarUtils.isNotEmpty((Object)changeTime)) {
                map.put("changeTime", changeTime);
            }
            if (HussarUtils.isEmpty((Object)(opportunityList = this.opportunityAPIService.selectOpptyPortraitUsedList(map)))) {
                return new ProcessResult(true, "\u9700\u8981\u6267\u884c\u5b9a\u65f6\u4efb\u52a1\u7684\u5546\u673a\u4e3a0");
            }
            opportunityIds = opportunityList.stream().map(OpportunityAPIVo::getOpportunityId).collect(Collectors.toList());
            autoRefreshFlag = true;
        }
        boolean AIFlag = "1".equals(this.crmBaseConfigBoService.getCrmBaseConfigByKey("opportunity_portrait_ai").getConfigValue());
        List<Object> opptyProductPriceVos = new ArrayList();
        if (HussarUtils.isNotEmpty(opportunityIds)) {
            opptyProductPriceVos = this.opportunityPortraitMapper.getOpptyProductPriceVos(opportunityIds);
        }
        HashMap<Long, OpptyProductPriceVo> opptyProductPriceMap = new HashMap();
        if (HussarUtils.isNotEmpty(opptyProductPriceVos)) {
            opptyProductPriceMap = opptyProductPriceVos.stream().collect(Collectors.toMap(OpptyProductPriceVo::getOpportunityId, o -> o));
        }
        List<OpptyQuoteVo> opptyQuoteVos = this.opportunityPortraitMapper.getOpptyQuoteRelateCount(opportunityIds);
        HashMap<Long, OpptyQuoteVo> opptyQuoteMap = new HashMap();
        if (HussarUtils.isNotEmpty(opptyQuoteVos)) {
            opptyQuoteMap = opptyQuoteVos.stream().collect(Collectors.toMap(OpptyQuoteVo::getOpportunityId, o -> o));
        }
        List allCompetitor = this.competitorAnalysisService.getAllCompetitor();
        DimensionVo budgetConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_budget").getConfigValue(), DimensionVo.class);
        DimensionVo needConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_need").getConfigValue(), DimensionVo.class);
        DimensionVo competitorConfig = (DimensionVo)JSONObject.parseObject((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("dimension_competitor").getConfigValue(), DimensionVo.class);
        List<CrmContactCharacter1> contactCharacters = this.opportunityPortraitMapper.getContactCharacters(opportunityIds);
        String jsjlDicValue = "3";
        List opportunityStageList = this.opportunityStageService.list((Wrapper)new LambdaQueryWrapper().eq(OpportunityStage::getDelFlag, (Object)"0"));
        Map<Long, List<OpportunityStage>> processIdStageMap = opportunityStageList.stream().collect(Collectors.groupingBy(OpportunityStage::getStageProcessId));
        ArrayList<Long> opptyStageIdsFilter = new ArrayList<Long>();
        for (Map.Entry<Long, List<OpportunityStage>> entry : processIdStageMap.entrySet()) {
            OpportunityStage jsjlStage = entry.getValue().stream().filter(os -> jsjlDicValue.equals(os.getStageNameValue())).findFirst().orElse(null);
            if (jsjlStage == null) continue;
            for (OpportunityStage opportunityStage : entry.getValue()) {
                if (Integer.parseInt(opportunityStage.getOrderNumber()) < Integer.parseInt(jsjlStage.getOrderNumber())) continue;
                opptyStageIdsFilter.add(opportunityStage.getCustomerStageId());
            }
        }
        List opptyPortraitScoresExist = this.opportunityPortraitService.list((Wrapper)new LambdaQueryWrapper().in(OpptyPortraitScore::getOpportunityId, opportunityIds));
        List recordAIListExist = this.recordAIService.list((Wrapper)new LambdaQueryWrapper().in(RecordAI::getTypeId, opportunityIds));
        ArrayList finalOpptyScores = new ArrayList();
        ArrayList<OpportunityAPIVo> finalOpptyList = new ArrayList<OpportunityAPIVo>();
        logger.info("\u5f00\u59cb\u8ba1\u7b97\u5546\u673a\u5f97\u5206");
        int count = 0;
        LocalDateTime start = LocalDateTime.now();
        for (OpportunityAPIVo opportunity : opportunityList) {
            ArrayList<OpptyPortraitScore> opptyPortraitScoresToUpdate = new ArrayList<OpptyPortraitScore>();
            OpptyPortraitScore scoreBudget = this.calculateBudget(opportunity, opptyPortraitScoresExist, recordAIListExist, opptyProductPriceMap, opptyQuoteMap, promptList, budgetConfig, AIFlag, autoRefreshFlag, date);
            OpptyPortraitScore scoreAuthority = this.calculateAuthority(opportunity, opptyPortraitScoresExist, contactCharacters, promptList, autoRefreshFlag, date);
            OpptyPortraitScore scoreNeed = this.calculateNeed(opportunity, opptyPortraitScoresExist, recordAIListExist, promptList, needConfig, opptyStageIdsFilter, AIFlag, autoRefreshFlag, date);
            OpptyPortraitScore scoreTime = this.calculateTime(opportunity, opptyPortraitScoresExist, opptyStageIdsFilter, promptList, autoRefreshFlag, date);
            OpptyPortraitScore scoreCompetitor = this.calculateCompetitor(opportunity, opptyPortraitScoresExist, allCompetitor, promptList, competitorConfig, autoRefreshFlag, date);
            if (HussarUtils.isNotEmpty((Object)scoreBudget)) {
                opptyPortraitScoresToUpdate.add(scoreBudget);
            }
            if (HussarUtils.isNotEmpty((Object)scoreAuthority)) {
                opptyPortraitScoresToUpdate.add(scoreAuthority);
            }
            if (HussarUtils.isNotEmpty((Object)scoreNeed)) {
                opptyPortraitScoresToUpdate.add(scoreNeed);
            }
            if (HussarUtils.isNotEmpty((Object)scoreTime)) {
                opptyPortraitScoresToUpdate.add(scoreTime);
            }
            if (HussarUtils.isNotEmpty((Object)scoreCompetitor)) {
                opptyPortraitScoresToUpdate.add(scoreCompetitor);
            }
            double targetValue = opptyPortraitScoresToUpdate.stream().mapToDouble(score -> score.getArtificialScore() != null ? score.getArtificialScore() : score.getSystemScore()).sum();
            for (ScoreLevelRangeVo range : scoreLevelRnageVoList) {
                int[] value = range.getValue();
                if (!((double)value[0] <= targetValue) || !(targetValue <= (double)value[1])) continue;
                opportunity.setWinPossibility(range.getName());
            }
            if (HussarUtils.isNotEmpty(opptyPortraitScoresToUpdate)) {
                ++count;
                finalOpptyScores.addAll(opptyPortraitScoresToUpdate);
            }
            finalOpptyList.add(opportunity);
        }
        LocalDateTime end = LocalDateTime.now();
        logger.info("{}\u6761\u5546\u673a\u5f97\u5206\u8ba1\u7b97\u5b8c\u6210\uff0c\u603b\u5171\u8017\u65f6{}s", (Object)count, (Object)(Duration.between(start, end).toMillis() / 1000L));
        logger.info("\u5f00\u59cb\u63d2\u5165\u6570\u636e");
        this.opportunityPortraitService.saveOrUpdateBatch(finalOpptyScores);
        this.opportunityAPIService.saveOrUpdateBatch(finalOpptyList);
        logger.info("\u63d2\u5165\u6570\u636e\u5b8c\u6210");
        return new ProcessResult(true);
    }

    public OpptyPortraitScore calculateBudget(OpportunityAPIVo opportunity, List<OpptyPortraitScore> existedScoreList, List<RecordAI> recordAIListExist, Map<Long, OpptyProductPriceVo> opptyProductPriceMap, Map<Long, OpptyQuoteVo> opptyQuoteMap, List<OpptyPortraitPrompt> promptList, DimensionVo budgetConfig, boolean AIFlag, boolean autoRefreshFlag, LocalDateTime date) {
        Long opportunityId = opportunity.getOpportunityId();
        OpptyPortraitScore opptyPortraitScoreFinal = existedScoreList.stream().filter(s -> HussarUtils.equals((Object)s.getOpportunityId(), (Object)opportunityId) && HussarUtils.equals((Object)s.getDimension(), (Object)"dimension_budget")).findFirst().orElse(null);
        if (HussarUtils.isEmpty((Object)opptyPortraitScoreFinal)) {
            opptyPortraitScoreFinal = new OpptyPortraitScore();
            opptyPortraitScoreFinal.setOpportunityId(opportunity.getOpportunityId());
            opptyPortraitScoreFinal.setDimension("dimension_budget");
            opptyPortraitScoreFinal.setCreateTime(date);
        } else if (HussarUtils.isNotEmpty((Object)opptyPortraitScoreFinal.getArtificialScore())) {
            return null;
        }
        if (autoRefreshFlag) {
            opptyPortraitScoreFinal.setModifyTime(date);
        } else {
            opptyPortraitScoreFinal.setChangeTime(date);
        }
        JSONObject replaceValueJSON = new JSONObject();
        RecordAI recordAI = recordAIListExist.stream().filter(r -> HussarUtils.equals((Object)r.getTypeId(), (Object)opportunityId)).findFirst().orElse(null);
        if (HussarUtils.isNotEmpty((Object)opportunity.getCustomerBudget())) {
            double customerBudget = Double.parseDouble(opportunity.getCustomerBudget());
            OpptyProductPriceVo opptyProductPriceVo = opptyProductPriceMap.get(opportunityId);
            if (customerBudget > 0.0 && HussarUtils.isNotEmpty((Object)opptyProductPriceVo)) {
                OpptyPortraitPrompt budgetPrompt;
                if (customerBudget > opptyProductPriceVo.getSellPriceTotal()) {
                    opptyPortraitScoreFinal.setSystemScore(5.0);
                    budgetPrompt = promptList.stream().filter(s -> "budget".equals(s.getDimension()) && "5".equals(s.getScore())).findFirst().get();
                } else {
                    opptyPortraitScoreFinal.setSystemScore(4.0);
                    budgetPrompt = promptList.stream().filter(s -> "budget".equals(s.getDimension()) && "4".equals(s.getScore())).findFirst().get();
                }
                replaceValueJSON.put("budget", (Object)customerBudget);
                opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                if ("1".equals(budgetPrompt.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(budgetPrompt.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(budgetPrompt.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        double aiBudgetFinal = 0.0;
        if (AIFlag && HussarUtils.isNotEmpty((Object)recordAI)) {
            double aiBudget;
            double d = aiBudget = HussarUtils.isNotEmpty((Object)recordAI.getBudget()) ? Double.parseDouble(recordAI.getBudget()) : 0.0;
            if (HussarUtils.isNotEmpty((Object)aiBudget) && aiBudget > 0.0) {
                aiBudgetFinal = aiBudget;
                OpptyProductPriceVo opptyProductPriceVo = opptyProductPriceMap.get(opportunityId);
                if (HussarUtils.isNotEmpty((Object)opptyProductPriceVo)) {
                    OpptyPortraitPrompt budgetPrompt;
                    if (aiBudgetFinal > opptyProductPriceVo.getSellPriceTotal()) {
                        opptyPortraitScoreFinal.setSystemScore(5.0);
                        budgetPrompt = promptList.stream().filter(s -> "budget".equals(s.getDimension()) && "5".equals(s.getScore())).findFirst().get();
                    } else {
                        opptyPortraitScoreFinal.setSystemScore(4.0);
                        budgetPrompt = promptList.stream().filter(s -> "budget".equals(s.getDimension()) && "4".equals(s.getScore())).findFirst().get();
                    }
                    replaceValueJSON.put("budget", (Object)aiBudgetFinal);
                    opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                    if ("1".equals(budgetPrompt.getIsPositive())) {
                        opptyPortraitScoreFinal.setPositiveConclusion(budgetPrompt.getConclusion());
                        opptyPortraitScoreFinal.setNegativeConclsion("");
                    } else {
                        opptyPortraitScoreFinal.setNegativeConclsion(budgetPrompt.getConclusion());
                        opptyPortraitScoreFinal.setPositiveConclusion("");
                    }
                    return opptyPortraitScoreFinal;
                }
            }
        }
        if (HussarUtils.isEmpty((Object)opportunity.getCustomerBudget()) || Double.parseDouble(opportunity.getCustomerBudget()) == 0.0) {
            OpptyQuoteVo opptyQuoteVo;
            String isConfirmBudget = opportunity.getIsConfirmBudget();
            if ("1".equals(isConfirmBudget)) {
                opptyPortraitScoreFinal.setSystemScore(3.0);
                OpptyPortraitPrompt budgetPrompt = promptList.stream().filter(s -> "budget".equals(s.getDimension()) && "3".equals(s.getScore())).findFirst().get();
                if ("1".equals(budgetPrompt.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(budgetPrompt.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(budgetPrompt.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
            boolean estimateFinal = false;
            String contentMatchKeys = budgetConfig.getTwo().getTrackrecordContain();
            String contentNoMatchKeys = budgetConfig.getTwo().getTrackrecordNoContain();
            if (AIFlag) {
                if (HussarUtils.isNotEmpty((Object)recordAI) && "0".equals(recordAI.getUnclearBudget())) {
                    opptyPortraitScoreFinal.setSystemScore(2.0);
                    OpptyPortraitPrompt budgetPrompt = promptList.stream().filter(s -> "budget".equals(s.getDimension()) && "2,1".equals(s.getScore())).findFirst().get();
                    if ("1".equals(budgetPrompt.getIsPositive())) {
                        opptyPortraitScoreFinal.setPositiveConclusion(budgetPrompt.getConclusion());
                        opptyPortraitScoreFinal.setNegativeConclsion("");
                    } else {
                        opptyPortraitScoreFinal.setNegativeConclsion(budgetPrompt.getConclusion());
                        opptyPortraitScoreFinal.setPositiveConclusion("");
                    }
                    return opptyPortraitScoreFinal;
                }
            } else {
                List<String> contentMatchKeysList = null;
                List<String> scontentNoMatchKeysList = null;
                if (HussarUtils.isNotEmpty((Object)contentMatchKeys)) {
                    contentMatchKeysList = Arrays.asList(contentMatchKeys.split("\u3001"));
                }
                if (HussarUtils.isNotEmpty((Object)contentNoMatchKeys)) {
                    scontentNoMatchKeysList = Arrays.asList(contentNoMatchKeys.split("\u3001"));
                }
                if (HussarUtils.isNotEmpty(contentMatchKeysList) || HussarUtils.isNotEmpty(scontentNoMatchKeysList)) {
                    List<TrackRecordAPIVo> trackRecordTemp = this.opportunityPortraitMapper.opportunityTrack(opportunity.getOpportunityId(), contentMatchKeysList, scontentNoMatchKeysList);
                    estimateFinal = HussarUtils.isNotEmpty(trackRecordTemp);
                }
                if (estimateFinal) {
                    opptyPortraitScoreFinal.setSystemScore(2.0);
                    OpptyPortraitPrompt budgetPrompt = promptList.stream().filter(s -> "budget".equals(s.getDimension()) && "2,1".equals(s.getScore())).findFirst().get();
                    if ("1".equals(budgetPrompt.getIsPositive())) {
                        opptyPortraitScoreFinal.setPositiveConclusion(budgetPrompt.getConclusion());
                        opptyPortraitScoreFinal.setNegativeConclsion("");
                    } else {
                        opptyPortraitScoreFinal.setNegativeConclsion(budgetPrompt.getConclusion());
                        opptyPortraitScoreFinal.setPositiveConclusion("");
                    }
                    return opptyPortraitScoreFinal;
                }
            }
            if (HussarUtils.isNotEmpty((Object)(opptyQuoteVo = opptyQuoteMap.get(opportunityId)))) {
                opptyPortraitScoreFinal.setSystemScore(2.0);
                OpptyPortraitPrompt budgetPrompt = promptList.stream().filter(s -> "budget".equals(s.getDimension()) && "2,1".equals(s.getScore())).findFirst().get();
                if ("1".equals(budgetPrompt.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(budgetPrompt.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(budgetPrompt.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        opptyPortraitScoreFinal.setSystemScore(1.0);
        OpptyPortraitPrompt budgetPrompt = promptList.stream().filter(s -> "budget".equals(s.getDimension()) && "2,1".equals(s.getScore())).findFirst().get();
        if ("1".equals(budgetPrompt.getIsPositive())) {
            opptyPortraitScoreFinal.setPositiveConclusion(budgetPrompt.getConclusion());
            opptyPortraitScoreFinal.setNegativeConclsion("");
        } else {
            opptyPortraitScoreFinal.setNegativeConclsion(budgetPrompt.getConclusion());
            opptyPortraitScoreFinal.setPositiveConclusion("");
        }
        return opptyPortraitScoreFinal;
    }

    public OpptyPortraitScore calculateAuthority(OpportunityAPIVo opportunity, List<OpptyPortraitScore> existedScoreList, List<CrmContactCharacter1> contactCharacters, List<OpptyPortraitPrompt> promptList, boolean autoRefreshFlag, LocalDateTime date) {
        List recordListTemp;
        ArrayList<Object> characterTwo;
        Object recordListTemp2;
        List contactIds;
        Long opportunityId = opportunity.getOpportunityId();
        OpptyPortraitScore opptyPortraitScoreFinal = existedScoreList.stream().filter(s -> HussarUtils.equals((Object)s.getOpportunityId(), (Object)opportunityId) && HussarUtils.equals((Object)s.getDimension(), (Object)"dimension_authority")).findFirst().orElse(null);
        if (HussarUtils.isEmpty((Object)opptyPortraitScoreFinal)) {
            opptyPortraitScoreFinal = new OpptyPortraitScore();
            opptyPortraitScoreFinal.setOpportunityId(opportunity.getOpportunityId());
            opptyPortraitScoreFinal.setDimension("dimension_authority");
            opptyPortraitScoreFinal.setCreateTime(date);
        } else if (HussarUtils.isNotEmpty((Object)opptyPortraitScoreFinal.getArtificialScore())) {
            return null;
        }
        if (autoRefreshFlag) {
            opptyPortraitScoreFinal.setModifyTime(date);
        } else {
            opptyPortraitScoreFinal.setChangeTime(date);
        }
        JSONObject replaceValueJSON = new JSONObject();
        List contactCharacter1s = contactCharacters.stream().filter(s -> Objects.equals(opportunityId, s.getOpportunityId())).collect(Collectors.toList());
        List<TrackRecordAPIVo> trackRecords = this.opportunityPortraitMapper.opportunityTrack(opportunity.getOpportunityId(), null, null);
        Map<Object, Object> characterRecordsMap = new HashMap();
        if (HussarUtils.isNotEmpty(trackRecords)) {
            characterRecordsMap = trackRecords.stream().filter(s -> HussarUtils.isNotEmpty((Object)s.getContactId())).collect(Collectors.groupingBy(TrackRecordAPIVo::getContactId));
        }
        if (HussarUtils.isNotEmpty(contactCharacter1s)) {
            contactIds = contactCharacter1s.stream().map(CrmContactCharacter1::getContactId).collect(Collectors.toList());
            ArrayList characterFive = new ArrayList();
            HashMap<Long, Integer> recordMapFive = new HashMap<Long, Integer>();
            for (Long contactId : contactIds) {
                List characterFiveTemp;
                recordListTemp2 = (List)characterRecordsMap.get(String.valueOf(contactId));
                if (!HussarUtils.isNotEmpty((Object)recordListTemp2) || !HussarUtils.isNotEmpty(characterFiveTemp = contactCharacter1s.stream().filter(s -> s.getOpportunityCharacter().contains("4") && Objects.equals(contactId, s.getContactId())).collect(Collectors.toList()))) continue;
                characterFive.addAll(characterFiveTemp);
                recordMapFive.put(contactId, recordListTemp2.size());
            }
            if (HussarUtils.isNotEmpty(characterFive)) {
                opptyPortraitScoreFinal.setSystemScore(5.0);
                OpptyPortraitPrompt authorityPrompt = promptList.stream().filter(s -> "authority".equals(s.getDimension()) && "5".equals(s.getScore())).findFirst().get();
                StringBuilder decisionMakers = new StringBuilder();
                int communicateCount = 0;
                for (CrmContactCharacter1 character1 : characterFive) {
                    decisionMakers.append("\u3001").append(character1.getContactName());
                    communicateCount += ((Integer)recordMapFive.get(character1.getContactId())).intValue();
                    if (!HussarUtils.isNotEmpty((Object)character1.getPosition())) continue;
                    decisionMakers.append("(\u804c\u52a1\uff1a").append(character1.getPosition()).append(")");
                }
                replaceValueJSON.put("decisionMaker", (Object)decisionMakers.deleteCharAt(0));
                replaceValueJSON.put("communicateCount", (Object)communicateCount);
                opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                if ("1".equals(authorityPrompt.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        if (HussarUtils.isNotEmpty(contactCharacter1s)) {
            contactIds = contactCharacter1s.stream().map(CrmContactCharacter1::getContactId).collect(Collectors.toList());
            ArrayList characterFour = new ArrayList();
            HashMap<Long, Integer> recordMapFour = new HashMap<Long, Integer>();
            for (Long contactId : contactIds) {
                List characterFourTemp;
                recordListTemp2 = (List)characterRecordsMap.get(String.valueOf(contactId));
                if (!HussarUtils.isNotEmpty((Object)recordListTemp2) || !HussarUtils.isNotEmpty(characterFourTemp = contactCharacter1s.stream().filter(s -> s.getOpportunityCharacter().contains("3") && Objects.equals(contactId, s.getContactId())).collect(Collectors.toList()))) continue;
                characterFour.addAll(characterFourTemp);
                recordMapFour.put(contactId, recordListTemp2.size());
            }
            if (HussarUtils.isNotEmpty(characterFour)) {
                opptyPortraitScoreFinal.setSystemScore(4.0);
                OpptyPortraitPrompt authorityPrompt = promptList.stream().filter(s -> "authority_no_agent".equals(s.getDimension()) && "4".equals(s.getScore())).findFirst().get();
                StringBuilder keyPerson = new StringBuilder();
                int communicateCount = 0;
                for (CrmContactCharacter1 character1 : characterFour) {
                    keyPerson.append("\u3001").append(character1.getContactName());
                    communicateCount += ((Integer)recordMapFour.get(character1.getContactId())).intValue();
                }
                replaceValueJSON.put("keyPerson", (Object)keyPerson.deleteCharAt(0));
                replaceValueJSON.put("communicateCount", (Object)communicateCount);
                opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                if ("1".equals(authorityPrompt.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        if (HussarUtils.isNotEmpty((Object)opportunity.getAgentId()) && HussarUtils.isNotEmpty(trackRecords)) {
            opptyPortraitScoreFinal.setSystemScore(4.0);
            OpptyPortraitPrompt authorityPrompt = promptList.stream().filter(s -> "authority_agent".equals(s.getDimension()) && "4".equals(s.getScore())).findFirst().get();
            if ("1".equals(authorityPrompt.getIsPositive())) {
                opptyPortraitScoreFinal.setPositiveConclusion(authorityPrompt.getConclusion());
                opptyPortraitScoreFinal.setNegativeConclsion("");
            } else {
                opptyPortraitScoreFinal.setNegativeConclsion(authorityPrompt.getConclusion());
                opptyPortraitScoreFinal.setPositiveConclusion("");
            }
            return opptyPortraitScoreFinal;
        }
        if (HussarUtils.isNotEmpty(contactCharacter1s)) {
            contactIds = contactCharacter1s.stream().map(CrmContactCharacter1::getContactId).collect(Collectors.toList());
            ArrayList characterThree = new ArrayList();
            HashMap<Long, Integer> recordMapThree = new HashMap<Long, Integer>();
            for (Long contactId : contactIds) {
                List characterThreeTemp;
                recordListTemp2 = (List)characterRecordsMap.get(String.valueOf(contactId));
                if (!HussarUtils.isNotEmpty((Object)recordListTemp2) || !HussarUtils.isNotEmpty(characterThreeTemp = contactCharacter1s.stream().filter(s -> (s.getOpportunityCharacter().contains("2") || s.getOpportunityCharacter().contains("5")) && Objects.equals(contactId, s.getContactId())).collect(Collectors.toList()))) continue;
                characterThree.addAll(characterThreeTemp);
                recordMapThree.put(contactId, recordListTemp2.size());
            }
            if (HussarUtils.isNotEmpty(characterThree)) {
                opptyPortraitScoreFinal.setSystemScore(3.0);
                OpptyPortraitPrompt authorityPrompt = promptList.stream().filter(s -> "authority".equals(s.getDimension()) && "3".equals(s.getScore())).findFirst().get();
                StringBuilder usePerson = new StringBuilder();
                int communicateCount = 0;
                for (CrmContactCharacter1 character1 : characterThree) {
                    usePerson.append("\u3001").append(character1.getContactName());
                    communicateCount += ((Integer)recordMapThree.get(character1.getContactId())).intValue();
                }
                replaceValueJSON.put("usePerson", (Object)usePerson.deleteCharAt(0));
                replaceValueJSON.put("communicateCount", (Object)communicateCount);
                opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                if ("1".equals(authorityPrompt.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        if (HussarUtils.isNotEmpty(contactCharacter1s)) {
            contactIds = contactCharacter1s.stream().map(CrmContactCharacter1::getContactId).collect(Collectors.toList());
            characterTwo = new ArrayList<Object>();
            for (Long contactId : contactIds) {
                List characterTwoTemp;
                recordListTemp = (List)characterRecordsMap.get(String.valueOf(contactId));
                if (!HussarUtils.isNotEmpty((Object)recordListTemp) || !HussarUtils.isNotEmpty(characterTwoTemp = contactCharacter1s.stream().filter(s -> s.getOpportunityCharacter().contains("1") && Objects.equals(contactId, s.getContactId())).collect(Collectors.toList()))) continue;
                characterTwo.addAll(characterTwoTemp);
            }
            if (HussarUtils.isNotEmpty(characterTwo)) {
                opptyPortraitScoreFinal.setSystemScore(2.0);
                OpptyPortraitPrompt authorityPrompt = promptList.stream().filter(s -> "authority".equals(s.getDimension()) && "2".equals(s.getScore())).findFirst().get();
                if ("1".equals(authorityPrompt.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        if (HussarUtils.isNotEmpty(contactCharacter1s)) {
            contactIds = contactCharacter1s.stream().map(CrmContactCharacter1::getContactId).collect(Collectors.toList());
            characterTwo = new ArrayList();
            for (Long contactId : contactIds) {
                recordListTemp = (List)characterRecordsMap.get(String.valueOf(contactId));
                if (!HussarUtils.isEmpty((Object)recordListTemp)) continue;
                characterTwo.add(contactId);
            }
            if (HussarUtils.isNotEmpty(characterTwo)) {
                opptyPortraitScoreFinal.setSystemScore(2.0);
                OpptyPortraitPrompt authorityPrompt = promptList.stream().filter(s -> "authority".equals(s.getDimension()) && "2".equals(s.getScore())).findFirst().get();
                if ("1".equals(authorityPrompt.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(authorityPrompt.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        OpptyPortraitPrompt authorityPrompt = promptList.stream().filter(s -> "authority".equals(s.getDimension()) && "1".equals(s.getScore())).findFirst().get();
        opptyPortraitScoreFinal.setSystemScore(1.0);
        if ("1".equals(authorityPrompt.getIsPositive())) {
            opptyPortraitScoreFinal.setPositiveConclusion(authorityPrompt.getConclusion());
            opptyPortraitScoreFinal.setNegativeConclsion("");
        } else {
            opptyPortraitScoreFinal.setNegativeConclsion(authorityPrompt.getConclusion());
            opptyPortraitScoreFinal.setPositiveConclusion("");
        }
        return opptyPortraitScoreFinal;
    }

    public OpptyPortraitScore calculateNeed(OpportunityAPIVo opportunity, List<OpptyPortraitScore> existedScoreList, List<RecordAI> recordAIListExist, List<OpptyPortraitPrompt> promptList, DimensionVo needConfig, List<Long> opptyStageIdsFilter, boolean AIFlag, boolean autoRefreshFlag, LocalDateTime date) {
        OpptyPortraitPrompt needPrompt;
        String lastRecordIntentionLevel;
        List<String> contentMatchKeysList;
        Long opportunityId = opportunity.getOpportunityId();
        OpptyPortraitScore opptyPortraitScoreFinal = existedScoreList.stream().filter(s -> HussarUtils.equals((Object)s.getOpportunityId(), (Object)opportunityId) && HussarUtils.equals((Object)s.getDimension(), (Object)"dimension_need")).findFirst().orElse(null);
        if (HussarUtils.isEmpty((Object)opptyPortraitScoreFinal)) {
            opptyPortraitScoreFinal = new OpptyPortraitScore();
            opptyPortraitScoreFinal.setOpportunityId(opportunity.getOpportunityId());
            opptyPortraitScoreFinal.setDimension("dimension_need");
            opptyPortraitScoreFinal.setCreateTime(date);
        } else if (HussarUtils.isNotEmpty((Object)opptyPortraitScoreFinal.getArtificialScore())) {
            return null;
        }
        if (autoRefreshFlag) {
            opptyPortraitScoreFinal.setModifyTime(date);
        } else {
            opptyPortraitScoreFinal.setChangeTime(date);
        }
        JSONObject replaceValueJSON = new JSONObject();
        RecordAI recordAI = recordAIListExist.stream().filter(r -> HussarUtils.equals((Object)r.getTypeId(), (Object)opportunityId)).findFirst().orElse(null);
        String contentMatchKeysFive = needConfig.getFive().getTrackrecordContain();
        String contentNoMatchKeysFive = needConfig.getFive().getTrackrecordNoContain();
        boolean estimateFiveFinal = false;
        if (AIFlag) {
            if (HussarUtils.isNotEmpty((Object)recordAI) && "1".equals(recordAI.getExistingPlan())) {
                OpptyPortraitPrompt needPrompt2 = promptList.stream().filter(s -> "need".equals(s.getDimension()) && "5".equals(s.getScore())).findFirst().get();
                opptyPortraitScoreFinal.setSystemScore(5.0);
                if ("1".equals(needPrompt2.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(needPrompt2.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(needPrompt2.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        } else {
            List<String> contentMatchKeysList2 = null;
            List<String> scontentNoMatchKeysList = null;
            if (HussarUtils.isNotEmpty((Object)contentMatchKeysFive)) {
                contentMatchKeysList2 = Arrays.asList(contentMatchKeysFive.split("\u3001"));
            }
            if (HussarUtils.isNotEmpty((Object)contentNoMatchKeysFive)) {
                scontentNoMatchKeysList = Arrays.asList(contentNoMatchKeysFive.split("\u3001"));
            }
            List<Object> trackRecordTemp = new ArrayList();
            if (HussarUtils.isNotEmpty(contentMatchKeysList2) || HussarUtils.isNotEmpty(scontentNoMatchKeysList)) {
                trackRecordTemp = this.opportunityPortraitMapper.opportunityTrack(opportunity.getOpportunityId(), contentMatchKeysList2, scontentNoMatchKeysList);
                estimateFiveFinal = HussarUtils.isNotEmpty(trackRecordTemp);
            }
            if (estimateFiveFinal) {
                opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                OpptyPortraitPrompt needPrompt3 = promptList.stream().filter(s -> "need".equals(s.getDimension()) && "5".equals(s.getScore())).findFirst().get();
                opptyPortraitScoreFinal.setSystemScore(5.0);
                if ("1".equals(needPrompt3.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(needPrompt3.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(needPrompt3.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        boolean estimateFourFinal = false;
        String contentMatchKeysFour = needConfig.getFour().getTrackrecordContain();
        String contentNoMatchKeysFour = needConfig.getFour().getTrackrecordNoContain();
        if (AIFlag) {
            if (HussarUtils.isNotEmpty((Object)recordAI) && "1".equals(recordAI.getClearRequirements())) {
                OpptyPortraitPrompt needPrompt4 = promptList.stream().filter(s -> "need".equals(s.getDimension()) && "4".equals(s.getScore())).findFirst().get();
                opptyPortraitScoreFinal.setSystemScore(4.0);
                if ("1".equals(needPrompt4.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(needPrompt4.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(needPrompt4.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        } else {
            contentMatchKeysList = null;
            List<String> scontentNoMatchKeysList = null;
            if (HussarUtils.isNotEmpty((Object)contentMatchKeysFour)) {
                contentMatchKeysList = Arrays.asList(contentMatchKeysFour.split("\u3001"));
            }
            if (HussarUtils.isNotEmpty((Object)contentNoMatchKeysFour)) {
                scontentNoMatchKeysList = Arrays.asList(contentNoMatchKeysFour.split("\u3001"));
            }
            if (HussarUtils.isNotEmpty(contentMatchKeysList) || HussarUtils.isNotEmpty(scontentNoMatchKeysList)) {
                List<TrackRecordAPIVo> trackRecordTemp = this.opportunityPortraitMapper.opportunityTrack(opportunity.getOpportunityId(), contentMatchKeysList, scontentNoMatchKeysList);
                estimateFourFinal = HussarUtils.isNotEmpty(trackRecordTemp);
            }
            if (estimateFourFinal) {
                OpptyPortraitPrompt needPrompt5 = promptList.stream().filter(s -> "need".equals(s.getDimension()) && "4".equals(s.getScore())).findFirst().get();
                opptyPortraitScoreFinal.setSystemScore(4.0);
                if ("1".equals(needPrompt5.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(needPrompt5.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(needPrompt5.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        if (HussarUtils.isNotEmpty((Object)needConfig.getFour())) {
            Integer fileInfoCount;
            contentMatchKeysList = null;
            List<String> contentNoMatchKeysList = null;
            if (HussarUtils.isNotEmpty((Object)contentMatchKeysFour)) {
                contentMatchKeysList = Arrays.asList(contentMatchKeysFour.split("\u3001"));
            }
            if (HussarUtils.isNotEmpty((Object)contentNoMatchKeysFour)) {
                contentNoMatchKeysList = Arrays.asList(contentNoMatchKeysFour.split("\u3001"));
            }
            if (HussarUtils.isNotEmpty((Object)(fileInfoCount = this.opportunityPortraitMapper.getOpptyFileInfoList(opportunityId, contentMatchKeysList, contentNoMatchKeysList))) && fileInfoCount > 0) {
                OpptyPortraitPrompt needPrompt6 = promptList.stream().filter(s -> "need".equals(s.getDimension()) && "4".equals(s.getScore())).findFirst().get();
                opptyPortraitScoreFinal.setSystemScore(4.0);
                if ("1".equals(needPrompt6.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(needPrompt6.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(needPrompt6.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        boolean stageFlag = false;
        if (opptyStageIdsFilter.contains(Long.parseLong(opportunity.getCustomerStageId()))) {
            stageFlag = true;
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin().stream().map(String::valueOf).collect(Collectors.toList());
        List<String> recordIntentionLevels = this.opportunityPortraitMapper.getLastRecordIntentionLevel(opportunityId);
        if (HussarUtils.isNotEmpty(recordIntentionLevels)) {
            String lastRecordIntentionLevel2 = recordIntentionLevels.get(0);
            if (stageFlag && ("3".equals(lastRecordIntentionLevel2) || "4".equals(lastRecordIntentionLevel2))) {
                OpptyPortraitPrompt needPrompt7;
                opptyPortraitScoreFinal.setSystemScore(3.0);
                if (stageWin.contains(opportunity.getCustomerStageId())) {
                    replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u6781\u9ad8");
                    needPrompt7 = promptList.stream().filter(s -> "need_high_win".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                } else {
                    replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u8f83\u9ad8");
                    needPrompt7 = promptList.stream().filter(s -> "need_high".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                }
                opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                if ("1".equals(needPrompt7.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(needPrompt7.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(needPrompt7.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        boolean estimateTwoFinal = false;
        String contentMatchKeysTwo = needConfig.getTwo().getTrackrecordContain();
        String contentNoMatchKeysTwo = needConfig.getTwo().getTrackrecordNoContain();
        if (AIFlag) {
            if (HussarUtils.isNotEmpty((Object)recordAI) && "1".equals(recordAI.getClearBiddingInformation())) {
                OpptyPortraitPrompt needPrompt8;
                if (HussarUtils.isNotEmpty(recordIntentionLevels)) {
                    String lastRecordIntentionLevel3 = recordIntentionLevels.get(0);
                    if ("3".equals(lastRecordIntentionLevel3) || "4".equals(lastRecordIntentionLevel3)) {
                        if (stageWin.contains(opportunity.getCustomerStageId())) {
                            replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u6781\u9ad8");
                            opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                            needPrompt8 = promptList.stream().filter(s -> "need_high_win".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                        } else {
                            replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u8f83\u9ad8");
                            opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                            needPrompt8 = promptList.stream().filter(s -> "need_high".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                        }
                    } else if (stageWin.contains(opportunity.getCustomerStageId())) {
                        needPrompt8 = promptList.stream().filter(s -> "need_middle_win".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                    } else {
                        replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u4e00\u822c");
                        opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                        needPrompt8 = promptList.stream().filter(s -> "need_middle".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                    }
                } else {
                    needPrompt8 = promptList.stream().filter(s -> "need_else".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                }
                opptyPortraitScoreFinal.setSystemScore(2.0);
                if ("1".equals(needPrompt8.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(needPrompt8.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(needPrompt8.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        } else {
            List<String> contentMatchKeysList3 = null;
            List<String> scontentNoMatchKeysList = null;
            if (HussarUtils.isNotEmpty((Object)contentMatchKeysTwo)) {
                contentMatchKeysList3 = Arrays.asList(contentMatchKeysTwo.split("\u3001"));
            }
            if (HussarUtils.isNotEmpty((Object)contentNoMatchKeysTwo)) {
                scontentNoMatchKeysList = Arrays.asList(contentNoMatchKeysTwo.split("\u3001"));
            }
            if (HussarUtils.isNotEmpty(contentMatchKeysList3) || HussarUtils.isNotEmpty(scontentNoMatchKeysList)) {
                List<TrackRecordAPIVo> trackRecordTemp = this.opportunityPortraitMapper.opportunityTrack(opportunity.getOpportunityId(), contentMatchKeysList3, scontentNoMatchKeysList);
                estimateTwoFinal = HussarUtils.isNotEmpty(trackRecordTemp);
            }
            if (estimateTwoFinal) {
                OpptyPortraitPrompt needPrompt9;
                if (HussarUtils.isNotEmpty(recordIntentionLevels)) {
                    String lastRecordIntentionLevel4 = recordIntentionLevels.get(0);
                    if ("3".equals(lastRecordIntentionLevel4) || "4".equals(lastRecordIntentionLevel4)) {
                        if (stageWin.contains(opportunity.getCustomerStageId())) {
                            replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u6781\u9ad8");
                            opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                            needPrompt9 = promptList.stream().filter(s -> "need_high_win".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                        } else {
                            replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u8f83\u9ad8");
                            opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                            needPrompt9 = promptList.stream().filter(s -> "need_high".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                        }
                    } else if (stageWin.contains(opportunity.getCustomerStageId())) {
                        needPrompt9 = promptList.stream().filter(s -> "need_middle_win".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                    } else {
                        replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u4e00\u822c");
                        opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                        needPrompt9 = promptList.stream().filter(s -> "need_middle".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                    }
                } else {
                    needPrompt9 = promptList.stream().filter(s -> "need_else".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                }
                opptyPortraitScoreFinal.setSystemScore(2.0);
                if ("1".equals(needPrompt9.getIsPositive())) {
                    opptyPortraitScoreFinal.setPositiveConclusion(needPrompt9.getConclusion());
                    opptyPortraitScoreFinal.setNegativeConclsion("");
                } else {
                    opptyPortraitScoreFinal.setNegativeConclsion(needPrompt9.getConclusion());
                    opptyPortraitScoreFinal.setPositiveConclusion("");
                }
                return opptyPortraitScoreFinal;
            }
        }
        if (HussarUtils.isNotEmpty((Object)opportunity.getPurchaseMethod()) && ("1".equals(opportunity.getPurchaseMethod()) || "2".equals(opportunity.getPurchaseMethod())) || HussarUtils.isNotEmpty((Object)opportunity.getTenderDate()) || Long.parseLong(opportunity.getCustomerStageId()) == 7L) {
            OpptyPortraitPrompt needPrompt10;
            if (HussarUtils.isNotEmpty(recordIntentionLevels)) {
                lastRecordIntentionLevel = recordIntentionLevels.get(0);
                if ("3".equals(lastRecordIntentionLevel) || "4".equals(lastRecordIntentionLevel)) {
                    if (stageWin.contains(opportunity.getCustomerStageId())) {
                        replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u6781\u9ad8");
                        opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                        needPrompt10 = promptList.stream().filter(s -> "need_high_win".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                    } else {
                        replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u8f83\u9ad8");
                        opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                        needPrompt10 = promptList.stream().filter(s -> "need_high".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                    }
                } else if (stageWin.contains(opportunity.getCustomerStageId())) {
                    needPrompt10 = promptList.stream().filter(s -> "need_middle_win".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                } else {
                    replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u4e00\u822c");
                    opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                    needPrompt10 = promptList.stream().filter(s -> "need_middle".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                }
            } else {
                needPrompt10 = promptList.stream().filter(s -> "need_else".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
            }
            opptyPortraitScoreFinal.setSystemScore(2.0);
            if ("1".equals(needPrompt10.getIsPositive())) {
                opptyPortraitScoreFinal.setPositiveConclusion(needPrompt10.getConclusion());
                opptyPortraitScoreFinal.setNegativeConclsion("");
            } else {
                opptyPortraitScoreFinal.setNegativeConclsion(needPrompt10.getConclusion());
                opptyPortraitScoreFinal.setPositiveConclusion("");
            }
            return opptyPortraitScoreFinal;
        }
        if (HussarUtils.isNotEmpty(recordIntentionLevels)) {
            lastRecordIntentionLevel = recordIntentionLevels.get(0);
            if ("3".equals(lastRecordIntentionLevel) || "4".equals(lastRecordIntentionLevel)) {
                if (stageWin.contains(opportunity.getCustomerStageId())) {
                    replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u6781\u9ad8");
                    opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                    needPrompt = promptList.stream().filter(s -> "need_high_win".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                } else {
                    replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u8f83\u9ad8");
                    opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                    needPrompt = promptList.stream().filter(s -> "need_high".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
                }
            } else if (stageWin.contains(opportunity.getCustomerStageId())) {
                needPrompt = promptList.stream().filter(s -> "need_middle_win".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
            } else {
                replaceValueJSON.put("intentionDegree", (Object)"\u610f\u5411\u7a0b\u5ea6\u4e00\u822c");
                opptyPortraitScoreFinal.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                needPrompt = promptList.stream().filter(s -> "need_middle".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
            }
        } else {
            needPrompt = promptList.stream().filter(s -> "need_else".equals(s.getDimension()) && "3,2,1".equals(s.getScore())).findFirst().get();
        }
        opptyPortraitScoreFinal.setSystemScore(1.0);
        if ("1".equals(needPrompt.getIsPositive())) {
            opptyPortraitScoreFinal.setPositiveConclusion(needPrompt.getConclusion());
            opptyPortraitScoreFinal.setNegativeConclsion("");
        } else {
            opptyPortraitScoreFinal.setNegativeConclsion(needPrompt.getConclusion());
            opptyPortraitScoreFinal.setPositiveConclusion("");
        }
        return opptyPortraitScoreFinal;
    }

    public OpptyPortraitScore calculateTime(OpportunityAPIVo opportunity, List<OpptyPortraitScore> existedScoreList, List<Long> stageList, List<OpptyPortraitPrompt> promptList, boolean autoRefreshFlag, LocalDateTime date) {
        OpptyPortraitScore opptyPortraitScore = existedScoreList.stream().filter(s -> HussarUtils.equals((Object)s.getOpportunityId(), (Object)opportunity.getOpportunityId()) && HussarUtils.equals((Object)s.getDimension(), (Object)"dimension_time")).findFirst().orElse(null);
        if (HussarUtils.isEmpty((Object)opptyPortraitScore)) {
            opptyPortraitScore = new OpptyPortraitScore();
            opptyPortraitScore.setOpportunityId(opportunity.getOpportunityId());
            opptyPortraitScore.setDimension("dimension_time");
            opptyPortraitScore.setCreateTime(date);
        } else if (HussarUtils.isNotEmpty((Object)opptyPortraitScore.getArtificialScore())) {
            return null;
        }
        if (autoRefreshFlag) {
            opptyPortraitScore.setModifyTime(date);
        } else {
            opptyPortraitScore.setChangeTime(date);
        }
        JSONObject replaceValueJSON = new JSONObject();
        if (HussarUtils.equals((Object)opportunity.getState(), (Object)"14")) {
            opptyPortraitScore.setSystemScore(2.0);
            OpptyPortraitPrompt timePrompt = promptList.stream().filter(p -> HussarUtils.equals((Object)p.getDimension(), (Object)"time") && p.getScore().contains("2")).findFirst().get();
            opptyPortraitScore.setNegativeConclsion(timePrompt.getConclusion());
            opptyPortraitScore.setPositiveConclusion("");
            replaceValueJSON.put("layUpReason", (Object)opportunity.getPendReason());
            opptyPortraitScore.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
        } else if (stageList.contains(Long.parseLong(opportunity.getCustomerStageId())) && HussarUtils.isNotEmpty((Object)opportunity.getLaunchDatePlan())) {
            LocalDateTime threeMonthsLater = date.plusMonths(3L);
            LocalDateTime oneYearLater = date.plusMonths(12L);
            LocalDateTime launchDatePlan = opportunity.getLaunchDatePlan().toInstant().atZone(ZoneId.systemDefault()).toLocalDate().atStartOfDay();
            if (threeMonthsLater.isAfter(launchDatePlan)) {
                opptyPortraitScore.setSystemScore(5.0);
            } else if (oneYearLater.isAfter(launchDatePlan)) {
                opptyPortraitScore.setSystemScore(4.0);
            } else if (oneYearLater.isBefore(launchDatePlan)) {
                opptyPortraitScore.setSystemScore(3.0);
            }
            OpptyPortraitPrompt timePrompt = promptList.stream().filter(p -> HussarUtils.equals((Object)p.getDimension(), (Object)"time") && "5,4,3".equals(p.getScore())).findFirst().get();
            opptyPortraitScore.setPositiveConclusion(timePrompt.getConclusion());
            opptyPortraitScore.setNegativeConclsion("");
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5");
            replaceValueJSON.put("deliveryDate", (Object)launchDatePlan.format(formatter));
            replaceValueJSON.put("expectedPeriod", (Object)(Math.abs(ChronoUnit.MONTHS.between(date, launchDatePlan)) + "\u4e2a\u6708"));
            opptyPortraitScore.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
        } else {
            opptyPortraitScore.setSystemScore(1.0);
            OpptyPortraitPrompt timePrompt = promptList.stream().filter(p -> HussarUtils.equals((Object)p.getDimension(), (Object)"time") && p.getScore().contains("1")).findFirst().get();
            opptyPortraitScore.setNegativeConclsion(timePrompt.getConclusion());
            opptyPortraitScore.setPositiveConclusion("");
            opptyPortraitScore.setReplaceText("");
        }
        return opptyPortraitScore;
    }

    public OpptyPortraitScore calculateCompetitor(OpportunityAPIVo opportunity, List<OpptyPortraitScore> existedScoreList, List<CompetitorAnalysisAPIVo> allCompetitor, List<OpptyPortraitPrompt> promptList, DimensionVo competitorConfig, boolean autoRefreshFlag, LocalDateTime date) {
        OpptyPortraitScore opptyPortraitScore = existedScoreList.stream().filter(s -> HussarUtils.equals((Object)s.getOpportunityId(), (Object)opportunity.getOpportunityId()) && HussarUtils.equals((Object)s.getDimension(), (Object)"dimension_competitor")).findFirst().orElse(null);
        if (HussarUtils.isEmpty((Object)opptyPortraitScore)) {
            opptyPortraitScore = new OpptyPortraitScore();
            opptyPortraitScore.setOpportunityId(opportunity.getOpportunityId());
            opptyPortraitScore.setDimension("dimension_competitor");
            opptyPortraitScore.setCreateTime(date);
        } else if (HussarUtils.isNotEmpty((Object)opptyPortraitScore.getArtificialScore())) {
            return null;
        }
        if (autoRefreshFlag) {
            opptyPortraitScore.setModifyTime(date);
        } else {
            opptyPortraitScore.setChangeTime(date);
        }
        JSONObject replaceValueJSON = new JSONObject();
        List<Object> trackRecords = new ArrayList();
        List analysisList = allCompetitor.stream().filter(s -> HussarUtils.equals((Object)s.getOpportunityId(), (Object)opportunity.getOpportunityId()) && HussarUtils.isNotEmpty((Object)s.getQuoteAmount())).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(analysisList)) {
            if (analysisList.stream().anyMatch(a -> Double.parseDouble(a.getQuoteAmount()) > 0.0 && HussarUtils.isNotEmpty((Object)a.getBusinessRelation()))) {
                opptyPortraitScore.setSystemScore(5.0);
                OpptyPortraitPrompt competitorPrompt = promptList.stream().filter(p -> HussarUtils.equals((Object)p.getDimension(), (Object)"competitor") && p.getScore().contains("5")).findFirst().orElse(null);
                opptyPortraitScore.setPositiveConclusion(competitorPrompt.getConclusion());
                opptyPortraitScore.setNegativeConclsion("");
                replaceValueJSON.put("competitorNames", (Object)analysisList.stream().map(CompetitorAnalysisAPIVo::getCompetitorName).collect(Collectors.joining(",")));
                opptyPortraitScore.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
            } else if (analysisList.stream().map(CompetitorAnalysisAPIVo::getCompetitiveForce).count() > 0L && analysisList.stream().map(CompetitorAnalysisAPIVo::getContactingLevel).anyMatch(l -> HussarUtils.equals((Object)l, (Object)"\u521d\u6b65\u4ea4\u6d41") || HussarUtils.equals((Object)l, (Object)"\u6df1\u5165\u4ea4\u6d41"))) {
                opptyPortraitScore.setSystemScore(4.0);
                OpptyPortraitPrompt competitorPrompt = promptList.stream().filter(p -> HussarUtils.equals((Object)p.getDimension(), (Object)"competitor") && p.getScore().contains("4")).findFirst().get();
                opptyPortraitScore.setPositiveConclusion(competitorPrompt.getConclusion());
                opptyPortraitScore.setNegativeConclsion("");
                replaceValueJSON.put("competitorNames", (Object)analysisList.stream().map(CompetitorAnalysisAPIVo::getCompetitorName).collect(Collectors.joining(",")));
                opptyPortraitScore.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
            } else {
                opptyPortraitScore.setSystemScore(3.0);
                OpptyPortraitPrompt competitorPrompt = promptList.stream().filter(p -> HussarUtils.equals((Object)p.getDimension(), (Object)"competitor") && p.getScore().contains("3")).findFirst().get();
                opptyPortraitScore.setPositiveConclusion(competitorPrompt.getConclusion());
                opptyPortraitScore.setNegativeConclsion("");
                replaceValueJSON.put("competitorNames", (Object)analysisList.stream().map(CompetitorAnalysisAPIVo::getCompetitorName).collect(Collectors.joining(",")));
                opptyPortraitScore.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
            }
        } else {
            List<String> containList = Arrays.stream(competitorConfig.getThree().getTrackrecordContain().split("\u3001")).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
            List<String> noContainList = Arrays.stream(competitorConfig.getThree().getTrackrecordNoContain().split("\u3001")).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(containList) || HussarUtils.isNotEmpty(noContainList)) {
                trackRecords = this.opportunityPortraitMapper.opportunityTrack(opportunity.getOpportunityId(), containList, noContainList);
            }
            if (HussarUtils.isNotEmpty(trackRecords)) {
                opptyPortraitScore.setSystemScore(3.0);
                OpptyPortraitPrompt competitorPrompt = promptList.stream().filter(p -> HussarUtils.equals((Object)p.getDimension(), (Object)"competitor") && p.getScore().contains("3")).findFirst().get();
                opptyPortraitScore.setPositiveConclusion(competitorPrompt.getConclusion());
                opptyPortraitScore.setNegativeConclsion("");
                List<TrackRecordAPIVo> records = trackRecords.stream().filter(t -> HussarUtils.equals((Object)t.getTypeId(), (Object)opportunity.getOpportunityId())).collect(Collectors.toList());
                String finalMatch = OpptyPortraitCalculateServiceImpl.findMatchingKeywords(records, containList);
                replaceValueJSON.put("competitorNames", (Object)finalMatch);
                opptyPortraitScore.setReplaceText(JSONObject.toJSONString((Object)replaceValueJSON));
                return opptyPortraitScore;
            }
            containList = Arrays.stream(competitorConfig.getTwo().getTrackrecordContain().split("\u3001")).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
            noContainList = Arrays.stream(competitorConfig.getTwo().getTrackrecordNoContain().split("\u3001")).filter(HussarUtils::isNotEmpty).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(containList) || HussarUtils.isNotEmpty(noContainList)) {
                trackRecords = this.opportunityPortraitMapper.opportunityTrack(opportunity.getOpportunityId(), containList, noContainList);
            }
            if (HussarUtils.isNotEmpty(trackRecords)) {
                opptyPortraitScore.setSystemScore(2.0);
                OpptyPortraitPrompt competitorPrompt = promptList.stream().filter(s -> "competitor".equals(s.getDimension()) && s.getScore().contains("2")).findFirst().get();
                opptyPortraitScore.setNegativeConclsion(competitorPrompt.getConclusion());
                opptyPortraitScore.setPositiveConclusion("");
                opptyPortraitScore.setReplaceText("");
                return opptyPortraitScore;
            }
            opptyPortraitScore.setSystemScore(1.0);
            OpptyPortraitPrompt competitorPrompt = promptList.stream().filter(s -> "competitor".equals(s.getDimension()) && s.getScore().contains("1")).findFirst().get();
            opptyPortraitScore.setNegativeConclsion(competitorPrompt.getConclusion());
            opptyPortraitScore.setPositiveConclusion("");
            opptyPortraitScore.setReplaceText("");
        }
        return opptyPortraitScore;
    }

    private static String findMatchingKeywords(List<TrackRecordAPIVo> records, List<String> keywords) {
        HashSet<String> matchedKeywords = new HashSet<String>();
        for (TrackRecordAPIVo record : records) {
            String recordContent = record.getRecordContent();
            for (String keyword : keywords) {
                if (!recordContent.contains(keyword)) continue;
                matchedKeywords.add(keyword);
            }
        }
        return String.join((CharSequence)",", matchedKeywords);
    }
}

