/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.unify.service.impl;

import com.jxdinfo.crm.analysis.unify.dao.OpportunityAndAnalysisMapper;
import com.jxdinfo.crm.analysis.unify.service.OpportunityAndAnalysisService;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateStartEndVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.unify.vo.OpportunityIncreaseVo;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class OpportunityAndAnalysisServiceImpl
implements OpportunityAndAnalysisService {
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private OpportunityAndAnalysisMapper opportunityAndAnalysisMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    @Override
    public int selectCrmOpportunityListCount(OpportunityDto dto) {
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        OpportunityDto opportunityDto = this.opportunityQueryCondition(dto);
        if ("\u79bb\u804c".equals(dto.getOpportunityScreening())) {
            dto.setOpportunityScreening("");
            SysStru dimissionStru = this.commonMapper.getSysStruByOrganAlias("\u79bb\u804c");
            dto.setDimissionId(dimissionStru.getId());
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageAbandonConvert(true);
        stageTypeDto.setStageStart(true);
        stageTypeDto.setStageEnd(true);
        stageTypeDto.setStageWinLose(true);
        stageTypeDto.setStageWin(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        int oppCount = this.opportunityAndAnalysisMapper.selectCrmOpportunityListCount(opportunityDto, permissionDto, stageSelectDto);
        return oppCount;
    }

    @Override
    public List<Map<String, Object>> selectCrmOpportunityFunnelCountNoPermission(OpportunityDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        OpportunityDto opportunityDto = this.opportunityQueryCondition(dto);
        StageSelectDto stageSelectDto = this.getStageSelectDto();
        return this.opportunityAndAnalysisMapper.selectCrmOpportunityFunnelCount(opportunityDto, permissionDto, stageSelectDto);
    }

    @Override
    public List<Map<String, Object>> selectCrmOpportunityFunnelCount(OpportunityDto dto) {
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        OpportunityDto opportunityDto = this.opportunityQueryCondition(dto);
        if ("\u79bb\u804c".equals(dto.getOpportunityScreening())) {
            dto.setOpportunityScreening("");
            SysStru dimissionStru = this.commonMapper.getSysStruByOrganAlias("\u79bb\u804c");
            dto.setDimissionId(dimissionStru.getId());
        }
        StageSelectDto stageSelectDto = this.getStageSelectDto();
        List<Map<String, Object>> funnelList = this.opportunityAndAnalysisMapper.selectCrmOpportunityFunnelCount(opportunityDto, permissionDto, stageSelectDto);
        return funnelList;
    }

    @Override
    public List<Map<String, Object>> selectCrmOpportunityFunnelProductCount(OpportunityDto dto) {
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        OpportunityDto opportunityDto = this.opportunityQueryCondition(dto);
        if ("\u79bb\u804c".equals(dto.getOpportunityScreening())) {
            dto.setOpportunityScreening("");
            SysStru dimissionStru = this.commonMapper.getSysStruByOrganAlias("\u79bb\u804c");
            dto.setDimissionId(dimissionStru.getId());
        }
        StageSelectDto stageSelectDto = this.getStageSelectDto();
        List<Map<String, Object>> funnelList = this.opportunityAndAnalysisMapper.selectCrmOpportunityFunnelProductCount(opportunityDto, permissionDto, stageSelectDto);
        return funnelList;
    }

    @NotNull
    private StageSelectDto getStageSelectDto() {
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageAbandonConvert(true);
        stageTypeDto.setStageWinLose(true);
        return this.stageProcessApiService.getStageIdByType(stageTypeDto);
    }

    @Override
    public OpportunityIncreaseVo getOpportunity(SalesStatisticsDto salesStatisticsDto) {
        OpportunityDto dto = new OpportunityDto();
        if (ToolUtil.isNotEmpty((Object)salesStatisticsDto.getTimeRange())) {
            dto.setTimeRange(salesStatisticsDto.getTimeRange());
            dto.setEndTime("4");
        }
        dto.setSelectType("2");
        dto.setDelFlag(salesStatisticsDto.getDelFlag());
        dto.setOpportunityView("1");
        dto.setCurrentUserId(salesStatisticsDto.getCurrentUserId());
        if (HussarUtils.isNotEmpty((Object)salesStatisticsDto.getDeptIds())) {
            List deptIds = salesStatisticsDto.getDeptIds().stream().map(String::valueOf).collect(Collectors.toList());
            dto.setOwnDepartments(deptIds);
        }
        if (HussarUtils.isNotEmpty((Object)salesStatisticsDto.getStageIds())) {
            List stageIds = salesStatisticsDto.getStageIds().stream().map(String::valueOf).collect(Collectors.toList());
            dto.setCustomerStageIds(stageIds);
        }
        if (HussarUtils.isNotEmpty((Object)salesStatisticsDto.getUserIds())) {
            List userIds = salesStatisticsDto.getUserIds().stream().map(String::valueOf).collect(Collectors.toList());
            dto.setChargePersonIds(userIds);
        }
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        OpportunityDto opportunityDto = this.opportunityQueryCondition(dto);
        opportunityDto.setStartDate(salesStatisticsDto.getStartTime());
        opportunityDto.setEndDate(salesStatisticsDto.getEndTime());
        if ("\u79bb\u804c".equals(dto.getOpportunityScreening())) {
            dto.setOpportunityScreening("");
            SysStru dimissionStru = this.commonMapper.getSysStruByOrganAlias("\u79bb\u804c");
            dto.setDimissionId(dimissionStru.getId());
        }
        permissionDto.setProducts(salesStatisticsDto.getProducts());
        dto.setOpportunityView(null);
        return this.opportunityAndAnalysisMapper.selectOpportunity(opportunityDto, permissionDto);
    }

    private SalesStatisticsDto opportunityOperate(OpportunityDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        String opportunityView = dto.getOpportunityView();
        if (StringUtil.isNotEmpty((Object)opportunityView) && !"2".equals(opportunityView) && !"0".equals(opportunityView) && !"10".equals(opportunityView)) {
            SecurityUser user;
            if (dto != null && dto.getCurrentUserId() != null) {
                IndexUtil.getUserRolePermissionsByUserId((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties, (Long)dto.getCurrentUserId());
            } else {
                IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            }
            if ("6".equals(opportunityView)) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
            if ((user = BaseSecurityUtil.getUser()) == null || ToolUtil.isEmpty((Object)user.getUserId())) {
                CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
                user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
            }
            if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
        }
        return permissionDto;
    }

    private OpportunityDto opportunityQueryCondition(OpportunityDto dto) {
        DateStartEndVo dateStartEndVo;
        DateConvertVo dateConvertVo;
        String opportunityView;
        SecurityUser user;
        if (StringUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("1");
        }
        if (ToolUtil.isNotEmpty((Object)dto.getOpportunityScreening())) {
            dto.setOpportunityScreening(dto.getOpportunityScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if ((user = BaseSecurityUtil.getUser()) == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (Object userId : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        ArrayList<String> createPersonIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getCreatePersonIds()) && dto.getCreatePersonIds().size() > 0) {
            for (Object createPersonId : dto.getCreatePersonIds()) {
                createPersonIds.add(CommonUtills.translateUserId((String)createPersonId));
            }
            dto.setTransCreatePersonIds(createPersonIds);
        }
        ArrayList<String> teamMemberIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getTeamMemberIds()) && dto.getTeamMemberIds().size() > 0) {
            for (String teamMemberId : dto.getTeamMemberIds()) {
                teamMemberIds.add(CommonUtills.translateUserId((String)teamMemberId));
            }
            dto.setTransTeamMemberIds(teamMemberIds);
        }
        List departments = dto.getOwnDepartments();
        ArrayList odpIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList Ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        List createDepartments = dto.getCreateDepartments();
        ArrayList cdpIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)createDepartments) && createDepartments.size() > 0) {
            for (String cdpId : createDepartments) {
                ArrayList Ids;
                String cdpIsTemp = CommonUtills.translateDepId((String)cdpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)cdpIsTemp, Ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    cdpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransCreateDepartmentIds(cdpIds);
        }
        if ("2".equals(opportunityView = dto.getOpportunityView()) || "2".equals(dto.getCompetence())) {
            dto.setOpportunityView("myself");
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if ("6".equals(opportunityView)) {
            dto.setCreatePerson(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"3".equals(dto.getEndTime()) && !"6".equals(dto.getEndTime())) {
            dateConvertVo = IndexUtil.getCurrentTime((String)dto.getEndTime());
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        } else if ("6".equals(dto.getEndTime()) && StringUtil.isEmpty((Object)dto.getStartDate()) && StringUtil.isEmpty((Object)dto.getEndDate())) {
            dto.setEndTime(null);
        }
        dto.setDelFlag("0");
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getClaimTimeFlag()) && !"6".equals(dto.getClaimTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getClaimTimeFlag())) != null) {
            dto.setClaimTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setClaimTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getAllocateTimeFlag()) && !"6".equals(dto.getAllocateTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getAllocateTimeFlag())) != null) {
            dto.setAllocateTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setAllocateTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getRecycleTimeFlag()) && !"6".equals(dto.getRecycleTimeFlag()) && (dateStartEndVo = CrmDateUtils.inviteSevenFifteenThirtyTime((String)dto.getRecycleTimeFlag())) != null) {
            dto.setRecycleTimeStart(dateStartEndVo.getStartDate());
            dto.setRecycleTimeEnd(dateStartEndVo.getEndDate());
        }
        if (ToolUtil.isNotEmpty((Object)dto.getSuccessTimeRange()) && !"6".equals(dto.getSuccessTimeRange()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSuccessTimeRange())) != null) {
            dto.setSuccessStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setSuccessEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        if (ToolUtil.isNotEmpty((Object)dto.getTrackTimeFlag()) && !"6".equals(dto.getTrackTimeFlag()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getTrackTimeFlag())) != null) {
            dto.setTrackTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setTrackTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        dto.setCurrentUserId(user.getUserId());
        return dto;
    }
}

