/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.unify.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.analysis.unify.dao.PortalStatisticsMapper;
import com.jxdinfo.crm.analysis.unify.model.PopUpTerm;
import com.jxdinfo.crm.analysis.unify.service.PortalStatisticsService;
import com.jxdinfo.crm.analysis.unify.vo.HomeOrganVo;
import com.jxdinfo.crm.analysis.unify.vo.HomeProductVo;
import com.jxdinfo.crm.analysis.unify.vo.HomeProvinceVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductService;
import com.jxdinfo.crm.core.provincerole.model.ProvinceRole;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PortalStatisticsServiceImpl
extends ServiceImpl<PortalStatisticsMapper, PopUpTerm>
implements PortalStatisticsService {
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private ProductService productService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private PortalStatisticsMapper portalStatisticsMapper;

    @Override
    public Map<String, Object> getOpportunitiesRange() {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        Long deptId = user.getDeptId();
        Long provinceID = 100101L;
        List products = DataPermission.getPermissionProduct((Long)userId);
        List struList = DataPermission.getStruCache();
        List rolesList = user.getRolesList();
        Long companyLeader = Long.valueOf(this.crmProperties.getRoles().getCompanyLeader());
        List leadershipRoles = DataPermission.getLeadershipRoles();
        Long bgLeader = Long.valueOf(this.crmProperties.getRoles().getBgLeader());
        Long allOpportunity = Long.valueOf(this.crmProperties.getRoles().getAllOpportunity());
        boolean b = rolesList.contains(Long.valueOf(this.crmProperties.getRoles().getMarketingManager())) && !rolesList.contains(allOpportunity);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        List<Object> province = new ArrayList();
        List<SysStru> sysStrus = new ArrayList<Object>();
        List<Product> productList = this.getProduct(products);
        if (rolesList.contains(companyLeader) || rolesList.contains(allOpportunity)) {
            sysStrus.add((SysStru)this.sysStruService.getById((Serializable)Long.valueOf(100001L)));
            productList = null;
        } else if (DataPermission.isLeadship((List)rolesList, (List)leadershipRoles)) {
            List struIds = DataPermission.getLeadershipBGList((Long)userId);
            List struLongIds = struIds.stream().map(Long::valueOf).collect(Collectors.toList());
            sysStrus = this.sysStruService.listByIds(struLongIds);
            province = this.portalStatisticsMapper.getProvince(userId);
        } else if (rolesList.contains(bgLeader) || rolesList.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) || rolesList.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector())) || b) {
            Long parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)deptId);
            if (HussarUtils.isNotEmpty((Object)parentId) && parentId.equals(provinceID)) {
                parentId = deptId;
            }
            SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)parentId);
            sysStrus.add(sysStru);
            province = this.portalStatisticsMapper.getProvince(userId);
        }
        List provinceIds = province.stream().map(ProvinceRole::getProvinceId).collect(Collectors.toList());
        List collect = sysStrus.stream().filter(m -> !provinceIds.contains(m.getId())).collect(Collectors.toList());
        ArrayList<HomeOrganVo> homeOrganVos = new ArrayList<HomeOrganVo>();
        ArrayList<HomeProductVo> homeProductVos = new ArrayList<HomeProductVo>();
        ArrayList<HomeProvinceVo> homeProvinceVos = new ArrayList<HomeProvinceVo>();
        if (HussarUtils.isNotEmpty(collect)) {
            for (SysStru sysStru : collect) {
                HomeOrganVo homeOrganVo = new HomeOrganVo();
                BeanUtil.copyProperties((Object)sysStru, (Object)homeOrganVo);
                homeOrganVos.add(homeOrganVo);
            }
        }
        if (HussarUtils.isNotEmpty(province)) {
            for (ProvinceRole provinceRole : province) {
                HomeProvinceVo homeProvinceVo = new HomeProvinceVo();
                BeanUtil.copyProperties((Object)provinceRole, (Object)homeProvinceVo);
                homeProvinceVos.add(homeProvinceVo);
            }
        }
        if (HussarUtils.isNotEmpty(productList)) {
            for (Product product : productList) {
                HomeProductVo homeProductVo = new HomeProductVo();
                BeanUtil.copyProperties((Object)product, (Object)homeProductVo);
                homeProductVos.add(homeProductVo);
            }
        }
        resultMap.put("organList", homeOrganVos);
        resultMap.put("province", homeProvinceVos);
        resultMap.put("productList", homeProductVos);
        return resultMap;
    }

    private List<Product> getProduct(List<Long> product) {
        if (HussarUtils.isNotEmpty(product)) {
            return this.productService.listByIds(product);
        }
        return new ArrayList<Product>();
    }

    @Override
    public LocalDateTime getPopUpTerm() {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        LocalDateTime expiredTime = null;
        PopUpTerm popUpTerm = (PopUpTerm)((Object)this.getById(userId));
        if (HussarUtils.isNotEmpty((Object)((Object)popUpTerm))) {
            expiredTime = popUpTerm.getExpiredTime();
        } else {
            PopUpTerm popUp = new PopUpTerm();
            popUp.setUserId(userId);
            this.save((Object)popUp);
        }
        return expiredTime;
    }

    @Override
    public Boolean updatePopUpTerm() {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        PopUpTerm popUpTerm = new PopUpTerm();
        popUpTerm.setUserId(userId);
        long timeInterval = 0L;
        List noReminderTime = this.sysDicRefService.getDictByType("no_reminder_time");
        if (HussarUtils.isNotEmpty((Object)noReminderTime)) {
            DicSingle dicSingle = (DicSingle)noReminderTime.get(0);
            timeInterval = Long.parseLong(dicSingle.getValue());
        }
        popUpTerm.setExpiredTime(LocalDateTime.now().plusDays(timeInterval));
        return this.updateById((Object)popUpTerm);
    }
}

