/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.OppoDistributeMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.SalespersonAnalysisMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.AbnormalAnalysisDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.CustomerProfileAnalysisDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.FollowUpAnalysisDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.OpportunityAnalysisDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.OppoDistributeService;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.AbnormalAnalysisCustomerVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.AbnormalCellVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.AbnormalRowVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.DepartmentVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.ExcelCellVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.ExcelCellVo2;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.FollowUpAnalysisCellVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.FollowUpAnalysisVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.IntelligentProductVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.OpportunityDistributionVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.OpportunityVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.SalespersonVo;
import com.jxdinfo.crm.analysis.unify.dao.OpportunityAnalysisMapper;
import com.jxdinfo.crm.analysis.unify.dao.OpportunityAndAnalysisMapper;
import com.jxdinfo.crm.analysis.unify.service.UnifyPortalService;
import com.jxdinfo.crm.analysis.unify.vo.ProductAnalysisTreeVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.IUserBoService;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunitySuccessRateAPIService;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageSelectDto;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.crm.datasourcefolder.crmopportunitystage1.service.CrmOpportunityStage1Service;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.intelligentanalysis.vo.ChargePersonVo;
import com.jxdinfo.crm.core.intelligentanalysis.vo.FollowUpAnalysisDeptVo;
import com.jxdinfo.crm.core.opportunity.dao.OpportunityMapper;
import com.jxdinfo.crm.core.opportunity.dto.OpportunityDto;
import com.jxdinfo.crm.core.opportunity.model.OpportunityEntity;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.model.OpportunitySuccessRateConfig;
import com.jxdinfo.crm.core.opportunity.model.SuccessRateDic;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.product.dao.ProductMapper;
import com.jxdinfo.crm.core.product.model.Product;
import com.jxdinfo.crm.core.product.service.ProductTypeAService;
import com.jxdinfo.crm.core.scene.dao.CrmSceneMapper;
import com.jxdinfo.crm.core.scene.model.CrmScene;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.crm.core.utills.ExcelStyle;
import com.jxdinfo.crm.core.utills.entity.DateConvertVo;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruService;
import com.jxdinfo.hussar.authorization.permit.model.SysUsers;
import com.jxdinfo.hussar.authorization.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.base.entity.HussarDelflagEntity;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.job.execution.common.utils.SpringUtils;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class OppoDistributeServiceImpl
extends ServiceImpl<OpportunityMapper, OpportunityEntity>
implements OppoDistributeService {
    @Resource
    private OpportunityMapper opportunityMapper;
    @Resource
    private OppoDistributeMapper oppoDistributeMapper;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ISysStruService sysStruService;
    @Resource
    private CrmOpportunityStage1Service crmOpportunityStage1;
    @Resource
    private CommonMapper commonMapper;
    @Resource
    private ProductTypeAService productTypeAService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private CrmSceneMapper crmSceneMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private SalespersonAnalysisMapper salespersonAnalysisMapper;
    @Resource
    private IOpportunitySuccessRateAPIService opportunitySuccessRateAPIService;
    @Resource
    private ProductMapper productMapper;
    @Resource
    private OpportunityAnalysisMapper opportunityAnalysisMapper;
    @Resource
    private UnifyPortalService unifyPortalService;
    @Resource
    private OpportunityAndAnalysisMapper opportunityAndAnalysisMapper;
    @Resource
    private IUserBoService iUserBoService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IStageProcessApiService stageProcessApiService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    public static final String[] ABNORMAL_TYPE = new String[]{"opportunityAbnormalOverdue", "opportunityAbnormalWin", "opportunityAbnormalInfo", "customerAbnormalInfo"};
    public static final String[] ABNORMAL_TYPE_NAME = new String[]{"\u903e\u671f\u672a\u63a8\u8fdb\u5546\u673a", "\u9884\u8ba1\u6210\u4ea4\u65f6\u95f4\u5f02\u5e38\u5546\u673a", "\u4fe1\u606f\u5f02\u5e38\u5546\u673a", "\u4fe1\u606f\u5f02\u5e38\u5ba2\u6237"};

    @Override
    public List<OpportunityDistributionVo> chargePerson2(OpportunityDto dto) {
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo;
        if (CollectionUtil.isEmpty((Collection)dto.getShowCustStageIds())) {
            return new ArrayList<OpportunityDistributionVo>();
        }
        dto.setDelFlag("0");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OpportunityStage::getDelFlag, (Object)"0");
        if (ToolUtil.isNotEmpty((Object)dto.getStageProcessId())) {
            queryWrapper.eq(OpportunityStage::getStageProcessId, (Object)dto.getStageProcessId());
        }
        List oppoStageList = this.opportunityStageService.list((Wrapper)queryWrapper);
        List currentCustomerStageIds = oppoStageList.stream().map(OpportunityStage::getCustomerStageId).map(String::valueOf).collect(Collectors.toList());
        List opptyStageIdsWin = oppoStageList.stream().filter(s -> "20".equals(s.getStageType())).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        List opptyStageIdsLoseAbandon = oppoStageList.stream().filter(s -> "21".equals(s.getStageType()) || "22".equals(s.getStageType()) || "23".equals(s.getStageType())).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        Map<String, OpportunityStage> opportunityStageMap = oppoStageList.stream().collect(Collectors.toMap(os -> String.valueOf(os.getCustomerStageId()), o -> o));
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            throw new HussarException("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\u5931\u8d25");
        }
        dto.setOpportunityView("1");
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"3".equals(dto.getEndTime()) && !"6".equals(dto.getEndTime())) {
            dateConvertVo = IndexUtil.getCurrentTime((String)dto.getEndTime());
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getSuccessTimeRange()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSuccessTimeRange())) != null) {
            dto.setSuccessStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setSuccessEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        this.createTimeFlag(dto);
        if (CollectionUtil.isNotEmpty((Collection)dto.getTransOwnDepartmentIds())) {
            List deptIds = dto.getTransOwnDepartmentIds();
            List dtoDeptIds = deptIds.stream().map(Long::parseLong).collect(Collectors.toList());
            List deptIdsAll = this.commonMapper.selectDeptIdParentId(dtoDeptIds);
            List deptIdsAllString = deptIdsAll.stream().map(String::valueOf).collect(Collectors.toList());
            deptIds.addAll(deptIdsAllString);
            dto.setTransOwnDepartmentIds(deptIds);
        }
        List<ChargePersonVo> chargePersonList = this.oppoDistributeMapper.selectChargePersonListByOppo(dto, permissionDto);
        List<ExcelCellVo> excelCellVoList = this.oppoDistributeMapper.selectChargePersonCellVos(dto, permissionDto);
        Map<String, List<ExcelCellVo>> listMap = excelCellVoList.stream().collect(Collectors.groupingBy(ExcelCellVo::getCustomerStageId));
        HashMap<String, OpportunityDistributionVo> resultMap = new HashMap<String, OpportunityDistributionVo>();
        OpportunitySuccessRateConfig successRateConfig = (OpportunitySuccessRateConfig)HussarUtils.readJson((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("success_rate_config").getConfigValue(), OpportunitySuccessRateConfig.class);
        boolean configModel1 = successRateConfig.getModelsInUse().contains("1");
        boolean configModel2 = successRateConfig.getModelsInUse().contains("2");
        boolean winStageModel1Flag = configModel1 && "1".equals(successRateConfig.getModelOneConfig().getIncludeWin());
        boolean winStageModel2Flag = configModel2 && "1".equals(successRateConfig.getModelTwoConfig().getIncludeWin());
        Map<Object, Object> model1SuccessRateMap = new HashMap();
        Map<Object, Object> model2SuccessRateMap = new HashMap();
        if (configModel1) {
            List successRateVoList = this.opportunitySuccessRateAPIService.getSuccessRate(null, null);
            model1SuccessRateMap = successRateVoList.stream().collect(Collectors.toMap(s -> String.valueOf(s.getStageId()), successRateVo -> Double.parseDouble(successRateVo.getSuccessRate().replace("%", "")) / 100.0, (key1, key2) -> key1));
        }
        if (configModel2) {
            model2SuccessRateMap = successRateConfig.getModelTwoConfig().getSuccessRateDic().stream().collect(Collectors.toMap(SuccessRateDic::getValue, s -> Double.valueOf(s.getSuccessRateValue().intValue()) / 100.0));
        }
        for (ChargePersonVo personVo : chargePersonList) {
            Double predictedAmount1 = configModel1 ? Double.valueOf(0.0) : null;
            Double predictedAmount2 = configModel2 ? Double.valueOf(0.0) : null;
            for (Map.Entry<String, List<ExcelCellVo>> entry : listMap.entrySet()) {
                for (ExcelCellVo excelCellVo : entry.getValue()) {
                    OpportunityDistributionVo od;
                    if (!excelCellVo.getDataId().equals(personVo.getUserId())) continue;
                    OpportunityStage os2 = opportunityStageMap.get(excelCellVo.getCustomerStageId());
                    if (!resultMap.containsKey(personVo.getUserId())) {
                        od = new OpportunityDistributionVo();
                        od.setChargePersonId(personVo.getUserId());
                        od.setChargePersonName(personVo.getUserName());
                        od.setDeptId(personVo.getStruId());
                        od.setDeptName(personVo.getOrganAlias());
                        od.setShortName(personVo.getShortName());
                        od.setStaffPosition(personVo.getStaffPosition());
                        od.setUserOrder(personVo.getUserOrder());
                        od.setStruOrder(personVo.getStruOrder());
                        resultMap.put(personVo.getUserId(), od);
                    } else {
                        od = (OpportunityDistributionVo)resultMap.get(personVo.getUserId());
                    }
                    OpportunityDistributionVo odChild = new OpportunityDistributionVo();
                    OppoDistributeServiceImpl.departPersonStageSwitch(excelCellVo, opportunityStageMap, odChild);
                    od.add(odChild);
                    if (opptyStageIdsWin.contains(Long.parseLong(excelCellVo.getCustomerStageId()))) {
                        if (winStageModel1Flag) {
                            predictedAmount1 = predictedAmount1 + excelCellVo.getAmount();
                        }
                        if (!winStageModel2Flag) continue;
                        predictedAmount2 = predictedAmount2 + excelCellVo.getAmount();
                        continue;
                    }
                    if (opptyStageIdsLoseAbandon.contains(Long.parseLong(excelCellVo.getCustomerStageId()))) continue;
                    if (configModel1 && model1SuccessRateMap.get(excelCellVo.getCustomerStageId()) != null) {
                        predictedAmount1 = predictedAmount1 + excelCellVo.getAmount() * (Double)model1SuccessRateMap.get(excelCellVo.getCustomerStageId());
                    }
                    if (!configModel2 || model2SuccessRateMap.get(excelCellVo.getOpportunityWinRate()) == null) continue;
                    predictedAmount2 = predictedAmount2 + excelCellVo.getAmount() * (Double)model2SuccessRateMap.get(excelCellVo.getOpportunityWinRate());
                }
            }
            ((OpportunityDistributionVo)resultMap.get(personVo.getUserId())).setSumCount(((OpportunityDistributionVo)resultMap.get(personVo.getUserId())).calculateSumCount());
            ((OpportunityDistributionVo)resultMap.get(personVo.getUserId())).setSumAmount(((OpportunityDistributionVo)resultMap.get(personVo.getUserId())).calculateSumAmount());
            ((OpportunityDistributionVo)resultMap.get(personVo.getUserId())).setYc1Amount(predictedAmount1);
            ((OpportunityDistributionVo)resultMap.get(personVo.getUserId())).setYc2Amount(predictedAmount2);
        }
        ArrayList<OpportunityDistributionVo> result = new ArrayList<OpportunityDistributionVo>(resultMap.values());
        OpportunityDistributionVo total = new OpportunityDistributionVo();
        total.setChargePersonName("\u5408\u8ba1");
        total.setChargePersonId("\u5408\u8ba1");
        total.setStruOrder(9999999);
        total.setUserOrder(9999999);
        for (OpportunityDistributionVo odv : result) {
            total.add(odv);
        }
        result.add(total);
        result.forEach(e -> {
            if (e.getStruOrder() == null) {
                e.setStruOrder(999999);
            }
        });
        result.sort(Comparator.comparingInt(OpportunityDistributionVo::getStruOrder).thenComparingInt(o -> {
            if (o.getUserOrder() != null) {
                return o.getUserOrder();
            }
            return 999999;
        }));
        return result;
    }

    private static void departPersonStageSwitch(ExcelCellVo excelCellVo, Map<String, OpportunityStage> opportunityStageMap, OpportunityDistributionVo od) {
        switch (opportunityStageMap.get(excelCellVo.getCustomerStageId()).getStageNameValue()) {
            case "1": {
                od.setStage1Count(excelCellVo.getCountnum());
                od.setStage1Amount(excelCellVo.getAmount());
                break;
            }
            case "2": {
                od.setStage2Count(excelCellVo.getCountnum());
                od.setStage2Amount(excelCellVo.getAmount());
                break;
            }
            case "3": {
                od.setStage3Count(excelCellVo.getCountnum());
                od.setStage3Amount(excelCellVo.getAmount());
                break;
            }
            case "4": {
                od.setStage4Count(excelCellVo.getCountnum());
                od.setStage4Amount(excelCellVo.getAmount());
                break;
            }
            case "5": {
                od.setStage5Count(excelCellVo.getCountnum());
                od.setStage5Amount(excelCellVo.getAmount());
                break;
            }
            case "6": {
                od.setStage6Count(excelCellVo.getCountnum());
                od.setStage6Amount(excelCellVo.getAmount());
                break;
            }
            case "7": {
                od.setStage7Count(excelCellVo.getCountnum());
                od.setStage7Amount(excelCellVo.getAmount());
                break;
            }
            case "8": {
                od.setStage8Count(excelCellVo.getCountnum());
                od.setStage8Amount(excelCellVo.getAmount());
                break;
            }
            case "9": {
                od.setStage9Count(excelCellVo.getCountnum());
                od.setStage9Amount(excelCellVo.getAmount());
                break;
            }
            case "10": {
                od.setStage10Count(excelCellVo.getCountnum());
                od.setStage10Amount(excelCellVo.getAmount());
                break;
            }
        }
    }

    private static void productStageSwitch(IntelligentProductVo productVo, Map<Long, OpportunityStage> opportunityStageMap, OpportunityDistributionVo od) {
        switch (opportunityStageMap.get(productVo.getStageId()).getStageNameValue()) {
            case "1": {
                od.setStage1Count(productVo.getCount().intValue());
                od.setStage1Amount(productVo.getAmount());
                break;
            }
            case "2": {
                od.setStage2Count(productVo.getCount().intValue());
                od.setStage2Amount(productVo.getAmount());
                break;
            }
            case "3": {
                od.setStage3Count(productVo.getCount().intValue());
                od.setStage3Amount(productVo.getAmount());
                break;
            }
            case "4": {
                od.setStage4Count(productVo.getCount().intValue());
                od.setStage4Amount(productVo.getAmount());
                break;
            }
            case "5": {
                od.setStage5Count(productVo.getCount().intValue());
                od.setStage5Amount(productVo.getAmount());
                break;
            }
            case "6": {
                od.setStage6Count(productVo.getCount().intValue());
                od.setStage6Amount(productVo.getAmount());
                break;
            }
            case "7": {
                od.setStage7Count(productVo.getCount().intValue());
                od.setStage7Amount(productVo.getAmount());
                break;
            }
            case "8": {
                od.setStage8Count(productVo.getCount().intValue());
                od.setStage8Amount(productVo.getAmount());
                break;
            }
            case "9": {
                od.setStage9Count(productVo.getCount().intValue());
                od.setStage9Amount(productVo.getAmount());
                break;
            }
            case "10": {
                od.setStage10Count(productVo.getCount().intValue());
                od.setStage10Amount(productVo.getAmount());
                break;
            }
        }
    }

    @Override
    public List<OpportunityDistributionVo> department2(OpportunityDto dto) {
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo;
        Object sysStru;
        if (CollectionUtil.isEmpty((Collection)dto.getShowCustStageIds())) {
            return new ArrayList<OpportunityDistributionVo>();
        }
        dto.setDelFlag("0");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OpportunityStage::getDelFlag, (Object)"0");
        if (ToolUtil.isNotEmpty((Object)dto.getStageProcessId())) {
            queryWrapper.eq(OpportunityStage::getStageProcessId, (Object)dto.getStageProcessId());
        }
        List oppoStageList = this.opportunityStageService.list((Wrapper)queryWrapper);
        List currentCustomerStageIds = oppoStageList.stream().map(OpportunityStage::getCustomerStageId).map(String::valueOf).collect(Collectors.toList());
        List opptyStageIdsWin = oppoStageList.stream().filter(s -> "20".equals(s.getStageType())).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        List opptyStageIdsLoseAbandon = oppoStageList.stream().filter(s -> "21".equals(s.getStageType()) || "22".equals(s.getStageType()) || "23".equals(s.getStageType())).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        Map<String, OpportunityStage> opportunityStageMap = oppoStageList.stream().collect(Collectors.toMap(os -> String.valueOf(os.getCustomerStageId()), o -> o));
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            throw new HussarException("\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4eba\u4fe1\u606f\u5931\u8d25");
        }
        dto.setOpportunityView("1");
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        Long userId = user.getId();
        List userRoles = user.getRolesList();
        List struList = DataPermission.getStruCache();
        int struLevel = 2;
        if (dto.getDeptIds() != null && dto.getDeptIds().size() > 0) {
            List deptIds = dto.getDeptIds();
            List deptIdsAll = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf((String)deptIds.get(0)));
            deptIds.addAll(deptIdsAll);
            dto.setDeptIds(deptIds);
            sysStru = (SysStru)this.sysStruService.getById((Serializable)dto.getDeptIds().get(0));
            struLevel = sysStru.getStruLevel() + 1;
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity())) || userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader())) || userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getProductManager()))) {
            dto.setDeptIds(null);
            dto.setChargePersonId(null);
        } else if (DataPermission.isLeadship((List)userRoles, (List)DataPermission.getLeadershipRoles())) {
            dto.setDeptIds(null);
            dto.setChargePersonId(null);
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader()))) {
            Long parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)user.getDeptId());
            List deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)parentId);
            dto.setDeptIds(deptIds);
            if (deptIds != null && deptIds.size() > 0) {
                sysStru = (SysStru)this.sysStruService.getById((Serializable)dto.getDeptIds().get(0));
                struLevel = sysStru.getStruLevel() + 1;
            }
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector()))) {
            dto.setDeptIds(Collections.singletonList(user.getDeptId().toString()));
            SysStru sysStru2 = (SysStru)this.sysStruService.getById((Serializable)dto.getDeptIds().get(0));
            struLevel = sysStru2.getStruLevel();
        } else {
            dto.setDeptIds(null);
            dto.setChargePersonId(userId.toString());
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"3".equals(dto.getEndTime()) && !"6".equals(dto.getEndTime())) {
            dateConvertVo = IndexUtil.getCurrentTime((String)dto.getEndTime());
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getSuccessTimeRange())) {
            dto.setSuccessTimeRange(dto.getSuccessTimeRange());
            dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSuccessTimeRange());
            if (dateConvertVo != null) {
                dto.setSuccessStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
                dto.setSuccessEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
            }
        }
        this.createTimeFlag(dto);
        if (ToolUtil.isNotEmpty((Object)dto.getTransOwnDepartmentIds()) && dto.getTransOwnDepartmentIds().size() > 0) {
            List ownDepts = dto.getTransOwnDepartmentIds();
            ArrayList ownDeptList = new ArrayList();
            ownDeptList.addAll(ownDepts);
            for (String struId : ownDepts) {
                List deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf(struId));
                ownDeptList.addAll(deptIds);
            }
            dto.setTransOwnDepartmentIds(ownDeptList);
        }
        ArrayList excelDeptRowVoList = new ArrayList(16);
        List<DepartmentVo> deptList = this.oppoDistributeMapper.selectDepartListByOppo(dto, permissionDto, struLevel);
        List<ExcelCellVo> excelCellVoList = this.oppoDistributeMapper.selectDepartCellVos(dto, permissionDto, struLevel);
        if (excelCellVoList == null || excelCellVoList.isEmpty()) {
            return new ArrayList<OpportunityDistributionVo>();
        }
        Map<String, List<ExcelCellVo>> listMap = excelCellVoList.stream().collect(Collectors.groupingBy(ExcelCellVo::getDataId));
        ArrayList<OpportunityDistributionVo> resultList = new ArrayList<OpportunityDistributionVo>();
        OpportunitySuccessRateConfig successRateConfig = (OpportunitySuccessRateConfig)HussarUtils.readJson((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("success_rate_config").getConfigValue(), OpportunitySuccessRateConfig.class);
        boolean configModel1 = successRateConfig.getModelsInUse().contains("1");
        boolean configModel2 = successRateConfig.getModelsInUse().contains("2");
        boolean winStageModel1Flag = configModel1 && "1".equals(successRateConfig.getModelOneConfig().getIncludeWin());
        boolean winStageModel2Flag = configModel2 && "1".equals(successRateConfig.getModelTwoConfig().getIncludeWin());
        Map<Object, Object> model1SuccessRateMap = new HashMap();
        Map<Object, Object> model2SuccessRateMap = new HashMap();
        if (configModel1) {
            List successRateVoList = this.opportunitySuccessRateAPIService.getSuccessRate(null, null);
            model1SuccessRateMap = successRateVoList.stream().collect(Collectors.toMap(s -> String.valueOf(s.getStageId()), successRateVo -> Double.parseDouble(successRateVo.getSuccessRate().replace("%", "")) / 100.0, (key1, key2) -> key1));
        }
        if (configModel2) {
            model2SuccessRateMap = successRateConfig.getModelTwoConfig().getSuccessRateDic().stream().collect(Collectors.toMap(SuccessRateDic::getValue, s -> Double.valueOf(s.getSuccessRateValue().intValue()) / 100.0));
        }
        for (DepartmentVo department : deptList) {
            if (listMap.get(department.getStruId()) == null) continue;
            OpportunityDistributionVo od = new OpportunityDistributionVo();
            od.setDeptId(department.getStruId());
            od.setDeptName(department.getOrganAlias());
            od.setShortName(department.getShortName());
            od.setStruOrder(department.getStruOrder());
            od.setNextLevel(department.getIsLeaf());
            Double predictedAmount1 = configModel1 ? Double.valueOf(0.0) : null;
            Double predictedAmount2 = configModel2 ? Double.valueOf(0.0) : null;
            for (ExcelCellVo excelCellVo : listMap.get(department.getStruId())) {
                OpportunityDistributionVo odChild = new OpportunityDistributionVo();
                OppoDistributeServiceImpl.departPersonStageSwitch(excelCellVo, opportunityStageMap, odChild);
                od.add(odChild);
                if (opptyStageIdsWin.contains(Long.parseLong(excelCellVo.getCustomerStageId()))) {
                    if (winStageModel1Flag) {
                        predictedAmount1 = predictedAmount1 + excelCellVo.getAmount();
                    }
                    if (!winStageModel2Flag) continue;
                    predictedAmount2 = predictedAmount2 + excelCellVo.getAmount();
                    continue;
                }
                if (opptyStageIdsLoseAbandon.contains(Long.parseLong(excelCellVo.getCustomerStageId()))) continue;
                if (configModel1 && model1SuccessRateMap.get(excelCellVo.getCustomerStageId()) != null) {
                    predictedAmount1 = predictedAmount1 + excelCellVo.getAmount() * (Double)model1SuccessRateMap.get(excelCellVo.getCustomerStageId());
                }
                if (!configModel2 || model2SuccessRateMap.get(excelCellVo.getOpportunityWinRate()) == null) continue;
                predictedAmount2 = predictedAmount2 + excelCellVo.getAmount() * (Double)model2SuccessRateMap.get(excelCellVo.getOpportunityWinRate());
            }
            od.setYc1Amount(predictedAmount1);
            od.setYc2Amount(predictedAmount2);
            od.setSumCount(od.calculateSumCount());
            od.setSumAmount(od.calculateSumAmount());
            resultList.add(od);
        }
        OpportunityDistributionVo total = new OpportunityDistributionVo();
        total.setDeptId("\u5408\u8ba1");
        total.setDeptName("\u5408\u8ba1");
        total.setStruOrder(9999999);
        for (OpportunityDistributionVo odv : resultList) {
            total.add(odv);
        }
        resultList.add(total);
        return resultList;
    }

    private ExcelCellVo2 initStageExcelCell(String deptId, OpportunityStage stage) {
        ExcelCellVo2 cell = new ExcelCellVo2();
        cell.setDeptId(deptId);
        cell.setCustomerStageId(stage.getCustomerStageId().toString());
        cell.setCustomerStageName(stage.getCustomerStageName());
        cell.setCountnum(0L);
        cell.setAmount(0.0);
        return cell;
    }

    private SalesStatisticsDto opportunityOperate(OpportunityDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        String opportunityView = dto.getOpportunityView();
        if (StringUtil.isNotEmpty((Object)opportunityView) && !"2".equals(opportunityView) && !"0".equals(opportunityView) && !"10".equals(opportunityView)) {
            if (dto != null && dto.getCurrentUserId() != null) {
                IndexUtil.getUserRolePermissionsByUserId((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties, (Long)dto.getCurrentUserId());
            } else {
                IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            }
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
                CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
                user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
            }
            if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
        }
        return permissionDto;
    }

    @Override
    public List<OpportunityDistributionVo> intelligentProductAnalysis(OpportunityDto dto) {
        if (CollectionUtil.isEmpty((Collection)dto.getShowCustStageIds())) {
            return new ArrayList<OpportunityDistributionVo>();
        }
        dto.setOpportunityView("1");
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        List<OpportunityDto> queryDtoList = this.getOpportUnityDtoList(dto);
        if ("\u79bb\u804c".equals(dto.getOpportunityScreening())) {
            dto.setOpportunityScreening("");
            dto.setDimissionId(this.commonMapper.getSysStruByOrganAlias("\u79bb\u804c").getId());
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getSuccessTimeRange())) {
            dto.setSuccessTimeRange(dto.getSuccessTimeRange());
            com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getSuccessTimeRange());
            if (dateConvertVo != null) {
                dto.setSuccessStartDate(LocalDate.parse(dateConvertVo.getStartDate()));
                dto.setSuccessEndDate(LocalDate.parse(dateConvertVo.getEndDate()));
            }
        }
        List<Object> productTreeVoList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)dto.getProductIds())) {
            List products1 = this.productMapper.selectBatchIds((Collection)dto.getProductIds());
            ArrayList<Long> productCategoryAllIds = new ArrayList<Long>();
            for (Product vo2 : products1) {
                ProductAnalysisTreeVo voTemp = new ProductAnalysisTreeVo();
                voTemp.setTreeType("2");
                voTemp.setProductId(vo2.getProductId());
                voTemp.setProductName(vo2.getProductName());
                voTemp.setProductShortName(vo2.getShortName());
                if (ToolUtil.isNotEmpty((Object)vo2.getOrderNumber())) {
                    voTemp.setOrders(Integer.parseInt(vo2.getOrderNumber()));
                } else {
                    voTemp.setOrders(9999);
                }
                productTreeVoList.add(voTemp);
                productCategoryAllIds.add(vo2.getProductId());
                dto.setProductCategoryAllId(productCategoryAllIds);
            }
        } else {
            productTreeVoList = this.unifyPortalService.getProductTreeVoListByProductIds();
        }
        if (ToolUtil.isNotEmpty((Object)dto.getProductCategoryId()) && ToolUtil.isEmpty((Object)dto.getProductIds())) {
            productTreeVoList = this.unifyPortalService.getProductTreeVoListByParentCategoryId(dto.getProductCategoryId());
        }
        ArrayList excelColumnVoList = new ArrayList();
        List<IntelligentProductVo> voList = this.oppoDistributeMapper.intelligentProductAnalysis(dto.getCurrentUserId(), queryDtoList, permissionDto, dto.getTimeOrder());
        OpportunitySuccessRateConfig successRateConfig = (OpportunitySuccessRateConfig)HussarUtils.readJson((String)this.crmBaseConfigBoService.getCrmBaseConfigByKey("success_rate_config").getConfigValue(), OpportunitySuccessRateConfig.class);
        boolean configModel1 = successRateConfig.getModelsInUse().contains("1");
        boolean configModel2 = successRateConfig.getModelsInUse().contains("2");
        boolean winStageModel1Flag = configModel1 && "1".equals(successRateConfig.getModelOneConfig().getIncludeWin());
        boolean winStageModel2Flag = configModel2 && "1".equals(successRateConfig.getModelTwoConfig().getIncludeWin());
        boolean groupByProductFlag = !"1".equals(successRateConfig.getModelOneConfig().getDistinguishProduct()) && !CollectionUtil.isEmpty((Collection)dto.getProductCategoryAllId());
        Map<Object, Object> model1SuccessRateMap = new HashMap();
        Map<Object, Object> model2SuccessRateMap = new HashMap();
        if (configModel1) {
            List successRateVoList;
            if (!groupByProductFlag) {
                successRateVoList = this.opportunitySuccessRateAPIService.getSuccessRate(null, null);
                model1SuccessRateMap = successRateVoList.stream().collect(Collectors.toMap(s -> String.valueOf(s.getStageId()), successRateVo -> Double.parseDouble(successRateVo.getSuccessRate().replace("%", "")) / 100.0, (key1, key2) -> key1));
            } else {
                successRateVoList = this.opportunitySuccessRateAPIService.getSuccessRate(dto.getProductCategoryAllId(), null);
                model1SuccessRateMap = successRateVoList.stream().collect(Collectors.toMap(s -> String.valueOf(s.getStageId()) + s.getProductId(), successRateVo -> Double.parseDouble(successRateVo.getSuccessRate().replace("%", "")) / 100.0, (key1, key2) -> key1));
            }
        }
        if (configModel2) {
            model2SuccessRateMap = successRateConfig.getModelTwoConfig().getSuccessRateDic().stream().collect(Collectors.toMap(SuccessRateDic::getValue, s -> Double.valueOf(s.getSuccessRateValue().intValue()) / 100.0));
        }
        Map<Long, List<IntelligentProductVo>> productIdMap = voList.stream().filter(m -> HussarUtils.isNotEmpty((Object)m.getProductId())).collect(Collectors.groupingBy(IntelligentProductVo::getProductId));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(OpportunityStage::getDelFlag, (Object)"0");
        if (ToolUtil.isNotEmpty((Object)dto.getStageProcessId())) {
            queryWrapper.eq(OpportunityStage::getStageProcessId, (Object)dto.getStageProcessId());
        }
        List opportunityStageList = this.opportunityStageService.list((Wrapper)queryWrapper);
        List currentCustomerStageIds = opportunityStageList.stream().map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        List opptyStageIdsWin = opportunityStageList.stream().filter(s -> "20".equals(s.getStageType())).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        List opptyStageIdsLoseAbandon = opportunityStageList.stream().filter(s -> "21".equals(s.getStageType()) || "22".equals(s.getStageType()) || "23".equals(s.getStageType())).map(OpportunityStage::getCustomerStageId).collect(Collectors.toList());
        Map<Long, OpportunityStage> opportunityStageMap = opportunityStageList.stream().collect(Collectors.toMap(OpportunityStage::getCustomerStageId, o -> o));
        String totalSign = "\u5408\u8ba1";
        String forecastSign = "\u9884\u6d4b";
        List stageCollect = opportunityStageList.stream().map(m -> String.valueOf(m.getCustomerStageId())).collect(Collectors.toList());
        stageCollect.add(totalSign);
        stageCollect.add(forecastSign);
        ArrayList<Long> keyList = new ArrayList<Long>(productIdMap.keySet());
        for (ProductAnalysisTreeVo productAnalysisTreeVo : productTreeVoList) {
            if (!ToolUtil.isEmpty((Object)productAnalysisTreeVo.getOrders()) && productAnalysisTreeVo.getOrders() != 0) continue;
            productAnalysisTreeVo.setOrders(9999);
        }
        ArrayList<Object> productTreeVosFinal = new ArrayList<Object>();
        List list = productTreeVoList.stream().filter(vo -> "1".equals(vo.getTreeType())).collect(Collectors.toList());
        List productTreeVosType2 = productTreeVoList.stream().filter(vo -> "2".equals(vo.getTreeType())).collect(Collectors.toList());
        for (Long productId : keyList) {
            for (Object treeVo : list) {
                if (!ToolUtil.isNotEmpty(((ProductAnalysisTreeVo)treeVo).getProductNodeIdList()) || ((ProductAnalysisTreeVo)treeVo).getProductNodeIdList().contains(productId)) continue;
                ((ProductAnalysisTreeVo)treeVo).getProductNodeIdList().remove(productId);
            }
        }
        List<Object> productTreeVosType11 = new ArrayList();
        productTreeVosType11 = list.stream().filter(s -> ToolUtil.isNotEmpty(s.getProductNodeIdList())).collect(Collectors.toList());
        productTreeVosType11.sort(Comparator.comparing(ProductAnalysisTreeVo::getOrders));
        productTreeVosFinal.addAll(productTreeVosType11);
        List<Object> productTreeVosType22 = new ArrayList();
        productTreeVosType22 = productTreeVosType2.stream().filter(s -> keyList.contains(s.getProductId())).collect(Collectors.toList());
        productTreeVosType22.sort(Comparator.comparing(ProductAnalysisTreeVo::getOrders));
        productTreeVosFinal.addAll(productTreeVosType22);
        ArrayList<OpportunityDistributionVo> resultList = new ArrayList<OpportunityDistributionVo>();
        for (ProductAnalysisTreeVo productAnalysisTreeVo : productTreeVosFinal) {
            Double predictedAmount1 = configModel1 ? Double.valueOf(0.0) : null;
            Double predictedAmount2 = configModel2 ? Double.valueOf(0.0) : null;
            OpportunityDistributionVo od = new OpportunityDistributionVo();
            od.setProductId(productAnalysisTreeVo.getProductId());
            od.setProductCategoryId(productAnalysisTreeVo.getProductCategoryId());
            od.setProductName(productAnalysisTreeVo.getProductShortName());
            od.setProductCategoryName(productAnalysisTreeVo.getProductCategoryName());
            od.setChildrenIdList(productAnalysisTreeVo.getProductNodeIdList());
            if ("2".equals(productAnalysisTreeVo.getTreeType())) {
                List<IntelligentProductVo> identifyOpportunityList = productIdMap.get(productAnalysisTreeVo.getProductId());
                od.setIsNext("0");
                for (IntelligentProductVo productVo : identifyOpportunityList) {
                    OpportunityDistributionVo odChild = new OpportunityDistributionVo();
                    OppoDistributeServiceImpl.productStageSwitch(productVo, opportunityStageMap, odChild);
                    od.add(odChild);
                    if (opptyStageIdsWin.contains(productVo.getStageId())) {
                        if (winStageModel1Flag) {
                            predictedAmount1 = predictedAmount1 + productVo.getAmount();
                        }
                        if (!winStageModel2Flag) continue;
                        predictedAmount2 = predictedAmount2 + productVo.getAmount();
                        continue;
                    }
                    if (opptyStageIdsLoseAbandon.contains(productVo.getStageId())) continue;
                    if (groupByProductFlag) {
                        if (configModel1 && model1SuccessRateMap.get(String.valueOf(productVo.getStageId()) + productVo.getProductId()) != null) {
                            predictedAmount1 = predictedAmount1 + productVo.getAmount() * (Double)model1SuccessRateMap.get(String.valueOf(productVo.getStageId()) + productVo.getProductId());
                        }
                    } else if (configModel1 && model1SuccessRateMap.get(String.valueOf(productVo.getStageId())) != null) {
                        predictedAmount1 = predictedAmount1 + productVo.getAmount() * (Double)model1SuccessRateMap.get(String.valueOf(productVo.getStageId()));
                    }
                    if (!configModel2 || model2SuccessRateMap.get(productVo.getOpportunityWinRate()) == null) continue;
                    predictedAmount2 = predictedAmount2 + productVo.getAmount() * (Double)model2SuccessRateMap.get(productVo.getOpportunityWinRate());
                }
            } else {
                od.setIsNext("1");
                for (Long id : productAnalysisTreeVo.getProductNodeIdList()) {
                    List<IntelligentProductVo> identifyOpportunityList = productIdMap.get(id);
                    if (CollectionUtil.isEmpty(identifyOpportunityList)) continue;
                    for (IntelligentProductVo productVo : identifyOpportunityList) {
                        OpportunityDistributionVo odChild = new OpportunityDistributionVo();
                        OppoDistributeServiceImpl.productStageSwitch(productVo, opportunityStageMap, odChild);
                        od.add(odChild);
                        if (opptyStageIdsWin.contains(productVo.getStageId())) {
                            if (winStageModel1Flag) {
                                predictedAmount1 = predictedAmount1 + productVo.getAmount();
                            }
                            if (!winStageModel2Flag) continue;
                            predictedAmount2 = predictedAmount2 + productVo.getAmount();
                            continue;
                        }
                        if (opptyStageIdsLoseAbandon.contains(productVo.getStageId())) continue;
                        if (groupByProductFlag) {
                            if (configModel1 && model1SuccessRateMap.get(String.valueOf(productVo.getStageId()) + productVo.getProductId()) != null) {
                                predictedAmount1 = predictedAmount1 + productVo.getAmount() * (Double)model1SuccessRateMap.get(String.valueOf(productVo.getStageId()) + productVo.getProductId());
                            }
                        } else if (configModel1 && model1SuccessRateMap.get(String.valueOf(productVo.getStageId())) != null) {
                            predictedAmount1 = predictedAmount1 + productVo.getAmount() * (Double)model1SuccessRateMap.get(String.valueOf(productVo.getStageId()));
                        }
                        if (!configModel2 || model2SuccessRateMap.get(productVo.getOpportunityWinRate()) == null) continue;
                        predictedAmount2 = predictedAmount2 + productVo.getAmount() * (Double)model2SuccessRateMap.get(productVo.getOpportunityWinRate());
                    }
                }
            }
            od.setYc1Amount(predictedAmount1);
            od.setYc2Amount(predictedAmount2);
            od.setSumCount(od.calculateSumCount());
            od.setSumAmount(od.calculateSumAmount());
            resultList.add(od);
        }
        OpportunityDistributionVo total = new OpportunityDistributionVo();
        total.setProductName("\u5408\u8ba1");
        for (OpportunityDistributionVo odv : resultList) {
            total.add(odv);
        }
        resultList.add(total);
        return resultList;
    }

    private List<OpportunityDto> getOpportUnityDtoList(OpportunityDto opportunityDto) {
        ArrayList<OpportunityDto> queryDtoList = new ArrayList<OpportunityDto>();
        String view = opportunityDto.getOpportunityView();
        if (StringUtil.isNotEmpty((Object)view) && !"preview".equals(view)) {
            CrmScene crmScene;
            long opportunityView = Long.parseLong(view);
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(CrmScene::getSceneId, (Object)opportunityView);
            lambdaQueryWrapper.eq(CrmScene::getModule, (Object)"opportunity");
            List crmSceneList = this.crmSceneMapper.selectList((Wrapper)lambdaQueryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)crmSceneList) && "0".equals((crmScene = (CrmScene)crmSceneList.get(0)).getIsSystem())) {
                try {
                    String query = crmScene.getQuery();
                    if (StringUtil.isNotBlank((CharSequence)query)) {
                        String queryValue = JSONObject.parseObject((String)query).get((Object)"queryValue").toString();
                        OpportunityDto queryDto = (OpportunityDto)JSONObject.parseObject((String)queryValue, OpportunityDto.class);
                        queryDto.setOpportunityView(String.valueOf(opportunityView));
                        queryDtoList.add(this.opportunityQueryCondition(queryDto));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        queryDtoList.add(this.opportunityQueryCondition(opportunityDto));
        return queryDtoList;
    }

    private OpportunityDto opportunityQueryCondition(OpportunityDto dto) {
        String opportunityView;
        SecurityUser user;
        if (StringUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("1");
        }
        if (ToolUtil.isNotEmpty((Object)dto.getOpportunityScreening())) {
            dto.setOpportunityScreening(dto.getOpportunityScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if ((user = BaseSecurityUtil.getUser()) == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (Object userId : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        ArrayList<String> createPersonIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getCreatePersonIds()) && dto.getCreatePersonIds().size() > 0) {
            for (Object createPersonId : dto.getCreatePersonIds()) {
                createPersonIds.add(CommonUtills.translateUserId((String)createPersonId));
            }
            dto.setTransCreatePersonIds(createPersonIds);
        }
        ArrayList<String> teamMemberIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getTeamMemberIds()) && dto.getTeamMemberIds().size() > 0) {
            for (String teamMemberId : dto.getTeamMemberIds()) {
                teamMemberIds.add(CommonUtills.translateUserId((String)teamMemberId));
            }
            dto.setTransTeamMemberIds(teamMemberIds);
        }
        List departments = dto.getOwnDepartments();
        ArrayList odpIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList Ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        List createDepartments = dto.getCreateDepartments();
        ArrayList cdpIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)createDepartments) && createDepartments.size() > 0) {
            for (String cdpId : createDepartments) {
                ArrayList Ids;
                String cdpIsTemp = CommonUtills.translateDepId((String)cdpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)cdpIsTemp, Ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    cdpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransCreateDepartmentIds(cdpIds);
        }
        if ("2".equals(opportunityView = dto.getOpportunityView()) || "2".equals(dto.getCompetence())) {
            dto.setOpportunityView("myself");
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"3".equals(dto.getEndTime()) && !"6".equals(dto.getEndTime())) {
            DateConvertVo dateConvertVo = IndexUtil.getCurrentTime((String)dto.getEndTime());
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        dto.setDelFlag("0");
        this.createTimeFlag(dto);
        dto.setCurrentUserId(user.getUserId());
        return dto;
    }

    private void createTimeFlag(OpportunityDto dto) {
        DateConvertVo dateConvertVo;
        if (StringUtil.isNotBlank((CharSequence)dto.getCreateTimeFlag()) && !"3".equals(dto.getCreateTimeFlag()) && !"6".equals(dto.getCreateTimeFlag()) && (dateConvertVo = IndexUtil.getCurrentTime((String)dto.getCreateTimeFlag())) != null) {
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
    }

    @Override
    public List<FollowUpAnalysisVo> followUpAnalysis(SalesStatisticsDto dto) {
        if (ToolUtil.isNotEmpty((Object)dto) && ToolUtil.isNotEmpty((Object)dto.getAccountName())) {
            List users = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)dto.getAccountName()));
            if (ToolUtil.isNotEmpty((Object)users) && !users.isEmpty()) {
                dto.setCurrentUserId(((SysUsers)users.get(0)).getId());
            }
        } else {
            SecurityUser user = BaseSecurityUtil.getUser();
            dto.setCurrentUserId(user.getId());
        }
        OpportunityDto oppDto1 = this.initOppoParam();
        List struList = DataPermission.getStruCache();
        if (HussarUtils.isNotEmpty((Object)dto.getTransOwnDepartmentIds())) {
            List deptIds = dto.getTransOwnDepartmentIds();
            List deptIdsAll = DataPermission.getAllDeptIdByParentId((List)struList, (Long)((Long)deptIds.get(0)));
            deptIds.addAll(deptIdsAll.stream().map(Long::valueOf).collect(Collectors.toList()));
            dto.setTransOwnDepartmentIds(deptIds);
        }
        oppDto1.setOverdueFollow("0");
        OpportunityDto opportunityDto1 = this.selectCrmOpportunityListCount(oppDto1, dto);
        SalesStatisticsDto permissionDto = this.opportunityOperate(opportunityDto1);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        if (HussarUtils.isNotEmpty((Object)dto.getStartTime())) {
            opportunityDto1.setStartTime(LocalDate.parse(dto.getStartTime(), formatter));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getFinalTime())) {
            opportunityDto1.setFinalTime(LocalDate.parse(dto.getFinalTime(), formatter));
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageAbandonConvert(true);
        stageTypeDto.setStageWinLose(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        opportunityDto1.setStates(Collections.singletonList("1"));
        List<FollowUpAnalysisDeptVo> day0 = this.opportunityAndAnalysisMapper.selectCrmOpportunityLists(opportunityDto1, permissionDto, stageSelectDto);
        OpportunityDto oppDto2 = this.initOppoParam();
        oppDto2.setOverdueFollow("1");
        OpportunityDto opportunityDto2 = this.selectCrmOpportunityListCount(oppDto2, dto);
        SalesStatisticsDto permissionDto2 = this.opportunityOperate(opportunityDto2);
        if (HussarUtils.isNotEmpty((Object)dto.getStartTime())) {
            opportunityDto2.setStartTime(LocalDate.parse(dto.getStartTime(), formatter));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getFinalTime())) {
            opportunityDto2.setFinalTime(LocalDate.parse(dto.getFinalTime(), formatter));
        }
        List<FollowUpAnalysisDeptVo> day07 = this.opportunityAndAnalysisMapper.selectCrmOpportunityLists(opportunityDto2, permissionDto2, stageSelectDto);
        OpportunityDto oppDto3 = this.initOppoParam();
        oppDto3.setOverdueFollow("2");
        OpportunityDto opportunityDto3 = this.selectCrmOpportunityListCount(oppDto3, dto);
        SalesStatisticsDto permissionDto3 = this.opportunityOperate(opportunityDto3);
        if (HussarUtils.isNotEmpty((Object)dto.getStartTime())) {
            opportunityDto3.setStartTime(LocalDate.parse(dto.getStartTime(), formatter));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getFinalTime())) {
            opportunityDto3.setFinalTime(LocalDate.parse(dto.getFinalTime(), formatter));
        }
        List<FollowUpAnalysisDeptVo> day15 = this.opportunityAndAnalysisMapper.selectCrmOpportunityLists(opportunityDto3, permissionDto3, stageSelectDto);
        OpportunityDto oppDto4 = this.initOppoParam();
        oppDto4.setOverdueFollow("3");
        OpportunityDto opportunityDto4 = this.selectCrmOpportunityListCount(oppDto4, dto);
        SalesStatisticsDto permissionDto4 = this.opportunityOperate(opportunityDto4);
        if (HussarUtils.isNotEmpty((Object)dto.getStartTime())) {
            opportunityDto4.setStartTime(LocalDate.parse(dto.getStartTime(), formatter));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getFinalTime())) {
            opportunityDto4.setFinalTime(LocalDate.parse(dto.getFinalTime(), formatter));
        }
        List<FollowUpAnalysisDeptVo> day30 = this.opportunityAndAnalysisMapper.selectCrmOpportunityLists(opportunityDto4, permissionDto4, stageSelectDto);
        int struLevel = 2;
        OpportunityDto opportunityDto = new OpportunityDto();
        opportunityDto.setDelFlag("0");
        if (ToolUtil.isNotEmpty((Object)dto.getDeptIds())) {
            List deptIds = dto.getDeptIds().stream().map(String::valueOf).collect(Collectors.toList());
            List deptIdsAll = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf((String)deptIds.get(0)));
            deptIds.addAll(deptIdsAll);
            opportunityDto.setDeptIds(deptIds);
            SysStru sysStru = (SysStru)this.sysStruService.getById((Serializable)dto.getDeptIds().get(0));
            struLevel = sysStru.getStruLevel() + 1;
        }
        List<DepartmentVo> deptList = this.oppoDistributeMapper.selectDepartListByOppo(opportunityDto, dto, struLevel);
        List<Object> followUpAnalysisVos = new ArrayList();
        String day0Name = "day0";
        String day07Name = "day07";
        String day15Name = "day15";
        String day30Name = "day30";
        String totalName = "\u5408\u8ba1";
        for (DepartmentVo departmentVo : deptList) {
            List<Long> structureIds;
            Long structureId = Long.parseLong(departmentVo.getStruId());
            if ("N".equals(departmentVo.getIsLeaf())) {
                List list = this.sysStruService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysStru::getParentId, (Object)structureId)).eq(HussarDelflagEntity::getDelFlag, (Object)"0"));
                structureIds = list.stream().map(SysStru::getId).collect(Collectors.toList());
                structureIds.add(structureId);
            } else {
                structureIds = Collections.singletonList(structureId);
            }
            int day0Size = (int)day0.stream().filter(f -> structureIds.contains(f.getOwnDepartment())).count();
            int day07Size = (int)day07.stream().filter(f -> structureIds.contains(f.getOwnDepartment())).count();
            int day15Size = (int)day15.stream().filter(f -> structureIds.contains(f.getOwnDepartment())).count();
            int day30Size = (int)day30.stream().filter(f -> structureIds.contains(f.getOwnDepartment())).count();
            ArrayList<FollowUpAnalysisCellVo> arrayList = new ArrayList<FollowUpAnalysisCellVo>();
            for (int i = 0; i < 4; ++i) {
                int numbers;
                String classificationName;
                FollowUpAnalysisCellVo followUpAnalysisCellVo = new FollowUpAnalysisCellVo();
                switch (i) {
                    case 0: {
                        classificationName = day0Name;
                        numbers = day0Size;
                        break;
                    }
                    case 1: {
                        classificationName = day07Name;
                        numbers = day07Size;
                        break;
                    }
                    case 2: {
                        classificationName = day15Name;
                        numbers = day15Size;
                        break;
                    }
                    case 3: {
                        classificationName = day30Name;
                        numbers = day30Size;
                        break;
                    }
                    default: {
                        classificationName = "";
                        numbers = 0;
                    }
                }
                followUpAnalysisCellVo.setClassificationName(classificationName);
                followUpAnalysisCellVo.setNumbers(numbers);
                arrayList.add(followUpAnalysisCellVo);
            }
            FollowUpAnalysisVo followUpAnalysisVo = new FollowUpAnalysisVo();
            followUpAnalysisVo.setDeptId(structureId + "");
            followUpAnalysisVo.setDeptName(departmentVo.getOrganAlias());
            followUpAnalysisVo.setShortName(departmentVo.getShortName());
            followUpAnalysisVo.setNextLevel(departmentVo.getIsLeaf());
            followUpAnalysisVo.setFollowUpAnalysisCellVos(arrayList);
            followUpAnalysisVos.add(followUpAnalysisVo);
        }
        if (!(followUpAnalysisVos = followUpAnalysisVos.stream().filter(f -> 0 != f.getFollowUpAnalysisCellVos().stream().mapToInt(FollowUpAnalysisCellVo::getNumbers).sum()).collect(Collectors.toList())).isEmpty()) {
            List followUpAnalysisCells = followUpAnalysisVos.stream().flatMap(vo -> vo.getFollowUpAnalysisCellVos().stream()).collect(Collectors.toList());
            HashMap<String, Integer> totalMap = new HashMap<String, Integer>();
            for (Object cell : followUpAnalysisCells) {
                totalMap.put(((FollowUpAnalysisCellVo)cell).getClassificationName(), totalMap.getOrDefault(((FollowUpAnalysisCellVo)cell).getClassificationName(), 0) + ((FollowUpAnalysisCellVo)cell).getNumbers());
            }
            ArrayList<FollowUpAnalysisCellVo> followUpAnalysisCellVos = new ArrayList<FollowUpAnalysisCellVo>();
            for (Map.Entry entry : totalMap.entrySet()) {
                FollowUpAnalysisCellVo totalCell = new FollowUpAnalysisCellVo();
                totalCell.setClassificationName((String)entry.getKey());
                totalCell.setNumbers((Integer)entry.getValue());
                followUpAnalysisCellVos.add(totalCell);
            }
            FollowUpAnalysisVo followUpAnalysisVo = new FollowUpAnalysisVo();
            followUpAnalysisVo.setDeptId(totalName);
            followUpAnalysisVo.setDeptName(totalName);
            followUpAnalysisVo.setNextLevel("Y");
            followUpAnalysisVo.setShortName(totalName);
            followUpAnalysisVo.setFollowUpAnalysisCellVos(followUpAnalysisCellVos.stream().sorted(Comparator.comparing(FollowUpAnalysisCellVo::getClassificationName)).collect(Collectors.toList()));
            followUpAnalysisVos.add(followUpAnalysisVo);
        }
        if (!followUpAnalysisVos.isEmpty() && HussarUtils.isNotEmpty((Object)dto.getOrderString())) {
            return this.followUpAnalysisSort(dto.getOrderString(), followUpAnalysisVos);
        }
        return followUpAnalysisVos;
    }

    @Override
    public List<FollowUpAnalysisVo> followUpByPersonAnalysis(SalesStatisticsDto dto) {
        if (ToolUtil.isNotEmpty((Object)dto) && ToolUtil.isNotEmpty((Object)dto.getAccountName())) {
            List users = this.sysUsersService.list((Wrapper)new LambdaQueryWrapper().eq(SysUsers::getUserAccount, (Object)dto.getAccountName()));
            if (ToolUtil.isNotEmpty((Object)users) && !users.isEmpty()) {
                dto.setCurrentUserId(((SysUsers)users.get(0)).getId());
            }
        } else {
            SecurityUser user = BaseSecurityUtil.getUser();
            dto.setCurrentUserId(user.getId());
        }
        OpportunityDto oppDto1 = this.initOppoParam();
        if (HussarUtils.isNotEmpty((Object)dto.getTransOwnDepartmentIds())) {
            List deptIds = dto.getTransOwnDepartmentIds();
            List struList = DataPermission.getStruCache();
            List deptIdsAll = DataPermission.getAllDeptIdByParentId((List)struList, (Long)((Long)deptIds.get(0)));
            deptIds.addAll(deptIdsAll.stream().map(Long::valueOf).collect(Collectors.toList()));
            dto.setTransOwnDepartmentIds(deptIds);
        }
        oppDto1.setOverdueFollow("0");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        OpportunityDto opportunityDto1 = this.selectCrmOpportunityListCount(oppDto1, dto);
        opportunityDto1.setStates(Collections.singletonList("1"));
        SalesStatisticsDto permissionDto = this.opportunityOperate(opportunityDto1);
        if (HussarUtils.isNotEmpty((Object)dto.getStartTime())) {
            opportunityDto1.setStartTime(LocalDate.parse(dto.getStartTime(), formatter));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getFinalTime())) {
            opportunityDto1.setFinalTime(LocalDate.parse(dto.getFinalTime(), formatter));
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageAbandonConvert(true);
        stageTypeDto.setStageWinLose(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List<String> day0 = this.opportunityAndAnalysisMapper.selectCrmOpportunityListsByPerson(opportunityDto1, permissionDto, stageSelectDto);
        OpportunityDto oppDto2 = this.initOppoParam();
        oppDto2.setOverdueFollow("1");
        OpportunityDto opportunityDto2 = this.selectCrmOpportunityListCount(oppDto2, dto);
        SalesStatisticsDto permissionDto1 = this.opportunityOperate(opportunityDto2);
        if (HussarUtils.isNotEmpty((Object)dto.getStartTime())) {
            opportunityDto2.setStartTime(LocalDate.parse(dto.getStartTime(), formatter));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getFinalTime())) {
            opportunityDto2.setFinalTime(LocalDate.parse(dto.getFinalTime(), formatter));
        }
        List<String> day07 = this.opportunityAndAnalysisMapper.selectCrmOpportunityListsByPerson(opportunityDto2, permissionDto1, stageSelectDto);
        OpportunityDto oppDto3 = this.initOppoParam();
        oppDto3.setOverdueFollow("2");
        OpportunityDto opportunityDto3 = this.selectCrmOpportunityListCount(oppDto3, dto);
        SalesStatisticsDto permissionDto2 = this.opportunityOperate(opportunityDto3);
        if (HussarUtils.isNotEmpty((Object)dto.getStartTime())) {
            opportunityDto3.setStartTime(LocalDate.parse(dto.getStartTime(), formatter));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getFinalTime())) {
            opportunityDto3.setFinalTime(LocalDate.parse(dto.getFinalTime(), formatter));
        }
        List<String> day15 = this.opportunityAndAnalysisMapper.selectCrmOpportunityListsByPerson(opportunityDto3, permissionDto2, stageSelectDto);
        OpportunityDto oppDto4 = this.initOppoParam();
        oppDto4.setOverdueFollow("3");
        OpportunityDto opportunityDto4 = this.selectCrmOpportunityListCount(oppDto4, dto);
        SalesStatisticsDto permissionDto3 = this.opportunityOperate(opportunityDto4);
        if (HussarUtils.isNotEmpty((Object)dto.getStartTime())) {
            opportunityDto4.setStartTime(LocalDate.parse(dto.getStartTime(), formatter));
        }
        if (HussarUtils.isNotEmpty((Object)dto.getFinalTime())) {
            opportunityDto4.setFinalTime(LocalDate.parse(dto.getFinalTime(), formatter));
        }
        List<String> day30 = this.opportunityAndAnalysisMapper.selectCrmOpportunityListsByPerson(opportunityDto4, permissionDto3, stageSelectDto);
        ArrayList<String> totalFollowUpAnalysis = new ArrayList<String>();
        totalFollowUpAnalysis.addAll(day0);
        totalFollowUpAnalysis.addAll(day07);
        totalFollowUpAnalysis.addAll(day15);
        totalFollowUpAnalysis.addAll(day30);
        if (totalFollowUpAnalysis.isEmpty()) {
            return new ArrayList<FollowUpAnalysisVo>();
        }
        List oppPerson = this.opportunityMapper.selectCrmOppPersons(totalFollowUpAnalysis);
        String day0Name = "day0";
        String day07Name = "day07";
        String day15Name = "day15";
        String day30Name = "day30";
        String totalName = "\u5408\u8ba1";
        List<FollowUpAnalysisVo> followUpAnalysisVoList = new ArrayList<FollowUpAnalysisVo>();
        if (HussarUtils.isNotEmpty((Object)oppPerson)) {
            for (ChargePersonVo person : oppPerson) {
                String userId = person.getUserId();
                int day0Size = (int)day0.stream().filter(f -> f.equals(userId)).count();
                int day07Size = (int)day07.stream().filter(f -> f.equals(userId)).count();
                int day15Size = (int)day15.stream().filter(f -> f.equals(userId)).count();
                int day30Size = (int)day30.stream().filter(f -> f.equals(userId)).count();
                FollowUpAnalysisCellVo followUpAnalysisCellVo0 = this.createFollowUpAnalysisCellVo(day0Name, day0Size);
                FollowUpAnalysisCellVo followUpAnalysisCellVo = this.createFollowUpAnalysisCellVo(day07Name, day07Size);
                FollowUpAnalysisCellVo followUpAnalysisCellVo15 = this.createFollowUpAnalysisCellVo(day15Name, day15Size);
                FollowUpAnalysisCellVo followUpAnalysisCellVo30 = this.createFollowUpAnalysisCellVo(day30Name, day30Size);
                FollowUpAnalysisVo followUpAnalysisVo = new FollowUpAnalysisVo();
                followUpAnalysisVo.setUserId(person.getUserId());
                followUpAnalysisVo.setUserName(person.getUserName());
                followUpAnalysisVo.setDeptId(person.getStruId());
                followUpAnalysisVo.setDeptName(person.getOrganAlias());
                followUpAnalysisVo.setShortName(person.getShortName());
                followUpAnalysisVo.setNextLevel("Y");
                List<FollowUpAnalysisCellVo> followUpAnalysisCellVos = Arrays.asList(followUpAnalysisCellVo0, followUpAnalysisCellVo, followUpAnalysisCellVo15, followUpAnalysisCellVo30);
                followUpAnalysisVo.setFollowUpAnalysisCellVos(followUpAnalysisCellVos.stream().sorted(Comparator.comparing(FollowUpAnalysisCellVo::getClassificationName)).collect(Collectors.toList()));
                followUpAnalysisVoList.add(followUpAnalysisVo);
            }
        }
        List followUpAnalysisCells = followUpAnalysisVoList.stream().flatMap(vo -> vo.getFollowUpAnalysisCellVos().stream()).collect(Collectors.toList());
        HashMap<String, Integer> totalMap = new HashMap<String, Integer>();
        for (Object cell : followUpAnalysisCells) {
            totalMap.put(((FollowUpAnalysisCellVo)cell).getClassificationName(), totalMap.getOrDefault(((FollowUpAnalysisCellVo)cell).getClassificationName(), 0) + ((FollowUpAnalysisCellVo)cell).getNumbers());
        }
        ArrayList<FollowUpAnalysisCellVo> followUpAnalysisCellVos = new ArrayList<FollowUpAnalysisCellVo>();
        for (Map.Entry entry : totalMap.entrySet()) {
            FollowUpAnalysisCellVo totalCell = new FollowUpAnalysisCellVo();
            totalCell.setClassificationName((String)entry.getKey());
            totalCell.setNumbers((Integer)entry.getValue());
            followUpAnalysisCellVos.add(totalCell);
        }
        if (HussarUtils.isEmpty((Object)dto.getOrderString())) {
            List<SalespersonVo> salespersonVoList;
            List collect = followUpAnalysisVoList.stream().map(FollowUpAnalysisVo::getUserId).collect(Collectors.toList());
            List<Long> list = collect.stream().filter(f -> null != f && !f.isEmpty()).map(Long::parseLong).collect(Collectors.toList());
            Map<String, FollowUpAnalysisVo> followUpAnalysisVoMap = followUpAnalysisVoList.stream().collect(Collectors.toMap(FollowUpAnalysisVo::getUserId, s -> s));
            if (CollectionUtil.isNotEmpty(list) && CollectionUtil.isNotEmpty(salespersonVoList = this.salespersonAnalysisMapper.selectUserList(list))) {
                for (SalespersonVo tempBehaviorVo : salespersonVoList) {
                    Long userId = tempBehaviorVo.getUserId();
                    FollowUpAnalysisVo followUpAnalysis = followUpAnalysisVoMap.get(userId + "");
                    if (followUpAnalysis == null) continue;
                    followUpAnalysis.setStaffPosition(tempBehaviorVo.getStaffPosition() == null ? "461" : tempBehaviorVo.getStaffPosition());
                    followUpAnalysis.setUserOrder(tempBehaviorVo.getUserOrder() == null ? 100000 : tempBehaviorVo.getUserOrder());
                    followUpAnalysis.setStruOrder(tempBehaviorVo.getStruOrder() == null ? 100000 : tempBehaviorVo.getStruOrder());
                }
            }
            followUpAnalysisVoList = followUpAnalysisVoList.stream().sorted(Comparator.comparing(FollowUpAnalysisVo::getStruOrder).thenComparing(FollowUpAnalysisVo::getDeptId).thenComparing(FollowUpAnalysisVo::getStaffPosition).thenComparingInt(FollowUpAnalysisVo::getUserOrder)).collect(Collectors.toList());
        }
        FollowUpAnalysisVo followUpAnalysisVo = new FollowUpAnalysisVo();
        followUpAnalysisVo.setDeptId(totalName);
        followUpAnalysisVo.setDeptName(totalName);
        followUpAnalysisVo.setUserName(totalName);
        followUpAnalysisVo.setNextLevel("Y");
        followUpAnalysisVo.setShortName(totalName);
        followUpAnalysisVo.setFollowUpAnalysisCellVos(followUpAnalysisCellVos.stream().sorted(Comparator.comparing(FollowUpAnalysisCellVo::getClassificationName)).collect(Collectors.toList()));
        followUpAnalysisVoList.add(followUpAnalysisVo);
        if (HussarUtils.isNotEmpty((Object)dto.getOrderString())) {
            return this.followUpAnalysisSort(dto.getOrderString(), followUpAnalysisVoList);
        }
        return followUpAnalysisVoList;
    }

    private FollowUpAnalysisCellVo createFollowUpAnalysisCellVo(String classificationName, int numbers) {
        FollowUpAnalysisCellVo followUpAnalysisCellVo = new FollowUpAnalysisCellVo();
        followUpAnalysisCellVo.setClassificationName(classificationName);
        followUpAnalysisCellVo.setNumbers(numbers);
        return followUpAnalysisCellVo;
    }

    private OpportunityDto initOppoParam() {
        OpportunityDto oppDto = new OpportunityDto();
        oppDto.setOpportunityView("1");
        oppDto.setWinMoney(0.0);
        oppDto.setIsMobile("1");
        oppDto.setSelectType("2");
        oppDto.setAbandonOpportunity("1");
        return oppDto;
    }

    private OpportunityDto selectCrmOpportunityListCount(OpportunityDto opportunity, SalesStatisticsDto salesStatisticsDto) {
        if (ToolUtil.isNotEmpty((Object)salesStatisticsDto)) {
            BeanUtils.copyProperties((Object)salesStatisticsDto, (Object)opportunity);
            if (ToolUtil.isNotEmpty((Object)salesStatisticsDto.getPermissionDeptIds())) {
                opportunity.setTransOwnDepartmentIds(salesStatisticsDto.getPermissionDeptIds().stream().map(String::valueOf).collect(Collectors.toList()));
            }
            if (ToolUtil.isNotEmpty((Object)salesStatisticsDto.getUserIds())) {
                opportunity.setTransChargePersonIds(salesStatisticsDto.getUserIds().stream().map(String::valueOf).collect(Collectors.toList()));
            }
        }
        OpportunityDto opportunityDto = this.opportunityQueryCondition(opportunity);
        if ("\u79bb\u804c".equals(opportunity.getOpportunityScreening())) {
            opportunity.setOpportunityScreening("");
            SysStru dimissionStru = this.commonMapper.getSysStruByOrganAlias("\u79bb\u804c");
            opportunity.setDimissionId(dimissionStru.getId());
        }
        return opportunityDto;
    }

    private List<FollowUpAnalysisVo> followUpAnalysisSort(String orderString, List<FollowUpAnalysisVo> followUpAnalysisVos) {
        String classificationName;
        String[] orders = orderString.split(",");
        if (orders.length != 2) {
            return followUpAnalysisVos;
        }
        String className = orders[0];
        String orderType = orders[1];
        switch (className) {
            case "0": {
                classificationName = "day0";
                break;
            }
            case "1": {
                classificationName = "day07";
                break;
            }
            case "2": {
                classificationName = "day15";
                break;
            }
            case "3": {
                classificationName = "day30";
                break;
            }
            default: {
                classificationName = "";
            }
        }
        FollowUpAnalysisVo total = followUpAnalysisVos.get(followUpAnalysisVos.size() - 1);
        followUpAnalysisVos.remove(followUpAnalysisVos.size() - 1);
        for (int i = 0; i < followUpAnalysisVos.size() - 1; ++i) {
            for (int j = 0; j < followUpAnalysisVos.size() - 1 - i; ++j) {
                FollowUpAnalysisVo followUpAnalysisVo = followUpAnalysisVos.get(j);
                int numbers1 = 0;
                FollowUpAnalysisVo follow = followUpAnalysisVos.get(j + 1);
                int numbers2 = 0;
                for (FollowUpAnalysisCellVo followUpAnalysisCellVo : followUpAnalysisVo.getFollowUpAnalysisCellVos()) {
                    if (!followUpAnalysisCellVo.getClassificationName().equals(classificationName)) continue;
                    numbers1 = followUpAnalysisCellVo.getNumbers();
                    break;
                }
                for (FollowUpAnalysisCellVo followUpAnalysisCellVo : follow.getFollowUpAnalysisCellVos()) {
                    if (!followUpAnalysisCellVo.getClassificationName().equals(classificationName)) continue;
                    numbers2 = followUpAnalysisCellVo.getNumbers();
                    break;
                }
                if ("0".equals(orderType)) {
                    if (numbers1 <= numbers2) continue;
                    Collections.swap(followUpAnalysisVos, j, j + 1);
                    continue;
                }
                if (numbers1 > numbers2) continue;
                Collections.swap(followUpAnalysisVos, j, j + 1);
            }
        }
        followUpAnalysisVos.add(total);
        return followUpAnalysisVos;
    }

    @Override
    public void followUpAnalysisExport(HttpServletResponse response, SalesStatisticsDto dto, String type) {
        List<FollowUpAnalysisVo> followUpAnalysisVoList;
        String dept = "dept";
        String person = "person";
        if (dept.equals(type)) {
            followUpAnalysisVoList = this.followUpAnalysis(dto);
        } else if (person.equals(type)) {
            followUpAnalysisVoList = this.followUpByPersonAnalysis(dto);
        } else {
            return;
        }
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            String lastFileName = "\u5546\u673a\u8ddf\u8fdb\u5206\u6790-" + (dept.equals(type) ? "\u90e8\u95e8" : "\u4eba\u5458") + ".xlsx";
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/msexcel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(lastFileName, "UTF-8"));
            String sheetName = "Sheet1";
            SXSSFSheet sheet = workbook.createSheet(sheetName);
            CellStyle style = ExcelStyle.getStyle((Workbook)workbook);
            Row dataRowTitle = sheet.createRow(0);
            Cell titleCellFirst = dataRowTitle.createCell(0);
            titleCellFirst.setCellType(CellType.STRING);
            titleCellFirst.setCellStyle(style);
            titleCellFirst.setCellValue(dept.equals(type) ? "\u90e8\u95e8\u540d\u79f0" : "\u4eba\u5458\u540d\u79f0");
            List<String> list = Arrays.asList("\u5f85\u8ddf\u8fdb", "[7,15)\u5929\u672a\u8ddf\u8fdb", "[15,30)\u5929\u672a\u8ddf\u8fdb", "30\u5929\u53ca\u4ee5\u4e0a\u672a\u8ddf\u8fdb");
            List<String> classList = Arrays.asList("day0", "day07", "day15", "day30");
            for (int i = 0; i < list.size(); ++i) {
                Cell titleCell = dataRowTitle.createCell(i + 1);
                titleCell.setCellType(CellType.STRING);
                titleCell.setCellStyle(style);
                titleCell.setCellValue(list.get(i));
            }
            if (followUpAnalysisVoList != null && !followUpAnalysisVoList.isEmpty()) {
                for (int index = 0; index < followUpAnalysisVoList.size(); ++index) {
                    SXSSFRow dataRow = workbook.getSheet(sheetName).createRow(index + 1);
                    List<FollowUpAnalysisCellVo> cellList = followUpAnalysisVoList.get(index).getFollowUpAnalysisCellVos();
                    Cell cellDepart = dataRow.createCell(0);
                    cellDepart.setCellType(CellType.STRING);
                    cellDepart.setCellStyle(style);
                    String shortName = followUpAnalysisVoList.get(index).getShortName();
                    if (dept.equals(type)) {
                        cellDepart.setCellValue(shortName);
                    } else if (ToolUtil.isNotEmpty((Object)shortName)) {
                        cellDepart.setCellValue(followUpAnalysisVoList.get(index).getUserName() + "(" + followUpAnalysisVoList.get(index).getShortName() + ")");
                    } else {
                        cellDepart.setCellValue(followUpAnalysisVoList.get(index).getUserName());
                    }
                    for (int j = 0; j < classList.size(); ++j) {
                        String abnormalType = classList.get(j);
                        for (FollowUpAnalysisCellVo cellVo : cellList) {
                            if (!abnormalType.equals(cellVo.getClassificationName())) continue;
                            Cell cellCount = dataRow.createCell(j + 1);
                            cellCount.setCellType(CellType.NUMERIC);
                            cellCount.setCellStyle(style);
                            cellCount.setCellValue((double)cellVo.getNumbers().intValue());
                        }
                    }
                }
            }
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<AbnormalRowVo> abnormalAnalysisDept(OpportunityDto dto) {
        Object sysStru2;
        dto.setDelFlag("0");
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        Long userId = user.getId();
        List userRoles = user.getRolesList();
        List struList = DataPermission.getStruCache();
        dto.setOpportunityView("1");
        int struLevel = 2;
        if (dto.getDeptIds() != null && dto.getDeptIds().size() > 0) {
            List deptIds = dto.getDeptIds();
            List deptIdsAll = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf((String)deptIds.get(0)));
            deptIds.addAll(deptIdsAll);
            dto.setDeptIds(deptIds);
            sysStru2 = (SysStru)this.sysStruService.getById((Serializable)dto.getDeptIds().get(0));
            struLevel = sysStru2.getStruLevel() + 1;
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity())) || userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getCompanyLeader())) || userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getProductManager()))) {
            dto.setDeptIds(null);
            dto.setChargePersonId(null);
        } else if (DataPermission.isLeadship((List)userRoles, (List)DataPermission.getLeadershipRoles())) {
            dto.setDeptIds(null);
            dto.setChargePersonId(null);
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getBgLeader()))) {
            Long parentId = DataPermission.getParentIdByDeptId((List)struList, (Long)user.getDeptId());
            List deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)parentId);
            dto.setDeptIds(deptIds);
            if (deptIds != null && deptIds.size() > 0) {
                sysStru2 = (SysStru)this.sysStruService.getById((Serializable)dto.getDeptIds().get(0));
                struLevel = sysStru2.getStruLevel() + 1;
            }
        } else if (userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesGM())) || userRoles.contains(Long.valueOf(this.crmProperties.getRoles().getSalesDirector()))) {
            dto.setDeptIds(Collections.singletonList(user.getDeptId().toString()));
            SysStru sysStru3 = (SysStru)this.sysStruService.getById((Serializable)dto.getDeptIds().get(0));
            struLevel = sysStru3.getStruLevel();
        } else {
            dto.setDeptIds(null);
            dto.setChargePersonId(userId.toString());
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"3".equals(dto.getEndTime()) && !"6".equals(dto.getEndTime())) {
            DateConvertVo dateConvertVo = IndexUtil.getCurrentTime((String)dto.getEndTime());
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        this.createTimeFlag(dto);
        if (ToolUtil.isNotEmpty((Object)dto.getTransOwnDepartmentIds()) && dto.getTransOwnDepartmentIds().size() > 0) {
            List ownDepts = dto.getTransOwnDepartmentIds();
            ArrayList ownDeptList = new ArrayList();
            ownDeptList.addAll(ownDepts);
            for (String struId : ownDepts) {
                List deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf(struId));
                ownDeptList.addAll(deptIds);
            }
            dto.setTransOwnDepartmentIds(ownDeptList);
        }
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        OpportunityDto opportunityDto = this.opportunityQueryCondition(dto);
        if ("\u79bb\u804c".equals(dto.getOpportunityScreening())) {
            dto.setOpportunityScreening("");
            SysStru dimissionStru = this.commonMapper.getSysStruByOrganAlias("\u79bb\u804c");
            dto.setDimissionId(dimissionStru.getId());
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageAbandonConvert(true);
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageEnd(true);
        stageTypeDto.setStageStart(true);
        stageTypeDto.setStageWinLose(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        opportunityDto.setOpportunityAbnormalOverdue("1");
        opportunityDto.setOpportunityAbnormalWin(null);
        opportunityDto.setOpportunityAbnormalInfo(null);
        List<AbnormalCellVo> overdueCells = this.oppoDistributeMapper.getDeptOppoAbnormalCellVos(opportunityDto, permissionDto, struLevel, stageSelectDto);
        List<DepartmentVo> overdueDept = this.oppoDistributeMapper.selectAbnormalDeptByOppo(opportunityDto, permissionDto, struLevel, stageSelectDto);
        opportunityDto.setOpportunityAbnormalOverdue(null);
        opportunityDto.setOpportunityAbnormalWin("1");
        opportunityDto.setOpportunityAbnormalInfo(null);
        List<AbnormalCellVo> winCells = this.oppoDistributeMapper.getDeptOppoAbnormalCellVos(opportunityDto, permissionDto, struLevel, stageSelectDto);
        List<DepartmentVo> winDept = this.oppoDistributeMapper.selectAbnormalDeptByOppo(opportunityDto, permissionDto, struLevel, stageSelectDto);
        opportunityDto.setOpportunityAbnormalOverdue(null);
        opportunityDto.setOpportunityAbnormalWin(null);
        opportunityDto.setOpportunityAbnormalInfo("1");
        List<AbnormalCellVo> oppoInfoCells = this.oppoDistributeMapper.getDeptOppoAbnormalCellVos(opportunityDto, permissionDto, struLevel, stageSelectDto);
        List<DepartmentVo> oppoInfoDept = this.oppoDistributeMapper.selectAbnormalDeptByOppo(opportunityDto, permissionDto, struLevel, stageSelectDto);
        CustomerDto custAbnormalInfoDto = new CustomerDto();
        custAbnormalInfoDto.setCustomerView("1");
        custAbnormalInfoDto.setCustomerAbnormalInfo("1");
        custAbnormalInfoDto.setTransChargePersonIds(dto.getTransChargePersonIds());
        custAbnormalInfoDto.setTransOwnDepartmentIds(dto.getTransOwnDepartmentIds());
        custAbnormalInfoDto.setCreateTimeFlag(dto.getCreateTimeFlag());
        custAbnormalInfoDto.setStartTime(dto.getStartTime());
        custAbnormalInfoDto.setFinalTime(dto.getFinalTime());
        List<AbnormalCellVo> custInfoCells = this.getDeptCustAbnormalCellVos(custAbnormalInfoDto, struLevel, stageSelectDto);
        List<DepartmentVo> custInfoDept = this.selectAbnormalDeptByCust(custAbnormalInfoDto, struLevel, stageSelectDto);
        ArrayList<AbnormalCellVo> cellList = new ArrayList<AbnormalCellVo>();
        cellList.addAll(overdueCells);
        cellList.addAll(winCells);
        cellList.addAll(oppoInfoCells);
        cellList.addAll(custInfoCells);
        if (cellList == null || cellList.size() == 0) {
            return new ArrayList<AbnormalRowVo>();
        }
        ArrayList<DepartmentVo> deptList = new ArrayList<DepartmentVo>();
        deptList.addAll(overdueDept);
        deptList.addAll(winDept);
        deptList.addAll(oppoInfoDept);
        deptList.addAll(custInfoDept);
        TreeSet<DepartmentVo> deptSet = new TreeSet<DepartmentVo>((o1, o2) -> o1.getStruId().compareTo(o2.getStruId()));
        deptSet.addAll(deptList);
        List<Object> deptListAll = new ArrayList(deptSet);
        List struLists = deptListAll.stream().map(DepartmentVo::getStruId).distinct().collect(Collectors.toList());
        List sysStrus = this.sysStruService.listByIds(struLists);
        Map<Long, SysStru> struIdToSysStruMap = sysStrus.stream().collect(Collectors.toMap(SysStru::getId, sysStru -> sysStru, (existing, replacement) -> existing));
        deptListAll.forEach(departmentVo -> {
            Long struId = Long.parseLong(departmentVo.getStruId());
            SysStru sysStru = (SysStru)struIdToSysStruMap.get(struId);
            if (sysStru != null) {
                departmentVo.setStruOrder(sysStru.getStruOrder());
            }
        });
        deptListAll = deptListAll.stream().sorted(Comparator.comparing(DepartmentVo::getStruOrder)).collect(Collectors.toList());
        List<AbnormalRowVo> excelDeptRowVoList = new ArrayList<AbnormalRowVo>(16);
        AbnormalRowVo totalRow = new AbnormalRowVo();
        totalRow.setDeptId("\u5408\u8ba1");
        totalRow.setDeptName("\u5408\u8ba1");
        totalRow.setShortName("\u5408\u8ba1");
        totalRow.setNextLevel("Y");
        totalRow.setCellVoList(new ArrayList<AbnormalCellVo>());
        for (int i = 0; i < deptListAll.size(); ++i) {
            DepartmentVo dept = (DepartmentVo)deptListAll.get(i);
            AbnormalRowVo thisDeptRow = new AbnormalRowVo();
            thisDeptRow.setDeptId(dept.getStruId());
            thisDeptRow.setDeptName(dept.getOrganAlias());
            thisDeptRow.setShortName(dept.getShortName());
            thisDeptRow.setNextLevel(dept.getIsLeaf());
            ArrayList<AbnormalCellVo> rowCellList = new ArrayList<AbnormalCellVo>(16);
            for (int j = 0; j < ABNORMAL_TYPE.length; ++j) {
                String abnormal = ABNORMAL_TYPE[j];
                AbnormalCellVo totalRowCell = new AbnormalCellVo();
                totalRowCell.setDataType(abnormal);
                totalRowCell.setDataId("\u5408\u8ba1");
                totalRowCell.setCountnum(0L);
                if (i != 0) {
                    totalRowCell = totalRow.getCellVoList().get(j);
                }
                boolean stageExist = false;
                for (int k = 0; k < cellList.size(); ++k) {
                    AbnormalCellVo cell = (AbnormalCellVo)cellList.get(k);
                    if (!abnormal.equals(cell.getDataType()) || !dept.getStruId().equals(cell.getDataId())) continue;
                    AbnormalCellVo thisCell = new AbnormalCellVo();
                    thisCell.setDataId(cell.getDataId());
                    thisCell.setDataType(abnormal);
                    thisCell.setCountnum(cell.getCountnum());
                    totalRowCell.setCountnum(totalRowCell.getCountnum() + thisCell.getCountnum());
                    rowCellList.add(thisCell);
                    cellList.remove(k);
                    --k;
                    stageExist = true;
                }
                if (!stageExist) {
                    AbnormalCellVo thisCell = new AbnormalCellVo();
                    thisCell.setDataId(dept.getStruId());
                    thisCell.setDataType(abnormal);
                    thisCell.setCountnum(0L);
                    rowCellList.add(thisCell);
                }
                List<AbnormalCellVo> totalCellList = totalRow.getCellVoList();
                if (i == 0) {
                    if (j == 0) {
                        totalCellList = new ArrayList<AbnormalCellVo>(Arrays.asList(totalRowCell));
                    } else {
                        totalCellList.add(totalRowCell);
                    }
                } else {
                    totalCellList.set(j, totalRowCell);
                }
                totalRow.setCellVoList(totalCellList);
            }
            thisDeptRow.setCellVoList(rowCellList);
            excelDeptRowVoList.add(thisDeptRow);
        }
        excelDeptRowVoList.add(totalRow);
        if (ToolUtil.isNotEmpty((Object)dto.getOppoDistributeOrderString())) {
            excelDeptRowVoList = this.abnormalSort(dto.getOppoDistributeOrderString(), excelDeptRowVoList);
        }
        return excelDeptRowVoList;
    }

    @Override
    public List<AbnormalRowVo> abnormalAnalysisPerson(OpportunityDto dto) {
        dto.setDelFlag("0");
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        List struList = DataPermission.getStruCache();
        dto.setOpportunityView("1");
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"3".equals(dto.getEndTime()) && !"6".equals(dto.getEndTime())) {
            DateConvertVo dateConvertVo = IndexUtil.getCurrentTime((String)dto.getEndTime());
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        this.createTimeFlag(dto);
        if (ToolUtil.isNotEmpty((Object)dto.getTransOwnDepartmentIds()) && dto.getTransOwnDepartmentIds().size() > 0) {
            List ownDepts = dto.getTransOwnDepartmentIds();
            ArrayList ownDeptList = new ArrayList();
            ownDeptList.addAll(ownDepts);
            for (String struId : ownDepts) {
                List deptIds = DataPermission.getAllDeptIdByParentId((List)struList, (Long)Long.valueOf(struId));
                ownDeptList.addAll(deptIds);
            }
            dto.setTransOwnDepartmentIds(ownDeptList);
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageAbandonConvert(true);
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageEnd(true);
        stageTypeDto.setStageStart(true);
        stageTypeDto.setStageWinLose(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        OpportunityDto opportunityDto = this.opportunityQueryCondition(dto);
        if ("\u79bb\u804c".equals(dto.getOpportunityScreening())) {
            dto.setOpportunityScreening("");
            SysStru dimissionStru = this.commonMapper.getSysStruByOrganAlias("\u79bb\u804c");
            dto.setDimissionId(dimissionStru.getId());
        }
        opportunityDto.setOpportunityAbnormalOverdue("1");
        opportunityDto.setOpportunityAbnormalWin(null);
        opportunityDto.setOpportunityAbnormalInfo(null);
        List<AbnormalCellVo> overdueCells = this.oppoDistributeMapper.getPersonOppoAbnormalCellVos(opportunityDto, permissionDto, stageSelectDto);
        List<ChargePersonVo> overdueDept = this.oppoDistributeMapper.selectAbnormalPersonByOppo(opportunityDto, permissionDto, stageSelectDto);
        opportunityDto.setOpportunityAbnormalOverdue(null);
        opportunityDto.setOpportunityAbnormalWin("1");
        opportunityDto.setOpportunityAbnormalInfo(null);
        List<AbnormalCellVo> winCells = this.oppoDistributeMapper.getPersonOppoAbnormalCellVos(opportunityDto, permissionDto, stageSelectDto);
        List<ChargePersonVo> winDept = this.oppoDistributeMapper.selectAbnormalPersonByOppo(opportunityDto, permissionDto, stageSelectDto);
        opportunityDto.setOpportunityAbnormalOverdue(null);
        opportunityDto.setOpportunityAbnormalWin(null);
        opportunityDto.setOpportunityAbnormalInfo("1");
        List<AbnormalCellVo> oppoInfoCells = this.oppoDistributeMapper.getPersonOppoAbnormalCellVos(opportunityDto, permissionDto, stageSelectDto);
        List<ChargePersonVo> oppoInfoDept = this.oppoDistributeMapper.selectAbnormalPersonByOppo(opportunityDto, permissionDto, stageSelectDto);
        CustomerDto custAbnormalInfoDto = new CustomerDto();
        custAbnormalInfoDto.setCustomerView("1");
        custAbnormalInfoDto.setCustomerAbnormalInfo("1");
        custAbnormalInfoDto.setCreateTimeFlag(dto.getCreateTimeFlag());
        custAbnormalInfoDto.setStartTime(dto.getStartTime());
        custAbnormalInfoDto.setFinalTime(dto.getFinalTime());
        custAbnormalInfoDto.setTransChargePersonIds(dto.getTransChargePersonIds());
        custAbnormalInfoDto.setTransOwnDepartmentIds(dto.getTransOwnDepartmentIds());
        List<AbnormalCellVo> custInfoCells = this.getPersonCustAbnormalCellVos(custAbnormalInfoDto, stageSelectDto);
        List<ChargePersonVo> custInfoDept = this.selectAbnormalPersonByCust(custAbnormalInfoDto, stageSelectDto);
        ArrayList<AbnormalCellVo> cellList = new ArrayList<AbnormalCellVo>();
        cellList.addAll(overdueCells);
        cellList.addAll(winCells);
        cellList.addAll(oppoInfoCells);
        cellList.addAll(custInfoCells);
        if (cellList == null || cellList.size() == 0) {
            return new ArrayList<AbnormalRowVo>();
        }
        ArrayList<ChargePersonVo> personList = new ArrayList<ChargePersonVo>();
        personList.addAll(overdueDept);
        personList.addAll(winDept);
        personList.addAll(oppoInfoDept);
        personList.addAll(custInfoDept);
        TreeSet<ChargePersonVo> personSet = new TreeSet<ChargePersonVo>((o1, o2) -> o1.getUserId().compareTo(o2.getUserId()));
        personSet.addAll(personList);
        List<Object> personListAll = new ArrayList(personSet);
        if (HussarUtils.isEmpty((Object)dto.getOppoDistributeOrderString())) {
            List struLists = personListAll.stream().map(ChargePersonVo::getStruId).distinct().collect(Collectors.toList());
            List sysStrus = this.sysStruService.listByIds(struLists);
            Map<Long, SysStru> struIdToSysStruMap = sysStrus.stream().collect(Collectors.toMap(SysStru::getId, sysStru -> sysStru, (existing, replacement) -> existing));
            personListAll.stream().filter(f -> ToolUtil.isNotEmpty((Object)f.getStruId())).forEach(chargePersonVo -> {
                Long struId = Long.parseLong(chargePersonVo.getStruId());
                SysStru sysStru = (SysStru)struIdToSysStruMap.get(struId);
                if (sysStru != null) {
                    chargePersonVo.setStruOrder(sysStru.getStruOrder());
                }
            });
            if (CollectionUtil.isNotEmpty(personListAll)) {
                Map<String, ChargePersonVo> salespersonRankingVoMap = personListAll.stream().collect(Collectors.toMap(ChargePersonVo::getUserId, s -> s));
                List<Long> userIdList = personListAll.stream().map(f -> Long.parseLong(f.getUserId())).distinct().collect(Collectors.toList());
                List<SalespersonVo> salespersonVoList = this.salespersonAnalysisMapper.selectUserList(userIdList);
                if (CollectionUtil.isNotEmpty(salespersonVoList)) {
                    for (SalespersonVo tempBehaviorVo : salespersonVoList) {
                        Long chargePersonId = tempBehaviorVo.getUserId();
                        ChargePersonVo chargePersonVo2 = salespersonRankingVoMap.get(chargePersonId + "");
                        if (chargePersonVo2 == null) continue;
                        chargePersonVo2.setStaffPosition(tempBehaviorVo.getStaffPosition() == null ? "461" : tempBehaviorVo.getStaffPosition());
                        chargePersonVo2.setUserOrder(Integer.valueOf(tempBehaviorVo.getUserOrder() == null ? 100000 : tempBehaviorVo.getUserOrder()));
                        chargePersonVo2.setStruOrder(Integer.valueOf(tempBehaviorVo.getStruOrder() == null ? 100000 : tempBehaviorVo.getStruOrder()));
                    }
                }
            }
            personListAll = personListAll.stream().sorted(Comparator.comparing(ChargePersonVo::getStruOrder).thenComparing(ChargePersonVo::getStruId).thenComparing(ChargePersonVo::getStaffPosition).thenComparingInt(ChargePersonVo::getUserOrder)).collect(Collectors.toList());
        }
        List<AbnormalRowVo> excelDeptRowVoList = new ArrayList<AbnormalRowVo>(16);
        AbnormalRowVo totalRow = new AbnormalRowVo();
        totalRow.setDeptId("\u5408\u8ba1");
        totalRow.setDeptName("\u5408\u8ba1");
        totalRow.setShortName("\u5408\u8ba1");
        totalRow.setNextLevel("Y");
        totalRow.setCellVoList(new ArrayList<AbnormalCellVo>());
        for (int i = 0; i < personListAll.size(); ++i) {
            ChargePersonVo person = (ChargePersonVo)personListAll.get(i);
            AbnormalRowVo thisPersonRow = new AbnormalRowVo();
            thisPersonRow.setDeptId(person.getStruId());
            thisPersonRow.setDeptName(person.getOrganAlias());
            thisPersonRow.setShortName(person.getShortName());
            thisPersonRow.setChargePersonId(person.getUserId());
            thisPersonRow.setChargePersonName(person.getUserName());
            ArrayList<AbnormalCellVo> rowCellList = new ArrayList<AbnormalCellVo>(16);
            for (int j = 0; j < ABNORMAL_TYPE.length; ++j) {
                String abnormal = ABNORMAL_TYPE[j];
                AbnormalCellVo totalRowCell = new AbnormalCellVo();
                totalRowCell.setDataType(abnormal);
                totalRowCell.setDataId("\u5408\u8ba1");
                totalRowCell.setCountnum(0L);
                if (i != 0) {
                    totalRowCell = totalRow.getCellVoList().get(j);
                }
                boolean stageExist = false;
                for (int k = 0; k < cellList.size(); ++k) {
                    AbnormalCellVo cell = (AbnormalCellVo)cellList.get(k);
                    if (!abnormal.equals(cell.getDataType()) || !person.getUserId().equals(cell.getDataId())) continue;
                    AbnormalCellVo thisCell = new AbnormalCellVo();
                    thisCell.setDataId(cell.getDataId());
                    thisCell.setDataType(abnormal);
                    thisCell.setCountnum(cell.getCountnum());
                    totalRowCell.setCountnum(totalRowCell.getCountnum() + thisCell.getCountnum());
                    rowCellList.add(thisCell);
                    cellList.remove(k);
                    --k;
                    stageExist = true;
                }
                if (!stageExist) {
                    AbnormalCellVo thisCell = new AbnormalCellVo();
                    thisCell.setDataId(person.getUserId());
                    thisCell.setDataType(abnormal);
                    thisCell.setCountnum(0L);
                    rowCellList.add(thisCell);
                }
                List<AbnormalCellVo> totalCellList = totalRow.getCellVoList();
                if (i == 0) {
                    if (j == 0) {
                        totalCellList = new ArrayList<AbnormalCellVo>(Arrays.asList(totalRowCell));
                    } else {
                        totalCellList.add(totalRowCell);
                    }
                } else {
                    totalCellList.set(j, totalRowCell);
                }
                totalRow.setCellVoList(totalCellList);
            }
            thisPersonRow.setCellVoList(rowCellList);
            excelDeptRowVoList.add(thisPersonRow);
        }
        excelDeptRowVoList.add(totalRow);
        if (ToolUtil.isNotEmpty((Object)dto.getOppoDistributeOrderString())) {
            excelDeptRowVoList = this.abnormalSort(dto.getOppoDistributeOrderString(), excelDeptRowVoList);
        }
        return excelDeptRowVoList;
    }

    @Override
    public void abnormalExport(HttpServletResponse response, OpportunityDto dto, String type) {
        List<Object> abnormalList = new ArrayList();
        if ("\u90e8\u95e8".equals(type)) {
            abnormalList = this.abnormalAnalysisDept(dto);
        } else if ("\u4eba\u5458".equals(type)) {
            abnormalList = this.abnormalAnalysisPerson(dto);
        }
        try {
            SXSSFWorkbook workbook = new SXSSFWorkbook(100);
            String lastFileName = "\u6570\u636e\u5f02\u5e38\u5206\u6790-" + type + ".xlsx";
            ServletOutputStream out = response.getOutputStream();
            response.setContentType("application/msexcel;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(lastFileName, "UTF-8"));
            String sheetName = "Sheet1";
            SXSSFSheet sheet = workbook.createSheet(sheetName);
            CellStyle style = ExcelStyle.getStyle((Workbook)workbook);
            Row dataRowTitle = sheet.createRow(0);
            Cell titleCellFirst = dataRowTitle.createCell(0);
            titleCellFirst.setCellType(CellType.STRING);
            titleCellFirst.setCellStyle(style);
            titleCellFirst.setCellValue(type);
            for (int i = 0; i < ABNORMAL_TYPE_NAME.length; ++i) {
                Cell titleCell = dataRowTitle.createCell(i + 1);
                titleCell.setCellType(CellType.STRING);
                titleCell.setCellStyle(style);
                titleCell.setCellValue(ABNORMAL_TYPE_NAME[i]);
            }
            if (abnormalList != null && abnormalList.size() > 0) {
                for (int index = 0; index < abnormalList.size(); ++index) {
                    SXSSFRow dataRow = workbook.getSheet(sheetName).createRow(index + 1);
                    List<AbnormalCellVo> cellList = ((AbnormalRowVo)abnormalList.get(index)).getCellVoList();
                    Cell cellDepart = dataRow.createCell(0);
                    cellDepart.setCellType(CellType.STRING);
                    cellDepart.setCellStyle(style);
                    if ("\u90e8\u95e8".equals(type)) {
                        cellDepart.setCellValue(((AbnormalRowVo)abnormalList.get(index)).getDeptName());
                    } else if ("\u4eba\u5458".equals(type)) {
                        String shortName = ToolUtil.isEmpty((Object)((AbnormalRowVo)abnormalList.get(index)).getShortName()) ? "" : "\uff08" + ((AbnormalRowVo)abnormalList.get(index)).getShortName() + "\uff09";
                        cellDepart.setCellValue(((AbnormalRowVo)abnormalList.get(index)).getChargePersonName() + shortName);
                        if (index == abnormalList.size() - 1) {
                            cellDepart.setCellValue("\u5408\u8ba1");
                        }
                    }
                    for (int j = 0; j < ABNORMAL_TYPE.length; ++j) {
                        String abnormalType = ABNORMAL_TYPE[j];
                        for (int columnIndex = 0; columnIndex < cellList.size(); ++columnIndex) {
                            AbnormalCellVo cellVo = cellList.get(columnIndex);
                            if (!abnormalType.equals(cellVo.getDataType())) continue;
                            Cell cellCount = dataRow.createCell(j + 1);
                            cellCount.setCellType(CellType.NUMERIC);
                            cellCount.setCellStyle(style);
                            cellCount.setCellValue((double)cellVo.getCountnum().longValue());
                        }
                    }
                }
            }
            workbook.write((OutputStream)out);
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SalesStatisticsDto customerOperate(CustomerDto dto) {
        String customerView;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (dto != null && StringUtil.isNotEmpty((Object)(customerView = dto.getCustomerView())) && !"2".equals(customerView) && !"4".equals(customerView) && !"0".equals(customerView)) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllCustomer()))) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
        }
        return permissionDto;
    }

    private CustomerDto customerQueryCondition(CustomerDto dto) {
        if (StringUtil.isEmpty((Object)dto.getCustomerView())) {
            dto.setCustomerView("1");
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isNotEmpty((Object)dto.getCustomerScreening())) {
            dto.setCustomerScreening(dto.getCustomerScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        String customerView = dto.getCustomerView();
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (Object userId : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        ArrayList<String> teamMemberIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getTeamMemberIds()) && dto.getTeamMemberIds().size() > 0) {
            for (String teamMemberId : dto.getTeamMemberIds()) {
                teamMemberIds.add(CommonUtills.translateUserId((String)teamMemberId));
            }
            dto.setTransTeamMemberIds(teamMemberIds);
        }
        List departments = dto.getTransOwnDepartmentIds();
        ArrayList odpIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        if ("2".equals(customerView)) {
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        dto.setDelFlag("0");
        dto.setCurrentUserId(user.getUserId());
        if ("1".equals(dto.getCreateTimeFlag()) || "2".equals(dto.getCreateTimeFlag()) || "13".equals(dto.getCreateTimeFlag())) {
            DateConvertVo dateConvertVo = IndexUtil.getCurrentTime((String)dto.getCreateTimeFlag());
            dto.setStartTime(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setFinalTime(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        return dto;
    }

    private List<AbnormalCellVo> getDeptCustAbnormalCellVos(CustomerDto dto, int struLevel, StageSelectDto stageSelectDto) {
        SalesStatisticsDto permissionDto = this.customerOperate(dto);
        CustomerDto customerDto = this.customerQueryCondition(dto);
        return this.oppoDistributeMapper.getDeptCustAbnormalCellVos(customerDto, permissionDto, struLevel, stageSelectDto);
    }

    private List<DepartmentVo> selectAbnormalDeptByCust(CustomerDto dto, int struLevel, StageSelectDto stageSelectDto) {
        SalesStatisticsDto permissionDto = this.customerOperate(dto);
        CustomerDto customerDto = this.customerQueryCondition(dto);
        return this.oppoDistributeMapper.selectAbnormalDeptByCust(customerDto, permissionDto, struLevel, stageSelectDto);
    }

    private List<AbnormalCellVo> getPersonCustAbnormalCellVos(CustomerDto dto, StageSelectDto stageSelectDto) {
        SalesStatisticsDto permissionDto = this.customerOperate(dto);
        CustomerDto customerDto = this.customerQueryCondition(dto);
        return this.oppoDistributeMapper.getPersonCustAbnormalCellVos(customerDto, permissionDto, stageSelectDto);
    }

    private List<ChargePersonVo> selectAbnormalPersonByCust(CustomerDto dto, StageSelectDto stageSelectDto) {
        SalesStatisticsDto permissionDto = this.customerOperate(dto);
        CustomerDto customerDto = this.customerQueryCondition(dto);
        return this.oppoDistributeMapper.selectAbnormalPersonByCust(customerDto, permissionDto, stageSelectDto);
    }

    private List<AbnormalRowVo> abnormalSort(String orderString, List<AbnormalRowVo> dataList) {
        String[] orders = orderString.split(",");
        if (orders == null || orders.length != 3) {
            return dataList;
        }
        String orderStageId = orders[0];
        String orderType = orders[1];
        String orderSc = orders[2];
        AbnormalRowVo total = dataList.get(dataList.size() - 1);
        dataList.remove(dataList.size() - 1);
        for (int i = 0; i < dataList.size() - 1; ++i) {
            for (int j = 0; j < dataList.size() - 1 - i; ++j) {
                AbnormalRowVo jDeptRowVo = dataList.get(j);
                Long jLong = 0L;
                AbnormalRowVo jPDeptRowVo = dataList.get(j + 1);
                Long jpLong = 0L;
                for (AbnormalCellVo jcell : jDeptRowVo.getCellVoList()) {
                    if (!jcell.getDataType().equals(orderStageId)) continue;
                    jLong = jcell.getCountnum();
                    break;
                }
                for (AbnormalCellVo jcell : jPDeptRowVo.getCellVoList()) {
                    if (!jcell.getDataType().equals(orderStageId)) continue;
                    jpLong = jcell.getCountnum();
                    break;
                }
                if (!"0".equals(orderType)) continue;
                if ("0".equals(orderSc)) {
                    if (jLong.compareTo(jpLong) <= 0) continue;
                    Collections.swap(dataList, j, j + 1);
                    continue;
                }
                if (jLong.compareTo(jpLong) > 0) continue;
                Collections.swap(dataList, j, j + 1);
            }
        }
        dataList.add(total);
        return dataList;
    }

    @Override
    public Page<OpportunityVo> abnormalAnalysisList(AbnormalAnalysisDto dto) {
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo2;
        Page page = dto.getPage();
        dto.setDelFlag("0");
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        if (ToolUtil.isNotEmpty((Object)dto.getOpportunityScreening())) {
            dto.setOpportunityScreening(dto.getOpportunityScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getCreateTimeRange()) && ToolUtil.isNotEmpty((Object)(dateConvertVo2 = CrmDateUtils.getCurrentTime((String)dto.getCreateTimeRange())))) {
            dto.setCreateTimeStart(LocalDate.parse(dateConvertVo2.getStartDate()));
            dto.setCreateTimeEnd(LocalDate.parse(dateConvertVo2.getEndDate()));
        }
        dto.setCurrentUserId(user.getUserId());
        List<Long> deptIds = dto.getDeptIds();
        ArrayList<Long> odpIds = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty(deptIds) && deptIds.size() > 0) {
            for (Long odpId : deptIds) {
                ArrayList Ids;
                String odpIsTemp = CommonUtills.translateDepId((String)String.valueOf(odpId));
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(Long.valueOf((String)idsTemp.get(i)));
                }
            }
            deptIds.addAll(odpIds);
            dto.setDeptIds(deptIds);
        }
        if ("1".equals(dto.getDimension())) {
            List<Long> selectRowIds = dto.getSelectRowIds();
            ArrayList<Long> cdpIds = new ArrayList<Long>();
            if (ToolUtil.isNotEmpty(selectRowIds) && selectRowIds.size() > 0) {
                for (Long odpId : selectRowIds) {
                    ArrayList Ids;
                    String odpIsTemp = CommonUtills.translateDepId((String)String.valueOf(odpId));
                    List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                    if (idsTemp.size() <= 0) continue;
                    for (int i = 0; i < idsTemp.size(); ++i) {
                        cdpIds.add(Long.valueOf((String)idsTemp.get(i)));
                    }
                }
                selectRowIds.addAll(cdpIds);
                dto.setSelectRowIds(selectRowIds);
            }
        }
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageStart(true);
        stageTypeDto.setStageWin(true);
        stageTypeDto.setStageEnd(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List<OpportunityVo> opportunityVoList = this.oppoDistributeMapper.abnormalAnalysisList(page, dto, permissionDto, stageSelectDto);
        page.setRecords(opportunityVoList);
        return page;
    }

    @Override
    public Page<OpportunityVo> followUpAnalysisList(FollowUpAnalysisDto dto) {
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo2;
        Page page = dto.getPage();
        dto.setDelFlag("0");
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        dto.setOpportunityView("1");
        SalesStatisticsDto permissionDto = this.opportunityOperate(dto);
        if (ToolUtil.isNotEmpty((Object)dto.getOpportunityScreening())) {
            dto.setOpportunityScreening(dto.getOpportunityScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getTimeRange()) && ToolUtil.isNotEmpty((Object)(dateConvertVo2 = CrmDateUtils.getCurrentTime((String)dto.getTimeRange())))) {
            dto.setStartTime(LocalDate.parse(dateConvertVo2.getStartDate()));
            dto.setEndTime(LocalDate.parse(dateConvertVo2.getEndDate()));
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getCreateTimeRange()) && ToolUtil.isNotEmpty((Object)(dateConvertVo2 = CrmDateUtils.getCurrentTime((String)dto.getCreateTimeRange())))) {
            dto.setCreateTimeStart(LocalDate.parse(dateConvertVo2.getStartDate()));
            dto.setCreateTimeEnd(LocalDate.parse(dateConvertVo2.getEndDate()));
        }
        dto.setCurrentUserId(user.getUserId());
        List<Long> deptIds = dto.getDeptIds();
        ArrayList<Long> odpIds = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty(deptIds) && deptIds.size() > 0) {
            for (Long odpId : deptIds) {
                ArrayList Ids;
                String odpIsTemp = CommonUtills.translateDepId((String)String.valueOf(odpId));
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(Long.valueOf((String)idsTemp.get(i)));
                }
            }
            deptIds.addAll(odpIds);
            dto.setDeptIds(deptIds);
        }
        if ("1".equals(dto.getDimension())) {
            List<Long> selectRowIds = dto.getSelectRowIds();
            ArrayList<Long> cdpIds = new ArrayList<Long>();
            if (ToolUtil.isNotEmpty(selectRowIds) && selectRowIds.size() > 0) {
                for (Long odpId : selectRowIds) {
                    ArrayList Ids;
                    String odpIsTemp = CommonUtills.translateDepId((String)String.valueOf(odpId));
                    List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                    if (idsTemp.size() <= 0) continue;
                    for (int i = 0; i < idsTemp.size(); ++i) {
                        cdpIds.add(Long.valueOf((String)idsTemp.get(i)));
                    }
                }
                selectRowIds.addAll(cdpIds);
                dto.setSelectRowIds(selectRowIds);
            }
        }
        LocalDate now = LocalDate.now();
        LocalDate sevenDaysLater = now.minus(Period.ofDays(7));
        LocalDate fifteenDaysLater = now.minus(Period.ofDays(15));
        LocalDate thirtyDaysLater = now.minus(Period.ofDays(30));
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageEnd(true);
        StageSelectDto stageSelectDto = this.stageProcessApiService.getStageIdByType(stageTypeDto);
        List<OpportunityVo> opportunityVoList = this.oppoDistributeMapper.followUpAnalysisList(page, dto, permissionDto, sevenDaysLater, fifteenDaysLater, thirtyDaysLater, stageSelectDto);
        page.setRecords(opportunityVoList);
        return page;
    }

    private SalesStatisticsDto opportunityOperate(OpportunityAnalysisDto dto) {
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        String opportunityView = dto.getOpportunityView();
        if (StringUtil.isNotEmpty((Object)opportunityView) && !"2".equals(opportunityView) && !"0".equals(opportunityView) && !"10".equals(opportunityView)) {
            if (dto != null && dto.getCurrentUserId() != null) {
                IndexUtil.getUserRolePermissionsByUserId((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties, (Long)dto.getCurrentUserId());
            } else {
                IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            }
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user == null || ToolUtil.isEmpty((Object)user.getUserId())) {
                CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
                user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
            }
            if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllOpportunity()))) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
        }
        return permissionDto;
    }

    @Override
    public Page<AbnormalAnalysisCustomerVo> abnormalAnalysisCustomerList(CustomerProfileAnalysisDto dto) {
        com.jxdinfo.crm.common.api.util.entity.DateConvertVo dateConvertVo;
        Page page = dto.getPage();
        SecurityUser user = BaseSecurityUtil.getUser();
        SalesStatisticsDto permissionDto = this.customerOperate(dto);
        if (ToolUtil.isNotEmpty((Object)dto.getCustomerScreening())) {
            dto.setCustomerScreening(dto.getCustomerScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        List<Long> departments = dto.getDeptIds();
        ArrayList<Long> odpIds = new ArrayList<Long>();
        if (ToolUtil.isNotEmpty(departments) && departments.size() > 0) {
            for (Long odpId : departments) {
                ArrayList ids;
                String odpIsTemp = CommonUtills.translateDepId((String)String.valueOf(odpId));
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(Long.valueOf((String)idsTemp.get(i)));
                }
            }
            departments.addAll(odpIds);
            dto.setDeptIds(departments);
        }
        dto.setCurrentUserId(user.getUserId());
        if (ToolUtil.isNotEmpty((Object)dto.getCreateTimeRange()) && !"6".equals(dto.getCreateTimeRange()) && (dateConvertVo = CrmDateUtils.getCurrentTime((String)dto.getCreateTimeRange())) != null) {
            dto.setCreateTimeStart(LocalDate.parse(dateConvertVo.getStartDate()));
            dto.setCreateTimeEnd(LocalDate.parse(dateConvertVo.getEndDate()));
        }
        List<AbnormalAnalysisCustomerVo> list = this.oppoDistributeMapper.abnormalAnalysisCustomerList(page, dto, permissionDto);
        page.setRecords(list);
        return page;
    }

    private SalesStatisticsDto customerOperate(CustomerProfileAnalysisDto dto) {
        String customerView;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        if (dto != null && StringUtil.isNotEmpty((Object)(customerView = dto.getCustomerView())) && !"2".equals(customerView) && !"4".equals(customerView) && !"0".equals(customerView)) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
            SecurityUser user = BaseSecurityUtil.getUser();
            if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllCustomer()))) {
                permissionDto.setPermissionDeptIds(null);
                permissionDto.setPermissionUserId(null);
            }
        }
        return permissionDto;
    }

    private OpportunityDto intelligentProductCondition(OpportunityDto dto) {
        String opportunityView;
        SecurityUser user;
        if (StringUtil.isEmpty((Object)dto.getOpportunityView())) {
            dto.setOpportunityView("1");
        }
        if (ToolUtil.isNotEmpty((Object)dto.getOpportunityScreening())) {
            dto.setOpportunityScreening(dto.getOpportunityScreening().replaceAll("%", "/%").replaceAll("_", "/_"));
        }
        if ((user = BaseSecurityUtil.getUser()) == null || ToolUtil.isEmpty((Object)user.getUserId())) {
            CommonMapper commonMapper = (CommonMapper)SpringUtils.getBean(CommonMapper.class);
            user = commonMapper.selectSecurityByUserId(dto.getCurrentUserId());
        }
        ArrayList<String> userIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getChargePersonIds()) && dto.getChargePersonIds().size() > 0) {
            for (Object userId : dto.getChargePersonIds()) {
                userIds.add(CommonUtills.translateUserId((String)userId));
            }
            dto.setTransChargePersonIds(userIds);
        }
        ArrayList<String> createPersonIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getCreatePersonIds()) && dto.getCreatePersonIds().size() > 0) {
            for (Object createPersonId : dto.getCreatePersonIds()) {
                createPersonIds.add(CommonUtills.translateUserId((String)createPersonId));
            }
            dto.setTransCreatePersonIds(createPersonIds);
        }
        ArrayList<String> teamMemberIds = new ArrayList<String>();
        if (ToolUtil.isNotEmpty((Object)dto.getTeamMemberIds()) && dto.getTeamMemberIds().size() > 0) {
            for (String teamMemberId : dto.getTeamMemberIds()) {
                teamMemberIds.add(CommonUtills.translateUserId((String)teamMemberId));
            }
            dto.setTransTeamMemberIds(teamMemberIds);
        }
        List departments = dto.getOwnDepartments();
        ArrayList odpIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)departments) && departments.size() > 0) {
            for (String odpId : departments) {
                ArrayList Ids;
                String odpIsTemp = CommonUtills.translateDepId((String)odpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    odpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransOwnDepartmentIds(odpIds);
        }
        List createDepartments = dto.getCreateDepartments();
        ArrayList cdpIds = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)createDepartments) && createDepartments.size() > 0) {
            for (String cdpId : createDepartments) {
                ArrayList Ids;
                String cdpIsTemp = CommonUtills.translateDepId((String)cdpId);
                List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)cdpIsTemp, Ids = new ArrayList());
                if (idsTemp.size() <= 0) continue;
                for (int i = 0; i < idsTemp.size(); ++i) {
                    cdpIds.add(idsTemp.get(i));
                }
            }
            dto.setTransCreateDepartmentIds(cdpIds);
        }
        if ("2".equals(opportunityView = dto.getOpportunityView()) || "2".equals(dto.getCompetence())) {
            dto.setOpportunityView("myself");
            dto.setChargePersonId(String.valueOf(BaseSecurityUtil.getUser().getId()));
        }
        if (StringUtil.isNotBlank((CharSequence)dto.getEndTime()) && !"3".equals(dto.getEndTime()) && !"6".equals(dto.getEndTime())) {
            DateConvertVo dateConvertVo = IndexUtil.getCurrentTime((String)dto.getEndTime());
            dto.setStartDate(dateConvertVo.getStartDate());
            dto.setEndDate(dateConvertVo.getEndDate());
        }
        dto.setDelFlag("0");
        this.createTimeFlag(dto);
        dto.setCurrentUserId(user.getUserId());
        return dto;
    }
}

