/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.common.CommonUtil;
import com.jxdinfo.crm.analysis.common.vo.RolePermissionsVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.OpportunityContractMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.OpportunityContractDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.IOpportunityContractService;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.ContractVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.OpportunityContractVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.OpportunityProductVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.OpportunityVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.organUser.IOrganUserBoService;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.contract.service.CrmContractService;
import com.jxdinfo.crm.core.index.dto.SalesStatisticsDto;
import com.jxdinfo.crm.core.index.util.IndexUtil;
import com.jxdinfo.crm.core.utills.WriteExcel;
import com.jxdinfo.crm.core.utills.entity.ExcelRegionDto;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;

@Service
public class OpportunityContractServiceImpl
implements IOpportunityContractService {
    @Resource
    private OpportunityContractMapper opportunityContractMapper;
    @Resource
    private CommonUtil commonUtil;
    @Resource
    private IOrganUserBoService organUserBoService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private ISysDicRefService dicRefService;
    @Resource
    private CrmContractService crmContractService;

    @Override
    public Page<OpportunityContractVo> getOpportunityContract(OpportunityContractDto dto) {
        List<OpportunityVo> opportunityVos;
        List<OpportunityProductVo> opportunityProductVoList;
        SalesStatisticsDto permissionDto = new SalesStatisticsDto();
        SecurityUser user = BaseSecurityUtil.getUser();
        if (!user.getRolesList().contains(Long.parseLong(this.crmProperties.getRoles().getAllOpportunity()))) {
            IndexUtil.currentUserRolePermissions((SalesStatisticsDto)permissionDto, (CrmCommonProperties)this.crmProperties);
        }
        this.permissionMethod(dto);
        dto.setDeptIds(this.organUserBoService.getOrganByParentIdContainsParent(dto.getDeptIds()));
        List<OpportunityVo> opportunityVoList = this.opportunityContractMapper.getOpportunityContract(dto, permissionDto);
        Map<Long, OpportunityVo> opportunityContractListMap = opportunityVoList.stream().collect(Collectors.toMap(OpportunityVo::getOpportunityId, opportunityContractVo -> opportunityContractVo));
        if (CollectionUtil.isNotEmpty(opportunityVoList) && CollectionUtil.isNotEmpty(opportunityProductVoList = this.opportunityContractMapper.getOpportunityProduct(dto, permissionDto))) {
            Map<Long, List<OpportunityProductVo>> opportunityProductListMap = opportunityProductVoList.stream().collect(Collectors.groupingBy(OpportunityProductVo::getOpportunityId));
            for (Long setKey : opportunityContractListMap.keySet()) {
                List<OpportunityProductVo> list = opportunityProductListMap.get(setKey);
                String productShortName = null;
                double sumSellPrice = 0.0;
                if (CollectionUtil.isNotEmpty(list)) {
                    for (OpportunityProductVo opportunityProductVo : list) {
                        productShortName = StringUtil.isEmpty(productShortName) ? opportunityProductVo.getProductShortNames() : productShortName + "," + opportunityProductVo.getProductShortNames();
                        double sellPrice = opportunityProductVo.getSellPrice() == null ? 0.0 : opportunityProductVo.getSellPrice();
                        sumSellPrice += sellPrice;
                    }
                }
                OpportunityVo vo = opportunityContractListMap.get(setKey);
                vo.setProductShortNames(productShortName);
                vo.setProductSellPrice(sumSellPrice);
            }
        }
        if (dto.getOrderBy() != null && "30".equals(dto.getOrderBy())) {
            opportunityVoList.sort(Comparator.comparingDouble(OpportunityVo::getProductSellPrice));
        } else if (dto.getOrderBy() != null && "31".equals(dto.getOrderBy())) {
            opportunityVoList.sort(Comparator.comparingDouble(OpportunityVo::getProductSellPrice).reversed());
        }
        double sumOpportunityAmount = 0.0;
        double sumSellPrices = 0.0;
        double sumContractAmount = 0.0;
        double sumNetContractAmount = 0.0;
        for (OpportunityVo opportunityContractVo2 : opportunityVoList) {
            double opportunityAmount = opportunityContractVo2.getOpportunityAmount() == null ? 0.0 : opportunityContractVo2.getOpportunityAmount();
            sumOpportunityAmount += opportunityAmount;
            double productSellPrice = opportunityContractVo2.getProductSellPrice() == null ? 0.0 : opportunityContractVo2.getProductSellPrice();
            sumSellPrices += productSellPrice;
            List<ContractVo> contractVoList = opportunityContractVo2.getContractVoList();
            double opportunityContractAmount = 0.0;
            for (ContractVo contractVo : contractVoList) {
                double contractAmount = contractVo.getContractAmount() == null ? 0.0 : contractVo.getContractAmount();
                sumContractAmount += contractAmount;
                opportunityContractAmount += contractAmount;
                double netContractAmount = contractVo.getNetContractAmount() == null ? 0.0 : contractVo.getNetContractAmount();
                sumNetContractAmount += netContractAmount;
            }
            opportunityContractVo2.setAmountMatched(1);
            if (opportunityContractAmount == opportunityAmount || !CollectionUtil.isNotEmpty(contractVoList)) continue;
            opportunityContractVo2.setAmountMatched(0);
        }
        Page page = new Page();
        if (dto.getSize() != null && dto.getCurrent() != null) {
            page.setTotal((long)opportunityVoList.size());
            Integer pageSize = dto.getSize();
            page.setSize((long)pageSize.intValue());
            Integer pageNo = dto.getCurrent();
            page.setCurrent((long)pageNo.intValue());
            page.setOptimizeCountSql(true);
            page.setSearchCount(true);
            int pages = opportunityVoList.size() / pageSize + (opportunityVoList.size() % pageSize > 0 ? 1 : 0);
            page.setPages((long)pages);
            opportunityVos = opportunityVoList.subList((pageNo - 1) * pageSize, Math.min(pageNo * pageSize, opportunityVoList.size()));
        } else {
            opportunityVos = opportunityVoList;
        }
        List<OpportunityContractVo> opportunityContractVoList = this.relationToList(opportunityVos);
        OpportunityContractVo opportunityContractVo3 = new OpportunityContractVo();
        opportunityContractVo3.setOpportunityName("\u5408\u8ba1\uff08\u4e07\u5143\uff09");
        opportunityContractVo3.setAmountMatched(1);
        opportunityContractVo3.setOpportunityAmount((double)Math.round(sumOpportunityAmount / 100.0) / 100.0);
        opportunityContractVo3.setProductSellPrice((double)Math.round(sumSellPrices / 100.0) / 100.0);
        opportunityContractVo3.setContractAmount((double)Math.round(sumContractAmount / 100.0) / 100.0);
        opportunityContractVo3.setNetContractAmount((double)Math.round(sumNetContractAmount / 100.0) / 100.0);
        opportunityContractVoList.add(opportunityContractVo3);
        page.setRecords(opportunityContractVoList);
        return page;
    }

    private List<OpportunityContractVo> relationToList(List<OpportunityVo> opportunityVoList) {
        if (CollectionUtil.isEmpty(opportunityVoList)) {
            return new ArrayList<OpportunityContractVo>();
        }
        ArrayList<OpportunityContractVo> opportunityContractVoList = new ArrayList<OpportunityContractVo>();
        List dicSingleList = this.dicRefService.getDictByType("opportunity_from");
        Map<String, String> valueLabelMap = dicSingleList.stream().collect(Collectors.toMap(DicSingle::getValue, DicSingle::getLabel));
        for (OpportunityVo opportunityVo : opportunityVoList) {
            List<ContractVo> contractVoList = opportunityVo.getContractVoList();
            if (CollectionUtil.isEmpty(contractVoList)) {
                OpportunityContractVo opportunityContractVo = new OpportunityContractVo();
                BeanUtil.copyProperties((Object)opportunityVo, (Object)opportunityContractVo);
                opportunityContractVo.setOpportunityFromName(valueLabelMap.get(opportunityVo.getOpportunityFrom()));
                opportunityContractVoList.add(opportunityContractVo);
                continue;
            }
            for (ContractVo contractVo : contractVoList) {
                OpportunityContractVo opportunityContractVo = new OpportunityContractVo();
                BeanUtil.copyProperties((Object)opportunityVo, (Object)opportunityContractVo);
                opportunityContractVo.setContractId(contractVo.getContractId());
                opportunityContractVo.setContractNumber(contractVo.getContractNumber());
                opportunityContractVo.setContractAmount(contractVo.getContractAmount());
                opportunityContractVo.setNetContractAmount(contractVo.getNetContractAmount());
                opportunityContractVo.setSignTime(contractVo.getSignTime());
                opportunityContractVo.setContractOwnDepartment(contractVo.getOwnDepartment());
                opportunityContractVo.setContractOwnDepartmentName(contractVo.getOwnDepartmentName());
                opportunityContractVo.setContractChargePerson(contractVo.getChargePersonId());
                opportunityContractVo.setContractChargePersonName(contractVo.getChargePersonName());
                opportunityContractVo.setFinishTime(contractVo.getFinishTime() == null ? null : contractVo.getFinishTime().toLocalDate());
                opportunityContractVo.setState(contractVo.getState());
                opportunityContractVo.setContractName(contractVo.getContractName());
                opportunityContractVo.setOpportunityFromName(valueLabelMap.get(opportunityVo.getOpportunityFrom()));
                opportunityContractVo.setEndTime(opportunityVo.getEndTime());
                opportunityContractVoList.add(opportunityContractVo);
            }
        }
        return opportunityContractVoList;
    }

    @Override
    public void exportOpportunityContract(HttpServletResponse response, OpportunityContractDto dto) {
        Page<OpportunityContractVo> opportunityContract = this.getOpportunityContract(dto);
        List exportList = opportunityContract.getRecords();
        if (CollectionUtil.isEmpty((Collection)exportList) || exportList.size() == 1) {
            WriteExcel writeExcel = new WriteExcel();
            writeExcel.writeBigExcel(response, exportList, "\u5546\u673a\u5408\u540c\u7edf\u8ba1", OpportunityContractVo.class, new ArrayList());
            return;
        }
        Long beforeOpportunityId = null;
        ArrayList<ExcelRegionDto> excelRegionDtoList = new ArrayList<ExcelRegionDto>();
        HashMap<String, ExcelRegionDto> excelRegionDtoMap = new HashMap<String, ExcelRegionDto>();
        HashSet<String> opportunityIdSet = new HashSet<String>();
        for (int i = 0; i < exportList.size(); ++i) {
            ExcelRegionDto excelRegionDto;
            int j;
            Long thisOpportunityId = ((OpportunityContractVo)exportList.get(i)).getOpportunityId();
            if (!Objects.equals(thisOpportunityId, beforeOpportunityId)) {
                for (j = 0; j < 7; ++j) {
                    excelRegionDto = new ExcelRegionDto();
                    excelRegionDto.setFirstRow(i);
                    excelRegionDto.setLastRow(i);
                    excelRegionDto.setFirstCol(j);
                    excelRegionDto.setLastCol(j);
                    excelRegionDtoMap.put(thisOpportunityId + "#" + j, excelRegionDto);
                }
                beforeOpportunityId = thisOpportunityId;
                continue;
            }
            for (j = 0; j < 7; ++j) {
                excelRegionDto = (ExcelRegionDto)excelRegionDtoMap.get(thisOpportunityId + "#" + j);
                int lastRow = excelRegionDto.getLastRow() + 1;
                excelRegionDto.setLastRow(lastRow);
                if (!opportunityIdSet.add(thisOpportunityId + "#" + j)) continue;
                excelRegionDtoList.add(excelRegionDto);
            }
        }
        WriteExcel writeExcel = new WriteExcel();
        writeExcel.writeBigExcel(response, exportList, "\u5546\u673a\u5408\u540c\u7edf\u8ba1", OpportunityContractVo.class, excelRegionDtoList);
    }

    @Override
    public Page<OpportunityContractVo> getUpdateOpportunityContract(OpportunityContractDto dto) {
        this.crmContractService.saveYyzcContracts();
        return this.getOpportunityContract(dto);
    }

    private OpportunityContractDto permissionMethod(OpportunityContractDto opportunityAnalysisDto) {
        DateConvertVo currentTime;
        RolePermissionsVo rolePermissions;
        if (HussarUtils.isEmpty(opportunityAnalysisDto.getDeptIds()) && HussarUtils.isNotEmpty((Object)(rolePermissions = this.commonUtil.getRolePermissions()))) {
            opportunityAnalysisDto.setPermissionDeptIds(rolePermissions.getPermissionDeptIds());
        }
        if (HussarUtils.isNotEmpty((Object)opportunityAnalysisDto.getTimeRange()) && !"6".equals(opportunityAnalysisDto.getTimeRange())) {
            currentTime = CrmDateUtils.getCurrentTime((String)opportunityAnalysisDto.getTimeRange());
            opportunityAnalysisDto.setStartTime(LocalDate.parse(currentTime.getStartDate()));
            opportunityAnalysisDto.setEndTime(LocalDate.parse(currentTime.getEndDate()));
        }
        if (HussarUtils.isNotEmpty((Object)opportunityAnalysisDto.getCreateTimeRange()) && !"6".equals(opportunityAnalysisDto.getCreateTimeRange())) {
            currentTime = CrmDateUtils.getCurrentTime((String)opportunityAnalysisDto.getCreateTimeRange());
            opportunityAnalysisDto.setCreateTimeStart(LocalDate.parse(currentTime.getStartDate()));
            opportunityAnalysisDto.setCreateTimeEnd(LocalDate.parse(currentTime.getEndDate()));
        }
        if (HussarUtils.isNotEmpty((Object)opportunityAnalysisDto.getFinishTimeRange()) && !"6".equals(opportunityAnalysisDto.getFinishTimeRange())) {
            currentTime = CrmDateUtils.getCurrentTime((String)opportunityAnalysisDto.getFinishTimeRange());
            opportunityAnalysisDto.setFinishTimeStart(LocalDate.parse(currentTime.getStartDate()));
            opportunityAnalysisDto.setFinishTimeEnd(LocalDate.parse(currentTime.getEndDate()));
        }
        SecurityUser user = BaseSecurityUtil.getUser();
        opportunityAnalysisDto.setCurrentUserId(user.getId());
        opportunityAnalysisDto.setWinningOrder(null);
        return opportunityAnalysisDto;
    }
}

