/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.datamonitor.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jxdinfo.crm.agent.api.service.IAgentApiService;
import com.jxdinfo.crm.analysis.datamonitor.dao.DataMonitorFieldMapper;
import com.jxdinfo.crm.analysis.datamonitor.dao.DataMonitorRuleMapper;
import com.jxdinfo.crm.analysis.datamonitor.dto.AbnormalPushScopeDto;
import com.jxdinfo.crm.analysis.datamonitor.dto.DataMonitorIgnoreDto;
import com.jxdinfo.crm.analysis.datamonitor.dto.DataMonitorRuleDto;
import com.jxdinfo.crm.analysis.datamonitor.model.ConditionEntity;
import com.jxdinfo.crm.analysis.datamonitor.model.DataMonitorFieldEntity;
import com.jxdinfo.crm.analysis.datamonitor.model.DataMonitorIgnoreEntity;
import com.jxdinfo.crm.analysis.datamonitor.model.DataMonitorRuleEntity;
import com.jxdinfo.crm.analysis.datamonitor.model.TabulationFieldEntity;
import com.jxdinfo.crm.analysis.datamonitor.service.IDataMonitorFieldService;
import com.jxdinfo.crm.analysis.datamonitor.service.IDataMonitorIgnoreService;
import com.jxdinfo.crm.analysis.datamonitor.service.IDataMonitorRuleService;
import com.jxdinfo.crm.analysis.datamonitor.service.ITabulationFieldService;
import com.jxdinfo.crm.analysis.datamonitor.vo.DataMonitorRuleVo;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.util.CrmLabelUtil;
import com.jxdinfo.crm.common.api.message.dto.MessagePushDto;
import com.jxdinfo.crm.common.api.message.dto.MessageTemplateDto;
import com.jxdinfo.crm.common.api.message.service.IMessagePushService;
import com.jxdinfo.crm.common.api.message.service.IMessageTemplateService;
import com.jxdinfo.crm.common.api.message.vo.MessagePushVo;
import com.jxdinfo.crm.common.api.util.CrmStringUtils;
import com.jxdinfo.crm.core.api.contact.service.IContactAPIService;
import com.jxdinfo.crm.core.api.customer.service.ICustomerAPIService;
import com.jxdinfo.crm.core.api.leads.service.ILeadsAPIService;
import com.jxdinfo.crm.core.api.opportunity.service.IOpportunityAPIService;
import com.jxdinfo.crm.core.common.dao.CommonMapper;
import com.jxdinfo.crm.core.config.UnifyProperties;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.authorization.permit.service.IHussarBaseUserBoService;
import com.jxdinfo.hussar.authorization.permit.vo.UserVo;
import com.jxdinfo.hussar.authorization.relational.model.SysStruUser;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.general.dict.model.DicSingle;
import com.jxdinfo.hussar.general.dict.service.ISysDicRefService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataMonitorRuleServiceImpl
extends ServiceImpl<DataMonitorRuleMapper, DataMonitorRuleEntity>
implements IDataMonitorRuleService {
    @Resource
    private DataMonitorFieldMapper dataMonitorFieldMapper;
    @Resource
    private DataMonitorRuleMapper dataMonitorRuleMapper;
    @Resource
    private ITabulationFieldService tabulationFieldService;
    @Resource
    private ISysDicRefService sysDicRefService;
    @Resource
    private IDataMonitorFieldService dataMonitorFieldService;
    @Resource
    private IOpportunityAPIService opportunityAPIService;
    @Resource
    private ICustomerAPIService customerAPIService;
    @Resource
    private IContactAPIService contactAPIService;
    @Resource
    private ILeadsAPIService leadsAPIService;
    @Resource
    private IAgentApiService agentApiService;
    @Resource
    private IDataMonitorIgnoreService dataMonitorIgnoreService;
    @Resource
    private IMessagePushService messagePushService;
    @Resource
    private IMessageTemplateService messageTemplateService;
    @Resource
    private IHussarBaseUserBoService hussarBaseUserBoService;
    @Resource
    private UnifyProperties unifyProperties;
    @Resource
    private ILabelService labelService;
    @Resource
    private CommonMapper commonMapper;

    @Override
    @Transactional
    public Boolean saveOrUpdateMonitorRuleConfig(DataMonitorRuleDto dto) {
        DataMonitorRuleEntity ruleEntity = new DataMonitorRuleEntity();
        ruleEntity = (DataMonitorRuleEntity)BeanUtil.copy((Object)((Object)dto), DataMonitorRuleEntity.class);
        SecurityUser user = BaseSecurityUtil.getUser();
        if (ToolUtil.isEmpty((Object)dto.getRuleId())) {
            ruleEntity.setRuleId(Long.parseLong(CommonUtills.generateAssignId()));
            ruleEntity.setCreator(user.getUserId());
            ruleEntity.setCreatorName(user.getUserName());
            ruleEntity.setCreateTime(LocalDateTime.now());
            ruleEntity.setLastEditor(user.getUserId());
            ruleEntity.setLastEditorName(user.getUserName());
            ruleEntity.setLastTime(LocalDateTime.now());
        } else {
            this.tabulationFieldService.remove((Wrapper)new LambdaQueryWrapper().in(TabulationFieldEntity::getRuleId, new Object[]{dto.getRuleId()}));
            this.messagePushService.deleteMessagePushByTemplateKey(dto.getRuleId().toString());
            this.messageTemplateService.deleteMessageTemplate(dto.getRuleId().toString());
            ruleEntity.setLastEditor(user.getUserId());
            ruleEntity.setLastEditorName(user.getUserName());
            ruleEntity.setLastTime(LocalDateTime.now());
        }
        ArrayList<DataMonitorFieldEntity> fieldEntitiesList = this.dataMonitorFieldService.listByIds(dto.getShowFields());
        HashMap<Long, DataMonitorFieldEntity> idToEntityMap = new HashMap<Long, DataMonitorFieldEntity>();
        for (DataMonitorFieldEntity entity : fieldEntitiesList) {
            idToEntityMap.put(entity.getFieldId(), entity);
        }
        fieldEntitiesList = new ArrayList<DataMonitorFieldEntity>();
        for (Long id : dto.getShowFields()) {
            DataMonitorFieldEntity entity = (DataMonitorFieldEntity)idToEntityMap.get(id);
            if (!ToolUtil.isNotEmpty((Object)entity)) continue;
            fieldEntitiesList.add(entity);
        }
        ArrayList<TabulationFieldEntity> tabulationFieldEntities = new ArrayList<TabulationFieldEntity>();
        for (int i = 0; i < fieldEntitiesList.size(); ++i) {
            TabulationFieldEntity tabulationFieldEntity = new TabulationFieldEntity();
            tabulationFieldEntity.setRuleId(ruleEntity.getRuleId());
            tabulationFieldEntity.setFieldId(((DataMonitorFieldEntity)fieldEntitiesList.get(i)).getFieldId());
            tabulationFieldEntity.setOrderNum(i);
            tabulationFieldEntities.add(tabulationFieldEntity);
        }
        this.tabulationFieldService.saveBatch(tabulationFieldEntities);
        List dicSingleList = this.sysDicRefService.getDictByType("monitor_target_table");
        String tableName = ((DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(dto.getTargetType())).collect(Collectors.toList()).get(0)).getLabel();
        StringBuffer tableReferredName = this.getInitialLettersLowerCase(tableName);
        List fieldEntities = this.dataMonitorFieldService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DataMonitorFieldEntity::getTargetType, (Object)dto.getTargetType())).eq(DataMonitorFieldEntity::getIsPrimaryKey, (Object)"1")).or()).in(DataMonitorFieldEntity::getFieldId, dto.getShowFields())).or()).eq(DataMonitorFieldEntity::getTargetType, (Object)dto.getTargetType())).eq(DataMonitorFieldEntity::getIsHidden, (Object)"1")).eq(DataMonitorFieldEntity::getIsDefault, (Object)"1"));
        StringBuffer querySQL = new StringBuffer("SELECT ");
        for (int i = 0; i < fieldEntities.size(); ++i) {
            String[] fromValue;
            if (i != 0) {
                querySQL.append(", ");
            }
            if (((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("recordContent")) {
                fromValue = ((DataMonitorFieldEntity)fieldEntities.get(i)).getDatasourceFromValue().split(",");
                querySQL.append("(SELECT RECORD_CONTENT FROM CRM_RECORD WHERE ").append(tableReferredName).append(".").append(fromValue[1]).append(" = TYPE_ID AND DEL_FLAG = '0' AND PRODUCE_TYPE = '1' ORDER BY CREATE_TIME DESC LIMIT 1) AS ").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
                continue;
            }
            if (((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("chargePerson") || ((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("changePersonName") || ((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("createPersonName") || ((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("createDepartmentName")) {
                fromValue = ((DataMonitorFieldEntity)fieldEntities.get(i)).getDatasourceFromValue().split(",");
                querySQL.append(tableReferredName).append(".").append(fromValue[0]).append(" AS ").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
                continue;
            }
            if (((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("ownDepartment")) {
                fromValue = ((DataMonitorFieldEntity)fieldEntities.get(i)).getDatasourceFromValue().split(",");
                querySQL.append(tableReferredName).append(".").append(fromValue[0]).append(" AS ").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
                querySQL.append(", ").append(tableReferredName).append(".").append("OWN_DEPARTMENT AS DEPARTMENT_ID");
                continue;
            }
            if (((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("customerStageId")) {
                querySQL.append("(SELECT COS.CUSTOMER_STAGE_NAME FROM CRM_OPPORTUNITY_STAGE COS WHERE COS.CUSTOMER_STAGE_ID = CO.CUSTOMER_STAGE_ID ) AS ").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
                continue;
            }
            if (((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("stageProcessId")) {
                querySQL.append("(SELECT CSP.PROCESS_NAME FROM CRM_STAGE_PROCESS CSP WHERE CSP.STAGE_PROCESS_ID = co.STAGE_PROCESS_ID) AS ").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
                continue;
            }
            if (((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("campaignName")) {
                fromValue = ((DataMonitorFieldEntity)fieldEntities.get(i)).getDatasourceFromValue().split(",");
                querySQL.append("(SELECT s.").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFuzzyMatchingField()).append(" FROM ").append(fromValue[0]).append(" s WHERE s.").append(fromValue[1]).append(" = ").append(tableReferredName).append(".").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName()).append(") AS ").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
                continue;
            }
            if (((DataMonitorFieldEntity)fieldEntities.get(i)).getTargetType().equals("2") && ((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("customerReferredName")) {
                querySQL.append("(SELECT CUSTOMER_REFERRED_NAME FROM CRM_CUSTOMER WHERE ").append(tableReferredName).append(".").append("CUSTOMER_ID").append(" = CUSTOMER_ID) AS ").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
                continue;
            }
            if (((DataMonitorFieldEntity)fieldEntities.get(i)).getTargetType().equals("2") && ((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldName().equals("agentName")) {
                fromValue = ((DataMonitorFieldEntity)fieldEntities.get(i)).getDatasourceFromValue().split(",");
                querySQL.append("(SELECT s.").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFuzzyMatchingField()).append(" FROM ").append(fromValue[0]).append(" s WHERE s.").append(fromValue[1]).append(" = ").append(tableReferredName).append(".").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName()).append(") AS ").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
                continue;
            }
            if ("3".equals(((DataMonitorFieldEntity)fieldEntities.get(i)).getConditionType()) && "1".equals(((DataMonitorFieldEntity)fieldEntities.get(i)).getDatasourceFromType())) {
                querySQL.append("(SELECT s.LABEL FROM SYS_DICT_SINGLE s LEFT JOIN SYS_DICT_TYPE t ON t.TYPE_ID = s.TYPE_ID WHERE s.VALUE = ").append(tableReferredName).append(".").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName()).append(" AND t.TYPE_NAME = '").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getDatasourceFromValue()).append("') AS ").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
                continue;
            }
            querySQL.append(tableReferredName).append(".").append(((DataMonitorFieldEntity)fieldEntities.get(i)).getFieldDatabaseName());
        }
        if ("17".equals(dto.getTargetType())) {
            querySQL.append(", ").append(tableReferredName).append(".").append("CHARGE_PERSON").append(" AS ").append("HIDDEN_CHARGE_PERSON_ID");
        } else {
            querySQL.append(", ").append(tableReferredName).append(".").append("CHARGE_PERSON_ID").append(" AS ").append("HIDDEN_CHARGE_PERSON_ID");
        }
        querySQL.append(" FROM ").append(tableName).append(" ").append(tableReferredName).append(" WHERE ");
        if ("2".equals(dto.getTargetType())) {
            querySQL.append("(").append(tableReferredName).append(".DEL_FLAG = '0' AND ").append(tableReferredName).append(".PROCESS_STATE = '1') AND ");
        } else {
            querySQL.append("(").append(tableReferredName).append(".DEL_FLAG = '0') AND ");
        }
        ConditionEntity condition = dto.getConditionRelationObject();
        ObjectMapper mapper = new ObjectMapper();
        try {
            ruleEntity.setConditionRelation(mapper.writeValueAsString((Object)condition));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<String, Object> configMap = this.analysisConditionRelationTree(condition);
        List conditionEntityList = (List)configMap.get("conditionList");
        StringBuffer equation = (StringBuffer)configMap.get("equation");
        for (ConditionEntity conditionEntity : conditionEntityList) {
            StringBuffer sql = this.generateSQL(conditionEntity, tableReferredName);
            int index = equation.indexOf(conditionEntity.getNodeId());
            if (index == -1) continue;
            int lengthToDelete = conditionEntity.getNodeId().length();
            equation.delete(index, index + lengthToDelete);
            equation.insert(index, sql);
        }
        querySQL.append(equation);
        ruleEntity.setRuleQuerySql(querySQL.toString());
        try {
            List<Map<String, Object>> list = this.dataMonitorRuleMapper.selectAbnormalDataList(querySQL.toString(), null);
        }
        catch (Exception e) {
            throw new HussarException("\u4fdd\u5b58\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u9879");
        }
        AbnormalPushScopeDto abnormalPushScopeDto = dto.getAbnormalPushScope();
        if (ToolUtil.isNotEmpty((Object)abnormalPushScopeDto)) {
            List<Map<String, Object>> list;
            List<Map<String, Object>> pushRoleMapList;
            List<Map<String, Object>> pushDeptMapList;
            ruleEntity.setPushText(abnormalPushScopeDto.getPushText());
            ArrayList<MessagePushDto> dtoList = new ArrayList<MessagePushDto>();
            List<Map<String, Object>> pushPersonMapList = abnormalPushScopeDto.getPersonList();
            if (ToolUtil.isNotEmpty(pushPersonMapList)) {
                for (Map<String, Object> map : pushPersonMapList) {
                    MessagePushDto messagePushDto = new MessagePushDto();
                    messagePushDto.setPushId(CommonUtills.generateAssignId());
                    messagePushDto.setTypeId(ruleEntity.getRuleId());
                    messagePushDto.setTemplateKey(ruleEntity.getRuleId().toString());
                    messagePushDto.setBusinessType("1");
                    messagePushDto.setBusinessId((String)map.get("userId"));
                    messagePushDto.setCreator(user.getUserId().toString());
                    messagePushDto.setCreateTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
                    messagePushDto.setLastEditor(user.getUserId().toString());
                    messagePushDto.setLastTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
                    messagePushDto.setBusinessName((String)map.get("userName"));
                    dtoList.add(messagePushDto);
                }
            }
            if (ToolUtil.isNotEmpty(pushDeptMapList = abnormalPushScopeDto.getDeptList())) {
                for (Map<String, Object> map : pushDeptMapList) {
                    MessagePushDto messagePushDto = new MessagePushDto();
                    messagePushDto.setPushId(CommonUtills.generateAssignId());
                    messagePushDto.setTypeId(ruleEntity.getRuleId());
                    messagePushDto.setTemplateKey(ruleEntity.getRuleId().toString());
                    messagePushDto.setBusinessType("2");
                    messagePushDto.setBusinessId((String)map.get("organId"));
                    messagePushDto.setCreator(user.getUserId().toString());
                    messagePushDto.setCreateTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
                    messagePushDto.setLastEditor(user.getUserId().toString());
                    messagePushDto.setLastTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
                    messagePushDto.setBusinessName((String)map.get("organName"));
                    dtoList.add(messagePushDto);
                }
            }
            if (ToolUtil.isNotEmpty(pushRoleMapList = abnormalPushScopeDto.getRoleList())) {
                for (Map<String, Object> map : pushRoleMapList) {
                    MessagePushDto messagePushDto = new MessagePushDto();
                    messagePushDto.setPushId(CommonUtills.generateAssignId());
                    messagePushDto.setTypeId(ruleEntity.getRuleId());
                    messagePushDto.setTemplateKey(ruleEntity.getRuleId().toString());
                    messagePushDto.setBusinessType("3");
                    messagePushDto.setBusinessId((String)map.get("roleId"));
                    messagePushDto.setCreator(user.getUserId().toString());
                    messagePushDto.setCreateTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
                    messagePushDto.setLastEditor(user.getUserId().toString());
                    messagePushDto.setLastTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
                    messagePushDto.setBusinessName((String)map.get("roleName"));
                    dtoList.add(messagePushDto);
                }
            }
            if (ToolUtil.isNotEmpty(list = abnormalPushScopeDto.getRoleEnum())) {
                for (Map<String, Object> map : list) {
                    MessagePushDto messagePushDto = new MessagePushDto();
                    messagePushDto.setPushId(CommonUtills.generateAssignId());
                    messagePushDto.setTypeId(ruleEntity.getRuleId());
                    messagePushDto.setTemplateKey(ruleEntity.getRuleId().toString());
                    messagePushDto.setBusinessType((String)map.get("value"));
                    messagePushDto.setCreator(user.getUserId().toString());
                    messagePushDto.setCreateTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
                    messagePushDto.setLastEditor(user.getUserId().toString());
                    messagePushDto.setLastTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
                    messagePushDto.setBusinessName((String)map.get("label"));
                    dtoList.add(messagePushDto);
                }
            }
            if (ToolUtil.isNotEmpty(dtoList)) {
                this.messagePushService.insertMessagePushBatch(dtoList);
            }
            if (ToolUtil.isNotEmpty(dtoList)) {
                ArrayList arrayList = new ArrayList();
                MessageTemplateDto messageTemplateDto = new MessageTemplateDto();
                MessageTemplateDto mobileDto = new MessageTemplateDto();
                messageTemplateDto.setTemplateKey(ruleEntity.getRuleId().toString());
                messageTemplateDto.setModuleId(ruleEntity.getTargetType());
                messageTemplateDto.setMessageContent(dto.getPushTextWebContent());
                messageTemplateDto.setPushDirection("1");
                mobileDto.setTemplateKey(ruleEntity.getRuleId().toString());
                mobileDto.setModuleId(ruleEntity.getTargetType());
                mobileDto.setMessageContent(dto.getPushTextMobileContent());
                mobileDto.setMessageTitle(dto.getPushTextMobileTitle());
                mobileDto.setPushDirection("2");
                List<MessageTemplateDto> list2 = Arrays.asList(messageTemplateDto, mobileDto);
                this.messageTemplateService.addMessageTemplateBatch(list2);
            }
        }
        LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
        if (ToolUtil.isNotEmpty((Object)ruleEntity) && ruleEntity.getIgnoreFlag().equals("0")) {
            ruleEntity.setIgnoreCycle(null);
            updateWrapper.eq(DataMonitorRuleEntity::getRuleId, (Object)ruleEntity.getRuleId());
            updateWrapper.set(DataMonitorRuleEntity::getIgnoreCycle, null);
            this.saveOrUpdate(ruleEntity, (Wrapper)updateWrapper);
        } else {
            this.saveOrUpdate(ruleEntity);
        }
        return true;
    }

    public StringBuffer getInitialLettersLowerCase(String input) {
        String[] parts = input.split("_");
        StringBuffer sb = new StringBuffer();
        for (String part : parts) {
            if (part.length() <= 0) continue;
            sb.append(Character.toLowerCase(part.charAt(0)));
        }
        return sb;
    }

    public Map<String, Object> analysisConditionRelationTree(ConditionEntity rootCondition) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<ConditionEntity> conditionEntityList = new ArrayList<ConditionEntity>();
        LinkedList<ConditionEntity> queue = new LinkedList<ConditionEntity>();
        queue.offer(rootCondition);
        while (!queue.isEmpty()) {
            ConditionEntity conditionEntity = (ConditionEntity)queue.poll();
            if (ToolUtil.isNotEmpty((Object)conditionEntity.getFieldId())) {
                conditionEntity.setNodeId(CommonUtills.generateAssignId());
                conditionEntityList.add(conditionEntity);
            }
            if (!ToolUtil.isNotEmpty(conditionEntity.getChildren())) continue;
            for (ConditionEntity child : conditionEntity.getChildren()) {
                queue.offer(child);
            }
        }
        resultMap.put("conditionList", conditionEntityList);
        StringBuffer equation = new StringBuffer();
        equation = this.conditionTreeDP(rootCondition, equation);
        resultMap.put("equation", equation);
        return resultMap;
    }

    private StringBuffer conditionTreeDP(ConditionEntity condition, StringBuffer equation) {
        equation.append("(");
        for (ConditionEntity child : condition.getChildren()) {
            equation = this.conditionTreeDP(child, equation);
        }
        if (ToolUtil.isNotEmpty((Object)condition.getFieldId())) {
            equation.append(condition.getNodeId());
        }
        equation.append(")");
        if (ToolUtil.isNotEmpty((Object)condition.getRelation())) {
            equation.append(condition.getRelation());
        }
        return equation;
    }

    private StringBuffer generateSQL(ConditionEntity condition, StringBuffer tableReferredName) {
        StringBuffer sqlStr;
        block220: {
            DataMonitorFieldEntity dataMonitorFieldEntity;
            block219: {
                dataMonitorFieldEntity = (DataMonitorFieldEntity)this.dataMonitorFieldService.getOne((Wrapper)new LambdaQueryWrapper().eq(DataMonitorFieldEntity::getFieldId, (Object)Long.parseLong(condition.getFieldId())));
                sqlStr = new StringBuffer();
                if (!dataMonitorFieldEntity.getFieldType().equals("1")) break block219;
                List dicSingleList = new ArrayList();
                DicSingle dicSingle = new DicSingle();
                block9 : switch (dataMonitorFieldEntity.getConditionType()) {
                    case "1": {
                        dicSingleList = this.sysDicRefService.getDictByType("numerical_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append(condition.getValue1());
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" != ").append(condition.getValue1());
                                break block9;
                            }
                            case "3": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" > ").append(condition.getValue1());
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" < ").append(condition.getValue1());
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" >= ").append(condition.getValue1());
                                break block9;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" <= ").append(condition.getValue1());
                                break block9;
                            }
                            case "7": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "8": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                            case "9": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" >= ").append(condition.getValue1()).append(" AND ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" <= ").append(condition.getValue2());
                                break block9;
                            }
                        }
                        break;
                    }
                    case "2": {
                        dicSingleList = this.sysDicRefService.getDictByType("text_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        StringBuffer fieldStr = new StringBuffer("");
                        if (dataMonitorFieldEntity.getFieldName().equals("recordContent")) {
                            Object fromValue = dataMonitorFieldEntity.getDatasourceFromValue().split(",");
                            fieldStr.append("(SELECT RECORD_CONTENT FROM CRM_RECORD WHERE ").append(tableReferredName).append(".").append(fromValue[1]).append(" = TYPE_ID AND DEL_FLAG = '0' AND PRODUCE_TYPE = '1' ORDER BY CREATE_TIME DESC LIMIT 1)");
                        } else if (dataMonitorFieldEntity.getTargetType().equals("2") && dataMonitorFieldEntity.getFieldName().equals("customerReferredName")) {
                            fieldStr.append("(SELECT CUSTOMER_REFERRED_NAME FROM CRM_CUSTOMER WHERE ").append(tableReferredName).append(".").append("CUSTOMER_ID").append(" = CUSTOMER_ID)");
                        } else {
                            fieldStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName());
                        }
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(fieldStr).append(" = '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(fieldStr).append(" != '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "3": {
                                sqlStr.append(fieldStr).append(" LIKE '%").append(condition.getValue1()).append("%'");
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(fieldStr).append(" IS NOT NULL AND ").append(fieldStr).append(" != ''");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(fieldStr).append(" IS NULL OR ").append(fieldStr).append(" = ''");
                                break block9;
                            }
                            case "6": {
                                String regexpStrMatch = "";
                                if (condition.getValue1() != null && condition.getValue1().length() >= 2) {
                                    regexpStrMatch = condition.getValue1().substring(1, condition.getValue1().length() - 1);
                                }
                                sqlStr.append(fieldStr).append(" REGEXP '").append(regexpStrMatch).append("'");
                                break block9;
                            }
                            case "7": {
                                String regexpStr = "";
                                if (condition.getValue1() != null && condition.getValue1().length() >= 2) {
                                    regexpStr = condition.getValue1().substring(1, condition.getValue1().length() - 1);
                                }
                                sqlStr.append(fieldStr).append(" NOT REGEXP '").append(regexpStr).append("'");
                                break block9;
                            }
                        }
                        break;
                    }
                    case "3": {
                        dicSingleList = this.sysDicRefService.getDictByType("enum_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                if (dataMonitorFieldEntity.getFieldName().equals("customerStageId")) {
                                    sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IN (SELECT CUSTOMER_STAGE_ID FROM CRM_OPPORTUNITY_STAGE WHERE STAGE_NAME_VALUE = '").append(condition.getValue1()).append("')");
                                    break;
                                }
                                if (dataMonitorFieldEntity.getFieldName().equals("dealStates")) {
                                    sqlStr.append(tableReferredName).append(".").append("CUSTOMER_ID ").append(" IN (select win.CUSTOMER_ID from( SELECT (case when COUNT(OPPORTUNITY_ID) = 0 then 1 when COUNT(OPPORTUNITY_ID) = 1 then 2 else 3 end )winAmount, cc1.CUSTOMER_ID FROM crm_customer cc1 left join CRM_OPPORTUNITY CO on co.customer_id = cc1.customer_id and CO.DEL_FLAG = '0' LEFT JOIN CRM_OPPORTUNITY_STAGE COS ON COS.CUSTOMER_STAGE_ID = CO.CUSTOMER_STAGE_ID AND COS.STAGE_TYPE = '20' GROUP BY cc1.CUSTOMER_ID) win where win.winAmount = '").append(condition.getValue1()).append("')");
                                    break;
                                }
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = '").append(condition.getValue1()).append("'");
                                break;
                            }
                            case "2": {
                                if (dataMonitorFieldEntity.getFieldName().equals("customerStageId")) {
                                    sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" NOT IN (SELECT CUSTOMER_STAGE_ID FROM CRM_OPPORTUNITY_STAGE WHERE STAGE_NAME_VALUE = '").append(condition.getValue1()).append("')");
                                    break;
                                }
                                if (dataMonitorFieldEntity.getFieldName().equals("dealStates")) {
                                    sqlStr.append(tableReferredName).append(".").append("CUSTOMER_ID ").append(" IN (select win.CUSTOMER_ID from( SELECT (case when COUNT(OPPORTUNITY_ID) = 0 then 1 when COUNT(OPPORTUNITY_ID) = 1 then 2 else 3 end )winAmount, cc1.CUSTOMER_ID FROM crm_customer cc1 left join CRM_OPPORTUNITY CO on co.customer_id = cc1.customer_id and CO.DEL_FLAG = '0' LEFT JOIN CRM_OPPORTUNITY_STAGE COS ON COS.CUSTOMER_STAGE_ID = CO.CUSTOMER_STAGE_ID AND COS.STAGE_TYPE = '20' GROUP BY cc1.CUSTOMER_ID) win where win.winAmount != '").append(condition.getValue1()).append("')");
                                    break;
                                }
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" != '").append(condition.getValue1()).append("'");
                                break;
                            }
                            case "3": {
                                if (dataMonitorFieldEntity.getFieldName().equals("customerStageId")) {
                                    List enumIdList = Arrays.stream(condition.getValue1().split(",")).collect(Collectors.toList());
                                    String enumId = enumIdList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
                                    sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IN (SELECT CUSTOMER_STAGE_ID FROM CRM_OPPORTUNITY_STAGE WHERE STAGE_NAME_VALUE IN (").append(enumId).append("))");
                                    break;
                                }
                                if (dataMonitorFieldEntity.getFieldName().equals("dealStates")) {
                                    sqlStr.append(tableReferredName).append(".").append("CUSTOMER_ID").append(" IN (select win.CUSTOMER_ID from( SELECT (case when COUNT(OPPORTUNITY_ID) = 0 then 1 when COUNT(OPPORTUNITY_ID) = 1 then 2 else 3 end )winAmount, cc1.CUSTOMER_ID FROM crm_customer cc1 left join CRM_OPPORTUNITY CO on co.customer_id = cc1.customer_id and CO.DEL_FLAG = '0' LEFT JOIN CRM_OPPORTUNITY_STAGE COS ON COS.CUSTOMER_STAGE_ID = CO.CUSTOMER_STAGE_ID AND COS.STAGE_TYPE = '20' GROUP BY cc1.CUSTOMER_ID) win where win.winAmount IN (").append(condition.getValue1()).append("))");
                                    break;
                                }
                                List enumIdList = Arrays.stream(condition.getValue1().split(",")).collect(Collectors.toList());
                                for (int i = 0; i < enumIdList.size(); ++i) {
                                    if (i != 0) {
                                        sqlStr.append(" OR ");
                                    }
                                    sqlStr.append("INSTR(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '").append((String)enumIdList.get(i)).append("') > 0");
                                }
                                break block220;
                            }
                            case "4": {
                                if (dataMonitorFieldEntity.getFieldName().equals("customerStageId")) {
                                    List enumIdList = Arrays.stream(condition.getValue1().split(",")).collect(Collectors.toList());
                                    String enumId = enumIdList.stream().map(s -> "'" + s + "'").collect(Collectors.joining(","));
                                    sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" NOT IN (SELECT CUSTOMER_STAGE_ID FROM CRM_OPPORTUNITY_STAGE WHERE STAGE_NAME_VALUE IN (").append(enumId).append("))");
                                    break;
                                }
                                if (dataMonitorFieldEntity.getFieldName().equals("dealStates")) {
                                    sqlStr.append(tableReferredName).append(".").append("CUSTOMER_ID").append(" IN (select win.CUSTOMER_ID from( SELECT (case when COUNT(OPPORTUNITY_ID) = 0 then 1 when COUNT(OPPORTUNITY_ID) = 1 then 2 else 3 end )winAmount, cc1.CUSTOMER_ID FROM crm_customer cc1 left join CRM_OPPORTUNITY CO on co.customer_id = cc1.customer_id and CO.DEL_FLAG = '0' LEFT JOIN CRM_OPPORTUNITY_STAGE COS ON COS.CUSTOMER_STAGE_ID = CO.CUSTOMER_STAGE_ID AND COS.STAGE_TYPE = '20' GROUP BY cc1.CUSTOMER_ID) win where win.winAmount NOT IN (").append(condition.getValue1()).append("))");
                                    break;
                                }
                                List enumIds = Arrays.stream(condition.getValue1().split(",")).collect(Collectors.toList());
                                for (int i = 0; i < enumIds.size(); ++i) {
                                    if (i != 0) {
                                        sqlStr.append(" AND ");
                                    }
                                    sqlStr.append("INSTR(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '").append((String)enumIds.get(i)).append("') = 0");
                                }
                                break block220;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL AND ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" != ''");
                                break;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NULL OR ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ''");
                                break;
                            }
                        }
                        break block220;
                    }
                    case "4": {
                        dicSingleList = this.sysDicRefService.getDictByType("time_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        LocalDateTime time1 = null;
                        LocalDateTime time2 = null;
                        switch (dicSingle.getValue()) {
                            case "1": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" = ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "2": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" != ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "3": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" > ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "4": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" < ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                            case "7": {
                                time1 = LocalDateTime.parse(condition.getValue1());
                                String timeStr1 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time1);
                                time2 = LocalDateTime.parse(condition.getValue2());
                                String timeStr2 = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(time2);
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" >= ").append("STR_TO_DATE('").append(timeStr1).append("', '%Y-%m-%d')").append(" AND ").append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" <= ").append("STR_TO_DATE('").append(timeStr2).append("', '%Y-%m-%d')");
                                break block9;
                            }
                            case "8": {
                                if (Arrays.asList("successDate", "endTime").contains(dataMonitorFieldEntity.getFieldName())) {
                                    int beforeDays = Integer.parseInt(condition.getValue1());
                                    String timeStr1 = "NOW() - INTERVAL '" + beforeDays + "' day";
                                    sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" < ").append("DATE_FORMAT(").append(timeStr1).append(", '%Y-%m-%d')");
                                    break block9;
                                }
                                int beforeDays = Integer.parseInt(condition.getValue1());
                                String timeStr1 = "NOW() - INTERVAL '" + beforeDays + "' day";
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d %H:%i:%s'), '%Y-%m-%d %H:%i:%s')").append(" < ").append("DATE_FORMAT(").append(timeStr1).append(", '%Y-%m-%d %H:%i:%s')");
                                break block9;
                            }
                            case "9": {
                                if (Arrays.asList("successDate", "endTime").contains(dataMonitorFieldEntity.getFieldName())) {
                                    int afterDays = Integer.parseInt(condition.getValue1());
                                    String timeStr1 = "NOW() + INTERVAL '" + afterDays + "' day";
                                    sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d'), '%Y-%m-%d')").append(" > ").append("DATE_FORMAT(").append(timeStr1).append(", '%Y-%m-%d')");
                                    break block9;
                                }
                                int afterDays = Integer.parseInt(condition.getValue1());
                                String timeStr1 = "NOW() + INTERVAL '" + afterDays + "' day";
                                sqlStr.append("STR_TO_DATE(DATE_FORMAT(").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(", '%Y-%m-%d %H:%i:%s'), '%Y-%m-%d %H:%i:%s')").append(" > ").append("DATE_FORMAT(").append(timeStr1).append(", '%Y-%m-%d %H:%i:%s')");
                                break block9;
                            }
                        }
                        break;
                    }
                    case "5": {
                        dicSingleList = this.sysDicRefService.getDictByType("dept_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" != '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "3": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IN (").append(condition.getValue1()).append(")");
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" NOT IN (").append(condition.getValue1()).append(")");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                            case "7": {
                                if ("ownDepartment".equals(dataMonitorFieldEntity.getFieldName())) {
                                    sqlStr.append("((select COUNT(*) FROM SYS_STRU WHERE STRU_ID = ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" AND DEL_FLAG = '0') = 0").append(" OR (select count(*) from SYS_STRU WHERE ORGAN_ALIAS = ").append(tableReferredName).append(".OWN_DEPARTMENT_NAME").append(" AND DEL_FLAG = '0'").append(")").append(")");
                                    break block9;
                                }
                                if ("createDepartmentName".equals(dataMonitorFieldEntity.getFieldName())) {
                                    sqlStr.append("((select COUNT(*) FROM SYS_STRU WHERE STRU_ID = ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" AND DEL_FLAG = '0') = 0").append(" OR (select count(*) from SYS_STRU WHERE ORGAN_ALIAS = ").append(tableReferredName).append(".CREATE_DEPARTMENT_NAME").append(" AND DEL_FLAG = '0'").append(")").append(")");
                                    break block9;
                                }
                                sqlStr.append("(select COUNT(*) FROM SYS_STRU WHERE STRU_ID = ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" AND DEL_FLAG = '0') = 0");
                                break block9;
                            }
                            case "8": {
                                String str = dataMonitorFieldEntity.getTargetType().equals("17") ? "CHARGE_PERSON" : "CHARGE_PERSON_ID";
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" NOT IN (select STRU_ID FROM SYS_STRU_USER WHERE ").append(tableReferredName).append(".").append(str).append(" = USER_ID)");
                                break block9;
                            }
                        }
                        break;
                    }
                    case "6": {
                        dicSingleList = this.sysDicRefService.getDictByType("user_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" != '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "3": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IN (").append(condition.getValue1()).append(")");
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" NOT IN (").append(condition.getValue1()).append(")");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "6": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                            case "7": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IN (SELECT USER_ID FROM SYS_STRU_USER WHERE STRU_ID IN (").append(condition.getValue1()).append("))");
                                break block9;
                            }
                            case "8": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IN (SELECT USER_ID FROM SYS_STRU_USER ssu LEFT JOIN SYS_STRU ss ON ssu.STRU_ID = ss.STRU_ID WHERE ss.ORGAN_ALIAS = '\u79bb\u804c\u4eba\u5458' OR ss.STRU_ID = 100122)");
                                break block9;
                            }
                        }
                        break;
                    }
                    case "7": {
                        dicSingleList = this.sysDicRefService.getDictByType("relation_field_condition");
                        dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                        switch (dicSingle.getValue()) {
                            case "1": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "2": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" != '").append(condition.getValue1()).append("'");
                                break block9;
                            }
                            case "3": {
                                List wordlist = Arrays.stream(dataMonitorFieldEntity.getDatasourceFromValue().split(",")).collect(Collectors.toList());
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IN (SELECT ").append((String)wordlist.get(1)).append(" FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(dataMonitorFieldEntity.getFuzzyMatchingField()).append(" LIKE '%").append(condition.getValue2()).append("%')");
                                break block9;
                            }
                            case "4": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NOT NULL");
                                break block9;
                            }
                            case "5": {
                                sqlStr.append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" IS NULL");
                                break block9;
                            }
                        }
                        break;
                    }
                }
                break block220;
            }
            if (dataMonitorFieldEntity.getFieldType().equals("2")) {
                List dicSingleList = this.sysDicRefService.getDictByType("numerical_field_condition");
                DicSingle dicSingle = (DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(condition.getMatch())).collect(Collectors.toList()).get(0);
                List wordlist = Arrays.stream(dataMonitorFieldEntity.getDatasourceFromValue().split(",")).collect(Collectors.toList());
                StringBuffer queryStr = new StringBuffer();
                if (!dataMonitorFieldEntity.getDatasourceFromType().equals("10")) {
                    queryStr.append(" AND DEL_FLAG = '0')");
                    switch (dicSingle.getValue()) {
                        case "1": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" = ").append(condition.getValue1());
                            break;
                        }
                        case "2": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" != ").append(condition.getValue1());
                            break;
                        }
                        case "3": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" > ").append(condition.getValue1());
                            break;
                        }
                        case "4": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" < ").append(condition.getValue1());
                            break;
                        }
                        case "5": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" >= ").append(condition.getValue1());
                            break;
                        }
                        case "6": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" <= ").append(condition.getValue1());
                            break;
                        }
                        case "7": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" > 0");
                            break;
                        }
                        case "8": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" = 0");
                            break;
                        }
                        case "9": {
                            sqlStr.append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" >= ").append(condition.getValue1()).append(" AND ").append("(SELECT COUNT(*) FROM ").append((String)wordlist.get(0)).append(" WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" <= ").append(condition.getValue2());
                            break;
                        }
                    }
                } else {
                    queryStr.append(" AND DEL_FLAG = '0')");
                    switch (dicSingle.getValue()) {
                        case "1": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" = ").append(condition.getValue1());
                            break;
                        }
                        case "2": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" != ").append(condition.getValue1());
                            break;
                        }
                        case "3": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" > ").append(condition.getValue1());
                            break;
                        }
                        case "4": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" < ").append(condition.getValue1());
                            break;
                        }
                        case "5": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" >= ").append(condition.getValue1());
                            break;
                        }
                        case "6": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" <= ").append(condition.getValue1());
                            break;
                        }
                        case "7": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" > 0");
                            break;
                        }
                        case "8": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" = 0");
                            break;
                        }
                        case "9": {
                            sqlStr.append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" >= ").append(condition.getValue1()).append(" AND ").append("(SELECT COUNT(*) FROM CRM_RECORD_RELATION  WHERE ").append(tableReferredName).append(".").append(dataMonitorFieldEntity.getFieldDatabaseName()).append(" = ").append((String)wordlist.get(1)).append(queryStr).append(" <= ").append(condition.getValue2());
                            break;
                        }
                    }
                }
            }
        }
        return sqlStr;
    }

    @Override
    public DataMonitorRuleVo viewMonitorRuleConfig(Long ruleId) {
        DataMonitorRuleEntity dataMonitorRuleEntity = (DataMonitorRuleEntity)this.getOne((Wrapper)new LambdaQueryWrapper().eq(DataMonitorRuleEntity::getRuleId, (Object)ruleId));
        DataMonitorRuleVo dataMonitorRuleVo = (DataMonitorRuleVo)BeanUtil.copy((Object)dataMonitorRuleEntity, DataMonitorRuleVo.class);
        List tabulationFieldEntities = this.tabulationFieldService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TabulationFieldEntity::getRuleId, (Object)ruleId)).orderByAsc(TabulationFieldEntity::getOrderNum));
        dataMonitorRuleVo.setShowFields(tabulationFieldEntities.stream().map(TabulationFieldEntity::getFieldId).collect(Collectors.toList()));
        AbnormalPushScopeDto abnormalPushScopeDto = new AbnormalPushScopeDto();
        ArrayList messagePushVoList = this.messageTemplateService.getMessagePushList(ruleId.toString());
        ArrayList messagePushVoList2 = new ArrayList(messagePushVoList);
        if (ToolUtil.isNotEmpty((Object)messagePushVoList)) {
            Map uniqueMap = messagePushVoList.stream().collect(Collectors.toMap(MessagePushVo::getPushId, Function.identity(), (existing, replacement) -> existing, LinkedHashMap::new));
            messagePushVoList = new ArrayList(uniqueMap.values());
            List<Object> personList = new ArrayList();
            List<Object> deptList = new ArrayList();
            List<Object> roleList = new ArrayList();
            ArrayList<Object> enumList = new ArrayList();
            personList = messagePushVoList.stream().filter(MessagePushVo2 -> MessagePushVo2.getBusinessType().equals("1")).collect(Collectors.toList());
            deptList = messagePushVoList.stream().filter(MessagePushVo2 -> MessagePushVo2.getBusinessType().equals("2")).collect(Collectors.toList());
            roleList = messagePushVoList.stream().filter(MessagePushVo2 -> MessagePushVo2.getBusinessType().equals("3")).collect(Collectors.toList());
            messagePushVoList.removeAll(personList);
            messagePushVoList.removeAll(deptList);
            messagePushVoList.removeAll(roleList);
            enumList = messagePushVoList;
            ArrayList<Map<String, Object>> personMapList = new ArrayList<Map<String, Object>>();
            for (Object pushEntity : personList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", pushEntity.getBusinessId());
                map.put("userName", pushEntity.getBusinessName());
                personMapList.add(map);
            }
            abnormalPushScopeDto.setPersonList(personMapList);
            ArrayList<Map<String, Object>> deptMapList = new ArrayList<Map<String, Object>>();
            for (Object pushEntity : deptList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("organId", pushEntity.getBusinessId());
                map.put("organName", pushEntity.getBusinessName());
                deptMapList.add(map);
            }
            abnormalPushScopeDto.setDeptList(deptMapList);
            ArrayList<Map<String, Object>> roleMapList = new ArrayList<Map<String, Object>>();
            for (Object pushEntity : roleList) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("roleId", pushEntity.getBusinessId());
                hashMap.put("roleName", pushEntity.getBusinessName());
                roleMapList.add(hashMap);
            }
            abnormalPushScopeDto.setRoleList(roleMapList);
            ArrayList<Map<String, Object>> enumMapList = new ArrayList<Map<String, Object>>();
            for (MessagePushVo messagePushVo : enumList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("label", messagePushVo.getBusinessName());
                map.put("value", messagePushVo.getBusinessType());
                enumMapList.add(map);
            }
            abnormalPushScopeDto.setRoleEnum(enumMapList);
            abnormalPushScopeDto.setPushText(dataMonitorRuleEntity.getPushText());
            dataMonitorRuleVo.setAbnormalPushScope(abnormalPushScopeDto);
            MessagePushVo pushVo = (MessagePushVo)messagePushVoList2.stream().filter(vo -> vo.getPushDirection().equals("1")).collect(Collectors.toList()).get(0);
            dataMonitorRuleVo.setPushTextWebContent(pushVo.getMessageContent());
            pushVo = (MessagePushVo)messagePushVoList2.stream().filter(vo -> vo.getPushDirection().equals("2")).collect(Collectors.toList()).get(0);
            dataMonitorRuleVo.setPushTextMobileContent(pushVo.getMessageContent());
            dataMonitorRuleVo.setPushTextMobileTitle(pushVo.getMessageTitle());
        }
        return dataMonitorRuleVo;
    }

    @Override
    public Page<DataMonitorRuleVo> selectMonitorRuleList(DataMonitorRuleDto dto) {
        Page page = dto.getPage();
        List<DataMonitorRuleVo> list = this.dataMonitorRuleMapper.selectDataMonitorRuleList(dto, (Page<DataMonitorRuleVo>)page);
        page.setRecords(list);
        return page;
    }

    @Override
    public Boolean updateMonitorRuleState(DataMonitorRuleDto dto) {
        DataMonitorRuleEntity dataMonitorRuleEntity = (DataMonitorRuleEntity)BeanUtil.copy((Object)((Object)dto), DataMonitorRuleEntity.class);
        return this.updateById(dataMonitorRuleEntity);
    }

    @Override
    public Boolean deleteMonitorRuleByRuleId(List<String> ruleIdList) {
        return this.removeByIds(ruleIdList);
    }

    @Override
    public Boolean sortMonitorRule(List<DataMonitorRuleDto> ruleList) {
        ArrayList<DataMonitorRuleEntity> dataMonitorRuleEntities = new ArrayList<DataMonitorRuleEntity>();
        for (int i = 0; i < ruleList.size(); ++i) {
            DataMonitorRuleEntity dataMonitorRuleEntity = new DataMonitorRuleEntity();
            dataMonitorRuleEntity.setRuleId(ruleList.get(i).getRuleId());
            dataMonitorRuleEntity.setOrderNum(i);
            dataMonitorRuleEntities.add(dataMonitorRuleEntity);
        }
        return this.saveOrUpdateBatch(dataMonitorRuleEntities);
    }

    @Override
    public Page<Map<String, Object>> getAbnormalDataList(DataMonitorRuleDto dto) {
        List<Object> abnormalDataList = new ArrayList();
        Page page = new Page();
        page.setSize(dto.getPage().getSize());
        page.setCurrent(dto.getPage().getCurrent());
        DataMonitorRuleEntity dataMonitorRuleEntity = (DataMonitorRuleEntity)this.getById(dto.getRuleId());
        List<Long> ruleIdList = Arrays.asList(dto.getRuleId());
        List<DataMonitorRuleVo> list = this.getPermissionSQLRuleList(ruleIdList);
        list = this.getExcludeIgnoreDataSQL(list);
        dataMonitorRuleEntity.setRuleQuerySql(list.get(0).getRuleQuerySql());
        if (ToolUtil.isNotEmpty((Object)dataMonitorRuleEntity)) {
            String queryParams = this.getQueryParamsSQL(dataMonitorRuleEntity, dto).toString();
            dataMonitorRuleEntity.setRuleQuerySql(dataMonitorRuleEntity.getRuleQuerySql() + queryParams);
            abnormalDataList = this.dataMonitorRuleMapper.selectAbnormalDataList(dataMonitorRuleEntity.getRuleQuerySql(), (Page<Map<String, Object>>)page);
            for (Object map : abnormalDataList) {
                map.put("ownDepartment", map.get("DEPARTMENT_ID"));
            }
            boolean labelFlag = false;
            for (Object map : abnormalDataList) {
                if (!map.containsKey("LABEL_ID")) continue;
                labelFlag = true;
            }
            if (ToolUtil.isNotEmpty(abnormalDataList) && labelFlag) {
                List labelList = new ArrayList();
                switch (dto.getTargetType()) {
                    case "2": {
                        labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.OPPORTUNITY.getModuleId());
                        break;
                    }
                    case "1": {
                        labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.CUSTOMER.getModuleId());
                        break;
                    }
                    case "4": {
                        labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.LEAD.getModuleId());
                        break;
                    }
                    case "17": {
                        labelList = this.labelService.getLabelListForUserByModule(LabelModuleEnum.AGENT.getModuleId());
                        break;
                    }
                }
                ArrayList finalLabelList = labelList;
                abnormalDataList.forEach(business -> {
                    if (business.containsKey("LABEL_ID")) {
                        business.put("LABEL_ID", CrmLabelUtil.getLabelName((List)finalLabelList, (String)((String)business.get("LABEL_ID"))));
                    }
                });
            }
            for (Object map : abnormalDataList) {
                if (map.containsKey("MOBILE_PHONE")) {
                    map.put("MOBILE_PHONE", CrmStringUtils.mobilePhoneDesensitization((String)((String)map.get("MOBILE_PHONE"))));
                }
                if (!map.containsKey("TELEPHONE")) continue;
                map.put("TELEPHONE", CrmStringUtils.telePhoneDesensitization((String)((String)map.get("TELEPHONE"))));
            }
            page.setRecords(abnormalDataList);
        }
        return page;
    }

    @Override
    public List<Map<String, Object>> getAbnormalDataCount(List<String> ruleIdList) {
        List<Long> ruleList = ruleIdList.stream().map(Long::parseLong).collect(Collectors.toList());
        List<Map<String, Object>> abnormalDataCountList = new ArrayList<Map<String, Object>>();
        if (ToolUtil.isNotEmpty(ruleList)) {
            abnormalDataCountList = this.dataMonitorRuleMapper.selectAbnormalDataCountByRuleList(this.getExcludeIgnoreDataSQL(this.getPermissionSQLRuleList(ruleList)));
            for (Map<String, Object> map : abnormalDataCountList) {
                map.put("abnormalDataCount", map.get("ABNORMAL_DATA_COUNT"));
                map.put("ruleId", map.get("RULE_ID"));
            }
        }
        return abnormalDataCountList;
    }

    @Override
    public List<Map<String, Object>> getProvinceAbnormalCount(DataMonitorRuleDto dto) {
        List departmentIdList;
        List departmentInfos;
        DataMonitorRuleEntity dataMonitorRuleEntity = (DataMonitorRuleEntity)this.getById(dto.getRuleId());
        List<Long> ruleIdList = Arrays.asList(dto.getRuleId());
        List<DataMonitorRuleVo> list = this.getPermissionSQLRuleList(ruleIdList);
        list = this.getExcludeIgnoreDataSQL(list);
        dataMonitorRuleEntity.setRuleQuerySql(list.get(0).getRuleQuerySql());
        if (ToolUtil.isNotEmpty((Object)dataMonitorRuleEntity)) {
            String queryParams = this.getQueryParamsSQL(dataMonitorRuleEntity, dto).toString();
            dataMonitorRuleEntity.setRuleQuerySql(dataMonitorRuleEntity.getRuleQuerySql() + queryParams);
        }
        List<Map<String, Object>> abnormalDataCountList = this.dataMonitorRuleMapper.selectProvinceAbnormalDataCount(dataMonitorRuleEntity);
        List<Map<String, Object>> businessDepartmentList = this.dataMonitorRuleMapper.selectOwnDepartment();
        if (ToolUtil.isNotEmpty(abnormalDataCountList) && ToolUtil.isNotEmpty((Object)(departmentInfos = this.commonMapper.getNameListByStruIdList(departmentIdList = abnormalDataCountList.stream().map(map -> (Long)map.get("OWN_DEPARTMENT")).collect(Collectors.toList()))))) {
            for (Map<String, Object> map2 : abnormalDataCountList) {
                String department = "#";
                List departmentNameList = departmentInfos.stream().filter(departInfo -> ((Long)departInfo.get("DEPARTMENT")).equals((Long)map2.get("OWN_DEPARTMENT"))).collect(Collectors.toList());
                if (ToolUtil.isNotEmpty(departmentNameList)) {
                    department = (String)((Map)departmentNameList.get(0)).get("DEPARTMENT_NAME");
                } else if (ToolUtil.isNotEmpty((Object)map2.get("OWN_DEPARTMENT")) && ToolUtil.isNotEmpty(departmentNameList = businessDepartmentList.stream().filter(businessDepartment -> ToolUtil.isNotEmpty(businessDepartment.get("OWN_DEPARTMENT")) && ((Long)businessDepartment.get("OWN_DEPARTMENT")).equals((Long)map2.get("OWN_DEPARTMENT"))).collect(Collectors.toList()))) {
                    department = (String)((Map)departmentNameList.get(0)).get("OWN_DEPARTMENT_NAME");
                }
                map2.put("ownDepartmentName", department);
            }
        }
        for (Map<String, Object> map3 : abnormalDataCountList) {
            map3.put("abnormalDataCount", map3.get("ABNORMAL_DATA_COUNT"));
            map3.put("ruleId", map3.get("RULE_ID"));
            map3.put("ownDepartment", map3.get("OWN_DEPARTMENT"));
        }
        return abnormalDataCountList;
    }

    private List<DataMonitorRuleVo> getPermissionSQLRuleList(List<Long> ruleIdList) {
        SecurityUser user = BaseSecurityUtil.getUser();
        Long userId = user.getUserId();
        List opportunityIdList = new ArrayList();
        List customerIdList = new ArrayList();
        List contactIdList = new ArrayList();
        List leadsIdList = new ArrayList();
        List agentIdList = new ArrayList();
        String opportunityStr = new String();
        String customerStr = new String();
        String contactStr = new String();
        String leadsStr = new String();
        String agentStr = new String();
        HashMap<String, String> map = new HashMap<String, String>();
        List list = this.listByIds(ruleIdList);
        for (DataMonitorRuleEntity dataMonitorRuleEntity : list) {
            map.put(dataMonitorRuleEntity.getTargetType(), "1");
        }
        if (ToolUtil.isNotEmpty(map.get("2")) && ((String)map.get("2")).equals("1") && ToolUtil.isNotEmpty(opportunityIdList = this.opportunityAPIService.getOpportunityIdList())) {
            opportunityStr = opportunityIdList.stream().map(Object::toString).collect(Collectors.joining(","));
        }
        if (ToolUtil.isNotEmpty(map.get("1")) && ((String)map.get("1")).equals("1") && ToolUtil.isNotEmpty(customerIdList = this.customerAPIService.getCustomerIdList())) {
            customerStr = customerIdList.stream().map(Object::toString).collect(Collectors.joining(","));
        }
        if (ToolUtil.isNotEmpty(map.get("3")) && ((String)map.get("3")).equals("1") && ToolUtil.isNotEmpty(contactIdList = this.contactAPIService.getContactIdList())) {
            contactStr = contactIdList.stream().map(Object::toString).collect(Collectors.joining(","));
        }
        if (ToolUtil.isNotEmpty(map.get("4")) && ((String)map.get("4")).equals("1") && ToolUtil.isNotEmpty(leadsIdList = this.leadsAPIService.getLeadsIdList())) {
            leadsStr = leadsIdList.stream().map(Object::toString).collect(Collectors.joining(","));
        }
        if (ToolUtil.isNotEmpty(map.get("17")) && ((String)map.get("17")).equals("1") && ToolUtil.isNotEmpty(agentIdList = this.agentApiService.getAgentIdList())) {
            agentStr = agentIdList.stream().map(Object::toString).collect(Collectors.joining(","));
        }
        ArrayList<DataMonitorRuleVo> ruleVoList = new ArrayList<DataMonitorRuleVo>();
        for (DataMonitorRuleEntity dataMonitorRuleEntity : list) {
            List dicSingleList = this.sysDicRefService.getDictByType("monitor_target_table");
            String tableName = ((DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(dataMonitorRuleEntity.getTargetType())).collect(Collectors.toList()).get(0)).getLabel();
            StringBuffer tableReferredName = this.getInitialLettersLowerCase(tableName);
            DataMonitorRuleVo dataMonitorRuleVo = (DataMonitorRuleVo)BeanUtil.copy((Object)dataMonitorRuleEntity, DataMonitorRuleVo.class);
            StringBuffer sql = new StringBuffer();
            sql.append(dataMonitorRuleVo.getRuleQuerySql());
            switch (dataMonitorRuleVo.getTargetType()) {
                case "2": {
                    if (!ToolUtil.isNotEmpty((Object)opportunityStr)) break;
                    sql.append(" AND (").append(tableReferredName).append(".").append("OPPORTUNITY_ID IN (").append(opportunityStr).append("))");
                    break;
                }
                case "1": {
                    if (!ToolUtil.isNotEmpty((Object)customerStr)) break;
                    sql.append(" AND (").append(tableReferredName).append(".").append("CUSTOMER_ID IN (").append(customerStr).append("))");
                    break;
                }
                case "3": {
                    if (!ToolUtil.isNotEmpty((Object)contactStr)) break;
                    sql.append(" AND (").append(tableReferredName).append(".").append("CONTACT_ID IN (").append(contactStr).append("))");
                    break;
                }
                case "4": {
                    if (!ToolUtil.isNotEmpty((Object)leadsStr)) break;
                    sql.append(" AND (").append(tableReferredName).append(".").append("LEADS_ID IN (").append(leadsStr).append("))");
                    break;
                }
                case "17": {
                    if (!ToolUtil.isNotEmpty((Object)agentStr)) break;
                    sql.append(" AND (").append(tableReferredName).append(".").append("AGENT_ID IN (").append(agentStr).append("))");
                    break;
                }
            }
            dataMonitorRuleVo.setRuleQuerySql(sql.toString());
            ruleVoList.add(dataMonitorRuleVo);
        }
        return ruleVoList;
    }

    private List<DataMonitorRuleVo> getExcludeIgnoreDataSQL(List<DataMonitorRuleVo> ruleVoList) {
        List dicSingleList = this.sysDicRefService.getDictByType("monitor_target_table");
        List dataMonitorIgnoreEntities = this.dataMonitorIgnoreService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DataMonitorIgnoreEntity::getDelFlag, (Object)"0")).in(DataMonitorIgnoreEntity::getRuleId, (Collection)ruleVoList.stream().map(DataMonitorRuleEntity::getRuleId).collect(Collectors.toList())));
        for (DataMonitorRuleVo dataMonitorRuleVo : ruleVoList) {
            List excludeDataList = dataMonitorIgnoreEntities.stream().filter(data -> data.getRuleId().equals(dataMonitorRuleVo.getRuleId())).collect(Collectors.toList());
            if (!ToolUtil.isNotEmpty(excludeDataList)) continue;
            String tableName = ((DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(dataMonitorRuleVo.getTargetType())).collect(Collectors.toList()).get(0)).getLabel();
            StringBuffer tableReferredName = this.getInitialLettersLowerCase(tableName);
            List businessIdList = excludeDataList.stream().map(DataMonitorIgnoreEntity::getBusinessId).collect(Collectors.toList());
            String excludeDataStr = businessIdList.stream().map(Object::toString).collect(Collectors.joining(","));
            StringBuffer sql = new StringBuffer();
            sql.append(dataMonitorRuleVo.getRuleQuerySql());
            switch (dataMonitorRuleVo.getTargetType()) {
                case "2": {
                    sql.append(" AND (").append(tableReferredName).append(".").append("OPPORTUNITY_ID NOT IN (").append(excludeDataStr).append("))");
                    break;
                }
                case "1": {
                    sql.append(" AND (").append(tableReferredName).append(".").append("CUSTOMER_ID NOT IN (").append(excludeDataStr).append("))");
                    break;
                }
                case "3": {
                    sql.append(" AND (").append(tableReferredName).append(".").append("CONTACT_ID NOT IN (").append(excludeDataStr).append("))");
                    break;
                }
                case "4": {
                    sql.append(" AND (").append(tableReferredName).append(".").append("LEADS_ID NOT IN (").append(excludeDataStr).append("))");
                    break;
                }
                case "17": {
                    sql.append(" AND (").append(tableReferredName).append(".").append("AGENT_ID NOT IN (").append(excludeDataStr).append("))");
                    break;
                }
            }
            dataMonitorRuleVo.setRuleQuerySql(sql.toString());
        }
        return ruleVoList;
    }

    private StringBuffer getQueryParamsSQL(DataMonitorRuleEntity dataMonitorRuleEntity, DataMonitorRuleDto dto) {
        List dicSingleList = this.sysDicRefService.getDictByType("monitor_target_table");
        String tableName = ((DicSingle)dicSingleList.stream().filter(dic -> dic.getValue().equals(dataMonitorRuleEntity.getTargetType())).collect(Collectors.toList()).get(0)).getLabel();
        StringBuffer tableReferredName = this.getInitialLettersLowerCase(tableName);
        StringBuffer mountedSQL = new StringBuffer("");
        if (ToolUtil.isNotEmpty((Object)dto.getSearchKey())) {
            mountedSQL.append("AND (");
            mountedSQL.append(tableReferredName).append(".").append("CHARGE_PERSON_NAME LIKE '%").append(dto.getSearchKey()).append("%'");
            mountedSQL.append(" OR ").append(tableReferredName).append(".").append("OWN_DEPARTMENT_NAME LIKE '%").append(dto.getSearchKey()).append("%'");
            switch (dataMonitorRuleEntity.getTargetType()) {
                case "2": {
                    mountedSQL.append(" OR ").append(tableReferredName).append(".").append("OPPORTUNITY_NAME LIKE '%").append(dto.getSearchKey()).append("%'");
                    break;
                }
                case "1": {
                    mountedSQL.append(" OR ").append(tableReferredName).append(".").append("CUSTOMER_NAME LIKE '%").append(dto.getSearchKey()).append("%'");
                    break;
                }
                case "3": {
                    mountedSQL.append(" OR ").append(tableReferredName).append(".").append("CONTACT_NAME LIKE '%").append(dto.getSearchKey()).append("%'");
                    break;
                }
                case "4": {
                    mountedSQL.append(" OR ").append(tableReferredName).append(".").append("LEADS_NAME LIKE '%").append(dto.getSearchKey()).append("%'");
                    break;
                }
                case "17": {
                    mountedSQL.append(" OR ").append(tableReferredName).append(".").append("AGENT_NAME LIKE '%").append(dto.getSearchKey()).append("%'");
                    break;
                }
            }
            mountedSQL.append(")");
        }
        if (ToolUtil.isNotEmpty((Object)dto.getOwnDepartments())) {
            mountedSQL.append(" AND (").append(tableReferredName).append(".").append("OWN_DEPARTMENT IN (").append(dto.getOwnDepartments()).append("))");
        }
        if (ToolUtil.isNotEmpty((Object)dto.getSearchNoStruFlag()) && dto.getSearchNoStruFlag().equals("1")) {
            mountedSQL.append(" AND (").append(tableReferredName).append(".").append("OWN_DEPARTMENT IS NULL)");
        }
        mountedSQL.append(" ORDER BY ").append(tableReferredName).append(".").append("CREATE_TIME DESC");
        return mountedSQL;
    }

    @Override
    public Boolean pushMonitorMessage(List<DataMonitorIgnoreDto> dtoList) {
        List messagePushVoList = this.messageTemplateService.getMessagePushList(dtoList.get(0).getRuleId().toString());
        ArrayList<Long> pushPersonList = new ArrayList<Long>();
        ArrayList<Long> deptList = new ArrayList<Long>();
        ArrayList<Long> roleList = new ArrayList<Long>();
        String chargePersonFlag = "0";
        String createPersonFlag = "0";
        String cooperatePersonFlag = "0";
        for (MessagePushVo vo : messagePushVoList) {
            switch (vo.getBusinessType()) {
                case "1": {
                    pushPersonList.add(Long.parseLong(vo.getBusinessId()));
                    break;
                }
                case "2": {
                    deptList.add(Long.parseLong(vo.getBusinessId()));
                    break;
                }
                case "3": {
                    roleList.add(Long.parseLong(vo.getBusinessId()));
                    break;
                }
                case "4": {
                    chargePersonFlag = "1";
                    break;
                }
                case "5": {
                    createPersonFlag = "1";
                    break;
                }
                case "6": {
                    cooperatePersonFlag = "1";
                    break;
                }
            }
        }
        if (ToolUtil.isNotEmpty(deptList)) {
            List userList = this.hussarBaseUserBoService.getStruUserByStruIds(deptList);
            pushPersonList.addAll(userList.stream().map(SysStruUser::getUserId).collect(Collectors.toList()));
        }
        if (ToolUtil.isNotEmpty(roleList)) {
            List userVoList = this.hussarBaseUserBoService.getUserInfoByRoleId(roleList);
            pushPersonList.addAll(userVoList.stream().map(UserVo::getId).collect(Collectors.toList()));
        }
        List<Long> businessIdList = dtoList.stream().map(DataMonitorIgnoreDto::getBusinessId).collect(Collectors.toList());
        if ("1".equals(chargePersonFlag)) {
            pushPersonList.addAll(this.dataMonitorRuleMapper.selectChargePerson(businessIdList));
        }
        if ("1".equals(createPersonFlag)) {
            pushPersonList.addAll(this.dataMonitorRuleMapper.selectCreatePerson(businessIdList));
        }
        if ("1".equals(cooperatePersonFlag)) {
            pushPersonList.addAll(this.dataMonitorRuleMapper.selectCooperatePerson(businessIdList));
        }
        HashSet set = new HashSet(pushPersonList);
        pushPersonList = new ArrayList(set);
        MessagePushVo pushToWeb = (MessagePushVo)messagePushVoList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("1")).collect(Collectors.toList()).get(0);
        MessagePushVo pushToMobile = (MessagePushVo)messagePushVoList.stream().filter(messagePushVo -> messagePushVo.getPushDirection().equals("2")).collect(Collectors.toList()).get(0);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("content", pushToWeb.getMessageContent());
        this.messagePushService.pushMessageByUser(pushToWeb, this.unifyProperties.getCrmUrl() + "/index", "/crm/sy/yddsy", LocalDateTime.now(), map, pushPersonList);
        map.put("content", pushToMobile.getMessageContent());
        map.put("title", pushToMobile.getMessageTitle());
        this.messagePushService.pushMessageByUser(pushToMobile, this.unifyProperties.getCrmUrl() + "/index", "/crm/sy/yddsy", LocalDateTime.now(), map, pushPersonList);
        return true;
    }
}

