/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.crm.analysis.intelligentanalysis.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.crm.analysis.common.CommonUtil;
import com.jxdinfo.crm.analysis.common.vo.RolePermissionsVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.dao.CustomerProfileAnalysisMapper;
import com.jxdinfo.crm.analysis.intelligentanalysis.dto.CustomerProfileAnalysisDto;
import com.jxdinfo.crm.analysis.intelligentanalysis.service.CustomerProfileAnalysisService;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerFromVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerLabelAnalysisVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerLabelVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerNatureAnalysisVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerProfileAnalysisColumnVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerProfileAnalysisVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerRankAnalysisVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerRegionAnalysisDetailsVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerRegionAnalysisVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerSourcesAnalysisVo;
import com.jxdinfo.crm.analysis.intelligentanalysis.vo.CustomerTransformAnalysisVo;
import com.jxdinfo.crm.common.api.baseconfig.service.ICrmBaseConfigBoService;
import com.jxdinfo.crm.common.api.baseconfig.service.IRegionBoService;
import com.jxdinfo.crm.common.api.baseconfig.vo.CrmBaseConfigVo;
import com.jxdinfo.crm.common.api.baseconfig.vo.SysRegionInformationVo;
import com.jxdinfo.crm.common.api.config.CrmCommonProperties;
import com.jxdinfo.crm.common.api.label.common.LabelModuleEnum;
import com.jxdinfo.crm.common.api.label.service.ILabelGroupService;
import com.jxdinfo.crm.common.api.label.service.ILabelService;
import com.jxdinfo.crm.common.api.label.vo.LabelGroupVo;
import com.jxdinfo.crm.common.api.label.vo.LabelVo;
import com.jxdinfo.crm.common.api.operaterecord.enums.RecordProductTypeEnum;
import com.jxdinfo.crm.common.api.trackrecord.enums.CrmBusinessTypeEnum;
import com.jxdinfo.crm.common.api.util.CrmDateUtils;
import com.jxdinfo.crm.common.api.util.entity.DateConvertVo;
import com.jxdinfo.crm.core.api.stageprocess.dto.StageTypeDto;
import com.jxdinfo.crm.core.api.stageprocess.service.IStageProcessApiService;
import com.jxdinfo.crm.core.customer.dto.CustomerDto;
import com.jxdinfo.crm.core.customer.model.CustomerEntity;
import com.jxdinfo.crm.core.customer.service.CustomerService;
import com.jxdinfo.crm.core.dataright.util.DataPermission;
import com.jxdinfo.crm.core.opportunity.model.OpportunityStage;
import com.jxdinfo.crm.core.opportunity.service.OpportunityStageService;
import com.jxdinfo.crm.core.utills.CommonUtills;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CustomerProfileAnalysisServiceImpl
implements CustomerProfileAnalysisService {
    @Resource
    private CustomerProfileAnalysisMapper profileAnalysisMapper;
    @Resource
    private CommonUtil commonUtil;
    @Resource
    private CustomerService customerService;
    @Resource
    private IRegionBoService regionBoService;
    @Resource
    private ILabelService labelService;
    @Resource
    private ILabelGroupService labelGroupService;
    @Resource
    private ICrmBaseConfigBoService crmBaseConfigBoService;
    @Resource
    private OpportunityStageService opportunityStageService;
    @Resource
    private CrmCommonProperties crmProperties;
    @Resource
    private CustomerProfileAnalysisMapper customerProfileAnalysisMapper;
    @Resource
    private IStageProcessApiService stageProcessApiService;

    private CustomerProfileAnalysisDto permissionMethod(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        DateConvertVo currentTime;
        SecurityUser user = BaseSecurityUtil.getUser();
        if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getAllCustomer()))) {
            customerProfileAnalysisDto.setPermissionDeptIds(null);
        } else {
            RolePermissionsVo rolePermissions = this.commonUtil.getRolePermissions();
            if (HussarUtils.isNotEmpty((Object)rolePermissions)) {
                customerProfileAnalysisDto.setPermissionDeptIds(rolePermissions.getPermissionDeptIds());
            }
            if (user.getRolesList().contains(Long.valueOf(this.crmProperties.getRoles().getMarketingManager()))) {
                customerProfileAnalysisDto.setCurrentDeptId(user.getDeptId());
            }
        }
        if (HussarUtils.isNotEmpty(customerProfileAnalysisDto.getDeptIds())) {
            List<Long> departments = customerProfileAnalysisDto.getDeptIds();
            ArrayList<Long> odpIds = new ArrayList<Long>();
            if (ToolUtil.isNotEmpty(departments) && !departments.isEmpty()) {
                for (Long odpId : departments) {
                    ArrayList Ids;
                    String odpIsTemp = CommonUtills.translateDepId((String)odpId.toString());
                    List idsTemp = CommonUtills.selectOpportunityTissueTreeUserId((String)odpIsTemp, Ids = new ArrayList());
                    if (idsTemp.isEmpty()) continue;
                    odpIds.addAll(idsTemp.stream().map(Long::parseLong).collect(Collectors.toList()));
                }
                customerProfileAnalysisDto.setDeptIds(odpIds);
            }
        }
        if (HussarUtils.isNotEmpty((Object)customerProfileAnalysisDto.getTimeRange()) && (currentTime = CrmDateUtils.getCurrentTime((String)customerProfileAnalysisDto.getTimeRange())) != null) {
            customerProfileAnalysisDto.setStartTime(LocalDate.parse(currentTime.getStartDate()));
            customerProfileAnalysisDto.setEndTime(LocalDate.parse(currentTime.getEndDate()));
        }
        customerProfileAnalysisDto.setCurrentUserId(user.getId());
        customerProfileAnalysisDto.setPermissionProductIds(DataPermission.getPermissionProduct((Long)user.getId()));
        StageTypeDto stageTypeDto = new StageTypeDto();
        stageTypeDto.setStageWin(true);
        List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
        customerProfileAnalysisDto.setWinStageIds(stageWin);
        return customerProfileAnalysisDto;
    }

    @Override
    public CustomerProfileAnalysisVo industryAnalysis(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        CustomerProfileAnalysisDto dto = this.permissionMethod(customerProfileAnalysisDto);
        dto.setModuleClassification("industry");
        List<CustomerProfileAnalysisColumnVo> customerProfileAnalysisVos = this.profileAnalysisMapper.industryAnalysis(dto);
        int tradedNumber = customerProfileAnalysisVos.stream().mapToInt(CustomerProfileAnalysisColumnVo::getTradedNumber).sum();
        int unsettledNumber = customerProfileAnalysisVos.stream().mapToInt(CustomerProfileAnalysisColumnVo::getUnsettledNumber).sum();
        CustomerProfileAnalysisVo customerProfileAnalysisVo = new CustomerProfileAnalysisVo();
        customerProfileAnalysisVo.setCustomerNumber(tradedNumber + unsettledNumber);
        customerProfileAnalysisVo.setTradedTotalNum(tradedNumber);
        customerProfileAnalysisVo.setUnsettledTotalNum(unsettledNumber);
        customerProfileAnalysisVo.setCustomerProfileAnalysisColumnVos(customerProfileAnalysisVos);
        return customerProfileAnalysisVo;
    }

    @Override
    public CustomerRegionAnalysisVo customerRegionAnalysis(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        CustomerProfileAnalysisDto dto = this.permissionMethod(customerProfileAnalysisDto);
        List<CustomerRegionAnalysisDetailsVo> regionAnalysisDetailsVos = this.profileAnalysisMapper.customerRegionAnalysis(dto);
        if (HussarUtils.isEmpty(regionAnalysisDetailsVos)) {
            return new CustomerRegionAnalysisVo();
        }
        List<String> transactionStatus = dto.getTransactionStatus();
        ArrayList<CustomerRegionAnalysisDetailsVo> provinceList = new ArrayList<CustomerRegionAnalysisDetailsVo>();
        Set<Object> tradeProvinceIds = new HashSet();
        List<Object> unsettledProvinceIds = new ArrayList();
        Set<Object> provinceIds = new HashSet();
        if (HussarUtils.isNotEmpty(transactionStatus) && transactionStatus.size() == 1 && transactionStatus.contains("1")) {
            provinceIds = regionAnalysisDetailsVos.stream().map(CustomerRegionAnalysisDetailsVo::getProvince).collect(Collectors.toSet());
            Set<Object> finalTradeProvinceIds = tradeProvinceIds = regionAnalysisDetailsVos.stream().filter(f -> f.getCustomerNum() > 0).map(CustomerRegionAnalysisDetailsVo::getProvince).collect(Collectors.toSet());
            unsettledProvinceIds = provinceIds.stream().filter(f -> !finalTradeProvinceIds.contains(f)).collect(Collectors.toList());
        } else if (HussarUtils.isNotEmpty(transactionStatus) && transactionStatus.size() == 1 && transactionStatus.contains("0")) {
            provinceIds = regionAnalysisDetailsVos.stream().map(CustomerRegionAnalysisDetailsVo::getProvince).collect(Collectors.toSet());
            unsettledProvinceIds = new ArrayList(regionAnalysisDetailsVos.stream().filter(f -> f.getCustomerNum() > 0).map(CustomerRegionAnalysisDetailsVo::getProvince).collect(Collectors.toSet()));
        } else if (HussarUtils.isEmpty(transactionStatus) || HussarUtils.isNotEmpty(transactionStatus) && transactionStatus.size() == 2 && transactionStatus.contains("0") && transactionStatus.contains("1")) {
            provinceIds = regionAnalysisDetailsVos.stream().map(CustomerRegionAnalysisDetailsVo::getProvince).collect(Collectors.toSet());
        }
        ArrayList<Object> statisticsProvince = new ArrayList();
        int provinceNumber = 0;
        if (HussarUtils.isNotEmpty(transactionStatus) && transactionStatus.size() == 1 && transactionStatus.contains("1")) {
            for (Integer n : tradeProvinceIds) {
                this.processRegionAnalysisDetails(Collections.singletonList(n), regionAnalysisDetailsVos, provinceList, customerProfileAnalysisDto);
            }
            provinceNumber = tradeProvinceIds.size();
            statisticsProvince = new ArrayList<Object>(tradeProvinceIds);
        } else if (HussarUtils.isNotEmpty(transactionStatus) && transactionStatus.size() == 1 && transactionStatus.contains("0")) {
            for (Integer n : unsettledProvinceIds) {
                this.processRegionAnalysisDetails(Collections.singletonList(n), regionAnalysisDetailsVos, provinceList, customerProfileAnalysisDto);
            }
            provinceNumber = unsettledProvinceIds.size();
            statisticsProvince = new ArrayList(unsettledProvinceIds);
        } else if (HussarUtils.isEmpty(transactionStatus) || HussarUtils.isNotEmpty(transactionStatus) && transactionStatus.size() == 2 && transactionStatus.contains("0") && transactionStatus.contains("1")) {
            this.processRegionAnalysisDetails(new ArrayList<Integer>(provinceIds), regionAnalysisDetailsVos, provinceList, customerProfileAnalysisDto);
            provinceNumber = provinceIds.size();
            statisticsProvince = new ArrayList<Object>(provinceIds);
        }
        ArrayList finalStatisticsProvince = statisticsProvince;
        List list = this.regionBoService.selectRegionListByLeve(Long.valueOf(0L), "1").stream().filter(f -> !finalStatisticsProvince.contains(Integer.parseInt(f.getRegionId().toString()))).collect(Collectors.toList());
        for (SysRegionInformationVo provinceVo : list) {
            CustomerRegionAnalysisDetailsVo customerRegionAnalysisDetailsVo = new CustomerRegionAnalysisDetailsVo();
            customerRegionAnalysisDetailsVo.setProvince(Integer.parseInt(provinceVo.getRegionId().toString()));
            customerRegionAnalysisDetailsVo.setProvinceName(provinceVo.getRegionName());
            customerRegionAnalysisDetailsVo.setCityNum(0);
            customerRegionAnalysisDetailsVo.setCustomerNum(0);
            provinceList.add(customerRegionAnalysisDetailsVo);
        }
        CustomerRegionAnalysisVo customerRegionAnalysisVo = new CustomerRegionAnalysisVo();
        customerRegionAnalysisVo.setProvinceNumber(provinceNumber);
        customerRegionAnalysisVo.setCityNumber(provinceList.stream().mapToInt(CustomerRegionAnalysisDetailsVo::getCityNum).sum());
        customerRegionAnalysisVo.setRegionAnalysisDetailsVos(provinceList);
        return customerRegionAnalysisVo;
    }

    private void processRegionAnalysisDetails(List<Integer> provinceIds, List<CustomerRegionAnalysisDetailsVo> regionAnalysisDetailsVos, List<CustomerRegionAnalysisDetailsVo> provinceList, CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        for (Integer provinceId : provinceIds) {
            List analysisDetailsVos = regionAnalysisDetailsVos.stream().filter(f -> Objects.equals(f.getProvince(), provinceId) && f.getCity() != null).collect(Collectors.toList());
            CustomerRegionAnalysisDetailsVo customerRegionAnalysisDetailsVo = new CustomerRegionAnalysisDetailsVo();
            customerRegionAnalysisDetailsVo.setProvince(provinceId);
            List<Object> regionLists = new ArrayList();
            List<String> transactionStatus = customerProfileAnalysisDto.getTransactionStatus();
            if (HussarUtils.isNotEmpty(transactionStatus) && transactionStatus.size() == 1 && transactionStatus.contains("0")) {
                regionLists = analysisDetailsVos.stream().filter(f -> f.getCustomerNum() == 0).collect(Collectors.toList());
            } else if (HussarUtils.isNotEmpty(transactionStatus) && transactionStatus.size() == 1 && transactionStatus.contains("1")) {
                regionLists = analysisDetailsVos.stream().filter(f -> f.getCustomerNum() > 0).collect(Collectors.toList());
            } else if (transactionStatus.isEmpty() || HussarUtils.isNotEmpty(transactionStatus) && transactionStatus.size() == 2 && transactionStatus.contains("0") && transactionStatus.contains("1")) {
                regionLists = analysisDetailsVos;
            }
            List provinceDetails = this.regionBoService.selectRegionListByLeve(Long.valueOf(0L), "1");
            SysRegionInformationVo provinceVo = (SysRegionInformationVo)provinceDetails.stream().filter(f -> f.getRegionId() == Long.parseLong(provinceId.toString())).collect(Collectors.toList()).get(0);
            customerRegionAnalysisDetailsVo.setProvinceName(provinceVo.getRegionName());
            customerRegionAnalysisDetailsVo.setCityNum(HussarUtils.isNotEmpty(regionLists) ? regionLists.size() : 0);
            List collect = regionAnalysisDetailsVos.stream().filter(f -> f.getProvince().equals(provinceId)).collect(Collectors.toList());
            Integer cusNum = collect.stream().mapToInt(CustomerRegionAnalysisDetailsVo::getCustomerNum).sum();
            customerRegionAnalysisDetailsVo.setCustomerNum(cusNum);
            provinceList.add(customerRegionAnalysisDetailsVo);
        }
    }

    @Override
    public List<CustomerNatureAnalysisVo> customerNatureAnalysis(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        CustomerProfileAnalysisDto dto = this.permissionMethod(customerProfileAnalysisDto);
        dto.setModuleClassification("customer_type");
        return this.profileAnalysisMapper.customerNatureAnalysis(dto);
    }

    @Override
    public List<CustomerLabelAnalysisVo> customerLabelAnalysis(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        Long groupId = customerProfileAnalysisDto.getLabelGroupId();
        List crmLabelVoList = this.labelService.listByGroupId(LabelModuleEnum.CUSTOMER.getModuleId(), groupId);
        List<Long> labelIdLists = crmLabelVoList.stream().map(LabelVo::getLabelId).collect(Collectors.toList());
        CustomerProfileAnalysisDto dto = this.permissionMethod(customerProfileAnalysisDto);
        List<CustomerLabelVo> labelIdList = this.profileAnalysisMapper.customerLabel(dto, labelIdLists);
        ArrayList<CustomerLabelAnalysisVo> customerLabelAnalysisVoList = new ArrayList<CustomerLabelAnalysisVo>();
        if (CollectionUtil.isNotEmpty((Collection)crmLabelVoList)) {
            for (LabelVo crmLabelVo : crmLabelVoList) {
                CustomerLabelAnalysisVo customerLabelAnalysisVo = new CustomerLabelAnalysisVo();
                String labelId = crmLabelVo.getLabelId().toString();
                customerLabelAnalysisVo.setLabelId(labelId);
                customerLabelAnalysisVo.setLabelName(crmLabelVo.getLabelName());
                int sum = labelIdList.stream().filter(f -> f.getLabelId().contains(labelId)).mapToInt(CustomerLabelVo::getCustomerNumber).sum();
                customerLabelAnalysisVo.setCustomerNumber(sum);
                customerLabelAnalysisVoList.add(customerLabelAnalysisVo);
            }
        }
        return customerLabelAnalysisVoList;
    }

    @Override
    public CustomerTransformAnalysisVo customerTransformAnalysis(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        CustomerProfileAnalysisDto dto = this.permissionMethod(customerProfileAnalysisDto);
        String businessType = CrmBusinessTypeEnum.CUSTOMER.getId();
        String produceType = RecordProductTypeEnum.PRODUCE_SYSTEM.getId();
        CrmBaseConfigVo crmBaseConfigVo = this.crmBaseConfigBoService.getCrmBaseConfigByKey("stage_config");
        if (ToolUtil.isNotEmpty((Object)crmBaseConfigVo)) {
            String configValue = crmBaseConfigVo.getConfigValue();
            List<String> configValues = Arrays.asList(configValue.split(","));
            List<Long> ongoingStageIds = configValues.stream().map(Long::valueOf).collect(Collectors.toList());
            dto.setOngoingStageIds(ongoingStageIds);
            List successStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
            dto.setSuccessStageIds(successStageIds);
        }
        return this.profileAnalysisMapper.customerTransformAnalysis(dto, businessType, produceType);
    }

    @Override
    public CustomerSourcesAnalysisVo customerSourceAnalysis(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        CustomerProfileAnalysisDto dto = this.permissionMethod(customerProfileAnalysisDto);
        dto.setModuleClassification("customer_source");
        List<CustomerFromVo> customerFromVos = this.profileAnalysisMapper.customerSourceAnalysis(dto);
        int sum = customerFromVos.stream().mapToInt(CustomerFromVo::getCustomerFromNumbers).sum();
        String customerSourceOnline = "5";
        Optional<Integer> networkSizeOptional = customerFromVos.stream().filter(f -> customerSourceOnline.equals(f.getCustomerFromId())).map(CustomerFromVo::getCustomerFromNumbers).findFirst();
        int networkSize = networkSizeOptional.orElse(0);
        CustomerSourcesAnalysisVo customerSourcesAnalysisVo = new CustomerSourcesAnalysisVo();
        customerSourcesAnalysisVo.setCustomerNumbers(sum);
        customerSourcesAnalysisVo.setNetworkPromotionNumbers(networkSize);
        customerSourcesAnalysisVo.setNonNetworkNumbers(sum - networkSize);
        customerSourcesAnalysisVo.setCustomerFromVos(customerFromVos);
        return customerSourcesAnalysisVo;
    }

    @Override
    public List<CustomerRankAnalysisVo> customerRankAnalysis(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        CustomerProfileAnalysisDto dto = this.permissionMethod(customerProfileAnalysisDto);
        dto.setModuleClassification("customer_level");
        return this.profileAnalysisMapper.customerRankAnalysis(dto);
    }

    @Override
    public Page<Map<String, Object>> profileAnalysisPopUp(CustomerDto dto) {
        Page customerPages = this.customerService.selectCustomerListForCustomerProfileAnalysis(dto);
        return this.characterConversion((Page<CustomerEntity>)customerPages);
    }

    @Override
    public Page<Map<String, Object>> followUpCustomersPopUp(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        CustomerProfileAnalysisDto dto = this.permissionMethod(customerProfileAnalysisDto);
        Page customerPages = dto.getPage();
        List successStageIds = this.opportunityStageService.listObjs((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{OpportunityStage::getCustomerStageId}).eq(OpportunityStage::getStageType, (Object)"20")).eq(OpportunityStage::getDelFlag, (Object)"0"), s -> Long.valueOf(s.toString()));
        dto.setSuccessStageIds(successStageIds);
        String businessType = CrmBusinessTypeEnum.CUSTOMER.getId();
        String produceSystemId = RecordProductTypeEnum.PRODUCE_SYSTEM.getId();
        List<CustomerEntity> customerEntityList = this.profileAnalysisMapper.followUpCustomersPopUp(customerPages, dto, businessType, produceSystemId);
        customerPages.setRecords(customerEntityList);
        return this.characterConversion((Page<CustomerEntity>)customerPages);
    }

    @Override
    public List<LabelGroupVo> getLabelGroupList(CustomerProfileAnalysisDto customerProfileAnalysisDto) {
        String keyword = customerProfileAnalysisDto.getCustomerScreening();
        return this.labelGroupService.getLabelGroupList(LabelModuleEnum.CUSTOMER.getModuleId(), keyword, "1");
    }

    private Page<Map<String, Object>> characterConversion(Page<CustomerEntity> customerPages) {
        ArrayList<Map> customerMap = new ArrayList<Map>();
        if (ToolUtil.isNotEmpty((Object)customerPages.getRecords())) {
            List records = customerPages.getRecords();
            List customerEntities = this.customerService.dictionaryTranslate(records);
            List<Long> customerIds = customerEntities.stream().map(CustomerEntity::getCustomerId).collect(Collectors.toList());
            SecurityUser user = BaseSecurityUtil.getUser();
            StageTypeDto stageTypeDto = new StageTypeDto();
            stageTypeDto.setStageWin(true);
            List stageWin = this.stageProcessApiService.getStageIdByType(stageTypeDto).getStageWin();
            String produceSystemId = RecordProductTypeEnum.PRODUCE_SYSTEM.getId();
            List<Map<String, Object>> customerState = this.profileAnalysisMapper.getCustomerDealState(user.getUserId(), customerIds, stageWin, produceSystemId);
            Map<Long, String> customerStateMap = customerState.stream().collect(Collectors.toMap(map -> (Long)map.get("customerId"), map -> map.get("dealState") != null ? map.get("dealState").toString() : ""));
            for (CustomerEntity customerEntity : customerEntities) {
                Map stringObjectMap = BeanUtil.beanToMap((Object)customerEntity);
                String state = customerStateMap.get(customerEntity.getCustomerId());
                stringObjectMap.put("dealState", state);
                customerMap.add(stringObjectMap);
            }
        }
        Page resultPage = new Page();
        BeanUtil.copyProperties(customerPages, (Object)resultPage);
        resultPage.setRecords(customerMap);
        return resultPage;
    }
}

